/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.command.lockcontroller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.form.IFormView;
import kd.epm.eb.spread.command.rangedefined.CellArea;
import kd.epm.eb.spread.command.style.AreasStyle;
import kd.epm.eb.spread.command.style.CellStyleInfo;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import kd.epm.eb.spread.template.spreadmanager.sheet.StyleCell;
import org.apache.commons.collections4.CollectionUtils;

public class SpreadLockContext {
    private boolean stopcommand = false;
    private IEbSpreadManager ebSpreadManager;
    private ITemplateModel templateModel;
    private List<AreasStyle> areasStyles = new ArrayList<AreasStyle>();
    private Map<String, Object> params = new HashMap<String, Object>(16);
    private Long processId;
    private String processType;
    private IFormView formView;
    private Map<Integer, Set<Integer>> lockCells = new HashMap<Integer, Set<Integer>>(16);
    private boolean isImportData = false;

    public boolean isImportData() {
        return this.isImportData;
    }

    public void setImportData(boolean importData) {
        this.isImportData = importData;
    }

    public Map<Integer, Set<Integer>> getLockCells() {
        return this.lockCells;
    }

    public SpreadLockContext setLockCells(Map<Integer, Set<Integer>> lockCells) {
        this.lockCells = lockCells;
        return this;
    }

    public Long getProcessId() {
        return this.processId;
    }

    public void setProcessId(Long processId) {
        this.processId = processId;
    }

    public String getProcessType() {
        return this.processType;
    }

    public void setProcessType(String processType) {
        this.processType = processType;
    }

    public SpreadLockContext(IEbSpreadManager ebSpreadManager, ITemplateModel templateModel) {
        this.ebSpreadManager = ebSpreadManager;
        this.templateModel = templateModel;
    }

    public boolean isStopcommand() {
        return this.stopcommand;
    }

    public void setStopcommand(boolean stopcommand) {
        this.stopcommand = stopcommand;
    }

    public IEbSpreadManager getEbSpreadManager() {
        return this.ebSpreadManager;
    }

    public void setEbSpreadManager(IEbSpreadManager ebSpreadManager) {
        this.ebSpreadManager = ebSpreadManager;
    }

    public ITemplateModel getTemplateModel() {
        return this.templateModel;
    }

    public void setTemplateModel(ITemplateModel templateModel) {
        this.templateModel = templateModel;
    }

    public List<AreasStyle> getAreasStyles() {
        return this.areasStyles;
    }

    public IFormView getFormView() {
        return this.formView;
    }

    public void setFormView(IFormView formView) {
        this.formView = formView;
    }

    public void lockAllData(String foreColor, String backColor) {
        if (backColor == null) {
            backColor = "#FFF8E1";
        }
        ISheet sheet = this.getEbSpreadManager().getEbook().getSheet(0);
        for (int row = sheet.getValueAreaRowStart(); row < sheet.getRealMaxRows(); ++row) {
            for (int col = sheet.getValueAreaColStart(); col < sheet.getRealMaxCols(); ++col) {
                StyleCell styleCell = (StyleCell)sheet.getECell(row, col);
                styleCell.setLocked(true);
                if (foreColor != null) {
                    styleCell.setForeColor(foreColor);
                }
                styleCell.setBackColor(backColor);
                Set cols = this.getLockCells().computeIfAbsent(row, t -> new HashSet(16));
                cols.add(col);
            }
        }
    }

    public AreasStyle getAreaStyle(String foreColor, String backColor) {
        if (backColor == null) {
            backColor = "#FFF8E1";
        }
        AreasStyle areasStyle = new AreasStyle();
        CellStyleInfo cellStyleInfo = new CellStyleInfo();
        cellStyleInfo.setBkc(backColor);
        if (foreColor != null) {
            cellStyleInfo.setFrc(foreColor);
        }
        cellStyleInfo.setL(true);
        areasStyle.setStyle(cellStyleInfo);
        areasStyle.setRange(new ArrayList<CellArea>());
        this.areasStyles.add(areasStyle);
        return areasStyle;
    }

    public void setLockCells(List<Integer[]> lockIndex) {
        if (CollectionUtils.isEmpty(lockIndex)) {
            return;
        }
        for (Integer[] index : lockIndex) {
            if (index == null || index.length != 2) continue;
            Integer rowIndex = index[0];
            Integer colIndex = index[1];
            Set colIndexs = this.lockCells.computeIfAbsent(rowIndex, t -> new HashSet(16));
            colIndexs.add(colIndex);
        }
    }

    public Map<String, Object> getParams() {
        return this.params;
    }

    public void setParams(Map<String, Object> params) {
        this.params = params;
    }

    public void lockAllData() {
        ISheet sheet = this.getEbSpreadManager().getEbook().getSheet(0);
        for (int row = sheet.getValueAreaRowStart(); row < sheet.getRealMaxRows(); ++row) {
            for (int col = sheet.getValueAreaColStart(); col < sheet.getRealMaxCols(); ++col) {
                StyleCell styleCell = (StyleCell)sheet.getECell(row, col);
                styleCell.setLocked(true);
                Set cols = this.getLockCells().computeIfAbsent(row, t -> new HashSet(16));
                cols.add(col);
            }
        }
    }
}

