/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.command.lockcontroller.lockcell;

import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.spread.command.lockcontroller.ISpreadLockControl;
import kd.epm.eb.spread.command.lockcontroller.SpreadLockContext;
import kd.epm.eb.spread.template.dimension.PageViewDimMember;
import kd.epm.eb.spread.template.spreadmanager.CellDimMember;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import kd.epm.eb.spread.template.spreadmanager.sheet.StyleCell;

public class ActualChangesLeafCellLockController
implements ISpreadLockControl {
    public static final String DARKCOLOR = "#E6E8EE";
    private static final String CHANGE_TYPE = SysDimensionEnum.ChangeType.getNumber();
    private static final String DATA_TYPE = SysDimensionEnum.DataType.getNumber();
    private static final String VERSION = SysDimensionEnum.Version.getNumber();
    private String dataTypeNumber;
    private String versionNumber;
    private static final Log log = LogFactory.getLog(ActualChangesLeafCellLockController.class);

    @Override
    public void control(SpreadLockContext styleControlContext) {
        if (this.checkChangeTypeMemberHasActualChangesLeaf(styleControlContext)) {
            Map<String, PageViewDimMember> pvDimMems = styleControlContext.getEbSpreadManager().getPageViewDims();
            PageViewDimMember pvDimChangType = pvDimMems.get(CHANGE_TYPE);
            PageViewDimMember pvDimDataType = pvDimMems.get(DATA_TYPE);
            PageViewDimMember pvDimVersion = pvDimMems.get(VERSION);
            if (pvDimChangType != null && pvDimDataType != null && pvDimVersion != null) {
                boolean actualFlag;
                String changTypeNumber = pvDimChangType.getNumber();
                String dataTypeNumber = pvDimDataType.getNumber();
                String versionNumber = pvDimVersion.getNumber();
                boolean bl = actualFlag = !"Actual".equals(dataTypeNumber) || !"ACTUAL".equals(versionNumber);
                if (this.checkMemberIsActualChangesLeaf(styleControlContext.getEbSpreadManager(), changTypeNumber) && actualFlag) {
                    styleControlContext.lockAllData(null, DARKCOLOR);
                    log.info("locked by ActualChangesLeafCellLockController 1");
                }
            } else if (pvDimChangType != null && pvDimDataType != null) {
                String changTypeNumber = pvDimChangType.getNumber();
                String dataTypeNumber = pvDimDataType.getNumber();
                if (this.checkMemberIsActualChangesLeaf(styleControlContext.getEbSpreadManager(), changTypeNumber)) {
                    if (!"Actual".equals(dataTypeNumber)) {
                        styleControlContext.lockAllData(null, DARKCOLOR);
                        log.info("locked by ActualChangesLeafCellLockController 2");
                    } else {
                        this.oneDimInRowColView(styleControlContext, VERSION);
                    }
                }
            } else if (pvDimChangType != null && pvDimVersion != null) {
                String changTypeNumber = pvDimChangType.getNumber();
                String versionNumber = pvDimVersion.getNumber();
                if (this.checkMemberIsActualChangesLeaf(styleControlContext.getEbSpreadManager(), changTypeNumber)) {
                    if (!"ACTUAL".equals(versionNumber)) {
                        styleControlContext.lockAllData(null, DARKCOLOR);
                        log.info("locked by ActualChangesLeafCellLockController 3");
                    } else {
                        this.oneDimInRowColView(styleControlContext, DATA_TYPE);
                    }
                }
            } else if (pvDimChangType != null) {
                String changTypeNumber = pvDimChangType.getNumber();
                if (this.checkMemberIsActualChangesLeaf(styleControlContext.getEbSpreadManager(), changTypeNumber)) {
                    this.twoDimInRowColViewByDataTypeAndVersion(styleControlContext);
                }
            } else if (pvDimDataType != null && pvDimVersion != null) {
                this.dataTypeNumber = pvDimDataType.getNumber();
                this.versionNumber = pvDimVersion.getNumber();
                this.oneDimInRowColView(styleControlContext, CHANGE_TYPE);
            } else if (pvDimDataType != null) {
                this.dataTypeNumber = pvDimDataType.getNumber();
                this.twoDimInRowColViewByChangeTypeAndVersion(styleControlContext);
            } else if (pvDimVersion != null) {
                this.versionNumber = pvDimVersion.getNumber();
                this.twoDimInRowColViewByChangeTypeAndDataType(styleControlContext);
            } else {
                this.threeDimInRowColView(styleControlContext);
            }
        }
    }

    private boolean checkChangeTypeMemberHasActualChangesLeaf(SpreadLockContext styleControlContext) {
        if (styleControlContext == null || styleControlContext.getEbSpreadManager() == null) {
            return false;
        }
        Set<String> changeTypeMems = styleControlContext.getEbSpreadManager().getAlldimensionWithMembers().get(CHANGE_TYPE);
        if (changeTypeMems != null) {
            IEbSpreadManager ebSpreadManager = styleControlContext.getEbSpreadManager();
            for (String member : changeTypeMems) {
                if (!this.checkMemberIsActualChangesLeaf(ebSpreadManager, member)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMemberIsActualChangesLeaf(IEbSpreadManager ebSpreadManager, String changeTypeMemberNumber) {
        List leafMemberNumbers;
        if (ebSpreadManager.getModelobj() == null || StringUtils.isEmpty((String)changeTypeMemberNumber)) {
            return false;
        }
        Long modelId = ebSpreadManager.getModelobj().getId();
        IModelCacheHelper modelCacheHelper = ebSpreadManager.getModelCacheHelper();
        if (modelCacheHelper == null) {
            modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        }
        Long viewId = ebSpreadManager.getDimemsionViews().get(SysDimensionEnum.ChangeType.getNumber());
        Member member = modelCacheHelper.getMember(SysDimensionEnum.ChangeType.getNumber(), viewId, "ActualChanges");
        return member != null && CommonUtils.hasBusinessModel((Long)modelId) != false && StringUtils.isNotEmpty((String)changeTypeMemberNumber) && (leafMemberNumbers = member.getLeaf().stream().map(BaseCache::getNumber).collect(Collectors.toList())).contains(changeTypeMemberNumber);
    }

    private void oneDimInRowColView(SpreadLockContext styleControlContext, String rowColDimNumber) {
        if (styleControlContext == null) {
            return;
        }
        boolean isDataType = rowColDimNumber.equals(DATA_TYPE);
        boolean isVersion = rowColDimNumber.equals(VERSION);
        boolean isChangType = rowColDimNumber.equals(CHANGE_TYPE);
        if (!(isDataType || isVersion || isChangType)) {
            return;
        }
        IEbSpreadManager spreadManager = styleControlContext.getEbSpreadManager();
        boolean isInRow = spreadManager.getRowpartitionDims().contains(rowColDimNumber);
        List<String> dimNumbers = isInRow ? spreadManager.getRowpartitionDims() : spreadManager.getColpartitionDims();
        List<List<CellDimMember>> rowColDimMems = isInRow ? spreadManager.getRowpartitionDimMems() : spreadManager.getColpartitionDimMems();
        ISheet sheet = spreadManager.getEbook().getSheet(0);
        for (int rowcol = 0; rowcol < rowColDimMems.size(); ++rowcol) {
            Set cols;
            StyleCell styleCell;
            List<CellDimMember> cellDimMembers = rowColDimMems.get(rowcol);
            if (cellDimMembers == null || cellDimMembers.size() == 0) continue;
            boolean lock = false;
            int i = 0;
            for (CellDimMember cellDimMember : cellDimMembers) {
                if (cellDimMember == null) continue;
                String dimNumber = dimNumbers.get(i);
                String dimMemberNumber = cellDimMember.getDimMemberNumber();
                ++i;
                if (!rowColDimNumber.equals(dimNumber)) continue;
                if (isDataType && !"Actual".equals(dimMemberNumber)) {
                    lock = true;
                    break;
                }
                if (isVersion && !"ACTUAL".equals(dimMemberNumber)) {
                    lock = true;
                    break;
                }
                if (!isChangType || !this.checkMemberIsActualChangesLeaf(spreadManager, dimMemberNumber) || "Actual".equals(this.dataTypeNumber) && "ACTUAL".equals(this.versionNumber)) continue;
                lock = true;
                break;
            }
            if (!lock) continue;
            if (isInRow) {
                log.info("locked_by_ActualChangesLeafCellLockController_oneDimInRowColView_isInRow_rowcol=" + rowcol);
                for (int col = sheet.getValueAreaColStart(); col < sheet.getRealMaxCols(); ++col) {
                    styleCell = (StyleCell)sheet.getECell(rowcol, col);
                    styleCell.setLocked(true);
                    styleCell.setBackColor("#FFF8E1");
                    cols = styleControlContext.getLockCells().computeIfAbsent(rowcol, t -> new HashSet(16));
                    cols.add(col);
                }
                continue;
            }
            log.info("locked_by_ActualChangesLeafCellLockController_oneDimInRowColView_isInCol_rowcol=" + rowcol);
            for (int row = sheet.getValueAreaRowStart(); row < sheet.getRealMaxRows(); ++row) {
                styleCell = (StyleCell)sheet.getECell(row, rowcol);
                styleCell.setLocked(true);
                styleCell.setBackColor("#FFF8E1");
                cols = styleControlContext.getLockCells().computeIfAbsent(row, t -> new HashSet(16));
                cols.add(rowcol);
            }
        }
    }

    private void twoDimInRowColViewByDataTypeAndVersion(SpreadLockContext styleControlContext) {
        block14: {
            boolean isDataTypeInCol;
            ISheet sheet;
            IEbSpreadManager spreadManager;
            block16: {
                boolean isDataTypeInRow;
                block15: {
                    boolean isVersionInCol;
                    block13: {
                        if (styleControlContext == null) {
                            return;
                        }
                        spreadManager = styleControlContext.getEbSpreadManager();
                        sheet = spreadManager.getEbook().getSheet(0);
                        isDataTypeInRow = spreadManager.getRowpartitionDims().contains(DATA_TYPE);
                        isDataTypeInCol = spreadManager.getColpartitionDims().contains(DATA_TYPE);
                        boolean isVersionInRow = spreadManager.getRowpartitionDims().contains(VERSION);
                        isVersionInCol = spreadManager.getColpartitionDims().contains(VERSION);
                        if (!isDataTypeInRow || !isVersionInRow) break block13;
                        for (int row = 0; row < spreadManager.getRowpartitionDimMems().size(); ++row) {
                            List<CellDimMember> cellDimMembers = spreadManager.getRowpartitionDimMems().get(row);
                            if (cellDimMembers == null || cellDimMembers.size() == 0) continue;
                            boolean lock = false;
                            int i = 0;
                            for (CellDimMember cellDimMember : cellDimMembers) {
                                if (cellDimMember == null) continue;
                                String dimNumber = spreadManager.getRowpartitionDims().get(i);
                                String dimMemberNumber = cellDimMember.getDimMemberNumber();
                                ++i;
                                if (DATA_TYPE.equals(dimNumber) && !"Actual".equals(dimMemberNumber)) {
                                    lock = true;
                                    break;
                                }
                                if (!VERSION.equals(dimNumber) || "ACTUAL".equals(dimMemberNumber)) continue;
                                lock = true;
                                break;
                            }
                            if (!lock) continue;
                            log.info("locked_by_ActualChangesLeafCellLockController_twoDimInRowColViewByDataTypeAndVersion_isDataTypeInRow&&isVersionInRow_row=" + row);
                            for (int col = sheet.getValueAreaColStart(); col < sheet.getRealMaxCols(); ++col) {
                                StyleCell styleCell = (StyleCell)sheet.getECell(row, col);
                                styleCell.setLocked(true);
                                styleCell.setBackColor("#FFF8E1");
                                Set cols = styleControlContext.getLockCells().computeIfAbsent(row, t -> new HashSet(16));
                                cols.add(col);
                            }
                        }
                        break block14;
                    }
                    if (!isDataTypeInCol || !isVersionInCol) break block15;
                    for (int col = 0; col < spreadManager.getColpartitionDimMems().size(); ++col) {
                        List<CellDimMember> cellDimMembers = spreadManager.getColpartitionDimMems().get(col);
                        if (cellDimMembers == null || cellDimMembers.size() == 0) continue;
                        boolean lock = false;
                        int i = 0;
                        for (CellDimMember cellDimMember : cellDimMembers) {
                            if (cellDimMember == null) continue;
                            String dimNumber = spreadManager.getColpartitionDims().get(i);
                            String dimMemberNumber = cellDimMember.getDimMemberNumber();
                            ++i;
                            if (DATA_TYPE.equals(dimNumber) && !"Actual".equals(dimMemberNumber)) {
                                lock = true;
                                break;
                            }
                            if (!VERSION.equals(dimNumber) || "ACTUAL".equals(dimMemberNumber)) continue;
                            lock = true;
                            break;
                        }
                        if (!lock) continue;
                        log.info("locked_by_ActualChangesLeafCellLockController_twoDimInRowColViewByDataTypeAndVersion_isDataTypeInCol&&isVersionInCol_col=" + col);
                        for (int row = sheet.getValueAreaRowStart(); row < sheet.getRealMaxRows(); ++row) {
                            StyleCell styleCell = (StyleCell)sheet.getECell(row, col);
                            styleCell.setLocked(true);
                            styleCell.setBackColor("#FFF8E1");
                            Set cols = styleControlContext.getLockCells().computeIfAbsent(row, t -> new HashSet(16));
                            cols.add(col);
                        }
                    }
                    break block14;
                }
                if (!isDataTypeInRow) break block16;
                int dtIndex = spreadManager.getRowpartitionDims().indexOf(DATA_TYPE);
                int versionIndex = spreadManager.getColpartitionDims().indexOf(VERSION);
                for (int row = 0; row < spreadManager.getRowpartitionDimMems().size(); ++row) {
                    CellDimMember dtCellDimMember;
                    List<CellDimMember> rowCellDimMembers = spreadManager.getRowpartitionDimMems().get(row);
                    if (rowCellDimMembers == null || rowCellDimMembers.size() < dtIndex || (dtCellDimMember = rowCellDimMembers.get(dtIndex)) == null) continue;
                    for (int col = 0; col < spreadManager.getColpartitionDimMems().size(); ++col) {
                        CellDimMember versionCellDimMem;
                        List<CellDimMember> colCellDimMembers = spreadManager.getColpartitionDimMems().get(col);
                        if (colCellDimMembers == null || colCellDimMembers.size() < versionIndex || (versionCellDimMem = colCellDimMembers.get(versionIndex)) == null || "Actual".equals(dtCellDimMember.getDimMemberNumber()) && "ACTUAL".equals(versionCellDimMem.getDimMemberNumber())) continue;
                        StyleCell styleCell = (StyleCell)sheet.getECell(row, col);
                        styleCell.setLocked(true);
                        styleCell.setBackColor("#FFF8E1");
                        Set cols = styleControlContext.getLockCells().computeIfAbsent(row, t -> new HashSet(16));
                        cols.add(col);
                    }
                }
                break block14;
            }
            if (!isDataTypeInCol) break block14;
            int dtIndex = spreadManager.getColpartitionDims().indexOf(DATA_TYPE);
            int versionIndex = spreadManager.getRowpartitionDims().indexOf(VERSION);
            for (int col = 0; col < spreadManager.getColpartitionDimMems().size(); ++col) {
                CellDimMember dtCellDimMember;
                List<CellDimMember> colCellDimMembers = spreadManager.getColpartitionDimMems().get(col);
                if (colCellDimMembers == null || colCellDimMembers.size() < dtIndex || (dtCellDimMember = colCellDimMembers.get(dtIndex)) == null) continue;
                for (int row = 0; row < spreadManager.getRowpartitionDimMems().size(); ++row) {
                    CellDimMember versionCellDimMem;
                    List<CellDimMember> rowCellDimMembers = spreadManager.getRowpartitionDimMems().get(row);
                    if (rowCellDimMembers == null || rowCellDimMembers.size() < versionIndex || (versionCellDimMem = rowCellDimMembers.get(versionIndex)) == null || "Actual".equals(dtCellDimMember.getDimMemberNumber()) && "ACTUAL".equals(versionCellDimMem.getDimMemberNumber())) continue;
                    StyleCell styleCell = (StyleCell)sheet.getECell(row, col);
                    styleCell.setLocked(true);
                    styleCell.setBackColor("#FFF8E1");
                    Set cols = styleControlContext.getLockCells().computeIfAbsent(row, t -> new HashSet(16));
                    cols.add(col);
                }
            }
        }
    }

    private void twoDimInRowColViewByChangeTypeAndVersion(SpreadLockContext styleControlContext) {
        block16: {
            boolean isChangeTypeInCol;
            ISheet sheet;
            IEbSpreadManager spreadManager;
            block18: {
                boolean isChangeTypeInRow;
                block17: {
                    boolean isVersionInCol;
                    block15: {
                        if (styleControlContext == null) {
                            return;
                        }
                        spreadManager = styleControlContext.getEbSpreadManager();
                        sheet = spreadManager.getEbook().getSheet(0);
                        isChangeTypeInRow = spreadManager.getRowpartitionDims().contains(CHANGE_TYPE);
                        isChangeTypeInCol = spreadManager.getColpartitionDims().contains(CHANGE_TYPE);
                        boolean isVersionInRow = spreadManager.getRowpartitionDims().contains(VERSION);
                        isVersionInCol = spreadManager.getColpartitionDims().contains(VERSION);
                        if (!isChangeTypeInRow || !isVersionInRow) break block15;
                        for (int row = 0; row < spreadManager.getRowpartitionDimMems().size(); ++row) {
                            boolean actualChangesFlag;
                            List<CellDimMember> cellDimMembers = spreadManager.getRowpartitionDimMems().get(row);
                            if (cellDimMembers == null || cellDimMembers.size() == 0) continue;
                            boolean lock = false;
                            int i = 0;
                            String changeTypeMemNum = "";
                            String versionMemNum = "";
                            for (CellDimMember cellDimMember : cellDimMembers) {
                                if (cellDimMember == null) continue;
                                String dimNumber = spreadManager.getRowpartitionDims().get(i);
                                String dimMemberNumber = cellDimMember.getDimMemberNumber();
                                ++i;
                                if (CHANGE_TYPE.equals(dimNumber)) {
                                    changeTypeMemNum = dimMemberNumber;
                                }
                                if (!VERSION.equals(dimNumber)) continue;
                                versionMemNum = dimMemberNumber;
                            }
                            boolean bl = actualChangesFlag = !"Actual".equals(this.dataTypeNumber) || !"ACTUAL".equals(versionMemNum);
                            if (this.checkMemberIsActualChangesLeaf(spreadManager, changeTypeMemNum) && actualChangesFlag) {
                                lock = true;
                            }
                            if (!lock) continue;
                            log.info("locked_by_ActualChangesLeafCellLockController_twoDimInRowColViewByChangeTypeAndVersion_isChangeTypeInRow&&isVersionInRow:" + changeTypeMemNum + "_" + versionMemNum + "_" + this.dataTypeNumber + "_row=" + row);
                            for (int col = sheet.getValueAreaColStart(); col < sheet.getRealMaxCols(); ++col) {
                                StyleCell styleCell = (StyleCell)sheet.getECell(row, col);
                                styleCell.setLocked(true);
                                styleCell.setBackColor("#FFF8E1");
                                Set cols = styleControlContext.getLockCells().computeIfAbsent(row, t -> new HashSet(16));
                                cols.add(col);
                            }
                        }
                        break block16;
                    }
                    if (!isChangeTypeInCol || !isVersionInCol) break block17;
                    for (int col = 0; col < spreadManager.getColpartitionDimMems().size(); ++col) {
                        boolean actualChangesFlag;
                        List<CellDimMember> cellDimMembers = spreadManager.getColpartitionDimMems().get(col);
                        if (cellDimMembers == null || cellDimMembers.size() == 0) continue;
                        boolean lock = false;
                        int i = 0;
                        String changeTypeMemNum = "";
                        String versionTypeMemNum = "";
                        for (CellDimMember cellDimMember : cellDimMembers) {
                            if (cellDimMember == null) continue;
                            String dimNumber = spreadManager.getColpartitionDims().get(i);
                            String dimMemberNumber = cellDimMember.getDimMemberNumber();
                            ++i;
                            if (CHANGE_TYPE.equals(dimNumber)) {
                                changeTypeMemNum = dimMemberNumber;
                            }
                            if (!VERSION.equals(dimNumber)) continue;
                            versionTypeMemNum = dimMemberNumber;
                        }
                        boolean bl = actualChangesFlag = !"Actual".equals(this.dataTypeNumber) || !"ACTUAL".equals(versionTypeMemNum);
                        if (this.checkMemberIsActualChangesLeaf(spreadManager, changeTypeMemNum) && actualChangesFlag) {
                            lock = true;
                        }
                        if (!lock) continue;
                        log.info("locked_by_ActualChangesLeafCellLockController_twoDimInRowColViewByChangeTypeAndVersion_isChangeTypeInCol&&isVersionInCol:" + changeTypeMemNum + "_" + versionTypeMemNum + "_" + this.dataTypeNumber + "_col=" + col);
                        for (int row = sheet.getValueAreaRowStart(); row < sheet.getRealMaxRows(); ++row) {
                            StyleCell styleCell = (StyleCell)sheet.getECell(row, col);
                            styleCell.setLocked(true);
                            styleCell.setBackColor("#FFF8E1");
                            Set cols = styleControlContext.getLockCells().computeIfAbsent(row, t -> new HashSet(16));
                            cols.add(col);
                        }
                    }
                    break block16;
                }
                if (!isChangeTypeInRow) break block18;
                int ctIndex = spreadManager.getRowpartitionDims().indexOf(CHANGE_TYPE);
                int versionIndex = spreadManager.getColpartitionDims().indexOf(VERSION);
                for (int row = 0; row < spreadManager.getRowpartitionDimMems().size(); ++row) {
                    CellDimMember ctCellDimMember;
                    List<CellDimMember> rowCellDimMembers = spreadManager.getRowpartitionDimMems().get(row);
                    if (rowCellDimMembers == null || rowCellDimMembers.size() < ctIndex || (ctCellDimMember = rowCellDimMembers.get(ctIndex)) == null) continue;
                    for (int col = 0; col < spreadManager.getColpartitionDimMems().size(); ++col) {
                        boolean actualChangesFlag;
                        CellDimMember versionCellDimMem;
                        List<CellDimMember> colCellDimMembers = spreadManager.getColpartitionDimMems().get(col);
                        if (colCellDimMembers == null || colCellDimMembers.size() < versionIndex || (versionCellDimMem = colCellDimMembers.get(versionIndex)) == null) continue;
                        boolean bl = actualChangesFlag = !"ACTUAL".equals(versionCellDimMem.getDimMemberNumber()) || !"Actual".equals(this.dataTypeNumber);
                        if (!this.checkMemberIsActualChangesLeaf(spreadManager, ctCellDimMember.getDimMemberNumber()) || !actualChangesFlag) continue;
                        StyleCell styleCell = (StyleCell)sheet.getECell(row, col);
                        styleCell.setLocked(true);
                        styleCell.setBackColor("#FFF8E1");
                        Set cols = styleControlContext.getLockCells().computeIfAbsent(row, t -> new HashSet(16));
                        cols.add(col);
                    }
                }
                break block16;
            }
            if (!isChangeTypeInCol) break block16;
            int ctIndex = spreadManager.getColpartitionDims().indexOf(CHANGE_TYPE);
            int versionIndex = spreadManager.getRowpartitionDims().indexOf(VERSION);
            for (int col = 0; col < spreadManager.getColpartitionDimMems().size(); ++col) {
                CellDimMember ctCellDimMember;
                List<CellDimMember> colCellDimMembers = spreadManager.getColpartitionDimMems().get(col);
                if (colCellDimMembers == null || colCellDimMembers.size() < ctIndex || (ctCellDimMember = colCellDimMembers.get(ctIndex)) == null) continue;
                for (int row = 0; row < spreadManager.getRowpartitionDimMems().size(); ++row) {
                    boolean actualChangesFlag;
                    CellDimMember versionCellDimMem;
                    List<CellDimMember> rowCellDimMembers = spreadManager.getRowpartitionDimMems().get(row);
                    if (rowCellDimMembers == null || rowCellDimMembers.size() < versionIndex || (versionCellDimMem = rowCellDimMembers.get(versionIndex)) == null) continue;
                    boolean bl = actualChangesFlag = !"ACTUAL".equals(versionCellDimMem.getDimMemberNumber()) || !"Actual".equals(this.dataTypeNumber);
                    if (!this.checkMemberIsActualChangesLeaf(spreadManager, ctCellDimMember.getDimMemberNumber()) || !actualChangesFlag) continue;
                    StyleCell styleCell = (StyleCell)sheet.getECell(row, col);
                    styleCell.setLocked(true);
                    styleCell.setBackColor("#FFF8E1");
                    Set cols = styleControlContext.getLockCells().computeIfAbsent(row, t -> new HashSet(16));
                    cols.add(col);
                }
            }
        }
    }

    private void twoDimInRowColViewByChangeTypeAndDataType(SpreadLockContext styleControlContext) {
        block16: {
            boolean isChangeTypeInCol;
            ISheet sheet;
            IEbSpreadManager spreadManager;
            block18: {
                boolean isChangeTypeInRow;
                block17: {
                    boolean isDataTypeInCol;
                    block15: {
                        if (styleControlContext == null) {
                            return;
                        }
                        spreadManager = styleControlContext.getEbSpreadManager();
                        sheet = spreadManager.getEbook().getSheet(0);
                        isChangeTypeInRow = spreadManager.getRowpartitionDims().contains(CHANGE_TYPE);
                        isChangeTypeInCol = spreadManager.getColpartitionDims().contains(CHANGE_TYPE);
                        boolean isDataTypeInRow = spreadManager.getRowpartitionDims().contains(DATA_TYPE);
                        isDataTypeInCol = spreadManager.getColpartitionDims().contains(DATA_TYPE);
                        if (!isChangeTypeInRow || !isDataTypeInRow) break block15;
                        for (int row = 0; row < spreadManager.getRowpartitionDimMems().size(); ++row) {
                            boolean actualChangesFlag;
                            List<CellDimMember> cellDimMembers = spreadManager.getRowpartitionDimMems().get(row);
                            if (cellDimMembers == null || cellDimMembers.size() == 0) continue;
                            boolean lock = false;
                            int i = 0;
                            String changeTypeMemNum = "";
                            String dataTypeMemNum = "";
                            for (CellDimMember cellDimMember : cellDimMembers) {
                                if (cellDimMember == null) continue;
                                String dimNumber = spreadManager.getRowpartitionDims().get(i);
                                String dimMemberNumber = cellDimMember.getDimMemberNumber();
                                ++i;
                                if (CHANGE_TYPE.equals(dimNumber)) {
                                    changeTypeMemNum = dimMemberNumber;
                                }
                                if (!DATA_TYPE.equals(dimNumber)) continue;
                                dataTypeMemNum = dimMemberNumber;
                            }
                            boolean bl = actualChangesFlag = !"Actual".equals(dataTypeMemNum) || !"ACTUAL".equals(this.versionNumber);
                            if (this.checkMemberIsActualChangesLeaf(spreadManager, changeTypeMemNum) && actualChangesFlag) {
                                lock = true;
                            }
                            if (!lock) continue;
                            log.info("locked_by_ActualChangesLeafCellLockController_twoDimInRowColViewByChangeTypeAndDataType_isChangeTypeInRow&&isDataTypeInRow:" + changeTypeMemNum + "_" + dataTypeMemNum + "_" + this.versionNumber + "_row=" + row);
                            for (int col = sheet.getValueAreaColStart(); col < sheet.getRealMaxCols(); ++col) {
                                StyleCell styleCell = (StyleCell)sheet.getECell(row, col);
                                styleCell.setLocked(true);
                                styleCell.setBackColor("#FFF8E1");
                                Set cols = styleControlContext.getLockCells().computeIfAbsent(row, t -> new HashSet(16));
                                cols.add(col);
                            }
                        }
                        break block16;
                    }
                    if (!isChangeTypeInCol || !isDataTypeInCol) break block17;
                    for (int col = 0; col < spreadManager.getColpartitionDimMems().size(); ++col) {
                        boolean actualChangesFlag;
                        List<CellDimMember> cellDimMembers = spreadManager.getColpartitionDimMems().get(col);
                        if (cellDimMembers == null || cellDimMembers.size() == 0) continue;
                        boolean lock = false;
                        int i = 0;
                        String changeTypeMemNum = "";
                        String dataTypeMemNum = "";
                        for (CellDimMember cellDimMember : cellDimMembers) {
                            if (cellDimMember == null) continue;
                            String dimNumber = spreadManager.getColpartitionDims().get(i);
                            String dimMemberNumber = cellDimMember.getDimMemberNumber();
                            ++i;
                            if (CHANGE_TYPE.equals(dimNumber)) {
                                changeTypeMemNum = dimMemberNumber;
                            }
                            if (!DATA_TYPE.equals(dimNumber)) continue;
                            dataTypeMemNum = dimMemberNumber;
                        }
                        boolean bl = actualChangesFlag = !"Actual".equals(dataTypeMemNum) || !"ACTUAL".equals(this.versionNumber);
                        if (this.checkMemberIsActualChangesLeaf(spreadManager, changeTypeMemNum) && actualChangesFlag) {
                            lock = true;
                        }
                        if (!lock) continue;
                        log.info("locked_by_ActualChangesLeafCellLockController_twoDimInRowColViewByChangeTypeAndDataType_isChangeTypeInCol&&isDataTypeInCol:" + changeTypeMemNum + "_" + dataTypeMemNum + "_" + this.versionNumber + "_col=" + col);
                        for (int row = sheet.getValueAreaRowStart(); row < sheet.getRealMaxRows(); ++row) {
                            StyleCell styleCell = (StyleCell)sheet.getECell(row, col);
                            styleCell.setLocked(true);
                            styleCell.setBackColor("#FFF8E1");
                            Set cols = styleControlContext.getLockCells().computeIfAbsent(row, t -> new HashSet(16));
                            cols.add(col);
                        }
                    }
                    break block16;
                }
                if (!isChangeTypeInRow) break block18;
                int ctIndex = spreadManager.getRowpartitionDims().indexOf(CHANGE_TYPE);
                int dtIndex = spreadManager.getColpartitionDims().indexOf(DATA_TYPE);
                for (int row = 0; row < spreadManager.getRowpartitionDimMems().size(); ++row) {
                    CellDimMember ctCellDimMember;
                    List<CellDimMember> rowCellDimMembers = spreadManager.getRowpartitionDimMems().get(row);
                    if (rowCellDimMembers == null || rowCellDimMembers.size() < ctIndex || (ctCellDimMember = rowCellDimMembers.get(ctIndex)) == null) continue;
                    for (int col = 0; col < spreadManager.getColpartitionDimMems().size(); ++col) {
                        boolean actualChangesFlag;
                        CellDimMember dtCellDimMem;
                        List<CellDimMember> colCellDimMembers = spreadManager.getColpartitionDimMems().get(col);
                        if (colCellDimMembers == null || colCellDimMembers.size() < dtIndex || (dtCellDimMem = colCellDimMembers.get(dtIndex)) == null) continue;
                        boolean bl = actualChangesFlag = !"ACTUAL".equals(this.versionNumber) || !"Actual".equals(dtCellDimMem.getDimMemberNumber());
                        if (!this.checkMemberIsActualChangesLeaf(spreadManager, ctCellDimMember.getDimMemberNumber()) || !actualChangesFlag) continue;
                        StyleCell styleCell = (StyleCell)sheet.getECell(row, col);
                        styleCell.setLocked(true);
                        styleCell.setBackColor("#FFF8E1");
                        Set cols = styleControlContext.getLockCells().computeIfAbsent(row, t -> new HashSet(16));
                        cols.add(col);
                    }
                }
                break block16;
            }
            if (!isChangeTypeInCol) break block16;
            int ctIndex = spreadManager.getColpartitionDims().indexOf(CHANGE_TYPE);
            int dtIndex = spreadManager.getRowpartitionDims().indexOf(DATA_TYPE);
            for (int col = 0; col < spreadManager.getColpartitionDimMems().size(); ++col) {
                CellDimMember ctCellDimMember;
                List<CellDimMember> colCellDimMembers = spreadManager.getColpartitionDimMems().get(col);
                if (colCellDimMembers == null || colCellDimMembers.size() < ctIndex || (ctCellDimMember = colCellDimMembers.get(ctIndex)) == null) continue;
                for (int row = 0; row < spreadManager.getRowpartitionDimMems().size(); ++row) {
                    boolean actualChangesFlag;
                    CellDimMember dtCellDimMem;
                    List<CellDimMember> rowCellDimMembers = spreadManager.getRowpartitionDimMems().get(row);
                    if (rowCellDimMembers == null || rowCellDimMembers.size() < dtIndex || (dtCellDimMem = rowCellDimMembers.get(dtIndex)) == null) continue;
                    boolean bl = actualChangesFlag = !"ACTUAL".equals(this.versionNumber) || !"Actual".equals(dtCellDimMem.getDimMemberNumber());
                    if (!this.checkMemberIsActualChangesLeaf(spreadManager, ctCellDimMember.getDimMemberNumber()) || !actualChangesFlag) continue;
                    StyleCell styleCell = (StyleCell)sheet.getECell(row, col);
                    styleCell.setLocked(true);
                    styleCell.setBackColor("#FFF8E1");
                    Set cols = styleControlContext.getLockCells().computeIfAbsent(row, t -> new HashSet(16));
                    cols.add(col);
                }
            }
        }
    }

    private void threeDimInRowColView(SpreadLockContext styleControlContext) {
        block42: {
            boolean isVersionInRow;
            boolean isDataTypeInCol;
            boolean isChangeTypeInCol;
            ISheet sheet;
            IEbSpreadManager spreadManager;
            block48: {
                boolean isVersionInCol;
                boolean isDataTypeInRow;
                block47: {
                    block46: {
                        boolean isChangeTypeInRow;
                        block45: {
                            block44: {
                                block43: {
                                    block41: {
                                        if (styleControlContext == null) {
                                            return;
                                        }
                                        spreadManager = styleControlContext.getEbSpreadManager();
                                        sheet = spreadManager.getEbook().getSheet(0);
                                        isChangeTypeInRow = spreadManager.getRowpartitionDims().contains(CHANGE_TYPE);
                                        isChangeTypeInCol = spreadManager.getColpartitionDims().contains(CHANGE_TYPE);
                                        isDataTypeInRow = spreadManager.getRowpartitionDims().contains(DATA_TYPE);
                                        isDataTypeInCol = spreadManager.getColpartitionDims().contains(DATA_TYPE);
                                        isVersionInRow = spreadManager.getRowpartitionDims().contains(VERSION);
                                        isVersionInCol = spreadManager.getColpartitionDims().contains(VERSION);
                                        if (!isChangeTypeInRow || !isDataTypeInRow || !isVersionInRow) break block41;
                                        for (int row = 0; row < spreadManager.getRowpartitionDimMems().size(); ++row) {
                                            boolean actualChangesFlag;
                                            List<CellDimMember> cellDimMembers = spreadManager.getRowpartitionDimMems().get(row);
                                            if (cellDimMembers == null || cellDimMembers.size() == 0) continue;
                                            boolean lock = false;
                                            int i = 0;
                                            String changeTypeMemNum = "";
                                            String dataTypeMemNum = "";
                                            String versionMemNum = "";
                                            for (CellDimMember cellDimMember : cellDimMembers) {
                                                if (cellDimMember == null) continue;
                                                String dimNumber = spreadManager.getRowpartitionDims().get(i);
                                                String dimMemberNumber = cellDimMember.getDimMemberNumber();
                                                ++i;
                                                if (CHANGE_TYPE.equals(dimNumber)) {
                                                    changeTypeMemNum = dimMemberNumber;
                                                }
                                                if (DATA_TYPE.equals(dimNumber)) {
                                                    dataTypeMemNum = dimMemberNumber;
                                                }
                                                if (!VERSION.equals(dimNumber)) continue;
                                                versionMemNum = dimMemberNumber;
                                            }
                                            boolean bl = actualChangesFlag = !"Actual".equals(dataTypeMemNum) || !"ACTUAL".equals(versionMemNum);
                                            if (this.checkMemberIsActualChangesLeaf(spreadManager, changeTypeMemNum) && actualChangesFlag) {
                                                lock = true;
                                            }
                                            if (!lock) continue;
                                            log.info("locked_by_ActualChangesLeafCellLockController_threeDimInRowColView_isChangeTypeInRow&&isDataTypeInRow&&isVersionInRow:" + changeTypeMemNum + "_" + dataTypeMemNum + "_" + versionMemNum + "_row=" + row);
                                            for (int col = sheet.getValueAreaColStart(); col < sheet.getRealMaxCols(); ++col) {
                                                StyleCell styleCell = (StyleCell)sheet.getECell(row, col);
                                                styleCell.setLocked(true);
                                                styleCell.setBackColor("#FFF8E1");
                                                Set cols = styleControlContext.getLockCells().computeIfAbsent(row, t -> new HashSet(16));
                                                cols.add(col);
                                            }
                                        }
                                        break block42;
                                    }
                                    if (!isChangeTypeInCol || !isDataTypeInCol || !isVersionInCol) break block43;
                                    for (int col = 0; col < spreadManager.getColpartitionDimMems().size(); ++col) {
                                        boolean actualChangesFlag;
                                        List<CellDimMember> cellDimMembers = spreadManager.getColpartitionDimMems().get(col);
                                        if (cellDimMembers == null || cellDimMembers.size() == 0) continue;
                                        boolean lock = false;
                                        int i = 0;
                                        String changeTypeMemNum = "";
                                        String dataTypeMemNum = "";
                                        String versionMemNum = "";
                                        for (CellDimMember cellDimMember : cellDimMembers) {
                                            if (cellDimMember == null) continue;
                                            String dimNumber = spreadManager.getColpartitionDims().get(i);
                                            String dimMemberNumber = cellDimMember.getDimMemberNumber();
                                            ++i;
                                            if (CHANGE_TYPE.equals(dimNumber)) {
                                                changeTypeMemNum = dimMemberNumber;
                                            }
                                            if (DATA_TYPE.equals(dimNumber)) {
                                                dataTypeMemNum = dimMemberNumber;
                                            }
                                            if (!VERSION.equals(dimNumber)) continue;
                                            versionMemNum = dimMemberNumber;
                                        }
                                        boolean bl = actualChangesFlag = !"Actual".equals(dataTypeMemNum) || !"ACTUAL".equals(versionMemNum);
                                        if (this.checkMemberIsActualChangesLeaf(spreadManager, changeTypeMemNum) && actualChangesFlag) {
                                            lock = true;
                                        }
                                        if (!lock) continue;
                                        log.info("locked_by_ActualChangesLeafCellLockController_threeDimInRowColView_isChangeTypeInCol&&isDataTypeInCol&&isVersionInCol:" + changeTypeMemNum + "_" + dataTypeMemNum + "_" + versionMemNum + "_col=" + col);
                                        for (int row = sheet.getValueAreaRowStart(); row < sheet.getRealMaxRows(); ++row) {
                                            StyleCell styleCell = (StyleCell)sheet.getECell(row, col);
                                            styleCell.setLocked(true);
                                            styleCell.setBackColor("#FFF8E1");
                                            Set cols = styleControlContext.getLockCells().computeIfAbsent(row, t -> new HashSet(16));
                                            cols.add(col);
                                        }
                                    }
                                    break block42;
                                }
                                if (!isChangeTypeInRow || !isDataTypeInRow || !isVersionInCol) break block44;
                                int ctIndex = spreadManager.getRowpartitionDims().indexOf(CHANGE_TYPE);
                                int dtIndex = spreadManager.getRowpartitionDims().indexOf(DATA_TYPE);
                                int versionIndex = spreadManager.getColpartitionDims().indexOf(VERSION);
                                for (int row = 0; row < spreadManager.getRowpartitionDimMems().size(); ++row) {
                                    CellDimMember ctCellDimMember = null;
                                    CellDimMember dtCellDimMember = null;
                                    List<CellDimMember> rowCellDimMembers = spreadManager.getRowpartitionDimMems().get(row);
                                    if (rowCellDimMembers != null && rowCellDimMembers.size() >= ctIndex) {
                                        ctCellDimMember = rowCellDimMembers.get(ctIndex);
                                    }
                                    if (rowCellDimMembers != null && rowCellDimMembers.size() >= dtIndex) {
                                        dtCellDimMember = rowCellDimMembers.get(dtIndex);
                                    }
                                    if (ctCellDimMember == null || !this.checkMemberIsActualChangesLeaf(spreadManager, ctCellDimMember.getDimMemberNumber()) || dtCellDimMember == null) continue;
                                    for (int col = 0; col < spreadManager.getColpartitionDimMems().size(); ++col) {
                                        boolean actualChangesFlag;
                                        CellDimMember versionCellDimMem;
                                        List<CellDimMember> colCellDimMembers = spreadManager.getColpartitionDimMems().get(col);
                                        if (colCellDimMembers == null || colCellDimMembers.size() < versionIndex || (versionCellDimMem = colCellDimMembers.get(versionIndex)) == null) continue;
                                        boolean bl = actualChangesFlag = !"ACTUAL".equals(versionCellDimMem.getDimMemberNumber()) || !"Actual".equals(dtCellDimMember.getDimMemberNumber());
                                        if (!actualChangesFlag) continue;
                                        StyleCell styleCell = (StyleCell)sheet.getECell(row, col);
                                        styleCell.setLocked(true);
                                        styleCell.setBackColor("#FFF8E1");
                                        Set cols = styleControlContext.getLockCells().computeIfAbsent(row, t -> new HashSet(16));
                                        cols.add(col);
                                    }
                                }
                                break block42;
                            }
                            if (!isChangeTypeInRow || !isDataTypeInCol || !isVersionInRow) break block45;
                            int ctIndex = spreadManager.getRowpartitionDims().indexOf(CHANGE_TYPE);
                            int versionIndex = spreadManager.getRowpartitionDims().indexOf(VERSION);
                            int dtIndex = spreadManager.getColpartitionDims().indexOf(DATA_TYPE);
                            for (int row = 0; row < spreadManager.getRowpartitionDimMems().size(); ++row) {
                                CellDimMember ctCellDimMember = null;
                                CellDimMember versionCellDimMem = null;
                                List<CellDimMember> rowCellDimMembers = spreadManager.getRowpartitionDimMems().get(row);
                                if (rowCellDimMembers != null && rowCellDimMembers.size() >= ctIndex) {
                                    ctCellDimMember = rowCellDimMembers.get(ctIndex);
                                }
                                if (rowCellDimMembers != null && rowCellDimMembers.size() >= versionIndex) {
                                    versionCellDimMem = rowCellDimMembers.get(versionIndex);
                                }
                                if (ctCellDimMember == null || !this.checkMemberIsActualChangesLeaf(spreadManager, ctCellDimMember.getDimMemberNumber()) || versionCellDimMem == null) continue;
                                for (int col = 0; col < spreadManager.getColpartitionDimMems().size(); ++col) {
                                    boolean actualChangesFlag;
                                    CellDimMember dtCellDimMem;
                                    List<CellDimMember> colCellDimMembers = spreadManager.getColpartitionDimMems().get(col);
                                    if (colCellDimMembers == null || colCellDimMembers.size() < dtIndex || (dtCellDimMem = colCellDimMembers.get(dtIndex)) == null) continue;
                                    boolean bl = actualChangesFlag = !"ACTUAL".equals(versionCellDimMem.getDimMemberNumber()) || !"Actual".equals(dtCellDimMem.getDimMemberNumber());
                                    if (!actualChangesFlag) continue;
                                    StyleCell styleCell = (StyleCell)sheet.getECell(row, col);
                                    styleCell.setLocked(true);
                                    styleCell.setBackColor("#FFF8E1");
                                    Set cols = styleControlContext.getLockCells().computeIfAbsent(row, t -> new HashSet(16));
                                    cols.add(col);
                                }
                            }
                            break block42;
                        }
                        if (!isChangeTypeInRow || !isDataTypeInCol || !isVersionInCol) break block46;
                        int ctIndex = spreadManager.getRowpartitionDims().indexOf(CHANGE_TYPE);
                        int dtIndex = spreadManager.getColpartitionDims().indexOf(DATA_TYPE);
                        int versionIndex = spreadManager.getColpartitionDims().indexOf(VERSION);
                        for (int row = 0; row < spreadManager.getRowpartitionDimMems().size(); ++row) {
                            CellDimMember ctCellDimMember = null;
                            List<CellDimMember> rowCellDimMembers = spreadManager.getRowpartitionDimMems().get(row);
                            if (rowCellDimMembers != null && rowCellDimMembers.size() >= ctIndex) {
                                ctCellDimMember = rowCellDimMembers.get(ctIndex);
                            }
                            if (ctCellDimMember == null || !this.checkMemberIsActualChangesLeaf(spreadManager, ctCellDimMember.getDimMemberNumber())) continue;
                            for (int col = 0; col < spreadManager.getColpartitionDimMems().size(); ++col) {
                                boolean actualChangesFlag;
                                List<CellDimMember> colCellDimMembers = spreadManager.getColpartitionDimMems().get(col);
                                CellDimMember dtCellDimMember = null;
                                CellDimMember versionCellDimMember = null;
                                if (colCellDimMembers != null && colCellDimMembers.size() >= dtIndex) {
                                    dtCellDimMember = colCellDimMembers.get(dtIndex);
                                }
                                if (colCellDimMembers != null && colCellDimMembers.size() >= versionIndex) {
                                    versionCellDimMember = colCellDimMembers.get(versionIndex);
                                }
                                if (dtCellDimMember == null || versionCellDimMember == null) continue;
                                boolean bl = actualChangesFlag = !"ACTUAL".equals(versionCellDimMember.getDimMemberNumber()) || !"Actual".equals(dtCellDimMember.getDimMemberNumber());
                                if (!actualChangesFlag) continue;
                                StyleCell styleCell = (StyleCell)sheet.getECell(row, col);
                                styleCell.setLocked(true);
                                styleCell.setBackColor("#FFF8E1");
                                Set cols = styleControlContext.getLockCells().computeIfAbsent(row, t -> new HashSet(16));
                                cols.add(col);
                            }
                        }
                        break block42;
                    }
                    if (!isChangeTypeInCol || !isDataTypeInRow || !isVersionInRow) break block47;
                    int dtIndex = spreadManager.getRowpartitionDims().indexOf(DATA_TYPE);
                    int versionIndex = spreadManager.getRowpartitionDims().indexOf(VERSION);
                    int ctIndex = spreadManager.getColpartitionDims().indexOf(CHANGE_TYPE);
                    for (int row = 0; row < spreadManager.getRowpartitionDimMems().size(); ++row) {
                        CellDimMember dtCellDimMember = null;
                        CellDimMember versionCellDimMember = null;
                        List<CellDimMember> rowCellDimMembers = spreadManager.getRowpartitionDimMems().get(row);
                        if (rowCellDimMembers != null && rowCellDimMembers.size() >= dtIndex) {
                            dtCellDimMember = rowCellDimMembers.get(dtIndex);
                        }
                        if (rowCellDimMembers != null && rowCellDimMembers.size() >= versionIndex) {
                            versionCellDimMember = rowCellDimMembers.get(versionIndex);
                        }
                        if (dtCellDimMember == null || versionCellDimMember == null) continue;
                        for (int col = 0; col < spreadManager.getColpartitionDimMems().size(); ++col) {
                            boolean actualChangesFlag;
                            List<CellDimMember> colCellDimMembers = spreadManager.getColpartitionDimMems().get(col);
                            CellDimMember ctCellDimMember = null;
                            if (colCellDimMembers != null && colCellDimMembers.size() >= ctIndex) {
                                ctCellDimMember = colCellDimMembers.get(ctIndex);
                            }
                            boolean bl = actualChangesFlag = !"ACTUAL".equals(versionCellDimMember.getDimMemberNumber()) || !"Actual".equals(dtCellDimMember.getDimMemberNumber());
                            if (ctCellDimMember == null || !this.checkMemberIsActualChangesLeaf(spreadManager, ctCellDimMember.getDimMemberNumber()) || !actualChangesFlag) continue;
                            StyleCell styleCell = (StyleCell)sheet.getECell(row, col);
                            styleCell.setLocked(true);
                            styleCell.setBackColor("#FFF8E1");
                            Set cols = styleControlContext.getLockCells().computeIfAbsent(row, t -> new HashSet(16));
                            cols.add(col);
                        }
                    }
                    break block42;
                }
                if (!isChangeTypeInCol || !isDataTypeInRow || !isVersionInCol) break block48;
                int dtIndex = spreadManager.getRowpartitionDims().indexOf(DATA_TYPE);
                int ctIndex = spreadManager.getColpartitionDims().indexOf(CHANGE_TYPE);
                int versionIndex = spreadManager.getColpartitionDims().indexOf(VERSION);
                for (int row = 0; row < spreadManager.getRowpartitionDimMems().size(); ++row) {
                    CellDimMember dtCellDimMember = null;
                    List<CellDimMember> rowCellDimMembers = spreadManager.getRowpartitionDimMems().get(row);
                    if (rowCellDimMembers != null && rowCellDimMembers.size() >= dtIndex) {
                        dtCellDimMember = rowCellDimMembers.get(dtIndex);
                    }
                    if (dtCellDimMember == null) continue;
                    for (int col = 0; col < spreadManager.getColpartitionDimMems().size(); ++col) {
                        boolean actualChangesFlag;
                        List<CellDimMember> colCellDimMembers = spreadManager.getColpartitionDimMems().get(col);
                        CellDimMember ctCellDimMember = null;
                        CellDimMember versionCellDimMember = null;
                        if (colCellDimMembers != null && colCellDimMembers.size() >= ctIndex) {
                            ctCellDimMember = colCellDimMembers.get(ctIndex);
                        }
                        if (colCellDimMembers != null && colCellDimMembers.size() >= versionIndex) {
                            versionCellDimMember = colCellDimMembers.get(versionIndex);
                        }
                        if (ctCellDimMember == null || versionCellDimMember == null) continue;
                        boolean bl = actualChangesFlag = !"ACTUAL".equals(versionCellDimMember.getDimMemberNumber()) || !"Actual".equals(dtCellDimMember.getDimMemberNumber());
                        if (!this.checkMemberIsActualChangesLeaf(spreadManager, ctCellDimMember.getDimMemberNumber()) || !actualChangesFlag) continue;
                        StyleCell styleCell = (StyleCell)sheet.getECell(row, col);
                        styleCell.setLocked(true);
                        styleCell.setBackColor("#FFF8E1");
                        Set cols = styleControlContext.getLockCells().computeIfAbsent(row, t -> new HashSet(16));
                        cols.add(col);
                    }
                }
                break block42;
            }
            if (!isChangeTypeInCol || !isDataTypeInCol || !isVersionInRow) break block42;
            int versionIndex = spreadManager.getRowpartitionDims().indexOf(VERSION);
            int ctIndex = spreadManager.getColpartitionDims().indexOf(CHANGE_TYPE);
            int dtIndex = spreadManager.getColpartitionDims().indexOf(DATA_TYPE);
            for (int row = 0; row < spreadManager.getRowpartitionDimMems().size(); ++row) {
                CellDimMember versionCellDimMember = null;
                List<CellDimMember> rowCellDimMembers = spreadManager.getRowpartitionDimMems().get(row);
                if (rowCellDimMembers != null && rowCellDimMembers.size() >= versionIndex) {
                    versionCellDimMember = rowCellDimMembers.get(versionIndex);
                }
                if (versionCellDimMember == null) continue;
                for (int col = 0; col < spreadManager.getColpartitionDimMems().size(); ++col) {
                    boolean actualChangesFlag;
                    List<CellDimMember> colCellDimMembers = spreadManager.getColpartitionDimMems().get(col);
                    CellDimMember ctCellDimMember = null;
                    CellDimMember dtCellDimMember = null;
                    if (colCellDimMembers != null && colCellDimMembers.size() >= ctIndex) {
                        ctCellDimMember = colCellDimMembers.get(ctIndex);
                    }
                    if (colCellDimMembers != null && colCellDimMembers.size() >= dtIndex) {
                        dtCellDimMember = colCellDimMembers.get(dtIndex);
                    }
                    if (ctCellDimMember == null || dtCellDimMember == null) continue;
                    boolean bl = actualChangesFlag = !"ACTUAL".equals(versionCellDimMember.getDimMemberNumber()) || !"Actual".equals(dtCellDimMember.getDimMemberNumber());
                    if (!this.checkMemberIsActualChangesLeaf(spreadManager, ctCellDimMember.getDimMemberNumber()) || !actualChangesFlag) continue;
                    StyleCell styleCell = (StyleCell)sheet.getECell(row, col);
                    styleCell.setLocked(true);
                    styleCell.setBackColor("#FFF8E1");
                    Set cols = styleControlContext.getLockCells().computeIfAbsent(row, t -> new HashSet(16));
                    cols.add(col);
                }
            }
        }
    }
}

