/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.command.lockcontroller.lockcell;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.approveBill.Entity.ApproveBillInfo;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.utils.ApproveAdjustUtils;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.common.utils.RangeModel;
import kd.epm.eb.common.utils.adjustdecompose.AdjustServiceHelper;
import kd.epm.eb.spread.command.lockcontroller.FixSpreadLockContext;
import kd.epm.eb.spread.command.lockcontroller.ISpreadLockControl;
import kd.epm.eb.spread.command.lockcontroller.SpreadLockContext;
import kd.epm.eb.spread.command.rangedefined.CellArea;
import kd.epm.eb.spread.command.style.AreasStyle;
import kd.epm.eb.spread.command.style.CellStyleInfo;
import kd.epm.eb.spread.template.afix.multimanager.MultiAreaManager;
import kd.epm.eb.spread.template.dimension.PageViewDimMember;
import kd.epm.eb.spread.template.spreadmanager.CellDimMember;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.book.IEBook;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import kd.epm.eb.spread.template.spreadmanager.sheet.StyleCell;

public class AdjustDecomposeCellLockController
implements ISpreadLockControl {
    private static final Log log = LogFactory.getLog(AdjustDecomposeCellLockController.class);
    private IFormView view;
    private ApproveBillInfo billInfo;

    public AdjustDecomposeCellLockController(IFormView view, ApproveBillInfo billInfo) {
        this.view = view;
        this.billInfo = billInfo;
    }

    @Override
    public void control(SpreadLockContext styleControlContext) {
        try {
            IEbSpreadManager ebSpreadManager = styleControlContext.getEbSpreadManager();
            Long modelId = ebSpreadManager.getModelobj().getId();
            boolean isVirtual = false;
            if (this.billInfo != null && !ConvertUtils.toLong((Object)ebSpreadManager.getReportProcessId()).equals(this.billInfo.getSourceRptId())) {
                isVirtual = true;
            }
            boolean approveAdjust = ApproveAdjustUtils.getInstance().approveAdjust(modelId, ebSpreadManager.getReportProcessId(), this.view, Long.valueOf(this.billInfo != null ? this.billInfo.getBillId() : 0L), Boolean.valueOf(isVirtual));
            this.dinCheckDimsLockAdjust(styleControlContext, approveAdjust);
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    @Override
    public void controlfix(FixSpreadLockContext fixSpreadLockContext) {
        try {
            IEbSpreadManager ebSpreadManager = fixSpreadLockContext.getEbSpreadManager();
            Long modelId = ebSpreadManager.getModelobj().getId();
            boolean isVirtual = false;
            if (this.billInfo != null && !ConvertUtils.toLong((Object)ebSpreadManager.getReportProcessId()).equals(this.billInfo.getSourceRptId())) {
                isVirtual = true;
            }
            boolean approveAdjust = ApproveAdjustUtils.getInstance().approveAdjust(modelId, ebSpreadManager.getReportProcessId(), this.view, Long.valueOf(this.billInfo != null ? this.billInfo.getBillId() : 0L), Boolean.valueOf(isVirtual));
            this.fixCheckDimsLockAdjust(fixSpreadLockContext, approveAdjust);
        }
        catch (Exception e) {
            throw new KDBizException(e.getMessage());
        }
    }

    public Map<Integer, Set<Map<String, String>>> getAdjustMemberMap(IEbSpreadManager spreadManager, Map<String, String> allDimMap) {
        IModelCacheHelper modelCacheHelper = spreadManager.getModelCacheHelper();
        return AdjustServiceHelper.getAdjustMemberMap((IModelCacheHelper)modelCacheHelper, (Long)spreadManager.getBusModelid(), (Long)spreadManager.getDatasetid(), allDimMap, spreadManager.getDimemsionViews());
    }

    private void dinCheckDimsLockAdjust(SpreadLockContext styleControlContext, boolean approveAdjust) {
        IEbSpreadManager ebSpreadManager = styleControlContext.getEbSpreadManager();
        if (ebSpreadManager == null) {
            return;
        }
        IEBook ebook = ebSpreadManager.getEbook();
        if (ebook == null) {
            return;
        }
        Map<String, String> pageDimMemberMap = new HashMap<String, String>(16);
        Map<String, PageViewDimMember> pageViewDimMemberMap = ebSpreadManager.getPageViewDims();
        if (pageViewDimMemberMap != null) {
            pageDimMemberMap = pageViewDimMemberMap.entrySet().stream().filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, kv -> kv.getValue() != null ? ((PageViewDimMember)kv.getValue()).getNumber() : ""));
        }
        Map<Object, Object> adjustMemberMap = new HashMap(16);
        if (!approveAdjust && (adjustMemberMap = this.getAdjustMemberMap(ebSpreadManager, pageDimMemberMap)).isEmpty()) {
            return;
        }
        Iterator<ISheet> iterator = ebook.iterator();
        while (iterator.hasNext()) {
            ArrayList<Integer[]> lockIndex = new ArrayList<Integer[]>(16);
            ISheet sheet = iterator.next();
            int rowStart = Math.max(sheet.getDimRowStart(), 0);
            int rowEnd = sheet.getRealMaxRows();
            int colStart = Math.max(sheet.getDimColStart(), 0);
            int colEnd = sheet.getRealMaxCols();
            for (int i = rowStart; i < rowEnd; ++i) {
                HashMap<String, String> dimMemberMap = new HashMap<String, String>(pageDimMemberMap);
                Map<String, CellDimMember> rowDims = ebSpreadManager.getRowpartitionDimMemsByRow(i);
                if (rowDims == null || rowDims.size() == 0) continue;
                Map<String, String> rowDimMemberMap = rowDims.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, kv -> ((CellDimMember)kv.getValue()).getDimMemberNumber()));
                dimMemberMap.putAll(rowDimMemberMap);
                for (int j = colStart; j < colEnd; ++j) {
                    Set adjustMemberSet;
                    StyleCell styleCell;
                    ECell eCell1;
                    Map<String, CellDimMember> colDims = ebSpreadManager.getColpartitionDimMemsByCol(j);
                    if (colDims == null || colDims.size() == 0 || !((eCell1 = sheet.getECell(i, j)) instanceof StyleCell) || (styleCell = (StyleCell)sheet.getECell(i, j)).isLocked()) continue;
                    Map<String, String> colDimMemberMap = colDims.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, kv -> ((CellDimMember)kv.getValue()).getDimMemberNumber()));
                    dimMemberMap.putAll(colDimMemberMap);
                    if (approveAdjust || (adjustMemberSet = (Set)adjustMemberMap.get(dimMemberMap.hashCode())) == null || !adjustMemberSet.contains(dimMemberMap)) continue;
                    lockIndex.add(new Integer[]{i, j});
                }
            }
            this.lockSheetCell(sheet, lockIndex);
            styleControlContext.setLockCells(lockIndex);
        }
    }

    private void fixCheckDimsLockAdjust(FixSpreadLockContext fixSpreadLockContext, boolean approveAdjust) {
        IEbSpreadManager ebSpreadManager = fixSpreadLockContext.getEbSpreadManager();
        if (ebSpreadManager == null) {
            return;
        }
        List<MultiAreaManager> multiAreaManager = ebSpreadManager.getMultiAreaManager();
        if (multiAreaManager == null || multiAreaManager.size() == 0) {
            return;
        }
        Map<String, PageViewDimMember> pageViewDimMemberMap = ebSpreadManager.getPageViewDims();
        Map<String, String> pageDimMemberMap = new HashMap<String, String>(16);
        if (pageViewDimMemberMap != null) {
            pageDimMemberMap = pageViewDimMemberMap.entrySet().stream().filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, kv -> kv.getValue() != null ? ((PageViewDimMember)kv.getValue()).getNumber() : ""));
        }
        Map<Object, Object> adjustMemberMap = new HashMap(16);
        if (!approveAdjust && (adjustMemberMap = this.getAdjustMemberMap(ebSpreadManager, pageDimMemberMap)).isEmpty()) {
            return;
        }
        for (MultiAreaManager areaManager : multiAreaManager) {
            MultiAreaManager.ValueArea areaStart;
            if (areaManager == null) continue;
            Map<String, PageViewDimMember> hideMemberMap = areaManager.getAreaPageViewDims();
            if (hideMemberMap != null) {
                for (Map.Entry<String, PageViewDimMember> entry : hideMemberMap.entrySet()) {
                    PageViewDimMember pageViewDimMember = entry.getValue();
                    pageDimMemberMap.put(entry.getKey(), pageViewDimMember != null ? pageViewDimMember.getNumber() : "");
                }
            }
            ArrayList<Integer[]> lockIndex = new ArrayList<Integer[]>(16);
            RangeModel areaRange = areaManager.getAreaRange();
            if (areaRange == null || (areaStart = areaManager.getValueAreaStart()) == null) continue;
            int colStart = areaStart.getCol_start();
            int colEnd = areaRange.getXEnd();
            int rowStart = areaStart.getRow_start();
            int rowEnd = areaRange.getYEnd();
            for (int i = rowStart; i <= rowEnd; ++i) {
                Map<String, String> rowDims = this.getRowpartitionDimMemsByRow(areaManager, i - rowStart);
                if (rowDims == null || rowDims.size() == 0) continue;
                HashMap<String, String> dimMemberMap = new HashMap<String, String>(pageDimMemberMap);
                dimMemberMap.putAll(rowDims);
                for (int j = colStart; j <= colEnd; ++j) {
                    Set adjustMemberSet;
                    Map<String, String> colDims = this.getColpartitionDimMemsByCol(areaManager, j - colStart);
                    if (colDims == null || colDims.size() == 0) continue;
                    dimMemberMap.putAll(colDims);
                    if (approveAdjust || (adjustMemberSet = (Set)adjustMemberMap.get(dimMemberMap.hashCode())) == null || !adjustMemberSet.contains(dimMemberMap)) continue;
                    lockIndex.add(new Integer[]{i, j});
                }
            }
            this.lockSheetCellFix(fixSpreadLockContext, lockIndex, areaManager.isUserStyle());
        }
    }

    private Map<String, String> getRowpartitionDimMemsByRow(MultiAreaManager areaManager, int row) {
        Map<String, CellDimMember> rowDims = areaManager.getRowpartitionDimMemsByRow(row);
        if (rowDims != null) {
            return rowDims.entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, kv -> ((CellDimMember)kv.getValue()).getDimMemberNumber()));
        }
        return null;
    }

    private Map<String, String> getColpartitionDimMemsByCol(MultiAreaManager areaManager, int col) {
        Map<String, CellDimMember> colDims = areaManager.getColpartitionDimMemsByCol(col);
        if (colDims != null) {
            return colDims.entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, kv -> ((CellDimMember)kv.getValue()).getDimMemberNumber()));
        }
        return null;
    }

    public void lockSheetCell(ISheet sheet, List<Integer[]> lockIndex) {
        for (Integer[] arr : lockIndex) {
            int col;
            int row = arr[0];
            ECell eCell = sheet.getECell(row, col = arr[1].intValue());
            if (!(eCell instanceof StyleCell)) continue;
            StyleCell styleCell = (StyleCell)eCell;
            styleCell.setLocked(true);
            styleCell.setBackColor("#E6E8EE");
        }
        if (lockIndex.size() > 0) {
            log.info("locked by AdjustDecomposeCellLockController lockIndex=" + lockIndex);
        }
    }

    private void lockSheetCellFix(FixSpreadLockContext fixSpreadLockContext, List<Integer[]> lockIndex, boolean userStyle) {
        if (lockIndex == null || lockIndex.size() == 0) {
            return;
        }
        AreasStyle areasStyle = new AreasStyle();
        CellStyleInfo styleInfo = new CellStyleInfo();
        if (!userStyle) {
            styleInfo.setBkc("#E6E8EE");
        }
        styleInfo.setL(true);
        int rowIndex = 0;
        int colIndex = 1;
        ArrayList<CellArea> range = new ArrayList<CellArea>(lockIndex.size() * 2);
        for (Integer[] indexes : lockIndex) {
            CellArea cellArea = new CellArea(indexes[rowIndex], indexes[colIndex], 1, 1);
            range.add(cellArea);
        }
        areasStyle.setStyle(styleInfo);
        areasStyle.setRange(range);
        fixSpreadLockContext.getAreasStyles().add(areasStyle);
        if (lockIndex.size() > 0) {
            log.info("locked by AdjustDecomposeCellLockController lockIndex=" + lockIndex);
        }
    }
}

