/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.command.lockcontroller.lockcell;

import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.approveBill.ApproveBillQuery;
import kd.epm.eb.common.approveBill.Entity.ApproveBillInfo;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.utils.ApproveAdjustUtils;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.spread.command.lockcontroller.ISpreadLockControl;
import kd.epm.eb.spread.command.lockcontroller.SpreadLockContext;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;

public class ApproveNeedLockCellController
implements ISpreadLockControl {
    private static final long serialVersionUID = 1L;
    private IFormView view;
    private ApproveBillInfo billInfo;
    private String reportProcessId;
    private static final Log log = LogFactory.getLog(ApproveNeedLockCellController.class);

    public ApproveNeedLockCellController(String reportProcessId, IFormView view, ApproveBillInfo billInfo) {
        this.reportProcessId = reportProcessId;
        this.view = view;
        this.billInfo = billInfo;
    }

    @Override
    public void control(SpreadLockContext spreadLockContext) {
        IEbSpreadManager ebSpreadManager = spreadLockContext.getEbSpreadManager();
        IModelCacheHelper modelCacheHelper = ebSpreadManager.getModelCacheHelper();
        Long modelId = modelCacheHelper.getModelobj().getId();
        this.setSourceRpt2BillInfo(ebSpreadManager.getReportProcessId());
        try {
            boolean isLock = new ApproveBillQuery().getIsLock(this.reportProcessId, this.billInfo, modelId, this.view);
            if (isLock) {
                this.view.getPageCache().put("reoportIsLock", "true");
                spreadLockContext.lockAllData(null, "#E6E8EE");
                spreadLockContext.setStopcommand(true);
                log.info("locked by ApproveNeedLockCellController " + ebSpreadManager.getReportProcessId());
            } else {
                this.view.getPageCache().put("reoportIsLock", "false");
                boolean isVirtual = false;
                if (this.billInfo != null && !ConvertUtils.toLong((Object)this.reportProcessId).equals(this.billInfo.getSourceRptId())) {
                    isVirtual = true;
                }
                boolean approveAdjust = ApproveAdjustUtils.getInstance().approveAdjust(modelId, Long.valueOf(Long.parseLong(this.reportProcessId)), this.view, Long.valueOf(this.billInfo != null ? this.billInfo.getBillId() : 0L), Boolean.valueOf(isVirtual));
                spreadLockContext.getParams().put("approveAdjust", approveAdjust);
            }
        }
        catch (Exception e) {
            log.error(CommonServiceHelper.getStackTraceStr((Throwable)e));
            throw new KDBizException(e.getMessage());
        }
        this.setSourceRpt2BillInfo(null);
    }

    private void setSourceRpt2BillInfo(Long sourceRptId) {
        if (this.billInfo != null) {
            this.billInfo.setSourceRptId(sourceRptId);
        }
    }
}

