/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.command.lockcontroller.lockcell;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.bgmddatalock.BgmdDataLockService;
import kd.epm.eb.common.bgmddatalock.BgmdDataLockUtils;
import kd.epm.eb.common.bgmddatalock.IBgmdDataLockCache;
import kd.epm.eb.spread.command.lockcontroller.ISpreadLockControl;
import kd.epm.eb.spread.command.lockcontroller.SpreadLockContext;
import kd.epm.eb.spread.template.dimension.PageViewDimMember;
import kd.epm.eb.spread.template.spreadmanager.CellDimMember;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import kd.epm.eb.spread.template.spreadmanager.sheet.StyleCell;

public class DataLockCellLockController
implements ISpreadLockControl {
    private static final Log log = LogFactory.getLog(DataLockCellLockController.class);

    @Override
    public void control(SpreadLockContext styleControlContext) {
        Long bizModel = styleControlContext.getTemplateModel().getTemplateBaseInfo().getBizModel();
        Long modelId = styleControlContext.getTemplateModel().getModelId();
        IBgmdDataLockCache dataLockCache = BgmdDataLockService.getInstance().getDataLockCache(modelId, bizModel);
        Map controlDimNumbers = BgmdDataLockUtils.getControlDimNumberMap();
        IEbSpreadManager ebSpreadManager = styleControlContext.getEbSpreadManager();
        String[] members = new String[controlDimNumbers.size()];
        for (Map.Entry<String, PageViewDimMember> entry : ebSpreadManager.getPageViewDims().entrySet()) {
            String memNumber;
            String dimNumber = entry.getKey();
            String string = memNumber = entry.getValue() != null ? entry.getValue().getNumber() : null;
            if (!controlDimNumbers.containsKey(dimNumber)) continue;
            members[((Integer)controlDimNumbers.get((Object)dimNumber)).intValue()] = memNumber;
        }
        if (this.checkFull(members)) {
            if (dataLockCache.isDataLock(members)) {
                styleControlContext.lockAllData(null, "#E6E8EE");
                log.info("locked by DataLockCellLockController");
            }
        } else {
            List<String> colpartitionDims = styleControlContext.getEbSpreadManager().getColpartitionDims();
            List<String> rowpartitionDims = styleControlContext.getEbSpreadManager().getRowpartitionDims();
            List<List<CellDimMember>> colPartitionDimMems = ebSpreadManager.getColpartitionDimMems();
            List<List<CellDimMember>> rowPartitionDimMems = ebSpreadManager.getRowpartitionDimMems();
            if (this.tryOnce(colpartitionDims, members, controlDimNumbers)) {
                this.genCellDataLockByOneAxis(styleControlContext, dataLockCache, colpartitionDims, colPartitionDimMems, members, controlDimNumbers, false);
            } else if (this.tryOnce(rowpartitionDims, members, controlDimNumbers)) {
                this.genCellDataLockByOneAxis(styleControlContext, dataLockCache, rowpartitionDims, rowPartitionDimMems, members, controlDimNumbers, true);
            } else if (this.tryAgain(colpartitionDims, members, controlDimNumbers)) {
                this.genCellDataLockByTwoAxis(styleControlContext, dataLockCache, members, controlDimNumbers, true, false);
            } else if (this.tryAgain(rowpartitionDims, members, controlDimNumbers)) {
                this.genCellDataLockByTwoAxis(styleControlContext, dataLockCache, members, controlDimNumbers, true, true);
            } else {
                this.genCellDataLockByTwoAxis(styleControlContext, dataLockCache, members, controlDimNumbers, false, true);
            }
        }
    }

    private void genCellDataLockByOneAxis(SpreadLockContext styleControlContext, IBgmdDataLockCache dataLockCache, List<String> rowColpartitionDims, List<List<CellDimMember>> rowColPartitionDimMems, String[] members, Map<String, Integer> controlDimNumbers, boolean isrow) {
        List<Pair<Integer, Integer>> pairs = this.genPairs(controlDimNumbers, rowColpartitionDims);
        ISheet sheet = styleControlContext.getEbSpreadManager().getEbook().getSheet(0);
        for (int rowcol = 0; rowcol < rowColPartitionDimMems.size(); ++rowcol) {
            List<CellDimMember> cellDimMembers = rowColPartitionDimMems.get(rowcol);
            if (cellDimMembers == null) continue;
            String[] currentMembers = this.copyMembers(members);
            for (Pair<Integer, Integer> pair : pairs) {
                currentMembers[((Integer)pair.p2).intValue()] = cellDimMembers.get((Integer)pair.p1).getDimMemberNumber();
            }
            if (!dataLockCache.isDataLock(currentMembers)) continue;
            this.doLockSheetByOneAxis(isrow, sheet, rowcol, styleControlContext);
            log.info("locked by DataLockCellLockController " + currentMembers + (isrow ? " row=" : " col=") + rowcol);
        }
    }

    private void genCellDataLockByTwoAxis(SpreadLockContext styleControlContext, IBgmdDataLockCache dataLockCache, String[] members, Map<String, Integer> controlDimNumbers, boolean oneAxisForPre, boolean byRow) {
        IEbSpreadManager ebSpreadManager = styleControlContext.getEbSpreadManager();
        ISheet sheet = ebSpreadManager.getEbook().getSheet(0);
        List<String> colpartitionDims = styleControlContext.getEbSpreadManager().getColpartitionDims();
        List<String> rowpartitionDims = styleControlContext.getEbSpreadManager().getRowpartitionDims();
        List<List<CellDimMember>> colPartitionDimMems = ebSpreadManager.getColpartitionDimMems();
        List<List<CellDimMember>> rowPartitionDimMems = ebSpreadManager.getRowpartitionDimMems();
        List<Pair<Integer, Integer>> rowPairs = this.genPairs(controlDimNumbers, rowpartitionDims);
        List<Pair<Integer, Integer>> colPairs = this.genPairs(controlDimNumbers, colpartitionDims);
        List<List<CellDimMember>> firstPartitionDimMems = byRow ? rowPartitionDimMems : colPartitionDimMems;
        List<Pair<Integer, Integer>> firstPairs = byRow ? rowPairs : colPairs;
        List<List<CellDimMember>> secondPartitionDimMems = byRow ? colPartitionDimMems : rowPartitionDimMems;
        List<Pair<Integer, Integer>> secondPairs = byRow ? colPairs : rowPairs;
        for (int rowcol = 0; rowcol < firstPartitionDimMems.size(); ++rowcol) {
            List<CellDimMember> cellDimMembers = firstPartitionDimMems.get(rowcol);
            if (cellDimMembers == null) continue;
            String[] currentMembers = this.copyMembers(members);
            for (Pair<Integer, Integer> firstPair : firstPairs) {
                currentMembers[((Integer)firstPair.p2).intValue()] = cellDimMembers.get((Integer)firstPair.p1).getDimMemberNumber();
            }
            for (int rowcol2 = 0; rowcol2 < secondPartitionDimMems.size(); ++rowcol2) {
                List<CellDimMember> cellDimMembers2 = secondPartitionDimMems.get(rowcol2);
                if (cellDimMembers2 == null) continue;
                String[] currentMembers2 = this.copyMembers(currentMembers);
                for (Pair<Integer, Integer> secondPair : secondPairs) {
                    CellDimMember cellDimMember = cellDimMembers2.get((Integer)secondPair.p1);
                    if (cellDimMember == null) {
                        return;
                    }
                    currentMembers2[((Integer)secondPair.p2).intValue()] = cellDimMember.getDimMemberNumber();
                }
                if (!dataLockCache.isDataLock(currentMembers2)) continue;
                StyleCell styleCell = byRow ? (StyleCell)sheet.getECell(rowcol, rowcol2) : (StyleCell)sheet.getECell(rowcol2, rowcol);
                this.fillStyleCell(styleCell, styleControlContext);
            }
        }
    }

    private List<Pair<Integer, Integer>> genPairs(Map<String, Integer> controlDimNumbers, List<String> colpartitionDims) {
        ArrayList<Pair<Integer, Integer>> colPairs = new ArrayList<Pair<Integer, Integer>>(10);
        for (int i = 0; i < colpartitionDims.size(); ++i) {
            String dimNumber = colpartitionDims.get(i);
            if (!controlDimNumbers.containsKey(dimNumber)) continue;
            colPairs.add((Pair<Integer, Integer>)new Pair((Object)i, (Object)controlDimNumbers.get(dimNumber)));
        }
        return colPairs;
    }

    private void doLockSheetByOneAxis(boolean isrow, ISheet sheet, int rowcol, SpreadLockContext styleControlContext) {
        if (isrow) {
            for (int col = sheet.getValueAreaColStart(); col < sheet.getRealMaxCols(); ++col) {
                StyleCell styleCell = (StyleCell)sheet.getECell(rowcol, col);
                this.fillStyleCell(styleCell, styleControlContext);
            }
        } else {
            for (int row = sheet.getValueAreaRowStart(); row < sheet.getRealMaxRows(); ++row) {
                StyleCell styleCell = (StyleCell)sheet.getECell(row, rowcol);
                this.fillStyleCell(styleCell, styleControlContext);
            }
        }
    }

    private void fillStyleCell(StyleCell styleCell, SpreadLockContext styleControlContext) {
        styleCell.setLocked(true);
        styleCell.setBackColor("#FFF8E1");
        Set cols = styleControlContext.getLockCells().computeIfAbsent(styleCell.getRow(), t -> new HashSet(16));
        cols.add(styleCell.getCol());
    }

    private boolean tryOnce(List<String> colpartitionDims, String[] members, Map<String, Integer> controlDimNumbers) {
        String[] currentMembers = this.fillCurrentMembers(colpartitionDims, members, controlDimNumbers);
        return this.checkFull(currentMembers);
    }

    private boolean tryAgain(List<String> colpartitionDims, String[] members, Map<String, Integer> controlDimNumbers) {
        String[] currentMembers = this.fillCurrentMembers(colpartitionDims, members, controlDimNumbers);
        return this.checkPre(currentMembers);
    }

    private String[] fillCurrentMembers(List<String> colpartitionDims, String[] members, Map<String, Integer> controlDimNumbers) {
        String[] currentMembers = this.copyMembers(members);
        for (int i = 0; i < colpartitionDims.size(); ++i) {
            String dimNumber = colpartitionDims.get(i);
            if (!controlDimNumbers.containsKey(dimNumber)) continue;
            Integer index = controlDimNumbers.get(dimNumber);
            currentMembers[index.intValue()] = "xxx";
        }
        return currentMembers;
    }

    private String[] copyMembers(String[] members) {
        String[] currentMembers = new String[members.length];
        System.arraycopy(members, 0, currentMembers, 0, members.length);
        return currentMembers;
    }

    private boolean checkPre(String[] members) {
        for (int i = 0; i < members.length; ++i) {
            String member;
            if (i == 4 || (member = members[i]) != null) continue;
            return false;
        }
        return true;
    }

    private boolean checkFull(String[] members) {
        for (String member : members) {
            if (member != null) continue;
            return false;
        }
        return true;
    }
}

