/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.command.lockcontroller.lockcell;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.threadlocal.EpmThreadLocalUtils;
import kd.epm.eb.common.permission.membPerm.DimMemberPermChecker;
import kd.epm.eb.common.permission.membPerm.MemberItem;
import kd.epm.eb.common.permission.pojo.PermDimGroup;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.spread.template.afix.multimanager.MultiAreaManager;
import kd.epm.eb.spread.template.dimension.PageViewDimMember;
import kd.epm.eb.spread.template.spreadmanager.CellDimMember;
import kd.epm.eb.spread.template.spreadmanager.EbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;

public class MemPermControllerHelper {
    public static DimMemberPermChecker getWritePermChecker(IEbSpreadManager ebSpreadManager) {
        return EpmThreadLocalUtils.getWritePermChecker((Long)ebSpreadManager.getModelobj().getId(), (Long)ebSpreadManager.getDatasetid());
    }

    public static List<PermDimGroup> getPermDimGroupsWithData(Long modelId, Long datasetId) {
        return DimMembPermHelper.getPermDimGroupWithData((Long)modelId, (Long)datasetId);
    }

    public static List<PermDimGroup> getPageViewPermGroup(IEbSpreadManager ebSpreadManager) {
        LinkedList<PermDimGroup> result = new LinkedList<PermDimGroup>();
        if (ebSpreadManager != null && ebSpreadManager.getPageViewDims() != null) {
            Set<String> pageViewDimsKeys = ebSpreadManager.getPageViewDims().keySet();
            List dimGroups = DimMembPermHelper.getPermDimGroupWithData((Long)ebSpreadManager.getModelobj().getId(), (Long)ebSpreadManager.getDatasetid());
            if (dimGroups != null && !dimGroups.isEmpty()) {
                HashSet<PermDimGroup> dimGroupsPV = new HashSet<PermDimGroup>(dimGroups.size());
                HashSet<PermDimGroup> dimGroupsRC = new HashSet<PermDimGroup>(dimGroups.size());
                for (PermDimGroup permDimGroup : dimGroups) {
                    boolean hasRowCol = false;
                    for (String dimNum : permDimGroup.getDimNums()) {
                        if (pageViewDimsKeys.contains(dimNum)) continue;
                        hasRowCol = true;
                        break;
                    }
                    if (!hasRowCol) {
                        dimGroupsPV.add(permDimGroup);
                        continue;
                    }
                    dimGroupsRC.add(permDimGroup);
                }
                if (dimGroupsRC.size() > 0) {
                    HashSet<PermDimGroup> dimGroupsToRemove = new HashSet<PermDimGroup>(dimGroups.size());
                    block2: for (PermDimGroup permDimGroupPV : dimGroupsPV) {
                        for (String dimNumber : permDimGroupPV.getDimNums()) {
                            for (PermDimGroup dimGroup : dimGroupsRC) {
                                if (!dimGroup.getDimNums().contains(dimNumber)) continue;
                                dimGroupsToRemove.add(permDimGroupPV);
                                continue block2;
                            }
                        }
                    }
                    dimGroupsPV.removeAll(dimGroupsToRemove);
                }
                if (!dimGroupsPV.isEmpty()) {
                    result.addAll(dimGroupsPV);
                }
            }
        }
        return result;
    }

    public static List<PermDimGroup> getRowColPermGroup(IEbSpreadManager ebSpreadManager, boolean isRow) {
        List<PermDimGroup> permDimGroupsWithData;
        LinkedList<PermDimGroup> result = new LinkedList<PermDimGroup>();
        if (ebSpreadManager != null && (permDimGroupsWithData = MemPermControllerHelper.getPermDimGroupsWithData(ebSpreadManager.getModelobj().getId(), ebSpreadManager.getDatasetid())) != null) {
            List<String> rowDims = ebSpreadManager.getRowpartitionDims();
            List<String> colDims = ebSpreadManager.getColpartitionDims();
            Set<String> pageViewDims = ebSpreadManager.getPageViewDims().keySet();
            for (PermDimGroup permDimGroup : permDimGroupsWithData) {
                List dimNums = permDimGroup.getDimNums();
                boolean inRow = false;
                boolean inCol = false;
                for (String dimNum : dimNums) {
                    if (rowDims.contains(dimNum)) {
                        inRow = true;
                        continue;
                    }
                    if (!colDims.contains(dimNum)) continue;
                    inCol = true;
                }
                if (isRow && inRow && !inCol) {
                    result.add(permDimGroup);
                    continue;
                }
                if (isRow || inRow || !inCol) continue;
                result.add(permDimGroup);
            }
            if (!result.isEmpty()) {
                Iterator it = result.iterator();
                while (it.hasNext()) {
                    PermDimGroup dimGroup = (PermDimGroup)it.next();
                    if (!MemPermControllerHelper.hasRelatedDim(permDimGroupsWithData, dimGroup.getDimNums(), isRow ? colDims : rowDims)) continue;
                    it.remove();
                }
            }
        }
        return result;
    }

    public static List<PermDimGroup> getRowColPermGroup(MultiAreaManager multiAreaManager, boolean isRow, List<PermDimGroup> dimGroups) {
        LinkedList<PermDimGroup> result = new LinkedList<PermDimGroup>();
        if (dimGroups != null && dimGroups.size() > 0 && multiAreaManager != null) {
            List<String> rowDims = multiAreaManager.getRowpartitionDims();
            List<String> colDims = multiAreaManager.getColpartitionDims();
            for (PermDimGroup permDimGroup : dimGroups) {
                List dimNums = permDimGroup.getDimNums();
                boolean inRow = false;
                boolean inCol = false;
                for (String dimNum : dimNums) {
                    if (rowDims.contains(dimNum)) {
                        inRow = true;
                        continue;
                    }
                    if (!colDims.contains(dimNum)) continue;
                    inCol = true;
                }
                if (isRow && inRow && !inCol) {
                    result.add(permDimGroup);
                    continue;
                }
                if (isRow || inRow || !inCol) continue;
                result.add(permDimGroup);
            }
            if (!result.isEmpty()) {
                Iterator it = result.iterator();
                while (it.hasNext()) {
                    PermDimGroup dimGroup = (PermDimGroup)it.next();
                    if (!MemPermControllerHelper.hasRelatedDim(dimGroups, dimGroup.getDimNums(), isRow ? colDims : rowDims)) continue;
                    it.remove();
                }
            }
        }
        return result;
    }

    public static List<PermDimGroup> getCrossRowColPermGroup(EbSpreadManager ebSpreadManager, List<PermDimGroup> dimGroups) {
        LinkedList<PermDimGroup> dimGroupsRowCol;
        block8: {
            HashSet<PermDimGroup> colDimGroups;
            List<String> rowDims;
            block9: {
                if (ebSpreadManager == null || dimGroups == null || dimGroups.isEmpty()) {
                    return null;
                }
                rowDims = ebSpreadManager.getRowpartitionDims();
                List<String> colDims = ebSpreadManager.getColpartitionDims();
                dimGroupsRowCol = new LinkedList<PermDimGroup>();
                HashSet<PermDimGroup> rowDimGroups = new HashSet<PermDimGroup>(16);
                colDimGroups = new HashSet<PermDimGroup>(16);
                for (PermDimGroup permDimGroup : dimGroups) {
                    List dimNums = permDimGroup.getDimNums();
                    boolean inRow = false;
                    boolean inCol = false;
                    for (String dimNum : dimNums) {
                        if (rowDims.contains(dimNum)) {
                            inRow = true;
                            continue;
                        }
                        if (!colDims.contains(dimNum)) continue;
                        inCol = true;
                    }
                    if (inRow && inCol) {
                        dimGroupsRowCol.add(permDimGroup);
                        continue;
                    }
                    if (inRow) {
                        rowDimGroups.add(permDimGroup);
                        continue;
                    }
                    if (!inCol) continue;
                    colDimGroups.add(permDimGroup);
                }
                if (!dimGroupsRowCol.isEmpty()) break block8;
                if (rowDimGroups.size() <= 0) break block9;
                for (PermDimGroup permDimGroup : rowDimGroups) {
                    if (!MemPermControllerHelper.hasRelatedDim(dimGroups, permDimGroup.getDimNums(), colDims)) continue;
                    dimGroupsRowCol.add(permDimGroup);
                    break block8;
                }
                break block8;
            }
            if (colDimGroups.size() <= 0) break block8;
            for (PermDimGroup permDimGroup : colDimGroups) {
                if (!MemPermControllerHelper.hasRelatedDim(dimGroups, permDimGroup.getDimNums(), rowDims)) continue;
                dimGroupsRowCol.add(permDimGroup);
                break;
            }
        }
        return dimGroupsRowCol;
    }

    public static List<PermDimGroup> getCrossRowColPermGroup(MultiAreaManager multiAreaManager, List<PermDimGroup> dimGroups) {
        LinkedList<PermDimGroup> dimGroupsRowCol;
        block8: {
            HashSet<PermDimGroup> colDimGroups;
            List<String> rowDims;
            block9: {
                if (multiAreaManager == null || dimGroups == null || dimGroups.isEmpty()) {
                    return null;
                }
                rowDims = multiAreaManager.getRowpartitionDims();
                List<String> colDims = multiAreaManager.getColpartitionDims();
                dimGroupsRowCol = new LinkedList<PermDimGroup>();
                HashSet<PermDimGroup> rowDimGroups = new HashSet<PermDimGroup>(16);
                colDimGroups = new HashSet<PermDimGroup>(16);
                for (PermDimGroup permDimGroup : dimGroups) {
                    List dimNums = permDimGroup.getDimNums();
                    boolean inRow = false;
                    boolean inCol = false;
                    for (String dimNum : dimNums) {
                        if (rowDims.contains(dimNum)) {
                            inRow = true;
                            continue;
                        }
                        if (!colDims.contains(dimNum)) continue;
                        inCol = true;
                    }
                    if (inRow && inCol) {
                        dimGroupsRowCol.add(permDimGroup);
                        continue;
                    }
                    if (inRow) {
                        rowDimGroups.add(permDimGroup);
                        continue;
                    }
                    if (!inCol) continue;
                    colDimGroups.add(permDimGroup);
                }
                if (!dimGroupsRowCol.isEmpty()) break block8;
                if (rowDimGroups.size() <= 0) break block9;
                for (PermDimGroup permDimGroup : rowDimGroups) {
                    if (!MemPermControllerHelper.hasRelatedDim(dimGroups, permDimGroup.getDimNums(), colDims)) continue;
                    dimGroupsRowCol.add(permDimGroup);
                    break block8;
                }
                break block8;
            }
            if (colDimGroups.size() <= 0) break block8;
            for (PermDimGroup permDimGroup : colDimGroups) {
                if (!MemPermControllerHelper.hasRelatedDim(dimGroups, permDimGroup.getDimNums(), rowDims)) continue;
                dimGroupsRowCol.add(permDimGroup);
                break;
            }
        }
        return dimGroupsRowCol;
    }

    private static boolean hasRelatedDim(List<PermDimGroup> permDimGroupsWithData, List<String> dims1, List<String> dims2) {
        boolean hasRelatedDim = false;
        if (dims1.size() > 0) {
            block0: for (String dim1 : dims1) {
                HashSet<String> relatedDims = new HashSet<String>(16);
                MemPermControllerHelper.getRelatedPermDims(dim1, permDimGroupsWithData, relatedDims);
                for (String dim2 : dims2) {
                    if (!relatedDims.contains(dim2)) continue;
                    hasRelatedDim = true;
                    continue block0;
                }
            }
        }
        return hasRelatedDim;
    }

    public static void getRelatedPermDims(String dimNumber, List<PermDimGroup> dimGroups, Set<String> relatedDims) {
        if (dimNumber != null && dimGroups != null && dimGroups.size() > 0 && relatedDims != null) {
            HashSet<String> newAdded = new HashSet<String>(16);
            for (PermDimGroup dimGroup : dimGroups) {
                if (!dimGroup.getDimNums().contains(dimNumber)) continue;
                for (String dim : dimGroup.getDimNums()) {
                    if (!relatedDims.add(dim)) continue;
                    newAdded.add(dim);
                }
            }
            if (!newAdded.isEmpty()) {
                for (String dimNum : newAdded) {
                    MemPermControllerHelper.getRelatedPermDims(dimNum, dimGroups, relatedDims);
                }
            }
        }
    }

    public static Map<String, Member> getPageViewDimMemIds(IEbSpreadManager ebSpreadManager) {
        HashMap<String, Member> pageViewDimMemIds = new HashMap<String, Member>(16);
        if (ebSpreadManager == null || ebSpreadManager.getPageViewDims() == null) {
            return pageViewDimMemIds;
        }
        Map<String, PageViewDimMember> pageViewDims = ebSpreadManager.getPageViewDims();
        if (pageViewDims != null && pageViewDims.size() > 0) {
            Set<String> pageViewDimsKeys = pageViewDims.keySet();
            IModelCacheHelper modelCacheHelper = ebSpreadManager.getModelCacheHelper();
            if (modelCacheHelper == null) {
                modelCacheHelper = ModelCacheContext.getOrCreate((Long)ebSpreadManager.getModelobj().getId());
            }
            for (String dimNumber : pageViewDimsKeys) {
                Member m;
                Set<String> memNumbers = ebSpreadManager.getAlldimensionWithMembers().get(dimNumber);
                if (memNumbers == null || memNumbers.size() <= 0 || (m = modelCacheHelper.getMember(dimNumber, DimensionViewServiceHelper.getViewId(ebSpreadManager.getDimemsionViews(), (String)dimNumber, null), memNumbers.iterator().next())) == null) continue;
                pageViewDimMemIds.put(dimNumber, m);
            }
        }
        return pageViewDimMemIds;
    }

    public static void putInMemberGroup(Set<String> dimNumSet, Map<String, MemberItem> memberGroup, String dimNumber, Member member) {
        if (dimNumSet != null && memberGroup != null && member != null && dimNumSet.contains(dimNumber)) {
            memberGroup.put(dimNumber, new MemberItem(true, member.getId(), member.getNumber()));
        }
    }

    public static void putInMemberGroup(IModelCacheHelper modelCacheHelper, Map<String, Long> dimViews, List<String> rowColDims, List<CellDimMember> rowColCellDimMembers, Set<String> dimNumSet, Map<String, MemberItem> memberGroup, String partition) {
        int i = 0;
        if (rowColCellDimMembers != null) {
            for (CellDimMember cellDimMember : rowColCellDimMembers) {
                String part;
                Member member;
                if (cellDimMember == null) break;
                if (cellDimMember.isProperty()) continue;
                String dimNumber = rowColDims.get(i);
                String memNumber = cellDimMember.getDimMemberNumber();
                ++i;
                if (memNumber == null || !dimNumSet.contains(dimNumber) || (member = MemPermControllerHelper.getMemberId(modelCacheHelper, dimNumber, memNumber, part = partition == null ? cellDimMember.getPartition() : partition, dimViews)) == null) continue;
                MemPermControllerHelper.putInMemberGroup(dimNumSet, memberGroup, dimNumber, member);
            }
        }
    }

    public static Member getMemberId(IModelCacheHelper modelCacheHelper, String dimNumber, String memNumber, String partNum, Map<String, Long> dimViews) {
        Member member;
        if (modelCacheHelper != null && dimNumber != null && memNumber != null && dimViews != null && (member = modelCacheHelper.getMember(dimNumber, DimensionViewServiceHelper.getViewId(dimViews, (String)dimNumber, (String)partNum), memNumber)) != null) {
            return member;
        }
        return null;
    }
}

