/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.command.lockcontroller.lockcell;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.DimMembPermHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.threadlocal.EpmThreadLocalUtils;
import kd.epm.eb.common.permission.membPerm.DimMemberPermChecker;
import kd.epm.eb.common.permission.membPerm.MemberItem;
import kd.epm.eb.common.permission.pojo.PermDimGroup;
import kd.epm.eb.spread.adaptor.OlapQuerySync;
import kd.epm.eb.spread.command.lockcontroller.SpreadLockContext;
import kd.epm.eb.spread.command.lockcontroller.lockcell.MemPermControllerHelper;
import kd.epm.eb.spread.command.rangedefined.CellArea;
import kd.epm.eb.spread.command.style.AreasStyle;
import kd.epm.eb.spread.command.stylecontroller.FixSpreadStyleControlContext;
import kd.epm.eb.spread.command.stylecontroller.ISpreadStyleControl;
import kd.epm.eb.spread.command.stylecontroller.SpreadStyleControlContext;
import kd.epm.eb.spread.template.afix.multimanager.MultiAreaManager;
import kd.epm.eb.spread.template.dimension.PageViewDimMember;
import kd.epm.eb.spread.template.spreadmanager.CellDimMember;
import kd.epm.eb.spread.template.spreadmanager.EbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.fix.FixSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;

public class MemPermStyleController
implements ISpreadStyleControl {
    private static final Log log = LogFactory.getLog(MemPermStyleController.class);
    private OlapQuerySync.ViewArea viewArea = null;
    private Set<Integer> refreshRows = null;
    private List<PermDimGroup> permDimGroupsWithData = null;
    private IModelCacheHelper modelCacheHelper = null;

    public MemPermStyleController(OlapQuerySync.ViewArea viewArea, Set<Integer> refreshRows) {
        this.viewArea = viewArea;
        this.refreshRows = refreshRows;
    }

    @Override
    public void control(SpreadStyleControlContext styleControlContext) {
        List<PermDimGroup> dimGroupsRowCol;
        EbSpreadManager ebSpreadManager = (EbSpreadManager)styleControlContext.getEbSpreadManager();
        DimMemberPermChecker writePermChecker = DimMembPermHelper.getWritePermChecker((Long)ebSpreadManager.getModelobj().getId(), (Long)ebSpreadManager.getDatasetid());
        if (writePermChecker != null && !writePermChecker.hasAllPerm() && (dimGroupsRowCol = MemPermControllerHelper.getCrossRowColPermGroup(ebSpreadManager, this.getPermDimGroupsWithData(ebSpreadManager.getModelobj().getId(), ebSpreadManager.getDatasetid()))) != null && dimGroupsRowCol.size() > 0 && ebSpreadManager != null) {
            this.memPermControl_dy(styleControlContext, writePermChecker, dimGroupsRowCol, this.viewArea);
        }
    }

    @Override
    public void controlFix(FixSpreadStyleControlContext fixSpreadStyleControlContext) {
        Long datasetId;
        FixSpreadManager fixSpreadManager = (FixSpreadManager)fixSpreadStyleControlContext.getEbSpreadManager();
        Long modelId = fixSpreadManager.getModelobj().getId();
        DimMemberPermChecker writePermChecker = EpmThreadLocalUtils.getWritePermChecker((Long)modelId, (Long)(datasetId = fixSpreadManager.getDatasetid()));
        if (writePermChecker != null && !writePermChecker.hasAllPerm()) {
            this.permDimGroupsWithData = this.getPermDimGroupsWithData(modelId, datasetId);
            if (this.permDimGroupsWithData != null && !this.permDimGroupsWithData.isEmpty()) {
                this.memPermControl_fix(fixSpreadStyleControlContext, writePermChecker, this.viewArea);
            }
        }
    }

    private void memPermControl_dy(SpreadStyleControlContext styleControlContext, DimMemberPermChecker writePermChecker, List<PermDimGroup> dimGroupsRowCol, OlapQuerySync.ViewArea viewArea) {
        if (styleControlContext == null || writePermChecker == null || dimGroupsRowCol == null) {
            return;
        }
        HashSet<ECell> lockedCells = new HashSet<ECell>(16);
        EbSpreadManager ebSpreadManager = (EbSpreadManager)styleControlContext.getEbSpreadManager();
        Map<String, Long> dimViews = ebSpreadManager.getDimemsionViews();
        List<String> rowDims = ebSpreadManager.getRowpartitionDims();
        List<String> colDims = ebSpreadManager.getColpartitionDims();
        List<List<CellDimMember>> rowDimMembers = ebSpreadManager.getRowpartitionDimMems();
        List<List<CellDimMember>> colDimMembers = ebSpreadManager.getColpartitionDimMems();
        Map<String, Member> pageViewDimMemIds = MemPermControllerHelper.getPageViewDimMemIds(ebSpreadManager);
        int startRow = 0;
        int endRow = rowDimMembers.size();
        if (viewArea != null) {
            startRow = viewArea.getStartrow();
            endRow = viewArea.getEndrow();
        }
        if (dimGroupsRowCol != null && dimGroupsRowCol.size() > 0) {
            HashSet<String> dimNumSet = new HashSet<String>(16);
            dimNumSet.addAll(ebSpreadManager.getPageViewDims().keySet());
            dimNumSet.addAll(rowDims);
            dimNumSet.addAll(colDims);
            HashMap<String, MemberItem> memberGroup = new HashMap<String, MemberItem>(16);
            pageViewDimMemIds.forEach((k, v) -> memberGroup.put((String)k, new MemberItem(true, v.getId(), v.getNumber())));
            for (int row = startRow; row < endRow; ++row) {
                List<CellDimMember> rowCellDimMembers = rowDimMembers.get(row);
                if (rowCellDimMembers == null || rowCellDimMembers.size() == 0 || this.refreshRows != null && this.refreshRows.contains(row)) continue;
                MemPermControllerHelper.putInMemberGroup(this.getModelCacheHelper(ebSpreadManager), dimViews, rowDims, rowCellDimMembers, dimNumSet, memberGroup, null);
                for (int col = 0; col < colDimMembers.size(); ++col) {
                    List<CellDimMember> colCellDimMembers = colDimMembers.get(col);
                    if (colCellDimMembers == null || colCellDimMembers.size() == 0) continue;
                    MemPermControllerHelper.putInMemberGroup(this.getModelCacheHelper(ebSpreadManager), dimViews, colDims, colCellDimMembers, dimNumSet, memberGroup, null);
                    if (writePermChecker.check(memberGroup)) continue;
                    lockedCells.add(new ECell(row, col));
                    log.info(String.format("locked by writePermChecker.check %s (%s,%s)", ((Object)memberGroup).toString(), row, col));
                }
            }
        }
        if (lockedCells.size() > 0) {
            styleControlContext.getAreasStyles().add(this.getLockAreaStyle(lockedCells));
        }
    }

    private void memPermControl_fix(FixSpreadStyleControlContext fixSpreadStyleControlContext, DimMemberPermChecker writePermChecker, OlapQuerySync.ViewArea viewArea) {
        if (fixSpreadStyleControlContext == null || writePermChecker == null) {
            return;
        }
        HashSet<ECell> lockedCells = new HashSet<ECell>(16);
        FixSpreadManager fixSpreadManager = (FixSpreadManager)fixSpreadStyleControlContext.getEbSpreadManager();
        Map<String, Long> dimViews = fixSpreadManager.getDimemsionViews();
        Map<String, Member> pageViewDimMemIds = MemPermControllerHelper.getPageViewDimMemIds(fixSpreadManager);
        HashSet<String> lockedAreas = new HashSet<String>(16);
        for (MultiAreaManager multiAreaManager : fixSpreadManager.getMultiAreaManager()) {
            HashMap<String, MemberItem> memberGroup;
            HashSet<String> dimNumSet;
            List<PermDimGroup> dimGroupsPageView;
            String areaIndex = multiAreaManager.getAreaIndex();
            if (lockedAreas.contains(areaIndex)) continue;
            MultiAreaManager.ValueArea valueArea = multiAreaManager.getValueAreaStart();
            int dataRowStart = valueArea.getData_row_start();
            int dataColStart = valueArea.getData_col_start();
            int rows = multiAreaManager.getAreaRange().getY_end() - valueArea.getData_row_start() + 1;
            int cols = multiAreaManager.getAreaRange().getX_end() - valueArea.getData_col_start() + 1;
            List<String> rowDims = multiAreaManager.getRowpartitionDims();
            List<String> colDims = multiAreaManager.getColpartitionDims();
            List<List<CellDimMember>> rowdimmems = multiAreaManager.getRowpartitionDimMems();
            List<List<CellDimMember>> coldimmems = multiAreaManager.getColpartitionDimMems();
            Map<String, PageViewDimMember> apvDimMemberMap = multiAreaManager.getAreaPageViewDims();
            if (apvDimMemberMap != null && apvDimMemberMap.size() > 0 && (dimGroupsPageView = this.getDimGroupsPageView(multiAreaManager, this.getPermDimGroupsWithData(fixSpreadManager.getModelobj().getId(), fixSpreadManager.getDatasetid()))) != null && dimGroupsPageView.size() > 0) {
                dimNumSet = new HashSet(16);
                dimNumSet.addAll(fixSpreadManager.getPageViewDims().keySet());
                dimNumSet.addAll(apvDimMemberMap.keySet());
                memberGroup = new HashMap<String, MemberItem>(16);
                pageViewDimMemIds.forEach((k, v) -> memberGroup.put((String)k, new MemberItem(true, v.getId(), v.getNumber())));
                for (Map.Entry<String, PageViewDimMember> entry : apvDimMemberMap.entrySet()) {
                    PageViewDimMember pageViewDimMember = entry.getValue();
                    if (pageViewDimMember == null) continue;
                    MemPermControllerHelper.putInMemberGroup(dimNumSet, memberGroup, entry.getKey(), MemPermControllerHelper.getMemberId(this.getModelCacheHelper(fixSpreadManager), entry.getKey(), entry.getValue().getNumber(), areaIndex, dimViews));
                }
                if (!writePermChecker.check(memberGroup)) {
                    AreasStyle areasStyle = this.getLockAreaStyle();
                    if (areasStyle.getRange() == null) {
                        areasStyle.setRange(new ArrayList<CellArea>());
                    }
                    areasStyle.getRange().add(new CellArea(valueArea.getData_row_start(), valueArea.getData_col_start(), rows, cols));
                    fixSpreadStyleControlContext.getAreasStyles().add(areasStyle);
                    lockedAreas.add(areaIndex);
                    log.info(multiAreaManager.getAreaRange() + " locked by writePermChecker.check " + ((Object)memberGroup).toString());
                    continue;
                }
            }
            List<PermDimGroup> dimGroupsRowCol = MemPermControllerHelper.getCrossRowColPermGroup(multiAreaManager, this.getPermDimGroupsWithData(fixSpreadManager.getModelobj().getId(), fixSpreadManager.getDatasetid()));
            if (rowdimmems == null || dimGroupsRowCol == null || dimGroupsRowCol.size() <= 0) continue;
            dimNumSet = new HashSet<String>(16);
            dimNumSet.addAll(fixSpreadManager.getPageViewDims().keySet());
            dimNumSet.addAll(rowDims);
            dimNumSet.addAll(colDims);
            memberGroup = new HashMap(16);
            pageViewDimMemIds.forEach((k, v) -> memberGroup.put((String)k, new MemberItem(true, v.getId(), v.getNumber())));
            for (int row = 0; row < rowdimmems.size(); ++row) {
                int absRow = row + dataRowStart;
                if (rowdimmems.get(row) == null || rowdimmems.get(row).isEmpty() || this.refreshRows != null && this.refreshRows.contains(absRow) || viewArea != null && (absRow < viewArea.getStartrow() || absRow > viewArea.getEndrow())) continue;
                MemPermControllerHelper.putInMemberGroup(this.getModelCacheHelper(fixSpreadManager), dimViews, rowDims, rowdimmems.get(row), dimNumSet, memberGroup, areaIndex);
                for (int col = 0; col < coldimmems.size(); ++col) {
                    MemPermControllerHelper.putInMemberGroup(this.getModelCacheHelper(fixSpreadManager), dimViews, colDims, coldimmems.get(col), dimNumSet, memberGroup, areaIndex);
                    if (writePermChecker.check(memberGroup)) continue;
                    lockedCells.add(new ECell(row + dataRowStart, col + dataColStart));
                    log.info(multiAreaManager.getAreaRange() + " locked by writePermChecker.check " + ((Object)memberGroup).toString() + " (" + row + dataRowStart + "," + col + dataColStart + ")");
                }
            }
        }
        if (lockedCells.size() > 0) {
            fixSpreadStyleControlContext.getAreasStyles().add(this.getLockAreaStyle(lockedCells));
        }
    }

    public List<PermDimGroup> getPermDimGroupsWithData(Long modelId, Long datasetId) {
        if (this.permDimGroupsWithData == null) {
            this.permDimGroupsWithData = DimMembPermHelper.getPermDimGroupWithData((Long)modelId, (Long)datasetId);
        }
        return this.permDimGroupsWithData;
    }

    private List<PermDimGroup> getDimGroupsPageView(MultiAreaManager multiAreaManager, List<PermDimGroup> dimGroups) {
        if (multiAreaManager == null || dimGroups == null || dimGroups.isEmpty()) {
            return null;
        }
        LinkedList<PermDimGroup> result = new LinkedList<PermDimGroup>();
        List<String> rowDims = multiAreaManager.getRowpartitionDims();
        List<String> colDims = multiAreaManager.getColpartitionDims();
        HashSet<PermDimGroup> dimGroupsPV = new HashSet<PermDimGroup>(dimGroups.size());
        HashSet<PermDimGroup> dimGroupsRC = new HashSet<PermDimGroup>(dimGroups.size());
        for (PermDimGroup permDimGroup : dimGroups) {
            List dimNums = permDimGroup.getDimNums();
            boolean inRow = false;
            boolean inCol = false;
            for (String dimNum : dimNums) {
                if (rowDims.contains(dimNum)) {
                    inRow = true;
                    continue;
                }
                if (!colDims.contains(dimNum)) continue;
                inCol = true;
            }
            if (!inRow && !inCol) {
                dimGroupsPV.add(permDimGroup);
                continue;
            }
            dimGroupsRC.add(permDimGroup);
        }
        if (dimGroupsRC.size() > 0) {
            HashSet<PermDimGroup> dimGroupsToRemove = new HashSet<PermDimGroup>(dimGroups.size());
            block2: for (PermDimGroup permDimGroupPV : dimGroupsPV) {
                for (String dimNumber : permDimGroupPV.getDimNums()) {
                    for (PermDimGroup dimGroup : dimGroupsRC) {
                        if (!dimGroup.getDimNums().contains(dimNumber)) continue;
                        dimGroupsToRemove.add(permDimGroupPV);
                        continue block2;
                    }
                }
            }
            dimGroupsPV.removeAll(dimGroupsToRemove);
        }
        if (!dimGroupsPV.isEmpty()) {
            result.addAll(dimGroupsPV);
        }
        return result;
    }

    private AreasStyle getLockAreaStyle(Set<ECell> lockedCells) {
        AreasStyle areasStyle = this.getLockAreaStyle();
        if (lockedCells != null) {
            ArrayList<CellArea> styleRange = new ArrayList<CellArea>(lockedCells.size());
            for (ECell cell : lockedCells) {
                styleRange.add(new CellArea(cell.getRow(), cell.getCol(), 1, 1));
            }
            areasStyle.setRange(styleRange);
        }
        return areasStyle;
    }

    private AreasStyle getLockAreaStyle() {
        return new SpreadLockContext(null, null).getAreaStyle(null, null);
    }

    public IModelCacheHelper getModelCacheHelper(IEbSpreadManager ebSpreadManager) {
        if (this.modelCacheHelper == null && ebSpreadManager != null) {
            this.modelCacheHelper = ebSpreadManager.getModelCacheHelper();
            if (this.modelCacheHelper == null) {
                this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)ebSpreadManager.getModelobj().getId());
            }
        }
        return this.modelCacheHelper;
    }
}

