/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.command.lockcontroller.lockcell;

import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.AuditTrailUseEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.permission.IMemberPermCache;
import kd.epm.eb.common.permission.membPerm.DimMemberPermChecker;
import kd.epm.eb.common.permission.membPerm.MemberItem;
import kd.epm.eb.common.permission.pojo.PermDimGroup;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.spread.command.lockcontroller.ISpreadLockControl;
import kd.epm.eb.spread.command.lockcontroller.SpreadLockContext;
import kd.epm.eb.spread.command.lockcontroller.lockcell.MemPermControllerHelper;
import kd.epm.eb.spread.template.spreadmanager.CellDimMember;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import kd.epm.eb.spread.template.spreadmanager.sheet.StyleCell;

public class NoLeafCellLockController
implements ISpreadLockControl {
    private static final Log log = LogFactory.getLog(NoLeafCellLockController.class);
    private Set<String> offsetAuditTrails = null;

    @Override
    public void control(SpreadLockContext styleControlContext) {
        if (styleControlContext == null || styleControlContext.getEbSpreadManager() == null) {
            return;
        }
        IEbSpreadManager ebSpreadManager = styleControlContext.getEbSpreadManager();
        this.checkRowColsLock(ebSpreadManager.getColpartitionDimMems(), styleControlContext, false);
        this.checkRowColsLock(ebSpreadManager.getRowpartitionDimMems(), styleControlContext, true);
    }

    private void checkRowColsLock(List<List<CellDimMember>> rowcoldimmems, SpreadLockContext styleControlContext, boolean isrow) {
        IMemberPermCache memberPermCache = styleControlContext.getEbSpreadManager().getMemberPerm();
        IEbSpreadManager ebSpreadManager = styleControlContext.getEbSpreadManager();
        DimMemberPermChecker writePermChecker = MemPermControllerHelper.getWritePermChecker(ebSpreadManager);
        boolean needCheckMemPerm = writePermChecker != null && !writePermChecker.hasAllPerm();
        List<PermDimGroup> permDimGroups = null;
        Map<String, Member> pageViewDimMemIds = null;
        IModelCacheHelper modelCacheHelper = ebSpreadManager.getModelCacheHelper();
        if (modelCacheHelper == null) {
            modelCacheHelper = ModelCacheContext.getOrCreate((Long)ebSpreadManager.getModelobj().getId());
        }
        Set needCheckAnalyseView = modelCacheHelper.getDimensionList().stream().filter(dimension -> !dimension.isPreset() || SysDimensionEnum.Entity.getNumber().equals(dimension.getNumber())).map(BaseCache::getNumber).collect(Collectors.toSet());
        Map<String, Long> dimensionViews = null;
        if (ebSpreadManager != null) {
            dimensionViews = ebSpreadManager.getDimemsionViews();
        }
        List<String> dimnumbers = null;
        dimnumbers = !isrow ? ebSpreadManager.getColpartitionDims() : ebSpreadManager.getRowpartitionDims();
        ISheet sheet = ebSpreadManager.getEbook().getSheet(0);
        List<String> rowDims = ebSpreadManager.getRowpartitionDims();
        List<String> colDims = ebSpreadManager.getColpartitionDims();
        for (int rowcol = 0; rowcol < rowcoldimmems.size(); ++rowcol) {
            Set cols;
            StyleCell styleCell;
            List<CellDimMember> cellDimMembers = rowcoldimmems.get(rowcol);
            if (cellDimMembers == null || cellDimMembers.size() == 0) continue;
            boolean lock = false;
            int i = 0;
            for (CellDimMember cellDimMember : cellDimMembers) {
                boolean offsetAT;
                String dimnumber = dimnumbers.get(i);
                String memNumber = cellDimMember.getDimMemberNumber();
                Long viewId = DimensionViewServiceHelper.getViewId(dimensionViews, (String)dimnumber, (String)cellDimMember.getPartition());
                ++i;
                boolean changeType = SysDimensionEnum.ChangeType.getNumber().equals(dimnumber) && ("Occupation".equals(memNumber) || "Execute".equals(memNumber));
                boolean noWritePerm = !memberPermCache.hasWritePerm(dimnumber, memNumber, viewId);
                boolean offsetOrg = memNumber != null && memNumber.endsWith("offsetentry") && SysDimensionEnum.Entity.getNumber().equals(dimnumber);
                boolean bl = offsetAT = SysDimensionEnum.AuditTrail.getNumber().equals(dimnumber) && this.isOffsetAuditTrail(memNumber, styleControlContext);
                if (!changeType && !noWritePerm && !offsetOrg && !offsetAT) continue;
                lock = true;
                log.info("locked by " + (changeType ? "changeType" : (noWritePerm ? "noWritePerm" : (offsetOrg ? "offsetOrg" : (offsetAT ? "offsetAT" : "notPossible")))) + (isrow ? " row=" : " col=") + rowcol + " dimNumber=" + dimnumber + " memNumber=" + memNumber);
                break;
            }
            if (!lock && needCheckMemPerm) {
                if (permDimGroups == null) {
                    permDimGroups = MemPermControllerHelper.getRowColPermGroup(styleControlContext.getEbSpreadManager(), isrow);
                }
                for (PermDimGroup permDimGroup : permDimGroups) {
                    List<String> dimnumbers_otherside;
                    List<String> list = dimnumbers_otherside = isrow ? colDims : rowDims;
                    if (dimnumbers_otherside.stream().anyMatch(e -> permDimGroup.getDimNums().contains(e))) continue;
                    HashSet<String> dimNumSet = new HashSet<String>(permDimGroup.getDimNums());
                    dimNumSet.addAll(isrow ? rowDims : colDims);
                    HashMap<String, MemberItem> memberGroup = new HashMap<String, MemberItem>(16);
                    if (pageViewDimMemIds == null) {
                        pageViewDimMemIds = MemPermControllerHelper.getPageViewDimMemIds(ebSpreadManager);
                    }
                    pageViewDimMemIds.forEach((k, v) -> memberGroup.put((String)k, new MemberItem(true, v.getId(), v.getNumber())));
                    MemPermControllerHelper.putInMemberGroup(modelCacheHelper, dimensionViews, isrow ? rowDims : colDims, cellDimMembers, dimNumSet, memberGroup, null);
                    if (writePermChecker.check(memberGroup)) continue;
                    lock = true;
                    log.info("locked by writePermChecker.check " + ((Object)memberGroup).toString() + (isrow ? " row=" : " col=") + rowcol);
                    break;
                }
            }
            if (!lock) continue;
            if (isrow) {
                for (int col = sheet.getValueAreaColStart(); col < sheet.getRealMaxCols(); ++col) {
                    styleCell = (StyleCell)sheet.getECell(rowcol, col);
                    styleCell.setLocked(true);
                    styleCell.setBackColor("#FFF8E1");
                    cols = styleControlContext.getLockCells().computeIfAbsent(rowcol, t -> new HashSet(16));
                    cols.add(col);
                }
                continue;
            }
            for (int row = sheet.getValueAreaRowStart(); row < sheet.getRealMaxRows(); ++row) {
                styleCell = (StyleCell)sheet.getECell(row, rowcol);
                styleCell.setLocked(true);
                styleCell.setBackColor("#FFF8E1");
                cols = styleControlContext.getLockCells().computeIfAbsent(row, t -> new HashSet(16));
                cols.add(rowcol);
            }
        }
    }

    private boolean isOffsetAuditTrail(String memNumber, SpreadLockContext styleControlContext) {
        if (this.offsetAuditTrails == null) {
            IModelCacheHelper modelCacheHelper = styleControlContext.getEbSpreadManager().getModelCacheHelper();
            if (modelCacheHelper == null && styleControlContext.getEbSpreadManager().getModelobj() != null) {
                modelCacheHelper = ModelCacheContext.getOrCreate((Long)styleControlContext.getEbSpreadManager().getModelobj().getId());
            }
            if (modelCacheHelper != null) {
                this.offsetAuditTrails = modelCacheHelper.getMembers(SysDimensionEnum.AuditTrail.getNumber()).stream().filter(e -> AuditTrailUseEnum.AUTO_OFFSET.getCode().equals(e.getAuditTrailUse()) || AuditTrailUseEnum.DECOMPOSE.getCode().equals(e.getAuditTrailUse())).map(BaseCache::getNumber).collect(Collectors.toSet());
                return this.offsetAuditTrails.contains(memNumber);
            }
        } else {
            return this.offsetAuditTrails.contains(memNumber);
        }
        return false;
    }
}

