/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.command.lockcontroller.lockcell;

import com.google.common.collect.Maps;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.utils.StringUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.decompose.entity.AdjustParam;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.MetricUtils;
import kd.epm.eb.common.utils.adjustdecompose.AdjustServiceHelper;
import kd.epm.eb.spread.template.afix.multimanager.MultiAreaManager;
import kd.epm.eb.spread.template.dimension.PageViewDimMember;
import kd.epm.eb.spread.template.spreadmanager.CellDimMember;
import kd.epm.eb.spread.template.spreadmanager.EbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;

public class NoLeafStorageLockControllerHelper {
    private final String dimNumber = SysDimensionEnum.Metric.getNumber();
    private Set<String> memNumbers = new HashSet<String>(16);
    private boolean dimInPageView;
    private boolean editMemInPageView;
    private boolean noleafInPageView;
    private boolean wholePageCanEdit;
    private boolean wholePageLock;
    private boolean dimInAreaPageView;
    private boolean editMemInAreaPageView;
    private boolean wholeAreaCanEdit;
    private boolean wholeAreaLock;
    private boolean noleafInAreaPageView;
    private boolean dimInRow;
    private boolean dimInCol;
    private final Set<Integer> lockRows = new LinkedHashSet<Integer>(16);
    private final Set<Integer> lockCols = new LinkedHashSet<Integer>(16);
    private final Map<Integer, Set<Integer>> lockRowCols = new LinkedHashMap<Integer, Set<Integer>>(16);
    private final Map<Integer, Set<Integer>> lockColRows = new LinkedHashMap<Integer, Set<Integer>>(16);
    private AdjustParam adjustParam;
    private boolean hasNotLeafAndNotInAdjusrDim = false;
    private boolean editNoLeafCell = false;
    private boolean approveAdjust = false;
    boolean pageMeticHasAgg = false;
    private final Map<String, Boolean> isBaseLeafCache = Maps.newLinkedHashMap();

    public NoLeafStorageLockControllerHelper init(IEbSpreadManager ebSpreadManager, Boolean approveAdjust) {
        this.approveAdjust = approveAdjust;
        if (ebSpreadManager != null) {
            Set<String> membersFromSpread = ebSpreadManager.getAlldimensionWithMembers().get(this.dimNumber);
            this.memNumbers = MetricUtils.getMetricNumbersStorageNoDetail((Long)ebSpreadManager.getModelobj().getId());
            if (membersFromSpread != null) {
                this.memNumbers.removeIf(e -> !membersFromSpread.contains(e));
            }
            Long modelId = ebSpreadManager.getModelobj().getId();
            this.adjustParam = CommonUtils.getAdjustParam((Long)modelId);
            this.editNoLeafCell = CommonUtils.editNoLeafCell((Long)ebSpreadManager.getModelobj().getId());
            this.wholePageLock = false;
            if (approveAdjust.booleanValue() && !this.adjustParam.isApproveedit()) {
                this.wholePageLock = true;
                return this;
            }
            for (Map.Entry<String, PageViewDimMember> entry : ebSpreadManager.getPageViewDims().entrySet()) {
                if (!entry.getKey().equals(this.dimNumber)) continue;
                this.dimInPageView = true;
                if (entry.getValue() == null) continue;
                if (this.memNumbers.contains(entry.getValue().getNumber())) {
                    this.editMemInPageView = true;
                    continue;
                }
                this.pageMeticHasAgg = AdjustServiceHelper.checkMeticHasAgg((String)entry.getValue().getNumber(), (IModelCacheHelper)ebSpreadManager.getModelCacheHelper());
            }
            if (this.editMemInPageView && approveAdjust.booleanValue() && this.adjustParam.isApproveeditnoleafcell() && this.adjustParam.isAdjustleaf() || this.editMemInPageView && this.editNoLeafCell) {
                this.wholePageCanEdit = true;
                return this;
            }
            for (Map.Entry<String, PageViewDimMember> entry : ebSpreadManager.getPageViewDims().entrySet()) {
                if (!this.isNoLeaf(entry.getValue(), entry.getKey(), ebSpreadManager.getModelCacheHelper(), ebSpreadManager.getDimemsionViews(), null)) continue;
                this.noleafInPageView = true;
                if (approveAdjust.booleanValue()) {
                    if (!this.adjustParam.getDims().contains(entry.getKey())) {
                        this.hasNotLeafAndNotInAdjusrDim = true;
                        if (!this.adjustParam.isApproveeditnoleafcell()) {
                            this.wholePageLock = true;
                            return this;
                        }
                    }
                    if (this.pageMeticHasAgg) {
                        if (this.adjustParam.getDims().contains(entry.getKey())) continue;
                        this.wholePageLock = true;
                        return this;
                    }
                    if (this.editMemInPageView) {
                        if (this.adjustParam.isApproveeditnoleafcell()) continue;
                        this.wholePageLock = true;
                        return this;
                    }
                    if (!this.dimInPageView) continue;
                    this.wholePageLock = true;
                    return this;
                }
                if (this.editNoLeafCell && !this.memNumbers.isEmpty() && (!this.dimInPageView || this.editMemInPageView)) continue;
                this.wholePageLock = true;
                break;
            }
            if (this.wholePageLock) {
                return this;
            }
            if (ebSpreadManager instanceof EbSpreadManager) {
                int dimIndex;
                List<String> rowDims = ebSpreadManager.getRowpartitionDims();
                List<String> colDims = ebSpreadManager.getColpartitionDims();
                this.dimInRow = rowDims.contains(this.dimNumber);
                this.dimInCol = colDims.contains(this.dimNumber);
                int n = dimIndex = this.dimInRow ? rowDims.indexOf(this.dimNumber) : colDims.indexOf(this.dimNumber);
                if (dimIndex >= 0) {
                    this.initRowRoCol(ebSpreadManager, null);
                }
            }
        }
        return this;
    }

    private void initRowRoCol(IEbSpreadManager ebSpreadManager, MultiAreaManager multiAreaManager) {
        List<String> colDims;
        List<String> rowDims;
        List<List<CellDimMember>> colDimMems;
        List<List<CellDimMember>> rowDimMems;
        if (this.dimInRow || this.dimInPageView || this.dimInAreaPageView) {
            if (multiAreaManager != null) {
                rowDimMems = multiAreaManager.getRowpartitionDimMems();
                colDimMems = multiAreaManager.getColpartitionDimMems();
                rowDims = multiAreaManager.getRowpartitionDims();
                colDims = multiAreaManager.getColpartitionDims();
                ebSpreadManager = multiAreaManager.getEbSpreadManager();
            } else {
                rowDimMems = ebSpreadManager.getRowpartitionDimMems();
                colDimMems = ebSpreadManager.getColpartitionDimMems();
                rowDims = ebSpreadManager.getRowpartitionDims();
                colDims = ebSpreadManager.getColpartitionDims();
            }
        } else if (multiAreaManager != null) {
            rowDimMems = multiAreaManager.getColpartitionDimMems();
            colDimMems = multiAreaManager.getRowpartitionDimMems();
            rowDims = multiAreaManager.getColpartitionDims();
            colDims = multiAreaManager.getRowpartitionDims();
            ebSpreadManager = multiAreaManager.getEbSpreadManager();
        } else {
            rowDimMems = ebSpreadManager.getColpartitionDimMems();
            colDimMems = ebSpreadManager.getRowpartitionDimMems();
            rowDims = ebSpreadManager.getColpartitionDims();
            colDims = ebSpreadManager.getRowpartitionDims();
        }
        LinkedHashMap metricAggMap = Maps.newLinkedHashMap();
        IModelCacheHelper modelCacheHelper = ebSpreadManager.getModelCacheHelper();
        Map<String, Long> dimensionViews = ebSpreadManager.getDimemsionViews();
        LinkedHashMap colLockedCache = Maps.newLinkedHashMap();
        int dimIndex = rowDims.indexOf(this.dimNumber);
        for (int i = 0; i < rowDimMems.size(); ++i) {
            String areaIndex;
            String dim;
            CellDimMember cellDimMember;
            int index;
            boolean hasAgg;
            boolean noLeafEditMember;
            boolean isRowLeaf = multiAreaManager != null ? !this.noleafInPageView && !this.noleafInAreaPageView : !this.noleafInPageView;
            List<CellDimMember> oneRowMems = rowDimMems.get(i);
            if (oneRowMems == null) continue;
            oneRowMems = oneRowMems.stream().filter(e -> e == null || !e.isProperty()).collect(Collectors.toList());
            if (rowDims.size() > oneRowMems.size() || oneRowMems.size() <= dimIndex) continue;
            if (this.dimInPageView || this.dimInAreaPageView) {
                noLeafEditMember = this.editMemInPageView || this.editMemInAreaPageView;
                hasAgg = this.pageMeticHasAgg;
            } else {
                CellDimMember meticMember = oneRowMems.get(dimIndex);
                if (meticMember == null || StringUtils.isEmpty((CharSequence)meticMember.getDimMemberNumber())) continue;
                hasAgg = metricAggMap.computeIfAbsent(meticMember.getDimMemberNumber(), f -> AdjustServiceHelper.checkMeticHasAgg((String)meticMember.getDimMemberNumber(), (IModelCacheHelper)modelCacheHelper));
                noLeafEditMember = this.isNoLeafEditMember(meticMember);
            }
            boolean lockRow = false;
            boolean editRow = false;
            if (this.approveAdjust) {
                if (noLeafEditMember && this.adjustParam.isApproveeditnoleafcell() && this.adjustParam.isAdjustleaf()) {
                    editRow = true;
                } else if (this.hasNotLeafAndNotInAdjusrDim && !noLeafEditMember) {
                    lockRow = true;
                } else {
                    for (index = 0; index < oneRowMems.size(); ++index) {
                        cellDimMember = oneRowMems.get(index);
                        if (cellDimMember == null || StringUtils.isEmpty((CharSequence)cellDimMember.getDimMemberNumber())) {
                            editRow = true;
                        } else {
                            dim = rowDims.get(index);
                            areaIndex = null;
                            if (multiAreaManager != null) {
                                areaIndex = multiAreaManager.getAreaIndex();
                            }
                            if (!this.isNoLeaf(cellDimMember, dim, modelCacheHelper, dimensionViews, areaIndex)) continue;
                            isRowLeaf = false;
                            if (hasAgg) {
                                if (this.adjustParam.getDims().contains(dim)) continue;
                                lockRow = true;
                            } else if (noLeafEditMember) {
                                if (this.adjustParam.isApproveeditnoleafcell()) continue;
                                lockRow = true;
                            } else {
                                lockRow = true;
                            }
                        }
                        break;
                    }
                }
            } else if (noLeafEditMember && this.editNoLeafCell) {
                editRow = true;
            } else if ((this.noleafInPageView || this.noleafInAreaPageView) && !noLeafEditMember) {
                lockRow = true;
            } else {
                for (index = 0; index < oneRowMems.size(); ++index) {
                    cellDimMember = oneRowMems.get(index);
                    if (cellDimMember == null || StringUtils.isEmpty((CharSequence)cellDimMember.getDimMemberNumber())) {
                        editRow = true;
                    } else {
                        dim = rowDims.get(index);
                        areaIndex = null;
                        if (multiAreaManager != null) {
                            areaIndex = multiAreaManager.getAreaIndex();
                        }
                        if (!this.isNoLeaf(cellDimMember, dim, modelCacheHelper, dimensionViews, areaIndex) || this.editNoLeafCell && noLeafEditMember) continue;
                        lockRow = true;
                    }
                    break;
                }
            }
            if (editRow) continue;
            if (lockRow) {
                if (this.dimInRow || this.dimInPageView || this.dimInAreaPageView) {
                    this.lockRows.add(i);
                } else if (this.dimInCol) {
                    this.lockCols.add(i);
                }
            }
            if ((!this.dimInRow && !this.dimInPageView && !this.dimInAreaPageView || this.lockRows.contains(i)) && this.lockCols.contains(i)) continue;
            for (int j = 0; j < colDimMems.size(); ++j) {
                boolean lock;
                boolean isLeaf = isRowLeaf;
                List<CellDimMember> oneColMems = colDimMems.get(j);
                if (oneColMems == null || !(lock = colLockedCache.computeIfAbsent(j, f -> {
                    CellDimMember cellDimMember;
                    boolean _lock = false;
                    boolean _isLeaf = isLeaf;
                    List _oneColMems = oneColMems.stream().filter(e -> e == null || !e.isProperty()).collect(Collectors.toList());
                    for (int index = 0; index < _oneColMems.size() && (cellDimMember = (CellDimMember)_oneColMems.get(index)) != null && !StringUtils.isEmpty((CharSequence)cellDimMember.getDimMemberNumber()); ++index) {
                        String dim = (String)colDims.get(index);
                        String areaIndex = null;
                        if (multiAreaManager != null) {
                            areaIndex = multiAreaManager.getAreaIndex();
                        }
                        if (!this.isNoLeaf(cellDimMember, dim, modelCacheHelper, dimensionViews, areaIndex)) continue;
                        _isLeaf = false;
                        if (this.approveAdjust) {
                            if (hasAgg) {
                                if (this.adjustParam.getDims().contains(dim)) continue;
                                _lock = true;
                                break;
                            }
                            if (noLeafEditMember) {
                                if (this.adjustParam.isApproveeditnoleafcell()) continue;
                                _lock = true;
                                break;
                            }
                            _lock = true;
                            break;
                        }
                        if (this.editNoLeafCell && noLeafEditMember) continue;
                        _lock = true;
                        break;
                    }
                    if (_isLeaf && this.approveAdjust && !this.adjustParam.isAdjustleaf()) {
                        _lock = true;
                    }
                    return _lock;
                }).booleanValue())) continue;
                Set set = this.dimInRow || this.dimInPageView || this.dimInAreaPageView ? this.lockRowCols.computeIfAbsent(i, e -> new LinkedHashSet()) : this.lockColRows.computeIfAbsent(i, e -> new LinkedHashSet());
                set.add(j);
            }
        }
    }

    public NoLeafStorageLockControllerHelper init(MultiAreaManager multiAreaManager) {
        if (multiAreaManager != null) {
            this.resetArea();
            IEbSpreadManager spreadManager = multiAreaManager.getEbSpreadManager();
            for (Map.Entry<String, PageViewDimMember> entry : multiAreaManager.getAreaPageViewDims().entrySet()) {
                if (!entry.getKey().equals(this.dimNumber)) continue;
                this.dimInAreaPageView = true;
                if (entry.getValue() == null) continue;
                if (this.memNumbers.contains(entry.getValue().getNumber())) {
                    this.editMemInAreaPageView = true;
                    continue;
                }
                this.pageMeticHasAgg = AdjustServiceHelper.checkMeticHasAgg((String)entry.getValue().getNumber(), (IModelCacheHelper)spreadManager.getModelCacheHelper());
            }
            if (this.editMemInAreaPageView && this.approveAdjust && this.adjustParam.isApproveeditnoleafcell() && this.adjustParam.isAdjustleaf() || this.editMemInAreaPageView && this.editNoLeafCell) {
                this.wholeAreaCanEdit = true;
                return this;
            }
            for (Map.Entry<String, PageViewDimMember> entry : multiAreaManager.getAreaPageViewDims().entrySet()) {
                if (!this.isNoLeaf(entry.getValue(), entry.getKey(), spreadManager.getModelCacheHelper(), spreadManager.getDimemsionViews(), multiAreaManager.getAreaIndex())) continue;
                this.noleafInAreaPageView = true;
                if (this.approveAdjust) {
                    if (!this.adjustParam.getDims().contains(entry.getKey())) {
                        this.hasNotLeafAndNotInAdjusrDim = true;
                        if (!this.adjustParam.isApproveeditnoleafcell()) {
                            this.wholeAreaLock = true;
                            return this;
                        }
                    }
                    if (this.pageMeticHasAgg) {
                        if (this.adjustParam.getDims().contains(entry.getKey())) continue;
                        this.wholeAreaLock = true;
                        return this;
                    }
                    if (this.editMemInAreaPageView) {
                        if (this.adjustParam.isApproveeditnoleafcell()) continue;
                        this.wholeAreaLock = true;
                        return this;
                    }
                    if (!this.dimInAreaPageView) continue;
                    this.wholeAreaLock = true;
                    return this;
                }
                if (this.editNoLeafCell && !this.memNumbers.isEmpty() && (!this.dimInAreaPageView || this.editMemInAreaPageView)) continue;
                this.wholeAreaLock = true;
                break;
            }
            if (this.wholeAreaLock) {
                return this;
            }
            if (this.dimInPageView || this.dimInAreaPageView) {
                this.initRowRoCol(spreadManager, multiAreaManager);
            } else {
                List<String> rowDims = multiAreaManager.getRowpartitionDims();
                List<String> colDims = multiAreaManager.getColpartitionDims();
                this.dimInRow = rowDims.contains(this.dimNumber);
                this.dimInCol = colDims.contains(this.dimNumber);
                this.initRowRoCol(spreadManager, multiAreaManager);
            }
        }
        return this;
    }

    private void resetArea() {
        this.editMemInAreaPageView = false;
        this.noleafInAreaPageView = false;
        this.wholeAreaCanEdit = false;
        this.dimInAreaPageView = false;
        this.dimInRow = false;
        this.dimInCol = false;
        this.lockRows.clear();
        this.lockCols.clear();
        this.lockRowCols.clear();
        this.lockColRows.clear();
        this.wholeAreaLock = false;
        this.isBaseLeafCache.clear();
    }

    public boolean isNoLeaf(CellDimMember cellDimMember, String dimNum, IModelCacheHelper modelCacheHelper, Map<String, Long> dimensionViews, String partitionNum) {
        if (cellDimMember == null || StringUtils.isEmpty((CharSequence)cellDimMember.getDimMemberNumber())) {
            return false;
        }
        String _partitionNum = partitionNum != null ? partitionNum : cellDimMember.getPartition();
        String baseKey = dimNum + '!' + _partitionNum + '!' + cellDimMember.getDimMemberNumber();
        boolean isLeaf = this.isBaseLeafCache.computeIfAbsent(baseKey, f -> {
            Long viewId = DimensionViewServiceHelper.getViewId((Map)dimensionViews, (String)dimNum, (String)_partitionNum);
            Member member = modelCacheHelper.getMember(dimNum, viewId, cellDimMember.getDimMemberNumber());
            if (member != null) {
                return member.isLeaf();
            }
            return false;
        });
        return !isLeaf;
    }

    public boolean isNoLeaf(PageViewDimMember member, String dimNum, IModelCacheHelper modelCacheHelper, Map<String, Long> dimensionViews, String partitionNum) {
        if (member != null && dimNum != null && modelCacheHelper != null) {
            String baseKey = dimNum + '!' + partitionNum + '!' + member.getNumber();
            boolean isLeaf = this.isBaseLeafCache.computeIfAbsent(baseKey, f -> {
                Long viewId = DimensionViewServiceHelper.getViewId((Map)dimensionViews, (String)dimNum, (String)partitionNum);
                Member mem = modelCacheHelper.getMember(dimNum, viewId, member.getNumber());
                if (mem != null) {
                    return mem.isLeaf();
                }
                return false;
            });
            return !isLeaf;
        }
        return member != null && !member.isIsleaf();
    }

    public boolean isNoLeafEditMember(CellDimMember cellDimMember) {
        return cellDimMember != null && !cellDimMember.isProperty() && this.memNumbers.contains(cellDimMember.getDimMemberNumber());
    }

    public Set<Integer> getLockRows() {
        return this.lockRows;
    }

    public Set<Integer> getLockCols() {
        return this.lockCols;
    }

    public Map<Integer, Set<Integer>> getLockRowCols() {
        return this.lockRowCols;
    }

    public Map<Integer, Set<Integer>> getLockColRows() {
        return this.lockColRows;
    }

    public boolean isWholePageCanEdit() {
        return this.wholePageCanEdit;
    }

    public boolean isWholeAreaCanEdit() {
        return this.wholeAreaCanEdit;
    }

    public boolean isWholePageLock() {
        return this.wholePageLock;
    }

    public boolean isWholeAreaLock() {
        return this.wholeAreaLock;
    }
}

