/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.command.lockcontroller.lockcell;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.threadlocal.EpmThreadLocalUtils;
import kd.epm.eb.common.enums.AuditTrailUseEnum;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.permission.membPerm.DimMemberPermChecker;
import kd.epm.eb.common.permission.membPerm.MemberItem;
import kd.epm.eb.common.permission.pojo.PermDimGroup;
import kd.epm.eb.spread.command.lockcontroller.ISpreadLockControl;
import kd.epm.eb.spread.command.lockcontroller.SpreadLockContext;
import kd.epm.eb.spread.command.lockcontroller.lockcell.MemPermControllerHelper;
import kd.epm.eb.spread.template.dimension.PageViewDimMember;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.utils.ReportHelper;

public class PageViewDimNoLeafController
implements ISpreadLockControl {
    public static final String DARKCOLOR = "#E6E8EE";
    public static final String YELLOW_COLOR = "#FFF8E1";
    public static final String WHITE_COLOR = "#FFFFFF";
    public static final String BLACK_COLOR = "#000000";
    private static final Log log = LogFactory.getLog(PageViewDimNoLeafController.class);
    private IFormView view;

    public PageViewDimNoLeafController(IFormView view) {
        this.view = view;
    }

    @Override
    public void control(SpreadLockContext styleControlContext) {
        boolean inProcessApproveBill;
        if (styleControlContext == null || styleControlContext.getEbSpreadManager() == null) {
            return;
        }
        IEbSpreadManager ebSpreadManager = styleControlContext.getEbSpreadManager();
        IModelCacheHelper modelCacheHelper = styleControlContext.getEbSpreadManager().getModelCacheHelper();
        if (modelCacheHelper == null) {
            modelCacheHelper = ModelCacheContext.getOrCreate((Long)styleControlContext.getEbSpreadManager().getModelobj().getId());
        }
        Map<String, Long> dimensionViews = null;
        if (styleControlContext.getEbSpreadManager() != null) {
            dimensionViews = styleControlContext.getEbSpreadManager().getDimemsionViews();
        }
        boolean needlock = false;
        boolean bl = inProcessApproveBill = this.view.getPageCache().get("inProcessApproveBill") != null;
        if (!inProcessApproveBill && ProcessTypeEnum.REPORT.getNumber().equals(ebSpreadManager.getProcessType()) && ebSpreadManager.getProcessId() != null) {
            if (ReportHelper.isRptSchemeClosed(ebSpreadManager.getProcessId())) {
                needlock = true;
                log.info("locked by ReportHelper.isRptSchemeClosed = true");
            }
        } else if (!inProcessApproveBill && ProcessTypeEnum.TASK.getNumber().equals(ebSpreadManager.getProcessType()) && ReportHelper.isTaskUnable(ebSpreadManager.getProcessId())) {
            needlock = true;
            log.info("locked by ReportHelper.isTaskUnable = true");
        }
        if (!needlock && styleControlContext.getTemplateModel() != null && styleControlContext.getTemplateModel().getTemplateBaseInfo() != null) {
            Long templateId = styleControlContext.getTemplateModel().getTemplateBaseInfo().getId();
            try {
                String openByHyperLinkCache;
                DynamicObject dynamicObject = QueryServiceHelper.queryOne((String)"eb_templateentity", (String)"id,isReadOnly,rptreadonly", (QFilter[])new QFilter("id", "=", (Object)templateId).toArray());
                if (dynamicObject != null && dynamicObject.getBoolean("isReadOnly")) {
                    needlock = true;
                    log.info("locked by isReadOnly = true");
                }
                if (dynamicObject != null && !dynamicObject.getBoolean("isReadOnly") && dynamicObject.getBoolean("rptreadonly")) {
                    needlock = true;
                    log.info("locked by isReadOnly = false and rptreadonly = true");
                }
                if (StringUtils.isNotEmpty((String)(openByHyperLinkCache = this.view.getPageCache().get("openByHyperLink_" + ebSpreadManager.getReportProcessId())))) {
                    needlock = true;
                    log.info("locked by isReadOnly = true  openByHyperLink");
                }
            }
            catch (Exception dynamicObject) {
                // empty catch block
            }
        }
        if (!needlock && this.view != null && (needlock = "true".equals(this.view.getPageCache().get("lockedbymutex")))) {
            log.info("locked by lockedbymutex");
        }
        if (!needlock) {
            for (Map.Entry<String, PageViewDimMember> stringStringEntry : ebSpreadManager.getPageViewDims().entrySet()) {
                boolean offsetAT;
                String dimNumber = stringStringEntry.getKey();
                String memNumber = stringStringEntry.getValue() != null ? stringStringEntry.getValue().getNumber() : null;
                boolean changeType = SysDimensionEnum.ChangeType.getNumber().equals(dimNumber) && ("Occupation".equals(memNumber) || "Execute".equals(memNumber));
                Long viewId = ebSpreadManager.getDimemsionViews().get(dimNumber);
                boolean noWritePerm = ebSpreadManager.isNeedCheckPerm() && !ebSpreadManager.getMemberPerm().hasWritePerm(dimNumber, memNumber, viewId);
                boolean offsetOrg = memNumber != null && memNumber.endsWith("offsetentry") && SysDimensionEnum.Entity.getNumber().equals(dimNumber);
                boolean bl2 = offsetAT = SysDimensionEnum.AuditTrail.getNumber().equals(dimNumber) && this.isLockAuditTrail(memNumber, styleControlContext);
                if (!changeType && !noWritePerm && !offsetOrg && !offsetAT) continue;
                needlock = true;
                log.info("locked by " + (changeType ? "changeType" : (noWritePerm ? "noWritePerm" : (offsetOrg ? "offsetOrg" : (offsetAT ? "offsetAT" : "notPossible")))) + " dimNumber=" + dimNumber + " memNumber=" + memNumber);
                break;
            }
        }
        if (!needlock) {
            needlock = this.isMemPermReadOnly(styleControlContext.getEbSpreadManager());
        }
        if (needlock) {
            styleControlContext.lockAllData(null, DARKCOLOR);
            styleControlContext.setStopcommand(true);
            log.info("locked by PageViewDimNoLeafController");
        }
    }

    public boolean isLockAuditTrail(String memNumber, SpreadLockContext styleControlContext) {
        if (memNumber != null) {
            Member member;
            IModelCacheHelper modelCacheHelper = styleControlContext.getEbSpreadManager().getModelCacheHelper();
            if (modelCacheHelper == null && styleControlContext.getEbSpreadManager().getModelobj() != null) {
                modelCacheHelper = ModelCacheContext.getOrCreate((Long)styleControlContext.getEbSpreadManager().getModelobj().getId());
            }
            if (modelCacheHelper != null && (member = modelCacheHelper.getMember(SysDimensionEnum.AuditTrail.getNumber(), null, memNumber)) != null && (AuditTrailUseEnum.AUTO_OFFSET.getCode().equals(member.getAuditTrailUse()) || AuditTrailUseEnum.DECOMPOSE.getCode().equals(member.getAuditTrailUse()))) {
                return true;
            }
        }
        return false;
    }

    public boolean isMemPermReadOnly(IEbSpreadManager ebSpreadManager) {
        Map<String, PageViewDimMember> pageViewDims = ebSpreadManager.getPageViewDims();
        if (pageViewDims == null || pageViewDims.isEmpty()) {
            return false;
        }
        DimMemberPermChecker writePermChecker = EpmThreadLocalUtils.getWritePermChecker((Long)ebSpreadManager.getModelobj().getId(), (Long)ebSpreadManager.getDatasetid());
        if (writePermChecker == null || writePermChecker.hasAllPerm()) {
            return false;
        }
        List<PermDimGroup> dimGroupsPV = MemPermControllerHelper.getPageViewPermGroup(ebSpreadManager);
        if (dimGroupsPV.size() > 0) {
            Map<String, Member> pageViewDimMemIds = MemPermControllerHelper.getPageViewDimMemIds(ebSpreadManager);
            for (PermDimGroup permDimGroup : dimGroupsPV) {
                HashMap memberGroup = new HashMap(16);
                pageViewDimMemIds.forEach((k, v) -> {
                    if (k != null && v != null && permDimGroup.getDimNums().contains(k)) {
                        memberGroup.put(k, new MemberItem(true, v.getId(), v.getNumber()));
                    }
                });
                if (writePermChecker.check(memberGroup)) continue;
                log.info("locked by writePermChecker.check " + ((Object)memberGroup).toString() + ", permDimGroup.getDimNums()=" + permDimGroup.getDimNums());
                return true;
            }
        }
        return false;
    }
}

