/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.command.lockcontroller.lockcell;

import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.spread.command.lockcontroller.ISpreadLockControl;
import kd.epm.eb.spread.command.lockcontroller.SpreadLockContext;
import kd.epm.eb.spread.template.dimension.PageViewDimMember;
import kd.epm.eb.spread.template.spreadmanager.CellDimMember;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import kd.epm.eb.spread.template.spreadmanager.sheet.StyleCell;

public class RollCellLockController
implements ISpreadLockControl {
    public static final String DARKCOLOR = "#E6E8EE";
    private Map<String, Date> rollStartDates = new HashMap<String, Date>(16);
    private Map<String, Date> periodStartDates = new HashMap<String, Date>(16);
    private static final String DATATYPE = SysDimensionEnum.DataType.getNumber();
    private static final String BUDGETPERIOD = SysDimensionEnum.BudgetPeriod.getNumber();
    private static final Log log = LogFactory.getLog(RollCellLockController.class);

    @Override
    public void control(SpreadLockContext styleControlContext) {
        this.initRollDateStart(styleControlContext);
        if (this.rollStartDates != null && this.rollStartDates.size() > 0) {
            Map<String, PageViewDimMember> pvDimMems = styleControlContext.getEbSpreadManager().getPageViewDims();
            PageViewDimMember pvDim_dataType = pvDimMems.get(DATATYPE);
            PageViewDimMember pvDim_bPeriod = pvDimMems.get(BUDGETPERIOD);
            Date pStartDate = null;
            Date rStartDate = null;
            if (pvDim_bPeriod != null && pvDim_dataType != null) {
                pStartDate = this.periodStartDates.get(pvDim_bPeriod.getNumber());
                rStartDate = this.rollStartDates.get(pvDim_dataType.getNumber());
                if (pStartDate != null && rStartDate != null && pStartDate.before(rStartDate)) {
                    styleControlContext.lockAllData(null, DARKCOLOR);
                    styleControlContext.setStopcommand(true);
                    log.info("locked by RollCellLockController");
                }
            } else if (pvDim_dataType != null) {
                this.oneDimInPageView(styleControlContext, this.rollStartDates.get(pvDim_dataType.getNumber()), BUDGETPERIOD);
            } else if (pvDim_bPeriod != null) {
                this.oneDimInPageView(styleControlContext, this.periodStartDates.get(pvDim_bPeriod.getNumber()), DATATYPE);
            } else {
                this.checkRowColsLock(styleControlContext);
            }
        }
    }

    private void oneDimInPageView(SpreadLockContext styleControlContext, Date startDateInPageView, String rowColDimNumber) {
        if (styleControlContext == null || startDateInPageView == null) {
            return;
        }
        boolean isDataType = rowColDimNumber.equals(SysDimensionEnum.DataType.getNumber());
        boolean isPeriod = rowColDimNumber.equals(SysDimensionEnum.BudgetPeriod.getNumber());
        if (!isDataType && !isPeriod) {
            return;
        }
        IEbSpreadManager spreadManager = styleControlContext.getEbSpreadManager();
        boolean isInRow = spreadManager.getRowpartitionDims().contains(rowColDimNumber);
        List<String> dimnumbers = isInRow ? spreadManager.getRowpartitionDims() : spreadManager.getColpartitionDims();
        List<List<CellDimMember>> rowcoldimmems = isInRow ? spreadManager.getRowpartitionDimMems() : spreadManager.getColpartitionDimMems();
        ISheet sheet = spreadManager.getEbook().getSheet(0);
        for (int rowcol = 0; rowcol < rowcoldimmems.size(); ++rowcol) {
            Set cols;
            StyleCell styleCell;
            List<CellDimMember> cellDimMembers = rowcoldimmems.get(rowcol);
            if (cellDimMembers == null || cellDimMembers.size() == 0) continue;
            boolean lock = false;
            int i = 0;
            for (CellDimMember cellDimMember : cellDimMembers) {
                Date rollStartDate;
                String dimnumber = dimnumbers.get(i);
                ++i;
                if (!rowColDimNumber.equals(dimnumber)) continue;
                Date periodStartDate = isPeriod ? this.periodStartDates.get(cellDimMember.getDimMemberNumber()) : startDateInPageView;
                Date date = rollStartDate = isDataType ? this.rollStartDates.get(cellDimMember.getDimMemberNumber()) : startDateInPageView;
                if (periodStartDate == null || rollStartDate == null || !periodStartDate.before(rollStartDate)) continue;
                lock = true;
                break;
            }
            if (!lock) continue;
            if (isInRow) {
                for (int col = sheet.getValueAreaColStart(); col < sheet.getRealMaxCols(); ++col) {
                    styleCell = (StyleCell)sheet.getECell(rowcol, col);
                    styleCell.setLocked(true);
                    styleCell.setBackColor("#FFF8E1");
                    cols = styleControlContext.getLockCells().computeIfAbsent(rowcol, t -> new HashSet(16));
                    cols.add(col);
                }
                continue;
            }
            for (int row = sheet.getValueAreaRowStart(); row < sheet.getRealMaxRows(); ++row) {
                styleCell = (StyleCell)sheet.getECell(row, rowcol);
                styleCell.setLocked(true);
                styleCell.setBackColor("#FFF8E1");
                cols = styleControlContext.getLockCells().computeIfAbsent(row, t -> new HashSet(16));
                cols.add(rowcol);
            }
        }
    }

    private void initRollDateStart(SpreadLockContext styleControlContext) {
        if (styleControlContext != null) {
            Map periodMemsMap;
            Map dataTypeMemsMap;
            Set<String> dataTypeMems = styleControlContext.getEbSpreadManager().getAlldimensionWithMembers().get(DATATYPE);
            Set<String> periodMems = styleControlContext.getEbSpreadManager().getAlldimensionWithMembers().get(BUDGETPERIOD);
            if (dataTypeMems != null && (dataTypeMemsMap = BusinessDataServiceHelper.loadFromCache((String)"epm_datatypemembertree", (String)"longnumber,datestart", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)styleControlContext.getEbSpreadManager().getModelobj().getId()), new QFilter("number", "in", dataTypeMems)})) != null && dataTypeMemsMap.size() > 0) {
                String rollPrefix = "DataType!RollBudget";
                for (DynamicObject dynamicObject : dataTypeMemsMap.values()) {
                    if (dynamicObject.getString("longnumber") == null || !dynamicObject.getString("longnumber").startsWith(rollPrefix)) continue;
                    this.rollStartDates.put(dynamicObject.getString("number"), dynamicObject.getDate("datestart"));
                }
            }
            if (this.rollStartDates.size() > 0 && periodMems != null && (periodMemsMap = BusinessDataServiceHelper.loadFromCache((String)"epm_bperiodmembertree", (String)"startdate", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)styleControlContext.getEbSpreadManager().getModelobj().getId()), new QFilter("number", "in", periodMems)})) != null && periodMemsMap.size() > 0) {
                for (DynamicObject dynamicObject : periodMemsMap.values()) {
                    this.periodStartDates.put(dynamicObject.getString("number"), dynamicObject.getDate("startdate"));
                }
            }
        }
    }

    private void checkRowColsLock(SpreadLockContext styleControlContext) {
        block17: {
            boolean isDataTypeInCol;
            ISheet sheet;
            IEbSpreadManager spreadManager;
            block19: {
                boolean isDataTypeInRow;
                block18: {
                    boolean isPeriodInCol;
                    block16: {
                        spreadManager = styleControlContext.getEbSpreadManager();
                        sheet = spreadManager.getEbook().getSheet(0);
                        boolean isPeriodInRow = spreadManager.getRowpartitionDims().contains(SysDimensionEnum.BudgetPeriod.getNumber());
                        isPeriodInCol = spreadManager.getColpartitionDims().contains(SysDimensionEnum.BudgetPeriod.getNumber());
                        isDataTypeInRow = spreadManager.getRowpartitionDims().contains(SysDimensionEnum.DataType.getNumber());
                        isDataTypeInCol = spreadManager.getColpartitionDims().contains(SysDimensionEnum.DataType.getNumber());
                        if (!isDataTypeInRow || !isPeriodInRow) break block16;
                        for (int row = 0; row < spreadManager.getRowpartitionDimMems().size(); ++row) {
                            List<CellDimMember> cellDimMembers = spreadManager.getRowpartitionDimMems().get(row);
                            if (cellDimMembers == null || cellDimMembers.size() == 0) continue;
                            boolean lock = false;
                            int i = 0;
                            Date periodStartDate = null;
                            Date rollStartDate = null;
                            for (CellDimMember cellDimMember : cellDimMembers) {
                                String dimnumber = spreadManager.getRowpartitionDims().get(i);
                                ++i;
                                if (BUDGETPERIOD.equals(dimnumber)) {
                                    periodStartDate = this.periodStartDates.get(cellDimMember.getDimMemberNumber());
                                } else if (DATATYPE.equals(dimnumber)) {
                                    rollStartDate = this.rollStartDates.get(cellDimMember.getDimMemberNumber());
                                }
                                if (periodStartDate == null || rollStartDate == null || !periodStartDate.before(rollStartDate)) continue;
                                lock = true;
                                break;
                            }
                            if (!lock) continue;
                            for (int col = sheet.getValueAreaColStart(); col < sheet.getRealMaxCols(); ++col) {
                                StyleCell styleCell = (StyleCell)sheet.getECell(row, col);
                                styleCell.setLocked(true);
                                styleCell.setBackColor("#FFF8E1");
                            }
                        }
                        break block17;
                    }
                    if (!isDataTypeInCol || !isPeriodInCol) break block18;
                    for (int col = 0; col < spreadManager.getColpartitionDimMems().size(); ++col) {
                        List<CellDimMember> cellDimMembers = spreadManager.getColpartitionDimMems().get(col);
                        if (cellDimMembers == null || cellDimMembers.size() == 0) continue;
                        boolean lock = false;
                        int i = 0;
                        Date periodStartDate = null;
                        Date rollStartDate = null;
                        for (CellDimMember cellDimMember : cellDimMembers) {
                            String dimnumber = spreadManager.getColpartitionDims().get(i);
                            ++i;
                            if (BUDGETPERIOD.equals(dimnumber)) {
                                periodStartDate = this.periodStartDates.get(cellDimMember.getDimMemberNumber());
                            } else if (DATATYPE.equals(dimnumber)) {
                                rollStartDate = this.rollStartDates.get(cellDimMember.getDimMemberNumber());
                            }
                            if (periodStartDate == null || rollStartDate == null || !periodStartDate.before(rollStartDate)) continue;
                            lock = true;
                            break;
                        }
                        if (!lock) continue;
                        for (int row = sheet.getValueAreaRowStart(); row < sheet.getRealMaxRows(); ++row) {
                            StyleCell styleCell = (StyleCell)sheet.getECell(row, col);
                            styleCell.setLocked(true);
                            styleCell.setBackColor("#FFF8E1");
                        }
                    }
                    break block17;
                }
                if (!isDataTypeInRow) break block19;
                int dtIndex = spreadManager.getRowpartitionDims().indexOf(DATATYPE);
                int periodIndex = spreadManager.getColpartitionDims().indexOf(BUDGETPERIOD);
                for (int row = 0; row < spreadManager.getRowpartitionDimMems().size(); ++row) {
                    List<CellDimMember> rowCellDimMembers = spreadManager.getRowpartitionDimMems().get(row);
                    if (rowCellDimMembers == null || rowCellDimMembers.size() < dtIndex) continue;
                    CellDimMember dtCellDimMember = rowCellDimMembers.get(dtIndex);
                    Date rollStartDate = null;
                    Date periodStartDate = null;
                    if (dtCellDimMember == null || (rollStartDate = this.rollStartDates.get(dtCellDimMember.getDimMemberNumber())) == null) continue;
                    for (int col = 0; col < spreadManager.getColpartitionDimMems().size(); ++col) {
                        CellDimMember periodCellDimMem;
                        List<CellDimMember> colCellDimMembers = spreadManager.getColpartitionDimMems().get(col);
                        if (colCellDimMembers == null || colCellDimMembers.size() < periodIndex || (periodCellDimMem = colCellDimMembers.get(periodIndex)) == null || (periodStartDate = this.periodStartDates.get(periodCellDimMem.getDimMemberNumber())) == null || !periodStartDate.before(rollStartDate)) continue;
                        StyleCell styleCell = (StyleCell)sheet.getECell(row, col);
                        styleCell.setLocked(true);
                        styleCell.setBackColor("#FFF8E1");
                    }
                }
                break block17;
            }
            if (!isDataTypeInCol) break block17;
            int dtIndex = spreadManager.getColpartitionDims().indexOf(DATATYPE);
            int periodIndex = spreadManager.getRowpartitionDims().indexOf(BUDGETPERIOD);
            for (int col = 0; col < spreadManager.getColpartitionDimMems().size(); ++col) {
                List<CellDimMember> colCellDimMembers = spreadManager.getColpartitionDimMems().get(col);
                if (colCellDimMembers == null || colCellDimMembers.size() < dtIndex) continue;
                CellDimMember dtCellDimMember = colCellDimMembers.get(dtIndex);
                Date rollStartDate = null;
                Date periodStartDate = null;
                if (dtCellDimMember == null || (rollStartDate = this.rollStartDates.get(dtCellDimMember.getDimMemberNumber())) == null) continue;
                for (int row = 0; row < spreadManager.getRowpartitionDimMems().size(); ++row) {
                    CellDimMember periodCellDimMem;
                    List<CellDimMember> rowCellDimMembers = spreadManager.getRowpartitionDimMems().get(row);
                    if (rowCellDimMembers == null || rowCellDimMembers.size() < periodIndex || (periodCellDimMem = rowCellDimMembers.get(periodIndex)) == null || (periodStartDate = this.periodStartDates.get(periodCellDimMem.getDimMemberNumber())) == null || !periodStartDate.before(rollStartDate)) continue;
                    StyleCell styleCell = (StyleCell)sheet.getECell(row, col);
                    styleCell.setLocked(true);
                    styleCell.setBackColor("#FFF8E1");
                }
            }
        }
    }
}

