/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.command.lockcontroller.lockcell.fix;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.dimension.dimensionrelation.DimensionRelationUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.RangeModel;
import kd.epm.eb.spread.command.lockcontroller.FixSpreadLockContext;
import kd.epm.eb.spread.command.lockcontroller.ISpreadLockControl;
import kd.epm.eb.spread.command.lockcontroller.SpreadLockContext;
import kd.epm.eb.spread.command.rangedefined.CellArea;
import kd.epm.eb.spread.command.style.AreasStyle;
import kd.epm.eb.spread.command.style.CellStyleInfo;
import kd.epm.eb.spread.template.afix.multimanager.MultiAreaManager;
import kd.epm.eb.spread.template.dimension.PageViewDimMember;
import kd.epm.eb.spread.template.spreadmanager.CellDimMember;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.book.IEBook;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import kd.epm.eb.spread.template.spreadmanager.sheet.StyleCell;
import kd.epm.eb.spread.utils.ReportHelper;

public class DimRelationLockController
implements ISpreadLockControl {
    private static final Log log = LogFactory.getLog(DimRelationLockController.class);
    private final IFormView view;

    public DimRelationLockController(IFormView view) {
        this.view = view;
    }

    @Override
    public void control(SpreadLockContext styleControlContext) {
        this.lockVoidRelationMemberCell(styleControlContext);
    }

    @Override
    public void controlfix(FixSpreadLockContext fixSpreadLockContext) {
        this.lockVoidRelationMemberCellFix(fixSpreadLockContext);
    }

    private void lockVoidRelationMemberCell(SpreadLockContext styleControlContext) {
        IEbSpreadManager ebSpreadManager = styleControlContext.getEbSpreadManager();
        IModelCacheHelper modelCache = ebSpreadManager.getModelCacheHelper();
        Long processId = ebSpreadManager.getReportProcessId();
        Long bizModelId = ebSpreadManager.getBusModelid();
        Map<String, Set<String>> dimRelationMap = ReportHelper.getDimRelationMap(this.view, processId);
        if (dimRelationMap.isEmpty()) {
            return;
        }
        long currPeriodId = IDUtils.toLong((Object)this.view.getPageCache().get("CURRENT_PERIOD"));
        List<Long> dimRelationList = ReportHelper.getDimRelation(this.view, processId);
        IEBook ebook = ebSpreadManager.getEbook();
        if (ebook == null) {
            return;
        }
        boolean pageDimIsinvalid = true;
        Map<String, PageViewDimMember> pageViewDimMemberMap = ebSpreadManager.getPageViewDims();
        HashMap<String, String> pageDimMemberMap = new HashMap<String, String>(16);
        if (pageViewDimMemberMap != null) {
            for (Map.Entry<String, PageViewDimMember> entry : pageViewDimMemberMap.entrySet()) {
                if (entry.getValue() == null || entry.getValue().getNumber() == null) continue;
                pageDimMemberMap.put(entry.getKey(), entry.getValue().getNumber());
            }
            pageDimIsinvalid = DimensionRelationUtils.isValidRelation((IModelCacheHelper)modelCache, (long)bizModelId, (Long)currPeriodId, pageDimMemberMap, dimRelationMap, dimRelationList);
        }
        Iterator<ISheet> iterator = ebook.iterator();
        while (iterator.hasNext()) {
            ArrayList<Integer[]> lockIndex = new ArrayList<Integer[]>(16);
            ISheet sheet = iterator.next();
            int rowStart = Math.max(sheet.getDimRowStart(), 0);
            int rowEnd = sheet.getRealMaxRows();
            int colStart = Math.max(sheet.getDimColStart(), 0);
            int colEnd = sheet.getRealMaxCols();
            List<String> rowpartitionDims = ebSpreadManager.getRowpartitionDims();
            boolean rowDimInRelation = false;
            for (String dim : rowpartitionDims) {
                if (!dimRelationMap.containsKey(dim)) continue;
                rowDimInRelation = true;
                break;
            }
            List<String> colpartitionDims = ebSpreadManager.getColpartitionDims();
            boolean colDimInRelation = false;
            for (String dim : colpartitionDims) {
                if (!dimRelationMap.containsKey(dim)) continue;
                colDimInRelation = true;
                break;
            }
            if (pageDimIsinvalid && !rowDimInRelation && !colDimInRelation) continue;
            for (int i = rowStart; i < rowEnd; ++i) {
                if (pageDimIsinvalid) {
                    HashMap<String, String> dimMemberMap = new HashMap<String, String>(pageDimMemberMap);
                    boolean rowDimIsInvalid = true;
                    if (rowDimInRelation) {
                        Map<String, CellDimMember> rowDims = ebSpreadManager.getRowpartitionDimMemsByRow(i);
                        if (rowDims == null || rowDims.size() == 0) continue;
                        Map<String, String> rowDimMemberMap = rowDims.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, kv -> ((CellDimMember)kv.getValue()).getDimMemberNumber()));
                        dimMemberMap.putAll(rowDimMemberMap);
                        rowDimIsInvalid = DimensionRelationUtils.isValidRelation((IModelCacheHelper)modelCache, (long)bizModelId, (Long)currPeriodId, dimMemberMap, dimRelationMap, dimRelationList);
                    }
                    for (int j = colStart; j < colEnd; ++j) {
                        if (rowDimIsInvalid) {
                            StyleCell eCell;
                            ECell eCell1;
                            Map<String, CellDimMember> colDims;
                            if (!colDimInRelation || (colDims = ebSpreadManager.getColpartitionDimMemsByCol(j)) == null || colDims.size() == 0 || (eCell1 = sheet.getECell(i, j)) instanceof StyleCell && (eCell = (StyleCell)sheet.getECell(i, j)).isLocked()) continue;
                            Map<String, String> colDimMemberMap = colDims.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, kv -> ((CellDimMember)kv.getValue()).getDimMemberNumber()));
                            dimMemberMap.putAll(colDimMemberMap);
                            if (DimensionRelationUtils.isValidRelation((IModelCacheHelper)modelCache, (long)bizModelId, (Long)currPeriodId, dimMemberMap, dimRelationMap, dimRelationList)) continue;
                            lockIndex.add(new Integer[]{i, j});
                            continue;
                        }
                        lockIndex.add(new Integer[]{i, j});
                    }
                    continue;
                }
                for (int j = colStart; j < colEnd; ++j) {
                    StyleCell eCell;
                    ECell eCell1;
                    Map<String, CellDimMember> colDims = ebSpreadManager.getColpartitionDimMemsByCol(j);
                    if (colDims == null || colDims.size() == 0 || (eCell1 = sheet.getECell(i, j)) instanceof StyleCell && (eCell = (StyleCell)sheet.getECell(i, j)).isLocked()) continue;
                    lockIndex.add(new Integer[]{i, j});
                }
            }
            this.lockSheetCell(sheet, lockIndex);
            styleControlContext.setLockCells(lockIndex);
        }
    }

    private void lockVoidRelationMemberCellFix(FixSpreadLockContext fixSpreadLockContext) {
        IEbSpreadManager ebSpreadManager = fixSpreadLockContext.getEbSpreadManager();
        if (ebSpreadManager == null) {
            return;
        }
        List<MultiAreaManager> multiAreaManager = ebSpreadManager.getMultiAreaManager();
        if (multiAreaManager == null || multiAreaManager.size() == 0) {
            return;
        }
        IModelCacheHelper modelCache = ebSpreadManager.getModelCacheHelper();
        Long processId = ebSpreadManager.getReportProcessId();
        Long bizModelId = ebSpreadManager.getBusModelid();
        Map<String, Set<String>> dimRelationMap = ReportHelper.getDimRelationMap(this.view, processId);
        if (dimRelationMap.isEmpty()) {
            return;
        }
        Long currPeriodId = IDUtils.toLong((Object)this.view.getPageCache().get("CURRENT_PERIOD"));
        List<Long> dimRelationList = ReportHelper.getDimRelation(this.view, processId);
        boolean pageDimIsinvalid = true;
        Map<String, PageViewDimMember> pageViewDimMemberMap = ebSpreadManager.getPageViewDims();
        Map<Object, Object> pageDimMemberMap = new HashMap(16);
        if (pageViewDimMemberMap != null) {
            pageDimMemberMap = pageViewDimMemberMap.entrySet().stream().filter(Objects::nonNull).collect(Collectors.toMap(Map.Entry::getKey, kv -> kv.getValue() != null ? ((PageViewDimMember)kv.getValue()).getNumber() : ""));
            pageDimIsinvalid = DimensionRelationUtils.isValidRelation((IModelCacheHelper)modelCache, (long)bizModelId, (Long)currPeriodId, pageDimMemberMap, dimRelationMap, dimRelationList);
        }
        for (MultiAreaManager areaManager : multiAreaManager) {
            MultiAreaManager.ValueArea areaStart;
            if (areaManager == null) continue;
            Map<String, PageViewDimMember> hideMemberMap = areaManager.getAreaPageViewDims();
            if (hideMemberMap != null) {
                for (Map.Entry<String, PageViewDimMember> entry : hideMemberMap.entrySet()) {
                    PageViewDimMember pageViewDimMember = entry.getValue();
                    pageDimMemberMap.put(entry.getKey(), pageViewDimMember != null ? pageViewDimMember.getNumber() : "");
                }
            }
            ArrayList<Integer[]> lockIndex = new ArrayList<Integer[]>(16);
            RangeModel areaRange = areaManager.getAreaRange();
            if (areaRange == null || (areaStart = areaManager.getValueAreaStart()) == null) continue;
            int colStart = areaStart.getCol_start();
            int colEnd = areaRange.getXEnd();
            int rowStart = areaStart.getRow_start();
            int rowEnd = areaRange.getYEnd();
            List<String> rowpartitionDims = areaManager.getRowpartitionDims();
            List<String> colpartitionDims = areaManager.getColpartitionDims();
            boolean rowDimInRelation = false;
            boolean colDimInRelation = false;
            if (rowpartitionDims != null) {
                for (String dim : rowpartitionDims) {
                    if (!dimRelationMap.containsKey(dim)) continue;
                    rowDimInRelation = true;
                    break;
                }
            }
            if (colpartitionDims != null) {
                for (String dim : colpartitionDims) {
                    if (!dimRelationMap.containsKey(dim)) continue;
                    colDimInRelation = true;
                    break;
                }
            }
            if (pageDimIsinvalid && !rowDimInRelation && !colDimInRelation) continue;
            for (int i = rowStart; i <= rowEnd; ++i) {
                Map<String, String> rowDims = this.getRowpartitionDimMemsByRow(areaManager, i - rowStart);
                if (rowDims == null || rowDims.size() == 0) continue;
                boolean rowDimIsInvalid = true;
                HashMap<Object, Object> dimMemberMap = new HashMap<Object, Object>(pageDimMemberMap);
                if (pageDimIsinvalid && rowDimInRelation) {
                    dimMemberMap.putAll(rowDims);
                    rowDimIsInvalid = DimensionRelationUtils.isValidRelation((IModelCacheHelper)modelCache, (long)bizModelId, (Long)currPeriodId, dimMemberMap, dimRelationMap, dimRelationList);
                }
                for (int j = colStart; j <= colEnd; ++j) {
                    Map<String, String> colDims = this.getColpartitionDimMemsByCol(areaManager, j - colStart);
                    if (colDims == null || colDims.size() == 0) continue;
                    if (pageDimIsinvalid && rowDimIsInvalid) {
                        if (!colDimInRelation) continue;
                        dimMemberMap.putAll(colDims);
                        if (DimensionRelationUtils.isValidRelation((IModelCacheHelper)modelCache, (long)bizModelId, (Long)currPeriodId, dimMemberMap, dimRelationMap, dimRelationList)) continue;
                        lockIndex.add(new Integer[]{i, j});
                        continue;
                    }
                    lockIndex.add(new Integer[]{i, j});
                }
            }
            this.lockSheetCellFix(fixSpreadLockContext, lockIndex, areaManager.isUserStyle());
        }
    }

    private Map<String, String> getRowpartitionDimMemsByRow(MultiAreaManager areaManager, int row) {
        Map<String, CellDimMember> rowDims = areaManager.getRowpartitionDimMemsByRow(row);
        if (rowDims != null) {
            return rowDims.entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, kv -> ((CellDimMember)kv.getValue()).getDimMemberNumber()));
        }
        return null;
    }

    private Map<String, String> getColpartitionDimMemsByCol(MultiAreaManager areaManager, int col) {
        Map<String, CellDimMember> colDims = areaManager.getColpartitionDimMemsByCol(col);
        if (colDims != null) {
            return colDims.entrySet().stream().filter(e -> e.getValue() != null).collect(Collectors.toMap(Map.Entry::getKey, kv -> ((CellDimMember)kv.getValue()).getDimMemberNumber()));
        }
        return null;
    }

    private void lockSheetCellFix(FixSpreadLockContext fixSpreadLockContext, List<Integer[]> lockIndex, boolean userStyle) {
        if (lockIndex == null || lockIndex.size() == 0) {
            return;
        }
        AreasStyle areasStyle = new AreasStyle();
        CellStyleInfo styleInfo = new CellStyleInfo();
        if (!userStyle) {
            styleInfo.setBkc("#E6E8EE");
        }
        styleInfo.setL(true);
        int rowIndex = 0;
        int colIndex = 1;
        ArrayList<CellArea> range = new ArrayList<CellArea>(lockIndex.size() * 2);
        for (Integer[] indexes : lockIndex) {
            if (indexes == null || indexes.length != 2) continue;
            CellArea cellArea = new CellArea(indexes[rowIndex], indexes[colIndex], 1, 1);
            range.add(cellArea);
        }
        areasStyle.setStyle(styleInfo);
        areasStyle.setRange(range);
        fixSpreadLockContext.getAreasStyles().add(areasStyle);
        log.info("locked by DimRelationLockController lockIndex=" + lockIndex);
    }

    private void lockSheetCell(ISheet sheet, List<Integer[]> lockIndex) {
        if (sheet == null || lockIndex == null || lockIndex.size() == 0) {
            return;
        }
        for (Integer[] arr : lockIndex) {
            int col;
            int row;
            ECell eCell;
            if (arr == null || arr.length != 2 || !((eCell = sheet.getECell(row = arr[0].intValue(), col = arr[1].intValue())) instanceof StyleCell)) continue;
            StyleCell styleCell = (StyleCell)eCell;
            styleCell.setLocked(true);
            styleCell.setBackColor("#E6E8EE");
        }
    }
}

