/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.command.lockcontroller.lockcell.fix;

import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CommonUtils;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.spread.command.lockcontroller.FixSpreadLockContext;
import kd.epm.eb.spread.command.lockcontroller.ISpreadLockControl;
import kd.epm.eb.spread.template.afix.multimanager.MultiAreaManager;
import kd.epm.eb.spread.template.dimension.PageViewDimMember;
import kd.epm.eb.spread.template.spreadmanager.CellDimMember;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;

public class FixActualChangesLeafCellLockController
implements ISpreadLockControl {
    public static final String DARKCOLOR = "#E6E8EE";
    private static final String CHANGE_TYPE = SysDimensionEnum.ChangeType.getNumber();
    private static final String DATA_TYPE = SysDimensionEnum.DataType.getNumber();
    private static final String VERSION = SysDimensionEnum.Version.getNumber();
    private String dataTypeNumber;
    private String versionNumber;
    private static final Log log = LogFactory.getLog(FixActualChangesLeafCellLockController.class);

    @Override
    public void controlfix(FixSpreadLockContext styleControlContext) {
        if (this.checkChangeTypeMemberHasActualChangesLeaf(styleControlContext)) {
            Map<String, PageViewDimMember> pvDimMems = styleControlContext.getEbSpreadManager().getPageViewDims();
            PageViewDimMember pvDimChangType = pvDimMems.get(CHANGE_TYPE);
            PageViewDimMember pvDimDataType = pvDimMems.get(DATA_TYPE);
            PageViewDimMember pvDimVersion = pvDimMems.get(VERSION);
            if (pvDimChangType != null && pvDimDataType != null && pvDimVersion != null) {
                String changTypeNumber = pvDimChangType.getNumber();
                String dataTypeNumber = pvDimDataType.getNumber();
                String versionNumber = pvDimVersion.getNumber();
                if (this.checkMemberIsActualChangesLeaf(styleControlContext.getEbSpreadManager(), changTypeNumber) && this.isNotActualDataTypeOrVersion(dataTypeNumber, versionNumber)) {
                    styleControlContext.lockAllData(null, DARKCOLOR);
                    log.info("locked by FixActualChangesLeafCellLockController 1");
                }
            } else if (pvDimChangType != null && pvDimDataType != null) {
                String changTypeNumber = pvDimChangType.getNumber();
                String dataTypeNumber = pvDimDataType.getNumber();
                if (this.checkMemberIsActualChangesLeaf(styleControlContext.getEbSpreadManager(), changTypeNumber)) {
                    if (!"Actual".equals(dataTypeNumber)) {
                        styleControlContext.lockAllData(null, DARKCOLOR);
                        log.info("locked by FixActualChangesLeafCellLockController 2");
                    } else {
                        this.oneDimInRowColView(styleControlContext, VERSION);
                    }
                }
            } else if (pvDimChangType != null && pvDimVersion != null) {
                String changTypeNumber = pvDimChangType.getNumber();
                String versionNumber = pvDimVersion.getNumber();
                if (this.checkMemberIsActualChangesLeaf(styleControlContext.getEbSpreadManager(), changTypeNumber)) {
                    if (!"ACTUAL".equals(versionNumber)) {
                        styleControlContext.lockAllData(null, DARKCOLOR);
                        log.info("locked by FixActualChangesLeafCellLockController 3");
                    } else {
                        this.oneDimInRowColView(styleControlContext, DATA_TYPE);
                    }
                }
            } else if (pvDimChangType != null) {
                String changTypeNumber = pvDimChangType.getNumber();
                if (this.checkMemberIsActualChangesLeaf(styleControlContext.getEbSpreadManager(), changTypeNumber)) {
                    this.twoDimInRowColViewByDataTypeAndVersion(styleControlContext);
                }
            } else if (pvDimDataType != null && pvDimVersion != null) {
                this.dataTypeNumber = pvDimDataType.getNumber();
                this.versionNumber = pvDimVersion.getNumber();
                this.oneDimInRowColView(styleControlContext, CHANGE_TYPE);
            } else if (pvDimDataType != null) {
                this.dataTypeNumber = pvDimDataType.getNumber();
                this.twoDimInRowColViewByChangeTypeAndOther(styleControlContext, VERSION);
            } else if (pvDimVersion != null) {
                this.versionNumber = pvDimVersion.getNumber();
                this.twoDimInRowColViewByChangeTypeAndOther(styleControlContext, DATA_TYPE);
            } else {
                this.threeDimInRowColView(styleControlContext);
            }
        }
    }

    private boolean checkChangeTypeMemberHasActualChangesLeaf(FixSpreadLockContext styleControlContext) {
        if (styleControlContext == null || styleControlContext.getEbSpreadManager() == null) {
            return false;
        }
        Set<String> changeTypeMems = styleControlContext.getEbSpreadManager().getAlldimensionWithMembers().get(CHANGE_TYPE);
        if (changeTypeMems != null) {
            IEbSpreadManager ebSpreadManager = styleControlContext.getEbSpreadManager();
            for (String member : changeTypeMems) {
                if (!this.checkMemberIsActualChangesLeaf(ebSpreadManager, member)) continue;
                return true;
            }
        }
        return false;
    }

    private boolean checkMemberIsActualChangesLeaf(IEbSpreadManager ebSpreadManager, String changeTypeMemberNumber) {
        List leafMemberNumbers;
        if (ebSpreadManager.getModelobj() == null || StringUtils.isEmpty((String)changeTypeMemberNumber)) {
            return false;
        }
        Long modelId = ebSpreadManager.getModelobj().getId();
        IModelCacheHelper modelCacheHelper = ebSpreadManager.getModelCacheHelper();
        if (modelCacheHelper == null) {
            modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        }
        Long viewId = ebSpreadManager.getDimemsionViews().get(SysDimensionEnum.ChangeType.getNumber());
        Member member = modelCacheHelper.getMember(SysDimensionEnum.ChangeType.getNumber(), viewId, "ActualChanges");
        return member != null && CommonUtils.hasBusinessModel((Long)modelId) != false && StringUtils.isNotEmpty((String)changeTypeMemberNumber) && (leafMemberNumbers = member.getLeaf().stream().map(BaseCache::getNumber).collect(Collectors.toList())).contains(changeTypeMemberNumber);
    }

    private void oneDimInRowColView(FixSpreadLockContext styleControlContext, String rowColDimNumber) {
        if (styleControlContext == null) {
            return;
        }
        boolean isDataType = rowColDimNumber.equals(DATA_TYPE);
        boolean isVersion = rowColDimNumber.equals(VERSION);
        boolean isChangType = rowColDimNumber.equals(CHANGE_TYPE);
        if (!(isDataType || isVersion || isChangType)) {
            return;
        }
        IEbSpreadManager spreadManager = styleControlContext.getEbSpreadManager();
        for (MultiAreaManager multiAreaManager : styleControlContext.getEbSpreadManager().getMultiAreaManager()) {
            boolean isInRow = multiAreaManager.getRowpartitionDims().contains(rowColDimNumber);
            List<String> dimNumbers = isInRow ? multiAreaManager.getRowpartitionDims() : multiAreaManager.getColpartitionDims();
            List<List<CellDimMember>> rowColDimMems = isInRow ? multiAreaManager.getRowpartitionDimMems() : multiAreaManager.getColpartitionDimMems();
            List<List<CellDimMember>> rowdimmems = multiAreaManager.getRowpartitionDimMems();
            PageViewDimMember pageViewDimMember = multiAreaManager.getAreaPageViewDims().get(rowColDimNumber);
            boolean lock = false;
            String dimMemberNumber = "";
            if (pageViewDimMember != null) {
                dimMemberNumber = pageViewDimMember.getNumber();
                if (isDataType && !"Actual".equals(dimMemberNumber) || isVersion && !"ACTUAL".equals(dimMemberNumber)) {
                    lock = true;
                }
                if (isChangType && this.checkMemberIsActualChangesLeaf(spreadManager, dimMemberNumber) && this.isNotActualDataTypeOrVersion(this.dataTypeNumber, this.versionNumber)) {
                    lock = true;
                }
                if (!lock) continue;
                log.info("locked_by_FixActualChangesLeafCellLockController_oneDimInRowColView_pageViewDimMember_no_null:" + dimMemberNumber + "_" + this.dataTypeNumber + "_" + this.versionNumber);
                for (int row = 0; row < rowdimmems.size(); ++row) {
                    styleControlContext.lockRowCol(null, "#FFF8E1", row, multiAreaManager, true);
                }
                continue;
            }
            for (int rowcol = 0; rowcol < rowColDimMems.size(); ++rowcol) {
                lock = false;
                List<CellDimMember> cellDimMembers = rowColDimMems.get(rowcol);
                if (cellDimMembers == null || cellDimMembers.size() == 0) continue;
                int i = 0;
                for (CellDimMember cellDimMember : cellDimMembers) {
                    if (cellDimMember == null) continue;
                    String dimNumber = dimNumbers.get(i);
                    dimMemberNumber = cellDimMember.getDimMemberNumber();
                    ++i;
                    if (!rowColDimNumber.equals(dimNumber)) continue;
                    if (isDataType && !"Actual".equals(dimMemberNumber) || isVersion && !"ACTUAL".equals(dimMemberNumber)) {
                        lock = true;
                        break;
                    }
                    if (!isChangType || !this.checkMemberIsActualChangesLeaf(spreadManager, dimMemberNumber) || !this.isNotActualDataTypeOrVersion(this.dataTypeNumber, this.versionNumber)) continue;
                    lock = true;
                    break;
                }
                if (!lock) continue;
                log.info("locked_by_FixActualChangesLeafCellLockController_oneDimInRowColView_pageViewDimMember_null:" + dimMemberNumber + "_" + this.dataTypeNumber + "_" + this.versionNumber + "_rowcol=" + rowcol);
                styleControlContext.lockRowCol(null, "#FFF8E1", rowcol, multiAreaManager, isInRow);
            }
        }
    }

    private void twoDimInRowColViewByDataTypeAndVersion(FixSpreadLockContext styleControlContext) {
        if (styleControlContext == null) {
            return;
        }
        for (MultiAreaManager multiAreaManager : styleControlContext.getEbSpreadManager().getMultiAreaManager()) {
            List<CellDimMember> colMembers;
            int col;
            List<CellDimMember> rowMembers;
            CellDimMember dtMember;
            int col2;
            List<CellDimMember> cellDimMembers;
            int row;
            String versionMemNum;
            CellDimMember versionMember;
            CellDimMember dtMember2;
            List<CellDimMember> cellDimMembers2;
            int versionIndex;
            List<List<CellDimMember>> rowdimmems = multiAreaManager.getRowpartitionDimMems();
            List<List<CellDimMember>> coldimmems = multiAreaManager.getColpartitionDimMems();
            List<String> rowdimnums = multiAreaManager.getRowpartitionDims();
            List<String> coldimnums = multiAreaManager.getColpartitionDims();
            boolean isDataTypeInRow = rowdimnums.contains(DATA_TYPE);
            boolean isDataTypeInCol = coldimnums.contains(DATA_TYPE);
            boolean isVersionInRow = rowdimnums.contains(VERSION);
            boolean isVersionInCol = coldimnums.contains(VERSION);
            int dtIndex = isDataTypeInRow ? rowdimnums.indexOf(DATA_TYPE) : coldimnums.indexOf(DATA_TYPE);
            int n = versionIndex = isVersionInRow ? rowdimnums.indexOf(VERSION) : coldimnums.indexOf(VERSION);
            if (isDataTypeInRow && isVersionInRow) {
                for (int row2 = 0; row2 < rowdimmems.size(); ++row2) {
                    cellDimMembers2 = rowdimmems.get(row2);
                    if (cellDimMembers2 == null || cellDimMembers2.size() == 0) continue;
                    dtMember2 = cellDimMembers2.get(dtIndex);
                    versionMember = cellDimMembers2.get(versionIndex);
                    if ((dtMember2 == null || "Actual".equals(dtMember2.getDimMemberNumber())) && (versionMember == null || "ACTUAL".equals(versionMember.getDimMemberNumber()))) continue;
                    String dtMemNum = dtMember2 != null ? dtMember2.getDimMemberNumber() : "";
                    versionMemNum = versionMember != null ? versionMember.getDimMemberNumber() : "";
                    log.info("locked_by_FixActualChangesLeafCellLockController_twoDimInRowColViewByDataTypeAndVersion_isDataTypeInRow&&isVersionInRow:" + dtMemNum + "_" + versionMemNum + "_row=" + row2);
                    styleControlContext.lockRowCol(null, "#FFF8E1", row2, multiAreaManager, true);
                }
                continue;
            }
            if (isDataTypeInCol && isVersionInCol) {
                for (int col3 = 0; col3 < coldimmems.size(); ++col3) {
                    cellDimMembers2 = coldimmems.get(col3);
                    if (cellDimMembers2 == null || cellDimMembers2.size() == 0) continue;
                    dtMember2 = cellDimMembers2.get(dtIndex);
                    versionMember = cellDimMembers2.get(versionIndex);
                    if ((dtMember2 == null || "Actual".equals(dtMember2.getDimMemberNumber())) && (versionMember == null || "ACTUAL".equals(versionMember.getDimMemberNumber()))) continue;
                    String dtMemNum = dtMember2 != null ? dtMember2.getDimMemberNumber() : "";
                    versionMemNum = versionMember != null ? versionMember.getDimMemberNumber() : "";
                    log.info("locked_by_FixActualChangesLeafCellLockController_twoDimInRowColViewByDataTypeAndVersion_isDataTypeInCol&&isVersionInCol:" + dtMemNum + "_" + versionMemNum + "_col=" + col3);
                    styleControlContext.lockRowCol(null, "#FFF8E1", col3, multiAreaManager, false);
                }
                continue;
            }
            PageViewDimMember dtPageMem = multiAreaManager.getAreaPageViewDims().get(DATA_TYPE);
            PageViewDimMember versionPageMem = multiAreaManager.getAreaPageViewDims().get(VERSION);
            if (dtPageMem != null && versionPageMem != null) {
                if (!this.isNotActualDataTypeOrVersion(dtPageMem.getNumber(), versionPageMem.getNumber())) continue;
                log.info("locked_by_FixActualChangesLeafCellLockController_twoDimInRowColViewByDataTypeAndVersion_dtPageMem&&VersionPageMem_no_null:" + dtPageMem.getNumber() + "_" + versionPageMem.getNumber());
                for (row = 0; row < rowdimmems.size(); ++row) {
                    styleControlContext.lockRowCol(null, "#FFF8E1", row, multiAreaManager, true);
                }
                continue;
            }
            if (dtPageMem != null) {
                if (!"Actual".equals(dtPageMem.getNumber())) {
                    log.info("locked_by_FixActualChangesLeafCellLockController_twoDimInRowColViewByDataTypeAndVersion_dtPageMem_no_null:" + dtPageMem.getNumber());
                    for (row = 0; row < rowdimmems.size(); ++row) {
                        styleControlContext.lockRowCol(null, "#FFF8E1", row, multiAreaManager, true);
                    }
                    continue;
                }
                if (isVersionInRow) {
                    for (row = 0; row < rowdimmems.size(); ++row) {
                        CellDimMember versionMember2;
                        cellDimMembers = rowdimmems.get(row);
                        if (cellDimMembers == null || cellDimMembers.size() == 0 || (versionMember2 = cellDimMembers.get(versionIndex)) == null || "ACTUAL".equals(versionMember2.getDimMemberNumber())) continue;
                        log.info("locked_by_FixActualChangesLeafCellLockController_twoDimInRowColViewByDataTypeAndVersion_isVersionInRow:" + versionMember2.getDimMemberNumber() + "_row=" + row);
                        styleControlContext.lockRowCol(null, "#FFF8E1", row, multiAreaManager, true);
                    }
                    continue;
                }
                if (!isVersionInCol) continue;
                for (col2 = 0; col2 < coldimmems.size(); ++col2) {
                    CellDimMember versionMember3;
                    cellDimMembers = coldimmems.get(col2);
                    if (cellDimMembers == null || cellDimMembers.size() == 0 || (versionMember3 = cellDimMembers.get(versionIndex)) == null || "ACTUAL".equals(versionMember3.getDimMemberNumber())) continue;
                    log.info("locked_by_FixActualChangesLeafCellLockController_twoDimInRowColViewByDataTypeAndVersion_isVersionInCol:" + versionMember3.getDimMemberNumber() + "_col=" + col2);
                    styleControlContext.lockRowCol(null, "#FFF8E1", col2, multiAreaManager, false);
                }
                continue;
            }
            if (versionPageMem != null) {
                if (!"ACTUAL".equals(versionPageMem.getNumber())) {
                    log.info("locked_by_FixActualChangesLeafCellLockController_twoDimInRowColViewByDataTypeAndVersion_versionPageMem_no_null:" + versionPageMem.getNumber());
                    for (row = 0; row < rowdimmems.size(); ++row) {
                        styleControlContext.lockRowCol(null, "#FFF8E1", row, multiAreaManager, true);
                    }
                    continue;
                }
                if (isDataTypeInRow) {
                    for (row = 0; row < rowdimmems.size(); ++row) {
                        cellDimMembers = rowdimmems.get(row);
                        if (cellDimMembers == null || cellDimMembers.size() == 0 || (dtMember = cellDimMembers.get(dtIndex)) == null || "Actual".equals(dtMember.getDimMemberNumber())) continue;
                        log.info("locked_by_FixActualChangesLeafCellLockController_twoDimInRowColViewByDataTypeAndVersion_isDataTypeInRow:" + dtMember.getDimMemberNumber() + "_row=" + row);
                        styleControlContext.lockRowCol(null, "#FFF8E1", row, multiAreaManager, true);
                    }
                    continue;
                }
                if (!isDataTypeInCol) continue;
                for (col2 = 0; col2 < coldimmems.size(); ++col2) {
                    cellDimMembers = coldimmems.get(col2);
                    if (cellDimMembers == null || cellDimMembers.size() == 0 || (dtMember = cellDimMembers.get(dtIndex)) == null || "Actual".equals(dtMember.getDimMemberNumber())) continue;
                    log.info("locked_by_FixActualChangesLeafCellLockController_twoDimInRowColViewByDataTypeAndVersion_isDataTypeInCol:" + dtMember.getDimMemberNumber() + "_col=" + col2);
                    styleControlContext.lockRowCol(null, "#FFF8E1", col2, multiAreaManager, false);
                }
                continue;
            }
            if (isDataTypeInRow) {
                for (row = 0; row < rowdimmems.size(); ++row) {
                    rowMembers = rowdimmems.get(row);
                    if (rowMembers == null || rowMembers.size() == 0 || (dtMember = rowMembers.get(dtIndex)) == null) continue;
                    for (col = 0; col < coldimmems.size(); ++col) {
                        CellDimMember versionMember4;
                        colMembers = coldimmems.get(col);
                        if (colMembers == null || colMembers.size() == 0 || (versionMember4 = colMembers.get(versionIndex)) == null || !this.isNotActualDataTypeOrVersion(dtMember.getDimMemberNumber(), versionMember4.getDimMemberNumber())) continue;
                        styleControlContext.lockRowCol(null, "#FFF8E1", row, col, multiAreaManager);
                    }
                }
                continue;
            }
            if (!isDataTypeInCol) continue;
            for (row = 0; row < rowdimmems.size(); ++row) {
                CellDimMember versionMember5;
                rowMembers = rowdimmems.get(row);
                if (rowMembers == null || rowMembers.size() == 0 || (versionMember5 = rowMembers.get(versionIndex)) == null) continue;
                for (col = 0; col < coldimmems.size(); ++col) {
                    colMembers = coldimmems.get(col);
                    if (colMembers == null || colMembers.size() == 0 || (dtMember = colMembers.get(dtIndex)) == null || !this.isNotActualDataTypeOrVersion(dtMember.getDimMemberNumber(), versionMember5.getDimMemberNumber())) continue;
                    styleControlContext.lockRowCol(null, "#FFF8E1", row, col, multiAreaManager);
                }
            }
        }
    }

    private void twoDimInRowColViewByChangeTypeAndOther(FixSpreadLockContext styleControlContext, String rowColDimNumber) {
        if (styleControlContext == null) {
            return;
        }
        boolean isDataType = rowColDimNumber.equals(DATA_TYPE);
        boolean isVersion = rowColDimNumber.equals(VERSION);
        IEbSpreadManager spreadManager = styleControlContext.getEbSpreadManager();
        for (MultiAreaManager multiAreaManager : styleControlContext.getEbSpreadManager().getMultiAreaManager()) {
            List<CellDimMember> colMembers;
            int col;
            List<CellDimMember> rowMembers;
            int col2;
            List<CellDimMember> cellDimMembers;
            int row;
            CellDimMember rowColDimMember;
            CellDimMember ctMember;
            List<CellDimMember> cellDimMembers2;
            int rowColDimIndex;
            List<List<CellDimMember>> rowdimmems = multiAreaManager.getRowpartitionDimMems();
            List<List<CellDimMember>> coldimmems = multiAreaManager.getColpartitionDimMems();
            List<String> rowdimnums = multiAreaManager.getRowpartitionDims();
            List<String> coldimnums = multiAreaManager.getColpartitionDims();
            boolean isChangeTypeInRow = rowdimnums.contains(CHANGE_TYPE);
            boolean isChangeTypeInCol = coldimnums.contains(CHANGE_TYPE);
            boolean isRowColDimInRow = rowdimnums.contains(rowColDimNumber);
            boolean isRowColDimInCol = coldimnums.contains(rowColDimNumber);
            int ctIndex = isChangeTypeInRow ? rowdimnums.indexOf(CHANGE_TYPE) : coldimnums.indexOf(CHANGE_TYPE);
            int n = rowColDimIndex = isRowColDimInRow ? rowdimnums.indexOf(rowColDimNumber) : coldimnums.indexOf(rowColDimNumber);
            if (isChangeTypeInRow && isRowColDimInRow) {
                for (int row2 = 0; row2 < rowdimmems.size(); ++row2) {
                    cellDimMembers2 = rowdimmems.get(row2);
                    if (cellDimMembers2 == null || cellDimMembers2.size() == 0) continue;
                    ctMember = cellDimMembers2.get(ctIndex);
                    rowColDimMember = cellDimMembers2.get(rowColDimIndex);
                    if (ctMember == null || !this.checkMemberIsActualChangesLeaf(spreadManager, ctMember.getDimMemberNumber()) || rowColDimMember == null || !this.getActualChangesFlag(isDataType, isVersion, rowColDimMember.getDimMemberNumber())) continue;
                    log.info("locked_by_FixActualChangesLeafCellLockController_twoDimInRowColViewByChangeTypeAndOther_isChangeTypeInRow&&IsRowColDimInRow:" + ctMember.getDimMemberNumber() + "_" + rowColDimMember.getDimMemberNumber() + "_row=" + row2);
                    styleControlContext.lockRowCol(null, "#FFF8E1", row2, multiAreaManager, true);
                }
                continue;
            }
            if (isChangeTypeInCol && isRowColDimInCol) {
                for (int col3 = 0; col3 < coldimmems.size(); ++col3) {
                    cellDimMembers2 = coldimmems.get(col3);
                    if (cellDimMembers2 == null || cellDimMembers2.size() == 0) continue;
                    ctMember = cellDimMembers2.get(ctIndex);
                    rowColDimMember = cellDimMembers2.get(rowColDimIndex);
                    if (ctMember == null || !this.checkMemberIsActualChangesLeaf(spreadManager, ctMember.getDimMemberNumber()) || rowColDimMember == null || !this.getActualChangesFlag(isDataType, isVersion, rowColDimMember.getDimMemberNumber())) continue;
                    log.info("locked_by_FixActualChangesLeafCellLockController_twoDimInRowColViewByChangeTypeAndOther_isChangeTypeInColAndIsRowColDimInCol:" + ctMember.getDimMemberNumber() + "_" + rowColDimMember.getDimMemberNumber() + "_col=" + col3);
                    styleControlContext.lockRowCol(null, "#FFF8E1", col3, multiAreaManager, false);
                }
                continue;
            }
            PageViewDimMember ctPageMem = multiAreaManager.getAreaPageViewDims().get(CHANGE_TYPE);
            PageViewDimMember rowColPageMem = multiAreaManager.getAreaPageViewDims().get(rowColDimNumber);
            if (ctPageMem != null && rowColPageMem != null) {
                if (!this.checkMemberIsActualChangesLeaf(spreadManager, ctPageMem.getNumber()) || !this.getActualChangesFlag(isDataType, isVersion, rowColPageMem.getNumber())) continue;
                log.info("locked_by_FixActualChangesLeafCellLockController_twoDimInRowColViewByChangeTypeAndOther_ctPageMemAndRowColPageMem_no_null:" + ctPageMem.getNumber() + "_" + rowColPageMem.getNumber());
                for (row = 0; row < rowdimmems.size(); ++row) {
                    styleControlContext.lockRowCol(null, "#FFF8E1", row, multiAreaManager, true);
                }
                continue;
            }
            if (ctPageMem != null && this.checkMemberIsActualChangesLeaf(spreadManager, ctPageMem.getNumber())) {
                if (isRowColDimInRow) {
                    for (row = 0; row < rowdimmems.size(); ++row) {
                        cellDimMembers = rowdimmems.get(row);
                        if (cellDimMembers == null || cellDimMembers.size() == 0 || (rowColDimMember = cellDimMembers.get(rowColDimIndex)) == null || !this.getActualChangesFlag(isDataType, isVersion, rowColDimMember.getDimMemberNumber())) continue;
                        log.info("locked_by_FixActualChangesLeafCellLockController_twoDimInRowColViewByChangeTypeAndOther_ctPageMem_no_null_isRowColDimInRow:" + ctPageMem.getNumber() + "_" + rowColDimMember.getDimMemberNumber() + "_row=" + row);
                        styleControlContext.lockRowCol(null, "#FFF8E1", row, multiAreaManager, true);
                    }
                    continue;
                }
                if (!isRowColDimInCol) continue;
                for (col2 = 0; col2 < coldimmems.size(); ++col2) {
                    cellDimMembers = coldimmems.get(col2);
                    if (cellDimMembers == null || cellDimMembers.size() == 0 || (rowColDimMember = cellDimMembers.get(rowColDimIndex)) == null || !this.getActualChangesFlag(isDataType, isVersion, rowColDimMember.getDimMemberNumber())) continue;
                    log.info("locked_by_FixActualChangesLeafCellLockController_twoDimInRowColViewByChangeTypeAndOther_ctPageMem_no_null_isRowColDimInCol:" + ctPageMem.getNumber() + "_" + rowColDimMember.getDimMemberNumber() + "_col=" + col2);
                    styleControlContext.lockRowCol(null, "#FFF8E1", col2, multiAreaManager, false);
                }
                continue;
            }
            if (rowColPageMem != null) {
                if (isChangeTypeInRow) {
                    for (row = 0; row < rowdimmems.size(); ++row) {
                        cellDimMembers = rowdimmems.get(row);
                        if (cellDimMembers == null || cellDimMembers.size() == 0 || (ctMember = cellDimMembers.get(ctIndex)) == null || !this.checkMemberIsActualChangesLeaf(spreadManager, ctMember.getDimMemberNumber()) || !this.getActualChangesFlag(isDataType, isVersion, rowColPageMem.getNumber())) continue;
                        log.info("locked_by_FixActualChangesLeafCellLockController_twoDimInRowColViewByChangeTypeAndOther_rowColPageMem_no_null_isChangeTypeInRow:" + rowColPageMem.getNumber() + "_" + ctMember.getDimMemberNumber() + "_row=" + row);
                        styleControlContext.lockRowCol(null, "#FFF8E1", row, multiAreaManager, true);
                    }
                    continue;
                }
                if (!isChangeTypeInCol) continue;
                for (col2 = 0; col2 < coldimmems.size(); ++col2) {
                    cellDimMembers = coldimmems.get(col2);
                    if (cellDimMembers == null || cellDimMembers.size() == 0 || (ctMember = cellDimMembers.get(ctIndex)) == null || !this.checkMemberIsActualChangesLeaf(spreadManager, ctMember.getDimMemberNumber()) || !this.getActualChangesFlag(isDataType, isVersion, rowColPageMem.getNumber())) continue;
                    log.info("locked_by_FixActualChangesLeafCellLockController_twoDimInRowColViewByChangeTypeAndOther_rowColPageMem_no_null_isChangeTypeInCol:" + rowColPageMem.getNumber() + "_" + ctMember.getDimMemberNumber() + "_col=" + col2);
                    styleControlContext.lockRowCol(null, "#FFF8E1", col2, multiAreaManager, false);
                }
                continue;
            }
            if (isChangeTypeInRow) {
                for (row = 0; row < rowdimmems.size(); ++row) {
                    rowMembers = rowdimmems.get(row);
                    if (rowMembers == null || rowMembers.size() == 0 || (ctMember = rowMembers.get(ctIndex)) == null || !this.checkMemberIsActualChangesLeaf(spreadManager, ctMember.getDimMemberNumber())) continue;
                    for (col = 0; col < coldimmems.size(); ++col) {
                        colMembers = coldimmems.get(col);
                        if (colMembers == null || colMembers.size() == 0 || (rowColDimMember = colMembers.get(rowColDimIndex)) == null || !this.getActualChangesFlag(isDataType, isVersion, rowColDimMember.getDimMemberNumber())) continue;
                        styleControlContext.lockRowCol(null, "#FFF8E1", row, col, multiAreaManager);
                    }
                }
                continue;
            }
            if (!isChangeTypeInCol) continue;
            for (row = 0; row < rowdimmems.size(); ++row) {
                rowMembers = rowdimmems.get(row);
                if (rowMembers == null || rowMembers.size() == 0 || (rowColDimMember = rowMembers.get(rowColDimIndex)) == null) continue;
                for (col = 0; col < coldimmems.size(); ++col) {
                    colMembers = coldimmems.get(col);
                    if (colMembers == null || colMembers.size() == 0 || (ctMember = colMembers.get(ctIndex)) == null || !this.checkMemberIsActualChangesLeaf(spreadManager, ctMember.getDimMemberNumber()) || !this.getActualChangesFlag(isDataType, isVersion, rowColDimMember.getDimMemberNumber())) continue;
                    styleControlContext.lockRowCol(null, "#FFF8E1", row, col, multiAreaManager);
                }
            }
        }
    }

    private boolean getActualChangesFlag(boolean isDataType, boolean isVersion, String memberNumber) {
        boolean actualChangesFlag = false;
        if (isDataType) {
            actualChangesFlag = !"Actual".equals(memberNumber) || !"ACTUAL".equals(this.versionNumber);
        } else if (isVersion) {
            actualChangesFlag = !"Actual".equals(this.dataTypeNumber) || !"ACTUAL".equals(memberNumber);
        }
        return actualChangesFlag;
    }

    private void threeDimInRowColView(FixSpreadLockContext styleControlContext) {
        if (styleControlContext == null) {
            return;
        }
        IEbSpreadManager spreadManager = styleControlContext.getEbSpreadManager();
        for (MultiAreaManager multiAreaManager : styleControlContext.getEbSpreadManager().getMultiAreaManager()) {
            List<CellDimMember> colMembers;
            int col;
            List<CellDimMember> rowMembers;
            CellDimMember dtMember;
            int col2;
            CellDimMember versionMember;
            List<CellDimMember> cellDimMembers;
            int row;
            CellDimMember versionMember2;
            CellDimMember dtMember2;
            CellDimMember ctMember;
            List<CellDimMember> cellDimMembers2;
            int versionIndex;
            List<List<CellDimMember>> rowdimmems = multiAreaManager.getRowpartitionDimMems();
            List<List<CellDimMember>> coldimmems = multiAreaManager.getColpartitionDimMems();
            List<String> rowdimnums = multiAreaManager.getRowpartitionDims();
            List<String> coldimnums = multiAreaManager.getColpartitionDims();
            boolean isChangeTypeInRow = rowdimnums.contains(CHANGE_TYPE);
            boolean isChangeTypeInCol = coldimnums.contains(CHANGE_TYPE);
            boolean isDataTypeInRow = rowdimnums.contains(DATA_TYPE);
            boolean isDataTypeInCol = coldimnums.contains(DATA_TYPE);
            boolean isVersionInRow = rowdimnums.contains(VERSION);
            boolean isVersionInCol = coldimnums.contains(VERSION);
            int ctIndex = isChangeTypeInRow ? rowdimnums.indexOf(CHANGE_TYPE) : coldimnums.indexOf(CHANGE_TYPE);
            int dtIndex = isDataTypeInRow ? rowdimnums.indexOf(DATA_TYPE) : coldimnums.indexOf(DATA_TYPE);
            int n = versionIndex = isVersionInRow ? rowdimnums.indexOf(VERSION) : coldimnums.indexOf(VERSION);
            if (isChangeTypeInRow && isDataTypeInRow && isVersionInRow) {
                for (int row2 = 0; row2 < rowdimmems.size(); ++row2) {
                    cellDimMembers2 = rowdimmems.get(row2);
                    if (cellDimMembers2 == null || cellDimMembers2.size() == 0) continue;
                    ctMember = cellDimMembers2.get(ctIndex);
                    dtMember2 = cellDimMembers2.get(dtIndex);
                    versionMember2 = cellDimMembers2.get(versionIndex);
                    if (ctMember == null || dtMember2 == null || versionMember2 == null || !this.checkMemberIsActualChangesLeaf(spreadManager, ctMember.getDimMemberNumber()) || !this.isNotActualDataTypeOrVersion(dtMember2.getDimMemberNumber(), versionMember2.getDimMemberNumber())) continue;
                    log.info("locked_by_FixActualChangesLeafCellLockController_threeDimInRowColView_isChangeTypeInRow&&isDataTypeInRow&&isVersionInRow:" + ctMember.getDimMemberNumber() + "_" + dtMember2.getDimMemberNumber() + "_" + versionMember2.getDimMemberNumber() + "_row=" + row2);
                    styleControlContext.lockRowCol(null, "#FFF8E1", row2, multiAreaManager, true);
                }
                continue;
            }
            if (isChangeTypeInCol && isDataTypeInCol && isVersionInCol) {
                for (int col3 = 0; col3 < coldimmems.size(); ++col3) {
                    cellDimMembers2 = coldimmems.get(col3);
                    if (cellDimMembers2 == null || cellDimMembers2.size() == 0) continue;
                    ctMember = cellDimMembers2.get(ctIndex);
                    dtMember2 = cellDimMembers2.get(dtIndex);
                    versionMember2 = cellDimMembers2.get(versionIndex);
                    if (ctMember == null || dtMember2 == null || versionMember2 == null || !this.checkMemberIsActualChangesLeaf(spreadManager, ctMember.getDimMemberNumber()) || !this.isNotActualDataTypeOrVersion(dtMember2.getDimMemberNumber(), versionMember2.getDimMemberNumber())) continue;
                    log.info("locked_by_FixActualChangesLeafCellLockController_threeDimInRowColView_isChangeTypeInCol&&isDataTypeInCol&&isVersionInCol:" + ctMember.getDimMemberNumber() + "_" + dtMember2.getDimMemberNumber() + "_" + versionMember2.getDimMemberNumber() + "_col=" + col3);
                    styleControlContext.lockRowCol(null, "#FFF8E1", col3, multiAreaManager, false);
                }
                continue;
            }
            PageViewDimMember ctPageMem = multiAreaManager.getAreaPageViewDims().get(CHANGE_TYPE);
            PageViewDimMember dtPageMem = multiAreaManager.getAreaPageViewDims().get(DATA_TYPE);
            PageViewDimMember versionPageMem = multiAreaManager.getAreaPageViewDims().get(VERSION);
            if (ctPageMem != null && dtPageMem != null && versionPageMem != null) {
                if (!this.checkMemberIsActualChangesLeaf(spreadManager, ctPageMem.getNumber()) || !this.isNotActualDataTypeOrVersion(dtPageMem.getNumber(), versionPageMem.getNumber())) continue;
                log.info("locked_by_FixActualChangesLeafCellLockController_threeDimInRowColView_ctPageMem&&dtPageMem&&versionPageMem_no_null:" + ctPageMem.getNumber() + "_" + dtPageMem.getNumber() + "_" + versionPageMem.getNumber());
                for (row = 0; row < rowdimmems.size(); ++row) {
                    styleControlContext.lockRowCol(null, "#FFF8E1", row, multiAreaManager, true);
                }
                continue;
            }
            if (ctPageMem != null && dtPageMem != null) {
                if (!this.checkMemberIsActualChangesLeaf(spreadManager, ctPageMem.getNumber())) continue;
                if (!"Actual".equals(dtPageMem.getNumber())) {
                    log.info("locked_by_FixActualChangesLeafCellLockController_threeDimInRowColView_ctPageMem&&dtPageMem_no_null:" + ctPageMem.getNumber() + "_" + dtPageMem.getNumber());
                    for (row = 0; row < rowdimmems.size(); ++row) {
                        styleControlContext.lockRowCol(null, "#FFF8E1", row, multiAreaManager, true);
                    }
                    continue;
                }
                if (isVersionInRow) {
                    for (row = 0; row < rowdimmems.size(); ++row) {
                        cellDimMembers = rowdimmems.get(row);
                        if (cellDimMembers == null || cellDimMembers.size() == 0 || (versionMember = cellDimMembers.get(versionIndex)) == null || "ACTUAL".equals(versionMember.getDimMemberNumber())) continue;
                        log.info("locked_by_FixActualChangesLeafCellLockController_threeDimInRowColView_ctPageMem&&dtPageMem_no_null_isVersionInRow:" + ctPageMem.getNumber() + "_" + dtPageMem.getNumber() + "_" + versionMember.getDimMemberNumber() + "_row=" + row);
                        styleControlContext.lockRowCol(null, "#FFF8E1", row, multiAreaManager, true);
                    }
                    continue;
                }
                if (!isVersionInCol) continue;
                for (col2 = 0; col2 < coldimmems.size(); ++col2) {
                    cellDimMembers = coldimmems.get(col2);
                    if (cellDimMembers == null || cellDimMembers.size() == 0 || (versionMember = cellDimMembers.get(versionIndex)) == null || "ACTUAL".equals(versionMember.getDimMemberNumber())) continue;
                    log.info("locked_by_FixActualChangesLeafCellLockController_threeDimInRowColView_ctPageMem&&dtPageMem_no_null_isVersionInCol:" + ctPageMem.getNumber() + "_" + dtPageMem.getNumber() + "_" + versionMember.getDimMemberNumber() + "_col=" + col2);
                    styleControlContext.lockRowCol(null, "#FFF8E1", col2, multiAreaManager, false);
                }
                continue;
            }
            if (ctPageMem != null && versionPageMem != null) {
                if (!this.checkMemberIsActualChangesLeaf(spreadManager, ctPageMem.getNumber())) continue;
                if (!"ACTUAL".equals(versionPageMem.getNumber())) {
                    log.info("locked_by_FixActualChangesLeafCellLockController_threeDimInRowColView_ctPageMem&&versionPageMem_no_null:" + ctPageMem.getNumber() + "_" + versionPageMem.getNumber());
                    for (row = 0; row < rowdimmems.size(); ++row) {
                        styleControlContext.lockRowCol(null, "#FFF8E1", row, multiAreaManager, true);
                    }
                    continue;
                }
                if (isDataTypeInRow) {
                    for (row = 0; row < rowdimmems.size(); ++row) {
                        cellDimMembers = rowdimmems.get(row);
                        if (cellDimMembers == null || cellDimMembers.size() == 0 || (dtMember = cellDimMembers.get(dtIndex)) == null || "Actual".equals(dtMember.getDimMemberNumber())) continue;
                        log.info("locked_by_FixActualChangesLeafCellLockController_threeDimInRowColView_ctPageMem&&versionPageMem_no_null_isDataTypeInRow:" + ctPageMem.getNumber() + "_" + versionPageMem.getNumber() + "_" + dtMember.getDimMemberNumber() + "_row=" + row);
                        styleControlContext.lockRowCol(null, "#FFF8E1", row, multiAreaManager, true);
                    }
                    continue;
                }
                if (!isDataTypeInCol) continue;
                for (col2 = 0; col2 < coldimmems.size(); ++col2) {
                    cellDimMembers = coldimmems.get(col2);
                    if (cellDimMembers == null || cellDimMembers.size() == 0 || (dtMember = cellDimMembers.get(dtIndex)) == null || "Actual".equals(dtMember.getDimMemberNumber())) continue;
                    log.info("locked_by_FixActualChangesLeafCellLockController_threeDimInRowColView_ctPageMem&&versionPageMem_no_null_isDataTypeInCol:" + ctPageMem.getNumber() + "_" + versionPageMem.getNumber() + "_" + dtMember.getDimMemberNumber() + "_col=" + col2);
                    styleControlContext.lockRowCol(null, "#FFF8E1", col2, multiAreaManager, false);
                }
                continue;
            }
            if (ctPageMem != null) {
                if (!this.checkMemberIsActualChangesLeaf(spreadManager, ctPageMem.getNumber())) continue;
                if (isDataTypeInRow && isVersionInRow) {
                    for (row = 0; row < rowdimmems.size(); ++row) {
                        cellDimMembers = rowdimmems.get(row);
                        if (cellDimMembers == null || cellDimMembers.size() == 0) continue;
                        dtMember = cellDimMembers.get(dtIndex);
                        versionMember = cellDimMembers.get(versionIndex);
                        if (dtMember == null || versionMember == null || !this.isNotActualDataTypeOrVersion(dtMember.getDimMemberNumber(), versionMember.getDimMemberNumber())) continue;
                        log.info("locked_by_FixActualChangesLeafCellLockController_threeDimInRowColView_ctPageMem_no_null_isDataTypeInRow&&isVersionInRow:" + ctPageMem.getNumber() + "_" + dtMember.getDimMemberNumber() + "_" + versionMember.getDimMemberNumber() + "_row=" + row);
                        styleControlContext.lockRowCol(null, "#FFF8E1", row, multiAreaManager, true);
                    }
                    continue;
                }
                if (isDataTypeInCol && isVersionInCol) {
                    for (col2 = 0; col2 < coldimmems.size(); ++col2) {
                        cellDimMembers = coldimmems.get(col2);
                        if (cellDimMembers == null || cellDimMembers.size() == 0) continue;
                        dtMember = cellDimMembers.get(dtIndex);
                        versionMember = cellDimMembers.get(versionIndex);
                        if (dtMember == null || versionMember == null || !this.isNotActualDataTypeOrVersion(dtMember.getDimMemberNumber(), versionMember.getDimMemberNumber())) continue;
                        log.info("locked_by_FixActualChangesLeafCellLockController_threeDimInRowColView_ctPageMem_no_null_isDataTypeInCol&&isVersionInCol:" + ctPageMem.getNumber() + "_" + dtMember.getDimMemberNumber() + "_" + versionMember.getDimMemberNumber() + "_col=" + col2);
                        styleControlContext.lockRowCol(null, "#FFF8E1", col2, multiAreaManager, false);
                    }
                    continue;
                }
                if (isDataTypeInRow) {
                    for (row = 0; row < rowdimmems.size(); ++row) {
                        rowMembers = rowdimmems.get(row);
                        if (rowMembers == null || rowMembers.size() == 0 || (dtMember = rowMembers.get(dtIndex)) == null) continue;
                        for (col = 0; col < coldimmems.size(); ++col) {
                            colMembers = coldimmems.get(col);
                            if (colMembers == null || colMembers.size() == 0 || (versionMember = colMembers.get(versionIndex)) == null || !this.isNotActualDataTypeOrVersion(dtMember.getDimMemberNumber(), versionMember.getDimMemberNumber())) continue;
                            styleControlContext.lockRowCol(null, "#FFF8E1", row, col, multiAreaManager);
                        }
                    }
                    continue;
                }
                if (!isDataTypeInCol) continue;
                for (row = 0; row < rowdimmems.size(); ++row) {
                    rowMembers = rowdimmems.get(row);
                    if (rowMembers == null || rowMembers.size() == 0 || (versionMember = rowMembers.get(versionIndex)) == null) continue;
                    for (col = 0; col < coldimmems.size(); ++col) {
                        colMembers = coldimmems.get(col);
                        if (colMembers == null || colMembers.size() == 0 || (dtMember = colMembers.get(dtIndex)) == null || !this.isNotActualDataTypeOrVersion(dtMember.getDimMemberNumber(), versionMember.getDimMemberNumber())) continue;
                        styleControlContext.lockRowCol(null, "#FFF8E1", row, col, multiAreaManager);
                    }
                }
                continue;
            }
            if (dtPageMem != null && versionPageMem != null) {
                if (isChangeTypeInRow) {
                    for (row = 0; row < rowdimmems.size(); ++row) {
                        CellDimMember ctMember2;
                        cellDimMembers = rowdimmems.get(row);
                        if (cellDimMembers == null || cellDimMembers.size() == 0 || (ctMember2 = cellDimMembers.get(ctIndex)) == null || !this.checkMemberIsActualChangesLeaf(spreadManager, ctMember2.getDimMemberNumber()) || !this.isNotActualDataTypeOrVersion(dtPageMem.getNumber(), versionPageMem.getNumber())) continue;
                        log.info("locked_by_FixActualChangesLeafCellLockController_threeDimInRowColView_dtPageMem&&versionPageMem_no_null_isChangeTypeInRow:" + dtPageMem.getNumber() + "_" + versionPageMem.getNumber() + "_" + ctMember2.getDimMemberNumber() + "_row=" + row);
                        styleControlContext.lockRowCol(null, "#FFF8E1", row, multiAreaManager, true);
                    }
                    continue;
                }
                if (!isChangeTypeInCol) continue;
                for (col2 = 0; col2 < coldimmems.size(); ++col2) {
                    CellDimMember ctMember3;
                    cellDimMembers = coldimmems.get(col2);
                    if (cellDimMembers == null || cellDimMembers.size() == 0 || (ctMember3 = cellDimMembers.get(ctIndex)) == null || !this.checkMemberIsActualChangesLeaf(spreadManager, ctMember3.getDimMemberNumber()) || !this.isNotActualDataTypeOrVersion(dtPageMem.getNumber(), versionPageMem.getNumber())) continue;
                    log.info("locked_by_FixActualChangesLeafCellLockController_threeDimInRowColView_dtPageMem&&versionPageMem_no_null_isChangeTypeInCol:" + dtPageMem.getNumber() + "_" + versionPageMem.getNumber() + "_" + ctMember3.getDimMemberNumber() + "_col=" + col2);
                    styleControlContext.lockRowCol(null, "#FFF8E1", col2, multiAreaManager, false);
                }
                continue;
            }
            if (dtPageMem != null) {
                if (isChangeTypeInRow && isVersionInRow) {
                    for (row = 0; row < rowdimmems.size(); ++row) {
                        cellDimMembers = rowdimmems.get(row);
                        if (cellDimMembers == null || cellDimMembers.size() == 0) continue;
                        CellDimMember ctMember4 = cellDimMembers.get(ctIndex);
                        versionMember = cellDimMembers.get(versionIndex);
                        if (ctMember4 == null || !this.checkMemberIsActualChangesLeaf(spreadManager, ctMember4.getDimMemberNumber()) || versionMember == null || !this.isNotActualDataTypeOrVersion(dtPageMem.getNumber(), versionMember.getDimMemberNumber())) continue;
                        log.info("locked_by_FixActualChangesLeafCellLockController_threeDimInRowColView_dtPageMem_no_null_isChangeTypeInRow&&isVersionInRow:" + dtPageMem.getNumber() + "_" + ctMember4.getDimMemberNumber() + "_" + versionMember.getDimMemberNumber() + "_row=" + row);
                        styleControlContext.lockRowCol(null, "#FFF8E1", row, multiAreaManager, true);
                    }
                    continue;
                }
                if (isChangeTypeInCol && isVersionInCol) {
                    for (col2 = 0; col2 < coldimmems.size(); ++col2) {
                        cellDimMembers = coldimmems.get(col2);
                        if (cellDimMembers == null || cellDimMembers.size() == 0) continue;
                        CellDimMember ctMember5 = cellDimMembers.get(ctIndex);
                        versionMember = cellDimMembers.get(versionIndex);
                        if (ctMember5 == null || !this.checkMemberIsActualChangesLeaf(spreadManager, ctMember5.getDimMemberNumber()) || versionMember == null || !this.isNotActualDataTypeOrVersion(dtPageMem.getNumber(), versionMember.getDimMemberNumber())) continue;
                        log.info("locked_by_FixActualChangesLeafCellLockController_threeDimInRowColView_dtPageMem_no_null_isChangeTypeInCol&&isVersionInCol:" + dtPageMem.getNumber() + "_" + ctMember5.getDimMemberNumber() + "_" + versionMember.getDimMemberNumber() + "_col=" + col2);
                        styleControlContext.lockRowCol(null, "#FFF8E1", col2, multiAreaManager, false);
                    }
                    continue;
                }
                if (isChangeTypeInRow) {
                    for (row = 0; row < rowdimmems.size(); ++row) {
                        CellDimMember ctMember6;
                        rowMembers = rowdimmems.get(row);
                        if (rowMembers == null || rowMembers.size() == 0 || (ctMember6 = rowMembers.get(ctIndex)) == null || !this.checkMemberIsActualChangesLeaf(spreadManager, ctMember6.getDimMemberNumber())) continue;
                        for (col = 0; col < coldimmems.size(); ++col) {
                            colMembers = coldimmems.get(col);
                            if (colMembers == null || colMembers.size() == 0 || (versionMember = colMembers.get(versionIndex)) == null || !this.isNotActualDataTypeOrVersion(dtPageMem.getNumber(), versionMember.getDimMemberNumber())) continue;
                            styleControlContext.lockRowCol(null, "#FFF8E1", row, col, multiAreaManager);
                        }
                    }
                    continue;
                }
                if (!isChangeTypeInCol) continue;
                for (row = 0; row < rowdimmems.size(); ++row) {
                    rowMembers = rowdimmems.get(row);
                    if (rowMembers == null || rowMembers.size() == 0 || (versionMember = rowMembers.get(versionIndex)) == null) continue;
                    for (col = 0; col < coldimmems.size(); ++col) {
                        CellDimMember ctMember7;
                        colMembers = coldimmems.get(col);
                        if (colMembers == null || colMembers.size() == 0 || (ctMember7 = colMembers.get(ctIndex)) == null || !this.checkMemberIsActualChangesLeaf(spreadManager, ctMember7.getDimMemberNumber()) || !this.isNotActualDataTypeOrVersion(dtPageMem.getNumber(), versionMember.getDimMemberNumber())) continue;
                        styleControlContext.lockRowCol(null, "#FFF8E1", row, col, multiAreaManager);
                    }
                }
                continue;
            }
            if (versionPageMem != null) {
                if (isChangeTypeInRow && isDataTypeInRow) {
                    for (row = 0; row < rowdimmems.size(); ++row) {
                        cellDimMembers = rowdimmems.get(row);
                        if (cellDimMembers == null || cellDimMembers.size() == 0) continue;
                        CellDimMember ctMember8 = cellDimMembers.get(ctIndex);
                        dtMember = cellDimMembers.get(dtIndex);
                        if (ctMember8 == null || !this.checkMemberIsActualChangesLeaf(spreadManager, ctMember8.getDimMemberNumber()) || dtMember == null || !this.isNotActualDataTypeOrVersion(dtMember.getDimMemberNumber(), versionPageMem.getNumber())) continue;
                        log.info("locked_by_FixActualChangesLeafCellLockController_threeDimInRowColView_versionPageMem_no_null_isChangeTypeInCol:" + versionPageMem.getNumber() + "_" + ctMember8.getDimMemberNumber() + "_" + dtMember.getDimMemberNumber() + "_row=" + row);
                        styleControlContext.lockRowCol(null, "#FFF8E1", row, multiAreaManager, true);
                    }
                    continue;
                }
                if (isChangeTypeInCol && isDataTypeInCol) {
                    for (col2 = 0; col2 < coldimmems.size(); ++col2) {
                        cellDimMembers = coldimmems.get(col2);
                        if (cellDimMembers == null || cellDimMembers.size() == 0) continue;
                        CellDimMember ctMember9 = cellDimMembers.get(ctIndex);
                        dtMember = cellDimMembers.get(dtIndex);
                        if (ctMember9 == null || !this.checkMemberIsActualChangesLeaf(spreadManager, ctMember9.getDimMemberNumber()) || dtMember == null || !this.isNotActualDataTypeOrVersion(dtMember.getDimMemberNumber(), versionPageMem.getNumber())) continue;
                        log.info("locked_by_FixActualChangesLeafCellLockController_threeDimInRowColView_versionPageMem_no_null_isChangeTypeInCol&&isDataTypeInCol:" + versionPageMem.getNumber() + "_" + ctMember9.getDimMemberNumber() + "_" + dtMember.getDimMemberNumber() + "_col=" + col2);
                        styleControlContext.lockRowCol(null, "#FFF8E1", col2, multiAreaManager, false);
                    }
                    continue;
                }
                if (isChangeTypeInRow) {
                    for (row = 0; row < rowdimmems.size(); ++row) {
                        CellDimMember ctMember10;
                        rowMembers = rowdimmems.get(row);
                        if (rowMembers == null || rowMembers.size() == 0 || (ctMember10 = rowMembers.get(ctIndex)) == null || !this.checkMemberIsActualChangesLeaf(spreadManager, ctMember10.getDimMemberNumber())) continue;
                        for (col = 0; col < coldimmems.size(); ++col) {
                            colMembers = coldimmems.get(col);
                            if (colMembers == null || colMembers.size() == 0 || (dtMember = colMembers.get(dtIndex)) == null || !this.isNotActualDataTypeOrVersion(dtMember.getDimMemberNumber(), versionPageMem.getNumber())) continue;
                            styleControlContext.lockRowCol(null, "#FFF8E1", row, col, multiAreaManager);
                        }
                    }
                    continue;
                }
                if (!isChangeTypeInCol) continue;
                for (row = 0; row < rowdimmems.size(); ++row) {
                    rowMembers = rowdimmems.get(row);
                    if (rowMembers == null || rowMembers.size() == 0 || (dtMember = rowMembers.get(dtIndex)) == null) continue;
                    for (col = 0; col < coldimmems.size(); ++col) {
                        CellDimMember ctMember11;
                        colMembers = coldimmems.get(col);
                        if (colMembers == null || colMembers.size() == 0 || (ctMember11 = colMembers.get(ctIndex)) == null || !this.checkMemberIsActualChangesLeaf(spreadManager, ctMember11.getDimMemberNumber()) || !this.isNotActualDataTypeOrVersion(dtMember.getDimMemberNumber(), versionPageMem.getNumber())) continue;
                        styleControlContext.lockRowCol(null, "#FFF8E1", row, col, multiAreaManager);
                    }
                }
                continue;
            }
            if (isChangeTypeInRow && isDataTypeInRow && isVersionInCol) {
                for (row = 0; row < rowdimmems.size(); ++row) {
                    rowMembers = rowdimmems.get(row);
                    if (rowMembers == null || rowMembers.size() == 0) continue;
                    CellDimMember ctMember12 = rowMembers.get(ctIndex);
                    dtMember = rowMembers.get(dtIndex);
                    if (ctMember12 == null || !this.checkMemberIsActualChangesLeaf(spreadManager, ctMember12.getDimMemberNumber()) || dtMember == null) continue;
                    for (col = 0; col < coldimmems.size(); ++col) {
                        colMembers = coldimmems.get(col);
                        if (colMembers == null || colMembers.size() == 0 || (versionMember = colMembers.get(versionIndex)) == null || !this.isNotActualDataTypeOrVersion(dtMember.getDimMemberNumber(), versionMember.getDimMemberNumber())) continue;
                        styleControlContext.lockRowCol(null, "#FFF8E1", row, col, multiAreaManager);
                    }
                }
                continue;
            }
            if (isChangeTypeInRow && isDataTypeInCol && isVersionInRow) {
                for (row = 0; row < rowdimmems.size(); ++row) {
                    rowMembers = rowdimmems.get(row);
                    if (rowMembers == null || rowMembers.size() == 0) continue;
                    CellDimMember ctMember13 = rowMembers.get(ctIndex);
                    versionMember = rowMembers.get(versionIndex);
                    if (ctMember13 == null || !this.checkMemberIsActualChangesLeaf(spreadManager, ctMember13.getDimMemberNumber()) || versionMember == null) continue;
                    for (col = 0; col < coldimmems.size(); ++col) {
                        colMembers = coldimmems.get(col);
                        if (colMembers == null || colMembers.size() == 0 || (dtMember = colMembers.get(dtIndex)) == null || !this.isNotActualDataTypeOrVersion(dtMember.getDimMemberNumber(), versionMember.getDimMemberNumber())) continue;
                        styleControlContext.lockRowCol(null, "#FFF8E1", row, col, multiAreaManager);
                    }
                }
                continue;
            }
            if (isChangeTypeInRow && isDataTypeInCol && isVersionInCol) {
                for (row = 0; row < rowdimmems.size(); ++row) {
                    CellDimMember ctMember14;
                    rowMembers = rowdimmems.get(row);
                    if (rowMembers == null || rowMembers.size() == 0 || (ctMember14 = rowMembers.get(ctIndex)) == null || !this.checkMemberIsActualChangesLeaf(spreadManager, ctMember14.getDimMemberNumber())) continue;
                    for (col = 0; col < coldimmems.size(); ++col) {
                        colMembers = coldimmems.get(col);
                        if (colMembers == null || colMembers.size() == 0) continue;
                        dtMember = colMembers.get(dtIndex);
                        versionMember = colMembers.get(versionIndex);
                        if (dtMember == null || versionMember == null || !this.isNotActualDataTypeOrVersion(dtMember.getDimMemberNumber(), versionMember.getDimMemberNumber())) continue;
                        styleControlContext.lockRowCol(null, "#FFF8E1", row, col, multiAreaManager);
                    }
                }
                continue;
            }
            if (isChangeTypeInCol && isDataTypeInRow && isVersionInRow) {
                for (row = 0; row < rowdimmems.size(); ++row) {
                    rowMembers = rowdimmems.get(row);
                    if (rowMembers == null || rowMembers.size() == 0) continue;
                    dtMember = rowMembers.get(dtIndex);
                    versionMember = rowMembers.get(versionIndex);
                    if (dtMember == null || versionMember == null) continue;
                    for (col = 0; col < coldimmems.size(); ++col) {
                        CellDimMember ctMember15;
                        colMembers = coldimmems.get(col);
                        if (colMembers == null || colMembers.size() == 0 || (ctMember15 = colMembers.get(ctIndex)) == null || !this.checkMemberIsActualChangesLeaf(spreadManager, ctMember15.getDimMemberNumber()) || !this.isNotActualDataTypeOrVersion(dtMember.getDimMemberNumber(), versionMember.getDimMemberNumber())) continue;
                        styleControlContext.lockRowCol(null, "#FFF8E1", row, col, multiAreaManager);
                    }
                }
                continue;
            }
            if (isChangeTypeInCol && isDataTypeInRow && isVersionInCol) {
                for (row = 0; row < rowdimmems.size(); ++row) {
                    rowMembers = rowdimmems.get(row);
                    if (rowMembers == null || rowMembers.size() == 0 || (dtMember = rowMembers.get(dtIndex)) == null) continue;
                    for (col = 0; col < coldimmems.size(); ++col) {
                        colMembers = coldimmems.get(col);
                        if (colMembers == null || colMembers.size() == 0) continue;
                        CellDimMember ctMember16 = colMembers.get(ctIndex);
                        versionMember = colMembers.get(versionIndex);
                        if (ctMember16 == null || !this.checkMemberIsActualChangesLeaf(spreadManager, ctMember16.getDimMemberNumber()) || versionMember == null || !this.isNotActualDataTypeOrVersion(dtMember.getDimMemberNumber(), versionMember.getDimMemberNumber())) continue;
                        styleControlContext.lockRowCol(null, "#FFF8E1", row, col, multiAreaManager);
                    }
                }
                continue;
            }
            if (!isChangeTypeInCol || !isDataTypeInCol || !isVersionInRow) continue;
            for (row = 0; row < rowdimmems.size(); ++row) {
                rowMembers = rowdimmems.get(row);
                if (rowMembers == null || rowMembers.size() == 0 || (versionMember = rowMembers.get(versionIndex)) == null) continue;
                for (col = 0; col < coldimmems.size(); ++col) {
                    colMembers = coldimmems.get(col);
                    if (colMembers == null || colMembers.size() == 0) continue;
                    CellDimMember ctMember17 = colMembers.get(ctIndex);
                    dtMember = colMembers.get(dtIndex);
                    if (ctMember17 == null || !this.checkMemberIsActualChangesLeaf(spreadManager, ctMember17.getDimMemberNumber()) || dtMember == null || !this.isNotActualDataTypeOrVersion(dtMember.getDimMemberNumber(), versionMember.getDimMemberNumber())) continue;
                    styleControlContext.lockRowCol(null, "#FFF8E1", row, col, multiAreaManager);
                }
            }
        }
    }

    private boolean isNotActualDataTypeOrVersion(String dtMemNumber, String versionMemNumber) {
        return !"Actual".equals(dtMemNumber) || !"ACTUAL".equals(versionMemNumber);
    }
}

