/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.command.lockcontroller.lockcell.fix;

import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.approveBill.ApproveBillQuery;
import kd.epm.eb.common.approveBill.Entity.ApproveBillInfo;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.utils.ApproveAdjustUtils;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.spread.command.lockcontroller.FixSpreadLockContext;
import kd.epm.eb.spread.command.lockcontroller.ISpreadLockControl;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;

public class FixApproveNeedLockCellController
implements ISpreadLockControl {
    private static final long serialVersionUID = 1L;
    private ApproveBillInfo billInfo;
    private static final Log log = LogFactory.getLog(FixApproveNeedLockCellController.class);
    private IFormView view;
    private String reportProcessId;

    public FixApproveNeedLockCellController(String reportProcessId, IFormView view, ApproveBillInfo billInfo) {
        this.reportProcessId = reportProcessId;
        this.view = view;
        this.billInfo = billInfo;
    }

    @Override
    public void controlfix(FixSpreadLockContext styleControlContext) {
        IEbSpreadManager ebSpreadManager = styleControlContext.getEbSpreadManager();
        IModelCacheHelper modelCacheHelper = ebSpreadManager.getModelCacheHelper();
        Long modelId = modelCacheHelper.getModelobj().getId();
        this.setSourceRpt2BillInfo(ebSpreadManager.getReportProcessId());
        try {
            boolean isLock = new ApproveBillQuery().getIsLock(this.reportProcessId, this.billInfo, modelId, this.view);
            if (isLock) {
                this.view.getPageCache().put("reoportIsLock", "true");
                styleControlContext.lockAllData(null, "#E6E8EE");
                styleControlContext.setStopcommand(true);
                log.info("locked by FixApproveNeedLockCellController");
            } else {
                this.view.getPageCache().put("reoportIsLock", "false");
                boolean isVirtual = false;
                if (this.billInfo != null && !ConvertUtils.toLong((Object)this.reportProcessId).equals(this.billInfo.getSourceRptId())) {
                    isVirtual = true;
                }
                boolean approveAdjust = ApproveAdjustUtils.getInstance().approveAdjust(modelId, Long.valueOf(Long.parseLong(this.reportProcessId)), this.view, Long.valueOf(this.billInfo != null ? this.billInfo.getBillId() : 0L), Boolean.valueOf(isVirtual));
                styleControlContext.getParams().put("approveAdjust", approveAdjust);
            }
        }
        catch (Exception e) {
            log.error(CommonServiceHelper.getStackTraceStr((Throwable)e));
            throw new KDBizException(e.getMessage());
        }
        this.setSourceRpt2BillInfo(null);
    }

    private void setSourceRpt2BillInfo(Long sourceRptId) {
        if (this.billInfo != null) {
            this.billInfo.setSourceRptId(sourceRptId);
        }
    }
}

