/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.command.lockcontroller.lockcell.fix;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.Pair;
import kd.epm.eb.common.bgmddatalock.BgmdDataLockService;
import kd.epm.eb.common.bgmddatalock.BgmdDataLockUtils;
import kd.epm.eb.common.bgmddatalock.IBgmdDataLockCache;
import kd.epm.eb.spread.command.lockcontroller.FixSpreadLockContext;
import kd.epm.eb.spread.command.lockcontroller.ISpreadLockControl;
import kd.epm.eb.spread.command.rangedefined.CellArea;
import kd.epm.eb.spread.command.style.AreasStyle;
import kd.epm.eb.spread.template.afix.multimanager.MultiAreaManager;
import kd.epm.eb.spread.template.dimension.PageViewDimMember;
import kd.epm.eb.spread.template.headerarea.IHeaderInfo;
import kd.epm.eb.spread.template.spreadmanager.CellDimMember;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import org.apache.commons.collections4.CollectionUtils;

public class FixDataLockCellLockController
implements ISpreadLockControl {
    private static final Log log = LogFactory.getLog(FixDataLockCellLockController.class);

    @Override
    public void controlfix(FixSpreadLockContext styleControlContext) {
        String memNumber;
        String dimNumber;
        Long bizModel = styleControlContext.getEbSpreadManager().getBusModelid();
        Long modelId = styleControlContext.getEbSpreadManager().getModelobj().getId();
        IBgmdDataLockCache dataLockCache = BgmdDataLockService.getInstance().getDataLockCache(modelId, bizModel);
        Map controlDimNumbers = BgmdDataLockUtils.getControlDimNumberMap();
        IEbSpreadManager ebSpreadManager = styleControlContext.getEbSpreadManager();
        String[] members = new String[controlDimNumbers.size()];
        for (Map.Entry<String, PageViewDimMember> entry : ebSpreadManager.getPageViewDims().entrySet()) {
            dimNumber = entry.getKey();
            String string = memNumber = entry.getValue() != null ? entry.getValue().getNumber() : null;
            if (!controlDimNumbers.containsKey(dimNumber)) continue;
            members[((Integer)controlDimNumbers.get((Object)dimNumber)).intValue()] = memNumber;
        }
        if (this.checkFull(members)) {
            if (dataLockCache.isDataLock(members)) {
                styleControlContext.lockAllData(null, "#E6E8EE");
                log.info("locked by FixDataLockCellLockController");
            }
        } else {
            for (MultiAreaManager multiAreaManager : styleControlContext.getEbSpreadManager().getMultiAreaManager()) {
                String[] members2 = this.copyMembers(members);
                Map<String, PageViewDimMember> pageViewDimMemberMap = multiAreaManager.getAreaPageViewDims();
                for (Map.Entry<String, PageViewDimMember> entry : pageViewDimMemberMap.entrySet()) {
                    dimNumber = entry.getKey();
                    String string = memNumber = entry.getValue() != null ? entry.getValue().getNumber() : null;
                    if (!controlDimNumbers.containsKey(entry.getKey())) continue;
                    members2[((Integer)controlDimNumbers.get((Object)dimNumber)).intValue()] = memNumber;
                }
                if (this.checkFull(members)) {
                    if (!dataLockCache.isDataLock(members)) continue;
                    MultiAreaManager.ValueArea valueArea = multiAreaManager.getValueAreaStart();
                    int rows = multiAreaManager.getAreaRange().getY_end() - valueArea.getData_row_start() + 1;
                    int cols = multiAreaManager.getAreaRange().getX_end() - valueArea.getData_col_start() + 1;
                    AreasStyle areasStyle = multiAreaManager.isUserStyle() ? styleControlContext.getAreaStyle() : styleControlContext.getAreaStyle(null, "#FFF8E1");
                    CellArea cellArea = new CellArea(valueArea.getData_row_start(), valueArea.getData_col_start(), rows, cols);
                    areasStyle.getRange().add(cellArea);
                    styleControlContext.getAreasStyles().add(areasStyle);
                    log.info(multiAreaManager.getAreaRange() + " locked by FixDataLockCellLockController " + members + " cellArea=" + cellArea);
                    continue;
                }
                List<List<CellDimMember>> rowdimmems = multiAreaManager.getRowpartitionDimMems();
                List<List<CellDimMember>> coldimmems = multiAreaManager.getColpartitionDimMems();
                List<Pair<Integer, Integer>> rowPairs = this.genPairs(controlDimNumbers, multiAreaManager.getRowHeaders());
                List<Pair<Integer, Integer>> colPairs = this.genPairs(controlDimNumbers, multiAreaManager.getColHeaders());
                if (rowPairs.isEmpty()) {
                    this.genCellDataLockByOneAxis(styleControlContext, multiAreaManager, dataLockCache, coldimmems, colPairs, members2, false);
                    continue;
                }
                if (colPairs.isEmpty()) {
                    this.genCellDataLockByOneAxis(styleControlContext, multiAreaManager, dataLockCache, rowdimmems, rowPairs, members2, true);
                    continue;
                }
                this.genCellDataLockByTwoAxis(styleControlContext, multiAreaManager, dataLockCache, rowPairs, colPairs, members2);
            }
        }
    }

    private void genCellDataLockByOneAxis(FixSpreadLockContext styleControlContext, MultiAreaManager multiAreaManager, IBgmdDataLockCache dataLockCache, List<List<CellDimMember>> rowcoldimmems, List<Pair<Integer, Integer>> rowcolPairs, String[] members, boolean isRow) {
        for (int rowcol = 0; rowcol < rowcoldimmems.size(); ++rowcol) {
            List<CellDimMember> cellDimMembers = rowcoldimmems.get(rowcol);
            if (CollectionUtils.isEmpty(cellDimMembers)) continue;
            String[] currentMembers = this.copyMembers(members);
            boolean isFack = false;
            for (Pair<Integer, Integer> pair : rowcolPairs) {
                CellDimMember cellDimMember = cellDimMembers.get((Integer)pair.p1);
                if (cellDimMember == null) {
                    isFack = true;
                    break;
                }
                currentMembers[((Integer)pair.p2).intValue()] = cellDimMember.getDimMemberNumber();
            }
            if (isFack || !dataLockCache.isDataLock(currentMembers)) continue;
            styleControlContext.lockRowCol(null, "#FFF8E1", rowcol, multiAreaManager, isRow);
            log.info("locked by FixDataLockCellLockController " + currentMembers + (isRow ? " row=" : " col=" + rowcol));
        }
    }

    private void genCellDataLockByTwoAxis(FixSpreadLockContext styleControlContext, MultiAreaManager multiAreaManager, IBgmdDataLockCache dataLockCache, List<Pair<Integer, Integer>> rowPairs, List<Pair<Integer, Integer>> colPairs, String[] members) {
        List<List<CellDimMember>> rowdimmems = multiAreaManager.getRowpartitionDimMems();
        List<List<CellDimMember>> coldimmems = multiAreaManager.getColpartitionDimMems();
        AreasStyle areasStyle = multiAreaManager.isUserStyle() ? styleControlContext.getAreaStyle() : styleControlContext.getAreaStyle(null, "#FFF8E1");
        MultiAreaManager.ValueArea valueAreaPoint = multiAreaManager.getValueAreaStart();
        for (int row = 0; row < rowdimmems.size(); ++row) {
            List<CellDimMember> cellDimMembers = rowdimmems.get(row);
            if (CollectionUtils.isEmpty(cellDimMembers)) continue;
            String[] currentMembers = this.copyMembers(members);
            boolean isFack = false;
            for (Pair<Integer, Integer> firstPair : rowPairs) {
                CellDimMember cellDimMember = cellDimMembers.get((Integer)firstPair.p1);
                if (cellDimMember == null) {
                    isFack = true;
                    break;
                }
                currentMembers[((Integer)firstPair.p2).intValue()] = cellDimMember.getDimMemberNumber();
            }
            if (isFack) continue;
            for (int col = 0; col < coldimmems.size(); ++col) {
                List<CellDimMember> cellDimMembers2 = coldimmems.get(col);
                if (CollectionUtils.isEmpty(cellDimMembers2)) continue;
                String[] currentMembers2 = this.copyMembers(currentMembers);
                isFack = false;
                for (Pair<Integer, Integer> secondPair : colPairs) {
                    CellDimMember cellDimMember = cellDimMembers2.get((Integer)secondPair.p1);
                    if (cellDimMember == null) {
                        isFack = true;
                        break;
                    }
                    currentMembers2[((Integer)secondPair.p2).intValue()] = cellDimMember.getDimMemberNumber();
                }
                if (isFack || !dataLockCache.isDataLock(currentMembers2)) continue;
                CellArea cellArea = new CellArea(valueAreaPoint.getData_row_start() + row, valueAreaPoint.getData_col_start() + col, 1, 1);
                areasStyle.getRange().add(cellArea);
                log.info(multiAreaManager.getAreaRange() + " locked by FixDataLockCellLockController " + currentMembers2 + " cellArea=" + cellArea);
            }
        }
        if (!areasStyle.getRange().isEmpty()) {
            styleControlContext.getAreasStyles().add(areasStyle);
        }
    }

    private List<Pair<Integer, Integer>> genPairs(Map<String, Integer> controlDimNumbers, List<IHeaderInfo> headerInfos) {
        ArrayList<Pair<Integer, Integer>> pairs = new ArrayList<Pair<Integer, Integer>>(10);
        for (int i = 0; i < headerInfos.size(); ++i) {
            IHeaderInfo headerInfo = headerInfos.get(i);
            if (headerInfo == null || !"Dimension".equals(headerInfo.getType()) || !controlDimNumbers.containsKey(headerInfo.getNumber())) continue;
            pairs.add((Pair<Integer, Integer>)new Pair((Object)i, (Object)controlDimNumbers.get(headerInfo.getNumber())));
        }
        return pairs;
    }

    private String[] copyMembers(String[] members) {
        String[] currentMembers = new String[members.length];
        System.arraycopy(members, 0, currentMembers, 0, members.length);
        return currentMembers;
    }

    private boolean checkFull(String[] members) {
        for (String member : members) {
            if (member != null) continue;
            return false;
        }
        return true;
    }
}

