/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.command.lockcontroller.lockcell.fix;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.AuditTrailUseEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.permission.IMemberPermCache;
import kd.epm.eb.common.permission.membPerm.DimMemberPermChecker;
import kd.epm.eb.common.permission.membPerm.MemberItem;
import kd.epm.eb.common.permission.pojo.PermDimGroup;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.spread.command.lockcontroller.FixSpreadLockContext;
import kd.epm.eb.spread.command.lockcontroller.ISpreadLockControl;
import kd.epm.eb.spread.command.lockcontroller.lockcell.MemPermControllerHelper;
import kd.epm.eb.spread.command.rangedefined.CellArea;
import kd.epm.eb.spread.command.style.AreasStyle;
import kd.epm.eb.spread.template.afix.multimanager.MultiAreaManager;
import kd.epm.eb.spread.template.dimension.PageViewDimMember;
import kd.epm.eb.spread.template.spreadmanager.CellDimMember;

public class FixNoLeafCellLockController
implements ISpreadLockControl {
    private static final Log log = LogFactory.getLog(FixNoLeafCellLockController.class);
    private Set<String> offsetAuditTrails = null;

    @Override
    public void controlfix(FixSpreadLockContext styleControlContext) {
        if (styleControlContext == null || styleControlContext.getEbSpreadManager() == null) {
            return;
        }
        this.checkRowColsLock(styleControlContext, false);
        this.checkRowColsLock(styleControlContext, true);
    }

    private void checkRowColsLock(FixSpreadLockContext styleControlContext, boolean isrow) {
        IMemberPermCache memberPermCache = styleControlContext.getEbSpreadManager().getMemberPerm();
        IModelCacheHelper modelCacheHelper = styleControlContext.getEbSpreadManager().getModelCacheHelper();
        Long modelId = styleControlContext.getEbSpreadManager().getModelobj().getId();
        Long datasetId = styleControlContext.getEbSpreadManager().getDatasetid();
        if (modelCacheHelper == null) {
            modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
        }
        Set needCheckAnalyseView = modelCacheHelper.getDimensionList().stream().filter(dimension -> !dimension.isPreset() || SysDimensionEnum.Entity.getNumber().equals(dimension.getNumber())).map(BaseCache::getNumber).collect(Collectors.toSet());
        Map<String, Long> dimensionViews = null;
        if (styleControlContext.getEbSpreadManager() != null) {
            dimensionViews = styleControlContext.getEbSpreadManager().getDimemsionViews();
        }
        List<String> dimnumbers = null;
        List<String> dimnumbers_otherside = null;
        Map<String, Member> pageViewDimMemIds = null;
        HashMap<String, Member> apvDimMemIds = new HashMap<String, Member>(16);
        boolean areaLocked = false;
        List<PermDimGroup> permDimGroups = MemPermControllerHelper.getPermDimGroupsWithData(modelId, datasetId);
        DimMemberPermChecker writePermChecker = MemPermControllerHelper.getWritePermChecker(styleControlContext.getEbSpreadManager());
        boolean needCheckMemPerm = writePermChecker != null && !writePermChecker.hasAllPerm();
        List<PermDimGroup> rowColPermDimGroups = null;
        for (MultiAreaManager multiAreaManager : styleControlContext.getEbSpreadManager().getMultiAreaManager()) {
            List<List<CellDimMember>> rowcoldimmems;
            String memNumber;
            String dimNumber;
            Map<String, PageViewDimMember> pageViewDimMemberMap = multiAreaManager.getAreaPageViewDims();
            areaLocked = false;
            if (pageViewDimMemberMap != null && pageViewDimMemberMap.size() > 0 && isrow) {
                for (Map.Entry<String, PageViewDimMember> entry : pageViewDimMemberMap.entrySet()) {
                    AreasStyle areasStyle;
                    boolean offsetAT;
                    PageViewDimMember pageViewDimMember = entry.getValue();
                    if (pageViewDimMember == null) continue;
                    dimNumber = entry.getKey();
                    memNumber = pageViewDimMember.getNumber();
                    Long viewId = DimensionViewServiceHelper.getViewId(dimensionViews, (String)dimNumber, (String)multiAreaManager.getAreaIndex());
                    Member member = modelCacheHelper.getMember(dimNumber, viewId, memNumber);
                    if (member != null) {
                        apvDimMemIds.put(dimNumber, member);
                    }
                    boolean changeType = SysDimensionEnum.ChangeType.getNumber().equals(dimNumber) && ("Occupation".equals(memNumber) || "Execute".equals(memNumber));
                    boolean noWritePerm = !memberPermCache.hasWritePerm(dimNumber, memNumber, viewId);
                    boolean offsetOrg = memNumber != null && memNumber.endsWith("offsetentry") && SysDimensionEnum.Entity.getNumber().equals(dimNumber);
                    boolean bl = offsetAT = SysDimensionEnum.AuditTrail.getNumber().equals(dimNumber) && this.isOffsetAuditTrail(memNumber, styleControlContext);
                    if (!changeType && !noWritePerm && !offsetOrg && !offsetAT) continue;
                    MultiAreaManager.ValueArea valueArea = multiAreaManager.getValueAreaStart();
                    int rows = multiAreaManager.getAreaRange().getY_end() - valueArea.getData_row_start() + 1;
                    int cols = multiAreaManager.getAreaRange().getX_end() - valueArea.getData_col_start() + 1;
                    AreasStyle areasStyle2 = areasStyle = multiAreaManager.isUserStyle() ? styleControlContext.getAreaStyle() : styleControlContext.getAreaStyle(null, "#FFF8E1");
                    if (areasStyle.getRange() == null) {
                        areasStyle.setRange(new ArrayList<CellArea>());
                    }
                    areasStyle.getRange().add(new CellArea(valueArea.getData_row_start(), valueArea.getData_col_start(), rows, cols));
                    styleControlContext.getAreasStyles().add(areasStyle);
                    areaLocked = true;
                    log.info(multiAreaManager.getAreaRange() + " locked by " + (changeType ? "changeType" : (noWritePerm ? "onlyReadPerm" : (offsetOrg ? "offsetOrg" : (offsetAT ? "offsetAT" : "notPossible")))) + " areaIndex=" + multiAreaManager.getAreaIndex() + " dimNumber=" + dimNumber + " memNumber=" + memNumber);
                    break;
                }
            }
            if (areaLocked) continue;
            if (!isrow) {
                rowcoldimmems = multiAreaManager.getColpartitionDimMems();
                dimnumbers = multiAreaManager.getColpartitionDims();
                dimnumbers_otherside = multiAreaManager.getRowpartitionDims();
            } else {
                rowcoldimmems = multiAreaManager.getRowpartitionDimMems();
                dimnumbers = multiAreaManager.getRowpartitionDims();
                dimnumbers_otherside = multiAreaManager.getColpartitionDims();
            }
            int dimSize = dimnumbers.size();
            for (int rowcol = 0; rowcol < rowcoldimmems.size(); ++rowcol) {
                boolean isFullDimMems;
                List<CellDimMember> cellDimMembers = rowcoldimmems.get(rowcol);
                if (cellDimMembers == null || cellDimMembers.size() == 0) continue;
                boolean lock = false;
                int i = 0;
                for (CellDimMember cellDimMember : cellDimMembers) {
                    boolean noWritePerm;
                    if (cellDimMember == null || i >= dimSize) break;
                    if (cellDimMember.isProperty()) continue;
                    dimNumber = dimnumbers.get(i);
                    memNumber = cellDimMember.getDimMemberNumber();
                    ++i;
                    boolean changeType = SysDimensionEnum.ChangeType.getNumber().equals(dimNumber) && ("Occupation".equals(memNumber) || "Execute".equals(memNumber));
                    Long viewId = DimensionViewServiceHelper.getViewId(dimensionViews, (String)dimNumber, (String)multiAreaManager.getAreaIndex());
                    boolean bl = noWritePerm = !memberPermCache.hasWritePerm(dimNumber, memNumber, viewId);
                    if (!changeType && !noWritePerm) continue;
                    lock = true;
                    log.info(multiAreaManager.getAreaRange() + " locked by " + (changeType ? "changeType" : (noWritePerm ? "onlyReadPerm" : "notPossible")) + (isrow ? " row=" : " col=") + rowcol + " dimNumber=" + dimNumber + " memNumber=" + memNumber);
                    break;
                }
                boolean bl = isFullDimMems = i == dimSize;
                if (!lock && needCheckMemPerm && isFullDimMems) {
                    if (rowColPermDimGroups == null) {
                        rowColPermDimGroups = MemPermControllerHelper.getRowColPermGroup(multiAreaManager, isrow, permDimGroups);
                    }
                    if (rowColPermDimGroups != null && rowColPermDimGroups.size() > 0) {
                        if (pageViewDimMemIds == null) {
                            pageViewDimMemIds = MemPermControllerHelper.getPageViewDimMemIds(styleControlContext.getEbSpreadManager());
                        }
                        for (PermDimGroup permDimGroup : rowColPermDimGroups) {
                            if (dimnumbers_otherside.stream().anyMatch(e -> permDimGroup.getDimNums().contains(e))) continue;
                            HashSet<String> dimNumSet = new HashSet<String>(permDimGroup.getDimNums());
                            dimNumSet.addAll(dimnumbers);
                            HashMap<String, MemberItem> memberGroup = new HashMap<String, MemberItem>(16);
                            pageViewDimMemIds.forEach((k, v) -> memberGroup.put((String)k, new MemberItem(true, v.getId(), v.getNumber())));
                            apvDimMemIds.forEach((k, v) -> memberGroup.put((String)k, new MemberItem(true, v.getId(), v.getNumber())));
                            MemPermControllerHelper.putInMemberGroup(modelCacheHelper, dimensionViews, dimnumbers, cellDimMembers, dimNumSet, memberGroup, multiAreaManager.getAreaIndex());
                            if (writePermChecker.check(memberGroup)) continue;
                            lock = true;
                            log.info(String.format(multiAreaManager.getAreaRange() + " locked by writePermChecker.check %s %s %s", ((Object)memberGroup).toString(), isrow ? "row=" : "col=", rowcol));
                            break;
                        }
                    }
                }
                if (!lock) continue;
                styleControlContext.lockRowCol(null, "#FFF8E1", rowcol, multiAreaManager, isrow);
            }
        }
    }

    private boolean isOffsetAuditTrail(String memNumber, FixSpreadLockContext styleControlContext) {
        if (this.offsetAuditTrails == null) {
            IModelCacheHelper modelCacheHelper = styleControlContext.getEbSpreadManager().getModelCacheHelper();
            if (modelCacheHelper == null && styleControlContext.getEbSpreadManager().getModelobj() != null) {
                modelCacheHelper = ModelCacheContext.getOrCreate((Long)styleControlContext.getEbSpreadManager().getModelobj().getId());
            }
            if (modelCacheHelper != null) {
                this.offsetAuditTrails = modelCacheHelper.getMembers(SysDimensionEnum.AuditTrail.getNumber()).stream().filter(e -> AuditTrailUseEnum.AUTO_OFFSET.getCode().equals(e.getAuditTrailUse())).map(BaseCache::getNumber).collect(Collectors.toSet());
                return this.offsetAuditTrails.contains(memNumber);
            }
        } else {
            return this.offsetAuditTrails.contains(memNumber);
        }
        return false;
    }
}

