/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.command.lockcontroller.lockcell.fix;

import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.form.IFormView;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.enums.AuditTrailUseEnum;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.spread.command.lockcontroller.FixSpreadLockContext;
import kd.epm.eb.spread.command.lockcontroller.ISpreadLockControl;
import kd.epm.eb.spread.command.lockcontroller.lockcell.PageViewDimNoLeafController;
import kd.epm.eb.spread.template.dimension.PageViewDimMember;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.utils.ReportHelper;

public class FixPageViewDimNoLeafController
implements ISpreadLockControl {
    private static final Log log = LogFactory.getLog(FixPageViewDimNoLeafController.class);
    public static final String DARKCOLOR = "#E6E8EE";
    public static final String YELLOW_COLOR = "#FFF8E1";
    public static final String WHITE_COLOR = "#FFFFFF";
    public static final String BLACK_COLOR = "#000000";
    private IFormView view;

    public FixPageViewDimNoLeafController(IFormView view) {
        this.view = view;
    }

    @Override
    public void controlfix(FixSpreadLockContext styleControlContext) {
        boolean inProcessApproveBill;
        if (styleControlContext == null || styleControlContext.getEbSpreadManager() == null) {
            return;
        }
        IEbSpreadManager ebSpreadManager = styleControlContext.getEbSpreadManager();
        boolean needlock = false;
        boolean bl = inProcessApproveBill = this.view.getPageCache().get("inProcessApproveBill") != null;
        if (!inProcessApproveBill && ProcessTypeEnum.REPORT.getNumber().equals(ebSpreadManager.getProcessType()) && ebSpreadManager.getProcessId() != null) {
            if (ReportHelper.isRptSchemeClosed(ebSpreadManager.getProcessId())) {
                needlock = true;
                log.info("locked by ReportHelper.isRptSchemeClosed = true");
            }
        } else if (!inProcessApproveBill && ProcessTypeEnum.TASK.getNumber().equals(ebSpreadManager.getProcessType()) && ReportHelper.isTaskUnable(ebSpreadManager.getProcessId())) {
            needlock = true;
            log.info("locked by ReportHelper.isTaskUnable = true");
        }
        if (styleControlContext.getTemplateModel() != null && styleControlContext.getTemplateModel().getTemplateBaseInfo() != null) {
            Long templateId = styleControlContext.getTemplateModel().getTemplateBaseInfo().getId();
            try {
                String openByHyperLinkCache;
                DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)templateId, (String)"eb_templateentity", (String)"isReadOnly,rptreadonly");
                if (dynamicObject != null && dynamicObject.getBoolean("isReadOnly")) {
                    needlock = true;
                    log.info("locked by isReadOnly = true");
                }
                if (dynamicObject != null && !dynamicObject.getBoolean("isReadOnly") && dynamicObject.getBoolean("rptreadonly")) {
                    needlock = true;
                    log.info("locked by isReadOnly = false and rptreadonly = true");
                }
                if (StringUtils.isNotEmpty((String)(openByHyperLinkCache = this.view.getPageCache().get("openByHyperLink_" + ebSpreadManager.getReportProcessId())))) {
                    needlock = true;
                    log.info("locked by isReadOnly = true  openByHyperLink");
                }
            }
            catch (Exception dynamicObject) {
                // empty catch block
            }
        }
        if (!needlock) {
            IModelCacheHelper modelCacheHelper = styleControlContext.getEbSpreadManager().getModelCacheHelper();
            if (modelCacheHelper == null) {
                modelCacheHelper = ModelCacheContext.getOrCreate((Long)styleControlContext.getEbSpreadManager().getModelobj().getId());
            }
            Map<String, Long> dimensionViews = null;
            if (styleControlContext.getEbSpreadManager() != null) {
                dimensionViews = styleControlContext.getEbSpreadManager().getDimemsionViews();
            }
            for (Map.Entry<String, PageViewDimMember> stringStringEntry : ebSpreadManager.getPageViewDims().entrySet()) {
                boolean offsetAT;
                String dimNumber = stringStringEntry.getKey();
                String memNumber = stringStringEntry.getValue() != null ? stringStringEntry.getValue().getNumber() : null;
                Long viewId = ebSpreadManager.getDimemsionViews().get(dimNumber);
                boolean changeType = SysDimensionEnum.ChangeType.getNumber().equals(dimNumber) && ("Occupation".equals(memNumber) || "Execute".equals(memNumber));
                boolean noWritePerm = ebSpreadManager.isNeedCheckPerm() && !ebSpreadManager.getMemberPerm().hasWritePerm(dimNumber, memNumber, viewId);
                boolean offsetOrg = memNumber != null && memNumber.endsWith("offsetentry") && SysDimensionEnum.Entity.getNumber().equals(dimNumber);
                boolean bl2 = offsetAT = SysDimensionEnum.AuditTrail.getNumber().equals(dimNumber) && this.isOffsetAuditTrail(memNumber, styleControlContext);
                if (!changeType && !noWritePerm && !offsetOrg && !offsetAT) continue;
                needlock = true;
                log.info("locked by " + (changeType ? "changeType" : (noWritePerm ? "noWritePerm" : (offsetOrg ? "offsetOrg" : (offsetAT ? "offsetAT" : "notPossible")))) + " dimNumber=" + dimNumber + " memNumber=" + memNumber);
                break;
            }
        }
        if (!needlock) {
            needlock = new PageViewDimNoLeafController(this.view).isMemPermReadOnly(styleControlContext.getEbSpreadManager());
        }
        if (needlock) {
            styleControlContext.lockAllData(null, DARKCOLOR);
            styleControlContext.setStopcommand(true);
            log.info("locked by FixPageViewDimNoLeafController");
        }
    }

    private boolean isOffsetAuditTrail(String memNumber, FixSpreadLockContext styleControlContext) {
        if (memNumber != null) {
            Member member;
            IModelCacheHelper modelCacheHelper = styleControlContext.getEbSpreadManager().getModelCacheHelper();
            if (modelCacheHelper == null && styleControlContext.getEbSpreadManager().getModelobj() != null) {
                modelCacheHelper = ModelCacheContext.getOrCreate((Long)styleControlContext.getEbSpreadManager().getModelobj().getId());
            }
            if (modelCacheHelper != null && (member = modelCacheHelper.getMember(SysDimensionEnum.AuditTrail.getNumber(), null, memNumber)) != null && AuditTrailUseEnum.AUTO_OFFSET.getCode().equals(member.getAuditTrailUse())) {
                return true;
            }
        }
        return false;
    }
}

