/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.command.lockcontroller.lockcell.fix;

import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.spread.command.lockcontroller.FixSpreadLockContext;
import kd.epm.eb.spread.command.lockcontroller.ISpreadLockControl;
import kd.epm.eb.spread.template.afix.multimanager.MultiAreaManager;
import kd.epm.eb.spread.template.dimension.PageViewDimMember;
import kd.epm.eb.spread.template.spreadmanager.CellDimMember;

public class FixRollCellLockController
implements ISpreadLockControl {
    public static final String DARKCOLOR = "#E6E8EE";
    private Map<String, Date> rollStartDates = new HashMap<String, Date>(16);
    private Map<String, Date> periodStartDates = new HashMap<String, Date>(16);
    private static final String DATATYPE = SysDimensionEnum.DataType.getNumber();
    private static final String BUDGETPERIOD = SysDimensionEnum.BudgetPeriod.getNumber();
    private static final Log log = LogFactory.getLog(FixRollCellLockController.class);

    @Override
    public void controlfix(FixSpreadLockContext styleControlContext) {
        this.initRollDateStart(styleControlContext);
        if (this.rollStartDates != null && this.rollStartDates.size() > 0) {
            Map<String, PageViewDimMember> pvDimMems = styleControlContext.getEbSpreadManager().getPageViewDims();
            PageViewDimMember pvDim_dataType = pvDimMems.get(DATATYPE);
            PageViewDimMember pvDim_bPeriod = pvDimMems.get(BUDGETPERIOD);
            Date pStartDate = null;
            Date rStartDate = null;
            if (pvDim_bPeriod != null && pvDim_dataType != null) {
                pStartDate = this.periodStartDates.get(pvDim_bPeriod.getNumber());
                rStartDate = this.rollStartDates.get(pvDim_dataType.getNumber());
                if (pStartDate != null && rStartDate != null && pStartDate.before(rStartDate)) {
                    styleControlContext.lockAllData(null, DARKCOLOR);
                    styleControlContext.setStopcommand(true);
                    log.info("locked by FixRollCellLockController");
                }
            } else if (pvDim_dataType != null) {
                this.dataTypeInPageView(styleControlContext, this.rollStartDates.get(pvDim_dataType.getNumber()));
            } else if (pvDim_bPeriod != null) {
                this.periodInPageView(styleControlContext, this.periodStartDates.get(pvDim_bPeriod.getNumber()));
            } else {
                this.checkRowColsLock(styleControlContext);
            }
        }
    }

    private void initRollDateStart(FixSpreadLockContext styleControlContext) {
        if (styleControlContext != null) {
            Map periodMemsMap;
            Map dataTypeMemsMap;
            Set<String> dataTypeMems = styleControlContext.getEbSpreadManager().getAlldimensionWithMembers().get(DATATYPE);
            Set<String> periodMems = styleControlContext.getEbSpreadManager().getAlldimensionWithMembers().get(BUDGETPERIOD);
            if (dataTypeMems != null && (dataTypeMemsMap = BusinessDataServiceHelper.loadFromCache((String)"epm_datatypemembertree", (String)"longnumber,datestart", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)styleControlContext.getEbSpreadManager().getModelobj().getId()), new QFilter("number", "in", dataTypeMems)})) != null && dataTypeMemsMap.size() > 0) {
                String rollPrefix = "DataType!RollBudget";
                for (DynamicObject dynamicObject : dataTypeMemsMap.values()) {
                    if (dynamicObject.getString("longnumber") == null || !dynamicObject.getString("longnumber").startsWith(rollPrefix)) continue;
                    this.rollStartDates.put(dynamicObject.getString("number"), dynamicObject.getDate("datestart"));
                }
            }
            if (this.rollStartDates.size() > 0 && periodMems != null && (periodMemsMap = BusinessDataServiceHelper.loadFromCache((String)"epm_bperiodmembertree", (String)"startdate", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)styleControlContext.getEbSpreadManager().getModelobj().getId()), new QFilter("number", "in", periodMems)})) != null && periodMemsMap.size() > 0) {
                for (DynamicObject dynamicObject : periodMemsMap.values()) {
                    this.periodStartDates.put(dynamicObject.getString("number"), dynamicObject.getDate("startdate"));
                }
            }
        }
    }

    private void checkRowColsLock(FixSpreadLockContext styleControlContext) {
        if (styleControlContext == null) {
            return;
        }
        for (MultiAreaManager multiAreaManager : styleControlContext.getEbSpreadManager().getMultiAreaManager()) {
            CellDimMember pMember;
            int col;
            CellDimMember dMember;
            List<CellDimMember> cellDimMembers;
            int row;
            Date dDate;
            Date pDate;
            Date dDate2;
            Date pDate2;
            int dIndex;
            List<List<CellDimMember>> rowdimmems = multiAreaManager.getRowpartitionDimMems();
            List<List<CellDimMember>> coldimmems = multiAreaManager.getColpartitionDimMems();
            List<String> rowdimnums = multiAreaManager.getRowpartitionDims();
            List<String> coldimnums = multiAreaManager.getColpartitionDims();
            boolean periodInRow = rowdimnums.contains(BUDGETPERIOD);
            boolean dataTypeInRow = rowdimnums.contains(DATATYPE);
            boolean periodInCol = coldimnums.contains(BUDGETPERIOD);
            boolean dataTypeInCol = coldimnums.contains(DATATYPE);
            int pIndex = periodInRow ? rowdimnums.indexOf(BUDGETPERIOD) : coldimnums.indexOf(BUDGETPERIOD);
            int n = dIndex = dataTypeInRow ? rowdimnums.indexOf(DATATYPE) : coldimnums.indexOf(DATATYPE);
            if (periodInRow && dataTypeInRow) {
                for (int row2 = 0; row2 < rowdimmems.size(); ++row2) {
                    List<CellDimMember> cellDimMembers2 = rowdimmems.get(row2);
                    if (cellDimMembers2 == null || cellDimMembers2.size() == 0) continue;
                    CellDimMember pMember2 = cellDimMembers2.get(pIndex);
                    CellDimMember dMember2 = cellDimMembers2.get(dIndex);
                    if (pMember2 == null || dMember2 == null || (pDate2 = this.periodStartDates.get(pMember2.getDimMemberNumber())) == null || (dDate2 = this.rollStartDates.get(dMember2.getDimMemberNumber())) == null || !pDate2.before(dDate2)) continue;
                    styleControlContext.lockRowCol(null, "#FFF8E1", row2, multiAreaManager, true);
                    log.info("locked by FixRollCellLockController row=" + row2);
                }
                continue;
            }
            if (periodInCol && dataTypeInCol) {
                for (int col2 = 0; col2 < coldimmems.size(); ++col2) {
                    List<CellDimMember> cellDimMembers3 = coldimmems.get(col2);
                    if (cellDimMembers3 == null || cellDimMembers3.size() == 0) continue;
                    CellDimMember pMember3 = cellDimMembers3.get(pIndex);
                    CellDimMember dMember3 = cellDimMembers3.get(dIndex);
                    if (pMember3 == null || dMember3 == null || (pDate2 = this.periodStartDates.get(pMember3.getDimMemberNumber())) == null || (dDate2 = this.rollStartDates.get(dMember3.getDimMemberNumber())) == null || !pDate2.before(dDate2)) continue;
                    styleControlContext.lockRowCol(null, "#FFF8E1", col2, multiAreaManager, false);
                    log.info("locked by FixRollCellLockController col=" + col2);
                }
                continue;
            }
            PageViewDimMember apvP = multiAreaManager.getAreaPageViewDims().get(BUDGETPERIOD);
            PageViewDimMember apvD = multiAreaManager.getAreaPageViewDims().get(DATATYPE);
            if (apvP != null && apvD != null && (pDate = this.periodStartDates.get(apvP.getNumber())) != null && (dDate = this.rollStartDates.get(apvD.getNumber())) != null) {
                if (!pDate.before(dDate)) continue;
                for (row = 0; row < rowdimmems.size(); ++row) {
                    styleControlContext.lockRowCol(null, "#FFF8E1", row, multiAreaManager, true);
                    log.info("locked by FixRollCellLockController row=" + row);
                }
                continue;
            }
            if (apvP != null && (pDate = this.periodStartDates.get(apvP.getNumber())) != null) {
                if (dataTypeInRow) {
                    for (row = 0; row < rowdimmems.size(); ++row) {
                        cellDimMembers = rowdimmems.get(row);
                        if (cellDimMembers == null || cellDimMembers.size() == 0 || (dMember = cellDimMembers.get(dIndex)) == null || (dDate = this.rollStartDates.get(dMember.getDimMemberNumber())) == null || !pDate.before(dDate)) continue;
                        styleControlContext.lockRowCol(null, "#FFF8E1", row, multiAreaManager, true);
                        log.info("locked by FixRollCellLockController row=" + row);
                    }
                    continue;
                }
                if (!dataTypeInCol) continue;
                for (col = 0; col < coldimmems.size(); ++col) {
                    cellDimMembers = coldimmems.get(col);
                    if (cellDimMembers == null || cellDimMembers.size() == 0 || (dMember = cellDimMembers.get(dIndex)) == null || (dDate = this.rollStartDates.get(dMember.getDimMemberNumber())) == null || !pDate.before(dDate)) continue;
                    styleControlContext.lockRowCol(null, "#FFF8E1", col, multiAreaManager, false);
                    log.info("locked by FixRollCellLockController col=" + col);
                }
                continue;
            }
            if (apvD != null && (dDate = this.rollStartDates.get(apvD.getNumber())) != null) {
                if (periodInRow) {
                    for (row = 0; row < rowdimmems.size(); ++row) {
                        cellDimMembers = rowdimmems.get(row);
                        if (cellDimMembers == null || cellDimMembers.size() == 0 || (pMember = cellDimMembers.get(pIndex)) == null || (pDate = this.periodStartDates.get(pMember.getDimMemberNumber())) == null || !pDate.before(dDate)) continue;
                        styleControlContext.lockRowCol(null, "#FFF8E1", row, multiAreaManager, true);
                        log.info("locked by FixRollCellLockController row=" + row);
                    }
                    continue;
                }
                if (!periodInCol) continue;
                for (col = 0; col < coldimmems.size(); ++col) {
                    cellDimMembers = coldimmems.get(col);
                    if (cellDimMembers == null || cellDimMembers.size() == 0 || (pMember = cellDimMembers.get(pIndex)) == null || (pDate = this.periodStartDates.get(pMember.getDimMemberNumber())) == null || !pDate.before(dDate)) continue;
                    styleControlContext.lockRowCol(null, "#FFF8E1", col, multiAreaManager, false);
                    log.info("locked by FixRollCellLockController col=" + col);
                }
                continue;
            }
            if (dataTypeInRow) {
                int rowIndexOfD = rowdimnums.indexOf(DATATYPE);
                for (row = 0; row < rowdimmems.size(); ++row) {
                    int colIndexOfP;
                    List<CellDimMember> rowMembers = rowdimmems.get(row);
                    if (rowMembers == null || (dMember = rowMembers.get(rowIndexOfD)) == null || this.rollStartDates.get(dMember.getDimMemberNumber()) == null || (colIndexOfP = coldimnums.indexOf(BUDGETPERIOD)) < 0) continue;
                    for (int col3 = 0; col3 < coldimmems.size(); ++col3) {
                        List<CellDimMember> colMembers = coldimmems.get(col3);
                        if (colMembers == null || (pMember = colMembers.get(colIndexOfP)) == null || pMember == null || dMember == null || (pDate = this.periodStartDates.get(pMember.getDimMemberNumber())) == null || (dDate = this.rollStartDates.get(dMember.getDimMemberNumber())) == null || !pDate.before(dDate)) continue;
                        styleControlContext.lockRowCol(null, "#FFF8E1", row, col3, multiAreaManager);
                        log.info("locked by FixRollCellLockController row=" + row);
                    }
                }
                continue;
            }
            if (!dataTypeInCol) continue;
            int colIndexOfD = coldimnums.indexOf(DATATYPE);
            for (col = 0; col < coldimmems.size(); ++col) {
                int rowIndexOfP;
                List<CellDimMember> colMembers = coldimmems.get(col);
                if (colMembers == null || (dMember = colMembers.get(colIndexOfD)) == null || this.rollStartDates.get(dMember.getDimMemberNumber()) == null || (rowIndexOfP = rowdimnums.indexOf(BUDGETPERIOD)) < 0) continue;
                for (int row3 = 0; row3 < rowdimmems.size(); ++row3) {
                    List<CellDimMember> rowMembers = rowdimmems.get(row3);
                    if (rowMembers == null || (pMember = rowMembers.get(rowIndexOfP)) == null || pMember == null || dMember == null || (pDate = this.periodStartDates.get(pMember.getDimMemberNumber())) == null || (dDate = this.rollStartDates.get(dMember.getDimMemberNumber())) == null || !pDate.before(dDate)) continue;
                    styleControlContext.lockRowCol(null, "#FFF8E1", row3, col, multiAreaManager);
                    log.info("locked by FixRollCellLockController row=" + row3 + " col=" + col);
                }
            }
        }
    }

    private void periodInPageView(FixSpreadLockContext styleControlContext, Date periodStartDate) {
        if (styleControlContext == null || periodStartDate == null) {
            return;
        }
        for (MultiAreaManager multiAreaManager : styleControlContext.getEbSpreadManager().getMultiAreaManager()) {
            boolean dataTypeInRow = multiAreaManager.getRowpartitionDims().contains(DATATYPE);
            List<List<CellDimMember>> rowdimmems = multiAreaManager.getRowpartitionDimMems();
            List<List<CellDimMember>> coldimmems = multiAreaManager.getColpartitionDimMems();
            List<String> rowdimnums = multiAreaManager.getRowpartitionDims();
            List<String> coldimnums = multiAreaManager.getColpartitionDims();
            PageViewDimMember pageViewDimMember = multiAreaManager.getAreaPageViewDims().get(DATATYPE);
            Date date = null;
            if (pageViewDimMember != null && (date = this.rollStartDates.get(pageViewDimMember.getNumber())) != null && periodStartDate.before(date)) {
                for (int row = 0; row < rowdimmems.size(); ++row) {
                    styleControlContext.lockRowCol(null, "#FFF8E1", row, multiAreaManager, true);
                    log.info("locked by FixRollCellLockController row=" + row);
                }
                continue;
            }
            if (pageViewDimMember != null) continue;
            List<String> dimnums = dataTypeInRow ? rowdimnums : coldimnums;
            List<List<CellDimMember>> dimmems = dataTypeInRow ? rowdimmems : coldimmems;
            int pIndex = dimnums.indexOf(DATATYPE);
            for (int rowCol = 0; rowCol < dimmems.size(); ++rowCol) {
                CellDimMember cellDimMember;
                List<CellDimMember> cellDimMembers = dimmems.get(rowCol);
                if (cellDimMembers == null || cellDimMembers.size() == 0 || (cellDimMember = cellDimMembers.get(pIndex)) == null || (date = this.rollStartDates.get(cellDimMember.getDimMemberNumber())) == null || !periodStartDate.before(date)) continue;
                styleControlContext.lockRowCol(null, "#FFF8E1", rowCol, multiAreaManager, dataTypeInRow);
                log.info("locked by FixRollCellLockController " + (dataTypeInRow ? "row=" : "col=") + rowCol);
            }
        }
    }

    private void dataTypeInPageView(FixSpreadLockContext styleControlContext, Date rollStartDate) {
        if (styleControlContext == null || rollStartDate == null) {
            return;
        }
        for (MultiAreaManager multiAreaManager : styleControlContext.getEbSpreadManager().getMultiAreaManager()) {
            boolean periodInRow = multiAreaManager.getRowpartitionDims().contains(BUDGETPERIOD);
            List<List<CellDimMember>> rowdimmems = multiAreaManager.getRowpartitionDimMems();
            List<List<CellDimMember>> coldimmems = multiAreaManager.getColpartitionDimMems();
            List<String> rowdimnums = multiAreaManager.getRowpartitionDims();
            List<String> coldimnums = multiAreaManager.getColpartitionDims();
            PageViewDimMember pageViewDimMember = multiAreaManager.getAreaPageViewDims().get(BUDGETPERIOD);
            Date date = null;
            if (pageViewDimMember != null) {
                date = this.periodStartDates.get(pageViewDimMember.getNumber());
                if (date == null || !date.before(rollStartDate)) continue;
                for (int row = 0; row < rowdimmems.size(); ++row) {
                    styleControlContext.lockRowCol(null, "#FFF8E1", row, multiAreaManager, true);
                    log.info("locked by FixRollCellLockController row=" + row);
                }
                continue;
            }
            List<String> dimnums = periodInRow ? rowdimnums : coldimnums;
            List<List<CellDimMember>> dimmems = periodInRow ? rowdimmems : coldimmems;
            int pIndex = dimnums.indexOf(BUDGETPERIOD);
            for (int rowCol = 0; rowCol < dimmems.size(); ++rowCol) {
                CellDimMember cellDimMember;
                List<CellDimMember> cellDimMembers = dimmems.get(rowCol);
                if (cellDimMembers == null || cellDimMembers.size() == 0 || (cellDimMember = cellDimMembers.get(pIndex)) == null || (date = this.periodStartDates.get(cellDimMember.getDimMemberNumber())) == null || !date.before(rollStartDate)) continue;
                styleControlContext.lockRowCol(null, "#FFF8E1", rowCol, multiAreaManager, periodInRow);
                log.info("locked by FixRollCellLockController " + (periodInRow ? "row=" : "col=") + rowCol);
            }
        }
    }
}

