/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.command.lockcontroller.lockcell.fix;

import java.util.ArrayList;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.utils.CommonServiceHelper;
import kd.epm.eb.spread.command.lockcontroller.FixSpreadLockContext;
import kd.epm.eb.spread.command.lockcontroller.ISpreadLockControl;
import kd.epm.eb.spread.command.lockcontroller.lockcell.NoLeafStorageLockControllerHelper;
import kd.epm.eb.spread.command.rangedefined.CellArea;
import kd.epm.eb.spread.command.style.AreasStyle;
import kd.epm.eb.spread.template.afix.multimanager.MultiAreaManager;

public class RealFixNoLeafCellLockController
implements ISpreadLockControl {
    private static final Log log = LogFactory.getLog(RealFixNoLeafCellLockController.class);
    private final NoLeafStorageLockControllerHelper controllerHelper = new NoLeafStorageLockControllerHelper();

    @Override
    public void controlfix(FixSpreadLockContext spreadLockContext) {
        if (spreadLockContext == null || spreadLockContext.getEbSpreadManager() == null) {
            return;
        }
        try {
            this.init(spreadLockContext);
            CanEditNoLeafStrategy spreadLockControl = new CanEditNoLeafStrategy();
            spreadLockControl.controlfix(spreadLockContext);
        }
        catch (Exception e) {
            log.error("RealFixNoLeafCellLockController:" + CommonServiceHelper.getStackTraceStr((Throwable)e));
            throw new KDBizException(e.getMessage());
        }
    }

    private void init(FixSpreadLockContext spreadLockContext) {
        Boolean approveAdjust = false;
        if (spreadLockContext.getParams().get("approveAdjust") != null) {
            approveAdjust = (Boolean)spreadLockContext.getParams().get("approveAdjust");
        }
        this.controllerHelper.init(spreadLockContext.getEbSpreadManager(), approveAdjust);
    }

    public boolean checkPageViewLockNoleafEdit(FixSpreadLockContext spreadLockContext) {
        if (spreadLockContext == null || spreadLockContext.getEbSpreadManager() == null) {
            return false;
        }
        if (this.controllerHelper.isWholePageLock()) {
            spreadLockContext.lockAllData(null, "#FFF8E1");
            spreadLockContext.setStopcommand(true);
            log.info("locked All by checkPageViewLockNoleafEdit");
        }
        return this.controllerHelper.isWholePageLock() || this.controllerHelper.isWholePageCanEdit();
    }

    private void lockArea(FixSpreadLockContext spreadLockContext, MultiAreaManager multiAreaManager) {
        MultiAreaManager.ValueArea valueArea = multiAreaManager.getValueAreaStart();
        int rows = multiAreaManager.getAreaRange().getY_end() - valueArea.getData_row_start() + 1;
        int cols = multiAreaManager.getAreaRange().getX_end() - valueArea.getData_col_start() + 1;
        AreasStyle areasStyle = multiAreaManager.isUserStyle() ? spreadLockContext.getAreaStyle() : spreadLockContext.getAreaStyle("#000000", "#FFF8E1");
        areasStyle.setRange(new ArrayList<CellArea>());
        areasStyle.getRange().add(new CellArea(valueArea.getData_row_start(), valueArea.getData_col_start(), rows, cols));
        spreadLockContext.getAreasStyles().add(areasStyle);
    }

    class CanEditNoLeafStrategy
    implements ISpreadLockControl {
        CanEditNoLeafStrategy() {
        }

        @Override
        public void controlfix(FixSpreadLockContext spreadLockContext) {
            if (spreadLockContext == null || spreadLockContext.getEbSpreadManager() == null) {
                return;
            }
            log.info("RealFixNoLeafCellLockController.controlfix controllerHelper = " + RealFixNoLeafCellLockController.this.controllerHelper);
            if (!RealFixNoLeafCellLockController.this.checkPageViewLockNoleafEdit(spreadLockContext)) {
                for (MultiAreaManager multiAreaManager : spreadLockContext.getEbSpreadManager().getMultiAreaManager()) {
                    RealFixNoLeafCellLockController.this.controllerHelper.init(multiAreaManager);
                    if (RealFixNoLeafCellLockController.this.controllerHelper.isWholeAreaLock()) {
                        RealFixNoLeafCellLockController.this.lockArea(spreadLockContext, multiAreaManager);
                        log.info("locked Area by RealFixNoLeafCellLockController isWholeAreaLock");
                        continue;
                    }
                    if (RealFixNoLeafCellLockController.this.controllerHelper.isWholeAreaCanEdit()) continue;
                    spreadLockContext.lockRowCol("#000000", "#FFF8E1", multiAreaManager, true, RealFixNoLeafCellLockController.this.controllerHelper.getLockRows(), RealFixNoLeafCellLockController.this.controllerHelper.getLockRowCols());
                    spreadLockContext.lockRowCol("#000000", "#FFF8E1", multiAreaManager, false, RealFixNoLeafCellLockController.this.controllerHelper.getLockCols(), RealFixNoLeafCellLockController.this.controllerHelper.getLockColRows());
                    log.info("fixCheckRowColsLockNoleafEdit after init " + multiAreaManager.getAreaRange() + ":" + RealFixNoLeafCellLockController.this.controllerHelper);
                }
            }
        }
    }
}

