/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.command.stylecontroller;

import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.utils.MetricUtils;
import kd.epm.eb.olap.enums.DataRowEnum;
import kd.epm.eb.spread.analyze.DiffAnalyzeScheme;
import kd.epm.eb.spread.command.rangedefined.CellArea;
import kd.epm.eb.spread.command.style.AreasStyle;
import kd.epm.eb.spread.command.style.CellStyleInfo;
import kd.epm.eb.spread.control.SpreadContainer;
import kd.epm.eb.spread.template.spreadmanager.DiffCellDimMember;
import kd.epm.eb.spread.template.spreadmanager.IDiffAnalyzeSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;

public class DiffAnalyzeStyleController {
    public static void setCellStyles(int startRow, int endRow, IDiffAnalyzeSpreadManager spreadManager, SpreadContainer spreadContainer, Map<String, Object> displaySettings) {
        if (spreadManager == null || spreadManager.getDiffAnalyzeScheme() == null || spreadContainer == null) {
            return;
        }
        boolean isMetricInRow = spreadManager.getRowDimension() != null && SysDimensionEnum.Metric.getNumber().equals(spreadManager.getRowDimension().getNumber());
        DiffAnalyzeScheme scheme = spreadManager.getDiffAnalyzeScheme();
        ISheet sheet = spreadManager.getEbook().getSheet(0);
        int schemeRowIndex = spreadManager.getColCellDimMembers() != null && spreadManager.getColCellDimMembers().size() > 0 ? 1 : 0;
        HashMap<Integer, String> indexFm = new HashMap<Integer, String>(16);
        List<DiffAnalyzeScheme.DiffAnalyzeColumn> columns = scheme.getAnalyzeColumns();
        Object configValue = null;
        Map<String, Integer> metricDisplay = null;
        if (displaySettings != null && (configValue = displaySettings.get("metricdisplay")) instanceof Map) {
            metricDisplay = (HashMap)configValue;
        }
        Collection metricDisplay_no_sep = null;
        if (metricDisplay == null && (configValue = scheme.getConfigMap().get("metricdisplay")) instanceof String && StringUtils.isNotEmpty((String)((String)configValue))) {
            metricDisplay = (Map)SerializationUtils.fromJsonString((String)((String)configValue), Map.class);
        }
        if (metricDisplay == null) {
            metricDisplay = new HashMap(16);
        }
        if (spreadManager.getModelCacheHelper() != null) {
            List metrics = spreadManager.getModelCacheHelper().getMembers(null, SysDimensionEnum.Metric.getNumber());
            for (Object metric : metrics) {
                if (!MetricDataTypeEnum.CURRENCY.getIndex().equals(metric.getDatatype()) && !MetricDataTypeEnum.NONMONETARY.getIndex().equals(metric.getDatatype())) continue;
                metricDisplay.putIfAbsent(metric.getNumber(), MetricDataTypeEnum.CURRENCY.getIndex().equals(metric.getDatatype()) ? Integer.valueOf(2) : Integer.valueOf(0));
            }
        }
        if (displaySettings != null && (configValue = displaySettings.get("metricdisplay_no_sep")) instanceof Collection) {
            metricDisplay_no_sep = (Collection)configValue;
        }
        if (metricDisplay_no_sep == null && (configValue = scheme.getConfigMap().get("metricdisplay_no_sep")) instanceof String && StringUtils.isNotEmpty((String)((String)configValue))) {
            metricDisplay_no_sep = (Collection)SerializationUtils.fromJsonString((String)((String)configValue), Collection.class);
        }
        if (metricDisplay_no_sep == null) {
            metricDisplay_no_sep = new HashSet(16);
        }
        String metric = null;
        String commonMetric = null;
        if (spreadManager.getCommonDimension() != null) {
            for (Dimension dimension : spreadManager.getCommonDimension()) {
                if (!"Metric".equals(dimension.getNumber()) || dimension.getMembers() == null || dimension.getMembers().size() <= 0) continue;
                Member metricMember = (Member)dimension.getMembers().get(0);
                commonMetric = metricMember.getNumber();
                break;
            }
        }
        for (int i = 0; i < columns.size(); ++i) {
            DiffAnalyzeScheme.DiffAnalyzeColumn column = columns.get(i);
            String displayFormat = column.getDisplayFormat();
            if (DataRowEnum.DATA == column.getDataRow().getDataRowType()) {
                if (displayFormat == null) {
                    metric = (String)column.getDataRow().getMetas().get("Metric");
                    if (metric != null && metricDisplay.get(metric) != null) {
                        displayFormat = MetricUtils.decimal2FormatStr((Integer)((Integer)metricDisplay.get(metric)), (boolean)metricDisplay_no_sep.contains(metric));
                    } else if (commonMetric != null) {
                        displayFormat = MetricUtils.decimal2FormatStr((Integer)((Integer)metricDisplay.get(commonMetric)), (boolean)metricDisplay_no_sep.contains(commonMetric));
                    }
                }
                if (isMetricInRow) continue;
                indexFm.put(i, displayFormat);
                continue;
            }
            indexFm.put(i, column.getDisplayFormat());
        }
        int rows = endRow - startRow + 1;
        LinkedList<AreasStyle> areasStyles = new LinkedList<AreasStyle>();
        if (isMetricInRow) {
            int cols = sheet.getRealMaxCols();
            String metricInRow = null;
            for (int row = startRow; row <= endRow; ++row) {
                ECell rowCell = sheet.getECellNotAdd(row, 0);
                if (rowCell == null) continue;
                if (row == startRow && !"Metric".equals(rowCell.getUserObject("dimnumber"))) {
                    for (int metricRowIndex = row; metricRowIndex >= 0; --metricRowIndex) {
                        ECell metricRowCell = sheet.getECellNotAdd(metricRowIndex, 0);
                        if (metricRowCell == null || !"Metric".equals(metricRowCell.getUserObject("dimnumber"))) continue;
                        metricInRow = (String)metricRowCell.getUserObject("memnumber");
                        break;
                    }
                }
                if ("Metric".equals(rowCell.getUserObject("dimnumber"))) {
                    metricInRow = (String)rowCell.getUserObject("memnumber");
                }
                if (metricInRow == null) continue;
                String fm = MetricUtils.decimal2FormatStr((Integer)((Integer)metricDisplay.get(metricInRow)), (boolean)metricDisplay_no_sep.contains(metricInRow));
                if (fm == null) {
                    fm = "#,##0.00";
                }
                AreasStyle areasStyle = new AreasStyle(Collections.singletonList(new CellArea(row, 1, 1, cols)), new CellStyleInfo().ofFm(fm));
                areasStyles.add(areasStyle);
            }
            if (!indexFm.isEmpty()) {
                DiffAnalyzeStyleController.setFormatByColIndex(startRow, sheet, schemeRowIndex, indexFm, rows, areasStyles);
            }
        } else {
            DiffAnalyzeStyleController.setFormatByColIndex(startRow, sheet, schemeRowIndex, indexFm, rows, areasStyles);
        }
        spreadContainer.setCellStyle(areasStyles);
    }

    private static void setFormatByColIndex(int startRow, ISheet sheet, int schemeRowIndex, Map<Integer, String> indexFm, int rows, List<AreasStyle> areasStyles) {
        if (sheet == null || indexFm == null || areasStyles == null) {
            return;
        }
        for (int col = 0; col < sheet.getRealMaxCols(); ++col) {
            Integer indexInGroup;
            ECell colCell = sheet.getECellNotAdd(schemeRowIndex, col);
            if (colCell == null || (indexInGroup = (Integer)colCell.getUserObject("index")) == null || !indexFm.containsKey(indexInGroup)) continue;
            String fm = indexFm.get(indexInGroup);
            if (fm == null) {
                fm = "#,##0.00";
            }
            AreasStyle areasStyle = new AreasStyle(Collections.singletonList(new CellArea(startRow > schemeRowIndex ? startRow : schemeRowIndex + 1, col, rows, 1)), new CellStyleInfo().ofFm(fm));
            areasStyles.add(areasStyle);
        }
    }

    private static Map<String, Object> getMetricDisplay(String configJson) {
        Map configMap;
        String metricDisplayStr;
        if (StringUtils.isNotEmpty((String)configJson) && StringUtils.isNotEmpty((String)(metricDisplayStr = (String)(configMap = (Map)SerializationUtils.fromJsonString((String)configJson, Map.class)).get("metricdisplay")))) {
            return (Map)SerializationUtils.fromJsonString((String)metricDisplayStr, Map.class);
        }
        return null;
    }

    public static void hideEmptyRows(IDiffAnalyzeSpreadManager spreadManager, SpreadContainer spreadContainer) {
        if (spreadManager != null && spreadManager.getEbook() != null && spreadContainer != null) {
            LinkedList<Integer> emptyRows = new LinkedList<Integer>();
            LinkedList<Integer> dataRows = new LinkedList<Integer>();
            List<DiffCellDimMember> rowCellDimMembers = spreadManager.getRowCellDimMembers();
            if (rowCellDimMembers != null) {
                int valueRowEnd = spreadManager.getValueRowEnd();
                for (int row = spreadManager.getValueRowStart(); row < valueRowEnd && row < rowCellDimMembers.size(); ++row) {
                    boolean isRefreshedWithRow = rowCellDimMembers.get(row).isRefreshed();
                    if (isRefreshedWithRow) {
                        dataRows.add(row);
                        continue;
                    }
                    emptyRows.add(row);
                }
            }
            if (emptyRows.size() > 0) {
                spreadContainer.setRowsVisible(emptyRows, false);
            }
            if (dataRows.size() > 0) {
                spreadContainer.setRowsVisible(dataRows, true);
            }
        }
    }

    public static void showEmptyRows(IDiffAnalyzeSpreadManager spreadManager, SpreadContainer spreadContainer) {
        if (spreadManager != null && spreadContainer != null) {
            LinkedList<Integer> rows = new LinkedList<Integer>();
            int valueRowEnd = spreadManager.getValueRowEnd();
            for (int row = spreadManager.getValueRowStart(); row < valueRowEnd; ++row) {
                rows.add(row);
            }
            spreadContainer.setRowsVisible(rows, true);
        }
    }
}

