/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.command.stylecontroller.styleset;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricUseEnum;
import kd.epm.eb.common.utils.MetricUtils;
import kd.epm.eb.spread.command.rangedefined.CellArea;
import kd.epm.eb.spread.command.style.AreasStyle;
import kd.epm.eb.spread.command.style.CellStyleInfo;
import kd.epm.eb.spread.command.style.HorizontalAlignEnum;
import kd.epm.eb.spread.command.stylecontroller.ISpreadStyleControl;
import kd.epm.eb.spread.command.stylecontroller.SpreadStyleControlContext;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.dimension.PageViewDimMember;
import kd.epm.eb.spread.template.spread.style.MetricCellStyleInfo;
import kd.epm.eb.spread.template.spreadmanager.CellDimMember;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.MetricCellDimMember;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import kd.epm.eb.spread.template.spreadmanager.sheet.StyleCell;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarCommonUtil;

public class SheetMetricDimStyleController
implements ISpreadStyleControl {
    private List<MetricCellStyleInfo> metricCellStyleInfos = null;
    private Map<String, Integer> metricDecimalMap = new HashMap<String, Integer>(16);
    private Boolean styleInTable;
    private CellStyleInfo cellStyleInfo_date = null;
    private CellStyleInfo cellStyleInfo_text = null;
    private Map<String, CellStyleInfo> specialCellStyleInfoMap = new HashMap<String, CellStyleInfo>(16);
    private Map<String, CellStyleInfo> specialCellStye_percentMap = new HashMap<String, CellStyleInfo>(16);

    @Override
    public void control(SpreadStyleControlContext styleControlContext) {
        this.initMetricCellStyleInfos(styleControlContext);
        if (this.styleInTable == null && styleControlContext.getEbSpreadManager() != null) {
            this.setStyleInTable(Boolean.FALSE);
        }
        if (this.wholePageControl(styleControlContext)) {
            return;
        }
        if (this.isMetricOnPageView(styleControlContext)) {
            return;
        }
        IEbSpreadManager ebSpreadManager = styleControlContext.getEbSpreadManager();
        HashMap<CellStyleInfo, List<Integer>> rows = new HashMap<CellStyleInfo, List<Integer>>();
        HashMap<CellStyleInfo, List<Integer>> cols = new HashMap<CellStyleInfo, List<Integer>>();
        if (ebSpreadManager.getRowpartitionDims().contains(SysDimensionEnum.Metric.getNumber())) {
            this.checkRowColIsNumber(ebSpreadManager.getRowpartitionDimMems(), rows);
        } else {
            this.checkRowColIsNumber(ebSpreadManager.getColpartitionDimMems(), cols);
        }
        this.resolveRowColStyle(rows, ebSpreadManager, styleControlContext, true);
        this.resolveRowColStyle(cols, ebSpreadManager, styleControlContext, false);
    }

    private boolean wholePageControl(SpreadStyleControlContext styleControlContext) {
        IEbSpreadManager ebSpreadManager = styleControlContext.getEbSpreadManager();
        Set<String> metricMems = ebSpreadManager.getAlldimensionWithMembers().get(SysDimensionEnum.Metric.getNumber());
        if (metricMems != null && metricMems.size() == 1) {
            ISheet sheet = ebSpreadManager.getEbook().getSheet(0);
            String metricNumber = metricMems.iterator().next();
            MetricCellDimMember metricCellDimMember = new MetricCellDimMember(true, metricNumber);
            metricCellDimMember.setDatatype(ebSpreadManager.getMetricDatatypeMap().get(metricNumber));
            CellStyleInfo cellStyleInfo = this.getCellStyleInfoByDataType(metricCellDimMember);
            AreasStyle areasStyle = new AreasStyle();
            areasStyle.setRange(Collections.singletonList(new CellArea(sheet.getValueAreaRowStart(), sheet.getValueAreaColStart(), sheet.getRealMaxRows(), sheet.getRealMaxCols())));
            areasStyle.setStyle(cellStyleInfo);
            styleControlContext.getAreasStyles().add(areasStyle);
            return true;
        }
        return false;
    }

    private void resolveRowColStyle(Map<CellStyleInfo, List<Integer>> rows, IEbSpreadManager ebSpreadManager, SpreadStyleControlContext styleControlContext, boolean isrow) {
        if (rows.size() == 0) {
            return;
        }
        ISheet sheet = ebSpreadManager.getEbook().getSheet(0);
        for (Map.Entry<CellStyleInfo, List<Integer>> rowinfo : rows.entrySet()) {
            List<Integer> rowlist = rowinfo.getValue();
            CellStyleInfo cellStyleInfo = rowinfo.getKey();
            boolean isLock = cellStyleInfo.isL();
            String bkc = StringUtils.isNotEmpty((String)cellStyleInfo.getBkc()) ? cellStyleInfo.getBkc() : "#FFFFFF";
            for (Integer rowcol : rowlist) {
                StyleCell styleCell;
                if (isrow) {
                    if (this.isStyleInTable().booleanValue()) {
                        for (int col = sheet.getValueAreaColStart(); col < sheet.getRealMaxCols(); ++col) {
                            styleCell = (StyleCell)sheet.getECell(rowcol, col);
                            styleCell.setFormatter(cellStyleInfo.getFm());
                            styleCell.sethAlign(cellStyleInfo.getHa());
                            if (styleCell.isLocked()) continue;
                            styleCell.setLocked(isLock);
                            styleCell.setBackColor(bkc);
                        }
                        continue;
                    }
                    AreasStyle areasStyle = new AreasStyle();
                    areasStyle.setRange(Collections.singletonList(new CellArea(rowcol, sheet.getValueAreaColStart(), 1, sheet.getRealMaxCols())));
                    areasStyle.setStyle(cellStyleInfo);
                    styleControlContext.getAreasStyles().add(areasStyle);
                    continue;
                }
                if (this.isStyleInTable().booleanValue()) {
                    for (int row = sheet.getValueAreaRowStart(); row < sheet.getRealMaxRows(); ++row) {
                        styleCell = (StyleCell)sheet.getECell(row, rowcol);
                        styleCell.setFormatter(cellStyleInfo.getFm());
                        styleCell.sethAlign(cellStyleInfo.getHa());
                        if (styleCell.isLocked()) continue;
                        styleCell.setLocked(isLock);
                        styleCell.setBackColor(bkc);
                    }
                    continue;
                }
                AreasStyle areasStyle = new AreasStyle();
                areasStyle.setRange(Collections.singletonList(new CellArea(sheet.getValueAreaRowStart(), rowcol, sheet.getRealMaxRows(), 1)));
                areasStyle.setStyle(cellStyleInfo);
                styleControlContext.getAreasStyles().add(areasStyle);
            }
        }
    }

    private void checkRowColIsNumber(List<List<CellDimMember>> partitionDimMems, Map<CellStyleInfo, List<Integer>> rowcols) {
        block0: for (int rowcol = 0; rowcol < partitionDimMems.size(); ++rowcol) {
            List<CellDimMember> cellDimMembers = partitionDimMems.get(rowcol);
            if (cellDimMembers == null || cellDimMembers.size() == 0) continue;
            for (CellDimMember cellDimMember : cellDimMembers) {
                if (!cellDimMember.isMetric()) continue;
                MetricCellDimMember metricCellDimMember = (MetricCellDimMember)cellDimMember;
                CellStyleInfo cellStyleInfoByDataType = this.getCellStyleInfoByDataType(metricCellDimMember);
                this.addCellStyleInfo(rowcols, cellStyleInfoByDataType, rowcol);
                continue block0;
            }
        }
    }

    public CellStyleInfo getCellStyleInfoByDataType(MetricCellDimMember metricCellDimMember) {
        if (TemplateVarCommonUtil.checkIsVar(metricCellDimMember.getDimMemberNumber(), SysDimensionEnum.Metric.getNumber()).booleanValue()) {
            return this.getCellStyleInfo_text();
        }
        int datatype = metricCellDimMember.getDatatype();
        if (MetricDataTypeEnum.CURRENCY.getIndex().equals(String.valueOf(datatype)) || MetricDataTypeEnum.NONMONETARY.getIndex().equals(String.valueOf(datatype))) {
            return this.getSpecialCellStyleInfoByMetric(metricCellDimMember);
        }
        if (MetricDataTypeEnum.RATE.getIndex().equals(String.valueOf(datatype))) {
            return this.getSpecialCellStye_percent(metricCellDimMember);
        }
        if (MetricDataTypeEnum.DATE.getIndex().equals(String.valueOf(datatype))) {
            return this.getCellStyleInfo_date();
        }
        if (MetricDataTypeEnum.TEXT.getIndex().equals(String.valueOf(datatype)) || MetricDataTypeEnum.ENUM.getIndex().equals(String.valueOf(datatype))) {
            return this.getCellStyleInfo_text();
        }
        return new CellStyleInfo();
    }

    public CellStyleInfo getCellStyleInfo_date() {
        if (this.cellStyleInfo_date == null) {
            this.cellStyleInfo_date = new CellStyleInfo();
            this.cellStyleInfo_date.setFm("yyyy-MM-dd");
            this.cellStyleInfo_date.setHa(HorizontalAlignEnum.RIGHT);
        }
        return this.cellStyleInfo_date;
    }

    public CellStyleInfo getCellStyleInfo_text() {
        if (this.cellStyleInfo_text == null) {
            this.cellStyleInfo_text = new CellStyleInfo();
            this.cellStyleInfo_text.setFm("@");
            this.cellStyleInfo_text.setHa(HorizontalAlignEnum.LEFT);
        }
        return this.cellStyleInfo_text;
    }

    private CellStyleInfo getSpecialCellStyleInfoByMetric(MetricCellDimMember metricCellDimMember) {
        String metricNum = metricCellDimMember.getDimMemberNumber();
        String use = metricCellDimMember.getUse();
        CellStyleInfo cellStyleInfo_specialnumber = this.specialCellStyleInfoMap.get(metricNum + "_" + use);
        if (cellStyleInfo_specialnumber == null) {
            cellStyleInfo_specialnumber = new CellStyleInfo();
            this.specialCellStyleInfoMap.put(metricNum + "_" + use, cellStyleInfo_specialnumber);
            String fm = null;
            if (this.metricCellStyleInfos != null && metricNum != null) {
                for (MetricCellStyleInfo metricCellStyleInfo : this.metricCellStyleInfos) {
                    if (!metricNum.equals(metricCellStyleInfo.getMetricNumber()) || metricCellStyleInfo.getFm() == null) continue;
                    fm = metricCellStyleInfo.getFm();
                    break;
                }
            }
            if (fm == null) {
                Integer decimal = this.metricDecimalMap.get(metricNum);
                fm = decimal != null ? MetricUtils.decimal2FormatStr((Integer)decimal) : ("Amount".equals(metricNum) ? "#,##0" : "#,##0.00");
            }
            if (StringUtils.isNotEmpty((String)use) && !"null".equals(use) && !MetricUseEnum.Prepare.getIndex().equals(use)) {
                cellStyleInfo_specialnumber.setBkc("#FFF8E1");
                cellStyleInfo_specialnumber.setL(true);
            }
            cellStyleInfo_specialnumber.setFm(fm);
            cellStyleInfo_specialnumber.setHa(HorizontalAlignEnum.RIGHT);
        }
        return cellStyleInfo_specialnumber;
    }

    private CellStyleInfo getSpecialCellStye_percent(MetricCellDimMember metricCellDimMember) {
        String metricNumber = metricCellDimMember.getDimMemberNumber();
        String use = metricCellDimMember.getUse();
        CellStyleInfo cellStyleInfo_percent = this.specialCellStye_percentMap.get(metricNumber + "_" + use);
        if (cellStyleInfo_percent == null) {
            cellStyleInfo_percent = new CellStyleInfo();
            this.specialCellStye_percentMap.put(metricNumber + "_" + use, cellStyleInfo_percent);
            String fm = null;
            if (this.metricCellStyleInfos != null && metricNumber != null) {
                for (MetricCellStyleInfo metricCellStyleInfo : this.metricCellStyleInfos) {
                    if (!metricNumber.equals(metricCellStyleInfo.getMetricNumber()) || metricCellStyleInfo.getFm() == null) continue;
                    fm = metricCellStyleInfo.getFm();
                    break;
                }
            }
            if (fm == null) {
                String decimalnum_str = metricCellDimMember.getDecimalnum();
                StringBuilder sb = new StringBuilder();
                Integer decimalnum = null;
                decimalnum = StringUtils.isNotEmpty((String)decimalnum_str) && !"null".equals(decimalnum_str) ? Integer.valueOf(Integer.parseInt(decimalnum_str)) : this.metricDecimalMap.get(metricNumber);
                if (decimalnum != null && decimalnum > 0) {
                    sb.append("0.");
                    Integer i = 0;
                    while (i < decimalnum) {
                        sb.append('0');
                        Integer n = i;
                        Integer n2 = i = Integer.valueOf(i + 1);
                    }
                    sb.append('%');
                } else if (decimalnum != null && decimalnum == 0) {
                    sb.append("0%");
                } else {
                    sb.append("0.00%");
                }
                fm = sb.toString();
            }
            if (fm == null) {
                fm = "0.00%";
            }
            if (fm.indexOf("%") < 0) {
                fm = fm + "%";
            }
            cellStyleInfo_percent.setFm(fm);
            cellStyleInfo_percent.setHa(HorizontalAlignEnum.RIGHT);
            if (StringUtils.isNotEmpty((String)metricCellDimMember.getUse()) && !MetricUseEnum.Prepare.getIndex().equals(metricCellDimMember.getUse())) {
                cellStyleInfo_percent.setBkc("#FFF8E1");
                cellStyleInfo_percent.setL(true);
            }
        }
        return cellStyleInfo_percent;
    }

    private void addCellStyleInfo(Map<CellStyleInfo, List<Integer>> rowcols, CellStyleInfo cellStyleInfo, int rowcol) {
        List<Integer> rowcol_number = rowcols.get(cellStyleInfo);
        if (rowcol_number == null) {
            rowcol_number = new ArrayList<Integer>();
        }
        rowcol_number.add(rowcol);
        rowcols.put(cellStyleInfo, rowcol_number);
    }

    private void initMetricCellStyleInfos(SpreadStyleControlContext styleControlContext) {
        ITemplateModel templateModel = styleControlContext.getTemplateModel();
        if (templateModel != null) {
            this.metricCellStyleInfos = templateModel.getMetricCellStyleInfo();
            Map metricsMap = BusinessDataServiceHelper.loadFromCache((String)"epm_metricmembertree", (String)"number,decimalnum", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)templateModel.getModelId())});
            if (metricsMap != null) {
                for (DynamicObject dynamicObject : metricsMap.values()) {
                    String number = dynamicObject.getString("number");
                    Integer decimal = dynamicObject.getInt("decimalnum");
                    if (number == null || decimal == null) continue;
                    this.metricDecimalMap.put(number, decimal);
                }
            }
        }
    }

    private boolean isMetricOnPageView(SpreadStyleControlContext styleControlContext) {
        IEbSpreadManager ebSpreadManager = styleControlContext.getEbSpreadManager();
        PageViewDimMember pageViewDimMember = ebSpreadManager.getPageViewDims().get(SysDimensionEnum.Metric.getNumber());
        if (pageViewDimMember == null) {
            return false;
        }
        ISheet sheet = ebSpreadManager.getEbook().getSheet(0);
        MetricCellDimMember metricCellDimMember = new MetricCellDimMember(true, pageViewDimMember.getNumber());
        metricCellDimMember.setDatatype(ebSpreadManager.getMetricDatatypeMap().get(pageViewDimMember.getNumber()));
        CellStyleInfo cellStyleInfo = this.getCellStyleInfoByDataType(metricCellDimMember);
        ArrayList<Integer> rowList = new ArrayList<Integer>(sheet.getRealMaxRows());
        HashMap<CellStyleInfo, List<Integer>> rows = new HashMap<CellStyleInfo, List<Integer>>(1);
        rows.put(cellStyleInfo, rowList);
        for (int i = sheet.getValueAreaRowStart(); i < sheet.getRealMaxRows(); ++i) {
            rowList.add(i);
        }
        this.resolveRowColStyle(rows, ebSpreadManager, styleControlContext, true);
        return true;
    }

    public Boolean isStyleInTable() {
        return this.styleInTable;
    }

    public void setStyleInTable(Boolean styleInTable) {
        this.styleInTable = styleInTable;
    }
}

