/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.command.stylecontroller.styleset.fix;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricDataTypeEnum;
import kd.epm.eb.common.enums.dimensionEnums.MetricUseEnum;
import kd.epm.eb.common.utils.MetricUtils;
import kd.epm.eb.spread.command.rangedefined.CellArea;
import kd.epm.eb.spread.command.style.AreasStyle;
import kd.epm.eb.spread.command.style.CellStyleInfo;
import kd.epm.eb.spread.command.style.HorizontalAlignEnum;
import kd.epm.eb.spread.command.stylecontroller.FixSpreadStyleControlContext;
import kd.epm.eb.spread.command.stylecontroller.ISpreadStyleControl;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.afix.multimanager.MultiAreaManager;
import kd.epm.eb.spread.template.dimension.PageViewDimMember;
import kd.epm.eb.spread.template.spread.style.MetricCellStyleInfo;
import kd.epm.eb.spread.template.spreadmanager.CellDimMember;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.MetricCellDimMember;

public class FixSheetMetricDimStyleController
implements ISpreadStyleControl {
    private List<MetricCellStyleInfo> metricCellStyleInfos = null;
    private Map<String, Integer> metricDecimalMap = new HashMap<String, Integer>(16);
    private CellStyleInfo cellStyleInfo_date = null;
    private CellStyleInfo cellStyleInfo_text = null;
    private Map<String, CellStyleInfo> specialCellStyleInfoMap = new HashMap<String, CellStyleInfo>(16);
    private Map<String, CellStyleInfo> specialCellStye_percentMap = new HashMap<String, CellStyleInfo>(16);

    @Override
    public void controlFix(FixSpreadStyleControlContext styleControlContext) {
        this.initMetricCellStyleInfos(styleControlContext);
        if (this.isMetricOnPageView(styleControlContext)) {
            return;
        }
        IEbSpreadManager ebSpreadManager = styleControlContext.getEbSpreadManager();
        for (MultiAreaManager multiAreaManager : ebSpreadManager.getMultiAreaManager()) {
            if (this.isMetricOnAreaPageView(styleControlContext, multiAreaManager)) continue;
            HashMap<CellStyleInfo, List<Integer>> rows = new HashMap<CellStyleInfo, List<Integer>>();
            HashMap<CellStyleInfo, List<Integer>> cols = new HashMap<CellStyleInfo, List<Integer>>();
            if (multiAreaManager.getRowpartitionDims().contains(SysDimensionEnum.Metric.getNumber())) {
                this.checkRowColIsNumber(multiAreaManager.getRowpartitionDimMems(), rows);
            }
            if (multiAreaManager.getColpartitionDims().contains(SysDimensionEnum.Metric.getNumber())) {
                this.checkRowColIsNumber(multiAreaManager.getColpartitionDimMems(), cols);
            }
            this.resolveRowColStyle(rows, multiAreaManager, styleControlContext, true);
            this.resolveRowColStyle(cols, multiAreaManager, styleControlContext, false);
        }
    }

    private void initMetricCellStyleInfos(FixSpreadStyleControlContext styleControlContext) {
        ITemplateModel templateModel = styleControlContext.getTemplateModel();
        if (templateModel != null) {
            this.metricCellStyleInfos = templateModel.getMetricCellStyleInfo();
            Map metricsMap = BusinessDataServiceHelper.loadFromCache((String)"epm_metricmembertree", (String)"number,decimalnum", (QFilter[])new QFilter[]{new QFilter("model", "=", (Object)templateModel.getModelId())});
            if (metricsMap != null) {
                for (DynamicObject dynamicObject : metricsMap.values()) {
                    String number = dynamicObject.getString("number");
                    Integer decimal = dynamicObject.getInt("decimalnum");
                    if (number == null || decimal == null) continue;
                    this.metricDecimalMap.put(number, decimal);
                }
            }
        }
    }

    private boolean isMetricOnPageView(FixSpreadStyleControlContext styleControlContext) {
        IEbSpreadManager ebSpreadManager = styleControlContext.getEbSpreadManager();
        PageViewDimMember pageViewDimMember = ebSpreadManager.getPageViewDims().get(SysDimensionEnum.Metric.getNumber());
        if (pageViewDimMember == null) {
            return false;
        }
        MetricCellDimMember metricCellDimMember = new MetricCellDimMember(true, pageViewDimMember.getNumber());
        metricCellDimMember.setDatatype(ebSpreadManager.getMetricDatatypeMap().get(pageViewDimMember.getNumber()));
        CellStyleInfo cellStyleInfo = this.getCellStyleInfoByDataType(metricCellDimMember);
        AreasStyle areasStyle = new AreasStyle();
        areasStyle.setStyle(cellStyleInfo);
        areasStyle.setRange(new ArrayList<CellArea>());
        for (MultiAreaManager multiAreaManager : ebSpreadManager.getMultiAreaManager()) {
            MultiAreaManager.ValueArea valueAreaPoint = multiAreaManager.getValueAreaStart();
            int rows = multiAreaManager.getAreaRange().getY_end() - valueAreaPoint.getData_row_start() + 1;
            int cols = multiAreaManager.getAreaRange().getX_end() - valueAreaPoint.getData_col_start() + 1;
            CellArea cellArea = new CellArea(valueAreaPoint.getData_row_start(), valueAreaPoint.getData_col_start(), rows, cols);
            areasStyle.getRange().add(cellArea);
        }
        if (areasStyle.getRange().size() > 0) {
            styleControlContext.getAreasStyles().add(areasStyle);
        }
        return true;
    }

    private boolean isMetricOnAreaPageView(FixSpreadStyleControlContext styleControlContext, MultiAreaManager multiAreaManager) {
        if (multiAreaManager == null || multiAreaManager.getAreaPageViewDims() == null || multiAreaManager.getEbSpreadManager() == null || multiAreaManager.getEbSpreadManager().getMetricDatatypeMap() == null) {
            return false;
        }
        PageViewDimMember pageViewDimMember = multiAreaManager.getAreaPageViewDims().get(SysDimensionEnum.Metric.getNumber());
        if (pageViewDimMember == null) {
            return false;
        }
        MetricCellDimMember metricCellDimMember = new MetricCellDimMember(true, pageViewDimMember.getNumber());
        metricCellDimMember.setDatatype(multiAreaManager.getEbSpreadManager().getMetricDatatypeMap().get(pageViewDimMember.getNumber()));
        CellStyleInfo cellStyleInfo = this.getCellStyleInfoByDataType(metricCellDimMember);
        AreasStyle areasStyle = new AreasStyle();
        areasStyle.setStyle(cellStyleInfo);
        areasStyle.setRange(new ArrayList<CellArea>());
        MultiAreaManager.ValueArea valueAreaPoint = multiAreaManager.getValueAreaStart();
        int rows = multiAreaManager.getAreaRange().getY_end() - valueAreaPoint.getData_row_start() + 1;
        int cols = multiAreaManager.getAreaRange().getX_end() - valueAreaPoint.getData_col_start() + 1;
        CellArea cellArea = new CellArea(valueAreaPoint.getData_row_start(), valueAreaPoint.getData_col_start(), rows, cols);
        areasStyle.getRange().add(cellArea);
        if (areasStyle.getRange().size() > 0) {
            styleControlContext.getAreasStyles().add(areasStyle);
        }
        return true;
    }

    private void resolveRowColStyle(Map<CellStyleInfo, List<Integer>> rowsinfos, MultiAreaManager multiAreaManager, FixSpreadStyleControlContext styleControlContext, boolean isrow) {
        MultiAreaManager.ValueArea valueAreaPoint = multiAreaManager.getValueAreaStart();
        IEbSpreadManager ebSpreadManager = styleControlContext.getEbSpreadManager();
        int rows = multiAreaManager.getAreaRange().getY_end() - valueAreaPoint.getData_row_start() + 1;
        int cols = multiAreaManager.getAreaRange().getX_end() - valueAreaPoint.getData_col_start() + 1;
        Map<String, PageViewDimMember> pageViewDimMemberMap = multiAreaManager.getAreaPageViewDims();
        if (pageViewDimMemberMap != null && pageViewDimMemberMap.containsKey(SysDimensionEnum.Metric.getNumber())) {
            if (isrow) {
                PageViewDimMember pageViewDimMember = pageViewDimMemberMap.get(SysDimensionEnum.Metric.getNumber());
                MetricCellDimMember metricCellDimMember = new MetricCellDimMember(true, pageViewDimMember.getNumber());
                metricCellDimMember.setDatatype(ebSpreadManager.getMetricDatatypeMap().get(pageViewDimMember.getNumber()));
                AreasStyle areasStyle = new AreasStyle();
                areasStyle.setStyle(this.getSpecialCellStyleInfoByMetric(metricCellDimMember));
                areasStyle.setRange(new ArrayList<CellArea>());
                areasStyle.getRange().add(new CellArea(valueAreaPoint.getData_row_start(), valueAreaPoint.getData_col_start(), rows, cols));
                styleControlContext.getAreasStyles().add(areasStyle);
            }
        } else {
            for (Map.Entry<CellStyleInfo, List<Integer>> rowinfo : rowsinfos.entrySet()) {
                List<Integer> rowlist = rowinfo.getValue();
                CellStyleInfo cellStyleInfo = rowinfo.getKey();
                AreasStyle areasStyle = new AreasStyle();
                areasStyle.setStyle(cellStyleInfo);
                areasStyle.setRange(new ArrayList<CellArea>());
                for (Integer rowcol : rowlist) {
                    CellArea cellArea = isrow ? new CellArea(valueAreaPoint.getData_row_start() + rowcol, valueAreaPoint.getData_col_start(), 1, cols) : new CellArea(valueAreaPoint.getData_row_start(), valueAreaPoint.getData_col_start() + rowcol, rows, 1);
                    areasStyle.getRange().add(cellArea);
                }
                styleControlContext.getAreasStyles().add(areasStyle);
            }
        }
    }

    private void checkRowColIsNumber(List<List<CellDimMember>> partitionDimMems, Map<CellStyleInfo, List<Integer>> rowcols) {
        block0: for (int rowcol = 0; rowcol < partitionDimMems.size(); ++rowcol) {
            List<CellDimMember> cellDimMembers = partitionDimMems.get(rowcol);
            if (cellDimMembers == null || cellDimMembers.size() == 0) continue;
            for (CellDimMember cellDimMember : cellDimMembers) {
                if (cellDimMember == null || !cellDimMember.isMetric()) continue;
                MetricCellDimMember metricCellDimMember = (MetricCellDimMember)cellDimMember;
                this.addCellStyleInfo(rowcols, this.getCellStyleInfoByDataType(metricCellDimMember), rowcol);
                continue block0;
            }
        }
    }

    public CellStyleInfo getCellStyleInfo_date() {
        if (this.cellStyleInfo_date == null) {
            this.cellStyleInfo_date = new CellStyleInfo();
            this.cellStyleInfo_date.setFm("yyyy-MM-dd");
            this.cellStyleInfo_date.setHa(HorizontalAlignEnum.RIGHT);
        }
        return this.cellStyleInfo_date;
    }

    public CellStyleInfo getCellStyleInfo_text() {
        if (this.cellStyleInfo_text == null) {
            this.cellStyleInfo_text = new CellStyleInfo();
            this.cellStyleInfo_text.setFm("@");
            this.cellStyleInfo_text.setHa(HorizontalAlignEnum.LEFT);
        }
        return this.cellStyleInfo_text;
    }

    public CellStyleInfo getCellStyleInfoByDataType(MetricCellDimMember metricCellDimMember) {
        String datatype = String.valueOf(metricCellDimMember.getDatatype());
        if (MetricDataTypeEnum.CURRENCY.getIndex().equals(datatype) || MetricDataTypeEnum.NONMONETARY.getIndex().equals(datatype)) {
            return this.getSpecialCellStyleInfoByMetric(metricCellDimMember);
        }
        if (MetricDataTypeEnum.RATE.getIndex().equals(datatype)) {
            return this.getSpecialCellStye_percent(metricCellDimMember);
        }
        if (MetricDataTypeEnum.DATE.getIndex().equals(datatype)) {
            return this.getCellStyleInfo_date();
        }
        if (MetricDataTypeEnum.TEXT.getIndex().equals(datatype) || MetricDataTypeEnum.ENUM.getIndex().equals(String.valueOf(datatype))) {
            return this.getCellStyleInfo_text();
        }
        return new CellStyleInfo();
    }

    private CellStyleInfo getSpecialCellStyleInfoByMetric(MetricCellDimMember metricCellDimMember) {
        String metricNum = metricCellDimMember.getDimMemberNumber();
        String datatype = String.valueOf(metricCellDimMember.getDatatype());
        String use = metricCellDimMember.getUse();
        CellStyleInfo cellStyleInfo_specialnumber = this.specialCellStyleInfoMap.get(metricNum + "_" + datatype + "_" + use);
        if (cellStyleInfo_specialnumber == null) {
            cellStyleInfo_specialnumber = new CellStyleInfo();
            this.specialCellStyleInfoMap.put(metricNum + "_" + datatype + "_" + use, cellStyleInfo_specialnumber);
            String fm = null;
            if (this.metricCellStyleInfos != null && metricNum != null) {
                for (MetricCellStyleInfo metricCellStyleInfo : this.metricCellStyleInfos) {
                    if (!metricNum.equals(metricCellStyleInfo.getMetricNumber()) || metricCellStyleInfo.getFm() == null) continue;
                    fm = metricCellStyleInfo.getFm();
                    break;
                }
            }
            if (fm == null) {
                Integer decimal = this.metricDecimalMap.get(metricNum);
                if (decimal != null) {
                    fm = MetricUtils.decimal2FormatStr((Integer)decimal);
                } else if ("Amount".equals(metricNum)) {
                    fm = "#,##0";
                } else if (MetricDataTypeEnum.RATE.getIndex().equals(String.valueOf(metricCellDimMember.getDatatype()))) {
                    fm = "0.00%";
                } else {
                    if (MetricDataTypeEnum.DATE.getIndex().equals(datatype)) {
                        CellStyleInfo cellStyleInfo_date = new CellStyleInfo();
                        cellStyleInfo_date.setFm("yyyy-MM-dd");
                        cellStyleInfo_date.setHa(HorizontalAlignEnum.RIGHT);
                        return cellStyleInfo_date;
                    }
                    if (MetricDataTypeEnum.TEXT.getIndex().equals(datatype) || MetricDataTypeEnum.ENUM.getIndex().equals(datatype)) {
                        CellStyleInfo cellStyleInfo_text = new CellStyleInfo();
                        cellStyleInfo_text.setFm("@");
                        cellStyleInfo_text.setHa(HorizontalAlignEnum.LEFT);
                        return cellStyleInfo_text;
                    }
                    if (MetricDataTypeEnum.CURRENCY.getIndex().equals(datatype) || MetricDataTypeEnum.NONMONETARY.getIndex().equals(datatype)) {
                        fm = "#,##0.00";
                    }
                }
            }
            if (StringUtils.isNotEmpty((String)use) && !MetricUseEnum.Prepare.getIndex().equals(use)) {
                cellStyleInfo_specialnumber.setL(true);
            }
            cellStyleInfo_specialnumber.setFm(fm);
            cellStyleInfo_specialnumber.setHa(HorizontalAlignEnum.RIGHT);
        }
        return cellStyleInfo_specialnumber;
    }

    private CellStyleInfo getSpecialCellStye_percent(MetricCellDimMember metricCellDimMember) {
        String metricNumber = metricCellDimMember.getDimMemberNumber();
        String use = metricCellDimMember.getUse();
        CellStyleInfo cellStyleInfo_percent = this.specialCellStye_percentMap.get(metricNumber + "_" + use);
        if (cellStyleInfo_percent == null) {
            cellStyleInfo_percent = new CellStyleInfo();
            this.specialCellStye_percentMap.put(metricNumber + "_" + use, cellStyleInfo_percent);
            String fm = null;
            if (this.metricCellStyleInfos != null && metricNumber != null) {
                for (MetricCellStyleInfo metricCellStyleInfo : this.metricCellStyleInfos) {
                    if (!metricNumber.equals(metricCellStyleInfo.getMetricNumber()) || metricCellStyleInfo.getFm() == null) continue;
                    fm = metricCellStyleInfo.getFm();
                    break;
                }
            }
            if (fm == null) {
                String decimalnum_str = metricCellDimMember.getDecimalnum();
                StringBuilder sb = new StringBuilder();
                Integer decimalnum = null;
                decimalnum = StringUtils.isNotEmpty((String)decimalnum_str) && !"null".equals(decimalnum_str) ? Integer.valueOf(Integer.parseInt(decimalnum_str)) : this.metricDecimalMap.get(metricNumber);
                if (decimalnum != null && decimalnum > 0) {
                    sb.append("0.");
                    Integer i = 0;
                    while (i < decimalnum) {
                        sb.append('0');
                        Integer n = i;
                        Integer n2 = i = Integer.valueOf(i + 1);
                    }
                    sb.append('%');
                } else if (decimalnum != null && decimalnum == 0) {
                    sb.append("0%");
                } else {
                    sb.append("0.00%");
                }
                fm = sb.toString();
            }
            if (fm == null) {
                fm = "0.00%";
            }
            if (fm.indexOf("%") < 0) {
                fm = fm + "%";
            }
            cellStyleInfo_percent.setFm(fm);
            cellStyleInfo_percent.setHa(HorizontalAlignEnum.RIGHT);
            if (StringUtils.isNotEmpty((String)use) && !MetricUseEnum.Prepare.getIndex().equals(use)) {
                cellStyleInfo_percent.setL(true);
            }
        }
        return cellStyleInfo_percent;
    }

    private void addCellStyleInfo(Map<CellStyleInfo, List<Integer>> rowcols, CellStyleInfo cellStyleInfo, int rowcol) {
        List<Integer> rowcol_number = rowcols.get(cellStyleInfo);
        if (rowcol_number == null) {
            rowcol_number = new ArrayList<Integer>();
        }
        rowcol_number.add(rowcol);
        rowcols.put(cellStyleInfo, rowcol_number);
    }
}

