/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.control;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.lang.constant.Constable;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.bos.orm.util.ReflectionUtils;
import kd.epm.eb.spread.command.rangedefined.ButtonCell;
import kd.epm.eb.spread.command.rangedefined.CellArea;
import kd.epm.eb.spread.command.rangedefined.ComboboxCell;
import kd.epm.eb.spread.command.rangedefined.ContextMenuItemsEnum;
import kd.epm.eb.spread.command.rangedefined.CustomFormula;
import kd.epm.eb.spread.command.rangedefined.FormulaCell;
import kd.epm.eb.spread.command.rangedefined.RedPointCell;
import kd.epm.eb.spread.command.rangedefined.SheetFrozenInfo;
import kd.epm.eb.spread.command.rangedefined.Shortcut;
import kd.epm.eb.spread.command.rangedefined.ToolBarItemsEnum;
import kd.epm.eb.spread.command.rangedefined.WorkbookOptions;
import kd.epm.eb.spread.command.rule.ConditionFormatParameter;
import kd.epm.eb.spread.command.style.AreasStyle;
import kd.epm.eb.spread.command.style.CellGroupNodeInfo;
import kd.epm.eb.spread.command.style.CellStyleInfo;
import kd.epm.eb.spread.command.style.ContextMenuWorkArea;
import kd.epm.eb.spread.control.ISpreadContainer;
import kd.epm.eb.spread.domain.view.js.SpreadProperties;
import kd.epm.eb.spread.model.MenuItem;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;

public class CmdSpreadContainer
implements ISpreadContainer,
Serializable {
    private static final long serialVersionUID = -8272450388102971374L;
    private List<Map<String, Object>> cmdList = new ArrayList<Map<String, Object>>(64);

    public List<Map<String, Object>> getCmdList() {
        return this.cmdList;
    }

    @Override
    public void callbackAction(String plugin_methodname) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("callback", "invokeAction");
        params.put("invokemethod", plugin_methodname);
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)SpreadProperties.CallBackActionMethod.CALLBACKACTION.k(), params));
    }

    @Override
    public void rebuildSpread(String json) {
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)SpreadProperties.SetSpreadJsonMethod.SETSPREADJSON.k(), (Object)json));
    }

    @Override
    public void appendRowCols(int rows, int cols) {
        if (rows > 0) {
            HashMap<String, Integer> rowcounts = new HashMap<String, Integer>();
            rowcounts.put("count", rows);
            this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"appendRows", rowcounts));
        }
        if (cols > 0) {
            HashMap<String, Integer> colcounts = new HashMap<String, Integer>();
            colcounts.put("count", cols);
            this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"appendCols", colcounts));
        }
    }

    @Override
    public void deleteRowCol(List<Integer> rowindexs, List<Integer> colindexs) {
        HashMap<String, Object> parasmap;
        if (rowindexs != null && rowindexs.size() > 0) {
            rowindexs.sort((o1, o2) -> o2 - o1);
            parasmap = new HashMap<String, Object>();
            parasmap.put("status", "true");
            parasmap.put("data", rowindexs);
            this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"deleteRow", parasmap));
        }
        if (colindexs != null && colindexs.size() > 0) {
            colindexs.sort((o1, o2) -> o2 - o1);
            parasmap = new HashMap();
            parasmap.put("status", "true");
            parasmap.put("data", colindexs);
            this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"deleteCol", parasmap));
        }
    }

    @Override
    public void deleteRowCol(int index, int count, boolean isRow) {
        LinkedHashMap<String, Object> parasmap = new LinkedHashMap<String, Object>(16);
        HashMap<String, Integer> data = new HashMap<String, Integer>();
        data.put("index", index);
        data.put("count", count);
        parasmap.put("status", true);
        parasmap.put("data", Collections.singletonList(data));
        if (isRow) {
            this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"deleteRow", parasmap));
        } else {
            this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"deleteCol", parasmap));
        }
    }

    @Override
    public void insertRowCol(List<Integer> rowindexs, List<Integer> colindexs) {
        HashMap<String, Object> parasmap;
        if (rowindexs != null && rowindexs.size() > 0) {
            parasmap = new HashMap<String, Object>();
            parasmap.put("status", "true");
            parasmap.put("data", rowindexs);
            this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"insertRow", parasmap));
        }
        if (colindexs != null && colindexs.size() > 0) {
            parasmap = new HashMap();
            parasmap.put("status", "true");
            parasmap.put("data", colindexs);
            this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"insertCol", parasmap));
        }
    }

    @Override
    public void insertRowCol(List<Integer> rowindexs, List<Integer> colindexs, boolean copyStyle) {
        HashMap<String, Object> parasmap;
        if (rowindexs != null && rowindexs.size() > 0) {
            parasmap = new HashMap<String, Object>();
            parasmap.put("copyStyle", copyStyle);
            parasmap.put("status", "true");
            parasmap.put("data", rowindexs);
            this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"insertRow", parasmap));
        }
        if (colindexs != null && colindexs.size() > 0) {
            parasmap = new HashMap();
            parasmap.put("copyStyle", copyStyle);
            parasmap.put("status", "true");
            parasmap.put("data", colindexs);
            this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"insertCol", parasmap));
        }
    }

    @Override
    public void setColumnsWidth(List<Integer> colindexs, int width) {
        if (colindexs == null || colindexs.size() == 0) {
            return;
        }
        HashMap<String, Object> parasmap = new HashMap<String, Object>();
        parasmap.put("index", colindexs);
        parasmap.put("num", width);
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)SpreadProperties.SetColumnsWidthMethod.SETCOLUMNSWIDTH.k(), parasmap));
    }

    @Override
    public void setRowsHeight(List<Integer> rowindexs, int height) {
        if (rowindexs == null || rowindexs.size() == 0) {
            return;
        }
        HashMap<String, Object> parasmap = new HashMap<String, Object>();
        parasmap.put("index", rowindexs);
        parasmap.put("num", height);
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)SpreadProperties.SetRowsHeightMethod.SETROWSHEIGHT.k(), parasmap));
    }

    @Override
    public void lockCells(List<CellArea> paras) {
        if (paras == null || paras.size() == 0) {
            return;
        }
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)SpreadProperties.LockCellMethod.LOACKCELL.k(), paras));
    }

    @Override
    public void lockECells(List<ECell> paras) {
        if (paras == null || paras.size() == 0) {
            return;
        }
        ArrayList<CellArea> areas = new ArrayList<CellArea>(paras.size());
        for (ECell para : paras) {
            areas.add(new CellArea(para.getRow(), para.getCol(), 1, 1));
        }
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)SpreadProperties.LockCellMethod.LOACKCELL.k(), areas));
    }

    @Override
    public void unlockCells(List<CellArea> paras) {
        if (paras == null || paras.size() == 0) {
            return;
        }
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)SpreadProperties.UnlockCellMethod.UNLOACKCELL.k(), paras));
    }

    @Override
    public void lockSheets(List<String> sheetnames) {
        if (sheetnames != null && sheetnames.size() > 0) {
            this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)SpreadProperties.LockSheetMethod.LOACKSHEET.k(), sheetnames));
        }
    }

    @Override
    public void unlockSheets(List<String> sheetnames) {
        if (sheetnames != null && sheetnames.size() > 0) {
            this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)SpreadProperties.UnLockSheetMethod.UNLOACKSHEET.k(), sheetnames));
        }
    }

    @Override
    public void updateCellValue2(List<ECell> cells) {
        ArrayList parameters = new ArrayList(cells.size());
        for (ECell cell : cells) {
            HashMap<String, Object> valMap = new HashMap<String, Object>();
            valMap.put(SpreadProperties.UpdataValueMethod.R.k(), cell.getRow());
            valMap.put(SpreadProperties.UpdataValueMethod.C.k(), cell.getCol());
            valMap.put(SpreadProperties.UpdataValueMethod.V.k(), cell.getValue());
            parameters.add(valMap);
        }
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)SpreadProperties.UpdataValueMethod.UPDATAVALUE.k(), parameters));
    }

    @Override
    public void updateCellValue(List<Map<String, Object>> parameters) {
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)SpreadProperties.UpdataValueMethod.UPDATAVALUE.k(), parameters));
    }

    @Override
    public void setSpan(List<CellArea> areas) {
        if (areas != null && areas.size() > 0) {
            HashMap<String, List<CellArea>> parasmap = new HashMap<String, List<CellArea>>();
            parasmap.put("range", areas);
            this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"setSpan", parasmap));
        }
    }

    @Override
    public void setCellStyle(List<AreasStyle> areasStyles) {
        if (areasStyles == null || areasStyles.size() == 0) {
            return;
        }
        Object paras = this.packageAreaStyles(areasStyles);
        if (paras != null) {
            this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)SpreadProperties.SetCellStyleMethod.SETCELLSTYLE.k(), (Object)paras));
        }
    }

    @Override
    public void fieldInsertRowCol(CellArea range, int index, int count, int styleIndex, boolean isrow, boolean allowSize) {
        LinkedHashMap<String, Serializable> parasmap = new LinkedHashMap<String, Serializable>();
        parasmap.put("range", range);
        parasmap.put("index", Integer.valueOf(index));
        parasmap.put("count", Integer.valueOf(count));
        parasmap.put("styleIndex", Integer.valueOf(styleIndex));
        parasmap.put("allowSize", Boolean.valueOf(allowSize));
        if (isrow) {
            this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)SpreadProperties.FieldInsertMethod.FIELDINSERTROW.k(), parasmap));
        } else {
            this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)SpreadProperties.FieldInsertMethod.FIELDINSERTCOL.k(), parasmap));
        }
    }

    @Override
    public void fieldInsertRowCol(CellArea range, int index, int count, int styleIndex, boolean isrow) {
        this.fieldInsertRowCol(range, index, count, styleIndex, isrow, true);
    }

    @Override
    public void fieldDeleteRowCol(CellArea range, int index, int count, boolean isrow) {
        LinkedHashMap<String, Serializable> parasmap = new LinkedHashMap<String, Serializable>();
        CellArea range01 = new CellArea(range.getR(), range.getC(), range.getRc(), range.getCc());
        parasmap.put("range", range01);
        parasmap.put("index", Integer.valueOf(index));
        parasmap.put("count", Integer.valueOf(count));
        if (isrow) {
            this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)SpreadProperties.FieldDelMethod.FIELDDELROW.k(), parasmap));
        } else {
            this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)SpreadProperties.FieldDelMethod.FIELDDELCOL.k(), parasmap));
        }
    }

    @Override
    public void setFListCells(List<ECell> cells, boolean fuzzyQuery, boolean combobox) {
        this.setFListCells(cells, fuzzyQuery, combobox, false);
    }

    @Override
    public void setFListCells(List<ECell> cells, boolean fuzzyQuery, boolean combobox, boolean quickAddNew) {
        ArrayList celllist = new ArrayList(cells.size());
        for (ECell cell : cells) {
            HashMap<String, Integer> cellmap = new HashMap<String, Integer>();
            cellmap.put("r", cell.getRow());
            cellmap.put("c", cell.getCol());
            celllist.add(cellmap);
        }
        LinkedHashMap<String, Serializable> parasmap = new LinkedHashMap<String, Serializable>();
        parasmap.put("cell", celllist);
        parasmap.put("selectType", Integer.valueOf(fuzzyQuery ? 0 : 1));
        parasmap.put("dst", Integer.valueOf(combobox ? 1 : 0));
        parasmap.put("showAddBtnWhenNoData", Boolean.valueOf(quickAddNew));
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)SpreadProperties.SetF7TypeCellMethod.SETF7TYPECELL.k(), parasmap));
    }

    @Override
    public void setFListCellArea(List<CellArea> cellAreas, boolean fuzzyQuery, boolean combobox) {
        LinkedHashMap<String, Object> parasmap = new LinkedHashMap<String, Object>();
        parasmap.put("cell", cellAreas);
        parasmap.put("selectType", fuzzyQuery ? 0 : 1);
        parasmap.put("dst", combobox ? 1 : 0);
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)SpreadProperties.SetF7TypeCellMethod.SETF7TYPECELL.k(), parasmap));
    }

    @Override
    public void setComboCell(List<ComboboxCell> comboboxCells) {
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"setComboCell", comboboxCells));
    }

    @Override
    public void setBtnCell(List<ButtonCell> buttonCells) {
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"setBtnCell", buttonCells));
    }

    @Override
    public void setCustomBtnCell(List<ButtonCell> buttonCells) {
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"setCustomBtnCell", buttonCells));
    }

    @Override
    public void setCellTag(List<RedPointCell> redPointCells) {
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"setCellTag", redPointCells));
    }

    @Override
    public void clearRowCellTags3(int rowIndex, int count, int startCol, int endCol) {
    }

    @Override
    public void clearColCellTags3(int colIndex, int count, int startRow, int endRow) {
    }

    @Override
    public void resetCell(List<CellArea> areas) {
        HashMap<String, List<CellArea>> parasmap = new HashMap<String, List<CellArea>>();
        parasmap.put("range", areas);
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"resetCell", parasmap));
    }

    @Override
    public void getSpreadJson(String callBack_MethodName) {
        HashMap<String, String> params = new HashMap<String, String>();
        params.put("callback", "invokeAction");
        params.put("invokemethod", callBack_MethodName);
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)SpreadProperties.GetSpreadJsonMethod.GETSPREADMETHOD.k(), params));
    }

    @Override
    public void getRangeStyles(List<Object> area, String si, String callBack_MethodName) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("callback", "invokeAction");
        params.put("range", area);
        params.put("si", si);
        params.put("invokemethod", callBack_MethodName);
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"getRangeStyles", (Object)Lists.newArrayList((Object[])new Map[]{params})));
    }

    @Override
    public void getLockedCells(boolean compression, String si, String callBack_MethodName) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("callback", "invokeAction");
        params.put("compression", compression);
        params.put("si", si);
        params.put("invokemethod", callBack_MethodName);
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"getLockedCells", (Object)Lists.newArrayList((Object[])new Map[]{params})));
    }

    @Override
    public void setLookupData(ECell cell, Object data) {
        LinkedHashMap<String, Object> parasmap = new LinkedHashMap<String, Object>();
        parasmap.put("r", cell.getRow());
        parasmap.put("c", cell.getCol());
        parasmap.put("data", data);
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"setLookupData", parasmap));
    }

    @Override
    public void setCustomFormulaCell(List<ECell> cells) {
        ArrayList paraslist = new ArrayList(cells.size());
        for (ECell cell : cells) {
            LinkedHashMap<String, Integer> parasmap = new LinkedHashMap<String, Integer>();
            parasmap.put("r", cell.getRow());
            parasmap.put("c", cell.getCol());
            paraslist.add(parasmap);
        }
        if (paraslist.size() > 0) {
            HashMap cellsmap = new HashMap();
            cellsmap.put("cell", paraslist);
            this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)SpreadProperties.SetCustomFormulaCellMethod.SETCUSTOMFORMULACELL.k(), cellsmap));
        }
    }

    @Override
    public void setAllCustomFormulaCell() {
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"setAllCustomFormulaCell", (Object)""));
    }

    @Override
    public void registerCustomFormula(List<CustomFormula> customFormulas) {
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)SpreadProperties.RegisterCustomFormulaMethod.REGISTERCUSTOMFORMULA.k(), customFormulas));
    }

    @Override
    public void setFormula(List<FormulaCell> formulaCells) {
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)SpreadProperties.SetFormulaMethod.SETFORMULA.k(), formulaCells));
    }

    @Override
    public void setSelections(CellArea cellArea, boolean triggerSel) {
        HashMap<String, Constable> params = new HashMap<String, Constable>(16);
        params.put("r", Integer.valueOf(cellArea.getR()));
        params.put("c", Integer.valueOf(cellArea.getC()));
        params.put("rc", Integer.valueOf(cellArea.getRc()));
        params.put("cc", Integer.valueOf(cellArea.getCc()));
        params.put("triggerSel", Boolean.valueOf(triggerSel));
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)SpreadProperties.SetSelectionsMethod.SETSELECTIONS.k(), params));
    }

    @Override
    public void setSelections(CellArea cellArea) {
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)SpreadProperties.SetSelectionsMethod.SETSELECTIONS.k(), (Object)cellArea));
    }

    @Override
    public void exportExcelFile(String fileName) {
        HashMap<String, String> parasmap = new HashMap<String, String>();
        parasmap.put("fileName", fileName);
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)SpreadProperties.ExportExcelFileMethod.EXPORTEXCELFILE.k(), parasmap));
    }

    @Override
    public void lockToolbarItems(List<ToolBarItemsEnum> lockItems, List<ToolBarItemsEnum> unlockItems) {
        LinkedHashMap<String, Object> lockmap;
        ArrayList locks = new ArrayList(lockItems.size() + unlockItems.size());
        for (ToolBarItemsEnum lockItem : lockItems) {
            lockmap = new LinkedHashMap<String, Object>();
            lockmap.put("name", lockItem.getNumber());
            lockmap.put("isLock", 1);
            locks.add(lockmap);
        }
        for (ToolBarItemsEnum lockItem : unlockItems) {
            lockmap = new LinkedHashMap();
            lockmap.put("name", lockItem.getNumber());
            lockmap.put("isLock", 0);
            locks.add(lockmap);
        }
        if (locks.size() > 0) {
            this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)SpreadProperties.LockToolbarItemsMethod.LOCKTOOLBARITEMS.k(), locks));
        }
    }

    @Override
    public void hideContextMenuItems(List<ContextMenuItemsEnum> hideItems, List<ContextMenuItemsEnum> showItems) {
        LinkedHashMap<String, Object> lockmap;
        HashMap<String, Integer> lockmap2;
        ArrayList paraslist = new ArrayList();
        if (showItems != null && showItems.size() > 0) {
            if (showItems.size() == ContextMenuItemsEnum.values().length) {
                lockmap2 = new HashMap();
                lockmap2.put("isHide", 0);
                this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)SpreadProperties.HideContextMenuItemsMethod.HIDECONTEXTMENUITEMS.k(), lockmap2));
            } else {
                for (ContextMenuItemsEnum showItem : showItems) {
                    lockmap = new LinkedHashMap<String, Object>();
                    lockmap.put("name", showItem.getNumber());
                    lockmap.put("isHide", 0);
                    paraslist.add(lockmap);
                }
            }
        }
        if (hideItems != null && hideItems.size() > 0) {
            if (hideItems.size() == ContextMenuItemsEnum.values().length) {
                lockmap2 = new HashMap<String, Integer>();
                lockmap2.put("isHide", (Integer)((Object)"1"));
                this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)SpreadProperties.HideContextMenuItemsMethod.HIDECONTEXTMENUITEMS.k(), lockmap2));
            } else {
                for (ContextMenuItemsEnum hideItem : hideItems) {
                    lockmap = new LinkedHashMap();
                    lockmap.put("name", hideItem.getNumber());
                    lockmap.put("isHide", 1);
                    paraslist.add(lockmap);
                }
            }
        }
        if (paraslist.size() > 0) {
            this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)SpreadProperties.HideContextMenuItemsMethod.HIDECONTEXTMENUITEMS.k(), paraslist));
        }
    }

    @Override
    public void hideContextMenuItemsByKey(List<String> hideItems, List<String> showItems) {
        LinkedHashMap<String, Object> lockmap;
        ArrayList paraslist = new ArrayList();
        if (showItems != null && showItems.size() > 0) {
            for (String showItem : showItems) {
                lockmap = new LinkedHashMap<String, Object>();
                lockmap.put("name", showItem);
                lockmap.put("isHide", 0);
                paraslist.add(lockmap);
            }
        }
        if (hideItems != null && hideItems.size() > 0) {
            for (String hideItem : hideItems) {
                lockmap = new LinkedHashMap();
                lockmap.put("name", hideItem);
                lockmap.put("isHide", 1);
                paraslist.add(lockmap);
            }
        }
        if (paraslist.size() > 0) {
            this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)SpreadProperties.HideContextMenuItemsMethod.HIDECONTEXTMENUITEMS.k(), paraslist));
        }
    }

    @Override
    public void addContextMenuItems(String callBackMethod, String title, ContextMenuWorkArea contextMenuWorkArea) {
        LinkedHashMap<String, Object> paras = new LinkedHashMap<String, Object>(8);
        paras.put("callback", "invokeAction");
        ArrayList items = new ArrayList();
        LinkedHashMap<String, Object> items_map = new LinkedHashMap<String, Object>(8);
        paras.put("items", items);
        items.add(items_map);
        items_map.put("name", callBackMethod);
        items_map.put("text", title);
        items_map.put("workArea", contextMenuWorkArea.getList());
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"addContextMenuItems", paras));
    }

    @Override
    public void deleteContextMenuItems(String[] name) {
        if (name != null && name.length > 0) {
            LinkedList params = new LinkedList();
            for (int i = 0; i < name.length; ++i) {
                HashMap<String, String> para = new HashMap<String, String>(2);
                para.put("name", name[i]);
                params.add(para);
            }
            this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"deleteContextMenuItems", params));
        }
    }

    @Override
    public void setDisplayLeftText(String text) {
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"setDisplayLeftText", (Object)text));
    }

    @Override
    public void setDisplayCenterText(String text) {
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"setDisplayCenterText", (Object)text));
    }

    @Override
    public void clearCellsStyle(List<CellArea> cellAreas) {
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"clearCellsStyle", cellAreas));
    }

    @Override
    public void controlToolbarItems(List<ToolBarItemsEnum> needControl, List<ToolBarItemsEnum> notneedControl) {
        HashMap<String, String> parasmap;
        ArrayList paraslist = new ArrayList();
        if (needControl != null && needControl.size() > 0) {
            for (ToolBarItemsEnum toolBarItemsEnum : needControl) {
                parasmap = new HashMap<String, String>();
                parasmap.put("name", toolBarItemsEnum.getNumber());
                parasmap.put("isCtl", "true'");
                paraslist.add(parasmap);
            }
        }
        if (notneedControl != null && notneedControl.size() > 0) {
            for (ToolBarItemsEnum toolBarItemsEnum : notneedControl) {
                parasmap = new HashMap();
                parasmap.put("name", toolBarItemsEnum.getNumber());
                parasmap.put("isCtl", "false'");
                paraslist.add(parasmap);
            }
        }
        if (paraslist.size() > 0) {
            this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"controlToolbarItems", paraslist));
        }
    }

    @Override
    public void closeToolbar() {
        HashMap parasmap = new HashMap();
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)SpreadProperties.CloseToolBar.CLOSETOOLBAR.k(), parasmap));
    }

    @Override
    public void closeToolbar(Boolean showExpandBtnVisible) {
        HashMap parasmap = new HashMap();
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)SpreadProperties.CloseToolBar.CLOSETOOLBAR.k(), parasmap));
        this.setToolbarExpandBtnVisible(showExpandBtnVisible);
    }

    @Override
    public void setToolbarExpandBtnVisible(Boolean visible) {
        HashMap<String, Boolean> parasmap = new HashMap<String, Boolean>();
        parasmap.put("visible", visible);
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"setExpandBtnVisible", parasmap));
    }

    @Override
    public void frozenSheet(SheetFrozenInfo frozenInfo) {
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"frozenSheet", (Object)frozenInfo));
    }

    @Override
    public void setRowsAutoFit(List<Integer> rows) {
        HashMap<String, List<Integer>> paras = new HashMap<String, List<Integer>>();
        paras.put(SpreadProperties.AutoFitRows.R.k(), rows);
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)SpreadProperties.AutoFitRows.AUTOFITROWS.k(), paras));
    }

    @Override
    public void setColsAutoFit(List<Integer> cols) {
        HashMap<String, List<Integer>> paras = new HashMap<String, List<Integer>>();
        paras.put(SpreadProperties.AutoFitColumns.C.k(), cols);
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)SpreadProperties.AutoFitColumns.AUTOFITCOLUMNS.k(), paras));
    }

    @Override
    public void setShortcutKey(Shortcut shortcut) {
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)SpreadProperties.SetShortcutKey.SETSHORTCUTKEY.k(), (Object)shortcut));
    }

    @Override
    public void setWorkbookOptions(WorkbookOptions workbookOptions) {
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"setWorkbookOptions", (Object)workbookOptions));
    }

    private Object packageAreaStyles(List<AreasStyle> areasStyles) {
        ArrayList rangestyles = new ArrayList();
        for (AreasStyle areasStyle : areasStyles) {
            List<CellArea> areas;
            if (areasStyle == null || (areas = areasStyle.getRange()) == null || areas.size() == 0) continue;
            CellStyleInfo cellStyleInfo = areasStyle.getStyle();
            Field[] fields = cellStyleInfo.getClass().getDeclaredFields();
            LinkedHashMap<String, Object> style = new LinkedHashMap<String, Object>();
            LinkedHashMap<String, Object> bls = new LinkedHashMap<String, Object>();
            for (Field field : fields) {
                String fieldname = field.getName();
                Object value = null;
                try {
                    ReflectionUtils.makeAccessible((Field)field);
                    value = field.get(cellStyleInfo);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                if (value == null) continue;
                if ("bls".equals(fieldname) || "blc".equals(fieldname)) {
                    bls.put(fieldname, value);
                    continue;
                }
                if ("ha".equals(fieldname) || "va".equals(fieldname)) {
                    if (!(value instanceof Integer) || (Integer)value < 0) continue;
                    style.put(fieldname, value);
                    continue;
                }
                style.put(fieldname, value);
            }
            if (bls.size() > 0) {
                style.put("bl", bls);
            }
            if (style.size() <= 0 || areas.size() <= 0) continue;
            LinkedHashMap<String, Object> rangestyle = new LinkedHashMap<String, Object>();
            rangestyle.put("range", areas);
            rangestyle.put("style", style);
            rangestyles.add(rangestyle);
        }
        if (rangestyles.size() > 0) {
            return rangestyles;
        }
        return null;
    }

    @Override
    public void setDisplayContent(String status, String cellMsg, String convertStatus) {
        this.setDisplayContent("", status, cellMsg, convertStatus, "");
    }

    @Override
    public void setDisplayContent(String attachement, String status, String cellMsg, String convertStatus, String unit) {
        Map<String, Object> attachementArea = CmdSpreadContainer.getStatusBarArea("attachement", attachement, "60pt", "#000000", "flex-start");
        Map<String, Object> statusArea = CmdSpreadContainer.getStatusBarArea("status", status, "8%", "#000000", "flex-grow");
        Map<String, Object> cellMsgArea = CmdSpreadContainer.getStatusBarArea("cellMsg", cellMsg, "55%", "#000000", "flex-grow");
        Map<String, Object> convertStatusArea = CmdSpreadContainer.getStatusBarArea("convertStatus", convertStatus, "15%", "#000000", "flex-grow");
        Map<String, Object> unitArea = CmdSpreadContainer.getStatusBarArea("unitArea", unit, "8%", "#000000", "flex-grow");
        ArrayList<Map<String, Object>> areaList = new ArrayList<Map<String, Object>>();
        areaList.add(attachementArea);
        areaList.add(statusArea);
        areaList.add(convertStatusArea);
        areaList.add(cellMsgArea);
        areaList.add(unitArea);
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)SpreadProperties.SetDisplayContentMethod.SETDISPALYCONTENT.k(), areaList));
    }

    private static Map<String, Object> getStatusBarArea(String key, String text, String w, String fc, String gr) {
        LinkedHashMap<String, Object> area = new LinkedHashMap<String, Object>();
        area.put(SpreadProperties.SetDisplayContentMethod.key.k(), key);
        area.put(SpreadProperties.SetDisplayContentMethod.TEXT.k(), text);
        LinkedHashMap<String, String> areaStyle = new LinkedHashMap<String, String>();
        areaStyle.put(SpreadProperties.SetDisplayContentMethod.w.k(), w);
        areaStyle.put(SpreadProperties.SetDisplayContentMethod.fc.k(), fc);
        areaStyle.put(SpreadProperties.SetDisplayContentMethod.gr.k(), gr);
        area.put(SpreadProperties.SetDisplayContentMethod.s.k(), areaStyle);
        return area;
    }

    @Override
    public void getColumnsWidth(Integer[] cols, String callBackMethodName) {
        HashMap<String, Object> paras = new HashMap<String, Object>();
        paras.put("index", cols);
        paras.put("callback", "invokeAction");
        paras.put("invokemethod", callBackMethodName);
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"getColumnsWidth", paras));
    }

    @Override
    public void getColumnsWidth(List<Integer> cols, String callBackMethodName) {
        this.getColumnsWidth(cols.toArray(new Integer[0]), callBackMethodName);
    }

    @Override
    public void getRowsHeight(Integer[] rows, String callBackMethodName) {
        HashMap<String, Object> paras = new HashMap<String, Object>();
        paras.put("index", rows);
        paras.put("callback", "invokeAction");
        paras.put("invokemethod", callBackMethodName);
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"getRowsHeight", paras));
    }

    @Override
    public void getRowsHeight(List<Integer> rows, String callBackMethodName) {
        this.getRowsHeight(rows.toArray(new Integer[0]), callBackMethodName);
    }

    @Override
    public void setOutlineColumn(int col, Boolean showCheckBox, Integer maxLevel, boolean default_collapsed) {
        HashMap<String, Serializable> datas = new HashMap<String, Serializable>();
        HashMap<String, Comparable<Boolean>> options = new HashMap<String, Comparable<Boolean>>();
        if (showCheckBox != null) {
            options.put("showCheckBox", showCheckBox);
            options.put("maxLevel", maxLevel);
            options.put("collapsed", Boolean.valueOf(default_collapsed));
        }
        if (options.size() > 0) {
            datas.put("options", options);
        }
        datas.put("c", Integer.valueOf(col));
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"setOutlineColumn", datas));
    }

    @Override
    public void setOutlineColumn(int col, Boolean showCheckBox, Integer maxLevel, Map<Integer, Boolean> collapsedFlags) {
        HashMap<String, Serializable> datas = new HashMap<String, Serializable>();
        HashMap<String, Object> options = new HashMap<String, Object>();
        if (showCheckBox != null) {
            options.put("showCheckBox", showCheckBox);
            options.put("maxLevel", maxLevel);
            options.put("collapsed", collapsedFlags);
        }
        if (options.size() > 0) {
            datas.put("options", options);
        }
        datas.put("c", Integer.valueOf(col));
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"setOutlineColumn", datas));
    }

    @Override
    public void getOutlineColumnNode(int si, String callbackMethod) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("si", si);
        params.put("callback", "invokeAction");
        params.put("invokemethod", callbackMethod);
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"getOutlineColumnNode", params));
    }

    @Override
    public void setVirtualMode(String callbackMethod, boolean isopen) {
        this.setVirtualMode(callbackMethod, isopen, 100);
    }

    @Override
    public void setVirtualMode(String callbackMethod, boolean isopen, Integer delay) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("callback", "invokeAction");
        params.put("invokemethod", callbackMethod);
        params.put("isOpen", isopen);
        if (delay != null) {
            params.put("delay", delay);
        }
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"setVirtualMode", params));
    }

    @Override
    public void addSheets(int index, String name, int rc, int cc) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        HashMap<String, Object[]> fea = new HashMap<String, Object[]>();
        Object[] objects = new Object[]{params};
        params.put("index", index);
        params.put("name", name);
        params.put("rc", rc);
        params.put("cc", cc);
        fea.put("sheets", objects);
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"addSheets", fea));
    }

    @Override
    public void updateCellValueAddSheet(List<Map<String, Object>> parameters, int si) {
        HashMap<String, Object> para = new HashMap<String, Object>();
        para.put("si", si);
        para.put("cells", parameters);
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)SpreadProperties.UpdataValueMethod.UPDATAVALUE.k(), para));
    }

    @Override
    public void setColumnsWidthAddSheet(Map<String, Object> parasmap) {
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)SpreadProperties.SetColumnsWidthMethod.SETCOLUMNSWIDTH.k(), parasmap));
    }

    @Override
    public void appendRowColsAddSheet(int rows, int cols, int si) {
        if (rows > 0) {
            HashMap<String, Integer> rowcounts = new HashMap<String, Integer>();
            rowcounts.put("count", rows);
            rowcounts.put("si", si);
            this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"appendRows", rowcounts));
        }
        if (cols > 0) {
            HashMap<String, Integer> colcounts = new HashMap<String, Integer>();
            colcounts.put("count", cols);
            colcounts.put("si", si);
            this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"appendCols", colcounts));
        }
    }

    @Override
    public void setCol0rRowGroupbyOnesheet(int count, int index, int si, boolean isRow) {
        HashMap<String, Object> feature = new HashMap<String, Object>();
        LinkedHashMap<String, Integer> rowcounts = new LinkedHashMap<String, Integer>();
        Object[] objects = new Object[1];
        rowcounts.put("index", index);
        rowcounts.put("count", count);
        objects[0] = rowcounts;
        feature.put("groups", objects);
        feature.put("si", si);
        if (isRow) {
            this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"setRowOutlines", feature));
        } else {
            this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"setColumnOutlines", feature));
        }
    }

    @Override
    public void expandRowOrColOutlines(int maxlevels, boolean expand, int si, boolean isRow) {
        HashMap<String, Object> feature = new HashMap<String, Object>();
        Integer[] levels = new Integer[maxlevels + 1];
        for (int i = 0; i < levels.length; ++i) {
            levels[i] = i;
        }
        feature.put("levels", levels);
        feature.put("expand", expand);
        feature.put("si", si);
        if (isRow) {
            this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"expandRowOutlines", feature));
        } else {
            this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"expandColumnOutlines", feature));
        }
    }

    @Override
    public void insertRowColAddSheet(List<Integer> rowindexs, List<Integer> colindexs, int si) {
        HashMap<String, Object> parasmap;
        if (rowindexs != null && rowindexs.size() > 0) {
            parasmap = new HashMap<String, Object>();
            parasmap.put("status", "true");
            parasmap.put("data", rowindexs);
            parasmap.put("si", si);
            parasmap.put("copyStyle", false);
            this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"insertRow", parasmap));
        }
        if (colindexs != null && colindexs.size() > 0) {
            parasmap = new HashMap();
            parasmap.put("status", "true");
            parasmap.put("data", colindexs);
            parasmap.put("copyStyle", false);
            parasmap.put("si", si);
            this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"insertCol", parasmap));
        }
    }

    @Override
    public void setCellStyleAddSheet(List<AreasStyle> areasStyles, int si) {
        HashMap<String, Object> featuer = new HashMap<String, Object>();
        if (areasStyles == null || areasStyles.size() == 0) {
            return;
        }
        Object paras = this.packageAreaStyles(areasStyles);
        featuer.put("si", si);
        featuer.put("data", paras);
        if (paras != null) {
            this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)SpreadProperties.SetCellStyleMethod.SETCELLSTYLE.k(), featuer));
        }
    }

    @Override
    public void setCellTags(List<Map<String, Object>> cellTags) {
        if (cellTags == null || cellTags.size() == 0) {
            return;
        }
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"setCellTag", cellTags));
    }

    @Override
    public void setComment(List<Map<String, Object>> data, int si) {
        if (data == null || data.size() == 0) {
            return;
        }
        ArrayList data11 = new ArrayList();
        HashMap<String, Object> optionMap1 = new HashMap<String, Object>();
        optionMap1.put("si", si);
        optionMap1.put("options", data);
        data11.add(optionMap1);
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"setComment", data11));
    }

    @Override
    public void addContextMenuItems(String callBackMethod, String title, List<Map<String, Object>> subMenus, ContextMenuWorkArea contextMenuWorkArea) {
        HashMap<String, Object> paras = new HashMap<String, Object>();
        paras.put("callback", "invokeAction");
        ArrayList items = new ArrayList();
        HashMap<String, Object> items_map = new HashMap<String, Object>();
        paras.put("items", items);
        items.add(items_map);
        items_map.put("name", callBackMethod);
        items_map.put("text", title);
        items_map.put("workArea", contextMenuWorkArea.getList());
        if (subMenus != null && !subMenus.isEmpty()) {
            items_map.put("subMenu", subMenus);
        }
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"addContextMenuItems", paras));
    }

    @Override
    public void addContextMenuItems(List<MenuItem> menuItems, ContextMenuWorkArea contextMenuWorkArea) {
        if (menuItems != null && menuItems.size() > 0) {
            HashMap<String, Object> paras = new HashMap<String, Object>();
            paras.put("callback", "invokeAction");
            ArrayList items = new ArrayList(menuItems.size());
            paras.put("items", items);
            for (MenuItem menuItem : menuItems) {
                HashMap<String, Object> items_map = new HashMap<String, Object>(menuItems.size());
                items_map.put("name", menuItem.getName());
                items_map.put("text", menuItem.getText());
                if (contextMenuWorkArea != null) {
                    items_map.put("workArea", contextMenuWorkArea.getList());
                }
                if (menuItem.getSubMenuItems() != null && !menuItem.getSubMenuItems().isEmpty()) {
                    ArrayList subMenus = new ArrayList(menuItem.getSubMenuItems().size());
                    for (MenuItem subMenuItem : menuItem.getSubMenuItems()) {
                        HashMap<String, Object> subMenuProp = new HashMap<String, Object>(2);
                        subMenuProp.put("name", subMenuItem.getName());
                        subMenuProp.put("text", subMenuItem.getText());
                        subMenus.add(subMenuProp);
                    }
                    items_map.put("subMenu", subMenus);
                }
                items.add(items_map);
            }
            this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"addContextMenuItems", paras));
        }
    }

    @Override
    public void hideShowContextMenuItems(List<MenuItem> hideItems, List<MenuItem> showItems) {
        HashMap<String, Object> paramMap;
        ArrayList paraslist = new ArrayList();
        if (showItems != null && showItems.size() > 0) {
            for (MenuItem menuItem : showItems) {
                if (menuItem == null) continue;
                paramMap = new HashMap<String, Integer>(2);
                paramMap.put("isHide", 0);
                paramMap.put("name", menuItem.getName());
                paraslist.add(paramMap);
                if (menuItem.getSubMenuItems() == null) continue;
                for (MenuItem subItem : menuItem.getSubMenuItems()) {
                    HashMap<String, Object> paramMap2 = new HashMap<String, Object>(2);
                    paramMap2.put("isHide", 0);
                    paramMap2.put("name", menuItem.getName());
                    paramMap2.put("subMenu", subItem.getName());
                    paraslist.add(paramMap2);
                }
            }
        }
        if (hideItems != null && hideItems.size() > 0) {
            for (MenuItem menuItem : hideItems) {
                if (menuItem == null) continue;
                if (menuItem.getSubMenuItems() != null) {
                    for (MenuItem subItem : menuItem.getSubMenuItems()) {
                        HashMap<String, Object> paramMap2 = new HashMap<String, Object>(2);
                        paramMap2.put("isHide", 1);
                        paramMap2.put("name", menuItem.getName());
                        paramMap2.put("subMenu", subItem.getName());
                        paraslist.add(paramMap2);
                    }
                    continue;
                }
                paramMap = new HashMap<String, Object>(2);
                paramMap.put("isHide", 1);
                paramMap.put("name", menuItem.getName());
                paraslist.add(paramMap);
            }
        }
        if (paraslist.size() > 0) {
            this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)SpreadProperties.HideContextMenuItemsMethod.HIDECONTEXTMENUITEMS.k(), paraslist));
        }
    }

    @Override
    public void insertRowsBelow(List<Integer> rowindexs, boolean copyStyle) {
        if (rowindexs != null && rowindexs.size() > 0) {
            HashMap<String, Object> parasmap = new HashMap<String, Object>();
            parasmap.put("copyStyle", copyStyle);
            parasmap.put("status", "true");
            parasmap.put("data", rowindexs);
            parasmap.put("dir", "bottom");
            this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"insertRow", parasmap));
        }
    }

    public void insertColsAfter(List<Integer> colindexs, boolean copyStyle) {
        if (colindexs != null && colindexs.size() > 0) {
            HashMap<String, Object> parasmap = new HashMap<String, Object>();
            parasmap.put("copyStyle", copyStyle);
            parasmap.put("status", "true");
            parasmap.put("data", colindexs);
            parasmap.put("dir", "after");
            this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"insertCol", parasmap));
        }
    }

    @Override
    public void insertRowsBelow(int rowIndex, int count, boolean copyStyle) {
        if (count > 0) {
            ArrayList<Integer> rowindexs = new ArrayList<Integer>(count);
            for (int i = 0; i < count; ++i) {
                rowindexs.add(i + rowIndex);
            }
            this.insertRowsBelow(rowindexs, copyStyle);
        }
    }

    @Override
    public void insertColsAfter(int colIndex, int count, boolean copyStyle) {
        if (count > 0) {
            ArrayList<Integer> colindexs = new ArrayList<Integer>(count);
            for (int i = 0; i < count; ++i) {
                colindexs.add(i + colIndex);
            }
            this.insertColsAfter(colindexs, copyStyle);
        }
    }

    @Override
    public void setRowsVisible(List<Integer> rowindexs, boolean isVisible) {
        if (rowindexs == null || rowindexs.size() == 0) {
            return;
        }
        HashMap<String, Object> parasmap = new HashMap<String, Object>();
        parasmap.put("rows", rowindexs);
        parasmap.put("value", isVisible);
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"setRowsVisible", parasmap));
    }

    @Override
    public void setColumnsVisible(List<Integer> colindexs, boolean isVisible) {
        if (colindexs == null || colindexs.size() == 0) {
            return;
        }
        HashMap<String, Object> parasmap = new HashMap<String, Object>();
        parasmap.put("cols", colindexs);
        parasmap.put("value", isVisible);
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"setColumnsVisible", parasmap));
    }

    @Override
    public void setFListCells(List<ECell> cells, boolean fuzzyQuery, boolean combobox, boolean showAddBtnWhenNoData, boolean lockClickable) {
        ArrayList celllist = new ArrayList(cells.size());
        for (ECell cell : cells) {
            HashMap<String, Integer> cellmap = new HashMap<String, Integer>();
            cellmap.put("r", cell.getRow());
            cellmap.put("c", cell.getCol());
            celllist.add(cellmap);
        }
        LinkedHashMap<String, Serializable> parasmap = new LinkedHashMap<String, Serializable>();
        parasmap.put("cell", celllist);
        parasmap.put("selectType", Integer.valueOf(fuzzyQuery ? 0 : 1));
        parasmap.put("dst", Integer.valueOf(combobox ? 1 : 0));
        parasmap.put("showAddBtnWhenNoData", Boolean.valueOf(showAddBtnWhenNoData));
        parasmap.put("lockClickable", Boolean.valueOf(lockClickable));
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)SpreadProperties.SetF7TypeCellMethod.SETF7TYPECELL.k(), parasmap));
    }

    @Override
    public void setFListCellArea(List<CellArea> cellAreas, boolean fuzzyQuery, boolean combobox, boolean showAddBtnWhenNoData, boolean lockClickable) {
        LinkedHashMap<String, Object> parasmap = new LinkedHashMap<String, Object>();
        parasmap.put("cell", cellAreas);
        parasmap.put("selectType", fuzzyQuery ? 0 : 1);
        parasmap.put("dst", combobox ? 1 : 0);
        parasmap.put("showAddBtnWhenNoData", showAddBtnWhenNoData);
        parasmap.put("lockClickable", lockClickable);
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)SpreadProperties.SetF7TypeCellMethod.SETF7TYPECELL.k(), parasmap));
    }

    @Override
    public void setGroupColNode(Collection<CellGroupNodeInfo> cellGroupNodeInfos) {
        if (cellGroupNodeInfos != null && !cellGroupNodeInfos.isEmpty()) {
            LinkedList<Map<String, Object>> parameters = new LinkedList<Map<String, Object>>();
            for (CellGroupNodeInfo info : cellGroupNodeInfos) {
                if (info == null) continue;
                parameters.add(info.toValueMap());
            }
            this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"setGroupColNode", parameters));
        }
    }

    public void setGroupColNode(List<CellGroupNodeInfo> cellGroupNodeInfos) {
        if (cellGroupNodeInfos != null && !cellGroupNodeInfos.isEmpty()) {
            LinkedList<Map<String, Object>> parameters = new LinkedList<Map<String, Object>>();
            for (CellGroupNodeInfo info : cellGroupNodeInfos) {
                if (info == null) continue;
                parameters.add(info.toValueMap());
            }
            this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"setGroupColNode", parameters));
        }
    }

    public void setConditionalFormatting(ConditionFormatParameter conditionFormatParameter) {
        if (conditionFormatParameter.getRanges() == null || conditionFormatParameter.getRanges().size() == 0) {
            return;
        }
        HashMap<String, Object> param = new HashMap<String, Object>(4);
        param.put("ranges", conditionFormatParameter.getRanges());
        param.put("si", conditionFormatParameter.getSi());
        param.put("methodName", conditionFormatParameter.getMethodName());
        param.put("parameters", conditionFormatParameter.getParameters());
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"setConditionalFormatting", param));
    }

    @Override
    public void setStatusBarVisible(Boolean visible) {
        this.cmdList.add((Map<String, Object>)ImmutableMap.of((Object)"setStatusBarVisible", (Object)visible));
    }
}

