/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.control;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import com.grapecity.documents.excel.SaveFileFormat;
import com.grapecity.documents.excel.Workbook;
import java.awt.Color;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.nio.charset.StandardCharsets;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.report.excel.ExportExceptionHelper;
import kd.epm.eb.common.spread.util.GZIPUtils;
import kd.epm.eb.spread.command.rangedefined.ButtonCell;
import kd.epm.eb.spread.command.rangedefined.CellArea;
import kd.epm.eb.spread.command.rangedefined.ComboboxCell;
import kd.epm.eb.spread.command.rangedefined.ContextMenuItemsEnum;
import kd.epm.eb.spread.command.rangedefined.CustomFormula;
import kd.epm.eb.spread.command.rangedefined.FormulaCell;
import kd.epm.eb.spread.command.rangedefined.RedPointCell;
import kd.epm.eb.spread.command.rangedefined.SheetFrozenInfo;
import kd.epm.eb.spread.command.rangedefined.Shortcut;
import kd.epm.eb.spread.command.rangedefined.ToolBarItemsEnum;
import kd.epm.eb.spread.command.rangedefined.WorkbookOptions;
import kd.epm.eb.spread.command.style.AreasStyle;
import kd.epm.eb.spread.command.style.CellGroupNodeInfo;
import kd.epm.eb.spread.command.style.CellStyleInfo;
import kd.epm.eb.spread.command.style.ContextMenuWorkArea;
import kd.epm.eb.spread.control.ISpreadContainer;
import kd.epm.eb.spread.model.MenuItem;
import kd.epm.eb.spread.report.excel.helper.POIHelper;
import kd.epm.eb.spread.report.excel.helper.TemplateHelper;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import kd.epm.eb.spread.utils.SpreadDisposeUtils;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.formula.FormulaParser;
import org.apache.poi.ss.formula.FormulaParsingWorkbook;
import org.apache.poi.ss.formula.FormulaType;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.ClientAnchor;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.WorkbookFactory;
import org.apache.poi.xssf.usermodel.DefaultIndexedColorMap;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFClientAnchor;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFComment;
import org.apache.poi.xssf.usermodel.XSSFDataFormat;
import org.apache.poi.xssf.usermodel.XSSFDrawing;
import org.apache.poi.xssf.usermodel.XSSFEvaluationWorkbook;
import org.apache.poi.xssf.usermodel.XSSFFont;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class POISpreadContainer
implements ISpreadContainer {
    protected XSSFWorkbook workbook;
    protected String fileName;
    protected String sheetName;
    protected boolean isRebuild = true;
    protected boolean hasRebuild = false;
    protected LinkedHashMap<String, Object> baseJsonMap = null;
    protected LinkedHashMap<String, Object> operateMaps = new LinkedHashMap(16);
    protected static final Log log = LogFactory.getLog(POISpreadContainer.class);
    protected final TemplateHelper templateHelper = new TemplateHelper();
    private Map<String, String> formulaCellsMap = new LinkedHashMap<String, String>(16);
    private Long exportLogId;
    private Map<Integer, Set<Integer>> lockCells = new HashMap<Integer, Set<Integer>>(16);
    private boolean isImportData = false;
    private boolean hasSetTabVisible = false;
    private Map<String, XSSFCellStyle> newCellStyleMap = new HashMap<String, XSSFCellStyle>(16);
    private POIHelper poiHelper;
    private Map<Integer, Set<Integer>> enumRowColMap = null;
    private List<Object> currentCellEnumItems = new ArrayList<Object>(16);
    private XSSFSheet sheet = null;

    public Map<String, String> getFormulaCellsMap() {
        return this.formulaCellsMap;
    }

    public Map<Integer, Set<Integer>> getLockCells() {
        return this.lockCells;
    }

    public boolean isImportData() {
        return this.isImportData;
    }

    public void setImportData(boolean importData) {
        this.isImportData = importData;
    }

    public POISpreadContainer() {
    }

    public void setHasRebuild(boolean hasRebuild) {
        this.hasRebuild = hasRebuild;
    }

    public POISpreadContainer(Long exportLogId, String fileName, boolean isRebuild) {
        this.exportLogId = exportLogId;
        this.fileName = fileName;
        this.isRebuild = isRebuild;
    }

    public POISpreadContainer(XSSFWorkbook workbook) {
        this.workbook = workbook;
    }

    public POISpreadContainer(XSSFWorkbook workbook, String fileName, String sheetName, Long exportLogId) {
        this.workbook = workbook;
        this.fileName = fileName;
        this.sheetName = sheetName;
        this.exportLogId = exportLogId;
    }

    public void setBaseJsonMap(LinkedHashMap<String, Object> baseJsonMap) {
        this.baseJsonMap = baseJsonMap;
    }

    public LinkedHashMap<String, Object> getOperateMaps() {
        return this.operateMaps;
    }

    @Override
    public void updateCellValue2(List<ECell> cells) {
        if (this.getSheet() == null) {
            return;
        }
        if (CollectionUtils.isEmpty(cells)) {
            return;
        }
        for (ECell c : cells) {
            Object value;
            Cell cell = this.getCell(c.getRow(), c.getCol());
            if (cell == null || (value = c.getValue()) == null) continue;
            if (value instanceof BigDecimal) {
                BigDecimal bigDecimal = new BigDecimal(String.valueOf(value));
                cell.setCellValue(bigDecimal.doubleValue());
                continue;
            }
            if (value instanceof Date) {
                cell.setCellValue(this.getDateFromStr(value));
                continue;
            }
            cell.setCellValue(this.getDateFromStr(value));
        }
    }

    @Override
    public void updateCellValue(List<Map<String, Object>> parameters) {
        if (this.getSheet() == null) {
            return;
        }
        if (CollectionUtils.isEmpty(parameters)) {
            return;
        }
        for (Map<String, Object> map : parameters) {
            Cell cell;
            if (map == null) continue;
            Integer r = (Integer)map.get("r");
            Integer c = (Integer)map.get("c");
            Object value = map.get("v");
            if (r == null || c == null || (cell = this.getCell(r, c)) == null || value == null) continue;
            if (value instanceof BigDecimal) {
                BigDecimal bigDecimal = new BigDecimal(String.valueOf(value));
                cell.setCellValue(bigDecimal.doubleValue());
                continue;
            }
            if (value instanceof Number) {
                cell.setCellValue(((Number)value).doubleValue());
                continue;
            }
            cell.setCellValue(this.getDateFromStr(value));
        }
    }

    private String getDateFromStr(Object value) {
        try {
            return new SimpleDateFormat("yyyy-MM-dd").format(POISpreadContainer.oaDateToDate(String.valueOf(value)));
        }
        catch (Exception exception) {
            return String.valueOf(value);
        }
    }

    public static Date oaDateToDate(String date) {
        if (date == null) {
            return null;
        }
        String oaData = POISpreadContainer.getOADate(date);
        BigDecimal time = new BigDecimal(oaData);
        time = time.multiply(new BigDecimal(86400000)).add(new BigDecimal("-2209190400000"));
        return new Date(time.longValue());
    }

    public static String getOADate(String date) {
        if (date == null) {
            return null;
        }
        String rgex = "(?<=\\/OADate\\().*?(?=\\)/)";
        Pattern pattern = Pattern.compile(rgex);
        Matcher matcher = pattern.matcher(date);
        String time = null;
        if (matcher.find()) {
            time = matcher.group();
        }
        return time;
    }

    @Override
    public void deleteRowCol(List<Integer> rowindexs, List<Integer> colindexs) {
        XSSFSheet sheet = this.getSheet();
        if (sheet == null) {
            return;
        }
        this.templateHelper.deleteRowCol(sheet, rowindexs, colindexs);
    }

    @Override
    public void deleteRowCol(int index, int count, boolean isRow) {
        ArrayList<Integer> rowindexs = null;
        ArrayList<Integer> colindexs = null;
        if (isRow) {
            rowindexs = new ArrayList<Integer>(16);
            for (int i = count; i > 0; --i) {
                rowindexs.add(index + i);
            }
        } else {
            colindexs = new ArrayList<Integer>(16);
            for (int i = count; i > 0; --i) {
                colindexs.add(index + i);
            }
        }
        this.deleteRowCol(rowindexs, colindexs);
    }

    @Override
    public void callbackAction(String plugin_methodname) {
    }

    @Override
    public void rebuildSpread(String json) {
        if (this.hasRebuild) {
            return;
        }
        ExportExceptionHelper.getInstance().judgeExportCancel(this.exportLogId);
        this.rebuildSpreadV1(json);
    }

    private void rebuildSpreadV1(String json) {
        if (json != null) {
            String jsonObj = json.startsWith("base64") ? new String(GZIPUtils.uncompress((byte[])Base64.getDecoder().decode(json.substring(6))), StandardCharsets.UTF_8) : json;
            if (!this.hasSetTabVisible) {
                this.baseJsonMap = (LinkedHashMap)JSON.parseObject((String)jsonObj, LinkedHashMap.class, (Feature[])new Feature[]{Feature.OrderedField});
                if (this.baseJsonMap == null) {
                    return;
                }
                if (this.baseJsonMap.containsKey("tabStripVisible")) {
                    this.baseJsonMap.put("tabStripVisible", Boolean.TRUE);
                }
                SpreadDisposeUtils.removeRowFilter(this.baseJsonMap);
                JSONObject result = new JSONObject(true);
                result.putAll(this.baseJsonMap);
                ExportExceptionHelper.getInstance().judgeExportCancel(this.exportLogId);
                jsonObj = result.toJSONString();
                this.hasSetTabVisible = true;
            }
            this.doGCExcelParseJsonToWorkBook(jsonObj);
            if (this.baseJsonMap != null) {
                this.baseJsonMap.clear();
            }
        }
    }

    public void initSheetFormulaCells() {
        this.formulaCellsMap.clear();
        XSSFSheet sheet = this.getSheet();
        if (sheet == null) {
            return;
        }
        XSSFEvaluationWorkbook fpb = POIHelper.getFpb(sheet.getWorkbook());
        for (Row row : sheet) {
            if (row == null) continue;
            for (Cell cell : row) {
                if (cell == null || cell.getCellType() != CellType.FORMULA || !StringUtils.isNotEmpty((CharSequence)cell.getCellFormula())) continue;
                try {
                    FormulaParser.parse((String)cell.getCellFormula(), (FormulaParsingWorkbook)fpb, (FormulaType)FormulaType.CELL, (int)0, (int)cell.getRowIndex());
                }
                catch (Exception e) {
                    log.error((Throwable)e);
                    cell.removeFormula();
                    continue;
                }
                this.formulaCellsMap.put(cell.getRowIndex() + ":" + cell.getColumnIndex(), cell.getCellFormula());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doGCExcelParseJsonToWorkBook(String json) {
        log.info("reportExport begin doGCExcelParseJsonToWorkBook.");
        log.info("sheetName:" + this.sheetName);
        ByteArrayOutputStream out = null;
        try {
            Workbook workbook_gc = new Workbook();
            workbook_gc.fromJson(json);
            out = new ByteArrayOutputStream();
            workbook_gc.save((OutputStream)out, SaveFileFormat.Xlsx);
            ExportExceptionHelper.getInstance().judgeExportCancel(this.exportLogId);
            try (ByteArrayInputStream inputStream = new ByteArrayInputStream(out.toByteArray());){
                this.workbook = (XSSFWorkbook)WorkbookFactory.create((InputStream)inputStream);
                log.info("reportExport doGCExcelParseJsonToWorkBook workbook sheetsize:" + this.workbook.getNumberOfSheets());
                this.initSheetFormulaCells();
                this.workbook.setSheetName(0, this.sheetName);
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw new KDBizException(e.getMessage());
            }
            ExportExceptionHelper.getInstance().judgeExportCancel(this.exportLogId);
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
            }
            catch (IOException e) {
                log.error((Throwable)e);
            }
        }
    }

    @Override
    public void appendRowCols(int rows, int cols) {
    }

    @Override
    public void insertRowCol(List<Integer> rowindexs, List<Integer> colindexs) {
    }

    @Override
    public void insertRowCol(List<Integer> rowindexs, List<Integer> colindexs, boolean copyStyle) {
    }

    @Override
    public void setColumnsWidth(List<Integer> colindexs, int width) {
        XSSFSheet sheet = this.getSheet();
        if (sheet == null) {
            return;
        }
        for (Integer colindex : colindexs) {
            sheet.setColumnWidth(colindex.intValue(), (2 + width / 8) * 256);
        }
    }

    @Override
    public void setRowsHeight(List<Integer> rowindexs, int height) {
        XSSFSheet sheet = this.getSheet();
        if (sheet == null) {
            return;
        }
        for (Integer rowindex : rowindexs) {
            XSSFRow row = sheet.getRow(rowindex.intValue());
            if (row == null) continue;
            row.setHeightInPoints((float)((short)height));
        }
    }

    @Override
    public void lockCells(List<CellArea> paras) {
        if (this.isImportData) {
            for (CellArea cellArea : paras) {
                int r = cellArea.getR();
                int rc = cellArea.getRc();
                int c = cellArea.getC();
                int cc = cellArea.getCc();
                for (int i = r; i < r + rc; ++i) {
                    Set integers = this.lockCells.computeIfAbsent(i, t -> new HashSet(16));
                    for (int i1 = c; i1 < c + cc; ++i1) {
                        integers.add(i1);
                    }
                }
            }
        }
    }

    @Override
    public void lockECells(List<ECell> paras) {
    }

    @Override
    public void unlockCells(List<CellArea> paras) {
    }

    @Override
    public void lockSheets(List<String> sheetnames) {
    }

    @Override
    public void unlockSheets(List<String> sheetnames) {
    }

    @Override
    public void setSpan(List<CellArea> areas) {
    }

    private void setStyle(CellStyleInfo style, XSSFCellStyle cellStyle) {
        Integer ti;
        String fm;
        String bkc;
        String frc = style.getFrc();
        if (StringUtils.isNotBlank((CharSequence)frc)) {
            int[] rgbColor = POIHelper.hexToRgb(frc);
            XSSFFont font = this.workbook.createFont();
            font.setColor(new XSSFColor(new Color(rgbColor[0], rgbColor[1], rgbColor[2]), (IndexedColorMap)new DefaultIndexedColorMap()));
            cellStyle.setFont((Font)font);
        }
        if (StringUtils.isNotBlank((CharSequence)(bkc = style.getBkc()))) {
            int[] rgbColor = POIHelper.hexToRgb(bkc);
            cellStyle.setFillForegroundColor(new XSSFColor(new Color(rgbColor[0], rgbColor[1], rgbColor[2]), (IndexedColorMap)new DefaultIndexedColorMap()));
            cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
        }
        if (StringUtils.isNotBlank((CharSequence)(fm = style.getFm()))) {
            XSSFDataFormat dataFormat = this.workbook.createDataFormat();
            short format = dataFormat.getFormat(fm);
            cellStyle.setDataFormat(format);
        }
        if ((ti = style.getTi()) != null) {
            cellStyle.setIndention((short)ti.intValue());
        }
        if (style.isWw() != null) {
            cellStyle.setWrapText(style.isWw().booleanValue());
        }
    }

    public void setNewCellStyleMap(Map<String, XSSFCellStyle> newCellStyleMap) {
        this.newCellStyleMap = newCellStyleMap;
    }

    @Override
    public void setCellStyle(List<AreasStyle> areasStyles) {
        if (this.getSheet() == null) {
            return;
        }
        if (CollectionUtils.isEmpty(areasStyles)) {
            return;
        }
        for (AreasStyle areasStyle : areasStyles) {
            List<CellArea> range = areasStyle.getRange();
            CellStyleInfo cellStyleInfo = areasStyle.getStyle();
            if (cellStyleInfo == null) continue;
            for (CellArea cellArea : range) {
                int rc = cellArea.getRc();
                int r = cellArea.getR();
                int c = cellArea.getC();
                int cc = cellArea.getCc();
                for (int rowIndex = r; rowIndex < r + rc; ++rowIndex) {
                    XSSFRow row = this.getSheet().getRow(rowIndex);
                    if (row == null) {
                        row = this.sheet.createRow(rowIndex);
                    }
                    for (int colIndex = c; colIndex < c + cc; ++colIndex) {
                        XSSFCellStyle style;
                        XSSFCell cell = row.getCell(colIndex);
                        if (cell == null) {
                            cell = row.createCell(colIndex);
                        }
                        if ((style = cell.getCellStyle()) == null) {
                            style = this.getWorkbook().createCellStyle();
                        }
                        int fontHashCode = style.getFont() == null ? 0 : style.getFont().hashCode();
                        String key = style.hashCode() + ":" + fontHashCode + ":" + cellStyleInfo.hashCode();
                        XSSFCellStyle cellStyle = this.newCellStyleMap.get(key);
                        if (cellStyle == null) {
                            cellStyle = this.getWorkbook().createCellStyle();
                            cellStyle.cloneStyleFrom((CellStyle)style);
                            this.setStyle(cellStyleInfo, cellStyle);
                            this.newCellStyleMap.put(key, cellStyle);
                        }
                        cell.setCellStyle((CellStyle)cellStyle);
                    }
                }
            }
        }
    }

    public POIHelper getPoiHelper() {
        if (this.poiHelper == null) {
            this.poiHelper = new POIHelper();
        }
        return this.poiHelper;
    }

    public void setPoiHelper(POIHelper poiHelper) {
        this.poiHelper = poiHelper;
    }

    @Override
    public void fieldInsertRowCol(CellArea range, int index, int count, int styleIndex, boolean isrow, boolean allowSize) {
        if (this.getSheet() == null) {
            return;
        }
        int startCol = range.getC();
        int colCount = range.getCc();
        int startRow = range.getR();
        int rowCount = range.getRc();
        if (isrow) {
            int i;
            XSSFRow styleRow = this.getSheet().getRow(styleIndex);
            for (i = startRow + rowCount - 1; i >= index; --i) {
                XSSFRow oldRow = this.getSheet().getRow(i);
                XSSFRow toRow = this.getSheet().getRow(i + count);
                if (oldRow == null) continue;
                if (toRow == null) {
                    this.getSheet().createRow(i + count);
                }
                this.getPoiHelper().copyRow(this.getSheet(), i, i + count, startCol, colCount, this.templateHelper.getStyles());
            }
            for (i = index; i < index + count; ++i) {
                XSSFRow newRow = this.getSheet().getRow(i);
                if (newRow == null) {
                    newRow = this.getSheet().createRow(i);
                }
                if (allowSize && styleRow != null) {
                    XSSFCellStyle rowStyle = styleRow.getRowStyle();
                    newRow.setRowStyle((CellStyle)rowStyle);
                }
                for (int j = startCol; j < startCol + colCount; ++j) {
                    XSSFCell cell1;
                    XSSFCell cell = newRow.getCell(j);
                    if (cell == null) {
                        cell = newRow.createCell(j);
                    }
                    if (styleRow == null || (cell1 = styleRow.getCell(j)) == null) continue;
                    cell.setCellStyle((CellStyle)cell1.getCellStyle());
                }
            }
        } else {
            for (int i = startRow; i < startRow + rowCount; ++i) {
                int j;
                XSSFRow row = this.getSheet().getRow(i);
                if (row == null) continue;
                for (j = startCol + colCount - 1; j >= index; --j) {
                    XSSFCell fromCell = row.getCell(j);
                    if (fromCell == null) continue;
                    XSSFCell toCell = row.getCell(j + count);
                    POIHelper.copyCell((org.apache.poi.ss.usermodel.Workbook)this.getWorkbook(), (Cell)fromCell, (Cell)toCell);
                }
                for (j = index; j < index + count; ++j) {
                    XSSFCell cell = row.getCell(j);
                    if (cell == null) {
                        cell = row.createCell(j);
                    }
                    XSSFCell cell1 = row.getCell(styleIndex);
                    if (!allowSize || cell1 == null) continue;
                    cell.setCellStyle((CellStyle)cell1.getCellStyle());
                }
            }
        }
    }

    @Override
    public void fieldInsertRowCol(CellArea range, int index, int count, int styleIndex, boolean isrow) {
        this.fieldInsertRowCol(range, index, count, styleIndex, isrow, true);
    }

    @Override
    public void fieldDeleteRowCol(CellArea range, int index, int count, boolean isrow) {
        XSSFSheet sheet = this.getSheet();
        if (sheet == null) {
            return;
        }
        this.templateHelper.setPoiHelper(this.getPoiHelper());
        this.templateHelper.fieldDeleteRowCol(sheet, range, index, count, isrow);
    }

    @Override
    public void setFListCells(List<ECell> cells, boolean fuzzyQuery, boolean combobox) {
        this.setFListCells(cells, fuzzyQuery, combobox, false);
    }

    public Map<Integer, Set<Integer>> getEnumRowColMap() {
        return this.enumRowColMap;
    }

    public void setEnumRowColMap(Map<Integer, Set<Integer>> enumRowColMap) {
        this.enumRowColMap = enumRowColMap;
    }

    public void setCurrentCellEnumItems(List<Object> currentCellEnumItems) {
        this.currentCellEnumItems = currentCellEnumItems;
    }

    @Override
    public void setFListCells(List<ECell> cells, boolean fuzzyQuery, boolean combobox, boolean quickAddNew) {
        if (combobox) {
            this.enumRowColMap = new HashMap<Integer, Set<Integer>>(16);
            for (ECell cell : cells) {
                Set rows = this.enumRowColMap.computeIfAbsent(cell.getCol(), t -> new HashSet(16));
                rows.add(cell.getRow());
            }
        }
    }

    @Override
    public void setFListCellArea(List<CellArea> cellAreas, boolean fuzzyQuery, boolean combobox) {
        this.setFListCellArea(cellAreas, fuzzyQuery, combobox, false, false);
    }

    @Override
    public void setComboCell(List<ComboboxCell> comboboxCells) {
    }

    @Override
    public void setBtnCell(List<ButtonCell> buttonCells) {
    }

    @Override
    public void setCustomBtnCell(List<ButtonCell> buttonCells) {
    }

    @Override
    public void setCellTag(List<RedPointCell> redPointCells) {
    }

    @Override
    public void clearRowCellTags3(int rowIndex, int count, int startCol, int endCol) {
    }

    @Override
    public void clearColCellTags3(int colIndex, int count, int startRow, int endRow) {
    }

    @Override
    public void resetCell(List<CellArea> areas) {
    }

    @Override
    public void getSpreadJson(String callBack_MethodName) {
    }

    @Override
    public void getRangeStyles(List<Object> area, String si, String callBack_MethodName) {
    }

    @Override
    public void getLockedCells(boolean compression, String si, String callBack_MethodName) {
    }

    public List<Object> getCurrentCellEnumItems() {
        return this.currentCellEnumItems;
    }

    @Override
    public void setLookupData(ECell cell, Object data) {
        if (data != null) {
            this.currentCellEnumItems = (List)data;
        }
    }

    @Override
    public void setCustomFormulaCell(List<ECell> cells) {
    }

    @Override
    public void setAllCustomFormulaCell() {
    }

    @Override
    public void registerCustomFormula(List<CustomFormula> customFormulas) {
    }

    @Override
    public void setFormula(List<FormulaCell> formulaCells) {
    }

    @Override
    public void setSelections(CellArea cellArea, boolean triggerSel) {
    }

    @Override
    public void setSelections(CellArea cellArea) {
    }

    @Override
    public void exportExcelFile(String fileName) {
    }

    @Override
    public void lockToolbarItems(List<ToolBarItemsEnum> lockItems, List<ToolBarItemsEnum> unlockItems) {
    }

    @Override
    public void hideContextMenuItems(List<ContextMenuItemsEnum> hideItems, List<ContextMenuItemsEnum> showItems) {
    }

    @Override
    public void hideContextMenuItemsByKey(List<String> hideItems, List<String> showItems) {
    }

    @Override
    public void addContextMenuItems(String callBackMethod, String title, ContextMenuWorkArea contextMenuWorkArea) {
    }

    @Override
    public void deleteContextMenuItems(String[] name) {
    }

    @Override
    public void setDisplayLeftText(String text) {
    }

    @Override
    public void setDisplayCenterText(String text) {
    }

    @Override
    public void clearCellsStyle(List<CellArea> cellAreas) {
    }

    @Override
    public void controlToolbarItems(List<ToolBarItemsEnum> needControl, List<ToolBarItemsEnum> notneedControl) {
    }

    @Override
    public void closeToolbar() {
    }

    @Override
    public void closeToolbar(Boolean showExpandBtnVisible) {
    }

    @Override
    public void setToolbarExpandBtnVisible(Boolean visible) {
    }

    @Override
    public void frozenSheet(SheetFrozenInfo frozenInfo) {
        XSSFSheet sheet = this.getSheet();
        if (sheet == null) {
            return;
        }
        Integer r = frozenInfo.getR();
        Integer c = frozenInfo.getC();
        Integer tr = frozenInfo.getTr();
        Integer tc = frozenInfo.getTc();
        if (tr == null || tc == null) {
            sheet.createFreezePane(c.intValue(), r.intValue());
        } else {
            sheet.createFreezePane(c.intValue(), r.intValue(), tr.intValue(), tc.intValue());
        }
    }

    @Override
    public void setRowsAutoFit(List<Integer> rows) {
    }

    @Override
    public void setColsAutoFit(List<Integer> cols) {
        XSSFSheet sheet = this.getSheet();
        if (sheet == null) {
            return;
        }
    }

    @Override
    public void setShortcutKey(Shortcut shortcut) {
    }

    @Override
    public void setWorkbookOptions(WorkbookOptions workbookOptions) {
    }

    @Override
    public void setDisplayContent(String status, String cellMsg, String convertStatus) {
    }

    @Override
    public void setDisplayContent(String attachement, String status, String cellMsg, String convertStatus, String unit) {
    }

    @Override
    public void getColumnsWidth(Integer[] cols, String callBackMethodName) {
    }

    @Override
    public void getColumnsWidth(List<Integer> cols, String callBackMethodName) {
    }

    @Override
    public void getRowsHeight(Integer[] rows, String callBackMethodName) {
    }

    @Override
    public void getRowsHeight(List<Integer> rows, String callBackMethodName) {
    }

    @Override
    public void setOutlineColumn(int col, Boolean showCheckBox, Integer maxLevel, boolean default_collapsed) {
    }

    @Override
    public void setOutlineColumn(int col, Boolean showCheckBox, Integer maxLevel, Map<Integer, Boolean> collapsedFlags) {
    }

    @Override
    public void getOutlineColumnNode(int si, String callbackMethod) {
    }

    @Override
    public void setVirtualMode(String callbackMethod, boolean isopen) {
    }

    @Override
    public void setVirtualMode(String callbackMethod, boolean isopen, Integer delay) {
    }

    @Override
    public void addSheets(int index, String name, int rc, int cc) {
    }

    @Override
    public void updateCellValueAddSheet(List<Map<String, Object>> parameters, int si) {
    }

    @Override
    public void setColumnsWidthAddSheet(Map<String, Object> parasmap) {
    }

    @Override
    public void appendRowColsAddSheet(int rows, int cols, int si) {
    }

    @Override
    public void setCol0rRowGroupbyOnesheet(int count, int index, int si, boolean isRow) {
    }

    @Override
    public void expandRowOrColOutlines(int maxlevels, boolean expand, int si, boolean isRow) {
    }

    @Override
    public void insertRowColAddSheet(List<Integer> rowindexs, List<Integer> colindexs, int si) {
    }

    @Override
    public void setCellStyleAddSheet(List<AreasStyle> areasStyles, int si) {
    }

    @Override
    public void setCellTags(List<Map<String, Object>> cellTags) {
    }

    @Override
    public void setComment(List<Map<String, Object>> data, int si) {
        XSSFSheet sheet = this.getSheet();
        if (sheet == null) {
            return;
        }
        XSSFDrawing drawingPatriarch = sheet.createDrawingPatriarch();
        XSSFClientAnchor xssfClientAnchor = new XSSFClientAnchor(si, si, si, si, 0, 0, 0, 0);
        for (Map<String, Object> datum : data) {
            XSSFCell cell;
            int r = Integer.parseInt("" + datum.get("r"));
            int c = Integer.parseInt("" + datum.get("c"));
            String v = datum.get("v") + "";
            XSSFRow row = sheet.getRow(r);
            if (row == null || (cell = row.getCell(c)) == null) continue;
            if (cell.getCellComment() != null) {
                cell.removeCellComment();
            }
            xssfClientAnchor.setCol1(c);
            xssfClientAnchor.setRow1(r);
            xssfClientAnchor.setCol2(c + 2);
            xssfClientAnchor.setRow2(r + 4);
            XSSFComment cellComment = drawingPatriarch.createCellComment((ClientAnchor)xssfClientAnchor);
            cellComment.setString(v);
            cell.setCellComment((Comment)cellComment);
        }
    }

    @Override
    public void addContextMenuItems(String callBackMethod, String title, List<Map<String, Object>> subMenus, ContextMenuWorkArea contextMenuWorkArea) {
    }

    @Override
    public void addContextMenuItems(List<MenuItem> menuItems, ContextMenuWorkArea contextMenuWorkArea) {
    }

    @Override
    public void hideShowContextMenuItems(List<MenuItem> hideItems, List<MenuItem> showItems) {
    }

    @Override
    public void insertRowsBelow(List<Integer> rowindexs, boolean copyStyle) {
        if (this.getSheet() == null) {
            return;
        }
        if (CollectionUtils.isEmpty(rowindexs)) {
            return;
        }
        ExportExceptionHelper.getInstance().judgeMaxExportFloatRowSize(rowindexs.size(), 100000);
        XSSFSheet sheet = this.getSheet();
        int startShiftRowIndex = rowindexs.get(0) + 1;
        int styleRowIndex = startShiftRowIndex - 1;
        int lastRowNo = sheet.getLastRowNum();
        if (lastRowNo < startShiftRowIndex) {
            lastRowNo = startShiftRowIndex + 1;
        }
        for (Integer rowIndex : rowindexs) {
            POIHelper.removeRowFormula((Sheet)sheet, rowIndex + 1);
        }
        POIHelper.shiftRows(startShiftRowIndex, lastRowNo, rowindexs.size(), (Sheet)sheet, this, Boolean.TRUE);
        Row styleRow = sheet.getRow(styleRowIndex);
        int i = 0;
        for (Integer rowIndex : rowindexs) {
            if (i++ % 1000 == 0) {
                ExportExceptionHelper.getInstance().judgeExportCancel(this.exportLogId);
            }
            Row row = sheet.createRow(rowIndex + 1);
            if (!copyStyle || styleRow == null) continue;
            POIHelper.copyRowStyle(row, styleRow);
        }
    }

    @Override
    public void insertRowsBelow(int rowIndex, int count, boolean copyStyle) {
        XSSFSheet sheet = this.getSheet();
        if (sheet == null) {
            return;
        }
        ++rowIndex;
        ExportExceptionHelper.getInstance().judgeMaxExportFloatRowSize(count, 100000);
        for (int i = 0; i < count; ++i) {
            POIHelper.removeRowFormula((Sheet)sheet, rowIndex + i);
        }
        Row styleRow = sheet.getRow(rowIndex - 1);
        int lastRowNo = sheet.getLastRowNum();
        if (lastRowNo < rowIndex) {
            lastRowNo = rowIndex + 1;
        }
        POIHelper.shiftRows(rowIndex, lastRowNo, count, (Sheet)sheet, this, Boolean.TRUE);
        for (int i = 0; i < count; ++i) {
            if (i % 1000 == 0) {
                ExportExceptionHelper.getInstance().judgeExportCancel(this.exportLogId);
            }
            Row row = sheet.createRow(rowIndex++);
            if (!copyStyle || styleRow == null) continue;
            POIHelper.copyRowStyle(row, styleRow);
        }
    }

    @Override
    public void insertColsAfter(int colIndex, int count, boolean copyStyle) {
    }

    @Override
    public void setRowsVisible(List<Integer> rowindexs, boolean isVisible) {
        XSSFSheet sheet = this.getSheet();
        if (sheet == null) {
            return;
        }
        if (!isVisible) {
            for (Integer rowindex : rowindexs) {
                XSSFRow row = sheet.getRow(rowindex.intValue());
                if (row == null) continue;
                for (int i = row.getFirstCellNum(); i <= row.getLastCellNum(); ++i) {
                    XSSFCell cell;
                    if (i < 0 || (cell = row.getCell(i)) == null) continue;
                    XSSFCell emptyCell = row.createCell(cell.getColumnIndex());
                    emptyCell.setCellType(cell.getCellType());
                    emptyCell.setCellStyle((CellStyle)cell.getCellStyle());
                }
                row.setHeightInPoints(0.0f);
            }
        }
    }

    @Override
    public void setColumnsVisible(List<Integer> colindexs, boolean isVisible) {
        XSSFSheet sheet = this.getSheet();
        if (sheet == null) {
            return;
        }
        if (!isVisible) {
            for (Integer colindex : colindexs) {
                sheet.setColumnHidden(colindex.intValue(), true);
            }
            for (int i = sheet.getFirstRowNum(); i <= sheet.getLastRowNum(); ++i) {
                XSSFRow row = sheet.getRow(i);
                if (row == null) continue;
                for (Integer colindex : colindexs) {
                    XSSFCell cell;
                    if (colindex < 0 || (cell = row.getCell(colindex.intValue())) == null) continue;
                    XSSFCell emptyCell = row.createCell(colindex.intValue());
                    emptyCell.setCellType(cell.getCellType());
                    emptyCell.setCellStyle((CellStyle)cell.getCellStyle());
                }
            }
        }
    }

    @Override
    public void setFListCells(List<ECell> cells, boolean fuzzyQuery, boolean combobox, boolean showAddBtnWhenNoData, boolean lockClickable) {
        this.setFListCells(cells, fuzzyQuery, combobox, false);
    }

    @Override
    public void setFListCellArea(List<CellArea> cellAreas, boolean fuzzyQuery, boolean combobox, boolean showAddBtnWhenNoData, boolean lockClickable) {
        if (combobox && CollectionUtils.isNotEmpty(cellAreas)) {
            this.enumRowColMap = new HashMap<Integer, Set<Integer>>(16);
            for (CellArea cellArea : cellAreas) {
                int c = cellArea.getC();
                int cc = cellArea.getCc();
                int r = cellArea.getR();
                int rc = cellArea.getRc();
                for (int i = r; i < r + rc; ++i) {
                    for (int j = c; j < c + cc; ++j) {
                        Set rows = this.enumRowColMap.computeIfAbsent(j, t -> new HashSet(16));
                        rows.add(i);
                    }
                }
            }
        }
    }

    @Override
    public void setGroupColNode(Collection<CellGroupNodeInfo> cellGroupNodeInfos) {
    }

    @Override
    public void setStatusBarVisible(Boolean visible) {
    }

    protected Cell getCell(int row, int col) {
        return this.getCell(row, col, true);
    }

    protected Cell getCell(int row, int col, boolean createIfNotExist) {
        Cell cell = null;
        XSSFSheet sheet = this.getSheet();
        if (sheet == null) {
            return cell;
        }
        XSSFRow r = sheet.getRow(row);
        if (r == null && createIfNotExist) {
            r = sheet.createRow(row);
        }
        if (r != null && (cell = r.getCell(col)) == null && createIfNotExist) {
            cell = r.createCell(col);
        }
        return cell;
    }

    public XSSFSheet getSheet() {
        if (this.sheet == null) {
            if (StringUtils.isNotEmpty((CharSequence)this.sheetName)) {
                this.sheet = this.getSheet(this.sheetName);
            }
            if (this.sheet == null) {
                this.sheet = this.getSheet(0);
            }
        }
        return this.sheet;
    }

    private XSSFSheet getSheet(int index) {
        if (this.sheet == null) {
            if (this.getWorkbook() == null || this.getWorkbook().getNumberOfSheets() == 0) {
                return this.sheet;
            }
            this.sheet = this.getWorkbook().getSheetAt(index);
        }
        return this.sheet;
    }

    private XSSFSheet getSheet(String sheetName) {
        if (this.sheet == null) {
            this.sheet = this.getWorkbook().getSheet(sheetName);
        }
        return this.sheet;
    }

    public void setCurrentSheet(String sheetName) {
        this.sheet = this.getWorkbook().getSheet(sheetName);
        this.sheetName = sheetName;
    }

    public XSSFWorkbook getWorkbook() {
        return this.getWorkbook(true);
    }

    public void setWorkbook(XSSFWorkbook workbook) {
        this.workbook = workbook;
    }

    public XSSFWorkbook getWorkbook(boolean createIfNotExist) {
        if (this.workbook == null && createIfNotExist) {
            this.workbook = new XSSFWorkbook();
        }
        return this.workbook;
    }
}

