/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.domain.view;

import java.io.Serializable;
import kd.epm.eb.common.utils.ExcelUtils;
import kd.epm.eb.common.utils.ToStringHelper;

public class SpreadSelector
implements Serializable {
    private static final long serialVersionUID = 1L;
    private int startRow = -1;
    private int startCol = -1;
    private int endRow = -1;
    private int endCol = -1;

    public SpreadSelector(int startRow, int startCol, int endRow, int endCol) {
        this.startRow = startRow < 0 ? 0 : startRow;
        this.startCol = startCol < 0 ? 0 : startCol;
        this.endRow = endRow < 0 ? 0 : endRow;
        this.endCol = endCol < 0 ? 0 : endCol;
    }

    public int getStartRow() {
        return this.startRow;
    }

    public int getStartCol() {
        return this.startCol;
    }

    public int getEndRow() {
        return this.endRow;
    }

    public int getEndCol() {
        return this.endCol;
    }

    public boolean isMultiSelectCells() {
        return this.startRow != this.endRow || this.startCol != this.endCol;
    }

    public String getRangePosition() {
        return this.getStartPosition() + ":" + this.getEndPosition();
    }

    public String getEndPosition() {
        return ExcelUtils.xy2Pos((int)this.endCol, (int)this.endRow);
    }

    public String getStartPosition() {
        return ExcelUtils.xy2Pos((int)this.startCol, (int)this.startRow);
    }

    public String getRect() {
        return this.getStartPosition() + ":" + this.getEndPosition();
    }

    public String toString() {
        return ToStringHelper.deepToString((Object)this);
    }
}

