/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.fix;

import com.fasterxml.jackson.core.JacksonException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.epm.eb.common.dimension.property.PropertyMemObj;
import kd.epm.eb.common.dimension.property.PropertyObj;
import kd.epm.eb.spread.fix.FloatPasteInfo;

public class FloatPasteInfoDeserialize
extends JsonDeserializer<FloatPasteInfo> {
    public FloatPasteInfo deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JacksonException {
        FloatPasteInfo pasteInfo = new FloatPasteInfo();
        JsonNode jsonNode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        this.parseBaseInfo(pasteInfo, jsonNode);
        pasteInfo.getDimPropertys().addAll(this.parseDimPropertys(jsonNode.get("dimPropertys")));
        return pasteInfo;
    }

    private List<PropertyObj> parseDimPropertys(JsonNode jsonNode) {
        ArrayList<PropertyObj> propertyObjs = new ArrayList<PropertyObj>(10);
        if (jsonNode != null) {
            Iterator jsonNodeIterator = jsonNode.elements();
            while (jsonNodeIterator.hasNext()) {
                JsonNode node = (JsonNode)jsonNodeIterator.next();
                if (node == null) continue;
                Long id = node.get("id").asLong();
                String name = node.get("name") == null ? "" : node.get("name").asText();
                String number = node.get("number").asText();
                PropertyObj propertyObj = new PropertyObj(id, name, number);
                propertyObj.getPropertyValueEntries().addAll(this.parsePropertyMemObj(node.get("propertyValueEntries")));
                propertyObjs.add(propertyObj);
            }
        }
        return propertyObjs;
    }

    private List<PropertyMemObj> parsePropertyMemObj(JsonNode jsonNode) {
        ArrayList<PropertyMemObj> propertyMemObjs = new ArrayList<PropertyMemObj>(10);
        if (jsonNode != null) {
            Iterator jsonNodeIterator = jsonNode.elements();
            while (jsonNodeIterator.hasNext()) {
                JsonNode node = (JsonNode)jsonNodeIterator.next();
                if (node == null) continue;
                Long id = node.get("id").asLong();
                String name = node.get("name") == null ? "" : node.get("name").asText();
                String number = node.get("number") == null ? "" : node.get("number").asText();
                PropertyMemObj propertyMemObj = new PropertyMemObj(id, name, number, 10);
                propertyMemObjs.add(propertyMemObj);
            }
        }
        return propertyMemObjs;
    }

    private void parseBaseInfo(FloatPasteInfo pasteInfo, JsonNode jsonNode) {
        pasteInfo.setPosition(jsonNode.get("position").asText());
        pasteInfo.setPasteValue(jsonNode.get("pasteValue").asText());
        pasteInfo.setCheckResult(jsonNode.get("checkResult").asInt());
        pasteInfo.setDeal(jsonNode.get("deal").asInt());
        pasteInfo.setDimNumber(jsonNode.get("dimNumber").asText());
        pasteInfo.setNumber(jsonNode.get("number") == null ? "" : jsonNode.get("number").asText());
        pasteInfo.setName(jsonNode.get("name") == null ? "" : jsonNode.get("name").asText());
        pasteInfo.setParentNumber(jsonNode.get("parentNumber") == null ? "" : jsonNode.get("parentNumber").asText());
        pasteInfo.setViewId(jsonNode.get("viewId").asLong());
        pasteInfo.setSelectedId(jsonNode.get("selectedId") == null ? 0L : jsonNode.get("selectedId").asLong());
        pasteInfo.setAreaIndex(jsonNode.get("areaIndex").asText());
        pasteInfo.setQuickAddNew(jsonNode.get("quickAddNew") != null && jsonNode.get("quickAddNew").asBoolean());
    }
}

