/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.fix;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import kd.epm.eb.common.dimension.property.PropertyMemObj;
import kd.epm.eb.common.dimension.property.PropertyObj;
import kd.epm.eb.spread.fix.FloatPasteInfo;

public class FloatPasteInfoSerializer
extends JsonSerializer<FloatPasteInfo> {
    private JsonGenerator jsonGenerator;

    public void serialize(FloatPasteInfo floatPasteInfo, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException {
        this.jsonGenerator = jsonGenerator;
        jsonGenerator.writeStartObject();
        this.writeBaseInfo(floatPasteInfo);
        this.writeDimProrpertys(floatPasteInfo.getDimPropertys());
        this.writeDefaultProp(floatPasteInfo.getDefaultProp());
        jsonGenerator.writeEndObject();
    }

    private void writeDefaultProp(Map<String, Map<String, String>> defaultProp) throws IOException {
        if (defaultProp != null && defaultProp.size() > 0) {
            this.jsonGenerator.writeObjectFieldStart("defaultProp");
            for (Map.Entry<String, Map<String, String>> stringMapEntry : defaultProp.entrySet()) {
                this.jsonGenerator.writeObjectFieldStart(stringMapEntry.getKey());
                Map<String, String> value = stringMapEntry.getValue();
                if (value != null && value.size() > 0) {
                    for (Map.Entry<String, String> entry : value.entrySet()) {
                        this.jsonGenerator.writeStringField(entry.getKey(), entry.getValue());
                    }
                }
                this.jsonGenerator.writeEndObject();
            }
            this.jsonGenerator.writeEndObject();
        }
    }

    private void writeDimProrpertys(List<PropertyObj> dimPropertys) throws IOException {
        if (dimPropertys != null && dimPropertys.size() > 0) {
            this.jsonGenerator.writeArrayFieldStart("dimPropertys");
            for (PropertyObj dimProperty : dimPropertys) {
                this.jsonGenerator.writeStartObject();
                if (dimProperty.getId() != null) {
                    this.jsonGenerator.writeNumberField("id", dimProperty.getId().longValue());
                }
                this.jsonGenerator.writeStringField("name", dimProperty.getName());
                this.jsonGenerator.writeStringField("number", dimProperty.getNumber());
                this.jsonGenerator.writeNumberField("desq", dimProperty.getDseq());
                this.jsonGenerator.writeBooleanField("addMustInput", dimProperty.isAddMustInput());
                this.writePropertyValue(dimProperty.getPropertyValueEntries());
                this.jsonGenerator.writeEndObject();
            }
            this.jsonGenerator.writeEndArray();
        }
    }

    private void writePropertyValue(List<PropertyMemObj> propertyValueEntries) throws IOException {
        if (propertyValueEntries != null && propertyValueEntries.size() > 0) {
            this.jsonGenerator.writeArrayFieldStart("propertyValueEntries");
            for (PropertyMemObj propertyValueEntry : propertyValueEntries) {
                this.jsonGenerator.writeStartObject();
                if (propertyValueEntry.getId() != null) {
                    this.jsonGenerator.writeNumberField("id", propertyValueEntry.getId().longValue());
                }
                this.jsonGenerator.writeStringField("name", propertyValueEntry.getName());
                this.jsonGenerator.writeStringField("number", propertyValueEntry.getNumber());
                this.jsonGenerator.writeNumberField("scope", propertyValueEntry.getScope());
                this.jsonGenerator.writeNumberField("desq", propertyValueEntry.getDseq());
                this.jsonGenerator.writeEndObject();
            }
            this.jsonGenerator.writeEndArray();
        }
    }

    private void writeBaseInfo(FloatPasteInfo floatPasteInfo) throws IOException {
        this.jsonGenerator.writeStringField("position", floatPasteInfo.getPosition());
        this.jsonGenerator.writeStringField("pasteValue", floatPasteInfo.getPasteValue());
        this.jsonGenerator.writeNumberField("checkResult", floatPasteInfo.getCheckResult());
        this.jsonGenerator.writeNumberField("deal", floatPasteInfo.getDeal());
        this.jsonGenerator.writeStringField("dimNumber", floatPasteInfo.getDimNumber());
        this.jsonGenerator.writeStringField("number", floatPasteInfo.getNumber());
        this.jsonGenerator.writeStringField("name", floatPasteInfo.getName());
        this.jsonGenerator.writeStringField("parentNumber", floatPasteInfo.getParentNumber());
        if (floatPasteInfo.getViewId() != null) {
            this.jsonGenerator.writeNumberField("viewId", floatPasteInfo.getViewId().longValue());
        }
        if (floatPasteInfo.getSelectedId() != null) {
            this.jsonGenerator.writeNumberField("selectedId", floatPasteInfo.getSelectedId().longValue());
        }
        this.jsonGenerator.writeStringField("areaIndex", floatPasteInfo.getAreaIndex());
        this.jsonGenerator.writeBooleanField("quickAddNew", floatPasteInfo.isQuickAddNew());
    }
}

