/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.report.excel.helper;

import java.awt.Color;
import java.math.BigDecimal;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.utils.ConvertUtils;
import kd.epm.eb.spread.command.rangedefined.CellArea;
import kd.epm.eb.spread.control.POISpreadContainer;
import org.apache.commons.collections.CollectionUtils;
import org.apache.poi.ss.formula.FormulaParser;
import org.apache.poi.ss.formula.FormulaParsingWorkbook;
import org.apache.poi.ss.formula.FormulaRenderer;
import org.apache.poi.ss.formula.FormulaRenderingWorkbook;
import org.apache.poi.ss.formula.FormulaType;
import org.apache.poi.ss.formula.ptg.AreaPtg;
import org.apache.poi.ss.formula.ptg.Ptg;
import org.apache.poi.ss.formula.ptg.RefPtgBase;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellCopyPolicy;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CellType;
import org.apache.poi.ss.usermodel.Comment;
import org.apache.poi.ss.usermodel.DateUtil;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.Workbook;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressBase;
import org.apache.poi.ss.util.PaneInformation;
import org.apache.poi.xssf.usermodel.IndexedColorMap;
import org.apache.poi.xssf.usermodel.XSSFCell;
import org.apache.poi.xssf.usermodel.XSSFCellStyle;
import org.apache.poi.xssf.usermodel.XSSFColor;
import org.apache.poi.xssf.usermodel.XSSFEvaluationWorkbook;
import org.apache.poi.xssf.usermodel.XSSFRow;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.apache.poi.xssf.usermodel.XSSFWorkbook;

public class POIHelper {
    private static final Log log = LogFactory.getLog(POIHelper.class);

    public static void removeRowFormula(Sheet sheet, Integer rowIndex) {
        if (sheet == null || rowIndex == null) {
            return;
        }
        Row row = sheet.getRow(rowIndex.intValue());
        if (row == null) {
            return;
        }
        for (Cell cell : row) {
            if (cell == null || cell.getCellType() != CellType.FORMULA) continue;
            try {
                cell.removeFormula();
            }
            catch (IllegalStateException e) {
                log.error((Throwable)e);
                throw new KDBizException(ResManager.loadResFormat((String)"\u5355\u5143\u683c\u201c%1:%2\u201d\u4e0a\u7684\u516c\u5f0f\u5b58\u5728\u9519\u8bef\uff0c\u8bf7\u68c0\u67e5\u3002", (String)"POISpreadContainer_001", (String)"epm-eb-spread", (Object[])new Object[]{cell.getRow(), cell.getColumnIndex()}));
            }
        }
    }

    public static XSSFRow getRow(XSSFSheet xssfSheet, int rowIndex) {
        return xssfSheet.getRow(rowIndex);
    }

    public static void removeColumnCells(Sheet sheet, int column) {
        for (Row row : sheet) {
            Cell cell = row.getCell(column);
            if (cell == null) continue;
            row.removeCell(cell);
        }
    }

    public static void removeRowCells(Sheet sheet, int rowIndex) {
        Row row = sheet.getRow(rowIndex);
        if (row == null) {
            return;
        }
        int lastCellNum = row.getLastCellNum();
        if (lastCellNum == 0) {
            return;
        }
        for (int i = 0; i < lastCellNum; ++i) {
            Cell cell = row.getCell(i);
            if (cell == null) continue;
            row.removeCell(cell);
        }
    }

    public static void removeRowCellsInArea(Sheet sheet, int rowIndex, int startCol, int colCount) {
        Row row = sheet.getRow(rowIndex);
        if (row == null) {
            return;
        }
        int endCol = startCol + colCount;
        for (int i = startCol; i < endCol; ++i) {
            Cell cell = row.getCell(i);
            if (cell == null) continue;
            row.removeCell(cell);
        }
    }

    public static void copyRowStyle(Row createRow, Row styleRow) {
        if (createRow == null || styleRow == null) {
            return;
        }
        CellCopyPolicy cellCopyPolicy = new CellCopyPolicy();
        cellCopyPolicy.setCopyCellValue(false);
        ((XSSFSheet)createRow.getSheet()).copyRows(styleRow.getRowNum(), styleRow.getRowNum(), createRow.getRowNum(), cellCopyPolicy);
    }

    public static void removeColCellsInArea(Sheet sheet, int colIndex, int startRow, int rowCount) {
        int endRow = startRow + rowCount;
        for (int i = startRow; i < endRow; ++i) {
            Cell cell;
            Row row = sheet.getRow(i);
            if (row == null || (cell = row.getCell(colIndex)) == null) continue;
            row.removeCell(cell);
        }
    }

    public static int getLastFilledColumn(Sheet sheet) {
        short result = 0;
        for (Row row : sheet) {
            if (row.getLastCellNum() <= result) continue;
            result = row.getLastCellNum();
        }
        return result;
    }

    public static void setCellValue(XSSFSheet xssfSheet, int rowIndex, int colIndex, Object value) {
        if (value != null) {
            XSSFRow xssfSheetRow = xssfSheet.getRow(rowIndex);
            if (xssfSheetRow == null) {
                return;
            }
            XSSFCell cell = xssfSheetRow.getCell(colIndex);
            if (cell == null) {
                cell = xssfSheetRow.createCell(colIndex);
            }
            cell.setCellValue(value + "");
        }
    }

    public static XSSFColor createXssfColor(String color, IndexedColorMap indexedColorMap) {
        int[] rgbColor = POIHelper.hexToRgb(color);
        return new XSSFColor(new Color(rgbColor[0], rgbColor[1], rgbColor[2]), indexedColorMap);
    }

    public static int[] hexToRgb(String hex) {
        String colorStr = hex;
        if (hex.startsWith("#")) {
            colorStr = hex.substring(1);
        }
        if (org.apache.commons.lang3.StringUtils.length((CharSequence)colorStr) == 8) {
            colorStr = hex.substring(2);
        }
        int r = Integer.parseInt(colorStr.substring(0, 2), 16);
        int g = Integer.parseInt(colorStr.substring(2, 4), 16);
        int b = Integer.parseInt(colorStr.substring(4, 6), 16);
        return new int[]{r, g, b};
    }

    public static Set<String> getCellFormula(XSSFEvaluationWorkbook fpb, Cell cell) {
        Ptg[] ptgs;
        HashSet<String> result = new HashSet<String>(16);
        String cellFormula = cell.getCellFormula();
        int sheetIndex = cell.getSheet().getWorkbook().getSheetIndex(cell.getSheet());
        for (Ptg ptg : ptgs = FormulaParser.parse((String)cellFormula, (FormulaParsingWorkbook)fpb, (FormulaType)FormulaType.CELL, (int)sheetIndex, (int)cell.getRowIndex())) {
            RefPtgBase ref;
            if (ptg instanceof RefPtgBase) {
                ref = (RefPtgBase)ptg;
                result.add(ref.getRow() + ":" + ref.getColumn());
                continue;
            }
            if (!(ptg instanceof AreaPtg)) continue;
            ref = (AreaPtg)ptg;
            int firstRow = ref.getFirstRow();
            int lastRow = ref.getLastRow();
            int firstColumn = ref.getFirstColumn();
            int lastColumn = ref.getLastColumn();
            result.add(firstRow + ":" + firstColumn);
            result.add(lastRow + ":" + lastColumn);
        }
        return result;
    }

    private static void updateFormulaPtg(Cell cell, Cell shiftCell, int shiftCount, boolean isRow) {
        String cellFormula = cell.getCellFormula();
        if (StringUtils.isBlank((String)cellFormula)) {
            return;
        }
        XSSFEvaluationWorkbook fpb = POIHelper.getFpb((XSSFWorkbook)cell.getSheet().getWorkbook());
        int rowIndex = cell.getRowIndex();
        Ptg[] basePtg = FormulaParser.parse((String)cellFormula, (FormulaParsingWorkbook)fpb, (FormulaType)FormulaType.CELL, (int)cell.getSheet().getWorkbook().getSheetIndex(cell.getSheet()), (int)rowIndex);
        Ptg[] ptgs = new Ptg[basePtg.length];
        for (int i = 0; i < basePtg.length; ++i) {
            ptgs[i] = basePtg[i].copy();
        }
        int shiftCellRowIndex = shiftCell.getRowIndex();
        int shiftCellColumnIndex = shiftCell.getColumnIndex();
        for (Ptg ptg : ptgs) {
            RefPtgBase ref;
            if (ptg instanceof RefPtgBase) {
                ref = (RefPtgBase)ptg;
                int column = ref.getColumn();
                int row = ref.getRow();
                if (column != shiftCellColumnIndex || row != shiftCellRowIndex) continue;
                if (isRow) {
                    ref.setRow(Math.max(0, ref.getRow() + shiftCount));
                    continue;
                }
                ref.setColumn(Math.max(0, ref.getColumn() + shiftCount));
                continue;
            }
            if (!(ptg instanceof AreaPtg)) continue;
            ref = (AreaPtg)ptg;
            int firstColumn = ref.getFirstColumn();
            int firstRow = ref.getFirstRow();
            int lastColumn = ref.getLastColumn();
            int lastRow = ref.getLastRow();
            if (firstColumn == shiftCellColumnIndex && firstRow == shiftCellRowIndex) {
                if (isRow) {
                    ref.setFirstRow(Math.max(0, ref.getFirstRow() + shiftCount));
                } else {
                    ref.setFirstColumn(Math.max(0, ref.getFirstColumn() + shiftCount));
                }
            }
            if (lastColumn != shiftCellColumnIndex || lastRow != shiftCellRowIndex) continue;
            if (isRow) {
                ref.setLastRow(Math.max(0, ref.getLastRow() + shiftCount));
                continue;
            }
            ref.setLastColumn(Math.max(0, ref.getLastColumn() + shiftCount));
        }
        String shiftedFormula = FormulaRenderer.toFormulaString((FormulaRenderingWorkbook)fpb, (Ptg[])ptgs);
        POIHelper.updateCtCellFormulaValue((XSSFCell)cell, shiftedFormula);
    }

    private static void copyCtCellFormulaValue(XSSFCell fromCell, XSSFCell toCell) {
        POIHelper.updateCtCellFormulaValue(toCell, fromCell.getCellFormula());
    }

    private static void updateCtCellFormulaValue(XSSFCell cell, String shiftedFormula) {
        if (shiftedFormula != null) {
            try {
                cell.removeFormula();
                cell.setCellFormula(shiftedFormula);
            }
            catch (Exception e) {
                log.error((Throwable)e);
            }
        }
    }

    public static void shiftRows(Integer startShiftRowIndex, Integer endShiftRowIndex, Integer shiftCount, Sheet sheet, POISpreadContainer poiSpreadContainer, Boolean resetFormulaCell) {
        if (poiSpreadContainer == null || sheet == null || startShiftRowIndex == null || endShiftRowIndex == null || shiftCount == null) {
            return;
        }
        List mergedRegions = sheet.getMergedRegions();
        ArrayList<CellRangeAddress> newMergedRegions = new ArrayList<CellRangeAddress>(16);
        HashSet<Integer> deleteIndex = new HashSet<Integer>(16);
        for (int i = 0; i < mergedRegions.size(); ++i) {
            CellRangeAddress cellAddresses = (CellRangeAddress)mergedRegions.get(i);
            if (cellAddresses.getFirstColumn() == cellAddresses.getLastColumn() && cellAddresses.getFirstRow() == cellAddresses.getLastRow() || startShiftRowIndex <= cellAddresses.getFirstRow() || startShiftRowIndex > cellAddresses.getLastRow() + 1) continue;
            deleteIndex.add(i);
            cellAddresses.setLastRow(cellAddresses.getLastRow() + shiftCount);
            newMergedRegions.add(cellAddresses);
        }
        sheet.removeMergedRegions(deleteIndex);
        sheet.shiftRows(startShiftRowIndex.intValue(), endShiftRowIndex.intValue(), shiftCount.intValue());
        POIHelper.shiftRowsUpdateFormulaCell(sheet, startShiftRowIndex, shiftCount, poiSpreadContainer, resetFormulaCell);
        for (CellRangeAddress mergedRegion : newMergedRegions) {
            sheet.addMergedRegion(mergedRegion);
        }
    }

    public static void shiftRowsUpdateFormulaCell(Sheet sheet, Integer startShiftRowIndex, Integer shiftCount, POISpreadContainer poiSpreadContainer, Boolean resetFormulaCell) {
        Cell cell;
        Row row;
        int formulaColIndex;
        int formulaRowIndex;
        if (poiSpreadContainer == null || sheet == null || startShiftRowIndex == null || shiftCount == null) {
            return;
        }
        Map<String, String> formulaCellsMap = poiSpreadContainer.getFormulaCellsMap();
        if (formulaCellsMap == null || formulaCellsMap.size() == 0) {
            return;
        }
        XSSFEvaluationWorkbook fpb = POIHelper.getFpb((XSSFWorkbook)sheet.getWorkbook());
        FormulaEvaluator evaluator = sheet.getWorkbook().getCreationHelper().createFormulaEvaluator();
        int sheetIndex = sheet.getWorkbook().getSheetIndex(sheet);
        sheet.getLastRowNum();
        for (Map.Entry<String, String> entry : formulaCellsMap.entrySet()) {
            String rowAndColStr = entry.getKey();
            String formulaStr = entry.getValue();
            formulaRowIndex = Integer.parseInt(rowAndColStr.split(":")[0]);
            formulaColIndex = Integer.parseInt(rowAndColStr.split(":")[1]);
            if (startShiftRowIndex > formulaRowIndex || (row = sheet.getRow(formulaRowIndex + shiftCount)) == null || (cell = row.getCell(formulaColIndex)) == null) continue;
            Ptg[] basePtg = FormulaParser.parse((String)formulaStr, (FormulaParsingWorkbook)fpb, (FormulaType)FormulaType.CELL, (int)sheetIndex, (int)formulaRowIndex);
            Ptg[] ptgs = new Ptg[basePtg.length];
            for (int j = 0; j < basePtg.length; ++j) {
                ptgs[j] = basePtg[j].copy();
            }
            for (Ptg ptg : ptgs) {
                RefPtgBase ref;
                if (ptg instanceof RefPtgBase) {
                    ref = (RefPtgBase)ptg;
                    if (ref.getRow() < startShiftRowIndex) continue;
                    ref.setRow(ref.getRow() + shiftCount);
                    continue;
                }
                if (!(ptg instanceof AreaPtg)) continue;
                ref = (AreaPtg)ptg;
                if (ref.getFirstRow() >= startShiftRowIndex) {
                    ref.setFirstRow(ref.getFirstRow() + shiftCount);
                }
                if (ref.getLastRow() < startShiftRowIndex) continue;
                ref.setLastRow(ref.getLastRow() + shiftCount);
            }
            String shiftedFormula = FormulaRenderer.toFormulaString((FormulaRenderingWorkbook)fpb, (Ptg[])ptgs);
            cell.removeFormula();
            cell.setCellFormula(shiftedFormula);
            evaluator.evaluateFormulaCell(cell);
        }
        if (resetFormulaCell.booleanValue()) {
            LinkedHashMap<String, String> formulaCellsMapTemp = new LinkedHashMap<String, String>();
            for (Map.Entry<String, String> entry : formulaCellsMap.entrySet()) {
                String rowAndColStr = entry.getKey();
                formulaRowIndex = Integer.parseInt(rowAndColStr.split(":")[0]);
                formulaColIndex = Integer.parseInt(rowAndColStr.split(":")[1]);
                row = sheet.getRow(formulaRowIndex);
                if (startShiftRowIndex <= formulaRowIndex) {
                    row = sheet.getRow(formulaRowIndex + shiftCount);
                }
                if (row == null || (cell = row.getCell(formulaColIndex)) == null || cell.getCellType() != CellType.FORMULA || !org.apache.commons.lang3.StringUtils.isNotEmpty((CharSequence)cell.getCellFormula())) continue;
                formulaCellsMapTemp.put(cell.getRowIndex() + ":" + cell.getColumnIndex(), cell.getCellFormula());
            }
            if (formulaCellsMap.size() != formulaCellsMapTemp.size()) {
                log.error("shiftrows update formula has exception.");
                log.error("formulaCellsMap:" + SerializationUtils.toJsonString(formulaCellsMap));
                log.error("formulaCellsMapTemp:" + SerializationUtils.toJsonString(formulaCellsMapTemp));
            }
            formulaCellsMap.clear();
            formulaCellsMap.putAll(formulaCellsMapTemp);
        }
    }

    public static void shiftColumn(XSSFSheet sheet, int colIndex, int shiftCount) {
        int i;
        int lastFilledColumn = POIHelper.getLastFilledColumn((Sheet)sheet);
        if (lastFilledColumn <= colIndex + 1) {
            lastFilledColumn = colIndex + 2;
        }
        List mergedRegions = sheet.getMergedRegions();
        HashSet<Integer> toDeleteAreaIndex = new HashSet<Integer>(16);
        ArrayList<CellRangeAddress> toAddAddress = new ArrayList<CellRangeAddress>(16);
        for (i = 0; i < mergedRegions.size(); ++i) {
            CellRangeAddress cellAddresses = (CellRangeAddress)mergedRegions.get(i);
            if (cellAddresses.containsColumn(colIndex)) {
                toDeleteAreaIndex.add(i);
                CellRangeAddress cellRangeAddress = cellAddresses.copy();
                int lastCol = cellRangeAddress.getLastColumn() - shiftCount;
                if (lastCol <= cellRangeAddress.getFirstColumn()) continue;
                cellRangeAddress.setLastColumn(Math.max(cellRangeAddress.getFirstColumn() + 1, lastCol));
                toAddAddress.add(cellRangeAddress);
                continue;
            }
            if (cellAddresses.getFirstColumn() <= colIndex) continue;
            toDeleteAreaIndex.add(i);
            CellRangeAddress cellRangeAddress = cellAddresses.copy();
            cellRangeAddress.setFirstColumn(Math.max(colIndex, cellRangeAddress.getFirstColumn() - shiftCount));
            if (cellRangeAddress.getLastColumn() - shiftCount <= cellRangeAddress.getFirstColumn()) continue;
            cellRangeAddress.setLastColumn(Math.max(cellRangeAddress.getFirstColumn() + 1, cellRangeAddress.getLastColumn() - shiftCount));
            toAddAddress.add(cellRangeAddress);
        }
        sheet.removeMergedRegions(toDeleteAreaIndex);
        for (i = 0; i < shiftCount; ++i) {
            POIHelper.removeColumnCells((Sheet)sheet, colIndex - i);
        }
        Map<String, List<Cell>> cellFormulaListMap = new POIHelper().getCellFormulaListMap(sheet);
        for (Map.Entry entry : cellFormulaListMap.entrySet()) {
            List value = (List)entry.getValue();
            for (Cell cell : value) {
                int columnIndex;
                if (cell == null || colIndex >= (columnIndex = cell.getColumnIndex()) || !cell.isPartOfArrayFormulaGroup()) continue;
                ((XSSFCell)cell).tryToDeleteArrayFormula(null);
            }
        }
        try {
            sheet.shiftColumns(colIndex + 1, lastFilledColumn, -shiftCount);
        }
        catch (Exception exception) {
            log.error("reportexport shiftColumns error:");
            log.error((Throwable)exception);
        }
        Map<String, List<Cell>> cellFormulaListMap1 = new POIHelper().getCellFormulaListMap(sheet);
        Set<String> set = cellFormulaListMap.keySet();
        Set<String> strings1 = cellFormulaListMap1.keySet();
        if (!set.equals(strings1)) {
            int sheetIndex = sheet.getWorkbook().getSheetIndex((Sheet)sheet);
            XSSFEvaluationWorkbook fpb = POIHelper.getFpb(sheet.getWorkbook());
            for (Map.Entry<String, List<Cell>> entry : cellFormulaListMap.entrySet()) {
                String key = entry.getKey();
                List<Cell> value = entry.getValue();
                for (Cell cell : value) {
                    int rowIndex1 = -1;
                    try {
                        rowIndex1 = cell.getRowIndex();
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    if (rowIndex1 == -1) continue;
                    Ptg[] basePtg = FormulaParser.parse((String)key, (FormulaParsingWorkbook)fpb, (FormulaType)FormulaType.CELL, (int)sheetIndex, (int)rowIndex1);
                    Ptg[] ptgs = new Ptg[basePtg.length];
                    for (int i2 = 0; i2 < basePtg.length; ++i2) {
                        ptgs[i2] = basePtg[i2].copy();
                    }
                    for (Ptg ptg : ptgs) {
                        RefPtgBase ref;
                        if (ptg instanceof RefPtgBase) {
                            ref = (RefPtgBase)ptg;
                            if (ref.getColumn() <= colIndex) continue;
                            ref.setColumn(ref.getColumn() - shiftCount);
                            continue;
                        }
                        if (!(ptg instanceof AreaPtg)) continue;
                        ref = (AreaPtg)ptg;
                        int firstColumn = ref.getFirstColumn();
                        int lastColumn = ref.getLastColumn();
                        if (firstColumn > colIndex) {
                            ref.setFirstColumn(ref.getFirstColumn() - shiftCount);
                        }
                        if (lastColumn <= colIndex) continue;
                        ref.setLastColumn(ref.getLastColumn() - shiftCount);
                    }
                    String shiftedFormula = FormulaRenderer.toFormulaString((FormulaRenderingWorkbook)fpb, (Ptg[])ptgs);
                    POIHelper.updateCtCellFormulaValue((XSSFCell)cell, shiftedFormula);
                }
            }
        }
        for (CellRangeAddress addAddress : toAddAddress) {
            try {
                sheet.addMergedRegion(addAddress);
            }
            catch (Exception exception) {
                log.error((Throwable)exception);
            }
        }
    }

    public static void shiftRow(XSSFSheet sheet, int rowIndex, int shiftCount) {
        int lastRowNum = sheet.getLastRowNum();
        if (lastRowNum <= rowIndex + 1) {
            lastRowNum = rowIndex + 2;
        }
        List mergedRegions = sheet.getMergedRegions();
        HashSet<Integer> toDeleteAreaIndex = new HashSet<Integer>(16);
        ArrayList<CellRangeAddress> toAddAddress = new ArrayList<CellRangeAddress>(16);
        for (int i = 0; i < mergedRegions.size(); ++i) {
            CellRangeAddress cellAddresses = (CellRangeAddress)mergedRegions.get(i);
            if (!cellAddresses.containsRow(rowIndex)) continue;
            toDeleteAreaIndex.add(i);
            CellRangeAddress cellRangeAddress = cellAddresses.copy();
            cellRangeAddress.setLastRow(Math.max(cellRangeAddress.getFirstRow() + 1, cellRangeAddress.getLastRow() - shiftCount));
            toAddAddress.add(cellRangeAddress);
        }
        sheet.removeMergedRegions(toDeleteAreaIndex);
        Map<String, List<Cell>> cellFormulaListMap = new POIHelper().getCellFormulaListMap(sheet);
        for (Map.Entry entry : cellFormulaListMap.entrySet()) {
            List value = (List)entry.getValue();
            for (Cell cell : value) {
                int rowIndex1;
                if (cell == null || rowIndex >= (rowIndex1 = cell.getRowIndex()) || !cell.isPartOfArrayFormulaGroup()) continue;
                ((XSSFCell)cell).tryToDeleteArrayFormula(null);
            }
        }
        try {
            sheet.shiftRows(rowIndex + 1, lastRowNum, -shiftCount);
        }
        catch (Exception exception) {
            log.error("reportexport shiftRows error:");
            log.error((Throwable)exception);
        }
        Map<String, List<Cell>> cellFormulaListMap1 = new POIHelper().getCellFormulaListMap(sheet);
        Set<String> set = cellFormulaListMap.keySet();
        Set<String> strings1 = cellFormulaListMap1.keySet();
        int sheetIndex = sheet.getWorkbook().getSheetIndex((Sheet)sheet);
        if (!set.equals(strings1)) {
            XSSFEvaluationWorkbook fpb = POIHelper.getFpb(sheet.getWorkbook());
            for (Map.Entry<String, List<Cell>> entry : cellFormulaListMap.entrySet()) {
                String key = entry.getKey();
                List<Cell> value = entry.getValue();
                for (Cell cell : value) {
                    int rowIndex1 = -1;
                    try {
                        rowIndex1 = cell.getRowIndex();
                    }
                    catch (Exception exception) {
                        continue;
                    }
                    if (rowIndex1 == -1) continue;
                    Ptg[] basePtg = FormulaParser.parse((String)key, (FormulaParsingWorkbook)fpb, (FormulaType)FormulaType.CELL, (int)sheetIndex, (int)rowIndex1);
                    Ptg[] ptgs = new Ptg[basePtg.length];
                    for (int i = 0; i < basePtg.length; ++i) {
                        ptgs[i] = basePtg[i].copy();
                    }
                    for (Ptg ptg : ptgs) {
                        RefPtgBase ref;
                        if (ptg instanceof RefPtgBase) {
                            ref = (RefPtgBase)ptg;
                            if (ref.getRow() <= rowIndex) continue;
                            ref.setRow(ref.getRow() - shiftCount);
                            continue;
                        }
                        if (!(ptg instanceof AreaPtg)) continue;
                        ref = (AreaPtg)ptg;
                        int firstRow = ref.getFirstRow();
                        int lastRow = ref.getLastRow();
                        if (firstRow > rowIndex) {
                            ref.setFirstRow(ref.getFirstRow() - shiftCount);
                        }
                        if (lastRow <= rowIndex) continue;
                        ref.setLastRow(ref.getLastRow() - shiftCount);
                    }
                    String shiftedFormula = FormulaRenderer.toFormulaString((FormulaRenderingWorkbook)fpb, (Ptg[])ptgs);
                    POIHelper.updateCtCellFormulaValue((XSSFCell)cell, shiftedFormula);
                }
            }
        }
        for (CellRangeAddress addAddress : toAddAddress) {
            try {
                sheet.addMergedRegion(addAddress);
            }
            catch (Exception exception) {
                log.error((Throwable)exception);
            }
        }
    }

    public static void copyCellStyle(CellStyle fromStyle, CellStyle toStyle) {
        toStyle.cloneStyleFrom(fromStyle);
    }

    public static void mergeSheetAllRegion(XSSFSheet fromSheet, XSSFSheet toSheet) {
        int num = fromSheet.getNumMergedRegions();
        CellRangeAddress cellR = null;
        for (int i = 0; i < num; ++i) {
            cellR = fromSheet.getMergedRegion(i);
            if (cellR.getNumberOfCells() < 2) continue;
            toSheet.addMergedRegionUnsafe(cellR);
        }
    }

    public static void copyCell(XSSFWorkbook wb, Cell fromCell, Cell toCell, Map<Short, Short> styles) {
        short index = fromCell.getCellStyle().getIndex();
        Short stylesOrDefault = styles.getOrDefault(index, (short)Short.MIN_VALUE);
        XSSFCellStyle newstyle = wb.getCellStyleAt((int)stylesOrDefault.shortValue());
        if (newstyle == null) {
            newstyle = wb.createCellStyle();
            POIHelper.copyCellStyle(fromCell.getCellStyle(), (CellStyle)newstyle);
            styles.put(fromCell.getCellStyle().getIndex(), newstyle.getIndex());
        }
        toCell.setCellStyle((CellStyle)newstyle);
        if (fromCell.getCellComment() != null) {
            toCell.setCellComment(fromCell.getCellComment());
        }
        POIHelper.copyCellValue(toCell, fromCell);
    }

    public static Object getCellValue(Cell cell) {
        if (cell == null) {
            return "";
        }
        CellType cellType = cell.getCellType();
        if (cellType == CellType.FORMULA) {
            CellType cachedFormulaResultType = cell.getCachedFormulaResultType();
            switch (cachedFormulaResultType) {
                case NUMERIC: {
                    if (DateUtil.isCellDateFormatted((Cell)cell)) {
                        Date dateCellValue = cell.getDateCellValue();
                        return ConvertUtils.convertToOADate((Date)dateCellValue);
                    }
                    NumberFormat instance = NumberFormat.getInstance();
                    instance.setMaximumFractionDigits(16);
                    instance.setGroupingUsed(false);
                    String result = instance.format(BigDecimal.valueOf(cell.getNumericCellValue()));
                    if (result.contains(",") && !result.contains(".")) {
                        return result.replace(",", "") + ".0";
                    }
                    return result.replace(",", "");
                }
                case STRING: {
                    return cell.getStringCellValue();
                }
                case BOOLEAN: {
                    return cell.getBooleanCellValue();
                }
                case BLANK: {
                    return "";
                }
            }
            FormulaEvaluator formulaEvaluator = cell.getSheet().getWorkbook().getCreationHelper().createFormulaEvaluator();
            return formulaEvaluator.evaluate(cell).getStringValue();
        }
        if (cellType == CellType.NUMERIC) {
            if (DateUtil.isCellDateFormatted((Cell)cell)) {
                Date dateCellValue = cell.getDateCellValue();
                return ConvertUtils.convertToOADate((Date)dateCellValue);
            }
            NumberFormat instance = NumberFormat.getInstance();
            instance.setMaximumFractionDigits(16);
            instance.setGroupingUsed(false);
            String result = instance.format(BigDecimal.valueOf(cell.getNumericCellValue()));
            if (result.contains(",") && !result.contains(".")) {
                return result.replace(",", "") + ".0";
            }
            return result.replace(",", "");
        }
        if (cellType == CellType.BOOLEAN) {
            return cell.getBooleanCellValue();
        }
        if (cellType == CellType.STRING) {
            return cell.getStringCellValue();
        }
        if (cellType == CellType.BLANK) {
            return "";
        }
        return "";
    }

    public static void copyCellValue(Cell toCell, Cell fromCell) {
        CellType cellType = fromCell.getCellType();
        if (cellType != CellType.FORMULA) {
            ((XSSFCell)toCell).setCellType(cellType);
        }
        switch (cellType) {
            case STRING: {
                toCell.setCellValue(fromCell.getRichStringCellValue());
                break;
            }
            case NUMERIC: {
                toCell.setCellValue(fromCell.getNumericCellValue());
                break;
            }
            case FORMULA: {
                POIHelper.copyCtCellFormulaValue((XSSFCell)fromCell, (XSSFCell)toCell);
                break;
            }
            case BOOLEAN: {
                toCell.setCellValue(fromCell.getBooleanCellValue());
                break;
            }
            case ERROR: {
                toCell.setCellValue((double)fromCell.getErrorCellValue());
                break;
            }
            case BLANK: {
                toCell.setBlank();
                break;
            }
        }
    }

    public void copyCol(XSSFSheet sheetAt, int startRowIndex, int rowCount, int oldCol, int toCol, Map<Short, Short> styles) {
        for (int i = startRowIndex; i < startRowIndex + rowCount; ++i) {
            XSSFCell oldCell;
            XSSFRow row = sheetAt.getRow(i);
            if (row == null || (oldCell = row.getCell(oldCol)) == null) continue;
            XSSFCell toCell = row.getCell(toCol);
            if (toCell == null) {
                toCell = row.createCell(toCol);
            }
            POIHelper.copyCell(sheetAt.getWorkbook(), oldCell, toCell, styles);
        }
    }

    public static XSSFEvaluationWorkbook getFpb(XSSFWorkbook xssfWorkbook) {
        return XSSFEvaluationWorkbook.create((XSSFWorkbook)xssfWorkbook);
    }

    public Map<String, List<Cell>> getAllFormulaCells(XSSFSheet xssfSheet) {
        HashMap<String, List<Cell>> result = new HashMap<String, List<Cell>>(16);
        XSSFEvaluationWorkbook fpb = POIHelper.getFpb(xssfSheet.getWorkbook());
        for (Row row : xssfSheet) {
            int lastCellNum = row.getLastCellNum();
            for (int i = 0; i < lastCellNum; ++i) {
                Cell cell = row.getCell(i);
                if (cell == null || cell.getCellType() != CellType.FORMULA) continue;
                String cellFormula = null;
                try {
                    cellFormula = cell.getCellFormula();
                }
                catch (Exception exception) {
                    continue;
                }
                if (StringUtils.isBlank((String)cellFormula)) continue;
                Set<String> formulaCells = POIHelper.getCellFormula(fpb, cell);
                for (String formulaCell : formulaCells) {
                    List xssfCells = result.computeIfAbsent(formulaCell, t -> new ArrayList(16));
                    xssfCells.add(cell);
                }
            }
        }
        return result;
    }

    public Map<String, List<Cell>> getCellFormulaListMap(XSSFSheet xssfSheet) {
        HashMap<String, List<Cell>> result = new HashMap<String, List<Cell>>(16);
        for (Row row : xssfSheet) {
            int lastCellNum = row.getLastCellNum();
            for (int i = 0; i < lastCellNum; ++i) {
                Cell cell = row.getCell(i);
                if (cell == null || cell.getCellType() != CellType.FORMULA) continue;
                String cellFormula = null;
                try {
                    cellFormula = cell.getCellFormula();
                }
                catch (Exception exception) {
                    continue;
                }
                if (StringUtils.isBlank((String)cellFormula)) continue;
                List xssfCells = result.computeIfAbsent(cellFormula, t -> new ArrayList(16));
                xssfCells.add(cell);
            }
        }
        return result;
    }

    public void copyRow(XSSFSheet sheetAt, int oldRowIndex, int toRowIndex, int startCol, int colCount, Map<Short, Short> styles) {
        XSSFRow oldRow = sheetAt.getRow(oldRowIndex);
        XSSFRow toRow = sheetAt.getRow(toRowIndex);
        if (oldRow == null || toRow == null) {
            return;
        }
        toRow.setRowStyle((CellStyle)oldRow.getRowStyle());
        for (int i = startCol; i < startCol + colCount; ++i) {
            XSSFCell cell = oldRow.getCell(i);
            if (cell == null) continue;
            XSSFCell newCell = toRow.getCell(i);
            if (newCell == null) {
                newCell = toRow.createCell(i);
            }
            POIHelper.copyCell(sheetAt.getWorkbook(), cell, newCell, styles);
        }
    }

    public static void updateFormulaRowAndCol(Map<String, List<Cell>> formulaCellMap, Cell oldCell, int shiftCount, boolean isRow) {
        if (formulaCellMap == null || formulaCellMap.size() == 0) {
            return;
        }
        int rowIndex = oldCell.getRowIndex();
        int columnIndex = oldCell.getColumnIndex();
        String mapKey = rowIndex + ":" + columnIndex;
        List<Cell> cells = formulaCellMap.get(mapKey);
        if (CollectionUtils.isEmpty(cells)) {
            return;
        }
        for (Cell cell1 : cells) {
            POIHelper.updateFormulaPtg(cell1, oldCell, shiftCount, isRow);
        }
    }

    public static boolean mergedAddressIsInRange(CellArea range, CellRangeAddress cellAddresses) {
        int c = range.getC();
        int cc = range.getCc();
        int r = range.getR();
        int rc = range.getRc();
        int firstRow = cellAddresses.getFirstRow();
        int lastRow = cellAddresses.getLastRow();
        int firstColumn = cellAddresses.getFirstColumn();
        int lastColumn = cellAddresses.getLastColumn();
        boolean colResult = firstColumn >= c && firstColumn <= c + cc && lastColumn >= c && c <= c + cc;
        boolean rowResult = firstRow >= r && firstRow <= r + rc && lastRow >= r && lastRow <= r + rc;
        return colResult && rowResult;
    }

    public static void copyColMergedRegion(int index, int count, XSSFSheet xssfSheet, Set<Integer> toModifyRegions, CellArea range) {
        CellRangeAddress cellAddresses2;
        List mergedRegions = xssfSheet.getMergedRegions();
        HashSet<Integer> toDeleteArea = new HashSet<Integer>(16);
        for (int i = index; i < index + count; ++i) {
            for (int i1 = 0; i1 < mergedRegions.size(); ++i1) {
                cellAddresses2 = (CellRangeAddress)mergedRegions.get(i1);
                if (!POIHelper.mergedAddressIsInRange(range, cellAddresses2) || !cellAddresses2.containsColumn(i)) continue;
                toDeleteArea.add(i1);
            }
        }
        ArrayList<CellRangeAddress> toAddArea = new ArrayList<CellRangeAddress>(16);
        for (int i = 0; i < mergedRegions.size(); ++i) {
            cellAddresses2 = (CellRangeAddress)mergedRegions.get(i);
            if (!toModifyRegions.contains(i)) continue;
            toDeleteArea.add(i);
            CellRangeAddress copy = cellAddresses2.copy();
            int colOffset = -count;
            copy.setFirstColumn(Math.max(copy.getFirstColumn() + colOffset, 0));
            copy.setLastColumn(Math.max(copy.getLastColumn() + colOffset, 0));
            toAddArea.add(copy);
        }
        xssfSheet.removeMergedRegions(toDeleteArea);
        toDeleteArea.clear();
        for (CellRangeAddress cellAddresses2 : toAddArea) {
            boolean intersects = false;
            for (int i = 0; i < mergedRegions.size(); ++i) {
                CellRangeAddress mergedRegion = (CellRangeAddress)mergedRegions.get(i);
                intersects = mergedRegion.intersects((CellRangeAddressBase)cellAddresses2);
                if (!intersects) continue;
                toDeleteArea.add(i);
            }
        }
        xssfSheet.removeMergedRegions(toDeleteArea);
        for (CellRangeAddress cellAddresses2 : toAddArea) {
            xssfSheet.addMergedRegion(cellAddresses2);
        }
    }

    public static void copyRowMergedRegion(int index, int count, XSSFSheet xssfSheet, Set<Integer> toModifyRegions, CellArea range) {
        CellRangeAddress cellAddresses;
        List mergedRegions = xssfSheet.getMergedRegions();
        HashSet<Integer> toDeleteArea = new HashSet<Integer>(16);
        for (int i = index; i < index + count; ++i) {
            for (int i1 = 0; i1 < mergedRegions.size(); ++i1) {
                cellAddresses = (CellRangeAddress)mergedRegions.get(i1);
                if (!POIHelper.mergedAddressIsInRange(range, cellAddresses) || !cellAddresses.containsRow(i)) continue;
                toDeleteArea.add(i1);
            }
        }
        ArrayList<CellRangeAddress> toAddArea = new ArrayList<CellRangeAddress>(16);
        for (int i = 0; i < mergedRegions.size(); ++i) {
            cellAddresses = (CellRangeAddress)mergedRegions.get(i);
            if (!toModifyRegions.contains(i)) continue;
            toDeleteArea.add(i);
            CellRangeAddress copy = cellAddresses.copy();
            int rowOffset = -count;
            copy.setFirstRow(Math.max(copy.getFirstRow() + rowOffset, 0));
            copy.setLastRow(Math.max(copy.getLastRow() + rowOffset, 0));
            toAddArea.add(copy);
        }
        xssfSheet.removeMergedRegions(toDeleteArea);
        toDeleteArea.clear();
        boolean intersects = false;
        for (CellRangeAddress cellAddresses2 : toAddArea) {
            for (int i = 0; i < mergedRegions.size(); ++i) {
                CellRangeAddress mergedRegion = (CellRangeAddress)mergedRegions.get(i);
                intersects = mergedRegion.intersects((CellRangeAddressBase)cellAddresses2);
                if (!intersects) continue;
                toDeleteArea.add(i);
            }
        }
        xssfSheet.removeMergedRegions(toDeleteArea);
        for (CellRangeAddress cellAddresses2 : toAddArea) {
            xssfSheet.addMergedRegion(cellAddresses2);
        }
    }

    public static void copyRow(XSSFWorkbook wb, XSSFRow oldRow, XSSFRow toRow, int maxCol, Map<Short, Short> styles) {
        toRow.setHeight(oldRow.getHeight());
        Iterator cellIt = oldRow.cellIterator();
        while (cellIt.hasNext()) {
            XSSFCell tmpCell = (XSSFCell)cellIt.next();
            if (tmpCell.getCellType() == CellType.BLANK && tmpCell.getCellStyle().getFont() == null) continue;
            XSSFCell newCell = toRow.createCell(tmpCell.getColumnIndex());
            POIHelper.copyCell(wb, tmpCell, newCell, styles);
        }
        return;
    }

    public static void copyCell(XSSFWorkbook wb, XSSFCell fromCell, XSSFCell toCell, Map<Short, Short> styles) {
        short index = fromCell.getCellStyle().getIndex();
        XSSFCellStyle newstyle = wb.getCellStyleAt((int)styles.getOrDefault(index, (short)Short.MIN_VALUE).shortValue());
        if (newstyle == null) {
            newstyle = wb.createCellStyle();
        }
        POIHelper.copyCellStyle(fromCell.getCellStyle(), newstyle);
        styles.put(fromCell.getCellStyle().getIndex(), newstyle.getIndex());
        toCell.setCellStyle((CellStyle)newstyle);
        if (fromCell.getCellComment() != null) {
            toCell.setCellComment((Comment)fromCell.getCellComment());
        }
        POIHelper.copyCellValue((Cell)toCell, (Cell)fromCell);
    }

    public static void copyCellStyle(XSSFCellStyle fromStyle, XSSFCellStyle toStyle) {
        toStyle.cloneStyleFrom((CellStyle)fromStyle);
    }

    public static void copyCell(Workbook wb, Cell fromCell, Cell toCell) {
        CellStyle cellStyle = fromCell.getCellStyle();
        if (cellStyle != null) {
            CellStyle cellStyle1 = toCell.getCellStyle();
            if (cellStyle1 == null) {
                cellStyle1 = wb.createCellStyle();
            }
            cellStyle1.cloneStyleFrom(cellStyle);
        }
        if (fromCell.getCellComment() != null) {
            toCell.setCellComment(fromCell.getCellComment());
        }
        POIHelper.copyCellValue(toCell, fromCell);
    }

    public static void copySheet(Sheet fromSheet, Sheet toSheet) {
        POIHelper.mergeSheetAllRegion((XSSFSheet)fromSheet, (XSSFSheet)toSheet);
        int firstRowNum = fromSheet.getFirstRowNum();
        if (firstRowNum >= 0) {
            for (int i = 0; i <= fromSheet.getRow(firstRowNum).getLastCellNum(); ++i) {
                toSheet.setColumnWidth(i, fromSheet.getColumnWidth(i));
            }
        }
        HashMap<Short, Short> styles = new HashMap<Short, Short>(16);
        Iterator rowIt = fromSheet.rowIterator();
        while (rowIt.hasNext()) {
            XSSFRow oldRow = (XSSFRow)rowIt.next();
            Row newRow = toSheet.createRow(oldRow.getRowNum());
            POIHelper.copyRow(((XSSFSheet)toSheet).getWorkbook(), oldRow, (XSSFRow)newRow, POIHelper.getLastFilledColumn(toSheet), styles);
        }
        PaneInformation paneInformation = fromSheet.getPaneInformation();
        if (paneInformation != null) {
            toSheet.createFreezePane((int)paneInformation.getVerticalSplitPosition(), (int)paneInformation.getHorizontalSplitPosition(), (int)paneInformation.getVerticalSplitLeftColumn(), (int)paneInformation.getHorizontalSplitTopRow());
        }
        styles.clear();
    }
}

