/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.report.excel.helper;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.parser.Feature;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.ebcommon.common.util.ThrowableHelper;
import kd.epm.eb.common.enums.SpreadTypeEnum;
import kd.epm.eb.common.utils.ExcelUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.Point;
import kd.epm.eb.spread.command.rangedefined.CellArea;
import kd.epm.eb.spread.report.excel.helper.POIHelper;
import kd.epm.eb.spread.template.BgTemplate;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.TemplateModelJSONUtil;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.util.CellRangeAddress;
import org.apache.poi.ss.util.CellRangeAddressBase;
import org.apache.poi.xssf.usermodel.XSSFSheet;

public class TemplateHelper {
    private static final Log log = LogFactory.getLog(TemplateHelper.class);
    private Map<Short, Short> styles = new HashMap<Short, Short>(16);
    private POIHelper poiHelper = new POIHelper();

    public static ITemplateModel parseTemplateModel(DynamicObject templateDynamicObject) {
        if (templateDynamicObject == null) {
            return null;
        }
        BgTemplate templateBaseInfo = new BgTemplate();
        templateBaseInfo.setVarBase(templateDynamicObject.getString("varbaseforeb"));
        templateBaseInfo.setId(templateDynamicObject.getLong("id"));
        templateBaseInfo.setName(templateDynamicObject.getString("name"));
        templateBaseInfo.setNumber(templateDynamicObject.getString("number"));
        templateBaseInfo.setTemplatetype(templateDynamicObject.getInt("templatetype"));
        templateBaseInfo.setDataunit(templateDynamicObject.getString("dataunit"));
        templateBaseInfo.setModelID(templateDynamicObject.getLong("model.id"));
        templateBaseInfo.setCatalog(templateDynamicObject.getLong("templateCatalog.id"));
        templateBaseInfo.setDatasetID(templateDynamicObject.getLong("dataset.id"));
        templateBaseInfo.setSpreadType(SpreadTypeEnum.SPREADTYPE_REPORT.getIndex());
        String data = (String)templateDynamicObject.get("data");
        ITemplateModel templateModel = null;
        if (StringUtils.isNotBlank((CharSequence)data)) {
            templateModel = TemplateModelJSONUtil.parseITemplateModel(data);
        }
        if (templateModel == null) {
            return null;
        }
        templateModel.setSpreadSerilal(templateDynamicObject.getString("spreadserial"));
        templateModel.setTemplateBaseInfo(templateBaseInfo);
        return templateModel;
    }

    public Map<Short, Short> getStyles() {
        return this.styles;
    }

    public void setStyles(Map<Short, Short> styles) {
        this.styles = styles;
    }

    public POIHelper getPoiHelper() {
        return this.poiHelper;
    }

    public void setPoiHelper(POIHelper poiHelper) {
        this.poiHelper = poiHelper;
    }

    public void fieldDeleteRowCol(XSSFSheet xssfSheet, CellArea range, int index, int count, boolean isRow) {
        int start;
        int i;
        int startCol = range.getC();
        int colCount = range.getCc();
        int startRow = range.getR();
        int rowCount = range.getRc();
        int oldIndexStart = index + count;
        if (isRow) {
            for (i = oldIndexStart; i < startRow + rowCount; ++i) {
                this.getPoiHelper().copyRow(xssfSheet, i, i - count, startCol, colCount, this.styles);
            }
            this.copyRowMergeRegions(xssfSheet, range, index, count);
        } else {
            for (i = oldIndexStart; i < startCol + colCount; ++i) {
                this.getPoiHelper().copyCol(xssfSheet, startRow, rowCount, i, i - count, this.styles);
            }
            this.copyColMergeRegions(xssfSheet, range, index, count);
        }
        if (isRow) {
            start = startRow + rowCount - 1;
            int end = startRow + rowCount - count - 1;
            for (int i2 = start; i2 > end; --i2) {
                POIHelper.removeRowCellsInArea((Sheet)xssfSheet, i2, startCol, colCount);
            }
        } else {
            start = startCol + colCount - 1;
            int end = startCol + colCount - count - 1;
            for (int i3 = start; i3 > end; --i3) {
                POIHelper.removeColCellsInArea((Sheet)xssfSheet, i3, startRow, rowCount);
            }
        }
    }

    private void copyRowMergeRegions(XSSFSheet xssfSheet, CellArea range, int index, int count) {
        List mergedRegions = xssfSheet.getMergedRegions();
        ArrayList<Object> toAddRegions = new ArrayList<Object>(16);
        ArrayList<Integer> toDeleteIndexList = new ArrayList<Integer>(16);
        int lastIndex = index + count - 1;
        for (int i = 0; i < mergedRegions.size(); ++i) {
            int n;
            CellRangeAddress copy;
            CellRangeAddress mergedRegion = (CellRangeAddress)mergedRegions.get(i);
            if (!POIHelper.mergedAddressIsInRange(range, mergedRegion)) continue;
            int firstRow = mergedRegion.getFirstRow();
            int lastRow = mergedRegion.getLastRow();
            if (firstRow > lastIndex) {
                copy = mergedRegion.copy();
                n = copy.getFirstRow() - count;
                int newLastRow = copy.getLastRow() - count;
                if (n >= 0) {
                    copy.setFirstRow(n);
                }
                if (newLastRow <= 0) {
                    toDeleteIndexList.add(i);
                    continue;
                }
                copy.setLastRow(newLastRow);
                toDeleteIndexList.add(i);
                toAddRegions.add(copy);
                continue;
            }
            if (lastRow <= lastIndex || firstRow >= lastIndex) continue;
            copy = mergedRegion.copy();
            n = copy.getLastRow() - count;
            if (copy.getFirstRow() <= n) {
                toDeleteIndexList.add(i);
                continue;
            }
            copy.setLastRow(n);
            toDeleteIndexList.add(i);
            toAddRegions.add(copy);
        }
        if (CollectionUtils.isNotEmpty(toDeleteIndexList)) {
            xssfSheet.removeMergedRegions(toDeleteIndexList);
        }
        List mergedRegions1 = xssfSheet.getMergedRegions();
        ArrayList<CellRangeAddress> newToAddRegions = new ArrayList<CellRangeAddress>(16);
        ArrayList<Integer> newToDeleteIndexList = new ArrayList<Integer>(16);
        for (CellRangeAddress cellRangeAddress : toAddRegions) {
            HashMap<Integer, CellRangeAddress> toModifyRegions = new HashMap<Integer, CellRangeAddress>(16);
            for (int i = 0; i < mergedRegions1.size(); ++i) {
                CellRangeAddress mergedRegion = (CellRangeAddress)mergedRegions1.get(i);
                boolean intersects = mergedRegion.intersects((CellRangeAddressBase)cellRangeAddress);
                if (!intersects) continue;
                toModifyRegions.put(i, mergedRegion);
            }
            for (Map.Entry entry : toModifyRegions.entrySet()) {
                Integer key = (Integer)entry.getKey();
                newToDeleteIndexList.add(key);
                CellRangeAddress toModifyRegion = (CellRangeAddress)entry.getValue();
                CellRangeAddress copy = toModifyRegion.copy();
                int newLastRow = copy.getLastRow() - count;
                if (newLastRow <= 0) {
                    newToDeleteIndexList.add(key);
                    continue;
                }
                if (copy.getFirstRow() <= newLastRow) {
                    newToDeleteIndexList.add(key);
                    continue;
                }
                newToAddRegions.add(copy);
            }
        }
        if (CollectionUtils.isNotEmpty(newToDeleteIndexList)) {
            xssfSheet.removeMergedRegions(newToDeleteIndexList);
        }
        toAddRegions.addAll(newToAddRegions);
        for (CellRangeAddress cellRangeAddress : toAddRegions) {
            try {
                xssfSheet.addMergedRegion(cellRangeAddress);
            }
            catch (Exception exception) {
                log.error((Throwable)exception);
            }
        }
    }

    private void copyColMergeRegions(XSSFSheet xssfSheet, CellArea range, int index, int count) {
        List mergedRegions = xssfSheet.getMergedRegions();
        ArrayList<Object> toAddRegions = new ArrayList<Object>(16);
        ArrayList<Integer> toDeleteIndexList = new ArrayList<Integer>(16);
        int lastIndex = index + count - 1;
        for (int i = 0; i < mergedRegions.size(); ++i) {
            int n;
            CellRangeAddress copy;
            CellRangeAddress mergedRegion = (CellRangeAddress)mergedRegions.get(i);
            if (!POIHelper.mergedAddressIsInRange(range, mergedRegion)) continue;
            int firstColumn = mergedRegion.getFirstColumn();
            int lastColumn = mergedRegion.getLastColumn();
            if (firstColumn > lastIndex) {
                copy = mergedRegion.copy();
                n = copy.getFirstColumn() - count;
                int newLastCol = copy.getLastColumn() - count;
                if (n >= 0) {
                    copy.setFirstColumn(n);
                }
                if (newLastCol <= 0) {
                    toDeleteIndexList.add(i);
                    continue;
                }
                copy.setLastColumn(newLastCol);
                toDeleteIndexList.add(i);
                toAddRegions.add(copy);
                continue;
            }
            if (lastColumn <= lastIndex || firstColumn >= lastIndex) continue;
            copy = mergedRegion.copy();
            n = copy.getLastColumn() - count;
            if (copy.getFirstColumn() <= n) {
                toDeleteIndexList.add(i);
                continue;
            }
            copy.setLastColumn(n);
            toDeleteIndexList.add(i);
            toAddRegions.add(copy);
        }
        if (CollectionUtils.isNotEmpty(toDeleteIndexList)) {
            xssfSheet.removeMergedRegions(toDeleteIndexList);
        }
        List mergedRegions1 = xssfSheet.getMergedRegions();
        ArrayList<CellRangeAddress> newToAddRegions = new ArrayList<CellRangeAddress>(16);
        ArrayList<Integer> newToDeleteIndexList = new ArrayList<Integer>(16);
        for (CellRangeAddress cellRangeAddress : toAddRegions) {
            HashMap<Integer, CellRangeAddress> toModifyRegions = new HashMap<Integer, CellRangeAddress>(16);
            for (int i = 0; i < mergedRegions1.size(); ++i) {
                CellRangeAddress mergedRegion = (CellRangeAddress)mergedRegions1.get(i);
                boolean intersects = mergedRegion.intersects((CellRangeAddressBase)cellRangeAddress);
                if (!intersects) continue;
                toModifyRegions.put(i, mergedRegion);
            }
            for (Map.Entry entry : toModifyRegions.entrySet()) {
                Integer key = (Integer)entry.getKey();
                CellRangeAddress toModifyRegion = (CellRangeAddress)entry.getValue();
                CellRangeAddress copy = toModifyRegion.copy();
                int newLastCol = copy.getLastColumn() - count;
                newToDeleteIndexList.add(key);
                if (newLastCol <= 0) {
                    newToDeleteIndexList.add(key);
                    continue;
                }
                if (copy.getFirstColumn() <= newLastCol) {
                    newToDeleteIndexList.add(key);
                    continue;
                }
                newToAddRegions.add(copy);
            }
        }
        if (CollectionUtils.isNotEmpty(newToDeleteIndexList)) {
            xssfSheet.removeMergedRegions(newToDeleteIndexList);
        }
        toAddRegions.addAll(newToAddRegions);
        for (CellRangeAddress cellRangeAddress : toAddRegions) {
            try {
                xssfSheet.addMergedRegion(cellRangeAddress);
            }
            catch (Exception exception) {
                log.error((Throwable)exception);
            }
        }
    }

    public void deleteRowCol(XSSFSheet xssfSheet, List<Integer> rowIndexList, List<Integer> colIndexList) {
        if (CollectionUtils.isNotEmpty(rowIndexList)) {
            Integer maxRowIndex = rowIndexList.get(0);
            POIHelper.shiftRow(xssfSheet, maxRowIndex, rowIndexList.size());
        }
        if (CollectionUtils.isNotEmpty(colIndexList)) {
            Integer maxColIndex = colIndexList.get(0);
            POIHelper.shiftColumn(xssfSheet, maxColIndex, colIndexList.size());
            int lastFilledColumn = POIHelper.getLastFilledColumn((Sheet)xssfSheet);
            for (int i = maxColIndex.intValue(); i < lastFilledColumn; ++i) {
                xssfSheet.setColumnWidth(i - colIndexList.size(), xssfSheet.getColumnWidth(i));
            }
        }
    }

    public static Point getAbsolutePosPoint(String areaRange, String relatedPosition) {
        if (StringUtils.isEmpty((CharSequence)areaRange) || StringUtils.isEmpty((CharSequence)relatedPosition)) {
            return null;
        }
        String[] startEndPos = areaRange.split(":");
        String[] relatedPos = relatedPosition.split(":");
        if (startEndPos.length == 2 || relatedPos.length == 2) {
            Point startPoint = ExcelUtils.pos2Point((String)startEndPos[0]);
            Point dataPoint = new Point(Integer.parseInt(relatedPos[0]), Integer.parseInt(relatedPos[1]));
            return new Point(dataPoint.x + startPoint.x, dataPoint.y + startPoint.y);
        }
        return null;
    }

    public void addSheetToJson(LinkedHashMap<String, Object> baseJsonMap, String fromJson, String fromSheetName) {
        try {
            JSONObject baseSheets = (JSONObject)baseJsonMap.get("sheets");
            if (StringUtils.isBlank((CharSequence)fromJson)) {
                return;
            }
            LinkedHashMap fromJsonMap = (LinkedHashMap)JSON.parseObject((String)fromJson, LinkedHashMap.class, (Feature[])new Feature[]{Feature.OrderedField});
            for (Map.Entry entry : fromJsonMap.entrySet()) {
                String key = (String)entry.getKey();
                Object value = entry.getValue();
                if (StringUtils.equals((CharSequence)"sheets", (CharSequence)key)) continue;
                baseJsonMap.put(key, value);
            }
            JSONObject fromSheets = (JSONObject)fromJsonMap.get("sheets");
            int newBaseSheetCount = baseSheets.size();
            for (Map.Entry entry : fromSheets.entrySet()) {
                JSONObject sheet = (JSONObject)entry.getValue();
                sheet.put("index", (Object)(++newBaseSheetCount));
                sheet.put("name", (Object)fromSheetName);
                baseSheets.put(fromSheetName, (Object)sheet);
                baseJsonMap.put("sheetCount", newBaseSheetCount);
            }
        }
        catch (Exception exception) {
            log.error((Throwable)exception);
            throw new KDBizException(ThrowableHelper.toString((Exception)exception));
        }
    }

    public static String getDimNumByPos(Map<String, Integer> dimPosMap, int pos) {
        String dim = "";
        if (dimPosMap == null || dimPosMap.size() == 0) {
            return dim;
        }
        for (Map.Entry<String, Integer> dimPosKV : dimPosMap.entrySet()) {
            if (!IDUtils.equals((Object)dimPosKV.getValue(), (Object)pos)) continue;
            return dimPosKV.getKey();
        }
        return dim;
    }
}

