/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.template;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.ModelCacheServiceHelper;
import kd.epm.eb.common.cache.impl.Model;
import kd.epm.eb.common.enums.BgTemplateTypeEnum;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.QFBuilder;
import kd.epm.eb.spread.template.BgTemplate;
import kd.epm.eb.spread.template.IBaseEntry;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.TemplateModelJSONUtil;
import kd.epm.eb.spread.template.afix.FixTemplateModel;
import kd.epm.eb.spread.template.afix.multisetting.IMultiAreaSetting;
import kd.epm.eb.spread.template.arearangedim.IRowColDimensionEntry;
import kd.epm.eb.spread.template.dimension.DefaultDimMember;
import kd.epm.eb.spread.template.dimension.IDimensionMember;
import kd.epm.eb.spread.template.pagedim.IPageDimensionEntry;
import kd.epm.eb.spread.template.partition.RowColPartition;
import kd.epm.eb.spread.template.viewpointdim.IViewPointDimensionEntry;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarCommonUtil;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.collections4.MapUtils;
import org.apache.commons.lang3.tuple.Pair;

public final class TemplateModelHelper {
    public static Pair<ITemplateModel, String> getTemplateModel(String tempId) {
        String selectFields = "id,name,number,templatetype,dataunit,model,templateCatalog,dataset,dataset.businessmodel,isrelation,dimrelationinfo,data,dimmemdefaultdisplaytype,varbaseforeb,spreadserial";
        DynamicObject dyna = QueryServiceHelper.queryOne((String)"eb_templateentity", (String)selectFields, (QFilter[])new QFilter("id", "=", (Object)IDUtils.toLong((Object)tempId)).toArray());
        if (dyna == null) {
            return null;
        }
        BgTemplate templateBaseInfo = new BgTemplate();
        templateBaseInfo.setId(dyna.getLong("id"));
        templateBaseInfo.setName(dyna.getString("name"));
        templateBaseInfo.setNumber(dyna.getString("number"));
        templateBaseInfo.setTemplatetype(dyna.getInt("templatetype"));
        templateBaseInfo.setDataunit(dyna.getString("dataunit"));
        templateBaseInfo.setModelID(dyna.getLong("model"));
        templateBaseInfo.setCatalog(dyna.getLong("templateCatalog"));
        templateBaseInfo.setDatasetID(dyna.getLong("dataset"));
        templateBaseInfo.setIsDimRelation(dyna.getBoolean("isrelation") ? "1" : "0");
        templateBaseInfo.setVarBase(dyna.getString("varbaseforeb"));
        templateBaseInfo.setBizModel(dyna.getLong("dataset.businessmodel"));
        templateBaseInfo.setDimMemDefaultDisplayType(dyna.getInt("dimmemdefaultdisplaytype"));
        String data = dyna.getString("data");
        if (StringUtils.isEmpty((String)data)) {
            return null;
        }
        ITemplateModel templateModel = TemplateModelJSONUtil.parseITemplateModel(data);
        if (templateModel == null) {
            return null;
        }
        templateModel.setTemplateBaseInfo(templateBaseInfo);
        templateModel.setSpreadSerilal(dyna.getString("spreadserial"));
        return Pair.of((Object)templateModel, (Object)data);
    }

    public static boolean hasFloat(ITemplateModel templateModel) {
        if (Integer.parseInt(BgTemplateTypeEnum.EBFIX.getNumber()) != templateModel.getTemplateBaseInfo().getTemplatetype()) {
            return false;
        }
        if (CollectionUtils.isEmpty(templateModel.getAreaRanges())) {
            return false;
        }
        for (IMultiAreaSetting areaRange : templateModel.getAreaRanges()) {
            if (!CollectionUtils.isNotEmpty(areaRange.getFloatInfos())) continue;
            return true;
        }
        return false;
    }

    public static Set<Long> parseOrgIdRange(Long modelId, Long templateId, Long processId, ProcessTypeEnum processTypeEnum) {
        if (modelId != null && templateId != null) {
            DynamicObject template = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_templateentity", (String)"id,data", (QFilter[])new QFBuilder("id", "=", (Object)templateId).toArray());
            Map<String, Map<String, String>> varValueMap = ReportVarUtil.getVarValues(processTypeEnum.getNumber(), modelId, processId, "1");
            return TemplateModelHelper.parseOrgIdRange(modelId, templateId, template.getString("data"), varValueMap);
        }
        return Collections.emptySet();
    }

    public static Set<Long> parseOrgIdRange(Long modelId, Long templateId, String templateData, Map<String, Map<String, String>> varValueMap) {
        Set<IDimensionMember> orgMemberRange;
        if (StringUtils.isBlank((String)templateData)) {
            DynamicObject template = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_templateentity", (String)"id,data", (QFilter[])new QFBuilder("id", "=", (Object)templateId).toArray());
            templateData = template.getString("data");
        }
        if (CollectionUtils.isNotEmpty(orgMemberRange = TemplateModelHelper.parseOrgMemberRange(modelId, templateId, templateData, varValueMap))) {
            return orgMemberRange.stream().map(IBaseEntry::getId).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    public static Map<Long, Set<Long>> parseOrgIdRange(Long modelId, Set<Long> templateIdSet, Map<String, Map<String, String>> varValueMap) {
        HashMap<Long, Set<Long>> result = new HashMap<Long, Set<Long>>(16);
        Map dynamicObjectMap = BusinessDataServiceHelper.loadFromCache((String)"eb_templateentity", (String)"id,data", (QFilter[])new QFBuilder("id", "in", templateIdSet).toArray());
        String templateData = "";
        for (Map.Entry entry : dynamicObjectMap.entrySet()) {
            DynamicObject template = (DynamicObject)entry.getValue();
            Long templateId = IDUtils.toLong(entry.getKey());
            Set<IDimensionMember> orgMemberRange = TemplateModelHelper.parseOrgMemberRange(modelId, templateId, templateData = template.getString("data"), varValueMap);
            if (!CollectionUtils.isNotEmpty(orgMemberRange)) continue;
            Set longs = result.computeIfAbsent(templateId, t -> new HashSet(16));
            longs.addAll(orgMemberRange.stream().map(IBaseEntry::getId).collect(Collectors.toSet()));
        }
        return result;
    }

    public static Set<String> parseOrgNumberRange(Long modelId, Long templateId, Long processId, ProcessTypeEnum processTypeEnum) {
        if (modelId != null || templateId != null) {
            DynamicObject template = BusinessDataServiceHelper.loadSingleFromCache((String)"eb_templateentity", (String)"id,data", (QFilter[])new QFBuilder("id", "=", (Object)templateId).toArray());
            Map<String, Map<String, String>> varValueMap = ReportVarUtil.getVarValues(processTypeEnum.getNumber(), modelId, processId, "1");
            Set<IDimensionMember> orgMemberRange = TemplateModelHelper.parseOrgMemberRange(modelId, templateId, template.getString("data"), varValueMap);
            if (CollectionUtils.isNotEmpty(orgMemberRange)) {
                return orgMemberRange.stream().map(IBaseEntry::getNumber).collect(Collectors.toSet());
            }
        }
        return Collections.emptySet();
    }

    private static Set<IDimensionMember> parseOrgMemberRange(Long modelId, Long templateId, String templateData, Map<String, Map<String, String>> varValueMap) {
        HashSet<IDimensionMember> pageViewOrgSet = new HashSet<IDimensionMember>(16);
        if (StringUtils.isEmpty((String)templateData)) {
            return pageViewOrgSet;
        }
        ITemplateModel templateModel = TemplateModelJSONUtil.parseITemplateModel(templateData);
        if (templateModel == null) {
            return pageViewOrgSet;
        }
        BgTemplate template = new BgTemplate();
        template.setId(templateId);
        template.setModelID(modelId);
        templateModel.setTemplateBaseInfo(template);
        Set<IDimensionMember> members = TemplateModelHelper.getViewMembersFromEBTemplate(templateModel, SysDimensionEnum.Entity.getNumber(), varValueMap);
        if (CollectionUtils.isNotEmpty(members)) {
            pageViewOrgSet.addAll(members);
        } else {
            members = TemplateModelHelper.getRowColMembersFromEBTemplate(templateModel, SysDimensionEnum.Entity.getNumber(), varValueMap);
            if (CollectionUtils.isNotEmpty(members)) {
                pageViewOrgSet.addAll(members);
            }
        }
        return pageViewOrgSet;
    }

    public static Map<String, Long> getDimensionViewIds(ITemplateModel templateModel) {
        if (templateModel == null || templateModel.getTemplateBaseInfo() == null || IDUtils.isNull((Long)templateModel.getTemplateBaseInfo().getId())) {
            return Maps.newHashMap();
        }
        HashMap<String, Long> dimensionViews = new HashMap<String, Long>(32);
        Long modelId = templateModel.getTemplateBaseInfo().getModelID();
        Long datasetId = templateModel.getTemplateBaseInfo().getDatasetID();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Map viewsByDataSet = modelCache.getViewsByDataSet(datasetId);
        dimensionViews.putAll(viewsByDataSet);
        if (templateModel.getDimemsionViews() != null && templateModel.getDimemsionViews().size() > 0) {
            dimensionViews.putAll(templateModel.getDimemsionViews());
        }
        return dimensionViews;
    }

    public static Set<IDimensionMember> getViewMembersFromEBTemplate(ITemplateModel templateModel, String dimNumber, Map<String, Map<String, String>> varValueMap) {
        if (templateModel == null) {
            return null;
        }
        if (StringUtils.isEmpty((String)dimNumber)) {
            return null;
        }
        if (CollectionUtils.isEmpty(templateModel.getViewpointmembentry())) {
            return null;
        }
        Map<String, Long> dimensionViews = templateModel.getDimensionView();
        Long modelId = templateModel.getTemplateBaseInfo().getModelID();
        IModelCacheHelper modelCacheHelper = templateModel.getModelCache(modelId);
        HashSet<IDimensionMember> members = new HashSet<IDimensionMember>(16);
        if (templateModel instanceof FixTemplateModel) {
            for (IViewPointDimensionEntry viewMem : templateModel.getViewpointmembentry()) {
                List ms;
                if (!dimNumber.equals(viewMem.getDimension().getNumber())) continue;
                IDimensionMember member = viewMem.getMember();
                if (MapUtils.isNotEmpty(varValueMap) && TemplateVarCommonUtil.checkIsVar(member.getNumber(), dimNumber).booleanValue()) {
                    member.setNumber(ReportVarUtil.getRealDimByVar(modelId, member.getNumber(), dimNumber, varValueMap));
                }
                if ((ms = modelCacheHelper.getMember(dimNumber, dimensionViews.get(dimNumber), member.getNumber(), RangeEnum.ONLY.getIndex())) == null) continue;
                ms.forEach(cacheMem -> members.add(new DefaultDimMember(cacheMem.getId(), cacheMem.getName(), cacheMem.getNumber(), RangeEnum.ONLY.getIndex())));
            }
        } else {
            for (IViewPointDimensionEntry viewMem : templateModel.getViewpointmembentry()) {
                if (!dimNumber.equals(viewMem.getDimension().getNumber())) continue;
                IDimensionMember member = viewMem.getMember();
                if (MapUtils.isNotEmpty(varValueMap) && TemplateVarCommonUtil.checkIsVar(member.getNumber(), dimNumber).booleanValue()) {
                    member.setNumber(ReportVarUtil.getRealDimByVar(modelId, member.getNumber(), dimNumber, varValueMap));
                    List ms = modelCacheHelper.getMember(dimNumber, dimensionViews.get(dimNumber), member.getNumber(), RangeEnum.ONLY.getIndex());
                    if (ms == null) continue;
                    ms.forEach(cacheMem -> members.add(new DefaultDimMember(cacheMem.getId(), cacheMem.getName(), cacheMem.getNumber(), RangeEnum.ONLY.getIndex())));
                    continue;
                }
                members.add(viewMem.getMember());
            }
        }
        return members;
    }

    public static Set<IDimensionMember> getPageMembersFromEBTemplate(Long modelId, Long templateId, ITemplateModel templateModel, String dimNumber, Map<String, Map<String, String>> varValueMap) {
        if (templateModel == null) {
            return null;
        }
        if (StringUtils.isEmpty((String)dimNumber) || modelId == null) {
            return null;
        }
        Map<String, Long> dimensionViews = templateModel.getDimensionView();
        HashSet<IDimensionMember> members = new HashSet<IDimensionMember>(16);
        Model model = templateModel.getModelCache(modelId).getModelobj();
        if (templateModel.getPagemembentry() != null) {
            for (IPageDimensionEntry pageMem : templateModel.getPagemembentry()) {
                String dimNum = pageMem.getDimension().getNumber();
                if (!dimNumber.equals(dimNum)) continue;
                for (IDimensionMember mem : pageMem.getMembers()) {
                    if (MapUtils.isNotEmpty(varValueMap) && TemplateVarCommonUtil.checkIsVar(mem.getNumber(), dimNum).booleanValue()) {
                        mem.setNumber(ReportVarUtil.getRealDimByVar(modelId, mem.getNumber(), dimNum, varValueMap));
                    }
                    List cacheMembers = ModelCacheServiceHelper.getMember((Model)model, (String)dimNumber, (Long)dimensionViews.get(dimNumber), (String)mem.getNumber(), (int)mem.getScope());
                    for (kd.epm.eb.common.cache.impl.Member m : cacheMembers) {
                        members.add(new DefaultDimMember(m.getId(), m.getName(), m.getNumber(), RangeEnum.ONLY.getIndex()));
                    }
                }
            }
        }
        return members;
    }

    public static Set<IDimensionMember> getRowColMembersFromEBTemplate(ITemplateModel templateModel, String dimNumber, Map<String, Map<String, String>> varValueMap) {
        if (templateModel == null) {
            return null;
        }
        if (StringUtils.isEmpty((String)dimNumber)) {
            return null;
        }
        Map<String, Long> dimensionViews = templateModel.getDimensionView();
        Long modelId = templateModel.getTemplateBaseInfo().getModelID();
        IModelCacheHelper modelCacheHelper = templateModel.getModelCache(modelId);
        HashSet<IDimensionMember> members = new HashSet<IDimensionMember>(16);
        if (templateModel instanceof FixTemplateModel) {
            Collection<Member> memWithScope = templateModel.retrieveRowColMembersWithScope().get(dimNumber);
            if (memWithScope != null) {
                memWithScope.forEach(m -> {
                    List ms;
                    if (MapUtils.isNotEmpty((Map)varValueMap) && TemplateVarCommonUtil.checkIsVar(m.getNumber(), dimNumber).booleanValue()) {
                        m.setNumber(ReportVarUtil.getRealDimByVar(modelId, m.getNumber(), dimNumber, varValueMap));
                    }
                    if ((ms = modelCacheHelper.getMember(dimNumber, (Long)dimensionViews.get(dimNumber), m.getNumber(), m.getRange())) != null) {
                        ms.forEach(cacheMem -> members.add(new DefaultDimMember(cacheMem.getId(), cacheMem.getName(), cacheMem.getNumber(), RangeEnum.ONLY.getIndex())));
                    }
                });
            }
        } else {
            HashSet<IDimensionMember> rowColMembers = new HashSet<IDimensionMember>(16);
            if (templateModel.getPartitionSetting() != null) {
                List<IRowColDimensionEntry> entries;
                List<RowColPartition> partitions = templateModel.getPartitionSetting().getRowPartition();
                for (RowColPartition p : partitions) {
                    entries = p.getRowColDimensionEntries();
                    if (entries == null) continue;
                    for (IRowColDimensionEntry e : entries) {
                        if (!dimNumber.equals(e.getDimension().getNumber())) continue;
                        rowColMembers.addAll(e.getMembers());
                    }
                }
                if (rowColMembers.isEmpty()) {
                    partitions = templateModel.getPartitionSetting().getColPartition();
                    for (RowColPartition p : partitions) {
                        entries = p.getRowColDimensionEntries();
                        if (entries == null) continue;
                        for (IRowColDimensionEntry e : entries) {
                            if (!dimNumber.equals(e.getDimension().getNumber())) continue;
                            rowColMembers.addAll(e.getMembers());
                        }
                    }
                }
                if (CollectionUtils.isNotEmpty(rowColMembers)) {
                    rowColMembers.forEach(member -> {
                        List ms;
                        if (MapUtils.isNotEmpty((Map)varValueMap) && TemplateVarCommonUtil.checkIsVar(member.getNumber(), dimNumber).booleanValue()) {
                            member.setNumber(ReportVarUtil.getRealDimByVar(modelId, member.getNumber(), dimNumber, varValueMap));
                        }
                        if ((ms = modelCacheHelper.getMember(dimNumber, (Long)dimensionViews.get(dimNumber), member.getNumber(), member.getScope())) != null) {
                            ms.forEach(cacheMem -> members.add(new DefaultDimMember(cacheMem.getId(), cacheMem.getName(), cacheMem.getNumber(), RangeEnum.ONLY.getIndex())));
                        }
                    });
                }
            }
        }
        return members;
    }
}

