/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.template;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.alibaba.fastjson.parser.ParserConfig;
import com.alibaba.fastjson.parser.deserializer.ObjectDeserializer;
import com.alibaba.fastjson.serializer.SerializeFilter;
import com.alibaba.fastjson.serializer.SerializerFeature;
import com.alibaba.fastjson.support.spring.PropertyPreFilters;
import com.alibaba.fastjson.util.IdentityHashMap;
import java.lang.reflect.Field;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.util.ReflectionUtils;
import kd.bos.util.StringUtils;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.ITemplateParseConfig;
import kd.epm.eb.spread.template.afix.serializer.FixtemplateSerializerUtil;
import kd.epm.eb.spread.template.arearangedim.IAreaRangeEntry;
import kd.epm.eb.spread.template.cache.TemplateCache;
import kd.epm.eb.spread.template.headerarea.HeaderInfo;
import kd.epm.eb.spread.template.headerarea.IHeaderInfo;
import kd.epm.eb.spread.utils.DimPropertyHelper;

public class TemplateModelJSONUtil {
    private static final Pattern CLASS_NAME_MAP_PATTERN = Pattern.compile("\"classNameMap\":\"(.+?)\"classNameMap");
    private static final Pattern ITEMPLATEMODEL_PATTERN = Pattern.compile("\"iTemplateModel\":\"(.+?)\"iTemplateModel");
    public static final IdentityHashMap<Type, ObjectDeserializer> IDENTITY_HASH_MAP = ParserConfig.getGlobalInstance().getDerializers();

    public static String toJSONString(ITemplateModel iTemplateModel) {
        if (Objects.isNull(iTemplateModel)) {
            throw new NullPointerException("iTemplateModel is null");
        }
        HashMap<Class, Class> classNameMap = new HashMap<Class, Class>(16);
        TemplateModelJSONUtil.getObjectClassType(iTemplateModel, classNameMap);
        String classNameMapJson = JSON.toJSONString(classNameMap);
        String classNameMapJsonString = "\"classNameMap\":\"" + classNameMapJson + "\"classNameMap";
        PropertyPreFilters filters = new PropertyPreFilters();
        PropertyPreFilters.MySimplePropertyPreFilter excludefilter = filters.addFilter();
        excludefilter.addExcludes(new String[]{"quoteMembers", "quoteMembersWithScope", "mdxNumber"});
        String iTemplateModelJson = JSON.toJSONString((Object)iTemplateModel, (SerializeFilter)excludefilter, (SerializerFeature[])new SerializerFeature[0]);
        String iTemplateModelJsonString = "\"iTemplateModel\":\"" + iTemplateModelJson + "\"iTemplateModel";
        return classNameMapJsonString + iTemplateModelJsonString;
    }

    public static ITemplateModel parseITemplateModel(String jsonString) {
        return TemplateCache.getTemplate(0L, jsonString);
    }

    public static ITemplateModel $parseITemplateModel(String jsonString) {
        if (StringUtils.isEmpty((String)jsonString)) {
            return null;
        }
        Log log = LogFactory.getLog(TemplateModelJSONUtil.class);
        long time1 = System.currentTimeMillis();
        ITemplateModel templateModel = null;
        if (jsonString.contains("classNameMap")) {
            String classNameMapJson = TemplateModelJSONUtil.getClassNameMapJsonString(jsonString);
            String iTemplateModelJson = TemplateModelJSONUtil.getiTemplateModelJsonString(jsonString);
            HashMap classNameMap = (HashMap)JSON.parseObject((String)classNameMapJson, HashMap.class);
            classNameMap.put("kd.epm.eb.spread.template.dimension.IDimensionMember", "kd.epm.eb.spread.template.dimension.DefaultDimMember");
            classNameMap.put("kd.epm.eb.spread.template.viewpointdim.IViewPointDimensionEntry", "kd.epm.eb.spread.template.viewpointdim.DefaultViewPointDimensionEntry");
            ITemplateParseConfig iTemplateParseConfig = TemplateModelJSONUtil.initITemplateParseConfigClassNameMap(classNameMap);
            templateModel = (ITemplateModel)JSON.parseObject((String)iTemplateModelJson, ITemplateModel.class, (ParserConfig)iTemplateParseConfig, (int)JSON.DEFAULT_PARSER_FEATURE, (Feature[])new Feature[0]);
            if (templateModel instanceof Proxy) {
                classNameMapJson = classNameMapJson.replaceAll("kd.epm.eb.business.template", "kd.epm.eb.spread.template");
                classNameMap = (HashMap)JSON.parseObject((String)classNameMapJson, HashMap.class);
                iTemplateParseConfig = TemplateModelJSONUtil.initITemplateParseConfigClassNameMap(classNameMap);
                templateModel = (ITemplateModel)JSON.parseObject((String)iTemplateModelJson, ITemplateModel.class, (ParserConfig)iTemplateParseConfig, (int)JSON.DEFAULT_PARSER_FEATURE, (Feature[])new Feature[0]);
            }
            TemplateModelJSONUtil.afterParseObject(templateModel);
        } else {
            templateModel = FixtemplateSerializerUtil.read(jsonString);
        }
        long time2 = System.currentTimeMillis();
        log.info("TemplateModelJSONUtil.parseITemplateModel \u7528\u65f6= " + (time2 - time1) + " length=" + jsonString.length());
        return templateModel;
    }

    private static void afterParseObject(ITemplateModel templateModel) {
        IAreaRangeEntry areaRangeEntry;
        IAreaRangeEntry iAreaRangeEntry = areaRangeEntry = templateModel == null ? null : templateModel.getAreaRangeEntry();
        if (areaRangeEntry != null) {
            ArrayList<IHeaderInfo> headerInfos;
            if ((areaRangeEntry.getRowHeaders() == null || areaRangeEntry.getRowHeaders().isEmpty()) && areaRangeEntry.getRowdimensions() != null) {
                headerInfos = new ArrayList<IHeaderInfo>(16);
                areaRangeEntry.setRowHeaders(headerInfos);
                areaRangeEntry.getRowdimensions().forEach(d -> {
                    headerInfos.add(new HeaderInfo("Dimension", d.getNumber()));
                    if (d.getPropertyEntries() != null && d.getPropertyEntries().size() > 0) {
                        d.getPropertyEntries().forEach(p -> headerInfos.add(new HeaderInfo(p.getId(), p.getNumber(), p.getName(), "Property", d.getNumber(), DimPropertyHelper.getPropertySign(p.getNumber(), p.getDseq() + "", "t"))));
                    }
                });
            }
            if ((areaRangeEntry.getColHeaders() == null || areaRangeEntry.getColHeaders().isEmpty()) && areaRangeEntry.getColdimensions() != null) {
                headerInfos = new ArrayList(16);
                areaRangeEntry.setColHeaders(headerInfos);
                areaRangeEntry.getColdimensions().forEach(d -> {
                    headerInfos.add(new HeaderInfo("Dimension", d.getNumber()));
                    if (d.getPropertyEntries() != null && d.getPropertyEntries().size() > 0) {
                        d.getPropertyEntries().forEach(p -> headerInfos.add(new HeaderInfo(p.getId(), p.getNumber(), p.getName(), "Property", d.getNumber(), DimPropertyHelper.getPropertySign(p.getNumber(), p.getDseq() + "", "t"))));
                    }
                });
            }
        }
    }

    private static void getObjectClassType(Object obj, HashMap<Class, Class> classNameMap) {
        block8: {
            Field[] declaredFields;
            Class<?> aClass;
            block11: {
                block10: {
                    Object o1;
                    Collection o2;
                    block9: {
                        if (Objects.isNull(obj)) {
                            return;
                        }
                        aClass = obj.getClass();
                        for (Class clazz : classNameMap.values()) {
                            if (aClass.equals(clazz)) break;
                        }
                        if (!TemplateModelJSONUtil.isPrimitive(aClass)) break block8;
                        if (!List.class.isAssignableFrom(aClass)) break block9;
                        o2 = (List)obj;
                        if (o2.size() <= 0) break block8;
                        o1 = o2.get(0);
                        TemplateModelJSONUtil.getObjectClassType(o1, classNameMap);
                        break block8;
                    }
                    if (!Set.class.isAssignableFrom(aClass)) break block10;
                    o2 = (Set)obj;
                    if (o2.size() <= 0) break block8;
                    o1 = o2.iterator().next();
                    TemplateModelJSONUtil.getObjectClassType(o1, classNameMap);
                    break block8;
                }
                if (!Map.class.isAssignableFrom(aClass)) break block11;
                Class<?>[] o1 = (Class<?>[])obj;
                if (o1.size() <= 0) break block8;
                for (Object o2 : o1.keySet()) {
                    TemplateModelJSONUtil.getObjectClassType(o2, classNameMap);
                }
                for (Object value : o1.values()) {
                    TemplateModelJSONUtil.getObjectClassType(value, classNameMap);
                }
                break block8;
            }
            for (Class<?> anInterface : aClass.getInterfaces()) {
                if (!Objects.isNull(classNameMap.get(anInterface)) || !Objects.isNull(IDENTITY_HASH_MAP.get(aClass))) continue;
                classNameMap.put(anInterface, aClass);
            }
            for (Field declaredField : declaredFields = aClass.getDeclaredFields()) {
                ReflectionUtils.makeAccessible((Field)declaredField);
                try {
                    Object o = declaredField.get(obj);
                    TemplateModelJSONUtil.getObjectClassType(o, classNameMap);
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
        }
    }

    private static boolean isPrimitive(Class<?> clazz) {
        return !clazz.isPrimitive() && clazz != Boolean.class && clazz != Character.class && clazz != Byte.class && clazz != Short.class && clazz != Integer.class && clazz != Long.class && clazz != Float.class && clazz != Double.class && clazz != BigInteger.class && clazz != BigDecimal.class && clazz != String.class && clazz != java.util.Date.class && clazz != Date.class && clazz != Time.class && clazz != Timestamp.class && !clazz.isEnum();
    }

    private static String getClassNameMapJsonString(String jsonString) {
        Matcher classNameMapMatcher = CLASS_NAME_MAP_PATTERN.matcher(jsonString);
        if (classNameMapMatcher.find()) {
            return classNameMapMatcher.group(1);
        }
        throw new NullPointerException(ResManager.loadKDString((String)"jsonString\u683c\u5f0f\u6709\u8bef\uff0c\u65e0\u6cd5\u627e\u5230classNameMap\u683c\u5f0f\u4e32\u3002", (String)"TemplateModelJSONUtil_0", (String)"epm-eb-spread", (Object[])new Object[0]));
    }

    private static String getiTemplateModelJsonString(String jsonString) {
        Matcher iTemplateModelMatcher = ITEMPLATEMODEL_PATTERN.matcher(jsonString);
        if (iTemplateModelMatcher.find()) {
            return iTemplateModelMatcher.group(1);
        }
        throw new NullPointerException(ResManager.loadKDString((String)"jsonString\u683c\u5f0f\u6709\u8bef\uff0c\u65e0\u6cd5\u627e\u5230iTemplateModel\u683c\u5f0f\u4e32\u3002", (String)"TemplateModelJSONUtil_1", (String)"epm-eb-spread", (Object[])new Object[0]));
    }

    private static ITemplateParseConfig initITemplateParseConfigClassNameMap(HashMap classNameMap) {
        ITemplateParseConfig iTemplateParseConfig = new ITemplateParseConfig();
        for (Map.Entry o : classNameMap.entrySet()) {
            try {
                Class<?> aClass = Class.forName((String)o.getKey());
                Class<?> aClass1 = Class.forName((String)o.getValue());
                iTemplateParseConfig.getClassNameMap().put(aClass, aClass1);
            }
            catch (ClassNotFoundException classNotFoundException) {}
        }
        return iTemplateParseConfig;
    }

    public static String toJSONString(Object obj) {
        if (Objects.isNull(obj)) {
            throw new NullPointerException("iTemplateModel is null");
        }
        HashMap<Class, Class> classNameMap = new HashMap<Class, Class>(16);
        TemplateModelJSONUtil.getObjectClassType(obj, classNameMap);
        String classNameMapJson = JSON.toJSONString(classNameMap);
        String classNameMapJsonString = "\"classNameMap\":\"" + classNameMapJson + "\"classNameMap";
        String iTemplateModelJson = JSON.toJSONString((Object)obj);
        String iTemplateModelJsonString = "\"iTemplateModel\":\"" + iTemplateModelJson + "\"iTemplateModel";
        return classNameMapJsonString + iTemplateModelJsonString;
    }
}

