/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.template;

import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import kd.bos.algo.DataSet;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.mutex.DataMutex;
import kd.bos.mutex.impl.MutexFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.UserUtils;

public class TemplateMutexServiceHelper {
    private static final String ENTITY_KEY = "eb_templateentity";
    private static final String OPERATION_KEY = "alter";
    private static final String separation = "!!";
    private static final long LOCK_KEEP_TIME_MS = Long.parseLong(System.getProperty("mutex.maxkeeptime_h", "8")) * 60L * 60L * 1000L;
    private static final String APPLYTEMPLATE_KEY = "eb_applytemplate";

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean lock(Long templateId, Long model) {
        try (DataMutex dataMutex = MutexFactory.createDataMutex();){
            boolean bl = dataMutex.require(String.valueOf(templateId), String.valueOf(model), ENTITY_KEY, OPERATION_KEY, true);
            return bl;
        }
        catch (IOException ex) {
            throw new RuntimeException("IOException when closing data mutex!", ex);
        }
    }

    public static boolean lockwithTips(Long templateId, Long model) {
        Boolean success = TemplateMutexServiceHelper.lock(templateId, model);
        if (!success.booleanValue()) {
            Map<String, String> lockinfo = TemplateMutexServiceHelper.getLockInfo(templateId, model);
            TemplateMutexServiceHelper.showTips(lockinfo, templateId);
        }
        return success;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static boolean unlock(Long templateId, Long model) {
        Map<String, String> lockinfo = TemplateMutexServiceHelper.getLockInfo(templateId, model);
        String userid = lockinfo.get("userid");
        if (userid == null) return false;
        if (!userid.equals(UserUtils.getUserId().toString())) return false;
        try (DataMutex dataMutex = MutexFactory.createDataMutex();){
            boolean bl = dataMutex.release(String.valueOf(templateId), ENTITY_KEY, OPERATION_KEY);
            return bl;
        }
        catch (IOException ex) {
            throw new RuntimeException("IOException when closing data mutex!", ex);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> getLockInfo(Long templateId, Long model) {
        try (DataMutex dataMutex = MutexFactory.createDataMutex();){
            Map lockinfo = dataMutex.getLockInfo(String.valueOf(templateId), String.valueOf(model), ENTITY_KEY);
            Map map = lockinfo = lockinfo == null ? Collections.emptyMap() : lockinfo;
            return map;
        }
        catch (IOException ex) {
            throw new RuntimeException("IOException when closing data mutex!", ex);
        }
    }

    public static void checkIsLock(Long templateId, Long model) {
        Map<String, String> lockinfo = TemplateMutexServiceHelper.getLockInfo(templateId, model);
        if (lockinfo == null || lockinfo.size() == 0) {
            return;
        }
        String lockTime = lockinfo.get("lockedTime");
        if (System.currentTimeMillis() - Long.parseLong(lockTime) > LOCK_KEEP_TIME_MS) {
            TemplateMutexServiceHelper.unlock(templateId, model);
        } else {
            TemplateMutexServiceHelper.showTips(lockinfo, templateId);
        }
    }

    public static void checkOtherIsLock(Long templatenumber, Long model) {
        Map<String, String> lockinfo = TemplateMutexServiceHelper.getLockInfo(templatenumber, model);
        if (lockinfo == null || lockinfo.size() == 0) {
            return;
        }
        if (!UserUtils.getUserId().toString().equals(lockinfo.get("userid"))) {
            String lockTime = lockinfo.get("lockedTime");
            if (System.currentTimeMillis() - Long.parseLong(lockTime) > LOCK_KEEP_TIME_MS) {
                TemplateMutexServiceHelper.unlock(templatenumber, model);
            } else {
                TemplateMutexServiceHelper.showTips(lockinfo, templatenumber);
            }
        }
    }

    public static String getOrgNameById(Long orgid) {
        QFilter filter = new QFilter("id", "=", (Object)orgid);
        String username = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)TemplateMutexServiceHelper.class.getName(), (String)"bos_user", (String)"name", (QFilter[])new QFilter[]{filter}, null);){
            while (dataSet.hasNext()) {
                username = dataSet.next().getString("name");
            }
        }
        return username;
    }

    public static void showTips(Map<String, String> lockinfo, String templatenumber) {
        if (lockinfo == null || lockinfo.size() == 0) {
            return;
        }
        String username = TemplateMutexServiceHelper.getOrgNameById(IDUtils.toLong((Object)lockinfo.get("userid")));
        StringBuilder sb = new StringBuilder();
        String msg = username == null ? ResManager.loadResFormat((String)"\u7f16\u7801\u4e3a%1\u7684\u6a21\u677f\u6b63\u5728\u88ab\u7528\u6237id\u4e3a%2\u7684\u7528\u6237\u4f7f\u7528\uff0c\u8bf7\u5148\u8010\u5fc3\u7b49\u5f85\uff0c\u6025\u7528\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5230\u7cfb\u7edf\u7ba1\u7406-\u7f51\u7edc\u4e92\u65a5\u4e2d\u89e3\u9501\u3002", (String)"TemplateMutexServiceHelper_2", (String)"epm-eb-spread", (Object[])new Object[]{templatenumber, lockinfo.get("userid")}) : ResManager.loadResFormat((String)"\u7f16\u7801\u4e3a%1\u7684\u6a21\u677f\u6b63\u5728\u88ab\u7528\u6237%2\u4f7f\u7528\uff0c\u8bf7\u5148\u8010\u5fc3\u7b49\u5f85\uff0c\u6025\u7528\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5230\u7cfb\u7edf\u7ba1\u7406-\u7f51\u7edc\u4e92\u65a5\u4e2d\u89e3\u9501\u3002", (String)"TemplateMutexServiceHelper_3", (String)"epm-eb-spread", (Object[])new Object[]{templatenumber, username});
        throw new KDBizException(msg);
    }

    public static void showTips(Map<String, String> lockinfo, Long templateId) {
        DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingleFromCache((Object)templateId, (String)ENTITY_KEY, (String)"id,number");
        if (dynamicObject != null) {
            TemplateMutexServiceHelper.showTips(lockinfo, dynamicObject.getString("number"));
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Map<String, String> getApplyTemplateLockInfo(String templatenumber, Long model) {
        try (DataMutex dataMutex = MutexFactory.createDataMutex();){
            Map lockinfo = dataMutex.getLockInfo(templatenumber + separation + model, String.valueOf(model), APPLYTEMPLATE_KEY);
            Map map = lockinfo = lockinfo == null ? Collections.emptyMap() : lockinfo;
            return map;
        }
        catch (IOException ex) {
            throw new RuntimeException("IOException when closing data mutex!", ex);
        }
    }

    public static void checkApplytemplateIsLock(Long templateId, Long model) {
        Map<String, String> lockinfo = TemplateMutexServiceHelper.getApplyTemplateLockInfo(templateId + "", model);
        if (lockinfo == null || lockinfo.size() == 0) {
            return;
        }
        String lockTime = lockinfo.get("lockedTime");
        if (System.currentTimeMillis() - Long.parseLong(lockTime) > LOCK_KEEP_TIME_MS) {
            TemplateMutexServiceHelper.unlock(templateId, model);
        } else {
            TemplateMutexServiceHelper.showTips(lockinfo, templateId + "");
        }
    }
}

