/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.template;

import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.ebcommon.common.enums.DetailTypeEnum;
import kd.epm.eb.common.enums.SpreadTypeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.ebBusiness.serviceHelper.QueryMemberDetailsHelper;
import kd.epm.eb.ebBusiness.template.model.Dimension;
import kd.epm.eb.ebBusiness.template.model.PageDimPropEntry;
import kd.epm.eb.ebBusiness.template.model.PageDimensionEntry;
import kd.epm.eb.ebBusiness.template.model.TemplateModel;
import kd.epm.eb.spread.template.ITemplateModel;

public class TemplateSetBaseVarUtil {
    public static final String P_M_01_PREFIX = "M_M";
    private static final Log log = LogFactory.getLog(TemplateSetBaseVarUtil.class);
    private static final String CONTROL_YEAR = "year";
    private static final String CONTROL_PERIOD = "period";
    private static final String CONTROL_TYPE = "datatype";
    private static final String CONTROL_VERSION = "version";
    private static final String CON_CELLVALUE_SPLITKEY = ";";
    private static final String DIMTYPE_YEAR = SysDimensionEnum.Year.getNumber();
    private static final String DIMTYPE_TYPE = SysDimensionEnum.DataType.getNumber();
    private static final String DIMTYPE_VERSION = SysDimensionEnum.Version.getNumber();
    private static final String CON_YEARVARPREFIX = "@Y";
    private static final String CON_VARPREFIX = "@";
    private static final String CON_MAPELEMENT_NUMBER_BASE = "number_base";
    private static final String CON_MAPELEMENT_ID_REPLEASE = "id_re";
    private static final String CON_MAPELEMENT_NUMBER_REPLEASE = "number_re";
    private static final String CON_MAPELEMENT_NAME_REPLEASE = "name_re";
    private static final String CON_VARREFIX = "rO";

    private static String getNewVarPreFix(String dimKey) {
        String strReturn = "";
        if (dimKey.equalsIgnoreCase(SysDimensionEnum.Entity.getNumber())) {
            strReturn = SysDimensionEnum.Entity.getShortNumber();
        } else if (dimKey.equalsIgnoreCase(SysDimensionEnum.Account.getNumber())) {
            strReturn = SysDimensionEnum.Account.getShortNumber();
        } else if (dimKey.equalsIgnoreCase(SysDimensionEnum.AuditTrail.getNumber())) {
            strReturn = SysDimensionEnum.AuditTrail.getShortNumber();
        } else if (dimKey.equalsIgnoreCase(SysDimensionEnum.ChangeType.getNumber())) {
            strReturn = SysDimensionEnum.ChangeType.getShortNumber();
        } else if (dimKey.equalsIgnoreCase(SysDimensionEnum.InternalCompany.getNumber())) {
            strReturn = SysDimensionEnum.InternalCompany.getShortNumber();
        } else if (dimKey.equalsIgnoreCase(SysDimensionEnum.DataType.getNumber())) {
            strReturn = SysDimensionEnum.DataType.getShortNumber();
        }
        strReturn = CON_VARPREFIX + strReturn;
        return strReturn;
    }

    private static String getReplacedForTypeAndVertion(String strBaseValue, String cellValue, String strDimType, Map<String, Map<String, String[]>> sysDimMap, Map<String, String[]> taskDimMap, Boolean isView, Boolean isDimName, Long modelID, Map<String, String> newValueMap) {
        Member structOfMember;
        kd.epm.eb.common.cache.impl.Dimension dimension;
        String strNewCellValue = cellValue;
        String strBaseName = null;
        IModelCacheHelper modelcache = ModelCacheContext.getOrCreate((Long)modelID);
        if (modelcache != null && (dimension = modelcache.getDimension(strDimType)) != null && (structOfMember = dimension.getStructOfMember(strBaseValue)) != null) {
            strBaseName = structOfMember.getName();
        }
        if (strBaseName == null) {
            return strNewCellValue;
        }
        String strVarPreFix = TemplateSetBaseVarUtil.getNewVarPreFix(strDimType);
        Map<String, String[]> sysDim = sysDimMap.get(strDimType);
        if (sysDim == null) {
            return strNewCellValue;
        }
        strBaseName = sysDim.get(strBaseValue)[0];
        String strBaseNumber = strBaseValue;
        Boolean isCellEquelCurrent = true;
        isCellEquelCurrent = isDimName != false ? Boolean.valueOf(cellValue.equalsIgnoreCase(strBaseName)) : Boolean.valueOf(cellValue.equalsIgnoreCase(strBaseNumber));
        if (isCellEquelCurrent.booleanValue()) {
            switch (strDimType.toLowerCase(Locale.getDefault())) {
                case "datatype": 
                case "version": {
                    strNewCellValue = isView != false ? strVarPreFix : (isDimName != false ? taskDimMap.get(strDimType.toLowerCase())[1] : taskDimMap.get(strDimType.toLowerCase())[0]);
                    break;
                }
                default: {
                    strNewCellValue = isView != false ? strVarPreFix : (isDimName != false ? newValueMap.get(CON_MAPELEMENT_NUMBER_REPLEASE) : newValueMap.get(CON_MAPELEMENT_NAME_REPLEASE));
                }
            }
        }
        log.info("var_getReplacedForTypeAndVertion:oldvalue :" + cellValue + "newvalue:" + strNewCellValue);
        return strNewCellValue;
    }

    private static String doYearValueForFY(String s) {
        if (s != null && s.contains(SysDimensionEnum.Year.getShortNumber()) && s.length() > 4 && StringUtils.isNumeric((String)s.substring(SysDimensionEnum.Year.getShortNumber().length(), SysDimensionEnum.Year.getShortNumber().length() + 4))) {
            return s.substring(SysDimensionEnum.Year.getShortNumber().length(), SysDimensionEnum.Year.getShortNumber().length() + 4);
        }
        return "";
    }

    private static String getInvaliadDimInfo(List<String> strLst) {
        if (strLst == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder();
        for (String str : strLst) {
            if (!StringUtils.isNotEmpty((String)str)) continue;
            sb.append(str).append(',');
        }
        if (sb.length() > 0) {
            sb.setLength(sb.length() - 1);
            return sb.toString();
        }
        return "";
    }

    private static int getPianYi(int baseYearVar, int cellYear) {
        return cellYear - baseYearVar;
    }

    private static String getPianYiString(int iPanYi) {
        String postFix = "";
        if (iPanYi != 0) {
            postFix = iPanYi > 0 ? "+" + iPanYi : "" + iPanYi;
        }
        return postFix;
    }

    private static String getNewShowValueForYear(int baseYearVar, String cellValue, String strDimType, Map<String, Map<String, String[]>> sysDimMap, Map<String, String[]> taskDimMap, Boolean isView, Boolean isDimName) {
        int iCellYear = 0;
        int iPanYi = 0;
        int iNewValue = 0;
        String strNewCellValue = cellValue;
        String strNewCellValueNumber = "";
        log.info("var_getNewShowValueForYear :" + cellValue);
        iCellYear = isDimName != false ? Integer.parseInt(StringUtils.isEmpty((String)TemplateSetBaseVarUtil.doYearValue(cellValue)) ? "0" : TemplateSetBaseVarUtil.doYearValue(cellValue)) : Integer.parseInt(StringUtils.isEmpty((String)TemplateSetBaseVarUtil.doYearValueForFY(cellValue)) ? "0" : TemplateSetBaseVarUtil.doYearValueForFY(cellValue));
        if (iCellYear == 0) {
            return strNewCellValue;
        }
        iPanYi = TemplateSetBaseVarUtil.getPianYi(baseYearVar, iCellYear);
        String postFix = TemplateSetBaseVarUtil.getPianYiString(iPanYi);
        if (isView.booleanValue()) {
            strNewCellValue = CON_YEARVARPREFIX + postFix + (isDimName != false ? ResManager.loadKDString((String)"\u5e74", (String)"TemplateSetBaseVarUtil_0", (String)"epm-eb-spread", (Object[])new Object[0]) : "");
        } else {
            iNewValue = Integer.parseInt(taskDimMap.get(strDimType)[0].substring("FY".length())) + iPanYi;
            strNewCellValueNumber = "FY" + iNewValue;
            strNewCellValue = sysDimMap.get(strDimType).containsKey(strNewCellValueNumber) ? (isDimName.booleanValue() ? ResManager.loadResFormat((String)"%1\u5e74", (String)"TemplateSetBaseVarUtil_2", (String)"epm-eb-spread", (Object[])new Object[]{iNewValue}) : "FY" + iNewValue) : cellValue;
        }
        log.info("var_getNewShowValueForYear:oldYearvalue :" + cellValue + "newYearvalue:" + strNewCellValue);
        return strNewCellValue;
    }

    private static String getNewShowValueForPeriod(int basePeriodVar, String cellValue, String strDimType, Map<String, Map<String, String>> newVarDimMap, Boolean isView, Boolean isDimName) {
        int iCellPeriod = 0;
        int iPanYi = 0;
        int iNewValue = 0;
        String strNewCellValue = cellValue;
        String strNewCellValueNumber = "";
        log.info("var_getNewShowValueForPeriod :" + cellValue);
        iCellPeriod = isDimName != false ? Integer.parseInt(cellValue.substring(0, cellValue.length() - 1)) : Integer.parseInt(cellValue.substring(P_M_01_PREFIX.length()));
        if (iCellPeriod == 0) {
            return strNewCellValue;
        }
        iPanYi = TemplateSetBaseVarUtil.getPianYi(basePeriodVar, iCellPeriod);
        String postFix = TemplateSetBaseVarUtil.getPianYiString(iPanYi);
        if (isView.booleanValue()) {
            strNewCellValue = CON_YEARVARPREFIX + postFix + (isDimName != false ? ResManager.loadKDString((String)"\u6708", (String)"TemplateSetBaseVarUtil_1", (String)"epm-eb-spread", (Object[])new Object[0]) : "");
        } else {
            iNewValue = iCellPeriod + iPanYi;
            strNewCellValueNumber = iNewValue > 10 ? P_M_01_PREFIX + iNewValue : "M_M0" + iNewValue;
            strNewCellValue = isDimName != false ? ResManager.loadResFormat((String)"%1\u6708", (String)"TemplateSetBaseVarUtil_3", (String)"epm-eb-spread", (Object[])new Object[]{iNewValue}) : strNewCellValueNumber;
        }
        log.info("var_getNewShowValueForPeriod:oldPeriodvalue :" + cellValue + "newPeriodValue:" + strNewCellValue);
        return strNewCellValue;
    }

    private static Map<String, String[]> getSingleDimMap(String sFormID, long modelID, Map<String, String> varDimMap) {
        if (varDimMap == null || varDimMap.size() == 0) {
            return null;
        }
        HashMap<String, String[]> sysDimMap = new HashMap<String, String[]>();
        QFilter qFilter = new QFilter("model", "=", (Object)modelID);
        switch (sFormID) {
            case "epm_datatypemembertree": {
                String strTypeNumber = varDimMap.get(DIMTYPE_TYPE);
                if (strTypeNumber == null || strTypeNumber.length() <= 0) break;
                qFilter = qFilter.and(new QFilter("number", "=", (Object)strTypeNumber));
                break;
            }
            case "epm_versionmembertree": {
                String strVerNumber = varDimMap.get(DIMTYPE_VERSION);
                if (strVerNumber == null || strVerNumber.length() <= 0) break;
                qFilter = qFilter.and(new QFilter("number", "=", (Object)strVerNumber));
                break;
            }
        }
        try (DataSet result = QueryServiceHelper.queryDataSet((String)sFormID, (String)sFormID, (String)"id,number,name ", (QFilter[])new QFilter[]{qFilter}, null);){
            for (Row memberRow : result) {
                sysDimMap.put(memberRow.getString("number"), new String[]{memberRow.getString("name"), memberRow.getString("id")});
            }
        }
        return sysDimMap;
    }

    private static String getReplaceValueForDynamicReport(String strDimType, String cellValue, ITemplateModel templateModel, Map<String, String[]> taskDimMap, Map<String, Map<String, String[]>> sysDimMap, Boolean isDimName) {
        String strNewCellValue = cellValue;
        String spreadType = templateModel.getTemplateBaseInfo().getSpreadType();
        Boolean isView = spreadType.equalsIgnoreCase(SpreadTypeEnum.SPREADTYPE_VIEW.getIndex());
        if (!(isView.booleanValue() || taskDimMap != null && taskDimMap.get(strDimType) != null)) {
            return strNewCellValue;
        }
        Map<String, String> baseVarMap = TemplateSetBaseVarUtil.getVarBaseMapFromString(templateModel.getTemplateBaseInfo().getVarBase());
        if (baseVarMap == null || baseVarMap.size() == 0) {
            return strNewCellValue;
        }
        Map<Object, Object> baseNewVarMap = new HashMap();
        if (TemplateSetBaseVarUtil.isNewVarStyle(templateModel.getTemplateBaseInfo().getVarBase()).booleanValue()) {
            baseNewVarMap = TemplateSetBaseVarUtil.getNewStyleVarMap(templateModel.getTemplateBaseInfo().getVarBase());
        }
        if (baseVarMap.containsKey(strDimType)) {
            String strBaseVarValue = baseVarMap.get(strDimType);
            switch (strDimType.toLowerCase(Locale.getDefault())) {
                case "year": {
                    int baseYearVar;
                    int n = baseYearVar = "".equals(strBaseVarValue) ? 0 : Integer.parseInt(strBaseVarValue);
                    if (baseYearVar <= 0) break;
                    strNewCellValue = TemplateSetBaseVarUtil.getNewShowValueForYear(baseYearVar, cellValue, strDimType, sysDimMap, taskDimMap, isView, isDimName);
                    break;
                }
                case "period": {
                    int basePeriodVar;
                    int n = basePeriodVar = "".equals(strBaseVarValue) ? 0 : Integer.parseInt(strBaseVarValue);
                    if (basePeriodVar <= 0) break;
                    strNewCellValue = TemplateSetBaseVarUtil.getNewShowValueForPeriod(basePeriodVar, cellValue, strDimType, baseNewVarMap, isView, isDimName);
                    break;
                }
                default: {
                    if (strBaseVarValue == null || strBaseVarValue.length() <= 0 || baseNewVarMap.get(strDimType) == null) break;
                    strNewCellValue = TemplateSetBaseVarUtil.getReplacedForTypeAndVertion(strBaseVarValue, cellValue, strDimType, sysDimMap, taskDimMap, isView, isDimName, templateModel.getModelId(), (Map)baseNewVarMap.get(strDimType));
                }
            }
        }
        return strNewCellValue;
    }

    private static void iniSysDimMap(Map<String, String[]> dimSysMap, Member dimMemb) {
        if (dimMemb == null) {
            return;
        }
        dimSysMap.put(dimMemb.getNumber(), new String[]{dimMemb.getName(), dimMemb.getId().toString()});
    }

    public static String doYearValue(String s) {
        if (s != null && s.contains(ResManager.loadKDString((String)"\u5e74", (String)"TemplateSetBaseVarUtil_0", (String)"epm-eb-spread", (Object[])new Object[0])) && s.length() > 4 && StringUtils.isNumeric((String)s.substring(0, 4))) {
            return s.substring(0, 4);
        }
        return "";
    }

    public static String getCtrlKey(String dimKey) {
        String strReturn = "";
        if (dimKey.equalsIgnoreCase(SysDimensionEnum.Entity.getNumber())) {
            strReturn = SysDimensionEnum.Entity.getMemberTreemodel();
        } else if (dimKey.equalsIgnoreCase(SysDimensionEnum.Account.getNumber())) {
            strReturn = SysDimensionEnum.Account.getMemberTreemodel();
        } else if (dimKey.equalsIgnoreCase(SysDimensionEnum.AuditTrail.getNumber())) {
            strReturn = SysDimensionEnum.AuditTrail.getMemberTreemodel();
        } else if (dimKey.equalsIgnoreCase(SysDimensionEnum.ChangeType.getNumber())) {
            strReturn = SysDimensionEnum.ChangeType.getMemberTreemodel();
        } else if (dimKey.equalsIgnoreCase(SysDimensionEnum.InternalCompany.getNumber())) {
            strReturn = SysDimensionEnum.InternalCompany.getMemberTreemodel();
        } else if (dimKey.equalsIgnoreCase(SysDimensionEnum.DataType.getNumber())) {
            strReturn = SysDimensionEnum.DataType.getMemberTreemodel();
        } else if (dimKey.equalsIgnoreCase(SysDimensionEnum.Year.getNumber())) {
            strReturn = SysDimensionEnum.Year.getMemberTreemodel();
        } else if (dimKey.equalsIgnoreCase(SysDimensionEnum.Period.getNumber())) {
            strReturn = SysDimensionEnum.Period.getMemberTreemodel();
        } else if (dimKey.equalsIgnoreCase(SysDimensionEnum.Version.getNumber())) {
            strReturn = SysDimensionEnum.Version.getMemberTreemodel();
        }
        return strReturn;
    }

    public static Map<String, String> getDimScopMap(String dimKey, long modelID, List<QFilter> qFilter) {
        HashMap<String, String> sysDimMap = new HashMap<String, String>();
        if (qFilter == null || qFilter.size() == 0) {
            return sysDimMap;
        }
        String sFormID = TemplateSetBaseVarUtil.getCtrlKey(dimKey);
        QFilter[] qfilter = new QFilter[qFilter.size()];
        try (DataSet result = QueryServiceHelper.queryDataSet((String)sFormID, (String)sFormID, (String)"id,number,name ", (QFilter[])qFilter.toArray(qfilter), null);){
            for (Row memberRow : result) {
                sysDimMap.put(memberRow.getString("number"), memberRow.getString("name"));
            }
        }
        return sysDimMap;
    }

    public static Map<String, Map<String, String>> getNewStyleVarMap(String strVarString) {
        if (strVarString == null || strVarString.length() == 0) {
            return Collections.emptyMap();
        }
        Map map = (Map)ObjectSerialUtil.deSerializedBytes((String)strVarString);
        return map;
    }

    public static Map<String, String> getVarBaseMapFromNewStyleMap(Map<String, Map<String, String>> newVarMap) {
        if (newVarMap == null) {
            return null;
        }
        HashMap<String, String> mapReturn = new HashMap<String, String>(newVarMap.size());
        for (Map.Entry<String, Map<String, String>> dimKey : newVarMap.entrySet()) {
            String dim = dimKey.getKey().toLowerCase();
            mapReturn.put(dim, dimKey.getValue().get(CON_MAPELEMENT_NUMBER_BASE));
        }
        return mapReturn;
    }

    public static Boolean isNewVarStyle(String baseVarString) {
        return false;
    }

    public static Map<String, String> getVarBaseMapFromString(Object strVarString) {
        if (strVarString == null) {
            return Collections.emptyMap();
        }
        HashMap<String, String> map = new HashMap<String, String>();
        if (TemplateSetBaseVarUtil.isNewVarStyle(strVarString.toString()).booleanValue()) {
            return TemplateSetBaseVarUtil.getVarBaseMapFromNewStyleMap(TemplateSetBaseVarUtil.getNewStyleVarMap(strVarString.toString()));
        }
        if (strVarString != null && strVarString.toString().trim().length() > 0) {
            String[] values = strVarString.toString().trim().split(CON_CELLVALUE_SPLITKEY);
            for (int i = 0; i < values.length; ++i) {
                String value = values[i].trim();
                if (value.indexOf(":") <= 0 || value.indexOf(":") >= value.length() || value.substring(value.indexOf(":") + 1) == null || value.substring(value.indexOf(":") + 1).length() <= 0) continue;
                map.put(value.substring(0, value.indexOf(":")), value.substring(value.indexOf(":") + 1));
            }
        }
        return map;
    }

    public static String getVarBaseValueFromString(String saveMapkey, Object strVarString) {
        Map<String, String> map;
        if (strVarString != null && strVarString.toString().length() > 0 && (map = TemplateSetBaseVarUtil.getVarBaseMapFromString(strVarString)) != null) {
            String saveVar = map.get(saveMapkey);
            return StringUtils.isNotEmpty((String)saveVar) ? saveVar : "";
        }
        return "";
    }

    public static Map<String, String[]> getTaskListDimInfo(String taskListID, Map<String, String[]> taskDim) {
        if (taskDim != null) {
            return taskDim;
        }
        if (StringUtils.isEmpty((String)taskListID)) {
            return null;
        }
        HashMap<String, String[]> dimMap = new HashMap<String, String[]>();
        QFilter qFilter = new QFilter("id", "=", (Object)taskListID);
        try (DataSet result = QueryServiceHelper.queryDataSet((String)"eb_tasklist", (String)"eb_tasklist", (String)"id,year.number FYNumber,year.name FYName ,year.id FYid,  version.number FVerNumber,version.name FVerName,version.id FVerid,datatype.number FDTNumber,datatype.name FDTName,datatype.id FDTid  ", (QFilter[])new QFilter[]{qFilter}, null);){
            for (Row memberRow : result) {
                dimMap.put(DIMTYPE_YEAR, new String[]{memberRow.getString("FYNumber"), memberRow.getString("FYName"), memberRow.getString("FYid")});
                dimMap.put(DIMTYPE_VERSION, new String[]{memberRow.getString("FVerNumber"), memberRow.getString("FVerName"), memberRow.getString("FVerid")});
                dimMap.put(DIMTYPE_TYPE, new String[]{memberRow.getString("FDTNumber"), memberRow.getString("FDTName"), memberRow.getString("FDTid")});
            }
        }
        return dimMap;
    }

    public static Map<String, Set<Member>> getNewAllDimension(Map<String, Set<Member>> oldDimMembers, ITemplateModel templateModel, String strtaskDimMap, String strsysDimMap) {
        HashMap<String, String[]> taskDimMap = new HashMap();
        Map<String, Map<String, String[]>> sysDimMap = new HashMap();
        if (strsysDimMap == null) {
            return oldDimMembers;
        }
        sysDimMap = (Map)ObjectSerialUtil.deSerializedBytes((String)strsysDimMap);
        if (strtaskDimMap != null) {
            taskDimMap = (Map)ObjectSerialUtil.deSerializedBytes((String)strtaskDimMap);
        }
        log.info("var_getNewAllDimension_getSpreadType :" + templateModel.getTemplateBaseInfo().getSpreadType());
        HashMap<String, Set<Member>> newAllDimension = new HashMap<String, Set<Member>>(oldDimMembers.size());
        if (sysDimMap == null || sysDimMap.size() == 0) {
            return oldDimMembers;
        }
        log.info("var_getNewAllDimension_getTaskDimMap :" + templateModel.getTemplateBaseInfo().getTaskDimMap());
        for (Map.Entry<String, Set<Member>> entry : oldDimMembers.entrySet()) {
            String dimkey = entry.getKey();
            LinkedHashSet<Member> oneDimension_members = new LinkedHashSet<Member>(entry.getValue().size());
            Iterator<Member> iterator = entry.getValue().iterator();
            while (iterator.hasNext()) {
                Member oneMember;
                Member newMem = oneMember = iterator.next();
                String cellDim = oneMember.getDimension().getNumber();
                newMem.setName(TemplateSetBaseVarUtil.getReplaceValueForDynamicReport(cellDim, oneMember.getName(), templateModel, taskDimMap, sysDimMap, true));
                newMem.setNumber(TemplateSetBaseVarUtil.getReplaceValueForDynamicReport(cellDim, oneMember.getNumber(), templateModel, taskDimMap, sysDimMap, false));
                oneDimension_members.add(newMem);
            }
            newAllDimension.put(dimkey, oneDimension_members);
        }
        return newAllDimension;
    }

    public static Map<String, Set<String>> getNewAllDimension_All(Map<String, Set<String>> oldDimMembers, ITemplateModel templateModel, String strtaskDimMap, String strsysDimMap) {
        HashMap<String, String[]> taskDimMap = new HashMap();
        HashMap<String, Map<String, String[]>> sysDimMap = new HashMap();
        if (strsysDimMap == null) {
            return oldDimMembers;
        }
        sysDimMap = (Map)ObjectSerialUtil.deSerializedBytes((String)strsysDimMap);
        if (strtaskDimMap != null) {
            taskDimMap = (Map)ObjectSerialUtil.deSerializedBytes((String)strtaskDimMap);
        }
        log.info("var_getNewAllDimension_All_getSpreadType :" + templateModel.getTemplateBaseInfo().getSpreadType());
        HashMap<String, Set<String>> newAllDimension = new HashMap<String, Set<String>>(oldDimMembers.size());
        log.info("var_getNewAllDimension_All_getTaskDimMap :" + templateModel.getTemplateBaseInfo().getSysDimMap());
        for (Map.Entry<String, Set<String>> entry : oldDimMembers.entrySet()) {
            String dimkey = entry.getKey();
            LinkedHashSet<String> oneDimension_members = new LinkedHashSet<String>(entry.getValue().size());
            for (String strNumber : entry.getValue()) {
                oneDimension_members.add(TemplateSetBaseVarUtil.getReplaceValueForDynamicReport(dimkey, strNumber, templateModel, taskDimMap, sysDimMap, false));
            }
            newAllDimension.put(dimkey, oneDimension_members);
        }
        return newAllDimension;
    }

    public static Long doPageDimControlInValid(ITemplateModel templateModel, String dimKey, Long dimID, List<Long> scop) {
        Long lngReturn = dimID;
        String strVarBase = templateModel.getTemplateBaseInfo().getVarBase();
        Map<String, String> baseVarMap = TemplateSetBaseVarUtil.getVarBaseMapFromString(strVarBase);
        if (baseVarMap == null || baseVarMap.size() == 0 || !baseVarMap.containsKey(dimKey)) {
            return lngReturn;
        }
        String strsysDimMap = templateModel.getTemplateBaseInfo().getSysDimMap();
        String strtaskDimMap = templateModel.getTemplateBaseInfo().getTaskDimMap();
        if (strtaskDimMap == null) {
            return lngReturn;
        }
        Map taskDimMap = new HashMap();
        Map sysDimMap = new HashMap();
        sysDimMap = (Map)ObjectSerialUtil.deSerializedBytes((String)strsysDimMap);
        taskDimMap = (Map)ObjectSerialUtil.deSerializedBytes((String)strtaskDimMap);
        if (taskDimMap == null || taskDimMap.size() == 0) {
            return lngReturn;
        }
        String strVarDimNumber = baseVarMap.get(dimKey);
        if (dimKey.equalsIgnoreCase(CONTROL_YEAR)) {
            strVarDimNumber = "FY" + strVarDimNumber;
        }
        if (dimKey.equalsIgnoreCase(CONTROL_PERIOD)) {
            strVarDimNumber = strVarDimNumber.length() > 1 ? P_M_01_PREFIX + strVarDimNumber : "M_M0" + strVarDimNumber;
        }
        long varDimID = Long.parseLong(((String[])((Map)sysDimMap.get(dimKey)).get(strVarDimNumber))[1]);
        Map<Object, Object> baseNewVarMap = new HashMap();
        if (TemplateSetBaseVarUtil.isNewVarStyle(strVarBase).booleanValue() && !TemplateSetBaseVarUtil.isYearVerstionDataTypeDim(dimKey)) {
            baseNewVarMap = TemplateSetBaseVarUtil.getNewStyleVarMap(strVarBase);
            varDimID = Long.parseLong((String)((Map)baseNewVarMap.get(dimKey)).get(CON_MAPELEMENT_ID_REPLEASE));
        }
        if (scop.contains(varDimID)) {
            lngReturn = Long.parseLong(((String[])taskDimMap.get(dimKey))[2]);
        }
        return lngReturn;
    }

    public static Map<String, String[]> getBcmReplaceDimMap(String modelID, String taskListID, String tempID) {
        if (StringUtils.isEmpty((String)tempID) || StringUtils.isEmpty((String)modelID)) {
            return null;
        }
        TemplateModel templateModel = new TemplateModel();
        DynamicObject templateDy = BusinessDataServiceHelper.loadSingle((Object)tempID, (String)"bcm_templateentity");
        templateModel.loadDynaObj2SimpleModel(templateDy);
        String strVarBase = templateDy.getString("varbaseforeb");
        if (StringUtils.isEmpty((String)strVarBase)) {
            return null;
        }
        Map<String, String> baseVarMap = TemplateSetBaseVarUtil.getVarBaseMapFromString(strVarBase);
        Map<String, String[]> taskMap = TemplateSetBaseVarUtil.getTaskListDimInfo(taskListID, null);
        HashMap<String, String[]> replaceDimMap = new HashMap<String, String[]>();
        if (baseVarMap != null) {
            Map<Object, Object> baseNewVarMap = new HashMap();
            if (TemplateSetBaseVarUtil.isNewVarStyle(strVarBase).booleanValue()) {
                baseNewVarMap = TemplateSetBaseVarUtil.getNewStyleVarMap(strVarBase);
            }
            for (Map.Entry<String, String> entry : baseVarMap.entrySet()) {
                String dimkey = entry.getKey();
                String strVarDimNumber = entry.getValue();
                if (dimkey.equalsIgnoreCase(CONTROL_YEAR)) {
                    strVarDimNumber = "FY" + strVarDimNumber;
                }
                if (dimkey.equalsIgnoreCase(CONTROL_PERIOD)) {
                    strVarDimNumber = strVarDimNumber.length() > 1 ? P_M_01_PREFIX + strVarDimNumber : "M_M0" + strVarDimNumber;
                }
                ArrayList<QFilter> qFilterList = new ArrayList<QFilter>(2);
                String ctrlKey = TemplateSetBaseVarUtil.getCtrlKey(dimkey);
                QFilter id = new QFilter("id", "in", TemplateSetBaseVarUtil.getBcmPageDimMembers(ctrlKey, templateModel));
                qFilterList.add(id);
                Map<String, String> dimScopMap = TemplateSetBaseVarUtil.getDimScopMap(dimkey, Long.parseLong(modelID), qFilterList);
                if (taskMap != null && dimScopMap.containsKey(strVarDimNumber)) {
                    replaceDimMap.put(dimkey, new String[]{taskMap.get(dimkey)[0], taskMap.get(dimkey)[1], taskMap.get(dimkey)[2]});
                    continue;
                }
                if (TemplateSetBaseVarUtil.isYearVerstionDataTypeDim(dimkey) || baseNewVarMap.get(dimkey) == null) continue;
                replaceDimMap.put(dimkey, new String[]{(String)((Map)baseNewVarMap.get(dimkey)).get(CON_MAPELEMENT_NUMBER_REPLEASE), (String)((Map)baseNewVarMap.get(dimkey)).get(CON_MAPELEMENT_NAME_REPLEASE), (String)((Map)baseNewVarMap.get(dimkey)).get(CON_MAPELEMENT_ID_REPLEASE)});
            }
        }
        return replaceDimMap;
    }

    private static boolean isYearVerstionDataTypeDim(String dimKey) {
        return dimKey.equalsIgnoreCase(CONTROL_YEAR) || dimKey.equalsIgnoreCase(CONTROL_TYPE) || dimKey.equalsIgnoreCase(CONTROL_VERSION);
    }

    public static Set<Long> getBcmPageDimMembers(String memberEntity, TemplateModel templateModel) {
        if (memberEntity == null || templateModel == null) {
            return null;
        }
        HashSet<Long> memberids = new HashSet<Long>();
        List<PageDimensionEntry> pageDimensionEntries = templateModel.getPageDimensionEntries();
        String modelid = String.valueOf(templateModel.getModelId());
        for (PageDimensionEntry e : pageDimensionEntries) {
            List<kd.epm.eb.ebBusiness.template.model.Member> lm = e.getMembers();
            for (kd.epm.eb.ebBusiness.template.model.Member member : lm) {
                String entity = member.getDataEntityNumber();
                String entity1 = null;
                entity1 = memberEntity.startsWith("epm_userdefinedmembertree") ? (entity + "_" + member.getDimension().getNumber()).toLowerCase(Locale.getDefault()) : entity;
                if (!memberEntity.equals(entity1)) continue;
                Long memberid = member.getId();
                int range = member.getScope();
                Set<Long> pk = QueryMemberDetailsHelper.queryMemberIdsByRange(entity, memberid, range, modelid, DetailTypeEnum.OTHERS);
                memberids.addAll(pk);
            }
        }
        List<PageDimPropEntry> pageDimPropEntries = templateModel.getPagePropEntries();
        for (PageDimPropEntry e : pageDimPropEntries) {
            Dimension lm = e.getDimension();
            String entity = lm.getMemberEntityNumber();
            String entity1 = null;
            if (memberEntity.startsWith("epm_userdefinedmembertree")) {
                entity1 = (entity + "_" + lm.getNumber()).toLowerCase(Locale.getDefault());
                continue;
            }
            entity1 = entity;
        }
        return memberids;
    }
}

