/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.template.afix.multimanager;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.dimension.property.PropertyObj;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.RangeF7PropertyCataEnum;
import kd.epm.eb.common.permission.IMemberPermCache;
import kd.epm.eb.common.reportprocess.entity.dto.FixReportRowSeqDto;
import kd.epm.eb.common.reportprocess.entity.dto.FixReportTotalTitleFormatDto;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.MemberServiceHelper;
import kd.epm.eb.common.utils.RangeModel;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.spread.command.rangedefined.CellArea;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.afix.multimanager.AreaInfo;
import kd.epm.eb.spread.template.afix.multimanager.AreaManagerStrategy;
import kd.epm.eb.spread.template.afix.multisetting.IMultiAreaSetting;
import kd.epm.eb.spread.template.afix.multisetting.MultiAreaSetting;
import kd.epm.eb.spread.template.arearangedim.DefaultRowColDimensionEntry;
import kd.epm.eb.spread.template.arearangedim.IRowColDimensionEntry;
import kd.epm.eb.spread.template.dimension.IDimensionMember;
import kd.epm.eb.spread.template.dimension.PageViewDimMember;
import kd.epm.eb.spread.template.headerarea.IHeaderInfo;
import kd.epm.eb.spread.template.partition.RowColPartition;
import kd.epm.eb.spread.template.spreadmanager.CellDimMember;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.MetricCellDimMember;
import kd.epm.eb.spread.template.spreadmanager.list.SPArrayList;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import kd.epm.eb.spread.template.spreadmanager.sheet.ESheet;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import kd.epm.eb.spread.template.viewpointdim.IViewPointDimensionEntry;
import kd.epm.eb.spread.utils.DimPropertyHelper;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarCommonUtil;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarUtil;
import org.apache.commons.collections4.CollectionUtils;

public class MultiAreaManager {
    private static final int FLOATF7STYLE_SIZE = 15;
    private RangeModel areaRange;
    private String startpoint;
    private String areaIndex;
    private Map<String, PageViewDimMember> areaPageViewDims = new HashMap<String, PageViewDimMember>();
    private List<List<CellDimMember>> colpartitionDimMems = new SPArrayList<List<CellDimMember>>(50);
    private List<String> colpartitionDims = new ArrayList<String>();
    private List<List<CellDimMember>> rowpartitionDimMems = new SPArrayList<List<CellDimMember>>(100);
    private List<String> rowpartitionDims = new ArrayList<String>();
    private AreaDataInfo data;
    private Set<String> toDeleteData = new HashSet<String>();
    private Set<String> updatedData = new HashSet<String>();
    private int floatonWhere = -1;
    private IEbSpreadManager ebSpreadManager;
    private IModelCacheHelper modelCacheHelper;
    private Map<String, List<PropertyObj>> dimPropertys = new HashMap<String, List<PropertyObj>>();
    private boolean userStyle = false;
    private boolean hasCellHyperLinkInfo = false;
    private List<IHeaderInfo> rowHeaders = null;
    private List<IHeaderInfo> colHeaders = null;
    private FixReportRowSeqDto fixReportRowSeqDto;
    private ITemplateModel templateModel;
    private static Log log = LogFactory.getLog(MultiAreaManager.class);
    private boolean isQuickAddNew;
    private static FixReportTotalTitleFormatDto fixReportTotalTitleFormatDto;
    private int colPropertyCount = -1;
    Map<String, Integer> rowDimPosMap = null;
    private int rowPropertyCount = -1;
    Map<String, Integer> colDimPosMap = null;

    public void setEbSpreadManager(IEbSpreadManager ebSpreadManager) {
        this.ebSpreadManager = ebSpreadManager;
    }

    public IEbSpreadManager getEbSpreadManager() {
        return this.ebSpreadManager;
    }

    public ITemplateModel getTemplateModel() {
        return this.templateModel;
    }

    public void setTemplateModel(ITemplateModel templateModel) {
        this.templateModel = templateModel;
    }

    private String getTemplateNum() {
        return this.templateModel == null ? "" : this.templateModel.getTemplateBaseInfo().getNumber();
    }

    public RangeModel getAreaRange() {
        return this.areaRange;
    }

    public void setAreaRange(RangeModel areaRange) {
        this.areaRange = areaRange;
    }

    public String getAreaIndex() {
        return this.areaIndex;
    }

    public void setAreaIndex(String areaIndex) {
        this.areaIndex = areaIndex;
    }

    public List<List<CellDimMember>> getColpartitionDimMems() {
        return this.colpartitionDimMems;
    }

    public List<String> getColpartitionDims() {
        return this.colpartitionDims;
    }

    public void setColpartitionDims(List<String> colpartitionDims) {
        this.colpartitionDims = colpartitionDims;
    }

    public void setRowpartitionDims(List<String> rowpartitionDims) {
        this.rowpartitionDims = rowpartitionDims;
    }

    public List<List<CellDimMember>> getRowpartitionDimMems() {
        return this.rowpartitionDimMems;
    }

    public List<String> getRowpartitionDims() {
        return this.rowpartitionDims;
    }

    public AreaDataInfo getData() {
        return this.data;
    }

    public Set<String> getToDeleteData() {
        return this.toDeleteData;
    }

    public Set<String> getUpdatedData() {
        return this.updatedData;
    }

    public Map<String, List<PropertyObj>> getDimPropertys() {
        return this.dimPropertys;
    }

    public void setDimPropertys(Map<String, List<PropertyObj>> dimPropertys) {
        this.dimPropertys = dimPropertys;
    }

    public void build(AreaManagerStrategy areaManager, IMultiAreaSetting areaRange) {
        this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.ebSpreadManager.getModelobj().getId());
        this.setAreaRange(new RangeModel(areaRange.getAreaRange()));
        this.startpoint = areaRange.getStartPosition();
        this.setColpartitionDims(areaRange.getColdims());
        this.setRowpartitionDims(areaRange.getRowdims());
        this.setDimPropertys(areaRange.getDimPropertys());
        this.setUserStyle(areaRange.isUserStyle());
        this.setRowHeaders(areaRange.getRowHeaders());
        this.setColHeaders(areaRange.getColHeaders());
        this.floatonWhere = areaRange.getFloatOnWhere();
        this.ebSpreadManager.setFloatOnRow(areaRange.getFloatOnWhere() == 0);
        Map<String, Map<String, String>> varValus = null;
        if (this.ebSpreadManager.getProcessId() != null) {
            varValus = areaManager.getVarValues(this.ebSpreadManager);
        }
        Map<String, Map<String, String>> varNumberNameMap = null;
        if (this.ebSpreadManager.getIsPreview()) {
            varNumberNameMap = TemplateVarCommonUtil.getVarIDNumberMap("isNeedVar", this.ebSpreadManager.getModelobj().getId());
        }
        this.buildHidedimsIntoAllDimension(areaRange);
        this.buildRowColPartitionMem(areaRange, true, areaRange.getFloatOnWhere() == 0, varValus, varNumberNameMap);
        this.buildRowColPartitionMem(areaRange, false, areaRange.getFloatOnWhere() == 1, varValus, varNumberNameMap);
        this.applyLockedCells(areaRange);
    }

    private void applyLockedCells(IMultiAreaSetting areaRange) {
        if (areaRange != null) {
            ISheet areaTemplate = areaRange.getAreaSheet();
            ISheet dataSheet = this.getData().getDataSheet();
            areaTemplate.iteratorECells(cell -> {
                if (Boolean.TRUE.equals(cell.getUserObject("l"))) {
                    dataSheet.getECell(cell.getRow(), cell.getCol()).setUserObject("l", true);
                }
            });
        }
    }

    private void buildHidedimsIntoAllDimension(IMultiAreaSetting areaRange) {
        List<IViewPointDimensionEntry> hidedims = areaRange.getAreaViewpointmembentry();
        for (IViewPointDimensionEntry hidedim : hidedims) {
            String dimNumber = hidedim.getDimension().getNumber();
            String memNumber = hidedim.getMember().getNumber();
            Long viewId = DimensionViewServiceHelper.getViewId(this.ebSpreadManager.getDimemsionViews(), (String)dimNumber, (String)this.getAreaIndex());
            Member member = this.modelCacheHelper.getMember(dimNumber, viewId, memNumber);
            if (member != null) {
                PageViewDimMember pageViewDimMember = new PageViewDimMember(memNumber, member.isLeaf());
                this.areaPageViewDims.put(hidedim.getDimension().getNumber(), pageViewDimMember);
            } else {
                MemberServiceHelper.memberNotExist((String)dimNumber, (String)memNumber, (Long)viewId, (String)this.getTemplateNum());
            }
            Set<String> members = this.ebSpreadManager.getAlldimensionWithMembers().get(hidedim.getDimension().getNumber());
            if (members == null) {
                members = new HashSet<String>();
                this.ebSpreadManager.getAlldimensionWithMembers().put(hidedim.getDimension().getNumber(), members);
            }
            members.add(hidedim.getMember().getNumber());
        }
    }

    public void buildRowColPartitionMem(IMultiAreaSetting areaRange, boolean isrow, boolean isFloat, Map<String, Map<String, String>> varValus, Map<String, Map<String, String>> varNumberNameMap) {
        int two_end;
        int two_start;
        int first_end;
        int first_start;
        ISheet sheet;
        int rowdim_size = areaRange.getRowdims().size();
        int coldim_size = areaRange.getColdims().size();
        if (areaRange.getDimPropertys() != null && areaRange.getDimPropertys().size() > 0) {
            rowdim_size += DimPropertyHelper.getPropertyCount(areaRange.getDimPropertys(), areaRange.getRowdims());
            coldim_size += DimPropertyHelper.getPropertyCount(areaRange.getDimPropertys(), areaRange.getColdims());
        }
        if ((sheet = areaRange.getAreaSheet()) == null) {
            return;
        }
        this.initAreaInfo(areaRange);
        HashSet<Integer> floatrowcols = new HashSet<Integer>();
        HashMap<Integer, MultiAreaSetting.FloatInfo> floatinfos = new HashMap<Integer, MultiAreaSetting.FloatInfo>();
        HashMap<Boolean, Set<Integer>> rangeTypwMap = new HashMap<Boolean, Set<Integer>>(2);
        if (isFloat) {
            this.initFloatRowCols(floatrowcols, areaRange, isrow, floatinfos, rangeTypwMap);
        }
        if (isrow) {
            first_start = 0;
            first_end = rowdim_size;
            two_start = coldim_size;
            two_end = sheet.getRealMaxRows();
        } else {
            first_start = 0;
            first_end = coldim_size;
            two_start = rowdim_size;
            two_end = sheet.getRealMaxCols();
        }
        Map<String, Integer> dimsIndex = DimPropertyHelper.getDimPosMap(isrow ? areaRange.getRowHeaders() : areaRange.getColHeaders());
        while (first_start < first_end) {
            int pos = first_start;
            Optional<Map.Entry> curDimOP = dimsIndex.entrySet().stream().filter(kv -> (Integer)kv.getValue() == pos).findFirst();
            Boolean isProperty = !curDimOP.isPresent();
            CellDimMember last_member = null;
            for (int temp_twostart = two_start; temp_twostart < two_end; ++temp_twostart) {
                ECell cell = isrow ? ECell.cloneECell(sheet.getECellNotAdd(temp_twostart, first_start)) : ECell.cloneECell(sheet.getECellNotAdd(first_start, temp_twostart));
                if (isProperty.booleanValue()) {
                    if (cell == null) {
                        cell = ECell.cloneECell(sheet.getECell(first_start, temp_twostart));
                    }
                    last_member = new CellDimMember(true, "");
                    last_member.setProperty(true);
                    List<List<CellDimMember>> partitionmems = this.getPartitionmems(isrow);
                    List<CellDimMember> dimMembers = partitionmems.get(temp_twostart - two_start);
                    if (dimMembers == null) {
                        dimMembers = new SPArrayList<CellDimMember>(rowdim_size);
                        partitionmems.set(temp_twostart - two_start, dimMembers);
                    }
                    dimMembers.set(first_start, last_member);
                    this.getData().getDataSheet().setECell(cell.getRow(), cell.getCol(), cell);
                    continue;
                }
                String dimnumber = (String)curDimOP.get().getKey();
                if (isFloat && floatrowcols.contains(temp_twostart)) {
                    Integer realRangeType = null;
                    for (Map.Entry booleanSetEntry : rangeTypwMap.entrySet()) {
                        boolean contains = ((Set)booleanSetEntry.getValue()).contains(temp_twostart);
                        if (!contains) continue;
                        realRangeType = (Boolean)booleanSetEntry.getKey() != false ? 0 : 1;
                    }
                    if (cell == null || cell.getValue() == null) {
                        this.initFloatCellInManager(isrow, temp_twostart, first_start, floatinfos, realRangeType);
                        continue;
                    }
                    if (cell != null && !cell.isFloatCell() && cell.getUserObject("number") != null) {
                        cell.setUserObject("fixMember", "true");
                        if (realRangeType != null) {
                            cell.setUserObject("rangeType", realRangeType);
                        }
                    }
                }
                if (cell != null && cell.getValue() != null) {
                    String lastdim_mem = cell.getUserObject("number") == null ? String.valueOf(cell.getValue()) : String.valueOf(cell.getUserObject("number"));
                    lastdim_mem = ReportVarUtil.getRealDimByVar(this.ebSpreadManager.getModelobj().getId(), lastdim_mem, dimnumber, varValus);
                    Long viewId = DimensionViewServiceHelper.getViewId(this.ebSpreadManager.getDimemsionViews(), (String)dimnumber, (String)this.getAreaIndex());
                    Member member = this.modelCacheHelper.getMember(dimnumber, viewId, lastdim_mem);
                    if (this.isPreviewVar(cell.getValue().toString(), dimnumber).booleanValue()) {
                        member = TemplateVarUtil.getNewVarMember(this.ebSpreadManager.getModelobj().getId(), lastdim_mem, dimnumber, varNumberNameMap, this.getModelCacheHelper());
                    }
                    if (member == null) {
                        MemberServiceHelper.memberNotExist((String)dimnumber, (String)lastdim_mem, (Long)viewId, (String)this.getTemplateNum());
                        return;
                    }
                    if (!this.ebSpreadManager.getIsPreview() && TemplateVarCommonUtil.checkIsVar(cell.getValue().toString(), dimnumber).booleanValue()) {
                        cell.setValue(member.getNumber());
                        cell.setUserObject("number", member.getNumber());
                        cell.setUserObject("name", member.getName());
                    }
                    if (isFloat) {
                        this.getData().getDataSheet().setECell(cell.getRow(), cell.getCol(), cell);
                    }
                    if ("Metric".equals(dimnumber)) {
                        MetricCellDimMember tempcelldimmember = new MetricCellDimMember(member.isLeaf(), member.getNumber());
                        tempcelldimmember.setSign(cell.getUserObject("sign") == null ? null : String.valueOf(cell.getUserObject("sign")));
                        tempcelldimmember.setDecimalnum(cell.getUserObject("decimalnum") == null ? null : String.valueOf(cell.getUserObject("decimalnum")));
                        tempcelldimmember.setUse(cell.getUserObject("use") == null ? null : String.valueOf(cell.getUserObject("use")));
                        tempcelldimmember.setMetric(true);
                        tempcelldimmember.setDatatype(this.ebSpreadManager.getMetricDatatypeMap().get(member.getNumber()));
                        last_member = tempcelldimmember;
                    } else {
                        last_member = new CellDimMember(member.isLeaf(), member.getNumber());
                    }
                    Set<String> onemembers = this.ebSpreadManager.getAlldimensionWithMembers().get(dimnumber);
                    if (onemembers == null) {
                        onemembers = new HashSet<String>();
                        this.ebSpreadManager.getAlldimensionWithMembers().put(dimnumber, onemembers);
                    }
                    if (!this.isPreviewVar(cell.getValue().toString(), dimnumber).booleanValue() && !this.getMemberPermCache().isNoperm(member.getDimension().getNumber(), member.getNumber(), viewId)) {
                        onemembers.add(member.getNumber());
                    }
                }
                if (last_member == null || cell != null && cell.getValue() == null && cell.isFloatCell() || !isrow && (cell == null || cell.getValue() == null)) continue;
                List<List<CellDimMember>> partitionmems = this.getPartitionmems(isrow);
                List<CellDimMember> dimMembers = partitionmems.get(temp_twostart - two_start);
                if (dimMembers == null) {
                    dimMembers = new SPArrayList<CellDimMember>(rowdim_size);
                    partitionmems.set(temp_twostart - two_start, dimMembers);
                }
                boolean needSetMember = cell != null && cell.hasUserObject() && StringUtils.equals((String)dimnumber, (String)String.valueOf(cell.getUserObject("dimnumber"))) && cell.getUserObject("number") != null;
                dimMembers.set(first_start, needSetMember ? last_member : null);
            }
            ++first_start;
        }
    }

    private Boolean isPreviewVar(String num, String dimension) {
        if (this.ebSpreadManager.getIsPreview() && TemplateVarCommonUtil.checkIsVar(num, dimension).booleanValue()) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private List<List<CellDimMember>> getPartitionmems(Boolean isrow) {
        List<List<CellDimMember>> partitionmems = isrow != false ? this.rowpartitionDimMems : this.colpartitionDimMems;
        return partitionmems;
    }

    private void initFloatCellInManager(boolean isrow, int temp_twostart, int first_start, Map<Integer, MultiAreaSetting.FloatInfo> floatinfos, Integer realRangeType) {
        ECell eCell = new ECell();
        eCell.setFloatCell(true);
        if (isrow) {
            this.getData().getDataSheet().setECell(temp_twostart, first_start, eCell);
        } else {
            this.getData().getDataSheet().setECell(first_start, temp_twostart, eCell);
        }
        int rangeTyppe = 0;
        MultiAreaSetting.FloatInfo floatInfo = floatinfos.get(temp_twostart);
        if (floatInfo != null) {
            rangeTyppe = floatInfo.getRangeType();
            if (realRangeType != null) {
                rangeTyppe = realRangeType;
            }
            List<String> dimNums = isrow ? this.getRowpartitionDims() : this.getColpartitionDims();
            Map<String, Integer> dimPosMap = DimPropertyHelper.getDimPosMap(isrow ? this.getRowHeaders() : this.getColHeaders());
            String dimNum = DimPropertyHelper.getDimNumByPos(dimPosMap, first_start);
            Optional<IRowColDimensionEntry> dimensionEntryOpt = floatInfo.getPartition().getRowColDimensionEntries().stream().filter(dimentry -> dimentry.getDimension().getNumber().equalsIgnoreCase(dimNum)).findFirst();
            IRowColDimensionEntry dimensionEntry = dimensionEntryOpt.get();
            Set<String> mems = this.getEbSpreadManager().getRowcolentryScopes().get(dimensionEntry);
            if (dimensionEntry.isFloat()) {
                eCell.setUserObject("scope", dimensionEntry);
                if (isrow) {
                    eCell.setUserObject("leavesize", floatInfo.getRowEnd_offset() - floatInfo.getRow_offset() + 1);
                } else {
                    eCell.setUserObject("leavesize", floatInfo.getColEnd_offset() - floatInfo.getCol_offset() + 1);
                }
                if (floatInfo.getLockCols() != null && floatInfo.getLockCols().size() > 0) {
                    eCell.setUserObject("lockcols", floatInfo.getLockCols());
                }
                this.isQuickAddNew = dimensionEntry.isQuickAddNew();
            }
            eCell.setUserObject("rangeType", rangeTyppe);
        }
        if (this.isQuickAddNew) {
            eCell.setUserObject("isQuickAddNew", "true");
        }
    }

    private void initFloatRowCols(Set<Integer> floatrowcols, IMultiAreaSetting areaRange, boolean isrow, Map<Integer, MultiAreaSetting.FloatInfo> floatinfos, Map<Boolean, Set<Integer>> rangeTypwMap) {
        IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
        for (MultiAreaSetting.FloatInfo floatInfo : areaRange.getFloatInfos()) {
            RowColPartition partition;
            int end;
            int start;
            if (isrow) {
                start = floatInfo.getRow_offset();
                end = floatInfo.getRowEnd_offset();
            } else {
                start = floatInfo.getCol_offset();
                end = floatInfo.getColEnd_offset();
            }
            floatinfos.put(start, floatInfo);
            boolean isAllLeaf = true;
            if (floatInfo.getRangeType() == 0 && (partition = floatInfo.getPartition()) != null) {
                for (IRowColDimensionEntry rowColDimensionEntry : partition.getRowColDimensionEntries()) {
                    String number = rowColDimensionEntry.getDimension().getNumber();
                    DefaultRowColDimensionEntry temp = (DefaultRowColDimensionEntry)rowColDimensionEntry;
                    String viewId = temp.getViewId();
                    boolean aFloat = rowColDimensionEntry.isFloat();
                    List<IDimensionMember> members = rowColDimensionEntry.getMembers();
                    for (IDimensionMember member : members) {
                        Object member1;
                        if (!RangeF7PropertyCataEnum.Member.getIndex().equals(member.getType())) continue;
                        if (aFloat) {
                            member1 = modelCacheHelper.getMember(number, IDUtils.toLong((Object)viewId), member.getNumber(), member.getScope());
                            Optional<Member> first = member1.stream().filter(x -> !x.isLeaf()).findFirst();
                            if (!first.isPresent()) continue;
                            isAllLeaf = Boolean.FALSE;
                            break;
                        }
                        member1 = modelCacheHelper.getMember(number, IDUtils.toLong((Object)viewId), member.getNumber());
                        isAllLeaf = member1.isLeaf();
                        break;
                    }
                    if (isAllLeaf) continue;
                    break;
                }
            }
            if (floatInfo.getRangeType() != 0 || floatInfo.getRangeType() == 0 && !isAllLeaf) {
                Set totalRow = rangeTypwMap.computeIfAbsent(Boolean.FALSE, k -> new HashSet());
                totalRow.add(start);
            } else {
                Set leafRow = rangeTypwMap.computeIfAbsent(Boolean.TRUE, k -> new HashSet());
                leafRow.add(start);
            }
            while (start <= end) {
                floatrowcols.add(start);
                ++start;
            }
        }
    }

    private void initAreaInfo(IMultiAreaSetting areaRange) {
        if (this.data == null) {
            ESheet realsheet = new ESheet();
            realsheet.setValueAreaColStart(0);
            realsheet.setValueAreaRowStart(0);
            this.data = new AreaDataInfo(realsheet);
        } else {
            int dimCount = 0;
            if (this.floatonWhere == 0) {
                dimCount = this.getRowpartitionDims().size();
                if (areaRange.getDimPropertys() != null) {
                    dimCount += DimPropertyHelper.getPropertyCount(areaRange.getDimPropertys(), this.getRowpartitionDims());
                }
                this.data.getDataSheet().setValueAreaColStart(dimCount);
            } else if (this.floatonWhere == 1) {
                dimCount = this.getColpartitionDims().size();
                if (areaRange.getDimPropertys() != null) {
                    dimCount += DimPropertyHelper.getPropertyCount(areaRange.getDimPropertys(), this.getColpartitionDims());
                }
                this.data.getDataSheet().setValueAreaRowStart(dimCount);
            }
        }
    }

    public int getFloatonWhere() {
        return this.floatonWhere;
    }

    public void setFloatonWhere(int floatonWhere) {
        this.floatonWhere = floatonWhere;
    }

    public void setData(AreaDataInfo data) {
        this.data = data;
    }

    public String getStartpoint() {
        return this.startpoint;
    }

    public ValueArea getValueAreaStart() {
        String[] startpoint = this.getStartpoint().split(":");
        int rowPropetyCount = 0;
        int colPropetyCount = 0;
        if (this.dimPropertys != null) {
            rowPropetyCount = DimPropertyHelper.getPropertyCount(this.dimPropertys, this.rowpartitionDims);
            colPropetyCount = DimPropertyHelper.getPropertyCount(this.dimPropertys, this.colpartitionDims);
        }
        int row_start = this.getAreaRange().getY_start() + Integer.parseInt(startpoint[1]);
        int col_start = this.getAreaRange().getX_start() + Integer.parseInt(startpoint[0]);
        int data_row_start = row_start + (this.getFloatonWhere() == 1 ? this.colpartitionDims.size() + colPropetyCount : 0);
        int data_col_start = col_start + (this.getFloatonWhere() == 0 ? this.rowpartitionDims.size() + rowPropetyCount : 0);
        return new ValueArea(row_start, col_start, data_row_start, data_col_start);
    }

    public Integer[] getValueAreaEnd() {
        ValueArea startpoint = this.getValueAreaStart();
        int reaMaxRows = this.data.getDataSheet().getRealMaxRows();
        int realMaxCols = this.data.getDataSheet().getRealMaxCols();
        return new Integer[]{startpoint.getRow_start() + reaMaxRows, startpoint.getCol_start() + realMaxCols, startpoint.getData_row_start() + reaMaxRows, startpoint.getData_col_start() + realMaxCols};
    }

    public void setStartpoint(String startpoint) {
        this.startpoint = startpoint;
    }

    public int getColPropertyCount() {
        if (this.colPropertyCount == -1) {
            this.colPropertyCount = DimPropertyHelper.getPropertyCount(this.getDimPropertys(), this.getColpartitionDims());
        }
        return this.colPropertyCount;
    }

    public Map<String, Integer> getRowDimPosMap() {
        if (this.rowDimPosMap == null) {
            this.rowDimPosMap = DimPropertyHelper.getDimPosMap(this.getRowHeaders());
        }
        return this.rowDimPosMap;
    }

    public Map<String, CellDimMember> getRowpartitionDimMemsByRow(int row) {
        if (this.getFloatonWhere() == 1) {
            row = row - this.getColpartitionDims().size() - this.getColPropertyCount();
        }
        if (row < 0) {
            return new LinkedHashMap<String, CellDimMember>(16);
        }
        Map<String, Integer> dimPosMap = this.getRowDimPosMap();
        LinkedHashMap<String, CellDimMember> dimMemberMap = new LinkedHashMap<String, CellDimMember>(dimPosMap.size());
        List<CellDimMember> dimMembers = this.getRowpartitionDimMems().get(row);
        if (dimMembers == null || dimMembers.size() == 0) {
            return dimMemberMap;
        }
        for (Map.Entry<String, Integer> dimPos : dimPosMap.entrySet()) {
            CellDimMember dimMember = dimMembers.get(dimPos.getValue());
            if (dimMember != null && dimMember.isProperty()) continue;
            dimMemberMap.put(dimPos.getKey(), dimMember);
        }
        return dimMemberMap;
    }

    public int getRowPropertyCount() {
        if (this.rowPropertyCount == -1) {
            this.rowPropertyCount = DimPropertyHelper.getPropertyCount(this.getDimPropertys(), this.getRowpartitionDims());
        }
        return this.rowPropertyCount;
    }

    public Map<String, Integer> getColDimPosMap() {
        if (this.colDimPosMap == null) {
            this.colDimPosMap = DimPropertyHelper.getDimPosMap(this.getColHeaders());
        }
        return this.colDimPosMap;
    }

    public Map<String, CellDimMember> getColpartitionDimMemsByCol(int col) {
        if (this.getFloatonWhere() == 0) {
            col = col - this.getRowpartitionDims().size() - this.getRowPropertyCount();
        }
        if (col < 0) {
            return null;
        }
        Map<String, Integer> dimPosMap = this.getColDimPosMap();
        LinkedHashMap<String, CellDimMember> dimMemberMap = new LinkedHashMap<String, CellDimMember>(dimPosMap.size());
        List<CellDimMember> dimMembers = this.getColpartitionDimMems().get(col);
        if (dimMembers == null || dimMembers.size() == 0) {
            return dimMemberMap;
        }
        for (Map.Entry<String, Integer> dimPos : dimPosMap.entrySet()) {
            CellDimMember dimMember = dimMembers.get(dimPos.getValue());
            if (dimMember != null && dimMember.isProperty()) continue;
            dimMemberMap.put(dimPos.getKey(), dimMember);
        }
        return dimMemberMap;
    }

    public AreaInfo getAreaInfo(int row, int col) {
        ValueArea valueAreaRowColStart = this.getValueAreaStart();
        int relativerow = row - valueAreaRowColStart.getRow_start();
        int relativecol = col - valueAreaRowColStart.getCol_start();
        return new AreaInfo(this, relativerow, relativecol, valueAreaRowColStart.getRow_start(), valueAreaRowColStart.getCol_start());
    }

    public ECell getScopeCell(int relativerow, int relativecol) {
        ECell cell = null;
        while (cell == null || !cell.isFloatCell() || cell.getUserObject("scope") == null) {
            cell = this.getData().getDataSheet().getECellNotAdd(relativerow, relativecol);
            if (this.getFloatonWhere() == 0) {
                --relativerow;
            } else {
                --relativecol;
            }
            if (relativerow >= 0 && relativecol >= 0 && cell != null && cell.isFloatCell()) continue;
            break;
        }
        return cell;
    }

    public IModelCacheHelper getModelCacheHelper() {
        if (this.modelCacheHelper == null) {
            this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.ebSpreadManager.getModelobj().getId());
        }
        return this.modelCacheHelper;
    }

    public List<Member> resolveScopeFuzzySearch(IRowColDimensionEntry rowColDimensionEntry, String tosearch, int size) {
        return null;
    }

    public List<Member> resolveScopeFuzzySearch(IRowColDimensionEntry rowColDimensionEntry, String tosearch, int size, boolean inDimRelation, Set<String> relationMems, Map<String, Map<String, String>> varValus, String orgNumber, String orgLongNumber, Integer rangeType, Set<String> filterMember) {
        boolean islike = true;
        if (StringUtils.isEmpty((String)tosearch)) {
            islike = false;
        } else {
            tosearch = tosearch.toLowerCase(Locale.getDefault());
        }
        LinkedList<Member> searchedMembers = new LinkedList<Member>();
        Map<String, Long> dimensionViews = this.getEbSpreadManager().getDimemsionViews();
        for (IDimensionMember member : rowColDimensionEntry.getMembers()) {
            Optional<Member> first;
            if (varValus != null) {
                member.setNumber(ReportVarUtil.getRealDimByVar(this.getEbSpreadManager().getModelobj().getId(), member.getNumber(), rowColDimensionEntry.getDimension().getNumber(), varValus));
            }
            Long viewId = DimensionViewServiceHelper.getViewId(dimensionViews, (String)rowColDimensionEntry.getDimension().getNumber(), (String)this.getAreaIndex());
            List members = this.getModelCacheHelper().getMember(rowColDimensionEntry.getDimension().getNumber(), viewId, member.getNumber(), member.getScope());
            if (members == null) continue;
            if (rangeType != null && rangeType == 0 && (first = members.stream().filter(x -> !x.isLeaf()).findFirst()).isPresent()) {
                rangeType = 1;
            }
            for (Member member1 : members) {
                if (CollectionUtils.isNotEmpty(filterMember) && !filterMember.contains(member1.getNumber()) || inDimRelation && relationMems != null && !relationMems.contains(member1.getNumber()) || this.getEbSpreadManager().getMemberPerm().isNoperm(rowColDimensionEntry.getDimension().getNumber(), member1.getNumber(), viewId) || searchedMembers.contains(member1) || SysDimensionEnum.Entity.getNumber().equals(rowColDimensionEntry.getDimension().getNumber()) && StringUtils.isNotEmpty((String)orgNumber) && StringUtils.isNotEmpty((String)orgLongNumber) && member1.getNumber() != null && !member1.getNumber().equals(orgNumber) && member1.getLongNumber() != null && !member1.getLongNumber().startsWith(orgLongNumber + "!")) continue;
                if (islike) {
                    if (member1.getName() != null && member1.getName().toLowerCase(Locale.getDefault()).equals(tosearch) || member1.getNumber() != null && member1.getNumber().toLowerCase(Locale.getDefault()).equals(tosearch)) {
                        if (searchedMembers.size() >= size && !searchedMembers.isEmpty()) {
                            searchedMembers.remove();
                        }
                        searchedMembers.addFirst(member1);
                        continue;
                    }
                    if ((member1.getName() == null || !member1.getName().toLowerCase(Locale.getDefault()).contains(tosearch)) && (member1.getNumber() == null || !member1.getNumber().toLowerCase(Locale.getDefault()).contains(tosearch)) || searchedMembers.size() >= size) continue;
                    searchedMembers.add(member1);
                    continue;
                }
                if (rangeType != null && rangeType == 0) {
                    if (member1.isLeaf()) {
                        searchedMembers.add(member1);
                    }
                } else {
                    searchedMembers.add(member1);
                }
                if (size < 0 || searchedMembers.size() < size) continue;
                return searchedMembers;
            }
        }
        return searchedMembers;
    }

    public IMemberPermCache getMemberPermCache() {
        return this.getEbSpreadManager().getMemberPerm();
    }

    public Map<String, PageViewDimMember> getAreaPageViewDims() {
        return this.areaPageViewDims;
    }

    public boolean isUserStyle() {
        return this.userStyle;
    }

    public void setUserStyle(boolean userStyle) {
        this.userStyle = userStyle;
    }

    public boolean isHasCellHyperLinkInfo() {
        return this.hasCellHyperLinkInfo;
    }

    public void setHasCellHyperLinkInfo(boolean hasCellHyperLinkInfo) {
        this.hasCellHyperLinkInfo = hasCellHyperLinkInfo;
    }

    public List<IHeaderInfo> getRowHeaders() {
        return this.rowHeaders;
    }

    public void setRowHeaders(List<IHeaderInfo> rowHeaders) {
        this.rowHeaders = rowHeaders;
    }

    public List<IHeaderInfo> getColHeaders() {
        return this.colHeaders;
    }

    public void setColHeaders(List<IHeaderInfo> colHeaders) {
        this.colHeaders = colHeaders;
    }

    public FixReportRowSeqDto getFixReportRowSeqDto() {
        return this.fixReportRowSeqDto;
    }

    public void setFixReportRowSeqDto(FixReportRowSeqDto fixReportRowSeqDto) {
        this.fixReportRowSeqDto = fixReportRowSeqDto;
    }

    public CellArea getValueArea() {
        ValueArea valueArea = this.getValueAreaStart();
        int dataRowStart = valueArea.getData_row_start();
        int dataColStart = valueArea.getData_col_start();
        RangeModel rangeModel = this.getAreaRange();
        int dataRowEnd = rangeModel.getY_end();
        int dataColEnd = rangeModel.getX_end();
        int rows = dataRowEnd - dataRowStart + 1;
        int cols = dataColEnd - dataColStart + 1;
        return new CellArea(dataRowStart, dataColStart, rows, cols);
    }

    public class AreaDataInfo {
        private ISheet sheet;

        public AreaDataInfo(ISheet sheet) {
            this.sheet = sheet;
        }

        public ECell getECell(int row, int col) {
            return this.sheet.getECell(row, col);
        }

        public ISheet getDataSheet() {
            return this.sheet;
        }

        public void insertRow(int index, boolean copybefore) {
            this.sheet.insertRow(index, copybefore);
            this.adjustTodeleteData(true, index);
        }

        public void insertColumn(int index, boolean copybefore) {
            this.sheet.insertColumn(index, copybefore);
            this.adjustTodeleteData(false, index);
        }

        private void adjustTodeleteData(boolean isrow, int index) {
            Iterator<String> toDeleteDatates = MultiAreaManager.this.getToDeleteData().iterator();
            HashSet<String> toadd = new HashSet<String>();
            while (toDeleteDatates.hasNext()) {
                String deletedata = toDeleteDatates.next();
                if (!StringUtils.isNotEmpty((String)deletedata)) continue;
                String[] ss = deletedata.split("&");
                String real = null;
                if (isrow) {
                    int currow = Integer.parseInt(ss[0]);
                    if (currow >= index) {
                        toDeleteDatates.remove();
                        real = ++currow + "&" + ss[1];
                    }
                } else {
                    int curcol = Integer.parseInt(ss[1]);
                    if (curcol >= index) {
                        toDeleteDatates.remove();
                        real = ss[0] + "&" + ++curcol;
                    }
                }
                if (real == null) continue;
                toadd.add(real);
            }
            MultiAreaManager.this.getToDeleteData().addAll(toadd);
        }
    }

    public static class ValueArea {
        private int row_start;
        private int col_start;
        private int data_row_start;
        private int data_col_start;

        public ValueArea(int row_start, int col_start, int data_row_start, int data_col_start) {
            this.row_start = row_start;
            this.col_start = col_start;
            this.data_row_start = data_row_start;
            this.data_col_start = data_col_start;
        }

        public int getRow_start() {
            return this.row_start;
        }

        public int getCol_start() {
            return this.col_start;
        }

        public int getData_row_start() {
            return this.data_row_start;
        }

        public int getData_col_start() {
            return this.data_col_start;
        }
    }
}

