/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.template.afix.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.epm.eb.common.reportprocess.entity.dto.FixReportRowSeqDto;
import kd.epm.eb.common.reportprocess.entity.dto.FixReportSortDiminfoDto;
import kd.epm.eb.common.reportprocess.entity.dto.FixReportTotalTitleFormatDto;
import kd.epm.eb.spread.template.BgTemplate;
import kd.epm.eb.spread.template.afix.FixTemplateModel;
import kd.epm.eb.spread.template.afix.multisetting.CellHyperLinkPOJO;
import kd.epm.eb.spread.template.afix.multisetting.FixTemplateDynTitle;
import kd.epm.eb.spread.template.afix.multisetting.IMultiAreaSetting;
import kd.epm.eb.spread.template.afix.multisetting.MultiAreaSetting;
import kd.epm.eb.spread.template.arearangedim.IRowColDimensionEntry;
import kd.epm.eb.spread.template.dimension.DefaultDimMember;
import kd.epm.eb.spread.template.dimension.IDimensionMember;
import kd.epm.eb.spread.template.pagedim.IPageDimensionEntry;
import kd.epm.eb.spread.template.partition.RowColPartition;
import kd.epm.eb.spread.template.spread.style.MetricCellStyleInfo;
import kd.epm.eb.spread.template.spreadmanager.serializer.ESheetSerializer;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import kd.epm.eb.spread.template.viewpointdim.IViewPointDimensionEntry;

public class FixTemplateSerializer
extends JsonSerializer<FixTemplateModel> {
    private JsonGenerator jsonGenerator;
    private ESheetSerializer eSheetSerializer = new ESheetSerializer();

    public void serialize(FixTemplateModel fixTemplateModel, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
        this.jsonGenerator = jsonGenerator;
        this.eSheetSerializer.setJsonGenerator(jsonGenerator);
        this.eSheetSerializer.setSerializerProvider(serializerProvider);
        jsonGenerator.writeStartObject();
        this.writeHideEntry(fixTemplateModel.getHidedimentry());
        this.writeViewEntry(fixTemplateModel.getViewpointmembentry());
        this.writePageEntry(fixTemplateModel.getPagemembentry());
        this.writeBgtemplate(fixTemplateModel.getTemplateBaseInfo());
        this.writeMetricCellStyle(fixTemplateModel.getMetricCellStyleInfo());
        this.writeRowColDims(fixTemplateModel.getRowcolDims());
        this.writeAreaRanges(fixTemplateModel.getAreaRanges());
        this.writeDimensionViews(fixTemplateModel.getDimemsionViews());
        this.writeFormulaMap(fixTemplateModel.getFormulaMap(), "formulaMap");
        this.writeFormulaMap(fixTemplateModel.getOutAreaHyperLink(), "outAreaHyperLink");
        this.writeFilterDims(fixTemplateModel.getFilterDims());
        jsonGenerator.writeEndObject();
    }

    private void writeFilterDims(List<String> filterDims) throws IOException {
        if (filterDims != null && filterDims.size() > 0) {
            this.jsonGenerator.writeArrayFieldStart("filterDims");
            for (String filterDim : filterDims) {
                this.jsonGenerator.writeString(filterDim);
            }
            this.jsonGenerator.writeEndArray();
        }
    }

    private void writeFormulaMap(Map<String, Map<String, String>> formulaMap, String key) throws IOException {
        if (formulaMap != null && !formulaMap.isEmpty()) {
            this.jsonGenerator.writeObjectFieldStart(key);
            for (Map.Entry<String, Map<String, String>> formula : formulaMap.entrySet()) {
                this.jsonGenerator.writeObjectFieldStart(formula.getKey());
                for (Map.Entry<String, String> entry : formula.getValue().entrySet()) {
                    this.jsonGenerator.writeStringField(entry.getKey(), entry.getValue());
                }
                this.jsonGenerator.writeEndObject();
            }
            this.jsonGenerator.writeEndObject();
        }
    }

    private void writeDimensionViews(Map<String, Long> dimemsionViews) throws IOException {
        if (dimemsionViews != null && !dimemsionViews.isEmpty()) {
            this.jsonGenerator.writeObjectFieldStart("dimemsionViews");
            for (Map.Entry<String, Long> dimView : dimemsionViews.entrySet()) {
                this.jsonGenerator.writeStringField(dimView.getKey(), String.valueOf(dimView.getValue()));
            }
            this.jsonGenerator.writeEndObject();
        }
    }

    private void writeAreaRanges(List<IMultiAreaSetting> areaRanges) throws IOException {
        if (areaRanges != null && areaRanges.size() > 0) {
            this.jsonGenerator.writeArrayFieldStart("areaRanges");
            for (IMultiAreaSetting areaRange : areaRanges) {
                this.jsonGenerator.writeStartObject();
                this.jsonGenerator.writeStringField("areaRange", areaRange.getAreaRange());
                this.jsonGenerator.writeStringField("startPosition", areaRange.getStartPosition());
                this.writeAreaViewEntry(areaRange.getAreaViewpointmembentry());
                this.jsonGenerator.writeArrayFieldStart("rowdims");
                for (String rowdim : areaRange.getRowdims()) {
                    this.jsonGenerator.writeString(rowdim);
                }
                this.jsonGenerator.writeEndArray();
                this.jsonGenerator.writeArrayFieldStart("coldims");
                for (String coldim : areaRange.getColdims()) {
                    this.jsonGenerator.writeString(coldim);
                }
                this.jsonGenerator.writeEndArray();
                this.jsonGenerator.writeStringField("rowheaders", SerializationUtils.toJsonString(areaRange.getRowHeaders()));
                this.jsonGenerator.writeStringField("colheaders", SerializationUtils.toJsonString(areaRange.getColHeaders()));
                this.writeSheet(areaRange.getAreaSheet());
                this.jsonGenerator.writeNumberField("floatOnWhere", areaRange.getFloatOnWhere());
                this.writeFloatInfos(areaRange.getFloatInfos());
                this.writeDynamicTitle(areaRange.getFixTemplateDynTitle());
                Map<String, Set<CellHyperLinkPOJO>> cellHyperLinkInfo = areaRange.getCellHyperLinkMap();
                String cellHyperLinkInfoStr = "";
                if (cellHyperLinkInfo != null && cellHyperLinkInfo.size() > 0) {
                    cellHyperLinkInfoStr = SerializationUtils.toJsonString(cellHyperLinkInfo);
                }
                this.jsonGenerator.writeStringField("cellHyperLink", cellHyperLinkInfoStr);
                String propertysJsonStr = "";
                if (areaRange.getDimPropertys().size() > 0) {
                    propertysJsonStr = SerializationUtils.toJsonString(areaRange.getDimPropertys());
                }
                this.jsonGenerator.writeStringField("DimPropertys", propertysJsonStr);
                this.jsonGenerator.writeBooleanField("userStyle", areaRange.isUserStyle());
                this.writeRowSeqSetting(areaRange.getRowSeq());
                this.jsonGenerator.writeEndObject();
            }
            this.jsonGenerator.writeEndArray();
        }
    }

    private void writeRowSeqSetting(FixReportRowSeqDto fixReportRowSeqDto) throws IOException {
        if (fixReportRowSeqDto == null) {
            return;
        }
        this.jsonGenerator.writeObjectFieldStart("fixReportRowSeqDto");
        if (fixReportRowSeqDto.getSeqSuffix() != null) {
            this.jsonGenerator.writeStringField("seqSuffix", fixReportRowSeqDto.getSeqSuffix());
        }
        if (fixReportRowSeqDto.getSeqPrefix() != null) {
            this.jsonGenerator.writeStringField("seqPrefix", fixReportRowSeqDto.getSeqPrefix());
        }
        if (fixReportRowSeqDto.getSeqcol() != null) {
            this.jsonGenerator.writeNumberField("seqcol", fixReportRowSeqDto.getSeqcol().intValue());
        }
        if (fixReportRowSeqDto.getSeqstart() != null) {
            this.jsonGenerator.writeNumberField("seqstart", fixReportRowSeqDto.getSeqstart().intValue());
        }
        this.jsonGenerator.writeBooleanField("totalRowNeedSeq", fixReportRowSeqDto.isTotalRowNeedSeq());
        this.jsonGenerator.writeEndObject();
    }

    private void writeDynamicTitle(List<FixTemplateDynTitle> fixTemplateDynTitles) throws IOException {
        if (fixTemplateDynTitles == null || fixTemplateDynTitles.size() == 0) {
            return;
        }
        this.jsonGenerator.writeArrayFieldStart("titles");
        for (FixTemplateDynTitle fixTemplateDynTitle : fixTemplateDynTitles) {
            this.jsonGenerator.writeStartObject();
            this.jsonGenerator.writeStringField("tRange", fixTemplateDynTitle.getTitleRange());
            this.jsonGenerator.writeStringField("tPrefix", fixTemplateDynTitle.getTitlePrefix());
            this.jsonGenerator.writeStringField("tDim", fixTemplateDynTitle.getTitleDimension());
            this.jsonGenerator.writeStringField("tSpType", fixTemplateDynTitle.getTitleSplitType());
            this.jsonGenerator.writeNumberField("tSpCount", fixTemplateDynTitle.getTitleSplitCount());
            this.jsonGenerator.writeStringField("tSuffix", fixTemplateDynTitle.getTitleSuffix());
            this.jsonGenerator.writeStringField("tSPosition", fixTemplateDynTitle.getTitleStartPosition());
            this.jsonGenerator.writeStringField("tEPosition", fixTemplateDynTitle.getTitleEndPosition());
            this.jsonGenerator.writeEndObject();
        }
        this.jsonGenerator.writeEndArray();
    }

    private void writeFloatInfos(List<MultiAreaSetting.FloatInfo> floatInfos) throws IOException {
        if (floatInfos == null || floatInfos.size() == 0) {
            return;
        }
        this.jsonGenerator.writeArrayFieldStart("floatInfos");
        for (MultiAreaSetting.FloatInfo floatInfo : floatInfos) {
            this.jsonGenerator.writeStartObject();
            this.jsonGenerator.writeNumberField("row_offset", floatInfo.getRow_offset());
            this.jsonGenerator.writeNumberField("rowEnd_offset", floatInfo.getRowEnd_offset());
            this.jsonGenerator.writeNumberField("col_offset", floatInfo.getCol_offset());
            this.jsonGenerator.writeNumberField("colEnd_offset", floatInfo.getColEnd_offset());
            if (floatInfo.getLockCols() != null && floatInfo.getLockCols().size() > 0) {
                this.jsonGenerator.writeStringField("lockcols", SerializationUtils.toJsonString(floatInfo.getLockCols()));
            }
            this.jsonGenerator.writeNumberField("rangeType", floatInfo.getRangeType());
            this.jsonGenerator.writeBooleanField("filterTopItems", floatInfo.isFilterTopItems());
            this.jsonGenerator.writeObjectFieldStart("partition");
            this.writeOneRCPartion(floatInfo.getPartition());
            this.jsonGenerator.writeEndObject();
            if (floatInfo.getTotalRowSortInfos() != null && floatInfo.getTotalRowSortInfos().size() > 0) {
                this.wtireTotalRowSortInfo(floatInfo);
            }
            if (floatInfo.getTotalRowFormatInfos() != null && floatInfo.getTotalRowFormatInfos().size() > 0) {
                this.wtireTotalRowFormatInfo(floatInfo);
            }
            this.jsonGenerator.writeEndObject();
        }
        this.jsonGenerator.writeEndArray();
    }

    private void wtireTotalRowSortInfo(MultiAreaSetting.FloatInfo floatInfo) throws IOException {
        this.jsonGenerator.writeArrayFieldStart("totalRowSortInfos");
        for (FixReportSortDiminfoDto totalRowSortInfo : floatInfo.getTotalRowSortInfos()) {
            this.jsonGenerator.writeStartObject();
            this.jsonGenerator.writeStringField("dimnumber", totalRowSortInfo.getDimnumber());
            this.jsonGenerator.writeStringField("levelCombo", totalRowSortInfo.getLevelCombo());
            this.jsonGenerator.writeStringField("sortOrder", totalRowSortInfo.getSortOrder());
            this.jsonGenerator.writeStringField("orderBy", totalRowSortInfo.getOrderBy());
            this.jsonGenerator.writeNumberField("index", totalRowSortInfo.getIndex());
            this.jsonGenerator.writeBooleanField("custom", totalRowSortInfo.isCustom());
            this.jsonGenerator.writeEndObject();
        }
        this.jsonGenerator.writeEndArray();
    }

    private void wtireTotalRowFormatInfo(MultiAreaSetting.FloatInfo floatInfo) throws IOException {
        this.jsonGenerator.writeArrayFieldStart("totalRowFormatInfos");
        for (FixReportTotalTitleFormatDto totalTitleFormatDto : floatInfo.getTotalRowFormatInfos()) {
            this.jsonGenerator.writeStartObject();
            this.jsonGenerator.writeStringField("dimnumber", totalTitleFormatDto.getDimNumber());
            this.jsonGenerator.writeStringField("format", totalTitleFormatDto.getFormat());
            this.jsonGenerator.writeStringField("suffix", totalTitleFormatDto.getSuffix());
            this.jsonGenerator.writeStringField("prefix", totalTitleFormatDto.getPrefix());
            this.jsonGenerator.writeEndObject();
        }
        this.jsonGenerator.writeEndArray();
    }

    private void writeSheet(ISheet areaSheet) throws IOException {
        this.jsonGenerator.writeObjectFieldStart("areaSheet");
        this.eSheetSerializer.serialize(areaSheet);
        this.jsonGenerator.writeEndObject();
    }

    private void writeRowColDims(List<String> rowcolDims) throws IOException {
        if (rowcolDims != null && rowcolDims.size() > 0) {
            this.jsonGenerator.writeArrayFieldStart("rowcolDims");
            for (String rowcolDim : rowcolDims) {
                this.jsonGenerator.writeString(rowcolDim);
            }
            this.jsonGenerator.writeEndArray();
        }
    }

    private void writeBgtemplate(BgTemplate templateBaseInfo) throws IOException {
        if (templateBaseInfo == null) {
            return;
        }
        this.jsonGenerator.writeObjectFieldStart("baseinfo");
        this.jsonGenerator.writeNumberField("templateid", templateBaseInfo.getId().longValue());
        this.jsonGenerator.writeStringField("name", templateBaseInfo.getName());
        this.jsonGenerator.writeStringField("number", templateBaseInfo.getNumber());
        this.jsonGenerator.writeNumberField("catalog", templateBaseInfo.getCatalog().longValue());
        this.jsonGenerator.writeNumberField("model", templateBaseInfo.getModelID().longValue());
        this.jsonGenerator.writeNumberField("dataset", templateBaseInfo.getDatasetID().longValue());
        this.jsonGenerator.writeStringField("dataunit", templateBaseInfo.getDataunit());
        this.jsonGenerator.writeNumberField("templatetype", templateBaseInfo.getTemplatetype());
        this.jsonGenerator.writeStringField("varbaseforeb", templateBaseInfo.getVarBase());
        this.jsonGenerator.writeStringField("spreadType", templateBaseInfo.getSpreadType());
        this.jsonGenerator.writeStringField("taskDimMap", templateBaseInfo.getTaskDimMap());
        this.jsonGenerator.writeStringField("sysDimMap", templateBaseInfo.getSysDimMap());
        this.jsonGenerator.writeStringField("satatus", templateBaseInfo.getStatus());
        this.jsonGenerator.writeStringField("isReadOnly", templateBaseInfo.getIsReadOnly());
        this.jsonGenerator.writeStringField("isDimRelation", templateBaseInfo.getIsDimRelation());
        this.jsonGenerator.writeEndObject();
    }

    private void writeMetricCellStyle(List<MetricCellStyleInfo> metricCellStyleInfo) throws IOException {
        if (metricCellStyleInfo == null || metricCellStyleInfo.isEmpty()) {
            return;
        }
        this.jsonGenerator.writeArrayFieldStart("metriccellstyle");
        for (MetricCellStyleInfo m : metricCellStyleInfo) {
            this.jsonGenerator.writeStartObject();
            this.jsonGenerator.writeStringField("metricnum", m.getMetricNumber());
            this.jsonGenerator.writeNumberField("dt", m.getDatatype().intValue());
            this.jsonGenerator.writeStringField("fm", m.getFm());
            if (m.getMustInput() != null) {
                this.jsonGenerator.writeBooleanField("mustinput", m.getMustInput().booleanValue());
            }
            if (m.getUseRptunit() != null) {
                this.jsonGenerator.writeBooleanField("userptunit", m.getUseRptunit().booleanValue());
            }
            if (m.getUnit() != null) {
                this.jsonGenerator.writeStringField("unit", m.getUnit());
            }
            this.jsonGenerator.writeEndObject();
        }
        this.jsonGenerator.writeEndArray();
    }

    private void writePageEntry(List<IPageDimensionEntry> pagemembentrys) throws IOException {
        if (pagemembentrys == null || pagemembentrys.size() == 0) {
            return;
        }
        this.jsonGenerator.writeArrayFieldStart("pageentry");
        for (IPageDimensionEntry pagemembentry : pagemembentrys) {
            this.jsonGenerator.writeStartObject();
            this.writeOnePageEntry(pagemembentry);
            this.jsonGenerator.writeEndObject();
        }
        this.jsonGenerator.writeEndArray();
    }

    private void writeOnePageEntry(IPageDimensionEntry pagemembentry) throws IOException {
        this.jsonGenerator.writeStringField("dimnum", pagemembentry.getDimension().getNumber());
        if (pagemembentry.getMembers() != null && pagemembentry.getMembers().size() > 0) {
            this.jsonGenerator.writeArrayFieldStart("mem");
            for (IDimensionMember member : pagemembentry.getMembers()) {
                this.jsonGenerator.writeStartObject();
                this.jsonGenerator.writeStringField("dimmemnum", member.getNumber());
                if (member instanceof DefaultDimMember && ((DefaultDimMember)member).getType() != null) {
                    this.jsonGenerator.writeStringField("dimmemtype", ((DefaultDimMember)member).getType());
                    this.jsonGenerator.writeStringField("dimmemlongnum", ((DefaultDimMember)member).getLongNumber());
                }
                this.jsonGenerator.writeNumberField("scope", member.getScope());
                this.jsonGenerator.writeEndObject();
            }
            this.jsonGenerator.writeEndArray();
        }
    }

    private void writeOneRCPartion(RowColPartition rowColPartition) throws IOException {
        if (rowColPartition.getRowColDimensionEntries() != null && rowColPartition.getRowColDimensionEntries().size() > 0) {
            this.jsonGenerator.writeArrayFieldStart("rowColDimensionEntries");
            for (IRowColDimensionEntry rcEntity : rowColPartition.getRowColDimensionEntries()) {
                this.jsonGenerator.writeStartObject();
                this.jsonGenerator.writeBooleanField("isFloat", rcEntity.isFloat());
                if (rcEntity.isQuickAddNew()) {
                    this.jsonGenerator.writeBooleanField("isQAdd", true);
                    if (rcEntity.getDefaultParentNum() != null) {
                        this.jsonGenerator.writeStringField("addpnumber", rcEntity.getDefaultParentNum());
                    }
                }
                this.writeOnePageEntry(rcEntity);
                this.jsonGenerator.writeEndObject();
            }
            this.jsonGenerator.writeEndArray();
        }
    }

    private void writeViewEntry(List<IViewPointDimensionEntry> viewpointmembentrys) throws IOException {
        this.writeOneDimEntry(viewpointmembentrys, "viewentry");
    }

    private void writeAreaViewEntry(List<IViewPointDimensionEntry> areaviewpointmembentrys) throws IOException {
        this.writeOneDimEntry(areaviewpointmembentrys, "areaviewentry");
    }

    private void writeHideEntry(List<IViewPointDimensionEntry> hidedimentrys) throws IOException {
        this.writeOneDimEntry(hidedimentrys, "hidentry");
    }

    private void writeOneDimEntry(List<IViewPointDimensionEntry> entrys, String prefix) throws IOException {
        if (entrys == null || entrys.size() == 0) {
            return;
        }
        this.jsonGenerator.writeArrayFieldStart(prefix);
        for (IViewPointDimensionEntry entry : entrys) {
            this.jsonGenerator.writeStartObject();
            this.jsonGenerator.writeStringField("dimnum", entry.getDimension().getNumber());
            this.jsonGenerator.writeStringField("dimmemnum", entry.getMember().getNumber());
            this.jsonGenerator.writeEndObject();
        }
        this.jsonGenerator.writeEndArray();
    }
}

