/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.template.afix.serializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.epm.eb.common.dimension.property.PropertyObj;
import kd.epm.eb.common.reportprocess.entity.dto.FixReportRowSeqDto;
import kd.epm.eb.common.reportprocess.entity.dto.FixReportSortDiminfoDto;
import kd.epm.eb.common.reportprocess.entity.dto.FixReportTotalTitleFormatDto;
import kd.epm.eb.spread.template.BgTemplate;
import kd.epm.eb.spread.template.afix.FixTemplateModel;
import kd.epm.eb.spread.template.afix.multisetting.CellHyperLinkPOJO;
import kd.epm.eb.spread.template.afix.multisetting.FixTemplateDynTitle;
import kd.epm.eb.spread.template.afix.multisetting.IMultiAreaSetting;
import kd.epm.eb.spread.template.afix.multisetting.MultiAreaSetting;
import kd.epm.eb.spread.template.afix.serializer.FixSerializerCommonUtils;
import kd.epm.eb.spread.template.arearangedim.DefaultRowColDimensionEntry;
import kd.epm.eb.spread.template.arearangedim.IRowColDimensionEntry;
import kd.epm.eb.spread.template.dimension.DefaultDimMember;
import kd.epm.eb.spread.template.dimension.DefaultDimension;
import kd.epm.eb.spread.template.headerarea.HeaderInfo;
import kd.epm.eb.spread.template.headerarea.IHeaderInfo;
import kd.epm.eb.spread.template.pagedim.DefaultPageDimensionEntry;
import kd.epm.eb.spread.template.pagedim.IPageDimensionEntry;
import kd.epm.eb.spread.template.partition.RowColPartition;
import kd.epm.eb.spread.template.spread.style.MetricCellStyleInfo;
import kd.epm.eb.spread.template.spreadmanager.serializer.ESheetDeSerializer;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import kd.epm.eb.spread.template.viewpointdim.DefaultViewPointDimensionEntry;

public class FixtemplateDeserializer
extends JsonDeserializer<FixTemplateModel> {
    private DeserializationContext deserializationContext;

    public FixTemplateModel deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        this.deserializationContext = deserializationContext;
        FixTemplateModel fixTemplateModel = new FixTemplateModel();
        JsonNode rootNode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        this.readHideEntry(rootNode, fixTemplateModel);
        this.readViewEntry(rootNode, fixTemplateModel);
        this.readPageEntry(rootNode, fixTemplateModel);
        this.readBgtemplate(rootNode, fixTemplateModel);
        this.readMetricCellStyle(rootNode, fixTemplateModel);
        this.readRowColDims(rootNode, fixTemplateModel);
        this.readAreaRanges(rootNode, fixTemplateModel);
        this.readFilterDims(rootNode, fixTemplateModel);
        fixTemplateModel.getDimemsionViews().putAll(this.readDimensionViews(rootNode));
        fixTemplateModel.getFormulaMap().putAll(this.readFormulaMap(rootNode, "formulaMap"));
        fixTemplateModel.getOutAreaHyperLink().putAll(this.readFormulaMap(rootNode, "outAreaHyperLink"));
        return fixTemplateModel;
    }

    private void readFilterDims(JsonNode rootNode, FixTemplateModel fixTemplateModel) {
        if (rootNode == null || rootNode.get("filterDims") == null) {
            return;
        }
        Iterator filterNodes = rootNode.get("filterDims").elements();
        while (filterNodes != null && filterNodes.hasNext()) {
            fixTemplateModel.getFilterDims().add(((JsonNode)filterNodes.next()).textValue());
        }
    }

    private Map<String, Map<String, String>> readFormulaMap(JsonNode rootNode, String key) {
        HashMap<String, Map<String, String>> formulaMap = new HashMap<String, Map<String, String>>(16);
        JsonNode node = rootNode.get(key);
        if (node != null) {
            Iterator fields = node.fields();
            while (fields.hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                JsonNode fieldNode = (JsonNode)field.getValue();
                Iterator fieldsEntry = fieldNode.fields();
                HashMap formula = new HashMap(16);
                while (fieldsEntry.hasNext()) {
                    Map.Entry field1 = (Map.Entry)fieldsEntry.next();
                    formula.put(field1.getKey(), field1.getValue() != null ? ((JsonNode)field1.getValue()).asText() : "");
                }
                formulaMap.put((String)field.getKey(), formula);
            }
        }
        return formulaMap;
    }

    private Map<String, Long> readDimensionViews(JsonNode rootNode) {
        HashMap<String, Long> dimensionViews = new HashMap<String, Long>();
        JsonNode node = rootNode.get("dimemsionViews");
        if (node != null) {
            Iterator fields = node.fields();
            while (fields.hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                dimensionViews.put((String)field.getKey(), field.getValue() != null ? Long.parseLong(((JsonNode)field.getValue()).asText()) : 0L);
            }
        }
        return dimensionViews;
    }

    private void readAreaRanges(JsonNode rootNode, FixTemplateModel fixTemplateModel) {
        JsonNode area_root = rootNode.get("areaRanges");
        if (area_root == null) {
            return;
        }
        Iterator areanodes = area_root.elements();
        ESheetDeSerializer eSheetDeSerializer = new ESheetDeSerializer(this.deserializationContext);
        while (areanodes != null && areanodes.hasNext()) {
            JsonNode rowheadersnode;
            JsonNode areanode = (JsonNode)areanodes.next();
            MultiAreaSetting multiAreaSetting = new MultiAreaSetting();
            multiAreaSetting.setAreaRange(areanode.get("areaRange").asText());
            multiAreaSetting.setStartPosition(areanode.get("startPosition").asText());
            this.readAreaViewEntry(areanode, multiAreaSetting);
            Iterator rowdimnodes = areanode.get("rowdims").elements();
            while (rowdimnodes != null && rowdimnodes.hasNext()) {
                multiAreaSetting.getRowdims().add(((JsonNode)rowdimnodes.next()).textValue());
            }
            Iterator coldimnodes = areanode.get("coldims").elements();
            while (coldimnodes != null && coldimnodes.hasNext()) {
                multiAreaSetting.getColdims().add(((JsonNode)coldimnodes.next()).textValue());
            }
            multiAreaSetting.setFloatOnWhere(areanode.get("floatOnWhere").asInt());
            this.readSheet(multiAreaSetting, areanode, eSheetDeSerializer);
            this.readFloatInfos(multiAreaSetting, areanode);
            this.readRowSeqSetting(multiAreaSetting, areanode);
            this.readDynamicTitle(multiAreaSetting, areanode);
            this.readCellHyperLinkInfo(multiAreaSetting, areanode.get("cellHyperLink"));
            this.readDimPropertys(multiAreaSetting, areanode.get("DimPropertys"));
            if (areanode.get("userStyle") != null) {
                multiAreaSetting.setUserStyle(areanode.get("userStyle").asBoolean());
            }
            if ((rowheadersnode = areanode.get("rowheaders")) != null) {
                multiAreaSetting.setRowHeaders(this.readHeaderInfo((List)SerializationUtils.fromJsonString((String)rowheadersnode.asText(), List.class)));
            } else {
                multiAreaSetting.setRowHeaders(this.readHeaderInfo(multiAreaSetting.getRowdims(), multiAreaSetting.getDimPropertys()));
            }
            JsonNode colheadersnode = areanode.get("colheaders");
            if (colheadersnode != null) {
                multiAreaSetting.setColHeaders(this.readHeaderInfo((List)SerializationUtils.fromJsonString((String)colheadersnode.asText(), List.class)));
            } else {
                multiAreaSetting.setColHeaders(this.readHeaderInfo(multiAreaSetting.getColdims(), multiAreaSetting.getDimPropertys()));
            }
            fixTemplateModel.getAreaRanges().add(multiAreaSetting);
        }
    }

    private void readDimPropertys(IMultiAreaSetting multiAreaSetting, JsonNode propertyNode) {
        HashMap<String, List<PropertyObj>> propertys = new HashMap();
        propertys = FixSerializerCommonUtils.getDimPropertys(propertyNode);
        multiAreaSetting.setDimPropertys(propertys);
    }

    private void readRowSeqSetting(IMultiAreaSetting multiAreaSetting, JsonNode areanode) {
        JsonNode jsonNode = areanode.get("fixReportRowSeqDto");
        if (jsonNode == null) {
            return;
        }
        FixReportRowSeqDto fixReportRowSeqDto = new FixReportRowSeqDto();
        if (jsonNode.get("seqcol") != null) {
            fixReportRowSeqDto.setSeqcol(Integer.valueOf(jsonNode.get("seqcol").asInt()));
        }
        if (jsonNode.get("seqstart") != null) {
            fixReportRowSeqDto.setSeqstart(Integer.valueOf(jsonNode.get("seqstart").asInt()));
        }
        if (jsonNode.get("seqSuffix") != null) {
            fixReportRowSeqDto.setSeqSuffix(jsonNode.get("seqSuffix").asText());
        }
        if (jsonNode.get("seqPrefix") != null) {
            fixReportRowSeqDto.setSeqPrefix(jsonNode.get("seqPrefix").asText());
        }
        if (jsonNode.get("totalRowNeedSeq") != null) {
            fixReportRowSeqDto.setTotalRowNeedSeq(jsonNode.get("totalRowNeedSeq").asBoolean(false));
        }
        multiAreaSetting.setRowSeq(fixReportRowSeqDto);
    }

    private void readFloatInfos(IMultiAreaSetting multiAreaSetting, JsonNode areanode) {
        JsonNode float_root = areanode.get("floatInfos");
        if (float_root == null) {
            return;
        }
        Iterator infos = float_root.elements();
        while (infos != null && infos.hasNext()) {
            Iterator elements;
            JsonNode info = (JsonNode)infos.next();
            MultiAreaSetting.FloatInfo floatInfo = new MultiAreaSetting.FloatInfo();
            floatInfo.setRow_offset(info.get("row_offset").asInt());
            floatInfo.setRowEnd_offset(info.get("rowEnd_offset").asInt());
            floatInfo.setCol_offset(info.get("col_offset").asInt());
            floatInfo.setColEnd_offset(info.get("colEnd_offset").asInt());
            if (info.get("rangeType") != null) {
                floatInfo.setRangeType(info.get("rangeType").asInt());
            }
            if (info.get("filterTopItems") != null) {
                floatInfo.setFilterTopItems(info.get("filterTopItems").asBoolean());
            }
            if (info.get("totalRowSortInfos") != null) {
                elements = info.get("totalRowSortInfos").elements();
                ArrayList<FixReportSortDiminfoDto> sortDiminfoDtos = new ArrayList<FixReportSortDiminfoDto>(16);
                while (elements.hasNext()) {
                    JsonNode totalRowSortInfoNode = (JsonNode)elements.next();
                    FixReportSortDiminfoDto fixReportSortDiminfoDto = new FixReportSortDiminfoDto();
                    fixReportSortDiminfoDto.setDimnumber(totalRowSortInfoNode.get("dimnumber").asText());
                    fixReportSortDiminfoDto.setCustom(totalRowSortInfoNode.get("custom").asBoolean());
                    fixReportSortDiminfoDto.setSortOrder(totalRowSortInfoNode.get("sortOrder").asText());
                    fixReportSortDiminfoDto.setLevelCombo(totalRowSortInfoNode.get("levelCombo").asText());
                    fixReportSortDiminfoDto.setOrderBy(totalRowSortInfoNode.get("orderBy").asText());
                    fixReportSortDiminfoDto.setIndex(totalRowSortInfoNode.get("index").asInt());
                    sortDiminfoDtos.add(fixReportSortDiminfoDto);
                }
                floatInfo.setTotalRowSortInfos(sortDiminfoDtos);
            }
            if (info.get("totalRowFormatInfos") != null) {
                elements = info.get("totalRowFormatInfos").elements();
                ArrayList<FixReportTotalTitleFormatDto> fixReportTotalTitleFormatDtos = new ArrayList<FixReportTotalTitleFormatDto>(16);
                while (elements.hasNext()) {
                    JsonNode totalRowFormat = (JsonNode)elements.next();
                    FixReportTotalTitleFormatDto fixReportTotalTitleFormatDto = new FixReportTotalTitleFormatDto();
                    fixReportTotalTitleFormatDto.setDimNumber(totalRowFormat.get("dimnumber").asText());
                    fixReportTotalTitleFormatDto.setFormat(totalRowFormat.get("format").asText());
                    fixReportTotalTitleFormatDto.setSuffix(totalRowFormat.get("suffix").asText());
                    fixReportTotalTitleFormatDto.setPrefix(totalRowFormat.get("prefix").asText());
                    fixReportTotalTitleFormatDtos.add(fixReportTotalTitleFormatDto);
                }
                floatInfo.setTotalRowFormatInfos(fixReportTotalTitleFormatDtos);
            }
            if (info.get("lockcols") != null) {
                floatInfo.setLockCols((Set)SerializationUtils.fromJsonString((String)info.get("lockcols").asText(), Set.class));
            }
            floatInfo.setPartition(this.readRCPartition(info.get("partition")));
            multiAreaSetting.getFloatInfos().add(floatInfo);
        }
    }

    private void readDynamicTitle(IMultiAreaSetting multiAreaSetting, JsonNode areanode) {
        JsonNode dynamicTitle = areanode.get("titles");
        if (dynamicTitle == null) {
            return;
        }
        Iterator infos = dynamicTitle.elements();
        while (infos != null && infos.hasNext()) {
            JsonNode info = (JsonNode)infos.next();
            FixTemplateDynTitle fixTemplateDynTitle = new FixTemplateDynTitle();
            if (info.get("tRange") == null || info.get("tDim") == null || info.get("tSpType") == null || info.get("tSPosition") == null || info.get("tEPosition") == null) continue;
            fixTemplateDynTitle.setTitleRange(info.get("tRange").asText());
            fixTemplateDynTitle.setTitlePrefix(info.get("tPrefix").asText());
            fixTemplateDynTitle.setTitleDimension(info.get("tDim").asText());
            fixTemplateDynTitle.setTitleSplitType(info.get("tSpType").asText());
            fixTemplateDynTitle.setTitleSplitCount(info.get("tSpCount").asInt());
            fixTemplateDynTitle.setTitleSuffix(info.get("tSuffix").asText());
            fixTemplateDynTitle.setTitleStartPosition(info.get("tSPosition").asText());
            fixTemplateDynTitle.setTitleEndPosition(info.get("tEPosition").asText());
            multiAreaSetting.getFixTemplateDynTitle().add(fixTemplateDynTitle);
        }
    }

    private void readCellHyperLinkInfo(IMultiAreaSetting multiAreaSetting, JsonNode areanode) {
        HashMap<String, Set<CellHyperLinkPOJO>> cellLinks = new HashMap();
        cellLinks = FixSerializerCommonUtils.getCellHyperLinkMap(areanode);
        multiAreaSetting.setCellHyperLinkMap(cellLinks);
    }

    private RowColPartition readRCPartition(JsonNode jsonNode) {
        if (jsonNode == null) {
            return null;
        }
        RowColPartition partition = new RowColPartition();
        Iterator entityNodes = jsonNode.get("rowColDimensionEntries").elements();
        JsonNode node = null;
        IRowColDimensionEntry entry = null;
        while (entityNodes != null && entityNodes.hasNext()) {
            node = (JsonNode)entityNodes.next();
            entry = this.readRowColDimEntry(node);
            if (entry == null) continue;
            partition.addOneRowColDimensionEntry(entry);
        }
        return partition;
    }

    private IRowColDimensionEntry readRowColDimEntry(JsonNode jsonNode) {
        JsonNode isQuickAddNew;
        if (jsonNode == null || jsonNode.get("dimnum") == null) {
            return null;
        }
        DefaultRowColDimensionEntry pageentry = new DefaultRowColDimensionEntry();
        DefaultDimension dimension = new DefaultDimension();
        dimension.setNumber(jsonNode.get("dimnum").asText());
        pageentry.setDimension(dimension);
        pageentry.setDefaultParentNum(jsonNode.get("addpnumber") == null ? null : jsonNode.get("addpnumber").asText());
        JsonNode isFloat = jsonNode.get("isFloat");
        if (isFloat != null) {
            pageentry.setFloat(isFloat.asBoolean());
        }
        if ((isQuickAddNew = jsonNode.get("isQAdd")) != null) {
            pageentry.setQuickAddNew(isQuickAddNew.asBoolean());
        }
        if (jsonNode.get("mem") != null) {
            Iterator membernodes = jsonNode.get("mem").elements();
            while (membernodes != null && membernodes.hasNext()) {
                JsonNode membernode = (JsonNode)membernodes.next();
                DefaultDimMember dimMember = new DefaultDimMember();
                dimMember.setNumber(membernode.get("dimmemnum").asText());
                if (membernode.get("dimmemtype") != null) {
                    dimMember.setType(membernode.get("dimmemtype").asText());
                }
                if (membernode.get("dimmemlongnum") != null) {
                    dimMember.setLongNumber(membernode.get("dimmemlongnum").asText());
                }
                dimMember.setScope(membernode.get("scope").asInt());
                pageentry.addOneMember(dimMember);
            }
        }
        return pageentry;
    }

    private void readSheet(IMultiAreaSetting multiAreaSetting, JsonNode areanode, ESheetDeSerializer eSheetDeSerializer) {
        if (areanode == null) {
            return;
        }
        JsonNode sheetnode = areanode.get("areaSheet");
        if (sheetnode != null) {
            ISheet sheet = eSheetDeSerializer.readSheet(sheetnode);
            multiAreaSetting.setAreaSheet(sheet);
        }
    }

    private void readRowColDims(JsonNode rootNode, FixTemplateModel fixTemplateModel) {
        if (rootNode == null || rootNode.get("rowcolDims") == null) {
            return;
        }
        Iterator rowcolnodes = rootNode.get("rowcolDims").elements();
        while (rowcolnodes != null && rowcolnodes.hasNext()) {
            fixTemplateModel.getRowcolDims().add(((JsonNode)rowcolnodes.next()).textValue());
        }
    }

    private void readBgtemplate(JsonNode rootNode, FixTemplateModel fixTemplateModel) {
        if (rootNode == null) {
            return;
        }
        JsonNode baseinfonode = rootNode.get("baseinfo");
        if (baseinfonode != null) {
            BgTemplate bgTemplate = new BgTemplate();
            bgTemplate.setId(baseinfonode.get("templateid").asLong());
            bgTemplate.setName(baseinfonode.get("name").isNull() ? null : baseinfonode.get("name").asText());
            bgTemplate.setNumber(baseinfonode.get("number").isNull() ? null : baseinfonode.get("number").asText());
            bgTemplate.setCatalog(baseinfonode.get("catalog").asLong());
            bgTemplate.setModelID(baseinfonode.get("model").asLong());
            bgTemplate.setDatasetID(baseinfonode.get("dataset").asLong());
            bgTemplate.setDataunit(baseinfonode.get("dataunit").isNull() ? null : baseinfonode.get("dataunit").asText());
            bgTemplate.setTemplatetype(baseinfonode.get("templatetype").asInt());
            bgTemplate.setVarBase(baseinfonode.get("varbaseforeb").isNull() ? null : baseinfonode.get("varbaseforeb").asText());
            bgTemplate.setSpreadType(baseinfonode.get("spreadType").isNull() ? null : baseinfonode.get("spreadType").asText());
            bgTemplate.setSysDimMap(baseinfonode.get("sysDimMap").isNull() ? null : baseinfonode.get("sysDimMap").asText());
            bgTemplate.setStatus(baseinfonode.get("satatus").isNull() ? null : baseinfonode.get("satatus").asText());
            bgTemplate.setIsDimRelation(baseinfonode.get("isReadOnly") == null ? null : baseinfonode.get("isReadOnly").asText());
            bgTemplate.setIsDimRelation(baseinfonode.get("isDimRelation") == null ? null : baseinfonode.get("isDimRelation").asText());
            fixTemplateModel.setTemplateBaseInfo(bgTemplate);
        }
    }

    private void readMetricCellStyle(JsonNode rootNode, FixTemplateModel fixTemplateModel) {
        if (rootNode == null || rootNode.get("metriccellstyle") == null) {
            return;
        }
        Iterator stylenodes = rootNode.get("metriccellstyle").elements();
        if (stylenodes != null) {
            ArrayList<MetricCellStyleInfo> metricCellStyleInfo = new ArrayList<MetricCellStyleInfo>();
            while (stylenodes.hasNext()) {
                JsonNode stylenode = (JsonNode)stylenodes.next();
                MetricCellStyleInfo msi = new MetricCellStyleInfo();
                msi.setMetricNumber(stylenode.get("metricnum").asText());
                msi.setDatatype(stylenode.get("dt").asInt());
                msi.setFm(stylenode.get("fm").asText());
                if (stylenode.get("mustinput") != null) {
                    msi.setMustInput(stylenode.get("mustinput").asBoolean());
                }
                if (stylenode.get("userptunit") != null) {
                    msi.setUseRptunit(stylenode.get("userptunit").asBoolean());
                }
                if (stylenode.get("unit") != null) {
                    msi.setUnit(stylenode.get("unit").asText());
                }
                metricCellStyleInfo.add(msi);
            }
            fixTemplateModel.setMetricCellStyleInfo(metricCellStyleInfo);
        }
    }

    private void readPageEntry(JsonNode rootNode, FixTemplateModel fixTemplateModel) {
        if (rootNode == null || rootNode.get("pageentry") == null) {
            return;
        }
        Iterator viewnodes = rootNode.get("pageentry").elements();
        while (viewnodes != null && viewnodes.hasNext()) {
            JsonNode viewnode = (JsonNode)viewnodes.next();
            IPageDimensionEntry pageDimensionEntry = this.readOnePageEntry(viewnode);
            fixTemplateModel.addPagemembentry(pageDimensionEntry);
        }
    }

    private IPageDimensionEntry readOnePageEntry(JsonNode viewnode) {
        DefaultPageDimensionEntry pageentry = new DefaultPageDimensionEntry();
        DefaultDimension dimension = new DefaultDimension();
        dimension.setNumber(viewnode.get("dimnum").asText());
        pageentry.setDimension(dimension);
        JsonNode memberNode = viewnode.get("mem");
        if (memberNode == null) {
            return pageentry;
        }
        Iterator membernodes = memberNode.elements();
        while (membernodes != null && membernodes.hasNext()) {
            JsonNode membernode = (JsonNode)membernodes.next();
            DefaultDimMember dimMember = new DefaultDimMember();
            dimMember.setNumber(membernode.get("dimmemnum").asText());
            dimMember.setScope(membernode.get("scope").asInt());
            pageentry.addOneMember(dimMember);
        }
        return pageentry;
    }

    private void readViewEntry(JsonNode rootNode, FixTemplateModel fixTemplateModel) {
        this.readViewEntry(rootNode, fixTemplateModel, "viewentry");
    }

    private void readAreaViewEntry(JsonNode rootNode, IMultiAreaSetting multiAreaSetting) {
        this.readAreaViewEntry(rootNode, multiAreaSetting, "areaviewentry");
    }

    private void readHideEntry(JsonNode rootNode, FixTemplateModel fixTemplateModel) {
        this.readViewEntry(rootNode, fixTemplateModel, "hidentry");
    }

    private void readViewEntry(JsonNode rootNode, FixTemplateModel fixTemplateModel, String prefix) {
        if (rootNode == null || rootNode.get(prefix) == null) {
            return;
        }
        Iterator entrys = rootNode.get(prefix).elements();
        while (entrys != null && entrys.hasNext()) {
            JsonNode entry = (JsonNode)entrys.next();
            DefaultViewPointDimensionEntry viewentry = new DefaultViewPointDimensionEntry();
            DefaultDimMember member = new DefaultDimMember();
            member.setNumber(entry.get("dimmemnum").asText());
            DefaultDimension dimension = new DefaultDimension();
            dimension.setNumber(entry.get("dimnum").asText());
            viewentry.setDimension(dimension);
            viewentry.setMember(member);
            if ("hidentry".equals(prefix)) {
                fixTemplateModel.addHidedimentry(viewentry);
                continue;
            }
            if (!"viewentry".equals(prefix)) continue;
            fixTemplateModel.addViewpointmembentry(viewentry);
        }
    }

    private void readAreaViewEntry(JsonNode rootNode, IMultiAreaSetting multiAreaSetting, String prefix) {
        if (rootNode == null || rootNode.get(prefix) == null) {
            return;
        }
        Iterator entrys = rootNode.get(prefix).elements();
        while (entrys != null && entrys.hasNext()) {
            JsonNode entry = (JsonNode)entrys.next();
            DefaultViewPointDimensionEntry viewentry = new DefaultViewPointDimensionEntry();
            DefaultDimMember member = new DefaultDimMember();
            member.setNumber(entry.get("dimmemnum").asText());
            DefaultDimension dimension = new DefaultDimension();
            dimension.setNumber(entry.get("dimnum").asText());
            viewentry.setDimension(dimension);
            viewentry.setMember(member);
            if (!"areaviewentry".equals(prefix)) continue;
            multiAreaSetting.addAreaViewpointmembentry(viewentry);
        }
    }

    private List<IHeaderInfo> readHeaderInfo(List<Map<String, Object>> listOfMaps) {
        if (listOfMaps != null) {
            ArrayList<IHeaderInfo> headerInfos = new ArrayList<IHeaderInfo>(listOfMaps.size());
            for (int i = 0; i < listOfMaps.size(); ++i) {
                Map<String, Object> map = listOfMaps.get(i);
                if (map == null) continue;
                String type = map.get("type") == null ? null : String.valueOf(map.get("type"));
                String number = map.get("number") == null ? null : String.valueOf(map.get("number"));
                String refDimension = map.get("refDimension") == null ? null : String.valueOf(map.get("refDimension"));
                HeaderInfo headerInfo = new HeaderInfo(type, number, refDimension);
                headerInfos.add(headerInfo);
            }
            return headerInfos;
        }
        return null;
    }

    private List<IHeaderInfo> readHeaderInfo(List<String> dimNumbers, Map<String, List<PropertyObj>> dimPropertys) {
        ArrayList<IHeaderInfo> headerInfos = new ArrayList<IHeaderInfo>(16);
        if (dimNumbers != null) {
            for (String dimNumber : dimNumbers) {
                headerInfos.add(new HeaderInfo("Dimension", dimNumber));
                List<PropertyObj> propertyObjs = dimPropertys == null ? null : dimPropertys.get(dimNumber);
                if (propertyObjs == null || propertyObjs.size() <= 0) continue;
                for (PropertyObj propertyObj : propertyObjs) {
                    headerInfos.add(new HeaderInfo("Property", propertyObj.getNumber(), dimNumber));
                }
            }
        }
        return headerInfos;
    }
}

