/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.template.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.login.utils.ShaSignUtils;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.utils.LogStats;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.TemplateModelJSONUtil;
import org.jetbrains.annotations.NotNull;

public class TemplateCache {
    public static final Log log = LogFactory.getLog(TemplateCache.class);
    private static final int TEMPLATE_INIT_SIZE = 16;
    private static final long TEMPLATE_MAX_SIZE = 128L;
    private static final long TEMPLATE_OVER_TIME = 10L;
    private static final LoadingCache<String, ITemplateModel> TEMPLATES = CacheBuilder.newBuilder().initialCapacity(16).maximumSize(128L).expireAfterAccess(10L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<String, ITemplateModel>(){

        @NotNull
        public ITemplateModel load(@NotNull String templateData) {
            return TemplateCache.parseTemplate(templateData);
        }
    });
    private static final ThreadLocal<Map<String, ITemplateModel>> LOCAL = new ThreadLocal();

    protected static LoadingCache<String, ITemplateModel> getTEMPLATES() {
        return TEMPLATES;
    }

    protected static ThreadLocal<Map<String, ITemplateModel>> getLocal() {
        return LOCAL;
    }

    public static void remove() {
        TemplateCache.getLocal().remove();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ITemplateModel getTemplate(Long modelId, String templateData) {
        if (StringUtils.isEmpty((String)templateData)) {
            throw new KDBizException("template data is null.");
        }
        LogStats stats = new LogStats("budget-template-log : ");
        try {
            Map<String, ITemplateModel> _templates = TemplateCache.getLocal().get();
            if (_templates == null) {
                _templates = new HashMap<String, ITemplateModel>();
                TemplateCache.getLocal().set(_templates);
            }
            ITemplateModel templateModel = _templates.computeIfAbsent(TemplateCache.getTemplateKey(modelId, templateData), f -> TemplateCache.loadCache(templateData));
            ITemplateModel iTemplateModel = (ITemplateModel)templateModel.clone();
            return iTemplateModel;
        }
        finally {
            stats.addInfo("end-load-template.");
            log.info(stats.toString());
        }
    }

    private static String getTemplateKey(Long modelId, String templateData) {
        return modelId + 46L + ModelCacheContext.getAcctId() + '.' + ShaSignUtils.getSHA256StrJava1((String)templateData);
    }

    private static ITemplateModel loadCache(String templateData) {
        try {
            return (ITemplateModel)TemplateCache.getTEMPLATES().get((Object)templateData);
        }
        catch (ExecutionException ex) {
            log.error(ex.getMessage(), (Throwable)ex);
            throw new KDBizException(ex.getMessage());
        }
    }

    private static ITemplateModel parseTemplate(String templateData) {
        return TemplateModelJSONUtil.$parseITemplateModel(templateData);
    }
}

