/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.template.dimension;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import kd.epm.eb.common.reportprocess.entity.dto.FixReportSortDiminfoDto;
import kd.epm.eb.common.reportprocess.entity.dto.FixReportTotalTitleFormatDto;
import kd.epm.eb.spread.template.dimension.DefaultDimension;
import kd.epm.eb.spread.template.dimension.IDimension;
import kd.epm.eb.spread.template.dimension.RowColDimMember;

public class BatchMembEntity
implements Serializable {
    private List<IDimension> dimensions = new ArrayList<IDimension>();
    private List<RowColDimMember[]> memberRows = new ArrayList<RowColDimMember[]>();
    private List<List<FixReportSortDiminfoDto>> sortInfoList = new ArrayList<List<FixReportSortDiminfoDto>>();
    private List<List<FixReportTotalTitleFormatDto>> totalRowForamtList = new ArrayList<List<FixReportTotalTitleFormatDto>>();

    public List<RowColDimMember[]> getMemberRows() {
        return this.memberRows;
    }

    public List<List<FixReportSortDiminfoDto>> getSortInfoList() {
        return this.sortInfoList;
    }

    public List<List<FixReportTotalTitleFormatDto>> getTotalRowFormatList() {
        return this.totalRowForamtList;
    }

    public void addDimension(long id, String number, String name, int dseq, String membModel) {
        DefaultDimension dimension = new DefaultDimension(id, name, number, dseq, membModel);
        this.dimensions.add(dimension);
        int dimSize = this.dimensions.size();
        this.memberRows.forEach(row -> {
            row = Arrays.copyOf(row, dimSize);
        });
    }

    public void addDimension(IDimension dimension) {
        this.dimensions.add(dimension);
        int dimSize = this.dimensions.size();
        for (int i = 0; i < this.memberRows.size(); ++i) {
            this.memberRows.set(i, (RowColDimMember[])Arrays.copyOf((Object[])this.memberRows.get(i), dimSize));
        }
    }

    public void addRow() {
        int dimSize = this.dimensions.size();
        if (dimSize == 0) {
            return;
        }
        RowColDimMember[] newRow = new RowColDimMember[dimSize];
        this.memberRows.add(newRow);
        this.sortInfoList.add(new ArrayList(16));
        this.totalRowForamtList.add(new ArrayList(16));
    }

    public void delRows(int[] rowIndexs) {
        for (int index : rowIndexs) {
            this.memberRows.set(index, null);
            this.sortInfoList.set(index, null);
            this.totalRowForamtList.set(index, null);
        }
        this.memberRows.removeIf(row -> row == null);
        this.sortInfoList.removeIf(row -> row == null);
        this.totalRowForamtList.removeIf(row -> row == null);
    }

    public IDimension delDimension(String dimNum) {
        int index = this.getDimIndex(dimNum);
        IDimension dim = this.dimensions.get(index);
        if (index > -1) {
            this.dimensions.remove(index);
            int dimSize = this.dimensions.size();
            if (dimSize == 0) {
                this.memberRows.clear();
                return dim;
            }
            for (int i = 0; i < this.memberRows.size(); ++i) {
                RowColDimMember[] vals = new RowColDimMember[dimSize];
                RowColDimMember[] oldVals = this.memberRows.get(i);
                int j = 0;
                for (int z = 0; z < oldVals.length; ++z) {
                    if (z == index) continue;
                    vals[j++] = oldVals[z];
                }
                this.memberRows.set(i, vals);
            }
        }
        return dim;
    }

    private int getDimIndex(String dimNum) {
        dimNum = dimNum.toLowerCase(Locale.getDefault());
        int index = -1;
        for (int i = 0; i < this.dimensions.size(); ++i) {
            if (!this.dimensions.get(i).getNumber().toLowerCase(Locale.getDefault()).equals(dimNum)) continue;
            index = i;
            break;
        }
        return index;
    }

    public void moveRow(int[] rowIndexs, boolean isUp) {
        int sign = isUp ? -1 : 1;
        for (int index : rowIndexs) {
            RowColDimMember[] row = this.memberRows.set(index + sign, this.memberRows.get(index));
            this.memberRows.set(index, row);
            List<FixReportSortDiminfoDto> sort = this.sortInfoList.set(index + sign, this.sortInfoList.get(index));
            this.sortInfoList.set(index, sort);
            List<FixReportTotalTitleFormatDto> totalRowFormat = this.totalRowForamtList.set(index + sign, this.totalRowForamtList.get(index));
            this.totalRowForamtList.set(index, totalRowFormat);
        }
    }

    public void changeDimSeq(int oldSeq, int newSeq) {
        if (oldSeq < 0 || oldSeq > this.dimensions.size() || oldSeq == newSeq || newSeq < 0 || newSeq > this.dimensions.size()) {
            return;
        }
        int sign = newSeq > oldSeq ? 1 : -1;
        IDimension movedDim = this.dimensions.set(newSeq, this.dimensions.get(oldSeq));
        for (int index = oldSeq + sign; index != newSeq; index += sign) {
            this.dimensions.set(index - sign, this.dimensions.get(index));
        }
        this.dimensions.set(newSeq - sign, movedDim);
        this.memberRows.forEach(row -> {
            RowColDimMember movedMemb = row[newSeq];
            row[newSeq] = row[oldSeq];
            for (int index = oldSeq + sign; index != newSeq; index += sign) {
                row[index - sign] = row[index];
            }
            row[newSeq - sign] = movedMemb;
        });
    }

    public List<IDimension> getDimensions() {
        return this.dimensions;
    }
}

