/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.template.pageviewpanel;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.entity.LocaleString;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.entity.datamodel.IDataModel;
import kd.bos.exception.KDBizException;
import kd.bos.form.IFormView;
import kd.bos.form.IPageCache;
import kd.bos.form.control.Label;
import kd.bos.form.field.BasedataEdit;
import kd.bos.form.field.TextEdit;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.constant.BgTaskConstant;
import kd.epm.eb.common.dao.formula.MemberCondition;
import kd.epm.eb.common.dimension.dimensionrelation.DimensionRelationUtils;
import kd.epm.eb.common.ebcommon.common.enums.RangeEnum;
import kd.epm.eb.common.ebcommon.common.json.JSONObject;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.utils.CollectionUtils;
import kd.epm.eb.common.utils.EntityUtils;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.TemplateSetBaseVarUtil;
import kd.epm.eb.spread.template.dimension.PageViewDimMember;
import kd.epm.eb.spread.template.pagedim.IPageDimensionEntry;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.viewpointdim.IViewPointDimensionEntry;
import kd.epm.eb.spread.utils.ReportHelper;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarCommonUtil;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarUtil;
import org.apache.commons.lang.StringUtils;

public class PageViewPanelDraw {
    private static final Log log = LogFactory.getLog(PageViewPanelDraw.class);
    private IFormView view;
    private final ITemplateModel templateModel;
    private final IEbSpreadManager spreadManager;
    private boolean needlockpage;
    private boolean needCheckPerm;
    public static final String all_f7_key_prefix = "ebf7_";
    public static final String userdefined_F7_Key_prefix = "customize";
    public static final String F7_MAPPING_CACHE = "f7_mapping_cache";
    public static final String F7_BASEMAPPING_CACHE = "f7_basemapping_cache";
    public static final String CACHE_PAGE_DIM_PAGE_ID = "floatPageDimPageId";
    public static final String CACHE_NEED_LOCK_DIM_F7KEYS = "cache_need_lock_dimF7Keys";
    public static final String CACHE_LOCK_DIM_VISIBLE = "cache_lock_dim_visible";
    private boolean showHideDim = true;
    private Map<String, Long> defaultDimMember;
    private String drillthrough_key;
    private Map<String, QFilter> extraQfilter = new HashMap<String, QFilter>();
    private final Map<String, String> dim_f7Key = new HashMap<String, String>();
    private final Set<String> needlockDims = new HashSet<String>();
    private boolean needUpdateView = true;
    private final IModelCacheHelper modelCacheHelper;
    private final Map<String, String> filterToDimMap = new HashMap<String, String>();
    public static final String filter_key_prefix = "filter_";
    public static final String filterToDimCache = "filterToDimCache";
    public static final String filterMemberCache = "filterMemberCache";
    public Map<String, String> cellMember;

    public PageViewPanelDraw(IFormView view, ITemplateModel templateModel, IEbSpreadManager spreadManager) {
        this.view = view;
        this.templateModel = templateModel;
        this.spreadManager = spreadManager;
        this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)templateModel.getModelId());
    }

    public PageViewPanelDraw(ITemplateModel templateModel, IEbSpreadManager spreadManager) {
        this.templateModel = templateModel;
        this.spreadManager = spreadManager;
        this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)templateModel.getModelId());
    }

    public boolean isShowHideDim() {
        return this.showHideDim;
    }

    public void setShowHideDim(boolean showHideDim) {
        this.showHideDim = showHideDim;
    }

    public IFormView getView() {
        return this.view;
    }

    public ITemplateModel getTemplateModel() {
        return this.templateModel;
    }

    public boolean isNeedlockpage() {
        return this.needlockpage;
    }

    public void setNeedlockpage(boolean needlockpage) {
        this.needlockpage = needlockpage;
    }

    public boolean isNeedCheckPerm() {
        return this.needCheckPerm;
    }

    public void setNeedCheckPerm(boolean needCheckPerm) {
        this.needCheckPerm = needCheckPerm;
    }

    public void build() {
        IFormView parentView;
        if (this.view == null) {
            this.needUpdateView = false;
        } else {
            this.hideAllF7Items();
        }
        AtomicInteger userdefined_index = new AtomicInteger(1);
        this.initViewDims(userdefined_index);
        this.initPageDims(userdefined_index);
        if (this.isBudgetForm() && (parentView = this.view.getParentView()) != null) {
            List orgIds;
            String orgIdCache;
            Long defaultOrgId = IDUtils.toLong((Object)parentView.getPageCache().get("defaultOrgId"));
            Long orgViewId = this.spreadManager.getDimemsionViews().getOrDefault(SysDimensionEnum.Entity.getNumber(), 0L);
            Member member = this.modelCacheHelper.getMember(SysDimensionEnum.Entity.getNumber(), orgViewId, defaultOrgId);
            if (member == null) {
                defaultOrgId = 0L;
            } else if (!this.isEntityPageDim() && StringUtils.isNotEmpty((String)(orgIdCache = parentView.getPageCache().get("orgIdsCache"))) && !(orgIds = (List)SerializationUtils.deSerializeFromBase64((String)orgIdCache)).contains(defaultOrgId)) {
                defaultOrgId = 0L;
            }
            if (IDUtils.isNotNull((Long)defaultOrgId)) {
                EntityUtils.setDataWithOutPropertychanged((IDataModel)this.getView().getModel(), (String)"ebf7_entity", (Object)defaultOrgId);
                parentView.getPageCache().put("defaultOrgId", "");
                this.getView().updateView("ebf7_entity");
            }
            this.dim_f7Key.put("ebf7_entity", SysDimensionEnum.Entity.getNumber());
        }
        if (this.view != null) {
            this.initFilterDims();
            this.cacheF7MappingKey();
            this.cacheNeedLockDim();
        }
    }

    public void buildWithOutView() {
        this.needUpdateView = false;
        this.build();
    }

    private void cacheF7MappingKey() {
        if (this.needUpdateView) {
            IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
            pageCache.put(F7_MAPPING_CACHE, this.dim_f7Key == null || this.dim_f7Key.size() == 0 ? null : ObjectSerialUtil.toByteSerialized(this.dim_f7Key));
        }
    }

    private void initPageDims(AtomicInteger userdefined_index) {
        IPageCache pageCache;
        this.spreadManager.setNeedCheckPerm(this.isNeedCheckPerm());
        Map<String, Set<Member>> pagedim_boundary = this.spreadManager.resolvePageMemberScope(this.templateModel);
        IFormView view = this.getView();
        Long reportProcessId = this.spreadManager.getReportProcessId();
        List<Long> dimRelationList = ReportHelper.getDimRelation(view, reportProcessId);
        Map<String, Set<String>> dimRelationMap = ReportHelper.getDimRelationMap(view, reportProcessId);
        String clickdimkey = "";
        if (view != null && (pageCache = view.getPageCache()) != null) {
            clickdimkey = pageCache.get("clickdimkey");
            pageCache.remove("clickdimkey");
            pageCache.remove("approveAdjust");
        }
        boolean isAfterClickDim = false;
        HashSet<String> notInTemplateScopeAssignDimNum = new HashSet<String>(16);
        HashSet<String> notPermAssignDimNum = new HashSet<String>(16);
        HashSet<String> notInRelationAssignDimNum = new HashSet<String>(16);
        for (IPageDimensionEntry pagemem : this.templateModel.getPagemembentry()) {
            Set<Member> members;
            String dimnumber = pagemem.getDimension().getNumber();
            Long viewId = this.spreadManager.getDimemsionViews().getOrDefault(dimnumber, 0L);
            String f7key = this.initDimensinMapping(pagemem, userdefined_index);
            if (StringUtils.isEmpty((String)clickdimkey)) {
                isAfterClickDim = true;
            }
            if ((members = pagedim_boundary.get(dimnumber)) != null && members.size() > 0) {
                Long newMemberID;
                boolean bolIsValiad;
                Member member;
                ArrayList<Long> filterids = new ArrayList<Long>(10);
                ArrayList<String> filterNumbers = new ArrayList<String>(10);
                for (Member mem : members) {
                    filterids.add(mem.getId());
                    filterNumbers.add(mem.getNumber());
                }
                Long finalmemberId = 0L;
                if (this.cellMember != null && this.cellMember.containsKey(dimnumber) && (member = this.modelCacheHelper.getMember(dimnumber, viewId, this.cellMember.get(dimnumber))) != null && filterids.contains(member.getId())) {
                    finalmemberId = member.getId();
                    log.info("initPageDims fromCellMember dim:{} mem:{} isLeaf:{}", new Object[]{dimnumber, member.getNumber(), member.isLeaf()});
                }
                if (finalmemberId == 0L && this.defaultDimMember != null && this.defaultDimMember.containsKey(dimnumber) && filterids.contains(this.defaultDimMember.get(dimnumber))) {
                    finalmemberId = this.defaultDimMember.get(dimnumber);
                    Member defaultMember = this.modelCacheHelper.getMember(dimnumber, viewId, finalmemberId);
                    log.info("initPageDims fromDefault dim:{} mem:{} isLeaf:{}", new Object[]{dimnumber, defaultMember == null ? null : defaultMember.getNumber(), defaultMember == null ? null : Boolean.valueOf(defaultMember.isLeaf())});
                }
                Set collect = members.stream().map(x -> x.getId()).collect(Collectors.toSet());
                if (this.isAssignDimNumber(dimnumber) != null && this.defaultDimMember != null && this.defaultDimMember.get(dimnumber) != null && !filterids.contains(this.defaultDimMember.get(dimnumber))) {
                    log.info("initPageDims notInTemplateScopeAssignDimNum dim:{} defaultDimMember:{} filterids:{},members:{}", new Object[]{dimnumber, JSONObject.toJSONString(this.defaultDimMember), JSONObject.toJSONString(filterids), JSONObject.toJSONString(collect)});
                    notInTemplateScopeAssignDimNum.add(this.isAssignDimNumber(dimnumber));
                    if (this.getView() == null) continue;
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{f7key});
                    continue;
                }
                if (members.size() > 1 && isAfterClickDim && dimRelationMap.containsKey(dimnumber)) {
                    Member defaultMember;
                    List members1;
                    Set<Member> mergeRelationMembers = this.mergeRelation(view, dimnumber, viewId, dimRelationMap, dimRelationList);
                    List mergeRelationMemberIds = mergeRelationMembers.stream().map(BaseCache::getId).collect(Collectors.toList());
                    if (!mergeRelationMemberIds.contains(finalmemberId) && !SysDimensionEnum.Entity.getNumber().equals(dimnumber)) {
                        if (this.isAssignDimNumber(dimnumber) != null) {
                            notInRelationAssignDimNum.add(this.isAssignDimNumber(dimnumber));
                            continue;
                        }
                        Member finalMember = null;
                        members1 = mergeRelationMembers.stream().sorted(Comparator.comparing(Member::disableToInt).thenComparing(BaseCache::getSeq)).collect(Collectors.toList());
                        if (!members1.isEmpty()) {
                            finalMember = (Member)members1.get(0);
                            finalmemberId = finalMember.getId();
                        }
                        log.info("initPageDims fromDimRel dim:{} mem:{} isLeaf:{}", new Object[]{dimnumber, finalMember == null ? null : finalMember.getNumber(), finalMember == null ? null : Boolean.valueOf(finalMember.isLeaf())});
                    }
                    if (finalmemberId != 0L && (defaultMember = this.modelCacheHelper.getMember(dimnumber, viewId, finalmemberId)) == null) {
                        members1 = members.stream().filter(e -> !e.isLeaf()).sorted(Comparator.comparing(Member::disableToInt).thenComparing(BaseCache::getSeq)).collect(Collectors.toList());
                        if (!members1.isEmpty()) {
                            defaultMember = (Member)members1.get(0);
                            finalmemberId = defaultMember.getId();
                        }
                        log.info("initPageDims finalMember null fromPageRange dim:{} mem:{} isLeaf:{}", new Object[]{dimnumber, defaultMember == null ? null : defaultMember.getNumber(), defaultMember == null ? null : Boolean.valueOf(defaultMember.isLeaf())});
                    }
                }
                if (finalmemberId == 0L) {
                    finalmemberId = (Long)filterids.get(0);
                    log.info("initPageDims finalmemberId=0 getPageRange first dim:{} finalmemberId:{}", (Object)dimnumber, (Object)finalmemberId);
                }
                if (!(bolIsValiad = finalmemberId.equals(newMemberID = TemplateSetBaseVarUtil.doPageDimControlInValid(this.templateModel, dimnumber, finalmemberId, filterids)))) {
                    this.getNeedlockDims().add(dimnumber);
                }
                finalmemberId = bolIsValiad ? finalmemberId : newMemberID;
                finalmemberId = this.setValueIntoSpread(finalmemberId, dimnumber);
                this.setValueIntoView(finalmemberId, dimnumber, f7key, filterNumbers);
                if (this.cellMember != null && view != null) {
                    view.getPageCache().put("lastselect_" + dimnumber, finalmemberId + "");
                    view.getPageCache().put(view.getPageCache().get("current_report_id") + "lastselect_" + dimnumber, finalmemberId + "");
                    if (SysDimensionEnum.Entity.getNumber().equals(dimnumber)) {
                        view.getPageCache().put(view.getPageCache().get("current_report_id") + "lastselect_" + dimnumber, finalmemberId + "");
                    }
                }
                if (StringUtils.equals((String)f7key, (String)clickdimkey)) {
                    isAfterClickDim = true;
                }
            } else {
                if (this.needUpdateView) {
                    this.setValueIntoView(null, dimnumber, f7key, null);
                    this.getView().setEnable(Boolean.valueOf(false), new String[]{f7key});
                    this.getNeedlockDims().add(dimnumber);
                }
                this.spreadManager.getAlldimensionWithMembers().put(dimnumber, Collections.emptySet());
            }
            if (this.isAssignDimNumber(dimnumber) == null || members != null && members.size() != 0) continue;
            notPermAssignDimNum.add(this.isAssignDimNumber(dimnumber));
        }
        if (CollectionUtils.isNotEmpty(notPermAssignDimNum)) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u7ef4\u5ea6\u201c%1\u201d\u6ca1\u6709\u6743\u9650\uff0c\u65e0\u6cd5\u6253\u5f00\u62a5\u8868\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PageViewPanelDraw_01", (String)"epm-eb-spread", (Object[])new Object[]{String.join((CharSequence)"\u3001", notPermAssignDimNum)}));
        }
        if (CollectionUtils.isNotEmpty(notInTemplateScopeAssignDimNum)) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u4e0b\u8fbe\u7684\u201c%1\u201d\u5728\u6a21\u677f\u4e2d\u4e0d\u5b58\u5728\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PageViewPanelDraw_02", (String)"epm-eb-spread", (Object[])new Object[]{String.join((CharSequence)"\u3001", notInTemplateScopeAssignDimNum)}));
        }
        if (CollectionUtils.isNotEmpty(notInRelationAssignDimNum)) {
            throw new KDBizException(ResManager.loadResFormat((String)"\u4e0b\u8fbe\u7684\u201c%1\u201d\u4e0e\u7ef4\u5ea6\u6210\u5458\u5173\u7cfb\u5b58\u5728\u51b2\u7a81\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u3002", (String)"PageViewPanelDraw_03", (String)"epm-eb-spread", (Object[])new Object[]{String.join((CharSequence)"\u3001", notInRelationAssignDimNum)}));
        }
    }

    private String isAssignDimNumber(String dimNumber) {
        if (SysDimensionEnum.DataType.getNumber().equals(dimNumber)) {
            return SysDimensionEnum.DataType.getChineseName();
        }
        if (SysDimensionEnum.Version.getNumber().equals(dimNumber)) {
            return SysDimensionEnum.Version.getChineseName();
        }
        return null;
    }

    public Set<Member> mergeRelation(IFormView view, String dimNumber, Long viewId, Map<String, Set<String>> dimRelationMap, List<Long> dimRelationList) {
        Map<String, String> preDimMap;
        Set dimRelMemSet;
        if (view == null) {
            return Collections.emptySet();
        }
        Long modelId = this.templateModel.getModelId();
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)modelId);
        Long bizModelId = modelCache.getBusModelByDataSet(this.templateModel.getTemplateBaseInfo().getDatasetID());
        Long periodId = IDUtils.toLong((Object)view.getPageCache().get("CURRENT_PERIOD"));
        Map<String, PageViewDimMember> pageViewDims = this.getSpreadManager().getPageViewDims();
        if (!dimRelationMap.isEmpty() && dimRelationMap.containsKey(dimNumber) && CollectionUtils.isNotEmpty((Collection)(dimRelMemSet = DimensionRelationUtils.getRelationMemNum((IModelCacheHelper)modelCache, (Long)bizModelId, (String)dimNumber, (Long)periodId, preDimMap = pageViewDims.entrySet().stream().collect(Collectors.toMap(Map.Entry::getKey, v -> ((PageViewDimMember)v.getValue()).getNumber(), (o1, o2) -> o2)), dimRelationMap, dimRelationList)))) {
            return dimRelMemSet.stream().map(memNumber -> this.modelCacheHelper.getMember(dimNumber, viewId, memNumber)).filter(Objects::nonNull).collect(Collectors.toSet());
        }
        return Collections.emptySet();
    }

    private Long setValueIntoSpread(Long finalMemberId, String dimNumber) {
        if (this.spreadManager != null && !dimNumber.equals(this.getDrillthrough_key())) {
            Long viewId = this.spreadManager.getDimemsionViews().getOrDefault(dimNumber, 0L);
            Dimension dimension = this.modelCacheHelper.getModelobj().getDimension(dimNumber);
            Member finalmember = this.modelCacheHelper.getMember(dimNumber, viewId, finalMemberId);
            if (finalmember == null) {
                finalmember = this.getMemberFromDb(dimension, finalMemberId);
            }
            if (finalmember == null) {
                return null;
            }
            this.spreadManager.getAlldimensionWithMembers().put(dimNumber, Sets.newHashSet((Object[])new String[]{finalmember.getNumber()}));
            PageViewDimMember pageViewDimMember = new PageViewDimMember(finalmember.getNumber(), finalmember.isLeaf());
            if (SysDimensionEnum.Metric.getNumber().equals(dimNumber) && StringUtils.isNotEmpty((String)finalmember.getUse())) {
                pageViewDimMember.setUse(finalmember.getUse());
            }
            this.spreadManager.getPageViewDims().put(dimNumber, pageViewDimMember);
        }
        return finalMemberId;
    }

    private Member getMemberFromDb(Dimension dimension, Long finalmemberId) {
        String dimnumber = dimension.getNumber();
        String membermodel = SysDimensionEnum.getMemberTreemodelByNumber((String)dimnumber);
        Member member = null;
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)membermodel, (String)"name, number, isleaf", (QFilter[])new QFilter[]{new QFilter("id", "=", (Object)finalmemberId)}, null);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                member = new Member();
                member.setId(finalmemberId);
                member.setName(row.getString("name"));
                member.setNumber(row.getString("number"));
                if (row.getBoolean("isleaf").booleanValue()) continue;
                Member mem = new Member();
                mem.setId(finalmemberId);
                mem.setParentId(finalmemberId);
                member.addChild(mem);
            }
        }
        return member;
    }

    private void setValueIntoView(Long finalmemberId, String dimnumber, String f7key, List<String> filterNumbers) {
        if (this.needUpdateView) {
            BasedataEdit basedataEdit;
            if (this.needlockDims.contains(dimnumber)) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{f7key});
            }
            EntityUtils.setDataWithOutPropertychanged((IDataModel)this.getView().getModel(), (String)f7key, (Object)finalmemberId);
            this.getView().updateView(f7key);
            QFilter qFilter = null;
            if (CollectionUtils.isNotEmpty(filterNumbers)) {
                qFilter = new QFilter("number", "in", filterNumbers);
            }
            if ("Entity".equals(dimnumber)) {
                if (qFilter == null) {
                    qFilter = new QFilter("number", "not in", this.getEntityExchangeRateNumbers(this.templateModel.getModelId()));
                } else {
                    qFilter.and("number", "not in", this.getEntityExchangeRateNumbers(this.templateModel.getModelId()));
                }
            }
            if (this.getExtraQfilter() != null && this.getExtraQfilter().containsKey(dimnumber)) {
                if (qFilter == null) {
                    qFilter = this.getExtraQfilter().get(dimnumber);
                } else {
                    qFilter.and(this.getExtraQfilter().get(dimnumber));
                }
            }
            if ((basedataEdit = (BasedataEdit)this.getView().getControl(f7key)) != null && qFilter != null) {
                basedataEdit.setQFilters((List)Lists.newArrayList((Object[])new QFilter[]{qFilter}));
            }
        }
    }

    private String initDimensinMapping(IPageDimensionEntry pagemem, AtomicInteger userdefined_index) {
        String dimnumber = pagemem.getDimension().getNumber();
        String memberTreemodel = SysDimensionEnum.getMemberTreemodelByNumber((String)dimnumber);
        boolean isuserdefined = false;
        if ("epm_userdefinedmembertree".equals(memberTreemodel) || "bcm_mycompanymembertree".equals(memberTreemodel)) {
            isuserdefined = true;
        }
        String f7key = all_f7_key_prefix + dimnumber.toLowerCase();
        if (isuserdefined) {
            f7key = "ebf7_customize" + userdefined_index.get();
            userdefined_index.incrementAndGet();
        }
        this.dim_f7Key.put(f7key, dimnumber);
        if (this.needUpdateView) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{f7key});
            if (this.isNeedlockpage()) {
                this.getView().setEnable(Boolean.valueOf(false), new String[]{f7key});
            } else {
                this.getView().setEnable(Boolean.valueOf(true), new String[]{f7key});
            }
            BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(f7key);
            if (basedataEdit != null && isuserdefined) {
                String dimName = pagemem.getDimension().getName();
                if (dimName == null) {
                    dimName = this.modelCacheHelper.getDimension(pagemem.getDimension().getNumber()).getName();
                }
                basedataEdit.setCaption(new LocaleString(dimName));
            }
        }
        return f7key;
    }

    private void initViewDims(AtomicInteger userdefined_index) {
        Map<String, Map<String, String>> varValus = null;
        if (TemplateVarUtil.isReport(this.templateModel) && this.spreadManager.getProcessId() != null) {
            varValus = ReportVarUtil.getVarValues(this.spreadManager.getProcessType(), this.templateModel.getModelId(), IDUtils.toLong((Object)this.spreadManager.getProcessId()), this.templateModel.getTemplateBaseInfo().getVarBase());
        }
        for (IViewPointDimensionEntry viewmem : this.templateModel.getViewpointmembentry()) {
            Member member;
            String dimnumber = viewmem.getDimension().getNumber();
            Long viewId = this.spreadManager.getDimemsionViews().getOrDefault(dimnumber, 0L);
            String memberTreemodel = SysDimensionEnum.getMemberTreemodelByNumber((String)dimnumber);
            boolean isuserdefined = false;
            if ("epm_userdefinedmembertree".equals(memberTreemodel) || "bcm_mycompanymembertree".equals(memberTreemodel)) {
                isuserdefined = true;
            }
            String f7key = all_f7_key_prefix + dimnumber.toLowerCase();
            if (isuserdefined) {
                f7key = "ebf7_customize" + userdefined_index.get();
                userdefined_index.incrementAndGet();
            }
            this.dim_f7Key.put(f7key, dimnumber);
            Long finalid = viewmem.getMember().getId();
            if (TemplateVarCommonUtil.checkIsVar(viewmem.getMember().getNumber(), dimnumber).booleanValue()) {
                finalid = null;
            }
            viewmem.getMember().setNumber(ReportVarUtil.getRealDimByVar(this.templateModel.getModelId(), viewmem.getMember().getNumber(), dimnumber, varValus));
            if ((finalid == null || finalid == 0L) && (member = this.modelCacheHelper.getMember(dimnumber, viewId, viewmem.getMember().getNumber())) != null) {
                finalid = member.getId();
            }
            Long finalmemberid = this.setValueIntoSpread(finalid, dimnumber);
            if (!this.needUpdateView) continue;
            if (this.showHideDim) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{f7key});
                this.getView().setEnable(Boolean.valueOf(false), new String[]{f7key});
            }
            if (isuserdefined) {
                BasedataEdit basedataEdit = (BasedataEdit)this.getView().getControl(f7key);
                if (basedataEdit == null) continue;
                String dimName = viewmem.getDimension().getName();
                if (dimName == null) {
                    dimName = this.modelCacheHelper.getDimension(viewmem.getDimension().getNumber()).getName();
                }
                basedataEdit.setCaption(new LocaleString(dimName));
            }
            EntityUtils.setDataWithOutPropertychanged((IDataModel)this.getView().getModel(), (String)f7key, (Object)finalmemberid);
            this.getView().updateView(f7key);
        }
    }

    private void hideAllF7Items() {
        if (this.needUpdateView) {
            this.getView().setVisible(Boolean.valueOf(false), BgTaskConstant.getInstance().getF7Keys());
            this.getView().setVisible(Boolean.valueOf(false), BgTaskConstant.getInstance().getFilterKeys());
        }
        if (this.isBudgetForm()) {
            this.getView().setVisible(Boolean.valueOf(true), new String[]{"ebf7_entity"});
            this.getView().setEnable(Boolean.valueOf(true), new String[]{"ebf7_entity"});
        }
    }

    private Set<String> getEntityExchangeRateNumbers(Long modelid) {
        QFilter model_qfilter = new QFilter("model", "=", (Object)modelid);
        QFilter exchange_qFilter = new QFilter("isexchangerate", "=", (Object)true);
        DynamicObjectCollection collection = QueryServiceHelper.query((String)"epm_entitymembertree", (String)"id,number", (QFilter[])new QFilter[]{model_qfilter, exchange_qFilter});
        HashSet<String> numbers = new HashSet<String>();
        if (collection != null && collection.size() > 0) {
            collection.forEach(obj -> numbers.add(obj.getString("number")));
        }
        return numbers;
    }

    public Map<String, Long> getDefaultDimMember() {
        return this.defaultDimMember;
    }

    public void setDefaultDimMember(Map<String, Long> defaultDimMember) {
        this.defaultDimMember = defaultDimMember;
    }

    public String getDrillthrough_key() {
        return this.drillthrough_key;
    }

    public void setDrillthrough_key(String drillthrough_key) {
        this.drillthrough_key = drillthrough_key;
    }

    public Map<String, QFilter> getExtraQfilter() {
        return this.extraQfilter;
    }

    public void setExtraQfilter(Map<String, QFilter> extraQfilter) {
        this.extraQfilter = extraQfilter;
    }

    public IEbSpreadManager getSpreadManager() {
        return this.spreadManager;
    }

    public Set<String> getNeedlockDims() {
        return this.needlockDims;
    }

    public Map<String, String> getCellMember() {
        return this.cellMember;
    }

    public void setCellMember(Map<String, String> cellMember) {
        this.cellMember = cellMember;
    }

    private void cacheNeedLockDim() {
        IFormView pageDimFormView;
        String cachePageDimPageId;
        if (!this.needUpdateView) {
            return;
        }
        List<IViewPointDimensionEntry> pagemembentry = this.templateModel.getViewpointmembentry();
        Set hideDims = pagemembentry.stream().map(e -> e.getDimension().getNumber()).collect(Collectors.toSet());
        HashSet<String> initHideDimF7Keys = new HashSet<String>(this.dim_f7Key.size());
        for (Map.Entry<String, String> entry : this.dim_f7Key.entrySet()) {
            String f7Key = entry.getKey();
            String dimNum = entry.getValue();
            if (!hideDims.contains(dimNum) && !this.needlockDims.contains(dimNum)) continue;
            initHideDimF7Keys.add(f7Key);
        }
        this.getView().setVisible(Boolean.valueOf(initHideDimF7Keys.size() > 0), new String[]{"showhidedetail"});
        if (initHideDimF7Keys.size() > 0) {
            Label label;
            this.getView().getPageCache().put(CACHE_NEED_LOCK_DIM_F7KEYS + this.spreadManager.getReportProcessId(), SerializationUtils.serializeToBase64(initHideDimF7Keys));
            boolean visible = "true".equals(this.getView().getPageCache().get(CACHE_LOCK_DIM_VISIBLE + this.spreadManager.getReportProcessId()));
            this.getView().setVisible(Boolean.valueOf(visible), initHideDimF7Keys.toArray(new String[0]));
            this.getView().setEnable(Boolean.FALSE, initHideDimF7Keys.toArray(new String[0]));
            if (this.isBudgetForm()) {
                this.getView().setVisible(Boolean.valueOf(true), new String[]{"ebf7_entity"});
                this.getView().setEnable(Boolean.valueOf(true), new String[]{"ebf7_entity"});
            }
            if ((label = (Label)this.getView().getControl("showhidedetail")) != null) {
                label.setText(visible ? ResManager.loadKDString((String)"\u9690\u85cf\u8be6\u60c5", (String)"PageViewPanelDraw_1", (String)"epm-eb-spread", (Object[])new Object[0]) : ResManager.loadKDString((String)"\u663e\u793a\u8be6\u60c5", (String)"PageViewPanelDraw_0", (String)"epm-eb-spread", (Object[])new Object[0]));
            }
        }
        if ((cachePageDimPageId = this.getView().getPageCache().get(CACHE_PAGE_DIM_PAGE_ID)) != null && (pageDimFormView = this.getView().getView(cachePageDimPageId)) != null) {
            String processId = pageDimFormView.getPageCache().get("processId");
            if (!IDUtils.equals((Object)processId, (Object)this.spreadManager.getReportProcessId())) {
                pageDimFormView.close();
                this.getView().sendFormAction(pageDimFormView);
            } else {
                return;
            }
        }
        this.getView().setVisible(Boolean.TRUE, new String[]{"pagedimspanel"});
    }

    private void initFilterDims() {
        if (this.needUpdateView) {
            String filterMemberCacheStr;
            List<String> filterDims = this.templateModel.getFilterDims();
            IPageCache pageCache = (IPageCache)this.getView().getService(IPageCache.class);
            pageCache.remove(filterToDimCache);
            Long modelId = this.getTemplateModel().getModelId();
            if (IDUtils.isNull((Long)modelId) || CollectionUtils.isEmpty(filterDims)) {
                return;
            }
            IModelCacheHelper modelCacheHelper = ModelCacheContext.getOrCreate((Long)modelId);
            String[] filterKeys = BgTaskConstant.getInstance().getFilterKeys();
            ArrayList<String> visalbeFilter = new ArrayList<String>(16);
            pageCache.put("initFilterChange", "1");
            Map historySelectMap = new HashMap(16);
            if (this.spreadManager != null && IDUtils.isNotNull((Long)this.spreadManager.getReportProcessId()) && StringUtils.isNotEmpty((String)(filterMemberCacheStr = pageCache.get(this.spreadManager.getReportProcessId() + filterMemberCache)))) {
                historySelectMap = (Map)ObjectSerialUtil.deSerializedBytes((String)filterMemberCacheStr);
            }
            for (int i = 0; i < filterDims.size(); ++i) {
                String filterKey;
                TextEdit textEdit;
                String dimKey = filterDims.get(i);
                Dimension dimension = modelCacheHelper.getDimension(dimKey);
                if (i >= filterKeys.length || (textEdit = (TextEdit)this.view.getControl(filterKey = filterKeys[i])) == null) continue;
                List conditionList = (List)historySelectMap.get(dimKey);
                if (CollectionUtils.isNotEmpty((Collection)conditionList)) {
                    this.view.getModel().setValue(filterKey, (Object)this.buildFilterMemShowname(conditionList));
                } else {
                    this.view.getModel().setValue(filterKey, (Object)"");
                }
                textEdit.setCaption(new LocaleString(dimension.getName()));
                this.filterToDimMap.put(filterKey, dimension.getNumber());
                visalbeFilter.add(filterKey);
                this.view.updateView(dimKey);
            }
            if (CollectionUtils.isNotEmpty(visalbeFilter)) {
                this.view.setVisible(Boolean.valueOf(true), visalbeFilter.toArray(new String[0]));
                pageCache.put(filterToDimCache, ObjectSerialUtil.toByteSerialized(this.filterToDimMap));
            } else {
                pageCache.remove(filterToDimCache);
            }
            pageCache.remove("initFilterChange");
        }
    }

    private String buildFilterMemShowname(List<MemberCondition> returnData) {
        ArrayList<String> list = new ArrayList<String>(returnData.size());
        for (MemberCondition memberCondition : returnData) {
            String name = memberCondition.getName();
            int scope = Integer.parseInt(memberCondition.getRange());
            String showtext = RangeEnum.getRangeByVal((int)scope) == RangeEnum.VALUE_10 ? name : name + RangeEnum.getRangeByVal((int)scope).getName();
            list.add(showtext);
        }
        return String.join((CharSequence)";", list);
    }

    private boolean isBudgetForm() {
        IFormView parentView;
        if (this.view != null && (parentView = this.view.getParentView()) != null) {
            return "bgm_adjust_addrow".equals(parentView.getFormShowParameter().getFormId());
        }
        return false;
    }

    private boolean isEntityPageDim() {
        boolean isEntityPageDim = false;
        List<IPageDimensionEntry> pageDimensionEntryList = this.templateModel.getPagemembentry();
        for (IPageDimensionEntry entry : pageDimensionEntryList) {
            String dimNumber = entry.getDimension().getNumber();
            if (!SysDimensionEnum.Entity.getNumber().equals(dimNumber)) continue;
            isEntityPageDim = true;
            break;
        }
        return isEntityPageDim;
    }
}

