/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.template.spreadmanager;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.BaseCache;
import kd.epm.eb.common.ebcommon.common.enums.MemberDisplayTypeEnum;
import kd.epm.eb.common.enums.GroupNodeTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.permission.IMemberPermCache;
import kd.epm.eb.common.permission.MemberPermCacheServiceHelper;
import kd.epm.eb.common.utils.DatasetServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.period.PeriodLeadUtils;
import kd.epm.eb.spread.analyze.DiffAnalyzeScheme;
import kd.epm.eb.spread.command.style.HorizontalAlignEnum;
import kd.epm.eb.spread.template.spreadmanager.DiffCellDimMember;
import kd.epm.eb.spread.template.spreadmanager.EbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.IDiffAnalyzeSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.book.EBook;
import kd.epm.eb.spread.template.spreadmanager.book.IEBook;
import kd.epm.eb.spread.template.spreadmanager.hander.ESpanInfo;
import kd.epm.eb.spread.template.spreadmanager.serializer.DiffAnalyzeSpreadManagerDeserializer;
import kd.epm.eb.spread.template.spreadmanager.serializer.DiffAnalyzeSpreadManagerSerializer;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import kd.epm.eb.spread.template.spreadmanager.sheet.StyleCell;
import kd.epm.eb.spread.utils.ReportHelper;
import org.apache.commons.collections4.CollectionUtils;

@JsonSerialize(using=DiffAnalyzeSpreadManagerSerializer.class)
@JsonDeserialize(using=DiffAnalyzeSpreadManagerDeserializer.class)
public class DiffAnalyzeSpreadManager
implements IDiffAnalyzeSpreadManager {
    private static final long serialVersionUID = -2887194079676145688L;
    private IEBook ebook = null;
    private DiffAnalyzeScheme scheme;
    private Dimension rowDimension;
    private Dimension colDimension;
    private List<Dimension> commonDimension;
    private List<DiffCellDimMember> rowCellDimMembers;
    private List<DiffCellDimMember> colCellDimMembers;
    private transient IModelCacheHelper modelCacheHelper;
    private transient IMemberPermCache memberPerm;
    private Map<String, Long> dimemsionViews = new HashMap<String, Long>();
    private Long modelid;
    private Long datasetid;
    private Long busmodelid;
    private boolean hideEmptyRows = false;
    private String dataUnit = null;
    private int memberDisplayType = 1;
    Map<String, String> metricDataTypeMap = null;

    public DiffAnalyzeSpreadManager() {
        this.initBook();
    }

    private void initBook() {
        this.ebook = new EBook("Sheet1");
        this.initSheetDefaults(this.ebook.getSheet(0));
    }

    private void initSheetDefaults(ISheet sheet) {
        if (sheet != null) {
            sheet.setStyleCell(true);
            HashMap defaultStyle = Maps.newHashMapWithExpectedSize((int)1);
            defaultStyle.put("borderColor", "#D3D3D3");
            defaultStyle.put("font", "10px Microsoft YaHei");
            sheet.setDefaultDataNodeStyle(defaultStyle);
            HashMap sheetDefaults = Maps.newHashMapWithExpectedSize((int)1);
            sheetDefaults.put("colWidth", String.valueOf(100));
            sheet.setSheetDefaults(sheetDefaults);
        }
    }

    @Override
    public DiffAnalyzeScheme getDiffAnalyzeScheme() {
        return this.scheme;
    }

    @Override
    public void setDiffAnalyzeScheme(DiffAnalyzeScheme scheme) {
        this.scheme = scheme;
    }

    @Override
    public IEBook getEbook() {
        return this.ebook;
    }

    @Override
    public void setEbook(IEBook ebook) {
        this.ebook = ebook;
    }

    @Override
    public void initSpreadManager(Long modelid, Long datasetid, DiffAnalyzeScheme scheme) {
        this.modelid = modelid;
        this.datasetid = datasetid;
        this.scheme = scheme;
        if (this.dimemsionViews.isEmpty()) {
            this.initDimensionViews();
        }
    }

    @Override
    public void buildSpreadManager() {
        if (!this.verify()) {
            return;
        }
        this.initBook();
        this.setRowColStart();
        this.buildReportRowPartition();
        this.buildReportColPartition();
    }

    @Override
    public List<ECell> buildReportRowPartition() {
        if (this.modelid == null || this.datasetid == null || this.rowDimension == null) {
            return null;
        }
        this.initSheetDefaults(this.getSheet());
        int r = this.getSheet().getValueAreaRowStart();
        int c = 0;
        List members = this.rowDimension.getMembers();
        String dimNumber = this.rowDimension.getNumber();
        boolean metricInRow = SysDimensionEnum.Metric.getNumber().equals(dimNumber);
        Map<String, String> metricDataTypes = this.getMetricDataTypeMap();
        DiffCellDimMember cellDimMember = null;
        HashMap<String, DiffCellDimMember> cellDimMemberMap = new HashMap<String, DiffCellDimMember>(16);
        LinkedList<ECell> updateUICells = new LinkedList<ECell>();
        if (members != null && members.size() > 0) {
            int rowSize = members.size() + 2;
            this.rowCellDimMembers = new ArrayList<DiffCellDimMember>(rowSize);
            for (int i = 0; i < rowSize; ++i) {
                this.rowCellDimMembers.add(null);
            }
            int levelOffset = ((Member)members.get(0)).getLevel();
            Set<String> topItems = this.getTopItems();
            List<String> longDisplayDimNums = ReportHelper.getLongDisplayDimNums(this.memberDisplayType, this.getModelCacheHelper());
            if (CollectionUtils.isEmpty(longDisplayDimNums) && (this.memberDisplayType == MemberDisplayTypeEnum.LONGNAME.index || this.memberDisplayType == MemberDisplayTypeEnum.LONGNUMBER.index || this.memberDisplayType == MemberDisplayTypeEnum.LONGNAMENUMBER.index)) {
                this.memberDisplayType = MemberDisplayTypeEnum.NAME.index;
            }
            Long viewId = IDUtils.toLong((Object)this.getDimemsionViews().get(dimNumber));
            IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
            Map<String, kd.epm.eb.common.cache.impl.Member> cacheMemberMap = this.getCacheMemberMap(modelCacheHelper, members, dimNumber, viewId);
            for (Member member : members) {
                if (topItems != null && topItems.contains(member.getNumber())) {
                    levelOffset = member.getLevel();
                }
                kd.epm.eb.common.cache.impl.Member cacheMember = cacheMemberMap.get(member.getNumber());
                String shownumber = member.getShowNumber() == null ? member.getNumber() : member.getShowNumber();
                StyleCell cell = this.getStyleCell(r, c, member.getName(), shownumber, member.getSimpleName(), member.getLevel() - levelOffset, cacheMember, longDisplayDimNums, dimNumber, viewId);
                cell.setUserObject("dimnumber", dimNumber);
                cell.setUserObject("memnumber", member.getNumber());
                cell.setUserObject("name", member.getName());
                cell.setUserObject("simplename", member.getSimpleName());
                if (metricInRow) {
                    cell.setUserObject("metricDT", metricDataTypes.get(member.getNumber()));
                }
                cell.setUserObject("shnum", member.getShowNumber());
                updateUICells.add(cell);
                String longNumber = member.getLongNumber();
                String parentLongNumber = longNumber != null && longNumber.contains("!") ? longNumber.substring(0, longNumber.lastIndexOf("!")) : longNumber;
                cellDimMember = new DiffCellDimMember(dimNumber, member.getNumber(), member.getLevel(), member.isLeaf(), (DiffCellDimMember)cellDimMemberMap.get(parentLongNumber));
                if (!member.isLeaf()) {
                    cellDimMemberMap.putIfAbsent(longNumber, cellDimMember);
                    cellDimMember.setGroupNodeType(1);
                }
                this.rowCellDimMembers.set(r, cellDimMember);
                ++r;
            }
        }
        return updateUICells;
    }

    private Map<String, kd.epm.eb.common.cache.impl.Member> getCacheMemberMap(IModelCacheHelper modelCacheHelper, List<Member> members, String dimNumber, Long viewId) {
        Map<String, kd.epm.eb.common.cache.impl.Member> cacheMemberMap = new HashMap<String, kd.epm.eb.common.cache.impl.Member>(16);
        if (modelCacheHelper == null || CollectionUtils.isEmpty(members) || StringUtils.isEmpty((String)dimNumber)) {
            return cacheMemberMap;
        }
        List collect = members.stream().map(Member::getNumber).collect(Collectors.toList());
        List cacheHelperMembers = modelCacheHelper.getMembers(modelCacheHelper.getDimension(dimNumber), viewId, collect);
        if (CollectionUtils.isEmpty((Collection)cacheHelperMembers)) {
            return cacheMemberMap;
        }
        cacheMemberMap = cacheHelperMembers.stream().collect(Collectors.toMap(BaseCache::getNumber, v -> v, (v1, v2) -> v1));
        return cacheMemberMap;
    }

    @Override
    public List<ECell> buildReportColPartition() {
        LinkedList<ECell> updateUICells;
        block21: {
            Map<String, String> metricDataTypes;
            String colMetric;
            String commonMetric;
            String METRIC;
            int tcol;
            int schemeColSize;
            List<DiffAnalyzeScheme.DiffAnalyzeColumn> schemeColumns;
            block20: {
                Dimension metricDim;
                if (this.modelid == null || this.datasetid == null || this.scheme == null) {
                    return null;
                }
                this.initSheetDefaults(this.getSheet());
                schemeColumns = this.scheme.getAnalyzeColumns();
                schemeColSize = schemeColumns.size();
                tcol = 1;
                DiffCellDimMember cellDimMember = null;
                HashMap<String, DiffCellDimMember> cellDimMemberMap = new HashMap<String, DiffCellDimMember>(16);
                updateUICells = new LinkedList<ECell>();
                List scopeMembers = null;
                LinkedHashSet<kd.epm.eb.common.cache.impl.Member> members = new LinkedHashSet<kd.epm.eb.common.cache.impl.Member>();
                METRIC = SysDimensionEnum.Metric.getNumber();
                int hAlign = HorizontalAlignEnum.Center.getIndex();
                commonMetric = null;
                colMetric = null;
                metricDataTypes = this.getMetricDataTypeMap();
                Optional<Dimension> optional = this.getCommonDimension().stream().filter(e -> METRIC.equals(e.getNumber())).findFirst();
                Dimension dimension = metricDim = optional.isPresent() ? optional.get() : null;
                if (metricDim != null && metricDim.getMembers() != null && metricDim.getMembers().size() > 0) {
                    commonMetric = ((Member)metricDim.getMembers().get(0)).getNumber();
                }
                if (this.colDimension == null) break block20;
                String dimNumber = this.colDimension.getNumber();
                IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
                HashMap<String, Set<Integer>> memberScopeMap = new HashMap<String, Set<Integer>>(16);
                Long viewId = IDUtils.toLong((Object)this.getDimemsionViews().get(dimNumber));
                scopeMembers = this.colDimension.getMembers();
                HashMap<String, Integer> partitionMemberMap = new HashMap<String, Integer>(16);
                if (scopeMembers != null && scopeMembers.size() > 0) {
                    for (Member member : this.colDimension.getMembers()) {
                        String memNumber = member.getNumber();
                        int memScope = member.getRange();
                        partitionMemberMap.put(memNumber, memScope);
                        List<kd.epm.eb.common.cache.impl.Member> cacheMems = EbSpreadManager.getMembers(modelCacheHelper, dimNumber, viewId, memNumber, memScope, memberScopeMap);
                        if (cacheMems == null || cacheMems.isEmpty()) continue;
                        members.addAll(cacheMems);
                    }
                }
                if (members.isEmpty()) break block21;
                int colSize = members.size() * schemeColSize + 2;
                this.colCellDimMembers = new ArrayList<DiffCellDimMember>(colSize);
                for (int i = 0; i < colSize; ++i) {
                    this.colCellDimMembers.add(null);
                }
                List<String> longDisplayDimNums = ReportHelper.getLongDisplayDimNums(this.memberDisplayType, this.getModelCacheHelper());
                if (CollectionUtils.isEmpty(longDisplayDimNums) && (this.memberDisplayType == MemberDisplayTypeEnum.LONGNAME.index || this.memberDisplayType == MemberDisplayTypeEnum.LONGNUMBER.index || this.memberDisplayType == MemberDisplayTypeEnum.LONGNAMENUMBER.index)) {
                    this.memberDisplayType = MemberDisplayTypeEnum.NAME.index;
                }
                for (kd.epm.eb.common.cache.impl.Member member : members) {
                    String memNumber = member.getNumber();
                    Integer memScope = (Integer)partitionMemberMap.get(memNumber);
                    memScope = EbSpreadManager.transMemScope(memberScopeMap, memNumber, memScope);
                    String shownumber = member.getShowNumber() != null ? member.getShowNumber() : member.getNumber();
                    ESpanInfo spanInfo = new ESpanInfo();
                    spanInfo.setColcount(schemeColSize);
                    StyleCell cell = this.getStyleCell(0, tcol, member.getName(), shownumber, member.getSimpleName(), schemeColSize > 1 ? spanInfo : null, member, longDisplayDimNums, dimNumber, viewId);
                    cell.setUserObject("dimnumber", this.colDimension.getNumber());
                    cell.setUserObject("memnumber", memNumber);
                    cell.setUserObject("name", member.getName());
                    cell.setUserObject("simplename", member.getSimpleName());
                    cell.setUserObject("shnum", member.getShowNumber());
                    for (int i = 0; i < schemeColSize; ++i) {
                        colMetric = (String)schemeColumns.get(i).getDataRow().getMetas().get(METRIC);
                        if (colMetric == null && commonMetric != null) {
                            colMetric = commonMetric;
                        } else if (colMetric == null && dimNumber.equals(METRIC)) {
                            colMetric = memNumber;
                        }
                        StyleCell schemeCell = this.getStyleCell(1, tcol + i, schemeColumns.get(i).getDisplayName(), null, null, null, null, null, null, null);
                        schemeCell.setUserObject("dimnumber", this.colDimension.getNumber());
                        schemeCell.setUserObject("number", memNumber);
                        schemeCell.setUserObject("simplename", member.getSimpleName());
                        schemeCell.setUserObject("index", i);
                        schemeCell.setUserObject("metric", colMetric);
                        schemeCell.setUserObject("metricDT", metricDataTypes.get(colMetric));
                        schemeCell.setUserObject("shnum", member.getShowNumber());
                        if (SysDimensionEnum.BudgetPeriod.getNumber().equals(this.colDimension.getNumber()) && memNumber != null && schemeColumns.get(i).getDataRow().getLead() != null) {
                            String leadPeriod = PeriodLeadUtils.get((String)memNumber, (PeriodLeadUtils.PeriodLead)PeriodLeadUtils.parse((String)schemeColumns.get(i).getDataRow().getLead()));
                            schemeCell.setUserObject("leadPeriod", leadPeriod);
                        } else {
                            schemeCell.setUserObject("leadPeriod", null);
                        }
                        String longNumber = member.getLongNumber();
                        String parentLongNumber = longNumber != null && longNumber.contains("!") ? longNumber.substring(0, longNumber.lastIndexOf("!")) : longNumber;
                        cellDimMember = new DiffCellDimMember(dimNumber, memNumber, member.getLevel(), member.isLeaf(), (DiffCellDimMember)cellDimMemberMap.get(parentLongNumber));
                        if (memScope != null && !member.isLeaf()) {
                            if (memScope.intValue() == RangeEnum.ONLY.getIndex()) {
                                cellDimMember.setIsleaf(true);
                            }
                            cellDimMemberMap.putIfAbsent(longNumber, cellDimMember);
                            cellDimMember.setGroupNodeType(cellDimMember.isIsleaf() ? GroupNodeTypeEnum.NONE.getIndex() : GroupNodeTypeEnum.EXPEND.getIndex());
                        }
                        this.colCellDimMembers.set(schemeCell.getCol(), cellDimMember);
                        updateUICells.add(schemeCell);
                    }
                    if (memScope != null && !member.isLeaf()) {
                        if (memScope.intValue() == RangeEnum.ONLY.getIndex()) {
                            cell.setUserObject("isLeaf", Boolean.TRUE);
                        } else {
                            cell.setUserObject("scope", memScope);
                        }
                    }
                    cell.sethAlign(hAlign);
                    updateUICells.add(cell);
                    tcol += schemeColSize;
                }
                break block21;
            }
            for (int i = 0; i < schemeColSize; ++i) {
                colMetric = (String)schemeColumns.get(i).getDataRow().getMetas().get(METRIC);
                if (colMetric == null) {
                    colMetric = commonMetric;
                }
                StyleCell schemeCell = this.getStyleCell(0, tcol + i, schemeColumns.get(i).getDisplayName(), null, null, null, null, null, null, null);
                schemeCell.setUserObject("index", i);
                schemeCell.setUserObject("metric", colMetric);
                schemeCell.setUserObject("metricDT", metricDataTypes.get(colMetric));
                updateUICells.add(schemeCell);
            }
        }
        return updateUICells;
    }

    public void setRowColStart() {
        ECell cell = this.getECell(0, 0);
        cell.setValue("  ");
        if (this.colDimension != null) {
            this.getSheet().setValueAreaRowStart(2);
            cell.setSpanInfo(new ESpanInfo(2, 1));
        } else {
            this.getSheet().setValueAreaRowStart(1);
            cell.setSpanInfo(new ESpanInfo(1, 1));
        }
        this.getSheet().setValueAreaColStart(1);
    }

    private StyleCell getStyleCell(int row, int col, String cellName, String cellNum, String simpleName, int ti, kd.epm.eb.common.cache.impl.Member cacheMember, List<String> longDisplayDimNums, String dimNumber, Long viewId) {
        StyleCell cell = this.getStyleCell(row, col);
        this.setCellValueByMemberDisPlayType(cell, cellName, cellNum, simpleName, cacheMember, longDisplayDimNums, dimNumber, viewId);
        cell.setFont("13px Microsoft YaHei");
        cell.setTextIndent(ti);
        return cell;
    }

    private StyleCell getStyleCell(int row, int col, String cellName, String cellNum, String simpleName, ESpanInfo spanInfo, kd.epm.eb.common.cache.impl.Member cacheMember, List<String> longDisplayDimNums, String dimNumber, Long viewId) {
        StyleCell cell = this.getStyleCell(row, col);
        cell.setFont("13px Microsoft YaHei");
        if (spanInfo != null) {
            this.setCellValueByMemberDisPlayType(cell, cellName, cellNum, simpleName, cacheMember, longDisplayDimNums, dimNumber, viewId);
            cell.setSpanInfo(spanInfo);
        } else if (cacheMember == null) {
            cell.setValue(cellName);
        } else {
            this.setCellValueByMemberDisPlayType(cell, cellName, cellNum, simpleName, cacheMember, longDisplayDimNums, dimNumber, viewId);
        }
        return cell;
    }

    private void setCellValueByMemberDisPlayType(StyleCell cell, String cellName, String cellNum, String simpleName, kd.epm.eb.common.cache.impl.Member cacheMember, List<String> longDisplayDimNums, String dimNumber, Long viewId) {
        if (MemberDisplayTypeEnum.NAME.getIndex() == this.memberDisplayType || MemberDisplayTypeEnum.SIMPLENAME.getIndex() == this.memberDisplayType && StringUtils.isEmpty((String)simpleName) || MemberDisplayTypeEnum.LONGNAME.getIndex() == this.memberDisplayType) {
            cell.setValue(cellName);
        } else if (MemberDisplayTypeEnum.SIMPLENAME.getIndex() == this.memberDisplayType) {
            cell.setValue(simpleName);
        } else if (MemberDisplayTypeEnum.NUMBER.getIndex() == this.memberDisplayType || MemberDisplayTypeEnum.LONGNUMBER.getIndex() == this.memberDisplayType) {
            cell.setValue(cellNum);
        } else if (MemberDisplayTypeEnum.NAMEANDNUMBER.getIndex() == this.memberDisplayType || MemberDisplayTypeEnum.SIMNAMENUMBER.getIndex() == this.memberDisplayType && StringUtils.isEmpty((String)simpleName) || MemberDisplayTypeEnum.LONGNAMENUMBER.getIndex() == this.memberDisplayType) {
            cell.setValue(cellName + ":" + cellNum);
        } else if (MemberDisplayTypeEnum.SIMNAMENUMBER.getIndex() == this.memberDisplayType) {
            cell.setValue(simpleName + ":" + cellNum);
        }
        this.setCellValueByLongDisplayType(cell, longDisplayDimNums, cacheMember, dimNumber, viewId);
    }

    protected void setCellValueByLongDisplayType(StyleCell cell, List<String> longDisplayDimNums, kd.epm.eb.common.cache.impl.Member cacheMember, String dimNumber, Long viewId) {
        boolean displayLong;
        if (cell == null || CollectionUtils.isEmpty(longDisplayDimNums) || cacheMember == null || StringUtils.isEmpty((String)dimNumber)) {
            return;
        }
        boolean bl = displayLong = MemberDisplayTypeEnum.LONGNUMBER.getIndex() == this.memberDisplayType || MemberDisplayTypeEnum.LONGNAME.getIndex() == this.memberDisplayType || MemberDisplayTypeEnum.LONGNAMENUMBER.getIndex() == this.memberDisplayType;
        if (longDisplayDimNums.contains(dimNumber) && displayLong) {
            String longName;
            IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
            String longNumber = cacheMember.getLongNumber();
            String string = longName = StringUtils.isNotEmpty((String)longNumber) ? cacheMember.getLongName(modelCacheHelper.getParentsByOrder(viewId, cacheMember, false)) : "";
            if (StringUtils.isEmpty((String)longName)) {
                longName = cacheMember.getName();
            }
            if (StringUtils.isEmpty((String)longNumber)) {
                longNumber = cacheMember.getNumber();
            }
            cell.setUserObject("longname", longName);
            cell.setUserObject("longnumber", longNumber);
            if (MemberDisplayTypeEnum.LONGNUMBER.getIndex() == this.memberDisplayType) {
                cell.setValue(longNumber);
            } else if (MemberDisplayTypeEnum.LONGNAME.getIndex() == this.memberDisplayType) {
                cell.setValue(longName);
            } else if (MemberDisplayTypeEnum.LONGNAMENUMBER.getIndex() == this.memberDisplayType) {
                cell.setValue(longName + ":" + longNumber);
            }
        }
    }

    private StyleCell getStyleCell(int row, int col) {
        return (StyleCell)this.getEbook().getSheet(0).getECell(row, col);
    }

    private StyleCell getStyleCellNotAdd(int row, int col) {
        return (StyleCell)this.getEbook().getSheet(0).getECellNotAdd(row, col);
    }

    private ECell getECell(int row, int col) {
        return this.getEbook().getSheet(0).getECell(row, col);
    }

    private ISheet getSheet() {
        return this.getEbook().getSheet(0);
    }

    @Override
    public int getValueRowStart() {
        return this.getSheet().getValueAreaRowStart();
    }

    @Override
    public int getValueRowEnd() {
        return this.getSheet().getRealMaxRows();
    }

    @Override
    public int getValueColStart() {
        return this.getSheet().getValueAreaColStart();
    }

    @Override
    public int getValueColEnd() {
        return this.getSheet().getRealMaxCols();
    }

    @Override
    public int getSchemeRowIndex() {
        return this.colCellDimMembers != null && this.colCellDimMembers.size() > 0 ? 1 : 0;
    }

    @Override
    public IModelCacheHelper getModelCacheHelper() {
        if (this.modelCacheHelper == null) {
            this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelid());
        }
        return this.modelCacheHelper;
    }

    @Override
    public void setModelCacheHelper(IModelCacheHelper modelCacheHelper) {
        this.modelCacheHelper = modelCacheHelper;
    }

    @Override
    public IMemberPermCache getMemberPerm() {
        if (this.memberPerm == null) {
            this.memberPerm = MemberPermCacheServiceHelper.build(null, (Long)this.getModelid(), (Long)this.getModelCacheHelper().getBusModelByDataSet(this.getDatasetid()), null);
        }
        return this.memberPerm;
    }

    @Override
    public void setMemberPerm(IMemberPermCache memberPerm) {
        this.memberPerm = memberPerm;
    }

    @Override
    public Long getModelid() {
        return this.modelid;
    }

    @Override
    public void setModelid(Long modelid) {
        this.modelid = modelid;
    }

    @Override
    public Long getDatasetid() {
        return this.datasetid;
    }

    @Override
    public void setDatasetid(Long datasetid) {
        this.datasetid = datasetid;
    }

    @Override
    public Long getBusmodelid() {
        if (this.busmodelid == null && this.getDatasetid() != null) {
            this.busmodelid = DatasetServiceHelper.getBusModelIdByDataset((Long)this.getDatasetid());
        }
        return this.busmodelid;
    }

    public void setBusmodelid(Long busmodelid) {
        this.busmodelid = busmodelid;
    }

    @Override
    public Map<String, Long> getDimemsionViews() {
        return this.dimemsionViews;
    }

    @Override
    public void setDimemsionViews(Map<String, Long> dimemsionViews) {
        this.dimemsionViews = dimemsionViews;
    }

    private void initDimensionViews() {
        IModelCacheHelper modelCache = ModelCacheContext.getOrCreate((Long)this.getModelid());
        Map viewsByDataSet = modelCache.getViewsByDataSet(this.getDatasetid());
        if (viewsByDataSet != null) {
            for (Map.Entry dimView : viewsByDataSet.entrySet()) {
                this.dimemsionViews.put((String)dimView.getKey(), (Long)dimView.getValue());
            }
        }
    }

    private boolean verify() {
        return this.scheme != null && this.modelid != null && this.datasetid != null;
    }

    @Override
    public Dimension getRowDimension() {
        return this.rowDimension;
    }

    @Override
    public void setRowDimension(Dimension rowDimension) {
        this.rowDimension = rowDimension;
    }

    @Override
    public Dimension getColDimension() {
        return this.colDimension;
    }

    @Override
    public void setColDimension(Dimension colDimension) {
        this.colDimension = colDimension;
    }

    @Override
    public List<Dimension> getCommonDimension() {
        return this.commonDimension;
    }

    @Override
    public void setCommonDimension(List<Dimension> commonDimension) {
        this.commonDimension = commonDimension;
    }

    @Override
    public List<DiffCellDimMember> getRowCellDimMembers() {
        return this.rowCellDimMembers;
    }

    public void setRowCellDimMembers(List<DiffCellDimMember> rowCellDimMembers) {
        this.rowCellDimMembers = rowCellDimMembers;
    }

    @Override
    public List<DiffCellDimMember> getColCellDimMembers() {
        return this.colCellDimMembers;
    }

    public void setColCellDimMembers(List<DiffCellDimMember> colCellDimMembers) {
        this.colCellDimMembers = colCellDimMembers;
    }

    private Set<String> getTopItems() {
        Map configMap;
        String topItems;
        if (this.scheme != null && StringUtils.isNotEmpty((String)this.scheme.getConfigJson()) && StringUtils.isNotEmpty((String)(topItems = (String)(configMap = (Map)SerializationUtils.fromJsonString((String)this.scheme.getConfigJson(), Map.class)).get("TOP_ITEMS")))) {
            Object[] items;
            if (this.isJson(topItems)) {
                ArrayList item = new ArrayList(8);
                List topMap = (List)SerializationUtils.fromJsonString((String)topItems, List.class);
                for (Map stringStringMap : topMap) {
                    item.add(stringStringMap.get("number"));
                }
                items = item.toArray(new String[0]);
            } else {
                items = topItems.split(",");
            }
            return Sets.newHashSet((Object[])items);
        }
        return null;
    }

    private boolean isJson(String config) {
        boolean result = false;
        if (config.startsWith("{") && config.endsWith("}")) {
            result = true;
        } else if (config.startsWith("[") && config.endsWith("]")) {
            result = true;
        }
        return result;
    }

    private Map<String, String> getMetricDataTypeMap() {
        if (this.metricDataTypeMap != null) {
            return this.metricDataTypeMap;
        }
        this.metricDataTypeMap = new HashMap<String, String>(16);
        List members = this.getModelCacheHelper().getMembers(null, SysDimensionEnum.Metric.getNumber());
        if (members != null) {
            members.forEach(m -> this.metricDataTypeMap.put(m.getNumber(), m.getDatatype()));
        }
        return this.metricDataTypeMap;
    }

    @Override
    public boolean isHideEmptyRows() {
        return this.hideEmptyRows;
    }

    @Override
    public void setHideEmptyRows(boolean hideEmptyRows) {
        this.hideEmptyRows = hideEmptyRows;
    }

    @Override
    public String getDataUnit() {
        return this.dataUnit;
    }

    @Override
    public void setDataUnit(String dataUnit) {
        this.dataUnit = dataUnit;
    }

    @Override
    public int getMemberDisplayType() {
        return this.memberDisplayType;
    }

    @Override
    public void setMemberDisplayType(int memberDisplayType) {
        this.memberDisplayType = memberDisplayType;
    }
}

