/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.template.spreadmanager;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Sets;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.Stack;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.entity.DynamicObjectCollection;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.entity.tree.TreeNode;
import kd.bos.exception.KDBizException;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.bos.util.StringUtils;
import kd.epm.eb.common.bgmddatalock.BgmdDataLockService;
import kd.epm.eb.common.bgmddatalock.IBgmdDataLockCache;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.impl.ViewMember;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.dimension.property.PropertyMemObj;
import kd.epm.eb.common.dimension.property.PropertyObj;
import kd.epm.eb.common.ebcommon.common.enums.MemberDisplayTypeEnum;
import kd.epm.eb.common.entity.property.CustomProperty;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.enums.GroupNodeTypeEnum;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.RangeF7PropertyCataEnum;
import kd.epm.eb.common.member.f7.MemberParamsUtils;
import kd.epm.eb.common.permission.IMemberPermCache;
import kd.epm.eb.common.permission.MemberPermCacheServiceHelper;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.ExcelUtils;
import kd.epm.eb.common.utils.GlobalIdUtil;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.spread.command.style.VerticalAlignEnum;
import kd.epm.eb.spread.template.BaseEntry;
import kd.epm.eb.spread.template.IBaseEntry;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.arearangedim.IRowColDimensionEntry;
import kd.epm.eb.spread.template.dimension.DefaultDimMember;
import kd.epm.eb.spread.template.dimension.IDimension;
import kd.epm.eb.spread.template.dimension.IDimensionMember;
import kd.epm.eb.spread.template.dimension.PageViewDimMember;
import kd.epm.eb.spread.template.dimension.userdefinedproperty.PropertyEntry;
import kd.epm.eb.spread.template.dimension.userdefinedproperty.PropertyValueEntry;
import kd.epm.eb.spread.template.headerarea.IHeaderInfo;
import kd.epm.eb.spread.template.metric.IMetricDimMmeber;
import kd.epm.eb.spread.template.pagedim.IPageDimensionEntry;
import kd.epm.eb.spread.template.partition.IPartitionSetting;
import kd.epm.eb.spread.template.partition.RowColPartition;
import kd.epm.eb.spread.template.spreadmanager.CellDimMember;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.LevelMember;
import kd.epm.eb.spread.template.spreadmanager.MetricCellDimMember;
import kd.epm.eb.spread.template.spreadmanager.book.IEBook;
import kd.epm.eb.spread.template.spreadmanager.hander.ESpanInfo;
import kd.epm.eb.spread.template.spreadmanager.list.SPArrayList;
import kd.epm.eb.spread.template.spreadmanager.serializer.EbSpreadManagerDeserializer;
import kd.epm.eb.spread.template.spreadmanager.serializer.EbSpreadManagerSerializer;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import kd.epm.eb.spread.template.spreadmanager.sheet.StyleCell;
import kd.epm.eb.spread.template.viewpointdim.IViewPointDimensionEntry;
import kd.epm.eb.spread.utils.DimPropertyHelper;
import kd.epm.eb.spread.utils.ReportHelper;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarCommonUtil;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarUtil;
import org.apache.commons.collections4.CollectionUtils;

@JsonSerialize(using=EbSpreadManagerSerializer.class)
@JsonDeserialize(using=EbSpreadManagerDeserializer.class)
public class EbSpreadManager
implements IEbSpreadManager {
    private static final long serialVersionUID = -2887194079676145677L;
    private IEBook ebook = null;
    private List<List<CellDimMember>> colpartitionDimMems = new SPArrayList<List<CellDimMember>>(50);
    private List<String> colpartitionDims = new ArrayList<String>();
    private List<List<CellDimMember>> rowpartitionDimMems = new SPArrayList<List<CellDimMember>>(100);
    private List<String> rowpartitionDims = new ArrayList<String>();
    private Map<String, Set<String>> alldimensionWithMembers = new HashMap<String, Set<String>>();
    private Map<String, PageViewDimMember> pageViewDims = new HashMap<String, PageViewDimMember>();
    private Set<String> toDeleteData = new HashSet<String>();
    private IBaseEntry modelobj;
    private boolean isShowNumber;
    private int dimMemDefaultDisplayType = 1;
    private int maxSize = 500000;
    private boolean isShowProperty = true;
    private boolean isShowMetricNumber;
    private Map<String, List<Long>> approveBillDimMembers;
    private transient IMemberPermCache memberPerm;
    private transient IBgmdDataLockCache dataLockCache;
    private boolean needMergeCells = true;
    private boolean needHandleIndents = true;
    private transient Map<Integer, List<ECell>> indentcells = new HashMap<Integer, List<ECell>>(16);
    private transient Map<Integer, Boolean> indentParents = new HashMap<Integer, Boolean>(16);
    private boolean isRowSpan = false;
    private transient IModelCacheHelper modelCacheHelper;
    private Map<String, Long> dimemsionViews = new HashMap<String, Long>();
    private Long busModelid;
    private Long datasetid;
    private Map<String, Map<String, String>> formulaMap = new HashMap<String, Map<String, String>>(16);
    private Map<String, Map<String, String>> outAreaHyperLink = new HashMap<String, Map<String, String>>(16);
    private Integer metricRowIndex;
    private Integer metricColIndex;
    private transient Set<String> longDisplayDims = null;
    private Map<String, Integer> metricDatatypeMap33;
    private boolean needCheckPerm = true;
    Long reportProcessId;
    private Long processId;
    private String processType;
    private String varFlagStr;
    private boolean isPreview;

    @Override
    public Integer getMetricRowIndex() {
        return this.metricRowIndex;
    }

    public void setMetricRowIndex(Integer metricRowIndex) {
        this.metricRowIndex = metricRowIndex;
    }

    @Override
    public Integer getMetricColIndex() {
        return this.metricColIndex;
    }

    public void setMetricColIndex(Integer metricColIndex) {
        this.metricColIndex = metricColIndex;
    }

    @Override
    public IEBook getEbook() {
        return this.ebook;
    }

    @Override
    public void setEbook(IEBook ebook) {
        this.ebook = ebook;
    }

    public ISheet getSheet() {
        return this.getEbook().getSheet(0);
    }

    @Override
    public void buildReportManager(ITemplateModel templateModel) {
        HashMap<String, Map<String, Set<Integer>>> memberScope;
        Map<String, Set<Member>> rowColDimMembers;
        int count;
        if (this.getModelobj() == null || this.getModelobj().getId() == null || this.getModelobj().getId() == 0L) {
            this.initModelObj(templateModel);
        }
        this.buildHidedimsIntoAllDimension(templateModel);
        this.checkViewMemberPermission(templateModel);
        if (templateModel.getPartitionSetting() == null) {
            return;
        }
        Map<String, Map<String, String>> varValus = null;
        if (TemplateVarUtil.isReport(templateModel) && this.getProcessId() != null && TemplateVarUtil.isVarTemplate(templateModel)) {
            if (ProcessTypeEnum.REPORT.getNumber().equals(this.getProcessType()) || ProcessTypeEnum.ANALYSIS.getNumber().equals(this.getProcessType())) {
                varValus = ReportVarUtil.getVarValues(this.getProcessType(), this.modelobj.getId(), this.processId, templateModel.getTemplateBaseInfo().getVarBase());
            } else if (ProcessTypeEnum.TASK.getNumber().equals(this.getProcessType())) {
                String formID = "eb_taskprocess";
                boolean exists = QueryServiceHelper.exists((String)formID, (Object)this.processId);
                varValus = exists ? ReportVarUtil.getVarValues(this.getProcessType(), this.modelobj.getId(), this.processId, templateModel.getTemplateBaseInfo().getVarBase()) : ReportVarUtil.getVarValueByTaskList(this.modelobj.getId(), this.processId, templateModel.getTemplateBaseInfo().getId());
            }
        }
        Map<String, Map<String, String>> varNumberNameMap = null;
        if (TemplateVarUtil.isReport(templateModel) && this.getProcessId() == null && TemplateVarUtil.isVarTemplate(templateModel)) {
            varNumberNameMap = TemplateVarCommonUtil.getVarIDNumberMap("isNeedVar", templateModel.getModelId());
        }
        if ((count = this.calculateTemplateSize(rowColDimMembers = this.resolveMemberScope(templateModel, varValus, varNumberNameMap, memberScope = new HashMap<String, Map<String, Set<Integer>>>(16)), templateModel)) > this.getMaxSize() || count < 0) {
            throw new KDBizException(ResManager.loadKDString((String)"\u8d85\u8fc7\u6a21\u677f\u6700\u5927\u5355\u5143\u683c\u6570\uff0c\u8bf7\u7f29\u5c0f\u7ef4\u5ea6\u6210\u5458\u8303\u56f4\u3002", (String)"EbSpreadManager_0", (String)"epm-eb-spread", (Object[])new Object[0]));
        }
        this.getEbook().getSheet(0).setStyleCell(true);
        this.initHeaderInfos(templateModel.getAreaRangeEntry().getColHeaders(), templateModel.getAreaRangeEntry().getColdimensions());
        this.initHeaderInfos(templateModel.getAreaRangeEntry().getRowHeaders(), templateModel.getAreaRangeEntry().getRowdimensions());
        if (this.longDisplayDims == null) {
            this.longDisplayDims = new HashSet<String>(16);
            List longNameNumDimsList = MemberParamsUtils.getLongNameNumDisplayParamsByCache((long)this.getModelobj().getId());
            if (longNameNumDimsList != null && !longNameNumDimsList.isEmpty()) {
                this.longDisplayDims.addAll(longNameNumDimsList);
            }
        }
        this.buildReportColPartition(templateModel, rowColDimMembers, varValus, memberScope);
        this.buildReportRowPartition(templateModel, rowColDimMembers, varValus, memberScope);
        this.mergeRowColDimensionCross(templateModel);
    }

    private void initHeaderInfos(List<IHeaderInfo> headerInfos, List<IDimension> dimensions) {
        if (headerInfos != null && dimensions != null) {
            IHeaderInfo metricHeaderInfo = null;
            for (IDimension dimension : dimensions) {
                block1: for (IHeaderInfo headerInfo : headerInfos) {
                    if ("Dimension".equals(headerInfo.getType()) && dimension.getNumber().equals(headerInfo.getNumber())) {
                        headerInfo.setId(dimension.getId());
                        headerInfo.setName(dimension.getName());
                        if (!SysDimensionEnum.Metric.getNumber().equals(dimension.getNumber())) continue;
                        metricHeaderInfo = headerInfo;
                        continue;
                    }
                    if (!"Property".equals(headerInfo.getType()) || !dimension.getNumber().equals(headerInfo.getRefDimension()) || dimension.getPropertyEntries() == null) continue;
                    for (PropertyEntry propertyEntry : dimension.getPropertyEntries()) {
                        if (!propertyEntry.getNumber().equals(headerInfo.getNumber())) continue;
                        headerInfo.setId(propertyEntry.getId());
                        headerInfo.setName(propertyEntry.getName());
                        continue block1;
                    }
                }
            }
            if (metricHeaderInfo != null) {
                headerInfos.remove(metricHeaderInfo);
            }
        }
    }

    private int calculateTemplateSize(Map<String, Set<Member>> allDimension_Members, ITemplateModel templateModel) {
        if (allDimension_Members != null && templateModel != null) {
            int i;
            Boolean isMetricInRow = templateModel.getAreaRangeEntry().isMetricInRow();
            List<RowColPartition> rowPartitions = templateModel.getPartitionSetting().getRowPartition();
            List<RowColPartition> colPartitions = templateModel.getPartitionSetting().getColPartition();
            if (rowPartitions.isEmpty() || colPartitions.isEmpty()) {
                return 0;
            }
            List rowDims = rowPartitions.get(0).getRowColDimensionEntries().stream().map(e -> e.getDimension().getNumber()).collect(Collectors.toList());
            List colDims = colPartitions.get(0).getRowColDimensionEntries().stream().map(e -> e.getDimension().getNumber()).collect(Collectors.toList());
            Integer[] rowPartSize = new Integer[rowPartitions.size()];
            Integer[] colPartSize = new Integer[colPartitions.size()];
            for (Map.Entry<String, Set<Member>> entry : allDimension_Members.entrySet()) {
                int n;
                Integer[] integerArray;
                String[] dimPartition = entry.getKey().split("_");
                if (rowDims.contains(dimPartition[0])) {
                    int rowIndex = Integer.parseInt(dimPartition[1]);
                    if (rowPartSize[rowIndex] == null) {
                        rowPartSize[rowIndex] = entry.getValue().size();
                        continue;
                    }
                    integerArray = rowPartSize;
                    n = rowIndex;
                    Integer.valueOf(integerArray[n] * entry.getValue().size());
                    continue;
                }
                if (!colDims.contains(dimPartition[0])) continue;
                int colIndex = Integer.parseInt(dimPartition[1]);
                if (colPartSize[colIndex] == null) {
                    colPartSize[colIndex] = entry.getValue().size();
                    continue;
                }
                integerArray = colPartSize;
                n = colIndex;
                Integer.valueOf(integerArray[n] * entry.getValue().size());
            }
            int rowCells = colDims.size();
            int colCells = rowDims.size();
            if (Boolean.TRUE.equals(isMetricInRow)) {
                ++colCells;
            } else if (Boolean.FALSE.equals(isMetricInRow)) {
                ++rowCells;
            }
            for (i = 0; i < rowPartSize.length; ++i) {
                if (rowPartSize[i] == null) continue;
                if (Boolean.TRUE.equals(isMetricInRow)) {
                    rowCells += rowPartSize[i] * rowPartitions.get(i).getMetricDimMmebers().size();
                    continue;
                }
                rowCells += rowPartSize[i].intValue();
            }
            for (i = 0; i < colPartSize.length; ++i) {
                if (colPartSize[i] == null) continue;
                if (Boolean.FALSE.equals(isMetricInRow)) {
                    colCells += colPartSize[i] * colPartitions.get(i).getMetricDimMmebers().size();
                    continue;
                }
                colCells += colPartSize[i].intValue();
            }
            return rowCells * colCells;
        }
        return 0;
    }

    private Set<Member> getCommonPart(Set<Member> dimSet, List<Long> ids) {
        List dimIds = dimSet.stream().map(e -> e.getId()).collect(Collectors.toList());
        dimIds.retainAll(ids);
        Iterator<Member> dimIterator = dimSet.iterator();
        while (dimIterator.hasNext()) {
            Member member = dimIterator.next();
            if (dimIds.contains(member.getId())) continue;
            dimIterator.remove();
        }
        return dimSet;
    }

    private void mergeRowColDimensionCross(ITemplateModel templateModel) {
        int rowdims = this.getColpartitionDims().size();
        int coldims = this.getRowpartitionDims().size();
        int valuerowstart = this.getEbook().getSheet(0).getValueAreaRowStart();
        int valuecolstart = this.getEbook().getSheet(0).getValueAreaColStart();
        if (this.isShowProperty()) {
            IPartitionSetting partitionSetting = templateModel.getPartitionSetting();
            List<RowColPartition> colpartitions = partitionSetting.getColPartition();
            List<RowColPartition> rowpartitions = partitionSetting.getRowPartition();
            int colPropertyCount = this.getPropertyCount(colpartitions.get(0).getRowColDimensionEntries());
            int rowPropertyCount = this.getPropertyCount(rowpartitions.get(0).getRowColDimensionEntries());
            rowdims += colPropertyCount;
            coldims += rowPropertyCount;
        }
        if (rowdims > 0 && coldims > 0 && valuerowstart - rowdims >= 0 && valuecolstart - coldims >= 0) {
            ECell cell = this.getEbook().getSheet(0).getECell(valuerowstart - rowdims, valuecolstart - coldims);
            cell.setValue("  ");
            cell.setSpanInfo(new ESpanInfo(rowdims, coldims));
        }
    }

    @Override
    public Map<String, Integer> getMetricDatatypeMap() {
        if (this.metricDatatypeMap33 == null || this.metricDatatypeMap33.isEmpty()) {
            this.metricDatatypeMap33 = this.queryMetricDataType(this.getModelobj().getId());
        }
        return this.metricDatatypeMap33;
    }

    private Map<String, Integer> queryMetricDataType(Long modelId) {
        QFilter modelqfilter = new QFilter("model", "=", (Object)modelId);
        Map metricmembers = BusinessDataServiceHelper.loadFromCache((String)"epm_metricmembertree", (String)"number, datatype", (QFilter[])new QFilter[]{modelqfilter});
        HashMap<String, Integer> metricDatatypeMap = new HashMap<String, Integer>();
        if (metricmembers != null && metricmembers.size() > 0) {
            for (Map.Entry metricobjects : metricmembers.entrySet()) {
                DynamicObject metricobject = (DynamicObject)metricobjects.getValue();
                metricDatatypeMap.put(metricobject.getString("number"), metricobject.getInt("datatype"));
            }
        }
        return metricDatatypeMap;
    }

    @Override
    public Map<String, CellDimMember> getColpartitionDimMemsByCol(Integer col) {
        List<CellDimMember> dimMembers = this.getColpartitionDimMems().get(col);
        if (dimMembers == null || dimMembers.size() == 0) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, CellDimMember> dimMemberMap = new LinkedHashMap<String, CellDimMember>(dimMembers.size());
        for (int i = 0; i < dimMembers.size(); ++i) {
            dimMemberMap.put(this.getColpartitionDims().get(i), dimMembers.get(i));
        }
        return dimMemberMap;
    }

    @Override
    public Map<String, CellDimMember> getRowpartitionDimMemsByRow(Integer row) {
        List<CellDimMember> dimMembers = this.getRowpartitionDimMems().get(row);
        if (dimMembers == null || dimMembers.size() == 0) {
            return Collections.emptyMap();
        }
        LinkedHashMap<String, CellDimMember> dimMemberMap = new LinkedHashMap<String, CellDimMember>(dimMembers.size());
        for (int i = 0; i < dimMembers.size(); ++i) {
            dimMemberMap.put(this.getRowpartitionDims().get(i), dimMembers.get(i));
        }
        return dimMemberMap;
    }

    @Override
    public Map<String, Set<String>> getAlldimensionWithMembers() {
        return this.alldimensionWithMembers;
    }

    @Override
    public Map<String, Set<String>> getFloatMembers() {
        return null;
    }

    @Override
    public IBaseEntry getModelobj() {
        return this.modelobj;
    }

    @Override
    public void setModelobj(IBaseEntry modelobj) {
        this.modelobj = modelobj;
    }

    @Override
    public Map<String, PageViewDimMember> getPageViewDims() {
        return this.pageViewDims;
    }

    @Override
    public Set<String> getToDeleteData() {
        return this.toDeleteData;
    }

    @Override
    public void setToDeleteData(Set<String> toDeleteData) {
        this.toDeleteData = toDeleteData;
    }

    @Override
    public List<List<CellDimMember>> getColpartitionDimMems() {
        return this.colpartitionDimMems;
    }

    @Override
    public void setColpartitionDimMems(List<List<CellDimMember>> colpartitionDimMems) {
        this.colpartitionDimMems = colpartitionDimMems;
    }

    @Override
    public List<String> getColpartitionDims() {
        return this.colpartitionDims;
    }

    @Override
    public void setColpartitionDims(List<String> colpartitionDims) {
        this.colpartitionDims = colpartitionDims;
    }

    @Override
    public List<List<CellDimMember>> getRowpartitionDimMems() {
        return this.rowpartitionDimMems;
    }

    @Override
    public void setRowpartitionDimMems(List<List<CellDimMember>> rowpartitionDimMems) {
        this.rowpartitionDimMems = rowpartitionDimMems;
    }

    @Override
    public List<String> getRowpartitionDims() {
        return this.rowpartitionDims;
    }

    @Override
    public void setRowpartitionDims(List<String> rowpartitionDims) {
        this.rowpartitionDims = rowpartitionDims;
    }

    @Override
    public boolean isShowNumber() {
        return this.isShowNumber;
    }

    @Override
    public void setShowNumber(boolean showNumber) {
        this.isShowNumber = showNumber;
    }

    @Override
    public boolean isShowMetricNumber() {
        return this.isShowMetricNumber;
    }

    @Override
    public void setShowMetricNumber(boolean showMetricNumber) {
        this.isShowMetricNumber = showMetricNumber;
    }

    @Override
    public Map<String, List<Long>> getApproveBillDimMembers() {
        return this.approveBillDimMembers;
    }

    @Override
    public void setApproveBillDimMembers(Map<String, List<Long>> approveBillDimMembers) {
        this.approveBillDimMembers = approveBillDimMembers;
    }

    @Override
    public boolean isDimensionCombine(int row, int col) {
        List<CellDimMember> rowdims = this.getRowpartitionDimMems().get(row);
        List<CellDimMember> coldims = this.getColpartitionDimMems().get(col);
        return rowdims != null && rowdims.size() > 0 && coldims != null && coldims.size() > 0;
    }

    @Override
    public boolean isDimensionCombine(ECell cell) {
        return this.isDimensionCombine(cell.getRow(), cell.getCol());
    }

    @Override
    public String getDeleteSepar() {
        return "&";
    }

    @Override
    public IMemberPermCache getMemberPerm() {
        if (this.memberPerm == null) {
            this.memberPerm = MemberPermCacheServiceHelper.build(null, (Long)this.getModelobj().getId(), (Long)this.getBusModelid(), null);
        }
        return this.memberPerm;
    }

    @Override
    public IBgmdDataLockCache getDataLock() {
        if (this.dataLockCache == null) {
            this.dataLockCache = BgmdDataLockService.getInstance().getDataLockCache(this.getModelobj().getId(), this.getBusModelid());
        }
        return this.dataLockCache;
    }

    public void setMemberPerm(IMemberPermCache memberPerm) {
        this.memberPerm = memberPerm;
    }

    private void buildHidedimsIntoAllDimension(ITemplateModel templateModel) {
        List<IViewPointDimensionEntry> hidedims = templateModel.getHidedimentry();
        if (hidedims != null) {
            for (IViewPointDimensionEntry hidedim : hidedims) {
                this.alldimensionWithMembers.put(hidedim.getDimension().getNumber(), Sets.newHashSet((Object[])new String[]{hidedim.getMember().getNumber()}));
                PageViewDimMember pageViewDimMember = new PageViewDimMember(hidedim.getMember().getNumber(), true);
                this.pageViewDims.put(hidedim.getDimension().getNumber(), pageViewDimMember);
            }
        }
    }

    private int getPropertyCount(List<IRowColDimensionEntry> dimEntrys) {
        int count = 0;
        for (IRowColDimensionEntry dimEntry : dimEntrys) {
            count += dimEntry.getDimension().getPropertyEntries().size();
        }
        return count;
    }

    private ECell getECell(int row, int col, String cellName, String cellNum, ESpanInfo spanInfo) {
        ECell cell = this.ebook.getSheet(0).getECell(row, col);
        if (this.isShowNumber) {
            cell.setValue(cellName + "(" + cellNum + ")");
        } else {
            cell.setValue(cellName);
        }
        if (spanInfo != null) {
            cell.setSpanInfo(spanInfo);
        }
        return cell;
    }

    private StyleCell getStyleECell(int row, int col, String cellName, String cellNum, ESpanInfo spanInfo) {
        return (StyleCell)this.getECell(row, col, cellName, cellNum, spanInfo);
    }

    private void buildReportColPartition(ITemplateModel templateModel, Map<String, Set<Member>> allDimension_Members, Map<String, Map<String, String>> varValus, Map<String, Map<String, Set<Integer>>> memberScope) {
        IPartitionSetting partitionSetting = templateModel.getPartitionSetting();
        List<RowColPartition> rowpartitions = partitionSetting.getRowPartition();
        List<RowColPartition> colpartitions = partitionSetting.getColPartition();
        List<IHeaderInfo> rowHeaders = templateModel.getAreaRangeEntry().getRowHeaders();
        List<IHeaderInfo> colHeaders = templateModel.getAreaRangeEntry().getColHeaders();
        int[] xy_start = ExcelUtils.pos2XY((String)partitionSetting.getPartitionInfo().getStartposition());
        int dimRowStart = xy_start[1];
        int dimColStart = xy_start[0];
        int valueRowStart = dimRowStart + colHeaders.size();
        int valueColStart = dimColStart + rowHeaders.size();
        if (rowpartitions.get(0).getMetricDimMmebers().size() > 0) {
            this.metricColIndex = valueColStart;
            valueColStart = this.metricColIndex + 1;
        }
        ISheet sheet = this.getSheet();
        sheet.setDimColStart(dimColStart);
        sheet.setValueAreaColStart(valueColStart);
        int row = dimRowStart;
        int col = valueColStart;
        IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
        HashMap<String, CellDimMember> cdmMap = new HashMap<String, CellDimMember>(16);
        List<String> longDisplayDimNums = ReportHelper.getLongDisplayDimNums(MemberDisplayTypeEnum.LONGNUMBER.getIndex(), this.getModelCacheHelper());
        for (int partitionnumber = 0; partitionnumber < colpartitions.size(); ++partitionnumber) {
            RowColPartition colpartition = colpartitions.get(partitionnumber);
            List<IMetricDimMmeber> metricDimMmebers = colpartition.getMetricDimMmebers();
            int metricspan = 1;
            if (metricDimMmebers.size() > 0) {
                metricspan = metricDimMmebers.size();
            }
            List<IRowColDimensionEntry> dimensionentrys = colpartition.getRowColDimensionEntries();
            int trow = row;
            for (int dimindex = 0; dimindex < dimensionentrys.size(); ++dimindex) {
                String dimensionnumber;
                int tcol = col;
                int span = metricspan;
                int curPropertyCount = 0;
                for (int temp_dimindex = dimindex + 1; temp_dimindex < dimensionentrys.size(); ++temp_dimindex) {
                    dimensionnumber = dimensionentrys.get(temp_dimindex).getDimension().getNumber();
                    String map_key = dimensionnumber + "_" + partitionnumber;
                    Set<Member> tempmembers = allDimension_Members.get(map_key);
                    if (tempmembers == null || tempmembers.size() <= 0) continue;
                    span *= tempmembers.size();
                }
                IRowColDimensionEntry dimensionentry = dimensionentrys.get(dimindex);
                dimensionnumber = dimensionentry.getDimension().getNumber();
                List<IDimensionMember> members = dimensionentry.getMembers();
                HashMap<String, Integer> partitionMemberMap = new HashMap<String, Integer>(members.size());
                for (IDimensionMember member : members) {
                    partitionMemberMap.put(member.getNumber(), member.getScope());
                }
                String current_mapkey = dimensionnumber + "_" + partitionnumber;
                Set<Member> current_members = allDimension_Members.get(current_mapkey);
                Map<String, Set<Integer>> scopeMap = memberScope.get(current_mapkey);
                if (current_members != null && current_members.size() > 0) {
                    int crcyleSize = 1;
                    for (int temp_dimindex = dimindex - 1; temp_dimindex >= 0; --temp_dimindex) {
                        String updimensionnumber = dimensionentrys.get(temp_dimindex).getDimension().getNumber();
                        String map_key = updimensionnumber + "_" + partitionnumber;
                        Set<Member> tempmembers = allDimension_Members.get(map_key);
                        if (tempmembers == null || tempmembers.size() <= 0) continue;
                        crcyleSize *= tempmembers.size();
                    }
                    Map<Object, Object> curDimMemProps = new LinkedHashMap();
                    if (this.isShowProperty && (curPropertyCount = dimensionentry.getDimension().getPropertyEntries().size()) > 0) {
                        List<String> memNumbers = current_members.stream().map(e -> e.getNumber()).collect(Collectors.toList());
                        curDimMemProps = DimPropertyHelper.queryMembersCustomProperties(memNumbers, templateModel.getModelId(), dimensionnumber);
                    }
                    HashMap<String, Integer> curDimPropIndexes = new HashMap<String, Integer>(16);
                    int curDimIndex = DimPropertyHelper.getDimAndPropPos(colHeaders, dimensionnumber, curDimPropIndexes);
                    Long viewId = DimensionViewServiceHelper.getViewId(this.getDimemsionViews(), (String)dimensionnumber, (String)("c" + partitionnumber));
                    while (crcyleSize > 0) {
                        for (Member current_member : current_members) {
                            String cdmKey;
                            CellDimMember cdm;
                            if (this.isNeedMergeCells()) {
                                ESpanInfo spanInfo = new ESpanInfo();
                                spanInfo.setColcount(span);
                                StyleCell cell = this.getStyleECell(dimRowStart + curDimIndex, tcol, current_member.getName(), current_member.getNumber(), spanInfo);
                                cell.setvAlign(VerticalAlignEnum.Center.getIndex());
                                cell.setUserObject("dimnumber", dimensionnumber);
                                cell.setUserObject("number", current_member.getNumber());
                                cell.setUserObject("name", current_member.getName());
                                if (StringUtils.isNotEmpty((String)current_member.getShowNumber())) {
                                    cell.setUserObject("shnum", current_member.getShowNumber());
                                }
                                if (StringUtils.isNotEmpty((String)current_member.getSimpleName())) {
                                    cell.setUserObject("simplename", current_member.getSimpleName());
                                }
                                cell.setUserObject("isLeaf", current_member.isLeaf());
                                cell.setUserObject("level", current_member.getLevel());
                                if (longDisplayDimNums != null && longDisplayDimNums.contains(dimensionnumber)) {
                                    cell.setUserObject("longnumber", current_member.getLongNumber());
                                    if (modelCacheHelper != null && StringUtils.isNotEmpty((String)current_member.getLongNumber())) {
                                        cell.setUserObject("longname", current_member.getLongName(modelCacheHelper.getParentsByOrder(viewId, current_member, false)));
                                    }
                                }
                                this.setCellValueByDefaultDisplayType(cell);
                                this.setCellValueByLongDisplayType(cell, longDisplayDimNums);
                            } else {
                                for (int iii = 0; iii < span; ++iii) {
                                    String memNumber = current_member.getNumber();
                                    StyleCell cell = this.getStyleECell(trow, tcol + iii, current_member.getName(), memNumber, null);
                                    cell.setvAlign(VerticalAlignEnum.Center.getIndex());
                                    cell.setUserObject("dimnumber", dimensionnumber);
                                    cell.setUserObject("number", memNumber);
                                    cell.setUserObject("name", current_member.getName());
                                    if (StringUtils.isNotEmpty((String)current_member.getShowNumber())) {
                                        cell.setUserObject("shnum", current_member.getShowNumber());
                                    }
                                    if (StringUtils.isNotEmpty((String)current_member.getSimpleName())) {
                                        cell.setUserObject("simplename", current_member.getSimpleName());
                                    }
                                    Integer memScope = (Integer)partitionMemberMap.get(memNumber);
                                    memScope = EbSpreadManager.transMemScope(scopeMap, memNumber, memScope);
                                    cell.setUserObject("isLeaf", current_member.isLeaf());
                                    cell.setUserObject("level", current_member.getLevel());
                                    if (memScope != null && !current_member.isLeaf()) {
                                        if (memScope.intValue() == RangeEnum.ONLY.getIndex()) {
                                            cell.setUserObject("isLeaf", Boolean.TRUE);
                                        } else {
                                            cell.setUserObject("scope", memScope);
                                        }
                                    }
                                    if (longDisplayDimNums != null && longDisplayDimNums.contains(dimensionnumber)) {
                                        cell.setUserObject("longnumber", current_member.getLongNumber());
                                        if (modelCacheHelper != null && StringUtils.isNotEmpty((String)current_member.getLongNumber())) {
                                            cell.setUserObject("longname", current_member.getLongName(modelCacheHelper.getParentsByOrder(viewId, current_member, false)));
                                        }
                                    }
                                    this.setCellValueByDefaultDisplayType(cell);
                                    this.setCellValueByLongDisplayType(cell, longDisplayDimNums);
                                }
                            }
                            for (int iii = 0; iii < span; ++iii) {
                                List<CellDimMember> dimmems = this.getColpartitionDimMems().get(tcol + iii);
                                if (dimmems == null) {
                                    dimmems = new ArrayList<CellDimMember>();
                                }
                                boolean isleaf = current_member.isLeaf();
                                if ("3".equals(current_member.getStorageType())) {
                                    isleaf = this.getModelCacheHelper().getMember(current_member.getDimension().getNumber(), this.getDimemsionViews().get(current_member.getDimension().getNumber()), current_member.getNumber()).isLeaf();
                                }
                                if ((cdm = (CellDimMember)cdmMap.get(cdmKey = dimensionnumber + "_" + current_member.getNumber() + "_" + partitionnumber)) == null) {
                                    cdm = new CellDimMember(isleaf, current_member.getNumber(), "c" + partitionnumber);
                                    cdm.setDisable(current_member.isDisable());
                                    cdmMap.put(cdmKey, cdm);
                                }
                                dimmems.add(cdm);
                                if (this.getColpartitionDims().size() < dimmems.size() && !this.getColpartitionDims().contains(dimensionnumber)) {
                                    this.getColpartitionDims().add(dimensionnumber);
                                }
                                this.getColpartitionDimMems().set(tcol + iii, dimmems);
                            }
                            if (this.isShowProperty && curPropertyCount > 0) {
                                List customProperties = (List)curDimMemProps.get(current_member.getNumber());
                                for (int pos = 0; pos < curPropertyCount; ++pos) {
                                    Integer index;
                                    String propertyTypeNum = dimensionentry.getDimension().getPropertyEntries().get(pos).getNumber();
                                    String propertyTypeName = dimensionentry.getDimension().getPropertyEntries().get(pos).getName();
                                    String propertyNum = "";
                                    String propertyName = "";
                                    if (customProperties != null) {
                                        for (PropertyObj propObj : customProperties) {
                                            if (!propObj.getNumber().equals(propertyTypeNum)) continue;
                                            propertyNum = ((PropertyMemObj)propObj.getPropertyValueEntries().get(0)).getNumber();
                                            propertyName = ((PropertyMemObj)propObj.getPropertyValueEntries().get(0)).getName();
                                            break;
                                        }
                                    }
                                    if ((index = (Integer)curDimPropIndexes.get(propertyTypeNum)) == null) continue;
                                    ECell propertyCell = this.getECell(dimRowStart + index, tcol, propertyName, propertyNum, new ESpanInfo(1, span));
                                    DimPropertyHelper.setPropertyCellUserObject(propertyCell, dimensionnumber, current_member.getNumber(), propertyTypeNum, propertyTypeName, propertyNum);
                                    this.setCellValueByDefaultDisplayType(propertyCell);
                                    this.setCellValueByLongDisplayType((StyleCell)propertyCell, longDisplayDimNums);
                                }
                            }
                            if (dimindex == dimensionentrys.size() - 1) {
                                int metric_col = tcol;
                                int metric_row = trow + 1;
                                if (this.isShowProperty) {
                                    metric_row += curPropertyCount;
                                }
                                for (IMetricDimMmeber metricDimMmeber : metricDimMmebers) {
                                    Member mb;
                                    if (TemplateVarCommonUtil.checkIsVar(metricDimMmeber.getNumber(), SysDimensionEnum.Metric.getNumber()).booleanValue()) {
                                        metricDimMmeber.setNumber(ReportVarUtil.getRealDimByVar(this.getModelobj().getId(), metricDimMmeber.getNumber(), SysDimensionEnum.Metric.getNumber(), varValus));
                                        Member mb2 = this.getModelCacheHelper().getMember(SysDimensionEnum.Metric.getNumber(), null, metricDimMmeber.getNumber());
                                        if (mb2 != null) {
                                            metricDimMmeber.setName(mb2.getName());
                                        }
                                    }
                                    String metricname = metricDimMmeber.getName();
                                    metricname = StringUtils.isNotEmpty((String)metricDimMmeber.getSign()) ? metricDimMmeber.getSign() : metricname;
                                    String metricnumber = metricDimMmeber.getNumber();
                                    ECell mcell = this.getECell(metric_row, metric_col, metricname, metricnumber, null);
                                    mcell.setUserObject("name", metricname);
                                    mcell.setUserObject("number", metricnumber);
                                    mcell.setUserObject("dimnumber", metricDimMmeber.getDimnumber());
                                    mcell.setUserObject("isLeaf", true);
                                    mcell.setUserObject("level", 1);
                                    if (StringUtils.isNotEmpty((String)metricDimMmeber.getUse())) {
                                        mcell.setUserObject("use", metricDimMmeber.getUse());
                                    }
                                    if (StringUtils.isEmpty((String)metricDimMmeber.getShowNumber()) && (mb = this.getModelCacheHelper().getMember(SysDimensionEnum.Metric.getNumber(), null, metricDimMmeber.getNumber())) != null && StringUtils.isNotEmpty((String)mb.getShowNumber())) {
                                        mcell.setUserObject("shnum", mb.getShowNumber());
                                    }
                                    this.setCellValueByDefaultDisplayType(mcell);
                                    List<CellDimMember> dimmems = this.getColpartitionDimMems().get(metric_col);
                                    if (dimmems == null) {
                                        dimmems = new ArrayList<CellDimMember>();
                                    }
                                    MetricCellDimMember cellDimMember = null;
                                    cdmKey = "Metric_" + metricnumber + "_" + partitionnumber;
                                    cdm = (CellDimMember)cdmMap.get(cdmKey);
                                    if (cdm instanceof MetricCellDimMember) {
                                        cellDimMember = (MetricCellDimMember)cdm;
                                    } else {
                                        Member member;
                                        cellDimMember = new MetricCellDimMember(true, metricnumber);
                                        cellDimMember.setDecimalnum(metricDimMmeber.getDecimalnum());
                                        cellDimMember.setSign(metricDimMmeber.getSign());
                                        cellDimMember.setMetric(true);
                                        cellDimMember.setDatatype(this.getMetricDatatypeMap().get(metricnumber));
                                        if (StringUtils.isNotEmpty((String)metricDimMmeber.getUse())) {
                                            cellDimMember.setUse(metricDimMmeber.getUse());
                                        }
                                        if ((member = this.getModelCacheHelper().getMember(SysDimensionEnum.Metric.getNumber(), null, metricDimMmeber.getNumber())) != null) {
                                            cellDimMember.setDisable(member.isDisable());
                                        }
                                        cellDimMember.setPartition("c" + partitionnumber);
                                        cdmMap.put(cdmKey, cellDimMember);
                                    }
                                    dimmems.add(cellDimMember);
                                    if (this.getColpartitionDims().size() < dimmems.size() && !this.getColpartitionDims().contains(metricDimMmeber.getDimnumber())) {
                                        this.getColpartitionDims().add(metricDimMmeber.getDimnumber());
                                    }
                                    this.getColpartitionDimMems().set(metric_col, dimmems);
                                    ++metric_col;
                                }
                            }
                            tcol += span;
                        }
                        --crcyleSize;
                    }
                }
                if (dimindex == dimensionentrys.size() - 1) {
                    col = tcol;
                }
                ++trow;
                if (!this.isShowProperty) continue;
                trow += curPropertyCount;
            }
        }
    }

    public static Integer transMemScope(Map<String, Set<Integer>> scopeMap, String memNumber, Integer memScope) {
        if (memScope == null || RangeEnum.ONLY.getIndex() != memScope.intValue()) {
            Set<Integer> integers;
            Set<Integer> set = integers = scopeMap == null ? null : scopeMap.get(memNumber);
            if (integers == null) {
                integers = new HashSet<Integer>(16);
            }
            memScope = integers.contains(RangeEnum.ALL.getIndex()) || integers.contains(RangeEnum.ALL_EXCLUDE.getIndex()) ? Integer.valueOf(RangeEnum.ALL.getIndex()) : (integers.contains(RangeEnum.ALL_DETAIL.getIndex()) && integers.contains(RangeEnum.ALL_NOTDETAIL.getIndex()) ? Integer.valueOf(RangeEnum.ALL.getIndex()) : (integers.contains(RangeEnum.ALL_DETAIL.getIndex()) ? Integer.valueOf(RangeEnum.ALL_DETAIL.getIndex()) : (integers.contains(RangeEnum.ALL_NOTDETAIL.getIndex()) ? Integer.valueOf(RangeEnum.ALL_NOTDETAIL.getIndex()) : (integers.contains(RangeEnum.DIRECTSUB.getIndex()) ? Integer.valueOf(RangeEnum.DIRECTSUB.getIndex()) : Integer.valueOf(RangeEnum.ONLY.getIndex())))));
        }
        return memScope;
    }

    private void setCellValueByDefaultDisplayType(ECell cell) {
        Object simpleName;
        if (MemberDisplayTypeEnum.NAME.getIndex() == this.dimMemDefaultDisplayType) {
            return;
        }
        Object memName = cell.getValue();
        if (memName == null) {
            return;
        }
        String memNum = (String)cell.getUserObject("shnum");
        if (StringUtils.isEmpty((String)memNum)) {
            memNum = (String)cell.getUserObject("number");
        }
        if ((simpleName = cell.getUserObject("simplename")) == null || StringUtils.isEmpty((String)simpleName.toString())) {
            simpleName = memName;
        }
        if (DimPropertyHelper.checkPropertyCell(cell)) {
            memNum = cell.getUserObject("typenum") + "#" + cell.getUserObject("properytnum");
        }
        if (MemberDisplayTypeEnum.NAME.getIndex() == this.dimMemDefaultDisplayType || MemberDisplayTypeEnum.LONGNAME.getIndex() == this.dimMemDefaultDisplayType) {
            cell.setValue(memName);
        } else if (MemberDisplayTypeEnum.SIMPLENAME.getIndex() == this.dimMemDefaultDisplayType) {
            cell.setValue(simpleName);
        } else if (MemberDisplayTypeEnum.NUMBER.getIndex() == this.dimMemDefaultDisplayType || MemberDisplayTypeEnum.LONGNUMBER.getIndex() == this.dimMemDefaultDisplayType) {
            cell.setValue(memNum);
        } else if (MemberDisplayTypeEnum.NAMEANDNUMBER.getIndex() == this.dimMemDefaultDisplayType || MemberDisplayTypeEnum.LONGNAMENUMBER.getIndex() == this.dimMemDefaultDisplayType) {
            cell.setValue(memName + ":" + memNum);
        } else if (MemberDisplayTypeEnum.SIMNAMENUMBER.getIndex() == this.dimMemDefaultDisplayType) {
            cell.setValue(simpleName + ":" + memNum);
        }
    }

    private void buildReportRowPartition(ITemplateModel templateModel, Map<String, Set<Member>> allDimension_Members, Map<String, Map<String, String>> varValus, Map<String, Map<String, Set<Integer>>> memberScope) {
        IPartitionSetting partitionSetting = templateModel.getPartitionSetting();
        List<RowColPartition> rowpartitions = partitionSetting.getRowPartition();
        List<RowColPartition> colpartitions = partitionSetting.getColPartition();
        List<IHeaderInfo> rowHeaders = templateModel.getAreaRangeEntry().getRowHeaders();
        List<IHeaderInfo> colHeaders = templateModel.getAreaRangeEntry().getColHeaders();
        int[] xy_start = ExcelUtils.pos2XY((String)partitionSetting.getPartitionInfo().getStartposition());
        int dimRowStart = xy_start[1];
        int dimColStart = xy_start[0];
        int valueRowStart = dimRowStart + colHeaders.size();
        int valueColStart = dimColStart + rowHeaders.size();
        if (colpartitions.get(0).getMetricDimMmebers().size() > 0) {
            this.metricRowIndex = valueRowStart;
            valueRowStart = this.metricRowIndex + 1;
        }
        ISheet sheet = this.getSheet();
        sheet.setDimRowStart(dimRowStart);
        sheet.setValueAreaRowStart(valueRowStart);
        int row = valueRowStart;
        int col = dimColStart;
        IModelCacheHelper modelCacheHelper = this.getModelCacheHelper();
        HashMap<String, CellDimMember> cdmMap = new HashMap<String, CellDimMember>(16);
        List<String> longDisplayDimNums = ReportHelper.getLongDisplayDimNums(MemberDisplayTypeEnum.LONGNUMBER.getIndex(), this.getModelCacheHelper());
        for (int partitionnumber = 0; partitionnumber < rowpartitions.size(); ++partitionnumber) {
            RowColPartition rowpartition = rowpartitions.get(partitionnumber);
            List<IMetricDimMmeber> metricDimMmebers = rowpartition.getMetricDimMmebers();
            int metricspan = 1;
            if (metricDimMmebers.size() > 0) {
                metricspan = metricDimMmebers.size();
            }
            List<IRowColDimensionEntry> dimensionentrys = rowpartition.getRowColDimensionEntries();
            int tcol = col;
            for (int dimindex = 0; dimindex < dimensionentrys.size(); ++dimindex) {
                String dimensionnumber;
                int trow = row;
                int span = metricspan;
                int curPropertyCount = 0;
                for (int temp_dimindex = dimindex + 1; temp_dimindex < dimensionentrys.size(); ++temp_dimindex) {
                    dimensionnumber = dimensionentrys.get(temp_dimindex).getDimension().getNumber();
                    String map_key = dimensionnumber + "_" + partitionnumber;
                    Set<Member> tempmembers = allDimension_Members.get(map_key);
                    if (tempmembers == null || tempmembers.size() <= 0) continue;
                    span *= tempmembers.size();
                }
                if (span > 1) {
                    this.isRowSpan = true;
                }
                IRowColDimensionEntry dimensionentry = dimensionentrys.get(dimindex);
                dimensionnumber = dimensionentry.getDimension().getNumber();
                String current_mapkey = dimensionnumber + "_" + partitionnumber;
                Map<String, Set<Integer>> scopeMap = memberScope.get(current_mapkey);
                Set<Member> current_members = allDimension_Members.get(current_mapkey);
                if (current_members == null) {
                    current_members = new LinkedHashSet<Member>();
                }
                int crcyleSize = 1;
                for (int temp_dimindex = dimindex - 1; temp_dimindex >= 0; --temp_dimindex) {
                    String updimensionnumber = dimensionentrys.get(temp_dimindex).getDimension().getNumber();
                    String map_key = updimensionnumber + "_" + partitionnumber;
                    Set<Member> tempmembers = allDimension_Members.get(map_key);
                    if (tempmembers == null || tempmembers.size() <= 0) continue;
                    crcyleSize *= tempmembers.size();
                }
                Map<Object, Object> curDimMemProps = new LinkedHashMap();
                if (this.isShowProperty && (curPropertyCount = dimensionentry.getDimension().getPropertyEntries().size()) > 0) {
                    List<String> memNumbers = current_members.stream().map(e -> e.getNumber()).collect(Collectors.toList());
                    curDimMemProps = DimPropertyHelper.queryMembersCustomProperties(memNumbers, templateModel.getModelId(), dimensionnumber);
                }
                List<IDimensionMember> members = dimensionentry.getMembers();
                HashMap<String, Integer> partitionMemberMap = new HashMap<String, Integer>(members.size());
                for (IDimensionMember member : members) {
                    partitionMemberMap.put(member.getNumber(), member.getScope());
                }
                HashMap<String, Integer> curDimPropIndexes = new HashMap<String, Integer>(16);
                int curDimIndex = DimPropertyHelper.getDimAndPropPos(rowHeaders, dimensionnumber, curDimPropIndexes);
                Long viewId = DimensionViewServiceHelper.getViewId(this.getDimemsionViews(), (String)dimensionnumber, (String)("r" + partitionnumber));
                while (crcyleSize > 0) {
                    for (Member current_member : current_members) {
                        String cdmKey;
                        CellDimMember cdm;
                        if (this.isNeedMergeCells()) {
                            ESpanInfo spanInfo = new ESpanInfo();
                            spanInfo.setRowcount(span);
                            ECell cell = this.getECell(trow, dimColStart + curDimIndex, current_member.getName(), current_member.getNumber(), spanInfo);
                            cell.setUserObject("dimnumber", dimensionnumber);
                            cell.setUserObject("number", current_member.getNumber());
                            cell.setUserObject("name", current_member.getName());
                            if (StringUtils.isNotEmpty((String)current_member.getShowNumber())) {
                                cell.setUserObject("shnum", current_member.getShowNumber());
                            }
                            if (StringUtils.isNotEmpty((String)current_member.getSimpleName())) {
                                cell.setUserObject("simplename", current_member.getSimpleName());
                            }
                            cell.setUserObject("isLeaf", current_member.isLeaf());
                            cell.setUserObject("level", current_member.getLevel());
                            if (longDisplayDimNums != null && longDisplayDimNums.contains(dimensionnumber)) {
                                cell.setUserObject("longnumber", current_member.getLongNumber());
                                if (modelCacheHelper != null && StringUtils.isNotEmpty((String)current_member.getLongNumber())) {
                                    cell.setUserObject("longname", current_member.getLongName(modelCacheHelper.getParentsByOrder(viewId, current_member, false)));
                                }
                            }
                            this.setCellValueByDefaultDisplayType(cell);
                            this.setCellValueByLongDisplayType((StyleCell)cell, longDisplayDimNums);
                            if (this.isNeedHandleIndents() && !this.isRowSpan()) {
                                this.putIntoIndentCells(current_member, cell);
                            }
                        } else {
                            for (int iii = 0; iii < span; ++iii) {
                                String memNumber = current_member.getNumber();
                                ECell cell = this.getECell(trow + iii, tcol, current_member.getName(), memNumber, null);
                                cell.setUserObject("dimnumber", dimensionnumber);
                                cell.setUserObject("number", memNumber);
                                cell.setUserObject("name", current_member.getName());
                                if (StringUtils.isNotEmpty((String)current_member.getShowNumber())) {
                                    cell.setUserObject("shnum", current_member.getShowNumber());
                                }
                                if (StringUtils.isNotEmpty((String)current_member.getSimpleName())) {
                                    cell.setUserObject("simplename", current_member.getSimpleName());
                                }
                                cell.setUserObject("isLeaf", current_member.isLeaf());
                                cell.setUserObject("level", current_member.getLevel());
                                Integer memScope = (Integer)partitionMemberMap.get(memNumber);
                                memScope = EbSpreadManager.transMemScope(scopeMap, memNumber, memScope);
                                if (memScope != null && !current_member.isLeaf()) {
                                    if (memScope.intValue() == RangeEnum.ONLY.getIndex()) {
                                        cell.setUserObject("isLeaf", Boolean.TRUE);
                                    } else {
                                        cell.setUserObject("scope", memScope);
                                    }
                                }
                                if (longDisplayDimNums != null && longDisplayDimNums.contains(dimensionnumber)) {
                                    cell.setUserObject("longnumber", current_member.getLongNumber());
                                    if (modelCacheHelper != null && StringUtils.isNotEmpty((String)current_member.getLongNumber())) {
                                        cell.setUserObject("longname", current_member.getLongName(modelCacheHelper.getParentsByOrder(viewId, current_member, false)));
                                    }
                                }
                                this.setCellValueByDefaultDisplayType(cell);
                                this.setCellValueByLongDisplayType((StyleCell)cell, longDisplayDimNums);
                                if (!this.isNeedHandleIndents() || this.isRowSpan()) continue;
                                this.putIntoIndentCells(current_member, cell);
                            }
                        }
                        for (int iii = 0; iii < span; ++iii) {
                            List<CellDimMember> dimmems = this.getRowpartitionDimMems().get(trow + iii);
                            if (dimmems == null) {
                                dimmems = new ArrayList<CellDimMember>();
                            }
                            boolean isleaf = current_member.isLeaf();
                            if ("3".equals(current_member.getStorageType())) {
                                isleaf = this.getModelCacheHelper().getMember(current_member.getDimension().getNumber(), this.getDimemsionViews().get(current_member.getDimension().getNumber()), current_member.getNumber()).isLeaf();
                            }
                            if ((cdm = (CellDimMember)cdmMap.get(cdmKey = dimensionnumber + "_" + current_member.getNumber() + "_" + partitionnumber)) == null) {
                                cdm = new CellDimMember(isleaf, current_member.getNumber(), "r" + partitionnumber);
                                cdm.setDisable(current_member.isDisable());
                                cdmMap.put(cdmKey, cdm);
                            }
                            dimmems.add(cdm);
                            if (this.getRowpartitionDims().size() < dimmems.size() && !this.getRowpartitionDims().contains(dimensionnumber)) {
                                this.getRowpartitionDims().add(dimensionnumber);
                            }
                            this.getRowpartitionDimMems().set(trow + iii, dimmems);
                        }
                        if (this.isShowProperty && curPropertyCount > 0) {
                            List customProperties = (List)curDimMemProps.get(current_member.getNumber());
                            for (int pos = 0; pos < curPropertyCount; ++pos) {
                                Integer index;
                                String propertyTypeNum = dimensionentry.getDimension().getPropertyEntries().get(pos).getNumber();
                                String propertyTypeName = dimensionentry.getDimension().getPropertyEntries().get(pos).getName();
                                String propertyNum = "";
                                String propertyName = "";
                                if (customProperties != null) {
                                    for (PropertyObj propObj : customProperties) {
                                        if (!propObj.getNumber().equals(propertyTypeNum)) continue;
                                        propertyNum = ((PropertyMemObj)propObj.getPropertyValueEntries().get(0)).getNumber();
                                        propertyName = ((PropertyMemObj)propObj.getPropertyValueEntries().get(0)).getName();
                                        break;
                                    }
                                }
                                if ((index = (Integer)curDimPropIndexes.get(propertyTypeNum)) == null) continue;
                                ECell propertyCell = this.getECell(trow, dimColStart + index, propertyName, propertyNum, new ESpanInfo(span, 1));
                                DimPropertyHelper.setPropertyCellUserObject(propertyCell, dimensionnumber, current_member.getNumber(), propertyTypeNum, propertyTypeName, propertyNum);
                                this.setCellValueByDefaultDisplayType(propertyCell);
                                this.setCellValueByLongDisplayType((StyleCell)propertyCell, longDisplayDimNums);
                            }
                        }
                        if (dimindex == dimensionentrys.size() - 1) {
                            int metric_row = trow;
                            int metric_col = tcol + 1;
                            if (this.isShowProperty) {
                                metric_col += curPropertyCount;
                            }
                            for (IMetricDimMmeber metricDimMmeber : metricDimMmebers) {
                                Member mb;
                                if (TemplateVarCommonUtil.checkIsVar(metricDimMmeber.getNumber(), SysDimensionEnum.Metric.getNumber()).booleanValue()) {
                                    metricDimMmeber.setNumber(ReportVarUtil.getRealDimByVar(this.getModelobj().getId(), metricDimMmeber.getNumber(), SysDimensionEnum.Metric.getNumber(), varValus));
                                    Member mb2 = this.getModelCacheHelper().getMember(SysDimensionEnum.Metric.getNumber(), null, metricDimMmeber.getNumber());
                                    if (mb2 != null) {
                                        metricDimMmeber.setName(mb2.getName());
                                    }
                                }
                                String metricname = metricDimMmeber.getName();
                                metricname = StringUtils.isNotEmpty((String)metricDimMmeber.getSign()) ? metricDimMmeber.getSign() : metricname;
                                String metricnumber = metricDimMmeber.getNumber();
                                ECell mcell = this.getECell(metric_row, metric_col, metricname, metricnumber, null);
                                mcell.setUserObject("number", metricnumber);
                                mcell.setUserObject("dimnumber", metricDimMmeber.getDimnumber());
                                mcell.setUserObject("name", metricname);
                                mcell.setUserObject("isLeaf", true);
                                mcell.setUserObject("level", 1);
                                if (StringUtils.isNotEmpty((String)metricDimMmeber.getUse())) {
                                    mcell.setUserObject("use", metricDimMmeber.getUse());
                                }
                                if (StringUtils.isEmpty((String)metricDimMmeber.getShowNumber()) && (mb = this.getModelCacheHelper().getMember(SysDimensionEnum.Metric.getNumber(), null, metricDimMmeber.getNumber())) != null && StringUtils.isNotEmpty((String)mb.getShowNumber())) {
                                    mcell.setUserObject("shnum", mb.getShowNumber());
                                }
                                this.setCellValueByDefaultDisplayType(mcell);
                                List<CellDimMember> dimmems = this.getRowpartitionDimMems().get(metric_row);
                                if (dimmems == null) {
                                    dimmems = new ArrayList<CellDimMember>();
                                }
                                MetricCellDimMember cellDimMember = null;
                                cdmKey = "Metric_" + metricnumber + "_" + partitionnumber;
                                cdm = (CellDimMember)cdmMap.get(cdmKey);
                                if (cdm instanceof MetricCellDimMember) {
                                    cellDimMember = (MetricCellDimMember)cdm;
                                } else {
                                    Member member;
                                    cellDimMember = new MetricCellDimMember(true, metricnumber);
                                    cellDimMember.setDecimalnum(metricDimMmeber.getDecimalnum());
                                    cellDimMember.setSign(metricDimMmeber.getSign());
                                    cellDimMember.setMetric(true);
                                    cellDimMember.setDatatype(this.getMetricDatatypeMap().get(metricnumber));
                                    if (StringUtils.isNotEmpty((String)metricDimMmeber.getUse())) {
                                        cellDimMember.setUse(metricDimMmeber.getUse());
                                    }
                                    if ((member = this.getModelCacheHelper().getMember(SysDimensionEnum.Metric.getNumber(), null, metricDimMmeber.getNumber())) != null) {
                                        cellDimMember.setDisable(member.isDisable());
                                    }
                                    cellDimMember.setPartition("r" + partitionnumber);
                                    cdmMap.put(cdmKey, cellDimMember);
                                }
                                dimmems.add(cellDimMember);
                                if (this.getRowpartitionDims().size() < dimmems.size() && !this.getRowpartitionDims().contains(metricDimMmeber.getDimnumber())) {
                                    this.getRowpartitionDims().add(metricDimMmeber.getDimnumber());
                                }
                                this.getRowpartitionDimMems().set(metric_row, dimmems);
                                ++metric_row;
                            }
                        }
                        trow += span;
                    }
                    --crcyleSize;
                }
                ++tcol;
                if (this.isShowProperty) {
                    tcol += curPropertyCount;
                }
                if (dimindex != dimensionentrys.size() - 1) continue;
                row = trow;
            }
        }
    }

    private Map<Long, List<PropertyValueEntry>> getMemPropertyMap(List<IDimensionMember> dimensionMembers) {
        if (dimensionMembers == null) {
            return new LinkedHashMap<Long, List<PropertyValueEntry>>(0);
        }
        LinkedHashMap<Long, List<PropertyValueEntry>> result = new LinkedHashMap<Long, List<PropertyValueEntry>>(dimensionMembers.size());
        for (IDimensionMember mem : dimensionMembers) {
            result.put(mem.getId(), mem.getPropertyValueEntries());
        }
        return result;
    }

    private void putIntoIndentCells(Member current_member, ECell cell) {
        LevelMember levelMember;
        int ti_size;
        if (current_member instanceof LevelMember && (ti_size = (levelMember = (LevelMember)current_member).getReal_level()) > 0) {
            List<ECell> thesame_ti;
            if (this.indentcells == null) {
                this.indentcells = new HashMap<Integer, List<ECell>>();
            }
            if ((thesame_ti = this.indentcells.get(ti_size)) == null) {
                thesame_ti = new ArrayList<ECell>();
                this.indentcells.put(ti_size, thesame_ti);
            }
            thesame_ti.add(cell);
            this.indentParents.putIfAbsent(cell.getRow() - 1, Boolean.FALSE);
        }
    }

    public void mergeCells() {
        this.mergeColCells();
        this.mergeRowCells();
    }

    private void mergeColCells() {
        ISheet sheet = this.getEbook().getSheet(0);
        int valuestart_row = sheet.getValueAreaRowStart();
        int dimensionRows = this.getColpartitionDims().size();
        int rowindex = 0;
        while (dimensionRows > 1) {
            int currentrow = valuestart_row - dimensionRows;
            List<ECell> rowcells = sheet.getRow(currentrow);
            ECell before = null;
            for (ECell rowcell : rowcells) {
                String beforevalue;
                if (rowcell == null || rowcell.getValue() == null) continue;
                if (before == null) {
                    before = rowcell;
                    continue;
                }
                String curentvalue = rowcell.getUserObject("number", "");
                if (curentvalue.equals(beforevalue = before.getUserObject("number", ""))) {
                    boolean thesameParent = true;
                    CellDimMember beforecellparent = this.getColpartitionDimMems().get(before.getCol()).get(rowindex - 1);
                    CellDimMember currentcellparent = this.getColpartitionDimMems().get(rowcell.getCol()).get(rowindex - 1);
                    if (!beforecellparent.getDimMemberNumber().equals(currentcellparent.getDimMemberNumber())) {
                        thesameParent = false;
                    }
                    if (thesameParent) {
                        ESpanInfo spanInfo = new ESpanInfo();
                        spanInfo.setColcount(before.getSpanInfo().getColcount() + rowcell.getSpanInfo().getColcount());
                        before.setSpanInfo(spanInfo);
                        rowcell.setValue(null);
                        rowcell.setSpanInfo(null);
                        continue;
                    }
                    before = rowcell;
                    continue;
                }
                before = rowcell;
            }
            --dimensionRows;
            ++rowindex;
        }
    }

    private void mergeRowCells() {
        ISheet sheet = this.getEbook().getSheet(0);
        int valuestart_row = sheet.getValueAreaRowStart();
        int valuestart_col = sheet.getValueAreaColStart();
        int dimensionCols = this.getRowpartitionDims().size();
        int colindex = 0;
        int rowmax = sheet.getRealMaxRows();
        while (dimensionCols > 1) {
            int currentcol = valuestart_col - dimensionCols;
            ECell before = null;
            for (int current_row = valuestart_row; current_row < rowmax; ++current_row) {
                String beforevalue;
                ECell rowcell = sheet.getECell(current_row, currentcol);
                if (rowcell == null || rowcell.getValue() == null) continue;
                if (before == null) {
                    before = rowcell;
                    continue;
                }
                String curentvalue = rowcell.getUserObject("number", "");
                if (curentvalue.equals(beforevalue = before.getUserObject("number", ""))) {
                    boolean thesameParent = true;
                    CellDimMember beforecellparent = this.getRowpartitionDimMems().get(before.getRow()).get(colindex - 1);
                    CellDimMember currentcellparent = this.getRowpartitionDimMems().get(rowcell.getRow()).get(colindex - 1);
                    if (!beforecellparent.getDimMemberNumber().equals(currentcellparent.getDimMemberNumber())) {
                        thesameParent = false;
                    }
                    if (thesameParent) {
                        ESpanInfo spanInfo = new ESpanInfo();
                        spanInfo.setRowcount(before.getSpanInfo().getRowcount() + rowcell.getSpanInfo().getRowcount());
                        before.setSpanInfo(spanInfo);
                        rowcell.setValue(null);
                        rowcell.setSpanInfo(null);
                        continue;
                    }
                    before = rowcell;
                    continue;
                }
                before = rowcell;
            }
            --dimensionCols;
            ++colindex;
        }
    }

    @Override
    public Map<String, Set<Member>> resolvePageMemberScope(ITemplateModel templateModel) {
        HashMap<String, Set<Member>> pagedim_boundary = new HashMap<String, Set<Member>>(templateModel.getPagemembentry().size());
        Map<String, Map<String, String>> varValus = null;
        boolean isReport = TemplateVarUtil.isReport(templateModel);
        boolean isVarTemplate = TemplateVarUtil.isVarTemplate(templateModel);
        if (isReport && this.getProcessId() != null && isVarTemplate) {
            if (ProcessTypeEnum.REPORT.getNumber().equals(this.getProcessType())) {
                varValus = ReportVarUtil.getVarValues(this.getProcessType(), this.modelobj.getId(), this.processId, templateModel.getTemplateBaseInfo().getVarBase());
            } else if (ProcessTypeEnum.TASK.getNumber().equals(this.getProcessType())) {
                String formID = "eb_taskprocess";
                boolean exists = QueryServiceHelper.exists((String)formID, (Object)this.processId);
                varValus = exists ? ReportVarUtil.getVarValues(this.getProcessType(), this.modelobj.getId(), this.processId, templateModel.getTemplateBaseInfo().getVarBase()) : ReportVarUtil.getVarValueByTaskList(this.modelobj.getId(), this.processId, templateModel.getTemplateBaseInfo().getId());
            }
        }
        Map<String, Map<String, String>> varNumberNameMap = null;
        if (isReport && IDUtils.isNull((Long)this.getProcessId())) {
            varNumberNameMap = TemplateVarCommonUtil.getVarIDNumberMap("isNeedVar", templateModel.getModelId());
        }
        for (IPageDimensionEntry pageDimensionEntry : templateModel.getPagemembentry()) {
            LinkedHashSet<Member> membersets;
            String dimnumber = pageDimensionEntry.getDimension().getNumber();
            Long viewId = this.getDimemsionViews().get(dimnumber);
            if (IDUtils.isNull((Long)viewId)) {
                viewId = 0L;
            }
            if ((membersets = (LinkedHashSet<Member>)pagedim_boundary.get(dimnumber)) == null) {
                membersets = new LinkedHashSet<Member>();
            }
            List<IDimensionMember> dimensionMembers = pageDimensionEntry.getMembers();
            DynamicObjectCollection varList = null;
            if (SysDimensionEnum.Entity.getNumber().equals(dimnumber)) {
                Set collect = dimensionMembers.stream().map(x -> x.getNumber()).collect(Collectors.toSet());
                List members = this.getModelCacheHelper().getMembers(dimnumber, this.getDimemsionViews().get(dimnumber), collect);
                if (members != null && !members.isEmpty()) {
                    for (Object member : members) {
                        if (this.isNeedCheckPerm() && this.getMemberPerm().isNoperm(dimnumber, member.getNumber(), this.getDimemsionViews().get(dimnumber))) continue;
                        membersets.add((Member)member);
                    }
                }
            } else {
                for (IDimensionMember dimensionMember : dimensionMembers) {
                    List members;
                    Object member;
                    boolean isVar = TemplateVarUtil.checkIsVar(dimensionMember, dimnumber);
                    if (isVar) {
                        if (isReport && IDUtils.isNotNull((Long)this.getProcessId())) {
                            dimensionMember.setNumber(ReportVarUtil.getRealDimByVar(templateModel.getModelId(), dimensionMember.getNumber(), dimnumber, varValus));
                        }
                        if (!isReport) {
                            varList = TemplateVarUtil.addVar2DimLst(templateModel.getModelId(), pageDimensionEntry.getDimension(), dimensionMember, membersets, null, varList);
                            continue;
                        }
                    }
                    if ((members = this.getModelCacheHelper().getMember(dimnumber, viewId, dimensionMember.getNumber(), dimensionMember.getScope())) != null && !members.isEmpty()) {
                        member = members.iterator();
                        while (member.hasNext()) {
                            Member member2 = (Member)member.next();
                            if (this.isNeedCheckPerm() && this.getMemberPerm().isNoperm(dimnumber, member2.getNumber(), viewId)) continue;
                            membersets.add(member2);
                        }
                    }
                    if (!isReport || !IDUtils.isNull((Long)this.getProcessId()) || !isVar || (member = TemplateVarUtil.getNewVarMember(templateModel.getModelId(), dimensionMember.getNumber(), dimnumber, varNumberNameMap, this.getModelCacheHelper())) == null) continue;
                    membersets.add((Member)member);
                }
            }
            pagedim_boundary.put(dimnumber, membersets);
        }
        if (this.approveBillDimMembers != null) {
            HashMap replaceMap = new HashMap();
            for (Map.Entry pagedim : pagedim_boundary.entrySet()) {
                if (!this.approveBillDimMembers.containsKey(pagedim.getKey())) continue;
                List<Long> billMemberIdList = this.approveBillDimMembers.get(pagedim.getKey());
                Set members = (Set)pagedim.getValue();
                Set<Member> commonPart = this.getCommonPart(members, billMemberIdList);
                replaceMap.put(pagedim.getKey(), commonPart);
            }
            pagedim_boundary.putAll(replaceMap);
        }
        return pagedim_boundary;
    }

    public Map<String, Set<Member>> resolveMemberScope(ITemplateModel templateModel, Map<String, Map<String, String>> varValus, Map<String, Map<String, String>> varNumberNameMap, Map<String, Map<String, Set<Integer>>> memberScope) {
        Long viewId;
        String dimNumber;
        IPartitionSetting partitionSetting = templateModel.getPartitionSetting();
        Long dataset = templateModel.getTemplateBaseInfo().getDatasetID();
        List<RowColPartition> colPartitions = partitionSetting.getColPartition();
        List<RowColPartition> rowPartitions = partitionSetting.getRowPartition();
        Long modelId = templateModel.getModelId();
        HashMap<String, Set<Member>> allDimension_Members = new HashMap<String, Set<Member>>();
        HashSet<String> noPermColPartIndex = new HashSet<String>(16);
        HashSet<String> noPermRowPartIndex = new HashSet<String>(16);
        int colindex = 0;
        MemberPropCache memberPropCache = MemberPropCacheService.getOrCreate((Long)modelId);
        boolean isReport = TemplateVarUtil.isReport(templateModel);
        for (RowColPartition colPartition : colPartitions) {
            for (IRowColDimensionEntry rowColDimensionEntry : colPartition.getRowColDimensionEntries()) {
                dimNumber = rowColDimensionEntry.getDimension().getNumber();
                Set<String> membernums = this.alldimensionWithMembers.get(dimNumber);
                if (membernums == null) {
                    membernums = new LinkedHashSet<String>();
                }
                String mapkey = dimNumber + "_" + colindex;
                LinkedHashSet<Member> OneDimension_members = new LinkedHashSet<Member>();
                DynamicObjectCollection varList = null;
                for (IDimensionMember member : rowColDimensionEntry.getMembers()) {
                    Member member1;
                    boolean isVar = TemplateVarUtil.checkIsVar(member, dimNumber);
                    if (isVar) {
                        if (isReport && this.getProcessId() != null) {
                            member.setNumber(ReportVarUtil.getRealDimByVar(templateModel.getModelId(), member.getNumber(), dimNumber, varValus));
                        }
                        if (!isReport) {
                            varList = TemplateVarUtil.addVar2DimLst(modelId, rowColDimensionEntry.getDimension(), member, OneDimension_members, membernums, varList);
                            continue;
                        }
                    }
                    String type = RangeF7PropertyCataEnum.Member.getIndex();
                    if (member instanceof DefaultDimMember) {
                        type = ((DefaultDimMember)member).getType();
                    }
                    List members = null;
                    viewId = DimensionViewServiceHelper.getViewId(this.getDimemsionViews(), (String)dimNumber, (String)("c" + colindex));
                    if ((SysDimensionEnum.Entity.getNumber().equals(dimNumber) || !SysDimensionEnum.include((String)dimNumber, (Boolean)false)) && RangeF7PropertyCataEnum.Property.getIndex().equals(type)) {
                        CustomProperty property;
                        members = memberPropCache.getMembersByPropValues(this.modelCacheHelper.getDimension(SysDimensionEnum.Entity.getNumber()).getId(), viewId, member.getId());
                        if (CollectionUtils.isEmpty((Collection)members) && (property = memberPropCache.getProperty(member.getId())) != null) {
                            CustomPropertyValue propertyValue = memberPropCache.getPropertyValue(dimNumber, property.getNumber(), member.getNumber());
                            members = memberPropCache.getMembersByPropValues(this.modelCacheHelper.getDimension(dimNumber).getId(), DimensionViewServiceHelper.getViewId(this.getDimemsionViews(), (String)dimNumber, (String)("c" + colindex)), propertyValue.getId());
                        }
                        if (CollectionUtils.isNotEmpty((Collection)members) && !this.isNeedMergeCells()) {
                            Map<Object, Object> memberScopeMap = new HashMap(16);
                            if (memberScope.containsKey(mapkey)) {
                                memberScopeMap = memberScope.get(mapkey);
                            } else {
                                memberScope.put(mapkey, memberScopeMap);
                            }
                            for (Member member12 : members) {
                                Set integers = memberScopeMap.computeIfAbsent(member12.getNumber(), k -> new HashSet(2));
                                integers.add(RangeEnum.ONLY.getIndex());
                            }
                        }
                    } else {
                        String memNumber = member.getNumber();
                        int memScope = member.getScope();
                        if (this.isNeedMergeCells()) {
                            members = this.getModelCacheHelper().getMemberSort(dimNumber, viewId, memNumber, memScope);
                        } else {
                            HashMap<String, Set<Integer>> memberScopeMap = new HashMap(16);
                            if (memberScope.containsKey(mapkey)) {
                                memberScopeMap = memberScope.get(mapkey);
                            } else {
                                memberScope.put(mapkey, memberScopeMap);
                            }
                            members = EbSpreadManager.getMembers(this.getModelCacheHelper(), dimNumber, viewId, memNumber, memScope, memberScopeMap);
                        }
                    }
                    if (members != null) {
                        if (SysDimensionEnum.Account.getNumber().equals(dimNumber)) {
                            members.removeIf(m -> m.getDatasetId() != null && m.getDatasetId().longValue() != dataset.longValue());
                        }
                        for (Member member13 : members) {
                            if (this.isNeedCheckPerm() && this.getMemberPerm().isNoperm(dimNumber, member13.getNumber(), viewId)) continue;
                            OneDimension_members.add(member13);
                            membernums.add(member13.getNumber());
                        }
                    }
                    if (!isReport || this.getProcessId() != null || !isVar || (member1 = TemplateVarUtil.getNewVarMember(modelId, member.getNumber(), dimNumber, varNumberNameMap, this.getModelCacheHelper())) == null) continue;
                    OneDimension_members.add(member1);
                    membernums.add(member1.getNumber());
                }
                if (OneDimension_members != null && OneDimension_members.size() > 0) {
                    allDimension_Members.put(mapkey, OneDimension_members);
                } else {
                    noPermColPartIndex.add(String.valueOf(colindex));
                }
                this.alldimensionWithMembers.put(dimNumber, membernums);
            }
            if (Boolean.FALSE.equals(templateModel.getAreaRangeEntry().isMetricInRow())) {
                boolean hasMetricPerm = false;
                Iterator<IMetricDimMmeber> it = colPartition.getMetricDimMmebers().iterator();
                while (it.hasNext()) {
                    Set<String> membernums;
                    IMetricDimMmeber metricDimMmeber = it.next();
                    if (this.isNeedCheckPerm() && this.getMemberPerm().isNoperm(SysDimensionEnum.Metric.getNumber(), metricDimMmeber.getNumber(), Long.valueOf(0L))) {
                        it.remove();
                        continue;
                    }
                    hasMetricPerm = true;
                    if (TemplateVarCommonUtil.checkIsVar(metricDimMmeber.getNumber(), SysDimensionEnum.Metric.getNumber()).booleanValue()) {
                        metricDimMmeber.setNumber(ReportVarUtil.getRealDimByVar(this.getModelobj().getId(), metricDimMmeber.getNumber(), SysDimensionEnum.Metric.getNumber(), varValus));
                        Member mb = this.getModelCacheHelper().getMember(SysDimensionEnum.Metric.getNumber(), null, metricDimMmeber.getNumber());
                        if (mb != null) {
                            metricDimMmeber.setName(mb.getName());
                        }
                    }
                    if ((membernums = this.alldimensionWithMembers.get(metricDimMmeber.getDimnumber())) == null) {
                        membernums = new LinkedHashSet<String>();
                    }
                    membernums.add(metricDimMmeber.getNumber());
                    this.alldimensionWithMembers.put(metricDimMmeber.getDimnumber(), membernums);
                }
                if (!hasMetricPerm) {
                    noPermColPartIndex.add(String.valueOf(colindex));
                }
            }
            ++colindex;
        }
        int rowindex = 0;
        for (RowColPartition rowPartition : rowPartitions) {
            int rowdimension_index = 0;
            for (IRowColDimensionEntry rowColDimensionEntry : rowPartition.getRowColDimensionEntries()) {
                dimNumber = rowColDimensionEntry.getDimension().getNumber();
                Set<String> membernums = this.alldimensionWithMembers.get(dimNumber);
                if (membernums == null) {
                    membernums = new LinkedHashSet<String>(16);
                }
                String mapkey = dimNumber + "_" + rowindex;
                LinkedHashSet<Member> oneDimension_members = new LinkedHashSet<Member>(16);
                Stack<LevelMember> parent_member = new Stack<LevelMember>();
                LinkedList<Member> members = new LinkedList<Member>();
                DynamicObjectCollection varList = null;
                viewId = DimensionViewServiceHelper.getViewId(this.getDimemsionViews(), (String)dimNumber, (String)("r" + rowindex));
                for (IDimensionMember memberWithScope : rowColDimensionEntry.getMembers()) {
                    Member member1;
                    Set integers;
                    Map<Object, Object> memberScopeMap;
                    if (TemplateVarUtil.checkIsVar(memberWithScope, dimNumber).booleanValue()) {
                        if (TemplateVarUtil.isReport(templateModel) && this.getProcessId() != null) {
                            memberWithScope.setNumber(ReportVarUtil.getRealDimByVar(templateModel.getModelId(), memberWithScope.getNumber(), rowColDimensionEntry.getDimension().getNumber(), varValus));
                        }
                        if (!TemplateVarUtil.isReport(templateModel)) {
                            varList = TemplateVarUtil.addVar2DimLst(modelId, rowColDimensionEntry.getDimension(), memberWithScope, oneDimension_members, membernums, varList);
                            continue;
                        }
                    }
                    String type = RangeF7PropertyCataEnum.Member.getIndex();
                    if (memberWithScope instanceof DefaultDimMember) {
                        type = ((DefaultDimMember)memberWithScope).getType();
                    }
                    ArrayList<Member> cacheMems = null;
                    if ((SysDimensionEnum.Entity.getNumber().equals(dimNumber) || !SysDimensionEnum.include((String)dimNumber, (Boolean)false)) && RangeF7PropertyCataEnum.Property.getIndex().equals(type)) {
                        CustomProperty property;
                        cacheMems = memberPropCache.getMembersByPropValues(this.modelCacheHelper.getDimension(dimNumber).getId(), viewId, memberWithScope.getId());
                        if (CollectionUtils.isEmpty((Collection)cacheMems) && (property = memberPropCache.getProperty(memberWithScope.getId())) != null) {
                            CustomPropertyValue propertyValue = memberPropCache.getPropertyValue(dimNumber, property.getNumber(), memberWithScope.getNumber());
                            cacheMems = memberPropCache.getMembersByPropValues(this.modelCacheHelper.getDimension(dimNumber).getId(), viewId, propertyValue.getId());
                        }
                        if (CollectionUtils.isNotEmpty((Collection)cacheMems) && !this.isNeedMergeCells()) {
                            memberScopeMap = new HashMap(16);
                            if (memberScope.containsKey(mapkey)) {
                                memberScopeMap = memberScope.get(mapkey);
                            } else {
                                memberScope.put(mapkey, memberScopeMap);
                            }
                            for (Member member : cacheMems) {
                                integers = memberScopeMap.computeIfAbsent(member.getNumber(), k -> new HashSet(2));
                                integers.add(RangeEnum.ONLY.getIndex());
                            }
                        }
                    } else if (this.isNeedMergeCells()) {
                        cacheMems = this.getModelCacheHelper().getMemberSort(dimNumber, viewId, memberWithScope.getNumber(), memberWithScope.getScope());
                    } else {
                        memberScopeMap = new HashMap(16);
                        if (memberScope.containsKey(mapkey)) {
                            memberScopeMap = memberScope.get(mapkey);
                        } else {
                            memberScope.put(mapkey, memberScopeMap);
                        }
                        if (memberWithScope.getScope() == RangeEnum.DIRECTSUB_EXCLUDE.getIndex()) {
                            cacheMems = this.getModelCacheHelper().getMemberSort(dimNumber, viewId, memberWithScope.getNumber(), memberWithScope.getScope());
                            for (Member member : cacheMems) {
                                integers = memberScopeMap.computeIfAbsent(member.getNumber(), k -> new HashSet(2));
                                integers.add(memberWithScope.getScope());
                            }
                        } else if (memberWithScope.getScope() == RangeEnum.ALL_EXCLUDE.getIndex()) {
                            cacheMems = this.getModelCacheHelper().getMemberSort(dimNumber, viewId, memberWithScope.getNumber(), memberWithScope.getScope(), 1);
                            for (Member member : cacheMems) {
                                integers = memberScopeMap.computeIfAbsent(member.getNumber(), k -> new HashSet(2));
                                integers.add(memberWithScope.getScope());
                            }
                        } else if (memberWithScope.getScope() == RangeEnum.PEERS_EXCLUDE.getIndex() || memberWithScope.getScope() == RangeEnum.PEERS.getIndex()) {
                            cacheMems = this.getModelCacheHelper().getMemberSort(dimNumber, viewId, memberWithScope.getNumber(), memberWithScope.getScope(), 1);
                            for (Member member : cacheMems) {
                                integers = memberScopeMap.computeIfAbsent(member.getNumber(), k -> new HashSet(2));
                                integers.add(RangeEnum.ONLY.getIndex());
                            }
                        } else if (memberWithScope.getScope() == RangeEnum.ALL_DETAIL.getIndex()) {
                            cacheMems = this.getModelCacheHelper().getMemberSort(dimNumber, viewId, memberWithScope.getNumber(), memberWithScope.getScope());
                            for (Member member : cacheMems) {
                                integers = memberScopeMap.computeIfAbsent(member.getNumber(), k -> new HashSet(2));
                                integers.add(RangeEnum.ONLY.getIndex());
                            }
                        } else if (memberWithScope.getScope() == RangeEnum.ALL_NOTDETAIL.getIndex()) {
                            Member root = this.getModelCacheHelper().getMember(dimNumber, viewId, memberWithScope.getNumber());
                            if (root != null && CollectionUtils.isNotEmpty((Collection)root.getChildren())) {
                                cacheMems = new ArrayList(root.getChildren());
                                cacheMems.removeIf(x -> x.isLeaf());
                                if (CollectionUtils.isNotEmpty(cacheMems)) {
                                    for (Member member15 : cacheMems) {
                                        Optional<Member> first = member15.getChildren().stream().filter(x -> !x.isLeaf()).findFirst();
                                        Set integers2 = memberScopeMap.computeIfAbsent(member15.getNumber(), k -> new HashSet(2));
                                        if (first.isPresent()) {
                                            integers2.add(memberWithScope.getScope());
                                            continue;
                                        }
                                        integers2.add(RangeEnum.ONLY.getIndex());
                                    }
                                }
                            } else {
                                cacheMems = new ArrayList<Member>(16);
                            }
                        } else {
                            cacheMems = this.getModelCacheHelper().getMemberSort(dimNumber, viewId, memberWithScope.getNumber(), RangeEnum.ONLY.getIndex());
                            if (memberWithScope.getScope() != RangeEnum.ONLY.getIndex()) {
                                for (Member member : cacheMems) {
                                    integers = memberScopeMap.computeIfAbsent(member.getNumber(), k -> new HashSet(2));
                                    integers.add(memberWithScope.getScope());
                                }
                            }
                        }
                    }
                    if (SysDimensionEnum.Account.getNumber().equals(dimNumber) && members != null) {
                        cacheMems.removeIf(m -> m.getDatasetId() != null && m.getDatasetId().longValue() != dataset.longValue());
                    }
                    if (TemplateVarUtil.isReport(templateModel) && this.getProcessId() == null && TemplateVarUtil.checkIsVar(memberWithScope, dimNumber).booleanValue() && (member1 = TemplateVarUtil.getNewVarMember(modelId, memberWithScope.getNumber(), dimNumber, varNumberNameMap, this.getModelCacheHelper())) != null) {
                        members.add(member1);
                    }
                    members.addAll(cacheMems);
                }
                if (rowdimension_index == 0 && this.getIndentcells().size() > 0) {
                    Collections.sort(members, Comparator.comparing(Member::getLongNumber));
                }
                for (Member member1 : members) {
                    if (this.isNeedCheckPerm() && this.getMemberPerm().isNoperm(dimNumber, member1.getNumber(), viewId)) continue;
                    member1 = this.getRealTreeLevel(member1, parent_member, rowdimension_index, dimNumber);
                    oneDimension_members.add(member1);
                    membernums.add(member1.getNumber());
                }
                if (oneDimension_members.size() > 0) {
                    allDimension_Members.put(mapkey, oneDimension_members);
                } else {
                    noPermRowPartIndex.add(String.valueOf(rowindex));
                }
                this.alldimensionWithMembers.put(dimNumber, membernums);
                ++rowdimension_index;
            }
            if (Boolean.TRUE.equals(templateModel.getAreaRangeEntry().isMetricInRow())) {
                boolean hasMetricPerm = false;
                Iterator<IMetricDimMmeber> it = rowPartition.getMetricDimMmebers().iterator();
                while (it.hasNext()) {
                    Set<String> membernums;
                    IMetricDimMmeber metricDimMmeber = it.next();
                    if (this.isNeedCheckPerm() && this.getMemberPerm().isNoperm(SysDimensionEnum.Metric.getNumber(), metricDimMmeber.getNumber(), Long.valueOf(0L))) {
                        it.remove();
                        continue;
                    }
                    hasMetricPerm = true;
                    if (TemplateVarCommonUtil.checkIsVar(metricDimMmeber.getNumber(), SysDimensionEnum.Metric.getNumber()).booleanValue()) {
                        metricDimMmeber.setNumber(ReportVarUtil.getRealDimByVar(this.getModelobj().getId(), metricDimMmeber.getNumber(), SysDimensionEnum.Metric.getNumber(), varValus));
                        Member mb = this.getModelCacheHelper().getMember(SysDimensionEnum.Metric.getNumber(), null, metricDimMmeber.getNumber());
                        if (mb != null) {
                            metricDimMmeber.setName(mb.getName());
                        }
                    }
                    if ((membernums = this.alldimensionWithMembers.get(metricDimMmeber.getDimnumber())) == null) {
                        membernums = new LinkedHashSet<String>();
                    }
                    membernums.add(metricDimMmeber.getNumber());
                    this.alldimensionWithMembers.put(metricDimMmeber.getDimnumber(), membernums);
                }
                if (!hasMetricPerm) {
                    noPermRowPartIndex.add(String.valueOf(rowindex));
                }
            }
            ++rowindex;
        }
        if (noPermColPartIndex.size() > 0) {
            for (String partIndex : noPermColPartIndex) {
                for (IRowColDimensionEntry entry : colPartitions.get(0).getRowColDimensionEntries()) {
                    allDimension_Members.remove(entry.getDimension().getNumber() + "_" + partIndex);
                }
            }
        }
        if (noPermRowPartIndex.size() > 0) {
            for (String partIndex : noPermRowPartIndex) {
                for (IRowColDimensionEntry entry : rowPartitions.get(0).getRowColDimensionEntries()) {
                    allDimension_Members.remove(entry.getDimension().getNumber() + "_" + partIndex);
                }
            }
        }
        return allDimension_Members;
    }

    public static List<Member> getMembers(IModelCacheHelper modelCacheHelper, String dimNumber, Long viewId, String memNumber, int memScope, Map<String, Set<Integer>> memberScopeMap) {
        ArrayList<Member> members;
        block10: {
            block14: {
                block15: {
                    block13: {
                        block12: {
                            block11: {
                                block9: {
                                    if (modelCacheHelper == null || StringUtils.isEmpty((String)dimNumber) || StringUtils.isEmpty((String)memNumber) || memberScopeMap == null) {
                                        return Collections.emptyList();
                                    }
                                    if (memScope != RangeEnum.DIRECTSUB_EXCLUDE.getIndex()) break block9;
                                    members = modelCacheHelper.getMemberSort(dimNumber, viewId, memNumber, memScope);
                                    for (Member member1 : members) {
                                        Set integers = memberScopeMap.computeIfAbsent(member1.getNumber(), k -> new HashSet(2));
                                        integers.add(memScope);
                                    }
                                    break block10;
                                }
                                if (memScope != RangeEnum.ALL_EXCLUDE.getIndex()) break block11;
                                members = modelCacheHelper.getMemberSort(dimNumber, viewId, memNumber, memScope, 1);
                                for (Member member1 : members) {
                                    Set integers = memberScopeMap.computeIfAbsent(member1.getNumber(), k -> new HashSet(2));
                                    integers.add(memScope);
                                }
                                break block10;
                            }
                            if (memScope != RangeEnum.PEERS_EXCLUDE.getIndex() && memScope != RangeEnum.PEERS.getIndex()) break block12;
                            members = modelCacheHelper.getMemberSort(dimNumber, viewId, memNumber, memScope, 1);
                            for (Member member1 : members) {
                                Set integers = memberScopeMap.computeIfAbsent(member1.getNumber(), k -> new HashSet(2));
                                integers.add(RangeEnum.ONLY.getIndex());
                            }
                            break block10;
                        }
                        if (memScope != RangeEnum.ALL_DETAIL.getIndex()) break block13;
                        members = modelCacheHelper.getMemberSort(dimNumber, viewId, memNumber, memScope, 1);
                        for (Member member1 : members) {
                            Set integers = memberScopeMap.computeIfAbsent(member1.getNumber(), k -> new HashSet(2));
                            integers.add(RangeEnum.ONLY.getIndex());
                        }
                        break block10;
                    }
                    if (memScope != RangeEnum.ALL_NOTDETAIL.getIndex()) break block14;
                    Member root = modelCacheHelper.getMember(dimNumber, viewId, memNumber);
                    if (root == null || !CollectionUtils.isNotEmpty((Collection)root.getChildren())) break block15;
                    members = new ArrayList(root.getChildren());
                    members.removeIf(x -> x.isLeaf());
                    if (!CollectionUtils.isNotEmpty(members)) break block10;
                    for (Member member1 : members) {
                        Optional<Member> first = member1.getChildren().stream().filter(x -> !x.isLeaf()).findFirst();
                        Set integers = memberScopeMap.computeIfAbsent(member1.getNumber(), k -> new HashSet(2));
                        if (first.isPresent()) {
                            integers.add(memScope);
                            continue;
                        }
                        integers.add(RangeEnum.ONLY.getIndex());
                    }
                    break block10;
                }
                members = new ArrayList<Member>(16);
                break block10;
            }
            members = modelCacheHelper.getMemberSort(dimNumber, viewId, memNumber, RangeEnum.ONLY.getIndex());
            if (memScope != RangeEnum.ONLY.getIndex()) {
                for (Member member1 : members) {
                    Set integers = memberScopeMap.computeIfAbsent(member1.getNumber(), k -> new HashSet(2));
                    integers.add(memScope);
                }
            }
        }
        return members;
    }

    public TreeNode setEntryNodeNew(TreeNode root, List<Member> memberList) {
        Object parentid;
        LinkedHashMap<String, TreeNode> nodeMap = new LinkedHashMap<String, TreeNode>(16);
        TreeNode realRoot = root;
        for (Member member : memberList) {
            Long id = member.getId();
            TreeNode entry = new TreeNode();
            parentid = member.getParentId();
            entry.setParentid(String.valueOf(parentid));
            if (parentid == null || (Long)parentid == 0L) {
                realRoot = entry;
            }
            entry.setId(String.valueOf(id));
            nodeMap.put(String.valueOf(id), entry);
        }
        for (Map.Entry entry : nodeMap.entrySet()) {
            TreeNode parent;
            TreeNode value = (TreeNode)entry.getValue();
            parentid = value.getParentid();
            if ("0".equals(parentid)) {
                parent = root;
            } else {
                parent = (TreeNode)nodeMap.get(parentid);
                if (parent == null) {
                    parent = realRoot;
                }
            }
            parent.addChild(value);
        }
        return root;
    }

    private Member getRealTreeLevel(Member member1, Stack<LevelMember> parent_member, int rowdimension_index, String number) {
        Long viewId = 0L;
        if (member1 instanceof ViewMember) {
            viewId = IDUtils.toLong((Object)((ViewMember)member1).getViewId());
        }
        if (rowdimension_index == 0) {
            member1 = new LevelMember(member1);
            if (parent_member.empty()) {
                parent_member.push((LevelMember)member1);
            } else {
                Member parent = this.getModelCacheHelper().getMember(number, viewId, member1.getParentId());
                if (parent != null) {
                    while (!parent_member.empty()) {
                        LevelMember before = parent_member.peek();
                        if (!parent.getNumber().equals(before.getNumber())) {
                            parent_member.pop();
                            continue;
                        }
                        ((LevelMember)member1).setReal_level(before.getReal_level() + 1);
                        parent_member.push((LevelMember)member1);
                        break;
                    }
                    if (parent_member.empty()) {
                        parent_member.push((LevelMember)member1);
                    }
                } else {
                    parent_member.clear();
                    parent_member.push((LevelMember)member1);
                }
            }
        }
        return member1;
    }

    private void checkViewMemberPermission(ITemplateModel templateModel) {
        if (!this.isNeedCheckPerm()) {
            return;
        }
        for (IViewPointDimensionEntry iViewPointDimensionEntry : templateModel.getViewpointmembentry()) {
            String dimnumber = iViewPointDimensionEntry.getDimension().getNumber();
            String membernum = iViewPointDimensionEntry.getMember().getNumber();
            Long aLong = templateModel.getDimensionView().get(dimnumber);
            if (!this.getMemberPerm().isNoperm(dimnumber, membernum, aLong)) continue;
            throw new KDBizException(ResManager.loadResFormat((String)"\u7f16\u7801\u4e3a\uff1a%1 \u7684\u7ef4\u5ea6\u6ca1\u6709\u6709\u6743\u7684\u6210\u5458\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"EbSpreadManager_1", (String)"epm-eb-spread", (Object[])new Object[]{dimnumber}));
        }
    }

    @Override
    public void initModelObj(ITemplateModel templateModel) {
        Long modelid = templateModel.getModelId();
        QFilter qFilter = new QFilter("id", "=", (Object)modelid);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"epm_model", (String)"shownumber, name", (QFilter[])new QFilter[]{qFilter}, null, (int)1);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String number = row.getString("shownumber");
                String name = row.getString("name");
                this.setModelobj(new BaseEntry(modelid, number, name));
            }
        }
        this.initDimensionViews(templateModel);
    }

    @Override
    public Map<Integer, List<ECell>> getIndentcells() {
        return this.indentcells;
    }

    @Override
    public Map<Integer, Boolean> getIndentParents() {
        return this.indentParents;
    }

    @Override
    public boolean isRowSpan() {
        return this.isRowSpan;
    }

    @Override
    public void setRowSpan(boolean rowSpan) {
        this.isRowSpan = rowSpan;
    }

    public boolean isNeedMergeCells() {
        return this.needMergeCells;
    }

    public void setNeedMergeCells(boolean needMergeCells) {
        this.needMergeCells = needMergeCells;
    }

    public boolean isNeedHandleIndents() {
        return this.needHandleIndents;
    }

    public void setNeedHandleIndents(boolean needHandleIndents) {
        this.needHandleIndents = needHandleIndents;
    }

    @Override
    public IModelCacheHelper getModelCacheHelper() {
        if (this.modelCacheHelper == null) {
            this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelobj().getId());
        }
        return this.modelCacheHelper;
    }

    @Override
    public void setNeedCheckPerm(boolean needCheckPerm) {
        this.needCheckPerm = needCheckPerm;
    }

    @Override
    public boolean isNeedCheckPerm() {
        return this.needCheckPerm;
    }

    @Override
    public Map<String, Long> getDimemsionViews() {
        return this.dimemsionViews;
    }

    @Override
    public void setDimemsionViews(Map<String, Long> dimemsionViews) {
        this.dimemsionViews = dimemsionViews;
    }

    private void initDimensionViews(ITemplateModel templateModel) {
        if (templateModel != null && templateModel.getTemplateBaseInfo() != null && templateModel.getTemplateBaseInfo().getDatasetID() != null) {
            Map<String, Long> templateDimViews;
            Long dataSet = templateModel.getTemplateBaseInfo().getDatasetID();
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)dataSet, (String)"eb_dataset", (String)"businessmodel");
            this.setBusModelid(dynamicObject.getLong("businessmodel.id"));
            this.setDatasetid(dynamicObject.getLong("id"));
            this.setDimMemDefaultDisplayType(templateModel.getTemplateBaseInfo().getDimMemDefaultDisplayType());
            Map viewsByDataSet = this.getModelCacheHelper().getViewsByDataSet(this.getDatasetid());
            if (viewsByDataSet != null) {
                for (Map.Entry dimView : viewsByDataSet.entrySet()) {
                    this.dimemsionViews.put((String)dimView.getKey(), (Long)dimView.getValue());
                }
            }
            if ((templateDimViews = templateModel.getDimemsionViews()) != null && templateDimViews.size() > 0) {
                this.dimemsionViews.putAll(templateDimViews);
            }
        }
    }

    public Map<String, Object> expandNode(int r, int c) {
        Integer groupNode;
        String memNumber;
        String dimNumber;
        HashMap<String, Serializable> result = null;
        ISheet sheet = this.getEbook().getSheet(0);
        ECell selectedCell = sheet.getECellNotAdd(r, c);
        if (selectedCell != null && (dimNumber = (String)selectedCell.getUserObject("dimnumber")) != null && (memNumber = (String)selectedCell.getUserObject("number")) != null && (groupNode = (Integer)selectedCell.getUserObject("groupNode")) != null && groupNode.intValue() == GroupNodeTypeEnum.EXPEND.getIndex()) {
            result = new HashMap<String, Serializable>(16);
            LinkedList<ECell> cells = new LinkedList<ECell>();
            result.put("cells", cells);
            result.put("count", Integer.valueOf(0));
            String cellFlag = (String)selectedCell.getUserObject("cellFlag");
            if (cellFlag == null) {
                cellFlag = GlobalIdUtil.genStringId();
                selectedCell.setUserObject("cellFlag", cellFlag);
            }
            selectedCell.setUserObject("groupNode", GroupNodeTypeEnum.COLLAPSE.getIndex());
            cells.add(selectedCell);
            boolean isRow = this.getRowpartitionDims().contains(dimNumber);
            List<String> dimNumbers = isRow ? this.getRowpartitionDims() : this.getColpartitionDims();
            Map<String, CellDimMember> cellDimMemberMap = isRow ? this.getRowpartitionDimMemsByRow(r) : this.getColpartitionDimMemsByCol(c);
            CellDimMember cellDimMember = cellDimMemberMap.get(dimNumber);
            if (cellDimMember != null) {
                Long viewId = DimensionViewServiceHelper.getViewId(this.getDimemsionViews(), (String)dimNumber, (String)cellDimMember.getPartition());
                Member selectedMember = this.getModelCacheHelper().getMember(dimNumber, viewId, memNumber);
                List members = this.getModelCacheHelper().getDirectSort(selectedMember);
                String rootNumber = selectedMember.getNumber();
                Integer scope = selectedCell.getUserObject("scope", RangeEnum.ONLY.getIndex());
                if (scope.equals(RangeEnum.ALL_DETAIL.getIndex())) {
                    members = this.getModelCacheHelper().getMember(dimNumber, viewId, rootNumber, scope.intValue());
                }
                List allMembers = this.getModelCacheHelper().getMember(dimNumber, viewId, rootNumber, scope.intValue());
                Set allMemberIds = allMembers.stream().map(x -> x.getId()).collect(Collectors.toSet());
                members = members.stream().filter(x -> allMemberIds.contains(x.getId())).collect(Collectors.toList());
                List<String> longDisplayDimNums = ReportHelper.getLongDisplayDimNums(MemberDisplayTypeEnum.LONGNUMBER.getIndex(), this.getModelCacheHelper());
                if (this.isNeedCheckPerm()) {
                    members = members.stream().filter(e -> !this.getMemberPerm().isNoperm(dimNumber, e.getNumber(), viewId)).collect(Collectors.toList());
                }
                if (members != null && members.size() > 0) {
                    ECell eCell;
                    Set<String> allDimMembers = this.getAlldimensionWithMembers().get(dimNumber);
                    int dRowStart = sheet.getDimRowStart();
                    int vRowStart = sheet.getValueAreaRowStart();
                    int dColStart = sheet.getDimColStart();
                    int vColStart = sheet.getValueAreaColStart();
                    List<List<CellDimMember>> partitionDimMems = isRow ? this.getRowpartitionDimMems() : this.getColpartitionDimMems();
                    List<CellDimMember> parentCellDimMems = partitionDimMems.get(isRow ? r : c);
                    int dimIndex = dimNumbers.indexOf(dimNumber);
                    CellDimMember pcellDimMember = parentCellDimMems.get(dimIndex);
                    int dimSize = parentCellDimMems.size();
                    int memIndex = 1;
                    ECell styleCell = null;
                    for (Member member : members) {
                        allDimMembers.add(member.getNumber());
                        ArrayList<CellDimMember> insertCellDimMems = new ArrayList<CellDimMember>(dimSize);
                        for (int i = 0; i < dimSize; ++i) {
                            if (i == dimIndex) {
                                insertCellDimMems.add(new CellDimMember(member.isLeaf(), member.getNumber(), pcellDimMember.getPartition()));
                                continue;
                            }
                            insertCellDimMems.add((CellDimMember)parentCellDimMems.get(i).clone());
                        }
                        if (isRow) {
                            partitionDimMems.add(r + memIndex, insertCellDimMems);
                            sheet.insertRow(r + memIndex, true);
                            styleCell = this.getStyleECell(r + memIndex, c, member.getName(), member.getNumber(), null);
                        } else {
                            partitionDimMems.add(c + memIndex, insertCellDimMems);
                            sheet.insertColumn(c + memIndex, true);
                            int col = c + memIndex;
                            for (int i = sheet.getValueAreaRowStart(); i < sheet.getMaxRowCount(); ++i) {
                                ECell eCell2 = sheet.getECellNotAdd(i, col);
                                if (eCell2 == null) continue;
                                eCell2.setValue(null);
                            }
                            styleCell = this.getStyleECell(r, c + memIndex, member.getName(), member.getNumber(), null);
                        }
                        styleCell.clearAllUserObject();
                        ((StyleCell)styleCell).setvAlign(VerticalAlignEnum.Center.getIndex());
                        ((StyleCell)styleCell).setLocked(true);
                        styleCell.setUserObject("dimnumber", dimNumber);
                        styleCell.setUserObject("number", member.getNumber());
                        styleCell.setUserObject("name", member.getName());
                        styleCell.setUserObject("scope", scope);
                        if (StringUtils.isNotEmpty((String)member.getSimpleName())) {
                            styleCell.setUserObject("simplename", member.getSimpleName());
                        }
                        if (!member.isLeaf()) {
                            List allMembers1 = member.getChildren();
                            Set collect = allMembers1.stream().map(x -> x.getId()).collect(Collectors.toSet());
                            boolean disjoint = Collections.disjoint(allMemberIds, collect);
                            styleCell.setUserObject("isLeaf", disjoint);
                            styleCell.setUserObject("groupNode", disjoint ? GroupNodeTypeEnum.NONE.getIndex() : GroupNodeTypeEnum.EXPEND.getIndex());
                        } else {
                            styleCell.setUserObject("isLeaf", member.isLeaf());
                            if (!member.isLeaf()) {
                                styleCell.setUserObject("groupNode", GroupNodeTypeEnum.EXPEND.getIndex());
                            } else {
                                styleCell.setUserObject("groupNode", GroupNodeTypeEnum.NONE.getIndex());
                            }
                        }
                        styleCell.setUserObject("level", member.getLevel());
                        if (longDisplayDimNums != null && longDisplayDimNums.contains(dimNumber)) {
                            styleCell.setUserObject("longnumber", member.getLongNumber());
                            styleCell.setUserObject("longname", StringUtils.isNotEmpty((String)member.getLongNumber()) ? member.getLongName(this.getModelCacheHelper().getParentsByOrder(viewId, member, false)) : "");
                        }
                        this.setCellValueByDefaultDisplayType(styleCell);
                        this.setCellValueByLongDisplayType((StyleCell)styleCell, longDisplayDimNums);
                        ++memIndex;
                    }
                    if (styleCell != null) {
                        styleCell.setUserObject("openParent", cellFlag);
                    }
                    if (isRow) {
                        int i;
                        for (i = 1; i < memIndex; ++i) {
                            for (int j = sheet.getDimColStart(); j < sheet.getValueAreaColStart(); ++j) {
                                eCell = sheet.getECell(r + i, j);
                                if (eCell == null) continue;
                                eCell.removeUserObject("cellFlag");
                                cells.add(eCell);
                            }
                        }
                        for (i = r; i < sheet.getMaxRowCount(); ++i) {
                            for (int j = sheet.getDimColStart(); j < sheet.getValueAreaColStart(); ++j) {
                                eCell = sheet.getECell(i, j);
                                if (eCell == null) continue;
                                eCell.setRowAndCol(i, j);
                            }
                        }
                    } else {
                        int i;
                        for (i = sheet.getDimRowStart(); i < sheet.getValueAreaRowStart(); ++i) {
                            for (int j = 1; j < memIndex; ++j) {
                                eCell = sheet.getECell(i, c + j);
                                if (eCell == null) continue;
                                eCell.removeUserObject("cellFlag");
                                cells.add(eCell);
                            }
                        }
                        for (i = sheet.getDimRowStart(); i < sheet.getValueAreaRowStart(); ++i) {
                            for (int j = c; j < sheet.getMaxColumnCount(); ++j) {
                                eCell = sheet.getECell(i, j);
                                if (eCell == null) continue;
                                eCell.setRowAndCol(i, j);
                            }
                        }
                    }
                    result.put("count", Integer.valueOf(members.size()));
                }
            }
        }
        return result;
    }

    private void setCellValueByLongDisplayType(StyleCell cell, List<String> longDisplayDimNums) {
        boolean displayLong;
        if (cell == null || CollectionUtils.isEmpty(longDisplayDimNums)) {
            return;
        }
        Object dimnum = cell.getUserObject("dimnumber");
        boolean bl = displayLong = MemberDisplayTypeEnum.LONGNUMBER.getIndex() == this.dimMemDefaultDisplayType || MemberDisplayTypeEnum.LONGNAME.getIndex() == this.dimMemDefaultDisplayType || MemberDisplayTypeEnum.LONGNAMENUMBER.getIndex() == this.dimMemDefaultDisplayType;
        if (dimnum instanceof String && longDisplayDimNums.contains(dimnum.toString()) && displayLong) {
            Object longName;
            Object longNumber;
            Object memName = cell.getValue();
            if (memName == null) {
                return;
            }
            Object memNum = cell.getUserObject("number");
            if (DimPropertyHelper.checkPropertyCell(cell)) {
                memNum = cell.getUserObject("typenum") + "#" + cell.getUserObject("properytnum");
            }
            if ((longNumber = cell.getUserObject("longnumber")) == null || StringUtils.isEmpty((String)longNumber.toString())) {
                longNumber = memNum;
            }
            if ((longName = cell.getUserObject("longname")) == null || StringUtils.isEmpty((String)longName.toString())) {
                longName = memName;
            }
            if (MemberDisplayTypeEnum.LONGNUMBER.getIndex() == this.dimMemDefaultDisplayType) {
                cell.setValue(longNumber);
            } else if (MemberDisplayTypeEnum.LONGNAME.getIndex() == this.dimMemDefaultDisplayType) {
                cell.setValue(longName);
            } else if (MemberDisplayTypeEnum.LONGNAMENUMBER.getIndex() == this.dimMemDefaultDisplayType) {
                cell.setValue(longName + ":" + longNumber);
            }
        }
    }

    public Map<String, Object> collapseNode(int r, int c) {
        Integer groupNode;
        String cellFlag;
        String memNumber;
        String dimNumber;
        ISheet sheet = this.getEbook().getSheet(0);
        ECell selectedCell = sheet.getECellNotAdd(r, c);
        HashMap<String, Object> result = new HashMap<String, Object>(16);
        LinkedList<Integer> indexes = new LinkedList<Integer>();
        result.put("count", 0);
        result.put("indexes", indexes);
        if (selectedCell != null && (dimNumber = (String)selectedCell.getUserObject("dimnumber")) != null && (memNumber = (String)selectedCell.getUserObject("number")) != null && (cellFlag = (String)selectedCell.getUserObject("cellFlag")) != null && (groupNode = (Integer)selectedCell.getUserObject("groupNode")) != null && groupNode.intValue() == GroupNodeTypeEnum.COLLAPSE.getIndex()) {
            int i;
            boolean isRow = this.getRowpartitionDims().contains(dimNumber);
            int rowCount = sheet.getMaxRowCount();
            int colCount = sheet.getMaxColumnCount();
            int index = -1;
            ECell _cell = null;
            if (isRow) {
                for (i = r + 1; i < rowCount; ++i) {
                    _cell = sheet.getECellNotAdd(i, c);
                    if (_cell == null || !cellFlag.equals(_cell.getUserObject("openParent"))) continue;
                    index = i;
                    break;
                }
            } else {
                for (i = c + 1; i < colCount; ++i) {
                    _cell = sheet.getECellNotAdd(r, i);
                    if (_cell == null || !cellFlag.equals(_cell.getUserObject("openParent"))) continue;
                    index = i;
                    break;
                }
            }
            if (index > 0) {
                Map<String, Object> subResult = null;
                Integer subCount = 0;
                List subIndexes = null;
                if (_cell != null && (groupNode = (Integer)_cell.getUserObject("groupNode")) != null && groupNode.intValue() == GroupNodeTypeEnum.COLLAPSE.getIndex()) {
                    subResult = this.collapseNode(_cell.getRow(), _cell.getCol());
                    subCount = (Integer)subResult.get("count");
                    subIndexes = (List)subResult.get("indexes");
                }
                List<List<CellDimMember>> cellDimMems = isRow ? this.getRowpartitionDimMems() : this.getColpartitionDimMems();
                int count = 0;
                if (isRow) {
                    int i2;
                    for (i2 = index; i2 > r; --i2) {
                        cellDimMems.remove(i2);
                        sheet.delRow(i2);
                        indexes.add(i2);
                        ++count;
                    }
                    for (i2 = r; i2 < sheet.getMaxRowCount(); ++i2) {
                        for (int j = sheet.getDimColStart(); j < sheet.getValueAreaColStart(); ++j) {
                            ECell eCell = sheet.getECell(i2, j);
                            if (eCell == null) continue;
                            eCell.setRowAndCol(i2, j);
                        }
                    }
                } else {
                    int i3;
                    for (i3 = index; i3 > c; --i3) {
                        cellDimMems.remove(i3);
                        sheet.delColumn(i3);
                        indexes.add(i3);
                        ++count;
                    }
                    for (i3 = sheet.getDimRowStart(); i3 < sheet.getValueAreaRowStart(); ++i3) {
                        for (int j = c; j < sheet.getMaxColumnCount(); ++j) {
                            ECell eCell = sheet.getECell(i3, j);
                            if (eCell == null) continue;
                            eCell.setRowAndCol(i3, j);
                        }
                    }
                }
                if (subIndexes != null && subIndexes.size() > 0) {
                    indexes.addAll(subIndexes);
                }
                result.put("count", subCount == null ? count : subCount + count);
            }
            selectedCell.setUserObject("groupNode", GroupNodeTypeEnum.EXPEND.getIndex());
        }
        return result;
    }

    @Override
    public boolean isShowProperty() {
        return this.isShowProperty;
    }

    @Override
    public void setShowProperty(boolean showProperty) {
        this.isShowProperty = showProperty;
    }

    @Override
    public Long getBusModelid() {
        return this.busModelid;
    }

    @Override
    public void setBusModelid(Long busModelid) {
        this.busModelid = busModelid;
    }

    @Override
    public Long getDatasetid() {
        return this.datasetid;
    }

    @Override
    public void setDatasetid(Long datasetid) {
        this.datasetid = datasetid;
    }

    @Override
    public Long getReportProcessId() {
        return this.reportProcessId;
    }

    @Override
    public void setReportProcessId(Long reportProcessId) {
        this.reportProcessId = reportProcessId;
    }

    @Override
    public void setProcessId(Long processId) {
        this.processId = processId;
    }

    @Override
    public void setVarFlagStr(String varFlagStr) {
        this.varFlagStr = varFlagStr;
    }

    @Override
    public String getVarFlagStr() {
        return this.varFlagStr;
    }

    @Override
    public Long getProcessId() {
        return this.processId;
    }

    @Override
    public String getProcessType() {
        return this.processType;
    }

    @Override
    public void setProcessType(String processType) {
        this.processType = processType;
    }

    @Override
    public void setIsPreview(boolean isPreview) {
        this.isPreview = isPreview;
    }

    @Override
    public boolean getIsPreview() {
        return this.isPreview;
    }

    @Override
    public Map<String, Map<String, String>> getFormulaMap() {
        return this.formulaMap;
    }

    @Override
    public void setFormulaMap(Map<String, Map<String, String>> formulaMap) {
        this.formulaMap = formulaMap;
    }

    @Override
    public Map<String, Map<String, String>> getOutAreaHyperLink() {
        return this.outAreaHyperLink;
    }

    @Override
    public void setOutAreaHyperLink(Map<String, Map<String, String>> outAreaHyperLink) {
        this.outAreaHyperLink = outAreaHyperLink;
    }

    @Override
    public int getDimMemDefaultDisplayType() {
        return this.dimMemDefaultDisplayType;
    }

    @Override
    public void setDimMemDefaultDisplayType(int dimMemDefaultDisplayType) {
        this.dimMemDefaultDisplayType = dimMemDefaultDisplayType;
    }

    @Override
    public int getMaxSize() {
        return this.maxSize;
    }

    @Override
    public void setMaxSize(int maxSize) {
        this.maxSize = maxSize;
    }
}

