/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.template.spreadmanager.book;

import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.io.SegmentedStringWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import kd.epm.eb.spread.template.spreadmanager.book.IEBook;
import kd.epm.eb.spread.template.spreadmanager.sheet.ESheet;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import kd.epm.eb.spread.utils.ObjectMapperCache;

public class EBook
implements IEBook {
    private static final long serialVersionUID = 1L;
    private List<ISheet> book = new ArrayList<ISheet>();

    public EBook(String ... sheetName) {
        this.buildBlankSheets(sheetName);
    }

    private void buildBlankSheets(String ... sheetName) {
        for (String name : sheetName) {
            this.addSheet(name);
        }
    }

    private void addSheet(String sheetName) {
        this.book.add(new ESheet(sheetName));
    }

    @Override
    public ISheet getSheet(int idx) {
        if (idx > this.book.size()) {
            return null;
        }
        return this.book.get(idx);
    }

    @Override
    public void addSheet(ISheet sheet) {
        this.book.add(sheet);
    }

    @Override
    public ISheet getSheet(String sheetName) {
        for (ISheet sheet : this.book) {
            if (!sheetName.equals(sheet.getSheetName())) continue;
            return sheet;
        }
        return null;
    }

    @Override
    public int getSheetCount() {
        return this.book.size();
    }

    @Override
    public void removeSheet(int idx) {
        this.book.remove(idx);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String toJsonWithRealRowCol() throws IOException {
        JsonGenerator jsonGenerator = null;
        boolean close = false;
        SegmentedStringWriter sw = null;
        try {
            JsonFactory jsonFactory = ObjectMapperCache.getObjectMapper(ISheet.class).getJsonFactory();
            sw = new SegmentedStringWriter(jsonFactory._getBufferRecycler());
            jsonGenerator = jsonFactory.createJsonGenerator((Writer)sw);
            jsonGenerator.writeStartObject();
            jsonGenerator.writeStringField("version", "12.0.0");
            jsonGenerator.writeNumberField("sheetCount", this.book.size());
            jsonGenerator.writeObjectFieldStart("sheets");
            for (ISheet sheet : this.book) {
                sheet.getSpreadJson(jsonGenerator);
            }
            jsonGenerator.writeEndObject();
            jsonGenerator.writeEndObject();
            if (jsonGenerator != null) {
                jsonGenerator.close();
                close = true;
            }
        }
        catch (Exception e) {
            close = false;
        }
        finally {
            if (!close && jsonGenerator != null) {
                jsonGenerator.close();
            }
        }
        return sw == null ? null : sw.getAndClear();
    }

    @Override
    public String getEmptyJson() {
        StringBuilder json = new StringBuilder();
        json.append("{\"version\":\"12.0.0\",");
        json.append("\"sheetCount\":").append(this.book.size()).append(",");
        json.append("\"sheets\":{");
        for (ISheet sheet : this.book) {
            json.append(sheet.getEmptySheetJson());
            json.append(",");
        }
        json.deleteCharAt(json.length() - 1);
        json.append("}}");
        return json.toString();
    }

    @Override
    public Iterator<ISheet> iterator() {
        return this.book.iterator();
    }
}

