/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.template.spreadmanager.fix;

import com.fasterxml.jackson.databind.annotation.JsonDeserialize;
import com.fasterxml.jackson.databind.annotation.JsonSerialize;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import kd.bos.algo.DataSet;
import kd.bos.algo.Row;
import kd.bos.dataentity.entity.DynamicObject;
import kd.bos.dataentity.resource.ResManager;
import kd.bos.exception.KDBizException;
import kd.bos.logging.Log;
import kd.bos.logging.LogFactory;
import kd.bos.orm.query.QFilter;
import kd.bos.servicehelper.BusinessDataServiceHelper;
import kd.bos.servicehelper.QueryServiceHelper;
import kd.epm.eb.common.bgmddatalock.BgmdDataLockService;
import kd.epm.eb.common.bgmddatalock.IBgmdDataLockCache;
import kd.epm.eb.common.cache.IModelCacheHelper;
import kd.epm.eb.common.cache.ModelCacheContext;
import kd.epm.eb.common.cache.impl.Dimension;
import kd.epm.eb.common.cache.impl.Member;
import kd.epm.eb.common.cache.propertycache.MemberPropCacheService;
import kd.epm.eb.common.cache.propertycache.entity.MemberPropCache;
import kd.epm.eb.common.entity.property.CustomPropertyValue;
import kd.epm.eb.common.enums.ProcessTypeEnum;
import kd.epm.eb.common.enums.RangeEnum;
import kd.epm.eb.common.enums.SysDimensionEnum;
import kd.epm.eb.common.enums.dimensionEnums.RangeF7PropertyCataEnum;
import kd.epm.eb.common.permission.IMemberPermCache;
import kd.epm.eb.common.permission.MemberPermCacheServiceHelper;
import kd.epm.eb.common.utils.DimensionViewServiceHelper;
import kd.epm.eb.common.utils.IDUtils;
import kd.epm.eb.common.utils.RangeModel;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.spread.template.BaseEntry;
import kd.epm.eb.spread.template.IBaseEntry;
import kd.epm.eb.spread.template.ITemplateModel;
import kd.epm.eb.spread.template.afix.multimanager.AreaInfo;
import kd.epm.eb.spread.template.afix.multimanager.AreaManagerStrategy;
import kd.epm.eb.spread.template.afix.multimanager.MultiAreaManager;
import kd.epm.eb.spread.template.afix.multisetting.CellHyperLinkPOJO;
import kd.epm.eb.spread.template.afix.multisetting.IMultiAreaSetting;
import kd.epm.eb.spread.template.afix.multisetting.MultiAreaSetting;
import kd.epm.eb.spread.template.arearangedim.DefaultRowColDimensionEntry;
import kd.epm.eb.spread.template.arearangedim.IRowColDimensionEntry;
import kd.epm.eb.spread.template.dimension.DefaultDimMember;
import kd.epm.eb.spread.template.dimension.IDimensionMember;
import kd.epm.eb.spread.template.dimension.PageViewDimMember;
import kd.epm.eb.spread.template.spreadmanager.CellDimMember;
import kd.epm.eb.spread.template.spreadmanager.EbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.book.IEBook;
import kd.epm.eb.spread.template.spreadmanager.serializer.afix.FixSpreadManagerDeserializer;
import kd.epm.eb.spread.template.spreadmanager.serializer.afix.FixSpreadManagerSerializer;
import kd.epm.eb.spread.template.spreadmanager.sheet.AbstractESheet;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import kd.epm.eb.spread.template.viewpointdim.IViewPointDimensionEntry;
import kd.epm.eb.spread.utils.DimPropertyHelper;
import kd.epm.eb.spread.utils.ReportVar.ReportVarUtil;
import kd.epm.eb.spread.utils.ReportVar.TemplateVarUtil;
import org.apache.commons.collections4.CollectionUtils;

@JsonSerialize(using=FixSpreadManagerSerializer.class)
@JsonDeserialize(using=FixSpreadManagerDeserializer.class)
public class FixSpreadManager
implements IEbSpreadManager {
    private Map<String, Set<String>> alldimensionWithMembers = new HashMap<String, Set<String>>();
    private Map<String, PageViewDimMember> pageViewDims = new HashMap<String, PageViewDimMember>();
    private IBaseEntry modelobj;
    private boolean isShowNumber = false;
    private boolean isShowProperty = true;
    private List<MultiAreaManager> multiAreaManager = new ArrayList<MultiAreaManager>();
    private boolean hasFloat = false;
    private boolean floatOnRow = true;
    private IMemberPermCache memberPerm;
    private transient IBgmdDataLockCache dataLockCache;
    private IModelCacheHelper modelCacheHelper;
    private Log log = LogFactory.getLog(FixSpreadManager.class);
    private Map<String, Long> dimemsionViews = new HashMap<String, Long>();
    private Long busModelid;
    private Long datasetid;
    private Long reportProcessId;
    private Long processId;
    private String processType;
    private String varFlagStr;
    private boolean isPreview;
    private Map<String, Map<String, String>> formulaMap = new HashMap<String, Map<String, String>>(16);
    private Map<String, Map<String, String>> outAreaHyperLink = new HashMap<String, Map<String, String>>(16);
    private int dimMemDefaultDisplayType = 1;
    private Map<IRowColDimensionEntry, Set<String>> rowcolentryScopes = new HashMap<IRowColDimensionEntry, Set<String>>();
    private Map<String, Integer> metricDatatypeMap;

    @Override
    public Integer getMetricRowIndex() {
        return null;
    }

    @Override
    public Integer getMetricColIndex() {
        return null;
    }

    @Override
    public IEBook getEbook() {
        throw new RuntimeException();
    }

    @Override
    public void setEbook(IEBook ebook) {
        throw new RuntimeException();
    }

    @Override
    public void buildReportManager(ITemplateModel templateModel) {
        if (this.getModelobj() == null || this.getModelobj().getId() == null || this.getModelobj().getId() == 0L) {
            this.initModelObj(templateModel);
        }
        this.buildHidedimsIntoAllDimension(templateModel);
        this.checkViewMemberPermission(templateModel);
        this.getMembersWithFloat(templateModel);
        this.buildAreaSettings(templateModel);
        if (this.getDimemsionViews() == null || this.getDimemsionViews().isEmpty()) {
            this.initDimensionViews(templateModel);
        }
    }

    @Override
    public Map<IRowColDimensionEntry, Set<String>> getRowcolentryScopes() {
        return this.rowcolentryScopes;
    }

    public void getMembersWithFloat(ITemplateModel templateModel) {
        Long dataset = templateModel.getTemplateBaseInfo().getDatasetID();
        Map<String, Map<String, String>> varValus = null;
        if (IDUtils.isNotNull((Long)this.processId) && templateModel.getTemplateBaseInfo() != null) {
            if (ProcessTypeEnum.REPORT.getNumber().equals(this.getProcessType())) {
                varValus = ReportVarUtil.getVarValues(this.getProcessType(), this.modelobj.getId(), this.processId, templateModel.getTemplateBaseInfo().getVarBase());
            } else if (ProcessTypeEnum.TASK.getNumber().equals(this.getProcessType())) {
                String formID = "eb_taskprocess";
                boolean exists = QueryServiceHelper.exists((String)formID, (Object)this.processId);
                varValus = exists ? ReportVarUtil.getVarValues(this.getProcessType(), this.modelobj.getId(), this.processId, templateModel.getTemplateBaseInfo().getVarBase()) : ReportVarUtil.getVarValueByTaskList(this.modelobj.getId(), this.processId, templateModel.getTemplateBaseInfo().getId());
            }
        }
        MemberPropCache memberPropCache = null;
        Long viewId = null;
        for (IMultiAreaSetting areaRange : templateModel.getAreaRanges()) {
            if (areaRange.getFloatInfos() == null || areaRange.getFloatInfos().size() <= 0) continue;
            for (MultiAreaSetting.FloatInfo floatInfo : areaRange.getFloatInfos()) {
                for (IRowColDimensionEntry rowColDimensionEntry : floatInfo.getPartition().getRowColDimensionEntries()) {
                    String dimnumber = rowColDimensionEntry.getDimension().getNumber();
                    Dimension dimension = this.getModelCacheHelper().getDimension(dimnumber);
                    viewId = DimensionViewServiceHelper.getViewId(this.getDimemsionViews(), (String)dimnumber, (String)areaRange.getAreaRangeStart());
                    Set<String> onedim_nums = this.alldimensionWithMembers.get(dimnumber);
                    if (onedim_nums == null) {
                        onedim_nums = new HashSet<String>();
                        this.alldimensionWithMembers.put(dimnumber, onedim_nums);
                    }
                    LinkedHashSet<String> rowcolentryscope = new LinkedHashSet<String>();
                    this.rowcolentryScopes.put(rowColDimensionEntry, rowcolentryscope);
                    HashMap<IDimensionMember, List> propMems2DimMems = new HashMap<IDimensionMember, List>(16);
                    for (IDimensionMember member : rowColDimensionEntry.getMembers()) {
                        List members;
                        if (RangeF7PropertyCataEnum.Property.getIndex().equals(member.getType()) && StringUtils.isNotEmpty((String)member.getLongNumber())) {
                            CustomPropertyValue customPropertyValue;
                            List transedMems = propMems2DimMems.computeIfAbsent(member, f -> new LinkedList());
                            String[] propValueNums = member.getLongNumber().split("!");
                            if (propValueNums.length != 2) continue;
                            if (memberPropCache == null) {
                                memberPropCache = MemberPropCacheService.getOrCreate((Long)this.modelobj.getId());
                            }
                            if ((customPropertyValue = memberPropCache.getPropertyValue(dimnumber, propValueNums[0], propValueNums[1])) == null) continue;
                            List dimMembers = memberPropCache.getMembersByPropValues(dimension.getId(), viewId, customPropertyValue.getId());
                            if (floatInfo.getRangeType() == 0) {
                                dimMembers = dimMembers.stream().filter(e -> e.isLeaf()).collect(Collectors.toList());
                            }
                            if (SysDimensionEnum.Account.getNumber().equals(rowColDimensionEntry.getDimension().getNumber())) {
                                dimMembers.removeIf(m -> m.getDatasetId() != null && m.getDatasetId().longValue() != dataset.longValue());
                            }
                            if (dimMembers == null || dimMembers.size() <= 0) continue;
                            for (Member member1 : dimMembers) {
                                if (this.isNeedCheckPerm() && this.getMemberPerm().isNoperm(rowColDimensionEntry.getDimension().getNumber(), member1.getNumber(), viewId)) continue;
                                onedim_nums.add(member1.getNumber());
                                rowcolentryscope.add(member1.getNumber());
                                transedMems.add(member1);
                            }
                            continue;
                        }
                        if (varValus != null && this.modelobj != null && rowColDimensionEntry.getDimension() != null) {
                            member.setNumber(ReportVarUtil.getRealDimByVar(this.modelobj.getId(), member.getNumber(), rowColDimensionEntry.getDimension().getNumber(), varValus));
                        }
                        if ((members = this.getModelCacheHelper().getMember(rowColDimensionEntry.getDimension().getNumber(), viewId, member.getNumber(), member.getScope())) == null) continue;
                        if (floatInfo.getRangeType() == 0) {
                            members = members.stream().filter(e -> e.isLeaf()).collect(Collectors.toList());
                        }
                        if (SysDimensionEnum.Account.getNumber().equals(rowColDimensionEntry.getDimension().getNumber())) {
                            members.removeIf(m -> m.getDatasetId() != null && m.getDatasetId().longValue() != dataset.longValue());
                        }
                        for (Member member1 : members) {
                            if (this.isNeedCheckPerm() && this.getMemberPerm().isNoperm(rowColDimensionEntry.getDimension().getNumber(), member1.getNumber(), viewId)) continue;
                            onedim_nums.add(member1.getNumber());
                            rowcolentryscope.add(member1.getNumber());
                        }
                    }
                    if (propMems2DimMems.isEmpty()) continue;
                    List<IDimensionMember> members = rowColDimensionEntry.getMembers();
                    for (Map.Entry entry : propMems2DimMems.entrySet()) {
                        members.addAll(((List)entry.getValue()).stream().map(e -> new DefaultDimMember(e.getId(), e.getName(), e.getNumber(), RangeEnum.ONLY.getIndex(), e.isLeaf())).collect(Collectors.toList()));
                        members.remove(entry.getKey());
                    }
                }
            }
        }
    }

    private void buildAreaSettings(ITemplateModel templateModel) {
        List<IMultiAreaSetting> areaRanges = templateModel.getAreaRanges();
        if (areaRanges == null || areaRanges.size() == 0) {
            return;
        }
        AreaManagerStrategy areaManager = new AreaManagerStrategy();
        areaManager.setLoadVarValue(TemplateVarUtil.isVarTemplate(templateModel));
        for (IMultiAreaSetting areaRange : areaRanges) {
            if (areaRange == null || !StringUtils.isNotEmpty((String)areaRange.getAreaRange())) continue;
            this.buildOneAreaSetting(areaManager, areaRange, templateModel);
        }
    }

    private void buildOneAreaSetting(AreaManagerStrategy areaManager, IMultiAreaSetting areaRange, ITemplateModel templateModel) {
        MultiAreaManager multiAreaManager = new MultiAreaManager();
        multiAreaManager.setEbSpreadManager(this);
        multiAreaManager.setTemplateModel(templateModel);
        multiAreaManager.setAreaIndex(areaRange.getAreaRangeStart());
        multiAreaManager.build(areaManager, areaRange);
        if (areaRange.getFloatOnWhere() != -1) {
            this.setHasFloat(true);
        }
        this.setCellHyperInfo(multiAreaManager, areaRange);
        if (areaRange.getRowSeq() != null) {
            multiAreaManager.setFixReportRowSeqDto(areaRange.getRowSeq());
        }
        this.multiAreaManager.add(multiAreaManager);
    }

    private void setCellHyperInfo(MultiAreaManager areaManager, IMultiAreaSetting areaRange) {
        if (areaManager == null || areaRange == null || areaRange.getCellHyperLinkMap() == null) {
            return;
        }
        Map<String, Set<CellHyperLinkPOJO>> cellHyperLinkMap = areaRange.getCellHyperLinkMap();
        if (cellHyperLinkMap != null && cellHyperLinkMap.size() > 0) {
            areaManager.setHasCellHyperLinkInfo(Boolean.TRUE);
            for (Map.Entry<String, Set<CellHyperLinkPOJO>> entry : cellHyperLinkMap.entrySet()) {
                Set<CellHyperLinkPOJO> value = entry.getValue();
                String key = entry.getKey();
                String[] split1 = key.split("]");
                if (!CollectionUtils.isNotEmpty(value)) continue;
                for (CellHyperLinkPOJO map : value) {
                    String s;
                    String[] split;
                    ECell eCellNotAdd = areaManager.getData().getDataSheet().getECell(map.getR(), map.getC());
                    if (split1.length != 2 || (split = (s = split1[0]).split(" ")).length < 2) continue;
                    eCellNotAdd.setUserObject("templatenumber", split[0].replace("[", ""));
                    eCellNotAdd.setUserObject("templateName", split1[0]);
                }
            }
        }
    }

    private void buildHidedimsIntoAllDimension(ITemplateModel templateModel) {
        List<IViewPointDimensionEntry> hidedims = templateModel.getHidedimentry();
        for (IViewPointDimensionEntry hidedim : hidedims) {
            this.alldimensionWithMembers.put(hidedim.getDimension().getNumber(), Sets.newHashSet((Object[])new String[]{hidedim.getMember().getNumber()}));
            PageViewDimMember pageViewDimMember = new PageViewDimMember(hidedim.getMember().getNumber(), true);
            this.pageViewDims.put(hidedim.getDimension().getNumber(), pageViewDimMember);
        }
    }

    private void checkViewMemberPermission(ITemplateModel templateModel) {
        for (IViewPointDimensionEntry iViewPointDimensionEntry : templateModel.getViewpointmembentry()) {
            String dimnumber = iViewPointDimensionEntry.getDimension().getNumber();
            String membernum = iViewPointDimensionEntry.getMember().getNumber();
            Long viweId = templateModel.getDimensionView().get(dimnumber);
            if (!this.isNeedCheckPerm() || !this.getMemberPerm().isNoperm(dimnumber, membernum, viweId)) continue;
            throw new KDBizException(ResManager.loadResFormat((String)"\u7f16\u7801\u4e3a\uff1a%1 \u7684\u7ef4\u5ea6\u6ca1\u6709\u6709\u6743\u7684\u6210\u5458\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406\u3002", (String)"FixSpreadManager_0", (String)"epm-eb-spread", (Object[])new Object[]{dimnumber}));
        }
    }

    @Override
    public Map<String, Integer> getMetricDatatypeMap() {
        if (this.metricDatatypeMap == null) {
            this.metricDatatypeMap = this.queryMetricDataType(this.getModelobj().getId());
        }
        return this.metricDatatypeMap;
    }

    private Map<String, Integer> queryMetricDataType(Long modelId) {
        QFilter modelqfilter = new QFilter("model", "=", (Object)modelId);
        Map metricmembers = BusinessDataServiceHelper.loadFromCache((String)"epm_metricmembertree", (String)"number, datatype", (QFilter[])new QFilter[]{modelqfilter});
        HashMap<String, Integer> metricDatatypeMap = new HashMap<String, Integer>();
        if (metricmembers != null && metricmembers.size() > 0) {
            for (Map.Entry metricobjects : metricmembers.entrySet()) {
                DynamicObject metricobject = (DynamicObject)metricobjects.getValue();
                metricDatatypeMap.put(metricobject.getString("number"), metricobject.getInt("datatype"));
            }
        }
        return metricDatatypeMap;
    }

    @Override
    public Map<String, CellDimMember> getColpartitionDimMemsByCol(Integer col) {
        throw new RuntimeException();
    }

    @Override
    public Map<String, CellDimMember> getRowpartitionDimMemsByRow(Integer row) {
        throw new RuntimeException();
    }

    @Override
    public Map<String, Set<String>> getAlldimensionWithMembers() {
        return this.alldimensionWithMembers;
    }

    @Override
    public Map<String, Set<String>> getFloatMembers() {
        HashMap floatMemberMap = null;
        if (this.isHasFloat()) {
            floatMemberMap = Maps.newHashMapWithExpectedSize((int)this.alldimensionWithMembers.size());
            List<MultiAreaManager> areas = this.getMultiAreaManager();
            if (areas != null) {
                for (MultiAreaManager _area : areas) {
                    CellDimMember cell;
                    List<CellDimMember> cells;
                    Set _members;
                    if (_area.getAreaPageViewDims() != null && !_area.getAreaPageViewDims().isEmpty()) {
                        for (Map.Entry<String, PageViewDimMember> entry : _area.getAreaPageViewDims().entrySet()) {
                            _members = floatMemberMap.computeIfAbsent(entry.getKey(), f -> Sets.newLinkedHashSet());
                            _members.add(entry.getValue().getNumber());
                        }
                    }
                    if (!_area.getRowpartitionDimMems().isEmpty()) {
                        List<String> rowPartitionDims = _area.getRowpartitionDims();
                        Map<String, Integer> dimPosMap = DimPropertyHelper.getDimPosMap(_area.getRowHeaders());
                        int in = rowPartitionDims.size();
                        for (int i = 0; i < in; ++i) {
                            String rowPartitionDim = rowPartitionDims.get(i);
                            _members = floatMemberMap.computeIfAbsent(rowPartitionDim, f -> Sets.newLinkedHashSet());
                            int jn = _area.getRowpartitionDimMems().size();
                            for (int j = 0; j < jn; ++j) {
                                cells = _area.getRowpartitionDimMems().get(j);
                                if (cells == null || cells.isEmpty()) continue;
                                Integer index = (Integer)dimPosMap.get(rowPartitionDim);
                                if (index != null) {
                                    cell = cells.get(index);
                                } else {
                                    CellDimMember cellDimMember = cell = cells.size() > i ? cells.get(i) : null;
                                }
                                if (cell == null) continue;
                                _members.add(cell.getDimMemberNumber());
                            }
                        }
                    } else {
                        List<String> rowpartitionDims = _area.getRowpartitionDims();
                        if (rowpartitionDims != null) {
                            for (String rowpartitionDim : rowpartitionDims) {
                                floatMemberMap.computeIfAbsent(rowpartitionDim, f -> Sets.newLinkedHashSet());
                            }
                        }
                    }
                    if (!_area.getColpartitionDimMems().isEmpty()) {
                        int in = _area.getColpartitionDims().size();
                        for (int i = 0; i < in; ++i) {
                            _members = floatMemberMap.computeIfAbsent(_area.getColpartitionDims().get(i), f -> Sets.newLinkedHashSet());
                            int jn = _area.getColpartitionDimMems().size();
                            for (int j = 0; j < jn; ++j) {
                                cells = _area.getColpartitionDimMems().get(j);
                                if (cells == null || cells.isEmpty()) continue;
                                CellDimMember cellDimMember = cell = cells.size() > i ? cells.get(i) : null;
                                if (cell == null) continue;
                                _members.add(cell.getDimMemberNumber());
                            }
                        }
                        continue;
                    }
                    List<String> colpartitionDims = _area.getColpartitionDims();
                    if (colpartitionDims == null) continue;
                    for (String rowpartitionDim : colpartitionDims) {
                        floatMemberMap.computeIfAbsent(rowpartitionDim, f -> Sets.newLinkedHashSet());
                    }
                }
            }
        }
        return floatMemberMap;
    }

    @Override
    public IBaseEntry getModelobj() {
        return this.modelobj;
    }

    @Override
    public void setModelobj(IBaseEntry modelobj) {
        this.modelobj = modelobj;
    }

    @Override
    public Map<String, PageViewDimMember> getPageViewDims() {
        return this.pageViewDims;
    }

    @Override
    public Set<String> getToDeleteData() {
        throw new RuntimeException();
    }

    @Override
    public void setToDeleteData(Set<String> toDeleteData) {
        throw new RuntimeException();
    }

    @Override
    public List<List<CellDimMember>> getColpartitionDimMems() {
        throw new RuntimeException();
    }

    @Override
    public void setColpartitionDimMems(List<List<CellDimMember>> colpartitionDimMems) {
        throw new RuntimeException();
    }

    @Override
    public List<String> getColpartitionDims() {
        throw new RuntimeException();
    }

    @Override
    public void setColpartitionDims(List<String> colpartitionDims) {
        throw new RuntimeException();
    }

    @Override
    public List<List<CellDimMember>> getRowpartitionDimMems() {
        throw new RuntimeException();
    }

    @Override
    public void setRowpartitionDimMems(List<List<CellDimMember>> rowpartitionDimMems) {
        throw new RuntimeException();
    }

    @Override
    public List<String> getRowpartitionDims() {
        throw new RuntimeException();
    }

    @Override
    public void setRowpartitionDims(List<String> rowpartitionDims) {
        throw new RuntimeException();
    }

    @Override
    public boolean isShowNumber() {
        return this.isShowNumber;
    }

    @Override
    public void setShowNumber(boolean showNumber) {
        this.isShowNumber = showNumber;
    }

    @Override
    public boolean isShowProperty() {
        return this.isShowProperty;
    }

    @Override
    public void setShowProperty(boolean showProperty) {
        this.isShowProperty = showProperty;
    }

    @Override
    public boolean isShowMetricNumber() {
        return false;
    }

    @Override
    public void setShowMetricNumber(boolean showMetricNumber) {
    }

    @Override
    public Map<String, List<Long>> getApproveBillDimMembers() {
        return null;
    }

    @Override
    public void setApproveBillDimMembers(Map<String, List<Long>> approveBillDimMembers) {
    }

    @Override
    public boolean isDimensionCombine(int row, int col) {
        return false;
    }

    @Override
    public boolean isDimensionCombine(ECell cell) {
        return false;
    }

    @Override
    public String getDeleteSepar() {
        return "&";
    }

    @Override
    public IMemberPermCache getMemberPerm() {
        if (this.memberPerm == null) {
            this.memberPerm = MemberPermCacheServiceHelper.build(null, (Long)this.getModelobj().getId(), (Long)this.getBusModelid(), null);
        }
        return this.memberPerm;
    }

    @Override
    public IBgmdDataLockCache getDataLock() {
        if (this.dataLockCache == null) {
            this.dataLockCache = BgmdDataLockService.getInstance().getDataLockCache(this.getModelobj().getId(), this.getBusModelid());
        }
        return this.dataLockCache;
    }

    @Override
    public Map<String, Set<Member>> resolvePageMemberScope(ITemplateModel templateModel) {
        EbSpreadManager sm = new EbSpreadManager();
        sm.setModelobj(this.getModelobj());
        sm.initModelObj(templateModel);
        sm.setMemberPerm(this.getMemberPerm());
        sm.setProcessId(this.getProcessId());
        sm.setProcessType(this.getProcessType());
        sm.setVarFlagStr(this.getVarFlagStr());
        sm.setIsPreview(this.getIsPreview());
        sm.setNeedCheckPerm(this.isNeedCheckPerm());
        return sm.resolvePageMemberScope(templateModel);
    }

    @Override
    public void initModelObj(ITemplateModel templateModel) {
        Long modelid = templateModel.getModelId();
        QFilter qFilter = new QFilter("id", "=", (Object)modelid);
        try (DataSet dataSet = QueryServiceHelper.queryDataSet((String)this.getClass().getName(), (String)"epm_model", (String)"shownumber, name", (QFilter[])new QFilter[]{qFilter}, null, (int)1);){
            while (dataSet.hasNext()) {
                Row row = dataSet.next();
                String number = row.getString("shownumber");
                String name = row.getString("name");
                this.setModelobj(new BaseEntry(modelid, number, name));
            }
        }
        this.initDimensionViews(templateModel);
    }

    @Override
    public Map<Integer, List<ECell>> getIndentcells() {
        return null;
    }

    @Override
    public Map<Integer, Boolean> getIndentParents() {
        return null;
    }

    @Override
    public boolean isRowSpan() {
        return false;
    }

    @Override
    public List<MultiAreaManager> getMultiAreaManager() {
        if (this.multiAreaManager == null) {
            this.multiAreaManager = new ArrayList<MultiAreaManager>();
        }
        return this.multiAreaManager;
    }

    @Override
    public AreaInfo getAreaInfoByRowCol(int row, int col) {
        RangeModel rangeModel = new RangeModel(col, col, row, row);
        for (MultiAreaManager multiAreaManager : this.multiAreaManager) {
            if (!rangeModel.checkIsInArea(multiAreaManager.getAreaRange())) continue;
            return multiAreaManager.getAreaInfo(row, col);
        }
        return null;
    }

    @Override
    public IModelCacheHelper getModelCacheHelper() {
        if (this.modelCacheHelper == null) {
            this.modelCacheHelper = ModelCacheContext.getOrCreate((Long)this.getModelobj().getId());
        }
        return this.modelCacheHelper;
    }

    @Override
    public boolean isHasFloat() {
        if (this.multiAreaManager != null) {
            for (MultiAreaManager m : this.multiAreaManager) {
                if (m.getFloatonWhere() != 0 && m.getFloatonWhere() != 1) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public void setHasFloat(boolean hasFloat) {
        this.hasFloat = hasFloat;
    }

    @Override
    public boolean isFloatOnRow() {
        return this.floatOnRow;
    }

    @Override
    public void setFloatOnRow(boolean floatOnRow) {
        this.floatOnRow = floatOnRow;
    }

    @Override
    public Set<Member> resolveScopeByDimensionEntry(IRowColDimensionEntry dimensionEntry, String areaIndex) {
        LinkedHashSet<Member> result = new LinkedHashSet<Member>();
        Long viewId = null;
        String dimNumber = dimensionEntry.getDimension().getNumber();
        if (dimensionEntry instanceof DefaultRowColDimensionEntry) {
            String viewIdStr = ((DefaultRowColDimensionEntry)dimensionEntry).getViewId();
            viewId = StringUtils.isNotEmpty((String)viewIdStr) ? IDUtils.toLong((Object)viewIdStr) : DimensionViewServiceHelper.getViewId(this.getDimemsionViews(), (String)dimNumber, (String)areaIndex);
        }
        for (IDimensionMember member : dimensionEntry.getMembers()) {
            List members = this.getModelCacheHelper().getMember(dimNumber, viewId, member.getNumber(), member.getScope());
            for (Member member1 : members) {
                if (this.isNeedCheckPerm() && this.getMemberPerm().isNoperm(dimNumber, member1.getNumber(), viewId)) continue;
                result.add(member1);
            }
        }
        return result;
    }

    @Override
    public Map<String, Long> getDimemsionViews() {
        return this.dimemsionViews;
    }

    @Override
    public void setDimemsionViews(Map<String, Long> dimemsionViews) {
        this.dimemsionViews = dimemsionViews;
    }

    private void initDimensionViews(ITemplateModel templateModel) {
        if (templateModel != null && templateModel.getTemplateBaseInfo() != null && templateModel.getTemplateBaseInfo().getDatasetID() != null) {
            Long dataSet = templateModel.getTemplateBaseInfo().getDatasetID();
            DynamicObject dynamicObject = BusinessDataServiceHelper.loadSingle((Object)dataSet, (String)"eb_dataset", (String)"businessmodel");
            this.setBusModelid(dynamicObject.getLong("businessmodel.id"));
            this.setDatasetid(dynamicObject.getLong("id"));
            this.setDimMemDefaultDisplayType(templateModel.getTemplateBaseInfo().getDimMemDefaultDisplayType());
            this.dimemsionViews.putAll(this.getModelCacheHelper().getViewsByDataSet(templateModel.getTemplateBaseInfo().getDatasetID()));
            Map<String, Long> templateDimViews = templateModel.getDimemsionViews();
            if (templateDimViews != null && templateDimViews.size() > 0) {
                this.dimemsionViews.putAll(templateDimViews);
            }
        }
    }

    public RangeModel getValueStartEnds() {
        if (this.getMultiAreaManager() == null || this.getMultiAreaManager().isEmpty()) {
            return new RangeModel(0, 0, 0, 0);
        }
        int valueAreaRowStart = AbstractESheet.getDefaultMaxRow();
        int valueAreaColStart = AbstractESheet.getDefaultMaxCol();
        int realMaxRows = 0;
        int realMaxCols = 0;
        for (MultiAreaManager multiAreaManager : this.getMultiAreaManager()) {
            MultiAreaManager.ValueArea vStart = multiAreaManager.getValueAreaStart();
            Integer[] vEnd = multiAreaManager.getValueAreaEnd();
            valueAreaRowStart = Math.min(valueAreaRowStart, vStart.getData_row_start());
            valueAreaColStart = Math.min(valueAreaColStart, vStart.getData_col_start());
            realMaxRows = Math.max(realMaxRows, vEnd[2]);
            realMaxCols = Math.max(realMaxCols, vEnd[3]);
        }
        return new RangeModel(valueAreaColStart, realMaxCols, valueAreaRowStart, realMaxRows);
    }

    @Override
    public Long getBusModelid() {
        return this.busModelid;
    }

    @Override
    public void setBusModelid(Long busModelid) {
        this.busModelid = busModelid;
    }

    @Override
    public Long getDatasetid() {
        return this.datasetid;
    }

    @Override
    public void setDatasetid(Long datasetid) {
        this.datasetid = datasetid;
    }

    @Override
    public String getVarFlagStr() {
        return this.varFlagStr;
    }

    @Override
    public Long getReportProcessId() {
        return this.reportProcessId;
    }

    @Override
    public void setReportProcessId(Long reportProcessId) {
        this.reportProcessId = reportProcessId;
    }

    @Override
    public Long getProcessId() {
        return this.processId;
    }

    @Override
    public void setProcessId(Long processId) {
        this.processId = processId;
    }

    @Override
    public String getProcessType() {
        return this.processType;
    }

    @Override
    public void setProcessType(String processType) {
        this.processType = processType;
    }

    @Override
    public void setVarFlagStr(String varFlagStr) {
        this.varFlagStr = varFlagStr;
    }

    @Override
    public void setIsPreview(boolean isPreview) {
        this.isPreview = isPreview;
    }

    @Override
    public boolean getIsPreview() {
        return this.isPreview;
    }

    @Override
    public Map<String, Map<String, String>> getFormulaMap() {
        return this.formulaMap;
    }

    @Override
    public void setFormulaMap(Map<String, Map<String, String>> formulaMap) {
        this.formulaMap = formulaMap;
    }

    @Override
    public Map<String, Map<String, String>> getOutAreaHyperLink() {
        return this.outAreaHyperLink;
    }

    @Override
    public void setOutAreaHyperLink(Map<String, Map<String, String>> outAreaHyperLink) {
        this.outAreaHyperLink = outAreaHyperLink;
    }

    @Override
    public int getDimMemDefaultDisplayType() {
        return this.dimMemDefaultDisplayType;
    }

    @Override
    public void setDimMemDefaultDisplayType(int dimMemDefaultDisplayType) {
        this.dimMemDefaultDisplayType = dimMemDefaultDisplayType;
    }
}

