/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.template.spreadmanager.serializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.spread.template.spreadmanager.DiffAnalyzeSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.DiffCellDimMember;
import kd.epm.eb.spread.template.spreadmanager.IDiffAnalyzeSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.book.EBook;
import kd.epm.eb.spread.template.spreadmanager.list.SPArrayList;
import kd.epm.eb.spread.template.spreadmanager.serializer.DiffESheetDeSerializer;
import kd.epm.eb.spread.template.spreadmanager.sheet.ESheet;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;

public class DiffAnalyzeSpreadManagerDeserializer
extends JsonDeserializer<DiffAnalyzeSpreadManager> {
    private DeserializationContext deserializationContext;

    public DiffAnalyzeSpreadManager deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        this.deserializationContext = deserializationContext;
        JsonNode rootNode = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        DiffAnalyzeSpreadManager spreadManager = this.readSpreadManager(rootNode);
        if (rootNode.get("modelid") != null) {
            spreadManager.setModelid(rootNode.get("modelid").asLong());
        }
        if (rootNode.get("datasetid") != null) {
            spreadManager.setDatasetid(rootNode.get("datasetid").asLong());
        }
        if (rootNode.get("busmodelid") != null) {
            spreadManager.setBusmodelid(rootNode.get("busmodelid").asLong());
        }
        if (rootNode.get("hideemptyrows") != null) {
            spreadManager.setHideEmptyRows(rootNode.get("hideemptyrows").asBoolean());
        }
        if (rootNode.get("dataunit") != null) {
            spreadManager.setDataUnit(rootNode.get("dataunit").asText());
        }
        if (rootNode.get("memberDisplayType") != null) {
            spreadManager.setMemberDisplayType(rootNode.get("memberDisplayType").asInt());
        }
        spreadManager.getDimemsionViews().putAll(this.readDimensionViews(rootNode));
        spreadManager.setRowDimension(this.readOneDimension(rootNode, "rowDim"));
        spreadManager.setColDimension(this.readOneDimension(rootNode, "colDim"));
        spreadManager.setCommonDimension(this.readCommonDimension(rootNode));
        spreadManager.setRowCellDimMembers(this.readCellDimMembers(rootNode, "rowCellDimMem"));
        spreadManager.setColCellDimMembers(this.readCellDimMembers(rootNode, "colCellDimMem"));
        this.readBook(rootNode, spreadManager);
        return spreadManager;
    }

    private List<Dimension> readCommonDimension(JsonNode rootNode) {
        LinkedList<Dimension> dimensions = new LinkedList<Dimension>();
        if (rootNode != null && rootNode.get("commonDim") != null) {
            Iterator dims = rootNode.get("commonDim").elements();
            while (dims.hasNext()) {
                dimensions.add(this.readOneDimension((JsonNode)dims.next(), null));
            }
        }
        return dimensions;
    }

    private Dimension readOneDimension(JsonNode rootNode, String fieldKey) {
        Dimension dimension = null;
        JsonNode dimNode = null;
        dimNode = fieldKey != null ? rootNode.get(fieldKey) : rootNode;
        if (dimNode != null) {
            dimension = new Dimension();
            if (dimNode.get("number") != null) {
                dimension.setNumber(dimNode.get("number").textValue());
            }
            if (dimNode.get("name") != null) {
                dimension.setName(dimNode.get("name").textValue());
            }
            if (dimNode.get("shortnum") != null) {
                dimension.setShortNumber(dimNode.get("shortnum").textValue());
            }
            if (dimNode.get("memmodel") != null) {
                dimension.setMemberModel(dimNode.get("memmodel").textValue());
            }
            if (dimNode.get("seq") != null) {
                dimension.setSeq(dimNode.get("seq").asInt());
            }
            if (dimNode.get("mems") != null) {
                Iterator membNodes = dimNode.get("mems").elements();
                while (membNodes.hasNext()) {
                    dimension.add(this.readOneDimensionMember(null, (JsonNode)membNodes.next()));
                }
            }
        }
        return dimension;
    }

    private Member readOneDimensionMember(Dimension dimension, JsonNode membNode) {
        if (membNode != null && !membNode.isNull()) {
            Member member = new Member(dimension);
            if (membNode.get("number") != null) {
                member.setNumber(membNode.get("number").textValue());
            }
            if (membNode.get("longnum") != null) {
                member.setLongNumber(membNode.get("longnum").textValue());
            }
            if (membNode.get("name") != null) {
                member.setName(membNode.get("name").textValue());
            }
            if (membNode.get("level") != null) {
                member.setLevel(membNode.get("level").asInt());
            }
            if (membNode.get("isLeaf") != null) {
                member.setLeaf(membNode.get("isLeaf").asBoolean());
            }
            if (membNode.get("shownumber") != null) {
                member.setShowNumber(membNode.get("shownumber").textValue());
            }
            return member;
        }
        return null;
    }

    private List<DiffCellDimMember> readCellDimMembers(JsonNode rootNode, String fieldKey) {
        SPArrayList<DiffCellDimMember> membs = null;
        JsonNode colPartNode = rootNode.get(fieldKey);
        if (colPartNode != null) {
            Iterator membNodes = colPartNode.elements();
            membs = new SPArrayList<DiffCellDimMember>();
            while (membNodes.hasNext()) {
                JsonNode membNode = (JsonNode)membNodes.next();
                membs.add(this.readOneCellDimMember(membNode));
            }
        }
        return membs;
    }

    private DiffCellDimMember readOneCellDimMember(JsonNode membNode) {
        if (membNode != null && !membNode.isNull()) {
            return new DiffCellDimMember(membNode.get("dimNum").textValue(), membNode.get("memNum").textValue(), membNode.get("level").asInt(), membNode.get("gnt").asInt(), membNode.get("drill").asInt(), membNode.get("ti").asInt(), membNode.get("isLeaf").asBoolean(), membNode.get("refreshed").asBoolean(), this.readOneCellDimMember(membNode.get("parent")));
        }
        return null;
    }

    private Map<String, Long> readDimensionViews(JsonNode rootNode) {
        HashMap<String, Long> dimensionViews = new HashMap<String, Long>();
        JsonNode node = rootNode.get("dimemsionViews");
        if (node != null) {
            Iterator fields = node.fields();
            while (fields.hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                if (field.getKey() == null || field.getValue() == null) continue;
                dimensionViews.put((String)field.getKey(), Long.parseLong(((JsonNode)field.getValue()).textValue()));
            }
        }
        return dimensionViews;
    }

    private DiffAnalyzeSpreadManager readSpreadManager(JsonNode node) {
        if (node == null || node.get("sm") == null) {
            return new DiffAnalyzeSpreadManager();
        }
        String smStr = node.get("sm").textValue();
        if (StringUtils.isNotEmpty((String)smStr)) {
            return (DiffAnalyzeSpreadManager)ObjectSerialUtil.deSerializedBytes((String)smStr);
        }
        return new DiffAnalyzeSpreadManager();
    }

    private void readBook(JsonNode node, IDiffAnalyzeSpreadManager ebSpreadManager) {
        DiffESheetDeSerializer eSheetDeSerializer = new DiffESheetDeSerializer(this.deserializationContext);
        EBook eBook = new EBook(new String[0]);
        ebSpreadManager.setEbook(eBook);
        JsonNode bookenode = node.get("book");
        if (bookenode == null) {
            eBook.addSheet(new ESheet());
        } else {
            Iterator sheets = bookenode.elements();
            while (sheets != null && sheets.hasNext()) {
                JsonNode sheetNode = (JsonNode)sheets.next();
                if (sheetNode == null) continue;
                ISheet sheet = eSheetDeSerializer.readSheet(sheetNode);
                eBook.addSheet(sheet);
            }
        }
    }
}

