/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.template.spreadmanager.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import kd.epm.eb.common.model.Dimension;
import kd.epm.eb.common.model.Member;
import kd.epm.eb.spread.template.spreadmanager.DiffAnalyzeSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.DiffCellDimMember;
import kd.epm.eb.spread.template.spreadmanager.book.IEBook;
import kd.epm.eb.spread.template.spreadmanager.serializer.DiffESheetSerializer;
import kd.epm.eb.spread.template.spreadmanager.serializer.ESheetSerializer;

public class DiffAnalyzeSpreadManagerSerializer
extends JsonSerializer<DiffAnalyzeSpreadManager> {
    private JsonGenerator jsonGenerator;
    private ESheetSerializer eSheetSerializer = new DiffESheetSerializer();

    public void serialize(DiffAnalyzeSpreadManager spreadManager, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
        this.jsonGenerator = jsonGenerator;
        this.eSheetSerializer.setJsonGenerator(jsonGenerator);
        this.eSheetSerializer.setSerializerProvider(serializerProvider);
        jsonGenerator.writeStartObject();
        jsonGenerator.writeNumberField("modelid", spreadManager.getModelid().longValue());
        jsonGenerator.writeNumberField("datasetid", spreadManager.getDatasetid().longValue());
        jsonGenerator.writeNumberField("busmodelid", spreadManager.getBusmodelid().longValue());
        jsonGenerator.writeBooleanField("hideemptyrows", spreadManager.isHideEmptyRows());
        jsonGenerator.writeNumberField("memberDisplayType", spreadManager.getMemberDisplayType());
        if (spreadManager.getDataUnit() != null) {
            jsonGenerator.writeStringField("dataunit", spreadManager.getDataUnit());
        }
        this.writeDimensionViews(spreadManager.getDimemsionViews());
        this.writeOneDimension(spreadManager.getRowDimension(), "rowDim");
        this.writeOneDimension(spreadManager.getColDimension(), "colDim");
        this.writeCommonDimension(spreadManager.getCommonDimension());
        this.writeCellDimMembers(spreadManager.getRowCellDimMembers(), true);
        this.writeCellDimMembers(spreadManager.getColCellDimMembers(), false);
        this.writeBook(spreadManager.getEbook());
        jsonGenerator.writeEndObject();
    }

    private void writeCommonDimension(List<Dimension> commonDimension) throws IOException {
        if (commonDimension != null && commonDimension.size() > 0) {
            this.jsonGenerator.writeArrayFieldStart("commonDim");
            for (Dimension dimension : commonDimension) {
                this.writeOneDimension(dimension, null);
            }
            this.jsonGenerator.writeEndArray();
        }
    }

    private void writeOneDimension(Dimension dimension, String dimTypeString) throws IOException {
        if (dimension != null) {
            List members = dimension.getMembers();
            if (dimTypeString != null) {
                this.jsonGenerator.writeObjectFieldStart(dimTypeString);
            } else {
                this.jsonGenerator.writeStartObject();
            }
            if (dimension.getNumber() != null) {
                this.jsonGenerator.writeStringField("number", dimension.getNumber());
            }
            if (dimension.getName() != null) {
                this.jsonGenerator.writeStringField("name", dimension.getName());
            }
            if (dimension.getShortNumber() != null) {
                this.jsonGenerator.writeStringField("shortnum", dimension.getShortNumber());
            }
            if (dimension.getMemberModel() != null) {
                this.jsonGenerator.writeStringField("memmodel", dimension.getMemberModel());
            }
            this.jsonGenerator.writeNumberField("seq", dimension.getSeq());
            if (members != null && members.size() > 0) {
                this.jsonGenerator.writeArrayFieldStart("mems");
                for (Member m : members) {
                    this.writeOneDimensionMember(m);
                }
                this.jsonGenerator.writeEndArray();
            }
            this.jsonGenerator.writeEndObject();
        }
    }

    private void writeOneDimensionMember(Member m) throws IOException {
        if (m != null) {
            this.jsonGenerator.writeStartObject();
            if (m.getNumber() != null) {
                this.jsonGenerator.writeStringField("number", m.getNumber());
            }
            if (m.getLongNumber() != null) {
                this.jsonGenerator.writeStringField("longnum", m.getLongNumber());
            }
            if (m.getName() != null) {
                this.jsonGenerator.writeStringField("name", m.getName());
            }
            if (m.getShowNumber() != null) {
                this.jsonGenerator.writeStringField("shownumber", m.getShowNumber());
            }
            this.jsonGenerator.writeNumberField("level", m.getLevel());
            this.jsonGenerator.writeBooleanField("isLeaf", m.isLeaf());
            this.jsonGenerator.writeEndObject();
        }
    }

    private void writeCellDimMembers(List<DiffCellDimMember> cellDimMembers, boolean isRow) throws IOException {
        if (cellDimMembers != null) {
            if (isRow) {
                this.jsonGenerator.writeArrayFieldStart("rowCellDimMem");
            } else {
                this.jsonGenerator.writeArrayFieldStart("colCellDimMem");
            }
            for (DiffCellDimMember cellMemb : cellDimMembers) {
                if (cellMemb != null) {
                    this.writeOneRowCellDimMember(cellMemb, false);
                    continue;
                }
                this.jsonGenerator.writeNull();
            }
            this.jsonGenerator.writeEndArray();
        }
    }

    private void writeOneRowCellDimMember(DiffCellDimMember cellMemb, boolean isParent) throws IOException {
        if (cellMemb != null) {
            if (!isParent) {
                this.jsonGenerator.writeStartObject();
            }
            if (cellMemb.getDimNumber() != null) {
                this.jsonGenerator.writeStringField("dimNum", cellMemb.getDimNumber());
            }
            if (cellMemb.getMemNumber() != null) {
                this.jsonGenerator.writeStringField("memNum", cellMemb.getMemNumber());
            }
            this.jsonGenerator.writeNumberField("level", cellMemb.getLevel());
            this.jsonGenerator.writeNumberField("gnt", cellMemb.getGroupNodeType());
            this.jsonGenerator.writeNumberField("drill", cellMemb.getDrill());
            this.jsonGenerator.writeNumberField("ti", cellMemb.getTi());
            this.jsonGenerator.writeBooleanField("isLeaf", cellMemb.isIsleaf());
            this.jsonGenerator.writeBooleanField("refreshed", cellMemb.isRefreshed());
            if (cellMemb.getParent() != null) {
                this.jsonGenerator.writeObjectFieldStart("parent");
                this.writeOneRowCellDimMember(cellMemb.getParent(), true);
            }
            this.jsonGenerator.writeEndObject();
        }
    }

    private void writeDimensionViews(Map<String, Long> dimensionViews) throws IOException {
        if (dimensionViews != null && !dimensionViews.isEmpty()) {
            this.jsonGenerator.writeObjectFieldStart("dimemsionViews");
            for (Map.Entry<String, Long> dimView : dimensionViews.entrySet()) {
                if (dimView.getKey() == null || dimView.getValue() == null) continue;
                this.jsonGenerator.writeStringField(dimView.getKey(), String.valueOf(dimView.getValue()));
            }
            this.jsonGenerator.writeEndObject();
        }
    }

    private void writeBook(IEBook ebook) throws IOException {
        this.jsonGenerator.writeArrayFieldStart("book");
        int j = ebook.getSheetCount();
        for (int i = 0; i < j; ++i) {
            this.jsonGenerator.writeStartObject();
            this.eSheetSerializer.serialize(ebook.getSheet(0));
            this.jsonGenerator.writeEndObject();
        }
        this.jsonGenerator.writeEndArray();
    }
}

