/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.template.spreadmanager.serializer;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.TextNode;
import java.math.BigDecimal;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.ebSpread.common.variant.Variant;
import kd.epm.eb.ebSpread.model.CellData;
import kd.epm.eb.ebSpread.model.UserObject;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import kd.epm.eb.spread.template.spreadmanager.sheet.ESheet;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import kd.epm.eb.spread.template.spreadmanager.sheet.StyleCell;

public class ESheetDeSerializer {
    protected DeserializationContext deserializationContext;

    public ESheetDeSerializer(DeserializationContext deserializationContext) {
        this.deserializationContext = deserializationContext;
    }

    public ISheet readSheet(JsonNode sheetNode) {
        JsonNode colWidth;
        ESheet sheet = new ESheet(sheetNode.get("sheetname").asText(), sheetNode.get("rmrs").asInt(), sheetNode.get("rmcs").asInt());
        sheet.setValueAreaRowStart(sheetNode.get("vars").asInt());
        sheet.setValueAreaColStart(sheetNode.get("vacs").asInt());
        if (sheetNode.get("drs") != null) {
            sheet.setDimRowStart(sheetNode.get("drs").asInt());
        }
        if (sheetNode.get("dcs") != null) {
            sheet.setDimColStart(sheetNode.get("dcs").asInt());
        }
        sheet.setIsdatachanged(sheetNode.get("change").asBoolean());
        sheet.setStyleCell(sheetNode.get("stylecell") == null ? false : sheetNode.get("stylecell").asBoolean());
        if (sheetNode.get("defaults") != null && (colWidth = sheetNode.get("defaults").get("colWidth")) instanceof TextNode) {
            HashMap<String, Object> sheetDefaults = new HashMap<String, Object>(1);
            sheetDefaults.put("colWidth", ((TextNode)colWidth).textValue());
            sheet.setSheetDefaults(sheetDefaults);
        }
        this.readTable(sheet, sheetNode);
        return sheet;
    }

    protected void readTable(ISheet sheet, JsonNode sheetNode) {
        Iterator row_Nodes = sheetNode.get("tb").elements();
        int row = 0;
        while (row_Nodes != null && row_Nodes.hasNext()) {
            JsonNode rowNode = (JsonNode)row_Nodes.next();
            Iterator cellNodes = rowNode.elements();
            int col = 0;
            while (cellNodes != null && cellNodes.hasNext()) {
                this.readCell((JsonNode)cellNodes.next(), sheet, row, col);
                ++col;
            }
            ++row;
        }
    }

    protected void readCell(JsonNode cellNode, ISheet sheet, int row, int col) {
        if (cellNode != null && cellNode.elements().hasNext()) {
            JsonNode floatcell = cellNode.get("floatcell");
            ECell cell = sheet.getECell(row, col);
            if (floatcell != null) {
                cell.setFloatCell(true);
            }
            if (cell instanceof StyleCell) {
                if (cellNode.get("ti") != null) {
                    ((StyleCell)cell).setTextIndent(cellNode.get("ti").asInt());
                }
                if (cellNode.get("fm") != null) {
                    ((StyleCell)cell).setFormatter(cellNode.get("fm").asText());
                }
                if (cellNode.get("ft") != null) {
                    ((StyleCell)cell).setFont(cellNode.get("ft").asText());
                }
            }
            this.readCellValue(cell, cellNode);
            this.readUserObject(cell, cellNode);
            this.readCellFormula(cell, cellNode);
        }
    }

    protected void readCellFormula(ECell cell, JsonNode cellNode) {
        JsonNode formulaNode = cellNode.get("f");
        if (formulaNode != null) {
            cell.setFormula(formulaNode.asText());
        }
    }

    protected void readUserObject(ECell cell, JsonNode cellNode) {
        JsonNode userobjnode = cellNode.get("ub");
        if (userobjnode != null) {
            if (cell.isFloatCell() && userobjnode instanceof TextNode) {
                cell.setUserObject((UserObject)ObjectSerialUtil.deSerializedBytes((String)userobjnode.asText()));
            } else {
                Iterator objIt = userobjnode.fields();
                while (objIt.hasNext()) {
                    Map.Entry entry = (Map.Entry)objIt.next();
                    JsonNode value = (JsonNode)entry.getValue();
                    if (value.isInt()) {
                        cell.setUserObject((String)entry.getKey(), value.asInt());
                        continue;
                    }
                    if (value.isLong()) {
                        cell.setUserObject((String)entry.getKey(), value.asLong());
                        continue;
                    }
                    if (value.isBoolean()) {
                        cell.setUserObject((String)entry.getKey(), value.asBoolean());
                        continue;
                    }
                    if (value.isBigDecimal()) {
                        cell.setUserObject((String)entry.getKey(), value.decimalValue());
                        continue;
                    }
                    if ("null".equalsIgnoreCase(value.asText())) continue;
                    cell.setUserObject((String)entry.getKey(), value.asText());
                }
            }
        }
    }

    protected void readCellValue(ECell cell, JsonNode cellNode) {
        JsonNode valueNode = cellNode.get("v");
        if (valueNode != null) {
            CellData cellData = null;
            if (valueNode.isArray()) {
                ArrayNode val = (ArrayNode)valueNode;
                Iterator vals = val.elements();
                if (vals.hasNext()) {
                    Variant v;
                    cellData = new CellData();
                    int vt = ((JsonNode)vals.next()).intValue();
                    JsonNode valNode = (JsonNode)vals.next();
                    switch (vt) {
                        case 12: {
                            v = new Variant(new Date(valNode.longValue()), vt);
                            break;
                        }
                        case 10: {
                            v = new Variant(new BigDecimal(valNode.textValue()), vt);
                            break;
                        }
                        case 9: {
                            v = new Variant(valNode.longValue(), vt);
                            break;
                        }
                        case 8: {
                            v = new Variant(valNode.booleanValue(), vt);
                            break;
                        }
                        case 13: {
                            v = new Variant(this.deserializationContext.constructCalendar(new Date(valNode.longValue())), vt);
                            break;
                        }
                        case 7: {
                            v = new Variant(valNode.textValue(), vt);
                            break;
                        }
                        case 3: {
                            v = new Variant(valNode.intValue(), vt);
                            break;
                        }
                        default: {
                            v = new Variant(valNode.textValue(), vt);
                        }
                    }
                    cellData.setData(v);
                }
            } else {
                cellData = new CellData();
                cellData.setData(new Variant(valueNode.decimalValue(), 10));
            }
            cell.setCellData(cellData);
        }
    }
}

