/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.template.spreadmanager.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.math.BigDecimal;
import java.util.List;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.ebSpread.common.variant.Variant;
import kd.epm.eb.spread.template.spreadmanager.sheet.ECell;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;
import kd.epm.eb.spread.template.spreadmanager.sheet.StyleCell;

public class ESheetSerializer {
    protected JsonGenerator jsonGenerator;
    protected SerializerProvider serializerProvider;

    public void setJsonGenerator(JsonGenerator jsonGenerator) {
        this.jsonGenerator = jsonGenerator;
    }

    public void setSerializerProvider(SerializerProvider serializerProvider) {
        this.serializerProvider = serializerProvider;
    }

    public void serialize(ISheet sheet) throws IOException, JsonProcessingException {
        this.writeSheets(sheet);
    }

    protected void writeSheets(ISheet sheet) throws IOException {
        this.jsonGenerator.writeStringField("sheetname", sheet.getSheetName());
        this.jsonGenerator.writeNumberField("vars", sheet.getValueAreaRowStart());
        this.jsonGenerator.writeNumberField("vacs", sheet.getValueAreaColStart());
        this.jsonGenerator.writeNumberField("drs", sheet.getDimRowStart());
        this.jsonGenerator.writeNumberField("dcs", sheet.getDimColStart());
        this.jsonGenerator.writeNumberField("rmrs", sheet.getRealMaxRows());
        this.jsonGenerator.writeNumberField("rmcs", sheet.getRealMaxCols());
        this.jsonGenerator.writeBooleanField("change", sheet.isIsdatachanged());
        this.jsonGenerator.writeBooleanField("stylecell", sheet.isStyleCell());
        if (sheet.getSheetDefaults() != null) {
            this.jsonGenerator.writeObjectFieldStart("defaults");
            sheet.getSheetDefaults().forEach((k, v) -> {
                if (k != null && v != null) {
                    try {
                        this.jsonGenerator.writeStringField(k, String.valueOf(v));
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
            });
            this.jsonGenerator.writeEndObject();
        }
        this.writeTable(sheet.getTable());
    }

    protected void writeTable(List<List<ECell>> table) throws IOException {
        this.jsonGenerator.writeArrayFieldStart("tb");
        for (List<ECell> row : table) {
            try {
                this.jsonGenerator.writeStartArray();
                for (ECell cell : row) {
                    try {
                        this.writeCell(cell);
                    }
                    catch (IOException e) {
                        throw new RuntimeException(e);
                    }
                }
                this.jsonGenerator.writeEndArray();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
        this.jsonGenerator.writeEndArray();
    }

    protected void writeCell(ECell cell) throws IOException {
        this.jsonGenerator.writeStartObject();
        if (cell != null) {
            if (cell.isFloatCell()) {
                this.jsonGenerator.writeNumberField("floatcell", 1);
            }
            this.writeCellData(cell);
            this.writeUserObject(cell);
            if (cell.getFormula() != null) {
                this.jsonGenerator.writeStringField("f", cell.getFormula());
            }
            if (cell instanceof StyleCell) {
                if (((StyleCell)cell).getTextIndent() != 0) {
                    this.jsonGenerator.writeNumberField("ti", ((StyleCell)cell).getTextIndent());
                }
                if (((StyleCell)cell).getFormatter() != null) {
                    this.jsonGenerator.writeStringField("fm", ((StyleCell)cell).getFormatter());
                }
                if (((StyleCell)cell).getFont() != null) {
                    this.jsonGenerator.writeStringField("ft", ((StyleCell)cell).getFont());
                }
            }
        }
        this.jsonGenerator.writeEndObject();
    }

    protected void writeUserObject(ECell cell) throws IOException {
        if (!cell.hasUserObject()) {
            return;
        }
        if (cell.isFloatCell() && cell.getUserObject("scope") != null) {
            this.jsonGenerator.writeStringField("ub", ObjectSerialUtil.toByteSerialized((Object)cell.getUserObject()));
        } else {
            this.jsonGenerator.writeObjectFieldStart("ub");
            cell.getUserObject().forEach((K, V) -> {
                try {
                    this.serializerProvider.defaultSerializeField(K, V, this.jsonGenerator);
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            });
            this.jsonGenerator.writeEndObject();
        }
    }

    protected void writeCellData(ECell cell) throws IOException {
        Object value = cell.getValue();
        if (value != null) {
            Variant variant = cell.getVariant();
            if (10 == variant.getVt() || 9 == variant.getVt()) {
                this.jsonGenerator.writeNumberField("v", (BigDecimal)value);
            } else {
                this.jsonGenerator.writeArrayFieldStart("v");
                this.jsonGenerator.writeNumber(variant.getVt());
                this.jsonGenerator.writeString(variant.toString());
                this.jsonGenerator.writeEndArray();
            }
        }
    }
}

