/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.template.spreadmanager.serializer;

import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonDeserializer;
import com.fasterxml.jackson.databind.JsonNode;
import java.io.IOException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.common.utils.StringUtils;
import kd.epm.eb.spread.template.spreadmanager.EbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.book.EBook;
import kd.epm.eb.spread.template.spreadmanager.serializer.ESheetDeSerializer;
import kd.epm.eb.spread.template.spreadmanager.sheet.ESheet;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;

public class EbSpreadManagerDeserializer
extends JsonDeserializer<EbSpreadManager> {
    private DeserializationContext deserializationContext;

    public EbSpreadManager deserialize(JsonParser jsonParser, DeserializationContext deserializationContext) throws IOException, JsonProcessingException {
        JsonNode memberDisplayType;
        JsonNode rowJsonNode;
        this.deserializationContext = deserializationContext;
        JsonNode node = (JsonNode)jsonParser.getCodec().readTree(jsonParser);
        EbSpreadManager ebSpreadManager = this.readSpreadManager(node);
        JsonNode colJsonNode = node.get("metricColIndex");
        if (colJsonNode != null) {
            ebSpreadManager.setMetricColIndex(colJsonNode.asInt());
        }
        if ((rowJsonNode = node.get("metricRowIndex")) != null) {
            ebSpreadManager.setMetricRowIndex(rowJsonNode.asInt());
        }
        if ((memberDisplayType = node.get("mdt")) != null) {
            ebSpreadManager.setDimMemDefaultDisplayType(memberDisplayType.asInt());
        }
        this.readBook(node, ebSpreadManager);
        ebSpreadManager.getDimemsionViews().putAll(this.readDimensionViews(node));
        return ebSpreadManager;
    }

    private void readBook(JsonNode node, IEbSpreadManager ebSpreadManager) {
        ESheetDeSerializer eSheetDeSerializer = new ESheetDeSerializer(this.deserializationContext);
        EBook eBook = new EBook(new String[0]);
        ebSpreadManager.setEbook(eBook);
        JsonNode bookeNode = node.get("book");
        if (bookeNode == null) {
            eBook.addSheet(new ESheet());
        } else {
            Iterator sheets = bookeNode.elements();
            while (sheets != null && sheets.hasNext()) {
                JsonNode sheetNode = (JsonNode)sheets.next();
                if (sheetNode == null) continue;
                ISheet sheet = eSheetDeSerializer.readSheet(sheetNode);
                eBook.addSheet(sheet);
            }
        }
    }

    private EbSpreadManager readSpreadManager(JsonNode node) {
        if (node == null || node.get("sm") == null) {
            return new EbSpreadManager();
        }
        String smStr = node.get("sm").asText();
        if (StringUtils.isNotEmpty((String)smStr)) {
            return (EbSpreadManager)ObjectSerialUtil.deSerializedBytes((String)smStr);
        }
        return new EbSpreadManager();
    }

    private Map<String, Long> readDimensionViews(JsonNode rootNode) {
        HashMap<String, Long> dimensionViews = new HashMap<String, Long>();
        JsonNode node = rootNode.get("dimemsionViews");
        if (node != null) {
            Iterator fields = node.fields();
            while (fields.hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                dimensionViews.put((String)field.getKey(), field.getValue() != null ? Long.parseLong(((JsonNode)field.getValue()).asText()) : 0L);
            }
        }
        return dimensionViews;
    }
}

