/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.template.spreadmanager.serializer;

import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonSerializer;
import com.fasterxml.jackson.databind.SerializerProvider;
import java.io.IOException;
import java.util.Map;
import kd.epm.eb.common.utils.ObjectSerialUtil;
import kd.epm.eb.spread.template.spreadmanager.EbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.IEbSpreadManager;
import kd.epm.eb.spread.template.spreadmanager.book.IEBook;
import kd.epm.eb.spread.template.spreadmanager.serializer.ESheetSerializer;

public class EbSpreadManagerSerializer
extends JsonSerializer<EbSpreadManager> {
    private JsonGenerator jsonGenerator;
    private ESheetSerializer eSheetSerializer = new ESheetSerializer();

    public void serialize(EbSpreadManager ebSpreadManager, JsonGenerator jsonGenerator, SerializerProvider serializerProvider) throws IOException, JsonProcessingException {
        Integer metricRowIndex;
        this.jsonGenerator = jsonGenerator;
        this.eSheetSerializer.setJsonGenerator(jsonGenerator);
        this.eSheetSerializer.setSerializerProvider(serializerProvider);
        jsonGenerator.writeStartObject();
        Integer metricColIndex = ebSpreadManager.getMetricColIndex();
        if (metricColIndex != null) {
            jsonGenerator.writeNumberField("metricColIndex", metricColIndex.intValue());
        }
        if ((metricRowIndex = ebSpreadManager.getMetricRowIndex()) != null) {
            jsonGenerator.writeNumberField("metricRowIndex", metricRowIndex.intValue());
        }
        jsonGenerator.writeNumberField("mdt", ebSpreadManager.getDimMemDefaultDisplayType());
        this.writeDimensionViews(ebSpreadManager.getDimemsionViews());
        this.writeSpreadManager(ebSpreadManager);
        this.writeBook(ebSpreadManager.getEbook());
        jsonGenerator.writeEndObject();
    }

    private void writeBook(IEBook ebook) throws IOException {
        this.jsonGenerator.writeArrayFieldStart("book");
        int j = ebook.getSheetCount();
        for (int i = 0; i < j; ++i) {
            this.jsonGenerator.writeStartObject();
            this.eSheetSerializer.serialize(ebook.getSheet(0));
            this.jsonGenerator.writeEndObject();
        }
        this.jsonGenerator.writeEndArray();
    }

    private void writeDimensionViews(Map<String, Long> dimensionViews) throws IOException {
        if (dimensionViews != null && !dimensionViews.isEmpty()) {
            this.jsonGenerator.writeObjectFieldStart("dimemsionViews");
            for (Map.Entry<String, Long> dimView : dimensionViews.entrySet()) {
                if (dimView == null) continue;
                this.jsonGenerator.writeStringField(dimView.getKey(), String.valueOf(dimView.getValue()));
            }
            this.jsonGenerator.writeEndObject();
        }
    }

    private void writeSpreadManager(IEbSpreadManager ebSpreadManager) throws IOException {
        IEBook book = ebSpreadManager.getEbook();
        ebSpreadManager.setEbook(null);
        this.jsonGenerator.writeStringField("sm", ObjectSerialUtil.toByteSerialized((Object)ebSpreadManager));
        ebSpreadManager.setEbook(book);
    }
}

