/*
 * Decompiled with CFR 0.152.
 */
package kd.epm.eb.spread.template.spreadmanager.serializer.afix;

import com.fasterxml.jackson.databind.DeserializationContext;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.node.NullNode;
import java.io.IOException;
import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import kd.bos.dataentity.serialization.SerializationUtils;
import kd.epm.eb.common.dimension.property.PropertyObj;
import kd.epm.eb.common.reportprocess.entity.dto.FixReportRowSeqDto;
import kd.epm.eb.common.utils.RangeModel;
import kd.epm.eb.spread.template.afix.multimanager.MultiAreaManager;
import kd.epm.eb.spread.template.afix.serializer.FixSerializerCommonUtils;
import kd.epm.eb.spread.template.dimension.PageViewDimMember;
import kd.epm.eb.spread.template.headerarea.HeaderInfo;
import kd.epm.eb.spread.template.headerarea.IHeaderInfo;
import kd.epm.eb.spread.template.spreadmanager.CellDimMember;
import kd.epm.eb.spread.template.spreadmanager.MetricCellDimMember;
import kd.epm.eb.spread.template.spreadmanager.list.SPArrayList;
import kd.epm.eb.spread.template.spreadmanager.serializer.ESheetDeSerializer;
import kd.epm.eb.spread.template.spreadmanager.sheet.ISheet;

public class FixMulAreaManagerDeserializer {
    private DeserializationContext deserializationContext;

    public MultiAreaManager deserialize(JsonNode rootNode, DeserializationContext deserializationContext) throws IOException {
        this.deserializationContext = deserializationContext;
        MultiAreaManager multiAreaManager = new MultiAreaManager();
        multiAreaManager.setAreaRange(this.readRangeModel(rootNode));
        JsonNode jsonNode = rootNode.get("startpoint");
        if (jsonNode != null) {
            multiAreaManager.setStartpoint(jsonNode.asText());
        }
        if ((jsonNode = rootNode.get("areaIndex")) != null) {
            multiAreaManager.setAreaIndex(jsonNode.asText());
        }
        multiAreaManager.getAreaPageViewDims().putAll(this.readAPVDims(rootNode));
        multiAreaManager.getColpartitionDimMems().addAll(this.readPartitionDimMembs(rootNode, "colMembs"));
        multiAreaManager.getRowpartitionDimMems().addAll(this.readPartitionDimMembs(rootNode, "rowMembs"));
        multiAreaManager.getRowpartitionDims().addAll(this.readStringCollection(rootNode, "rowdims", false));
        multiAreaManager.getColpartitionDims().addAll(this.readStringCollection(rootNode, "coldims", false));
        jsonNode = rootNode.get("rowheaders");
        if (jsonNode != null) {
            multiAreaManager.setRowHeaders(this.readHeaderInfo((List)SerializationUtils.fromJsonString((String)jsonNode.asText(), List.class)));
        }
        if ((jsonNode = rootNode.get("colheaders")) != null) {
            multiAreaManager.setColHeaders(this.readHeaderInfo((List)SerializationUtils.fromJsonString((String)jsonNode.asText(), List.class)));
        }
        if ((jsonNode = rootNode.get("seqDto")) != null) {
            multiAreaManager.setFixReportRowSeqDto((FixReportRowSeqDto)SerializationUtils.fromJsonString((String)jsonNode.asText(), FixReportRowSeqDto.class));
        }
        multiAreaManager.getToDeleteData().addAll(this.readStringCollection(rootNode, "delData", true));
        multiAreaManager.getUpdatedData().addAll(this.readStringCollection(rootNode, "uptData", true));
        jsonNode = rootNode.get("floatOnWhere");
        if (jsonNode != null) {
            multiAreaManager.setFloatonWhere(jsonNode.asInt());
        }
        multiAreaManager.setData(this.readAreaDataInfo(rootNode, multiAreaManager));
        multiAreaManager.setData(this.readAreaDataInfo(rootNode, multiAreaManager));
        this.setDimPropertys(multiAreaManager, rootNode.get("DimPropertys"));
        jsonNode = rootNode.get("userStyle");
        if (jsonNode != null) {
            multiAreaManager.setUserStyle(jsonNode.asBoolean());
        }
        if ((jsonNode = rootNode.get("hasCellHyperLinkInfo")) != null) {
            multiAreaManager.setHasCellHyperLinkInfo(jsonNode.asBoolean());
        }
        return multiAreaManager;
    }

    private void setDimPropertys(MultiAreaManager multiAreaManager, JsonNode propertyNode) {
        HashMap<String, List<PropertyObj>> propertys = new HashMap();
        propertys = FixSerializerCommonUtils.getDimPropertys(propertyNode);
        multiAreaManager.setDimPropertys(propertys);
    }

    private MultiAreaManager.AreaDataInfo readAreaDataInfo(JsonNode rootNode, MultiAreaManager multiAreaManager) {
        MultiAreaManager.AreaDataInfo dataInfo = null;
        JsonNode dataInfoNode = rootNode.get("areaData");
        if (dataInfoNode != null) {
            ESheetDeSerializer eSheetDeSerializer = new ESheetDeSerializer(this.deserializationContext);
            ISheet eSheet = eSheetDeSerializer.readSheet(dataInfoNode);
            MultiAreaManager multiAreaManager2 = multiAreaManager;
            multiAreaManager2.getClass();
            dataInfo = new MultiAreaManager.AreaDataInfo(multiAreaManager2, eSheet);
        }
        return dataInfo;
    }

    public RangeModel readRangeModel(JsonNode rootNode) {
        JsonNode rangeNode = rootNode.get("areaRange");
        RangeModel rangeModel = null;
        if (rangeNode != null) {
            int s_x = rangeNode.get("pos_sx").asInt();
            int s_y = rangeNode.get("pos_ex").asInt();
            int e_x = rangeNode.get("pos_sy").asInt();
            int e_y = rangeNode.get("pos_ey").asInt();
            rangeModel = new RangeModel(s_x, s_y, e_x, e_y);
        }
        return rangeModel;
    }

    public List<List<CellDimMember>> readPartitionDimMembs(JsonNode rootNode, String fieldKey) {
        SPArrayList<List<CellDimMember>> dimMembs = new SPArrayList<List<CellDimMember>>();
        SPArrayList<CellDimMember> membs = null;
        JsonNode colPartNode = rootNode.get(fieldKey);
        CellDimMember cellMemb = null;
        if (colPartNode != null) {
            Iterator listNodes = colPartNode.elements();
            while (listNodes.hasNext()) {
                JsonNode listNode = (JsonNode)listNodes.next();
                membs = new SPArrayList<CellDimMember>();
                Iterator membNodes = listNode.elements();
                while (membNodes.hasNext()) {
                    JsonNode membNode = (JsonNode)membNodes.next();
                    if (membNode.get("number") == null) {
                        membs.add(null);
                        continue;
                    }
                    if (membNode.get("isMetric") != null && membNode.get("isMetric").asBoolean()) {
                        JsonNode jsonNode = membNode.get("leaf");
                        cellMemb = new MetricCellDimMember(jsonNode == null ? false : jsonNode.asBoolean(), membNode.get("number").asText());
                        cellMemb.setMetric(true);
                        JsonNode node = membNode.get("datatype");
                        ((MetricCellDimMember)cellMemb).setDatatype(node == null ? null : Integer.valueOf(node.asInt()));
                        node = membNode.get("decimalnum");
                        ((MetricCellDimMember)cellMemb).setDecimalnum(node == null || node instanceof NullNode ? null : node.asText());
                        node = membNode.get("sign");
                        ((MetricCellDimMember)cellMemb).setSign(node == null || node instanceof NullNode ? null : node.asText());
                    } else {
                        cellMemb = new CellDimMember(membNode.get("number").asText());
                        if (membNode.get("leaf") != null) {
                            cellMemb.setIsleaf(membNode.get("leaf").asBoolean());
                        }
                    }
                    if (membNode.get("isProperty") != null) {
                        cellMemb.setProperty(membNode.get("isProperty").asBoolean());
                    }
                    if (membNode.get("format") != null) {
                        cellMemb.setFormat(membNode.get("format").asText());
                    }
                    if (membNode.get("suffix") != null) {
                        cellMemb.setSuffix(membNode.get("suffix").asText());
                    }
                    if (membNode.get("prefix") != null) {
                        cellMemb.setPrefix(membNode.get("prefix").asText());
                    }
                    membs.add(cellMemb);
                }
                dimMembs.add(membs);
            }
        }
        return dimMembs;
    }

    public Collection<String> readStringCollection(JsonNode rootNode, String fieldKey, boolean isSet) {
        HashSet<String> collection;
        JsonNode node = rootNode.get(fieldKey);
        AbstractCollection abstractCollection = collection = isSet ? new HashSet() : new SPArrayList();
        if (node != null) {
            Iterator list = node.elements();
            while (list.hasNext()) {
                collection.add(((JsonNode)list.next()).textValue());
            }
        }
        return collection;
    }

    private Map<String, PageViewDimMember> readAPVDims(JsonNode rootNode) {
        HashMap<String, PageViewDimMember> pvDims = new HashMap<String, PageViewDimMember>();
        JsonNode node = rootNode.get("APVDimMembs");
        Object membNums = null;
        if (node != null) {
            Iterator fields = node.fields();
            PageViewDimMember dimMember = null;
            while (fields.hasNext()) {
                Map.Entry field = (Map.Entry)fields.next();
                JsonNode memb = (JsonNode)field.getValue();
                if (memb != null) {
                    dimMember = new PageViewDimMember(memb.get("number").asText(), memb.get("leaf").asBoolean());
                }
                pvDims.put((String)field.getKey(), dimMember);
            }
        }
        return pvDims;
    }

    private List<IHeaderInfo> readHeaderInfo(List<Map<String, Object>> listOfMaps) {
        if (listOfMaps != null) {
            ArrayList<IHeaderInfo> headerInfos = new ArrayList<IHeaderInfo>(listOfMaps.size());
            for (int i = 0; i < listOfMaps.size(); ++i) {
                Map<String, Object> map = listOfMaps.get(i);
                if (map == null) continue;
                String type = map.get("type") == null ? null : String.valueOf(map.get("type"));
                String number = map.get("number") == null ? null : String.valueOf(map.get("number"));
                String refDimension = map.get("refDimension") == null ? null : String.valueOf(map.get("refDimension"));
                HeaderInfo headerInfo = new HeaderInfo(type, number, refDimension);
                headerInfos.add(headerInfo);
            }
            return headerInfos;
        }
        return null;
    }
}

